/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import kafka.cluster.BrokerEndPoint;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.FollowerThrottler;
import kafka.server.KafkaConfig;
import kafka.server.LeaderEndPoint;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.RequestBuilder;
import kafka.server.TierMaterializationRequirements;
import kafka.server.TierOffsetInfo;
import kafka.server.TierOffsetInfo$;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0005a\u0001B\u000e\u001d\u0001\u0005B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!I!\t\u0001BC\u0002\u0013\u0005Ad\u0011\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005\t\"I\u0001\u000b\u0001BC\u0002\u0013\u0005A$\u0015\u0005\t+\u0002\u0011\t\u0011)A\u0005%\"Aa\u000b\u0001B\u0001B\u0003%q\u000b\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003\\\u0011!q\u0006A!A!\u0002\u0013y\u0006\u0002\u00032\u0001\u0005\u0003\u0005\u000b\u0011B2\t\u0011\u0019\u0004!\u0011!Q\u0001\n\u001dDQ!\u001d\u0001\u0005\u0002IDq! \u0001C\u0002\u0013%a\u0010C\u0004\u0002\u0010\u0001\u0001\u000b\u0011B@\t\u000f\u0005E\u0001\u0001\"\u0011\u0002\u0014!9\u00111\u0004\u0001\u0005B\u0005u\u0001bBA\u0013\u0001\u0011\u0005\u0013Q\u0004\u0005\b\u0003O\u0001A\u0011IA\u0015\u0011\u001d\t9\u0004\u0001C!\u0003sAq!!\u001d\u0001\t\u0003\n\u0019\bC\u0004\u0002\n\u0002!\t%a#\t\u000f\u0005]\u0005\u0001\"\u0011\u0002\u001a\"9\u0011q\u0014\u0001\u0005\n\u0005\u0005\u0006bBAV\u0001\u0011\u0005\u0013Q\u0016\u0005\b\u0003#\u0004A\u0011IAj\u0011\u001d\tI\u0010\u0001C!\u0003w\u0014ACU3n_R,G*Z1eKJ,e\u000e\u001a)pS:$(BA\u000f\u001f\u0003\u0019\u0019XM\u001d<fe*\tq$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001\u0011\u0003\u0006\f\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005%RS\"\u0001\u000f\n\u0005-b\"A\u0004'fC\u0012,'/\u00128e!>Lg\u000e\u001e\t\u0003[Aj\u0011A\f\u0006\u0003_y\tQ!\u001e;jYNL!!\r\u0018\u0003\u000f1{wmZ5oO\u0006IAn\\4Qe\u00164\u0017\u000e\u001f\t\u0003imr!!N\u001d\u0011\u0005Y\"S\"A\u001c\u000b\u0005a\u0002\u0013A\u0002\u001fs_>$h(\u0003\u0002;I\u00051\u0001K]3eK\u001aL!\u0001P\u001f\u0003\rM#(/\u001b8h\u0015\tQD%\u0001\bcY>\u001c7.\u001b8h'\u0016tG-\u001a:\u0011\u0005%\u0002\u0015BA!\u001d\u00051\u0011En\\2lS:<7+\u001a8e\u0003M1W\r^2i'\u0016\u001c8/[8o\u0011\u0006tG\r\\3s+\u0005!\u0005CA#N\u001b\u00051%BA$I\u0003\u001d\u0019G.[3oiNT!aH%\u000b\u0005)[\u0015AB1qC\u000eDWMC\u0001M\u0003\ry'oZ\u0005\u0003\u001d\u001a\u00131CR3uG\"\u001cVm]:j_:D\u0015M\u001c3mKJ\fACZ3uG\"\u001cVm]:j_:D\u0015M\u001c3mKJ\u0004\u0013A\u0004:fcV,7\u000f\u001e\"vS2$WM]\u000b\u0002%B\u0011\u0011fU\u0005\u0003)r\u0011aBU3rk\u0016\u001cHOQ;jY\u0012,'/A\bsKF,Xm\u001d;Ck&dG-\u001a:!\u0003%!\bN]8ui2,'\u000f\u0005\u0002*1&\u0011\u0011\f\b\u0002\u0012\r>dGn\\<feRC'o\u001c;uY\u0016\u0014\u0018\u0001\u00042s_.,'oQ8oM&<\u0007CA\u0015]\u0013\tiFDA\u0006LC\u001a\\\u0017mQ8oM&<\u0017A\u0004:fa2L7-Y'b]\u0006<WM\u001d\t\u0003S\u0001L!!\u0019\u000f\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006)\u0011/^8uCB\u0011\u0011\u0006Z\u0005\u0003Kr\u0011ABU3qY&\u001c\u0017-U;pi\u0006\fq#\\3uC\u0012\fG/\u0019,feNLwN\\*vaBd\u0017.\u001a:\u0011\u0007\rB'.\u0003\u0002jI\tIa)\u001e8di&|g\u000e\r\t\u0003W>l\u0011\u0001\u001c\u0006\u0003[:\faaY8n[>t'BA\u000fI\u0013\t\u0001HNA\bNKR\fG-\u0019;b-\u0016\u00148/[8o\u0003\u0019a\u0014N\\5u}QQ1\u000f^;wobL(p\u001f?\u0011\u0005%\u0002\u0001\"\u0002\u001a\r\u0001\u0004\u0019\u0004\"\u0002 \r\u0001\u0004y\u0004\"\u0002\"\r\u0001\u0004!\u0005\"\u0002)\r\u0001\u0004\u0011\u0006\"\u0002,\r\u0001\u00049\u0006\"\u0002.\r\u0001\u0004Y\u0006\"\u00020\r\u0001\u0004y\u0006\"\u00022\r\u0001\u0004\u0019\u0007\"\u00024\r\u0001\u00049\u0017!\u00034fi\u000eD7+\u001b>f+\u0005y\b\u0003BA\u0001\u0003\u0017i!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\u0005Y\u0006twM\u0003\u0002\u0002\n\u0005!!.\u0019<b\u0013\u0011\ti!a\u0001\u0003\u000f%sG/Z4fe\u0006Qa-\u001a;dQNK'0\u001a\u0011\u00029%\u001cHK];oG\u0006$\u0018n\u001c8P]\u001a+Go\u00195TkB\u0004xN\u001d;fIV\u0011\u0011Q\u0003\t\u0004G\u0005]\u0011bAA\rI\t9!i\\8mK\u0006t\u0017!D5oSRL\u0017\r^3DY>\u001cX\r\u0006\u0002\u0002 A\u00191%!\t\n\u0007\u0005\rBE\u0001\u0003V]&$\u0018!B2m_N,\u0017A\u00042s_.,'/\u00128e!>Lg\u000e\u001e\u000b\u0003\u0003W\u0001B!!\f\u000245\u0011\u0011q\u0006\u0006\u0004\u0003cq\u0012aB2mkN$XM]\u0005\u0005\u0003k\tyC\u0001\bCe>\\WM]#oIB{\u0017N\u001c;\u0002\u000b\u0019,Go\u00195\u0015\t\u0005m\u0012\u0011\f\t\t\u0003{\t\u0019%a\u0012\u0002R5\u0011\u0011q\b\u0006\u0004\u0003\u0003\"\u0013AC2pY2,7\r^5p]&!\u0011QIA \u0005\ri\u0015\r\u001d\t\u0005\u0003\u0013\ni%\u0004\u0002\u0002L)\u0011Q\u000eS\u0005\u0005\u0003\u001f\nYE\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0005M\u0013QK\u0007\u0002\u0001%\u0019\u0011q\u000b\u0016\u0003\u0013\u0019+Go\u00195ECR\f\u0007bBA.'\u0001\u0007\u0011QL\u0001\rM\u0016$8\r\u001b*fcV,7\u000f\u001e\t\u0005\u0003?\nYG\u0004\u0003\u0002b\u0005\u001dTBAA2\u0015\u0011\t)'a\u0013\u0002\u0011I,\u0017/^3tiNLA!!\u001b\u0002d\u0005aa)\u001a;dQJ+\u0017/^3ti&!\u0011QNA8\u0005\u001d\u0011U/\u001b7eKJTA!!\u001b\u0002d\u0005\u0019b-\u001a;dQ\u0016\u000b'\u000f\\5fgR|eMZ:fiR1\u0011QOA>\u0003\u007f\u00022aIA<\u0013\r\tI\b\n\u0002\u0005\u0019>tw\rC\u0004\u0002~Q\u0001\r!a\u0012\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\"9\u0011\u0011\u0011\u000bA\u0002\u0005\r\u0015AE2veJ,g\u000e\u001e'fC\u0012,'/\u00129pG\"\u00042aIAC\u0013\r\t9\t\n\u0002\u0004\u0013:$\u0018A\b4fi\u000eDG+[3s\u001b\u0006$XM]5bY&T\u0018\r^5p]R\u000b'oZ3u)\u0019\ti)a%\u0002\u0016B\u0019\u0011&a$\n\u0007\u0005EED\u0001\bUS\u0016\u0014xJ\u001a4tKRLeNZ8\t\u000f\u0005uT\u00031\u0001\u0002H!9\u0011\u0011Q\u000bA\u0002\u0005\r\u0015!\u00054fi\u000eDG*\u0019;fgR|eMZ:fiR1\u0011QOAN\u0003;Cq!! \u0017\u0001\u0004\t9\u0005C\u0004\u0002\u0002Z\u0001\r!a!\u0002\u0017\u0019,Go\u00195PM\u001a\u001cX\r\u001e\u000b\t\u0003\u001b\u000b\u0019+!*\u0002(\"9\u0011QP\fA\u0002\u0005\u001d\u0003bBAA/\u0001\u0007\u00111\u0011\u0005\b\u0003S;\u0002\u0019AA;\u0003%!\u0018.\\3ti\u0006l\u0007/\u0001\u000bgKR\u001c\u0007.\u00129pG\",e\u000eZ(gMN,Go\u001d\u000b\u0005\u0003_\u000b)\r\u0005\u0005\u0002>\u0005\r\u0013qIAY!\u0011\t\u0019,a0\u000f\t\u0005U\u00161X\u0007\u0003\u0003oSA!!/\u0002L\u00059Q.Z:tC\u001e,\u0017\u0002BA_\u0003o\u000b\u0001e\u00144gg\u0016$hi\u001c:MK\u0006$WM]#q_\u000eD'+Z:q_:\u001cX\rR1uC&!\u0011\u0011YAb\u00059)\u0005o\\2i\u000b:$wJ\u001a4tKRTA!!0\u00028\"9\u0011q\u0019\rA\u0002\u0005%\u0017A\u00039beRLG/[8ogBA\u0011QHA\"\u0003\u000f\nY\r\u0005\u0003\u0002T\u00055\u0017bAAhU\tIQ\t]8dQ\u0012\u000bG/Y\u0001\u000bEVLG\u000e\u001a$fi\u000eDG\u0003BAk\u0003_\u0004b!a6\u0002^\u0006\rhbA\u0015\u0002Z&\u0019\u00111\u001c\u000f\u0002+\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bI&!\u0011q\\Aq\u0005Q\u0011Vm];mi^KG\u000f\u001b)beRLG/[8og*\u0019\u00111\u001c\u000f\u0011\u000b\r\n)/!;\n\u0007\u0005\u001dHE\u0001\u0004PaRLwN\u001c\t\u0005\u0003/\fY/\u0003\u0003\u0002n\u0006\u0005(\u0001\u0004*fa2L7-\u0019$fi\u000eD\u0007bBAd3\u0001\u0007\u0011\u0011\u001f\t\t\u0003{\t\u0019%a\u0012\u0002tB\u0019\u0011&!>\n\u0007\u0005]HDA\nQCJ$\u0018\u000e^5p]\u001a+Go\u00195Ti\u0006$X-A\bjgJ+\u0017\rZ=G_J4U\r^2i)\u0011\t)\"!@\t\u000f\u0005}(\u00041\u0001\u0002H\u0005\u0011A\u000f\u001d")
public class RemoteLeaderEndPoint
implements LeaderEndPoint,
Logging {
    private final BlockingSend blockingSender;
    private final FetchSessionHandler fetchSessionHandler;
    private final RequestBuilder requestBuilder;
    private final FollowerThrottler throttler;
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaManager;
    private final ReplicaQuota quota;
    private final Function0<MetadataVersion> metadataVersionSupplier;
    private final Integer fetchSize;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public FetchSessionHandler fetchSessionHandler() {
        return this.fetchSessionHandler;
    }

    public RequestBuilder requestBuilder() {
        return this.requestBuilder;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    @Override
    public boolean isTruncationOnFetchSupported() {
        return ((MetadataVersion)this.metadataVersionSupplier.apply()).isTruncationOnFetchSupported();
    }

    @Override
    public void initiateClose() {
        this.blockingSender.initiateClose();
    }

    @Override
    public void close() {
        this.blockingSender.close();
    }

    @Override
    public BrokerEndPoint brokerEndPoint() {
        return this.blockingSender.brokerEndPoint();
    }

    @Override
    public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
        ClientResponse clientResponse;
        try {
            clientResponse = this.blockingSender.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)fetchRequest);
        }
        catch (Throwable t) {
            this.fetchSessionHandler().handleError(t);
            throw t;
        }
        ClientResponse clientResponse2 = clientResponse;
        FetchResponse fetchResponse = (FetchResponse)clientResponse2.responseBody();
        if (!this.fetchSessionHandler().handleResponse(fetchResponse, clientResponse2.requestHeader().apiVersion())) {
            Errors errors = fetchResponse.error();
            Errors errors2 = Errors.FETCH_SESSION_TOPIC_ID_ERROR;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                throw Errors.forCode((short)fetchResponse.error().code()).exception();
            }
            return scala.collection.Map$.MODULE$.empty();
        }
        return (Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)fetchResponse.responseData(this.fetchSessionHandler().sessionTopicNames(), clientResponse2.requestHeader().apiVersion())).asScala();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long fetchEarliestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        void var4_4;
        void var6_5;
        TierOffsetInfo tierOffsetInfo = this.fetchOffset(topicPartition, currentLeaderEpoch, -2L);
        if (tierOffsetInfo == null) {
            throw new MatchError(null);
        }
        long localLogStartOffset = tierOffsetInfo.localLogStartOffset();
        Option<TierMaterializationRequirements> tierRestorePoint = tierOffsetInfo.tierRestorePoint();
        if (var6_5.isDefined()) {
            throw new IllegalStateException("Tier restore point returned for earliest timestamp fetch");
        }
        return (long)var4_4;
    }

    @Override
    public TierOffsetInfo fetchTierMaterializationTarget(TopicPartition topicPartition, int currentLeaderEpoch) {
        if (Predef$.MODULE$.Boolean2boolean(this.brokerConfig.confluentConfig().tierFeature())) {
            return this.fetchOffset(topicPartition, currentLeaderEpoch, -10000L);
        }
        throw new IllegalStateException("Incompatible configuration for tiered storage");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long fetchLatestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        void var4_4;
        void var6_5;
        TierOffsetInfo tierOffsetInfo = this.fetchOffset(topicPartition, currentLeaderEpoch, -1L);
        if (tierOffsetInfo == null) {
            throw new MatchError(null);
        }
        long localLogStartOffset = tierOffsetInfo.localLogStartOffset();
        Option<TierMaterializationRequirements> tierRestorePoint = tierOffsetInfo.tierRestorePoint();
        if (var6_5.isDefined()) {
            throw new IllegalStateException("Tier restore point returned for latest timestamp fetch");
        }
        return (long)var4_4;
    }

    private TierOffsetInfo fetchOffset(TopicPartition topicPartition, int currentLeaderEpoch, long timestamp) {
        ListOffsetsRequestData.ListOffsetsTopic topic = new ListOffsetsRequestData.ListOffsetsTopic().setName(topicPartition.topic()).setPartitions(Collections.singletonList(new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(topicPartition.partition()).setCurrentLeaderEpoch(currentLeaderEpoch).setTimestamp(timestamp)));
        ListOffsetsRequest.Builder listOffsetRequest = this.requestBuilder().buildListOffsetRequest(topic);
        ListOffsetsResponse response = (ListOffsetsResponse)this.blockingSender.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)listOffsetRequest).responseBody();
        ListOffsetsResponseData.ListOffsetsPartitionResponse responsePartition = (ListOffsetsResponseData.ListOffsetsPartitionResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((ListOffsetsResponseData.ListOffsetsTopicResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(response.topics()).asScala()).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)RemoteLeaderEndPoint.$anonfun$fetchOffset$1(topicPartition, x$3))).get()).partitions()).asScala()).find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)RemoteLeaderEndPoint.$anonfun$fetchOffset$2(topicPartition, x$4))).get();
        Errors errors = Errors.forCode((short)responsePartition.errorCode());
        if (Errors.NONE.equals(errors)) {
        } else {
            throw errors.exception();
        }
        TierOffsetInfo tierOffsetInfo = ((MetadataVersion)this.metadataVersionSupplier.apply()).isAtLeast(MetadataVersion.IBP_0_10_1_IV2) ? (responsePartition.followerRestorePointObjectId() != null && !responsePartition.followerRestorePointObjectId().equals((Object)Uuid.ZERO_UUID) ? TierOffsetInfo$.MODULE$.apply(responsePartition.offset(), CoreUtils$.MODULE$.toJavaUUID(responsePartition.followerRestorePointObjectId()), responsePartition.followerRestorePointEpoch()) : TierOffsetInfo$.MODULE$.apply(responsePartition.offset())) : TierOffsetInfo$.MODULE$.apply(Predef$.MODULE$.Long2long((Long)responsePartition.oldStyleOffsets().get(0)));
        return tierOffsetInfo;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        if (partitions.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Skipping leaderEpoch request since all partitions do not have an epoch");
            return scala.collection.Map$.MODULE$.empty();
        }
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection topics = new OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection(partitions.size());
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, epochData) -> BoxesRunTime.boxToBoolean((boolean)RemoteLeaderEndPoint.$anonfun$fetchEpochEndOffsets$2(topics, topicPartition, epochData));
        Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> map = Implicits$.MODULE$.MapExtensionMethods(partitions);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        OffsetsForLeaderEpochRequest.Builder epochRequest = this.requestBuilder().buildOffsetsForLeaderEpochRequest(topics);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Sending offset for leader epoch request ").append(epochRequest).toString());
        try {
            ClientResponse response = this.blockingSender.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)epochRequest);
            OffsetsForLeaderEpochResponse responseBody = (OffsetsForLeaderEpochResponse)response.responseBody();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Received leaderEpoch response ").append(response).toString());
            return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)responseBody.data().topics()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)offsetForLeaderTopicResult -> (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(offsetForLeaderTopicResult.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)offsetForLeaderPartitionResult -> {
                TopicPartition tp = new TopicPartition(offsetForLeaderTopicResult.topic(), offsetForLeaderPartitionResult.partition());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), offsetForLeaderPartitionResult);
            }, Buffer$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        catch (Throwable t) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Error when sending leader epoch request for ").append(partitions).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            Errors error = Errors.forException((Throwable)t);
            return (Map)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                TopicPartition tp = (TopicPartition)x0$1._1();
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(error.code()));
                return tuple2;
            }, scala.collection.Map$.MODULE$.canBuildFrom());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitions) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        scala.collection.mutable.Map partitionsWithError = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        FetchSessionHandler.Builder builder = this.fetchSessionHandler().newBuilder(partitions.size(), false);
        boolean lowDiskThrottle = this.throttler.shouldThrottleDueToLowDisk(this.quota);
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, fetchState) -> {
            if (fetchState.isReadyForFetch() && this.isReadyForFetch((TopicPartition)topicPartition)) {
                if (lowDiskThrottle || $this.throttler.shouldThrottle($this.quota, (PartitionFetchState)fetchState, (TopicPartition)topicPartition)) {
                    $this.throttler.markReplicaThrottle($this.replicaManager);
                    return BoxedUnit.UNIT;
                }
                try {
                    long logStartOffset = $this.replicaManager.localLogOrException((TopicPartition)topicPartition).logStartOffset();
                    Optional lastFetchedEpoch = this.isTruncationOnFetchSupported() ? OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(fetchState.lastFetchedEpoch().map((Function1 & Serializable & scala.Serializable)x$5 -> RemoteLeaderEndPoint.$anonfun$buildFetch$2(BoxesRunTime.unboxToInt((Object)x$5))))) : Optional.empty();
                    builder.add(topicPartition, new FetchRequest.PartitionData((Uuid)fetchState.topicId().getOrElse((Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID), fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch())), lastFetchedEpoch));
                    return BoxedUnit.UNIT;
                }
                catch (KafkaStorageException kafkaStorageException) {
                    return partitionsWithError.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicPartition), (Object)Errors.KAFKA_STORAGE_ERROR));
                }
            }
            return BoxedUnit.UNIT;
        };
        Map<TopicPartition, PartitionFetchState> map = Implicits$.MODULE$.MapExtensionMethods(partitions);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        FetchSessionHandler.FetchRequestData fetchData = builder.build();
        Some fetchRequestOpt = fetchData.sessionPartitions().isEmpty() && fetchData.toForget().isEmpty() ? None$.MODULE$ : new Some((Object)new AbstractFetcherThread.ReplicaFetch(fetchData.sessionPartitions(), this.requestBuilder().buildFetchRequest(fetchData)));
        return new AbstractFetcherThread.ResultWithPartitions<Some>(fetchRequestOpt, (Map<TopicPartition, Errors>)partitionsWithError);
    }

    @Override
    public boolean isReadyForFetch(TopicPartition tp) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffset$1(TopicPartition topicPartition$1, ListOffsetsResponseData.ListOffsetsTopicResponse x$3) {
        String string = x$3.name();
        String string2 = topicPartition$1.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffset$2(TopicPartition topicPartition$1, ListOffsetsResponseData.ListOffsetsPartitionResponse x$4) {
        return x$4.partitionIndex() == topicPartition$1.partition();
    }

    public static final /* synthetic */ boolean $anonfun$fetchEpochEndOffsets$2(OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection topics$1, TopicPartition topicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition epochData) {
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopic topic = topics$1.find(topicPartition.topic());
        if (topic == null) {
            topic = new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic().setTopic(topicPartition.topic());
            topics$1.add((ImplicitLinkedHashCollection.Element)topic);
        }
        return topic.partitions().add(epochData);
    }

    public static final /* synthetic */ Integer $anonfun$buildFetch$2(int x$5) {
        return BoxesRunTime.boxToInteger((int)x$5);
    }

    public RemoteLeaderEndPoint(String logPrefix, BlockingSend blockingSender, FetchSessionHandler fetchSessionHandler, RequestBuilder requestBuilder, FollowerThrottler throttler, KafkaConfig brokerConfig, ReplicaManager replicaManager, ReplicaQuota quota, Function0<MetadataVersion> metadataVersionSupplier) {
        this.blockingSender = blockingSender;
        this.fetchSessionHandler = fetchSessionHandler;
        this.requestBuilder = requestBuilder;
        this.throttler = throttler;
        this.brokerConfig = brokerConfig;
        this.replicaManager = replicaManager;
        this.quota = quota;
        this.metadataVersionSupplier = metadataVersionSupplier;
        Logging.$init$(this);
        this.logIdent_$eq(logPrefix);
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
    }
}

