/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kafka.controller.ClusterBalanceManager;
import kafka.metrics.KafkaMetricsReporter$;
import kafka.raft.KafkaRaftManager;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.server.KafkaRaftServer$BrokerRole$;
import kafka.server.KafkaRaftServer$ControllerRole$;
import kafka.server.MetaProperties;
import kafka.server.Server;
import kafka.server.Server$;
import kafka.server.metadata.BrokerServerMetrics;
import kafka.server.metadata.BrokerServerMetrics$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Mx4jLoader$;
import kafka.utils.VerifiableProperties$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.ControllerMetrics;
import org.apache.kafka.controller.QuorumControllerMetrics;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.LoggingFaultHandler;
import org.apache.kafka.server.fault.ProcessExitingFaultHandler;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u001df\u0001\u0002!B\u0001\u0019C\u0001b\u0016\u0001\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\t7\u0002\u0011\t\u0011)A\u00059\"A\u0001\u000e\u0001B\u0001B\u0003%\u0011\u000eC\u0003x\u0001\u0011\u0005\u0001\u0010\u0003\u0006~\u0001A\u0005\t1!Q\u0001\nyD\u0011\"!\n\u0001\u0005\u0004%I!a\n\t\u0011\u0005%\u0002\u0001)A\u0005\u0003\u0007A\u0011\"a\u000b\u0001\u0005\u0004%I!!\f\t\u0011\u0005=\u0002\u0001)A\u0005\u0003\u0013A\u0011\"!\r\u0001\u0005\u0004%I!a\r\t\u0011\u0005U\u0002\u0001)A\u0005\u00033A\u0011\"a\u000e\u0001\u0005\u0004%I!!\u000f\t\u0011\u0005\u0015\u0003\u0001)A\u0005\u0003wA\u0011\"a\u0012\u0001\u0005\u0004%\t!!\u0013\t\u0011\u0005m\u0003\u0001)A\u0005\u0003\u0017B\u0011\"!\u0018\u0001\u0005\u0004%I!a\u0018\t\u0011\u0005u\u0005\u0001)A\u0005\u0003CB\u0011\"a(\u0001\u0005\u0004%I!!)\t\u0011\u0005]\u0006\u0001)A\u0005\u0003GC\u0011\"!/\u0001\u0005\u0004%\t!a/\t\u0011\u0005-\u0007\u0001)A\u0005\u0003{C\u0011\"!4\u0001\u0005\u0004%I!a4\t\u0011\u0005e\u0007\u0001)A\u0005\u0003#D\u0011\"!2\u0001\u0005\u0004%I!a7\t\u0011\u0005\u0015\b\u0001)A\u0005\u0003;Dq!a:\u0001\t\u0003\nI\u000fC\u0004\u0002r\u0002!\t%!;\t\u000f\u0005M\b\u0001\"\u0011\u0002j\u001e9\u0011Q_!\t\u0002\u0005]hA\u0002!B\u0011\u0003\tI\u0010\u0003\u0004x=\u0011\u0005\u00111 \u0005\n\u0003{t\"\u0019!C\u0001\u0003\u007fD\u0001B!\u0002\u001fA\u0003%!\u0011\u0001\u0005\n\u0005\u000fq\"\u0019!C\u0001\u0005\u0013A\u0001Ba\u0005\u001fA\u0003%!1\u0002\u0005\n\u0005+q\"\u0019!C\u0001\u0005/A\u0001Ba\b\u001fA\u0003%!\u0011\u0004\u0004\n\u0005Cq\u0002\u0013aI\u0011\u0005G9qAa$\u001f\u0011\u0003\u0013iDB\u0004\u0003(yA\tI!\u000b\t\r]DC\u0011\u0001B\u001e\u0011%\u0011y\u0004KA\u0001\n\u0003\ny\u0010C\u0005\u0003B!\n\t\u0011\"\u0001\u0003D!I!1\n\u0015\u0002\u0002\u0013\u0005!Q\n\u0005\n\u0005/B\u0013\u0011!C!\u00053B\u0011B!\u0019)\u0003\u0003%\tAa\u0019\t\u0013\t5\u0004&!A\u0005B\t=\u0004\"\u0003B9Q\u0005\u0005I\u0011\tB:\u0011%\u0011)\bKA\u0001\n\u0013\u00119hB\u0004\u0003\u0012zA\tI!\"\u0007\u000f\t}d\u0004#!\u0003\u0002\"1qo\rC\u0001\u0005\u0007C\u0011Ba\u00104\u0003\u0003%\t%a@\t\u0013\t\u00053'!A\u0005\u0002\t\r\u0003\"\u0003B&g\u0005\u0005I\u0011\u0001BD\u0011%\u00119fMA\u0001\n\u0003\u0012I\u0006C\u0005\u0003bM\n\t\u0011\"\u0001\u0003\f\"I!QN\u001a\u0002\u0002\u0013\u0005#q\u000e\u0005\n\u0005c\u001a\u0014\u0011!C!\u0005gB\u0011B!\u001e4\u0003\u0003%IAa\u001e\t\u000f\tMe\u0004\"\u0001\u0003\u0016\"I!\u0011\u0014\u0010C\u0002\u0013\u0005!1\u0014\u0005\t\u0005Ks\u0002\u0015!\u0003\u0003\u001e\ny1*\u00194lCJ\u000bg\r^*feZ,'O\u0003\u0002C\u0007\u000611/\u001a:wKJT\u0011\u0001R\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001q)T)\u0011\u0005![U\"A%\u000b\u0003)\u000bQa]2bY\u0006L!\u0001T%\u0003\r\u0005s\u0017PU3g!\tqu*D\u0001B\u0013\t\u0001\u0016I\u0001\u0004TKJ4XM\u001d\t\u0003%Vk\u0011a\u0015\u0006\u0003)\u000e\u000bQ!\u001e;jYNL!AV*\u0003\u000f1{wmZ5oO\u000611m\u001c8gS\u001e\u0004\"AT-\n\u0005i\u000b%aC&bM.\f7i\u001c8gS\u001e\fA\u0001^5nKB\u0011QLZ\u0007\u0002=*\u0011Ak\u0018\u0006\u0003A\u0006\faaY8n[>t'B\u0001#c\u0015\t\u0019G-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0006\u0019qN]4\n\u0005\u001dt&\u0001\u0002+j[\u0016\f\u0001\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=\u0011\u0007!SG.\u0003\u0002l\u0013\n1q\n\u001d;j_:\u0004\"!\u001c;\u000f\u00059\u0014\bCA8J\u001b\u0005\u0001(BA9F\u0003\u0019a$o\\8u}%\u00111/S\u0001\u0007!J,G-\u001a4\n\u0005U4(AB*ue&twM\u0003\u0002t\u0013\u00061A(\u001b8jiz\"B!\u001f>|yB\u0011a\n\u0001\u0005\u0006/\u0012\u0001\r\u0001\u0017\u0005\u00067\u0012\u0001\r\u0001\u0018\u0005\u0006Q\u0012\u0001\r![\u0001\u0004q\u0012\n\u0004\u0003\u0003%\u0000\u0003\u0007\tI!!\u0007\n\u0007\u0005\u0005\u0011J\u0001\u0004UkBdWm\r\t\u0004\u001d\u0006\u0015\u0011bAA\u0004\u0003\nqQ*\u001a;b!J|\u0007/\u001a:uS\u0016\u001c\b\u0003BA\u0006\u0003+i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\nE>|Go\u001d;sCBT1!a\u0005b\u0003!iW\r^1eCR\f\u0017\u0002BA\f\u0003\u001b\u0011\u0011CQ8piN$(/\u00199NKR\fG-\u0019;b!\u0015\tY\"!\tm\u001b\t\tiBC\u0002\u0002 %\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019#!\b\u0003\u0007M+\u0017/A\u0005nKR\f\u0007K]8qgV\u0011\u00111A\u0001\u000b[\u0016$\u0018\r\u0015:paN\u0004\u0013!\u00052p_R\u001cHO]1q\u001b\u0016$\u0018\rZ1uCV\u0011\u0011\u0011B\u0001\u0013E>|Go\u001d;sCBlU\r^1eCR\f\u0007%A\u0006pM\u001ad\u0017N\\3ESJ\u001cXCAA\r\u00031ygM\u001a7j]\u0016$\u0015N]:!\u0003\u001diW\r\u001e:jGN,\"!a\u000f\u0011\t\u0005u\u0012\u0011I\u0007\u0003\u0003\u007fQ1!a\u000e`\u0013\u0011\t\u0019%a\u0010\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%A\nnk2$\u0018\u000eV3oC:$X*\u001a;bI\u0006$\u0018-\u0006\u0002\u0002LA!\u0001J[A'!\u0011\ty%a\u0016\u000e\u0005\u0005E#\u0002BA*\u0003+\n1\"\\;mi&$XM\\1oi*\u0011!)Y\u0005\u0005\u00033\n\tFA\nNk2$\u0018\u000eV3oC:$X*\u001a;bI\u0006$\u0018-\u0001\u000bnk2$\u0018\u000eV3oC:$X*\u001a;bI\u0006$\u0018\rI\u0001\u001dG>tGO]8mY\u0016\u0014\u0018+^8sk64v\u000e^3sg\u001a+H/\u001e:f+\t\t\t\u0007\u0005\u0004\u0002d\u0005E\u0014QO\u0007\u0003\u0003KRA!a\u001a\u0002j\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005-\u0014QN\u0001\u0005kRLGN\u0003\u0002\u0002p\u0005!!.\u0019<b\u0013\u0011\t\u0019(!\u001a\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\r\u0005\u0005\u0002x\u0005e\u0014QPAE\u001b\t\tI'\u0003\u0003\u0002|\u0005%$aA'baB!\u0011qPAC\u001b\t\t\tI\u0003\u0003\u0002\u0004\u00065\u0014\u0001\u00027b]\u001eLA!a\"\u0002\u0002\n9\u0011J\u001c;fO\u0016\u0014\b\u0003BAF\u0003/sA!!$\u0002\u00146\u0011\u0011q\u0012\u0006\u0004\u0003#\u000b\u0017\u0001\u0002:bMRLA!!&\u0002\u0010\u0006Q!+\u00194u\u0007>tg-[4\n\t\u0005e\u00151\u0014\u0002\f\u0003\u0012$'/Z:t'B,7M\u0003\u0003\u0002\u0016\u0006=\u0015!H2p]R\u0014x\u000e\u001c7feF+xN];n->$XM]:GkR,(/\u001a\u0011\u0002\u0017I\fg\r^'b]\u0006<WM]\u000b\u0003\u0003G\u0003b!!*\u0002*\u00065VBAAT\u0015\r\t\tjQ\u0005\u0005\u0003W\u000b9K\u0001\tLC\u001a\\\u0017MU1gi6\u000bg.Y4feB!\u0011qVAZ\u001b\t\t\tLC\u0002a\u0003+JA!!.\u00022\n!\u0012\t]5NKN\u001c\u0018mZ3B]\u00124VM]:j_:\fAB]1gi6\u000bg.Y4fe\u0002\nQc\u00197vgR,'OQ1mC:\u001cW-T1oC\u001e,'/\u0006\u0002\u0002>B!\u0001J[A`!\u0011\t\t-a2\u000e\u0005\u0005\r'bAAc\u0007\u0006Q1m\u001c8ue>dG.\u001a:\n\t\u0005%\u00171\u0019\u0002\u0016\u00072,8\u000f^3s\u0005\u0006d\u0017M\\2f\u001b\u0006t\u0017mZ3s\u0003Y\u0019G.^:uKJ\u0014\u0015\r\\1oG\u0016l\u0015M\\1hKJ\u0004\u0013A\u00022s_.,'/\u0006\u0002\u0002RB!\u0001J[Aj!\rq\u0015Q[\u0005\u0004\u0003/\f%\u0001\u0004\"s_.,'oU3sm\u0016\u0014\u0018a\u00022s_.,'\u000fI\u000b\u0003\u0003;\u0004B\u0001\u00136\u0002`B\u0019a*!9\n\u0007\u0005\r\u0018I\u0001\tD_:$(o\u001c7mKJ\u001cVM\u001d<fe\u0006Y1m\u001c8ue>dG.\u001a:!\u0003\u001d\u0019H/\u0019:ukB$\"!a;\u0011\u0007!\u000bi/C\u0002\u0002p&\u0013A!\u00168ji\u0006A1\u000f[;uI><h.A\u0007bo\u0006LGo\u00155vi\u0012|wO\\\u0001\u0010\u0017\u000647.\u0019*bMR\u001cVM\u001d<feB\u0011aJH\n\u0003=\u001d#\"!a>\u0002\u001b5+G/\u00193bi\u0006$v\u000e]5d+\t\u0011\t\u0001\u0005\u0003\u0002\u0000\t\r\u0011bA;\u0002\u0002\u0006qQ*\u001a;bI\u0006$\u0018\rV8qS\u000e\u0004\u0013!E'fi\u0006$\u0017\r^1QCJ$\u0018\u000e^5p]V\u0011!1\u0002\t\u0005\u0005\u001b\u0011y!D\u0001`\u0013\r\u0011\tb\u0018\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003IiU\r^1eCR\f\u0007+\u0019:uSRLwN\u001c\u0011\u0002\u001f5+G/\u00193bi\u0006$v\u000e]5d\u0013\u0012,\"A!\u0007\u0011\t\t5!1D\u0005\u0004\u0005;y&\u0001B+vS\u0012\f\u0001#T3uC\u0012\fG/\u0019+pa&\u001c\u0017\n\u001a\u0011\u0003\u0017A\u0013xnY3tgJ{G.Z\n\u0003M\u001dK3A\n\u00154\u0005)\u0011%o\\6feJ{G.Z\n\tQ\u001d\u0013YCa\f\u00036A\u0019!Q\u0006\u0014\u000e\u0003y\u00012\u0001\u0013B\u0019\u0013\r\u0011\u0019$\u0013\u0002\b!J|G-^2u!\rA%qG\u0005\u0004\u0005sI%\u0001D*fe&\fG.\u001b>bE2,GC\u0001B\u001f!\r\u0011i\u0003K\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\t\u0015\u0003c\u0001%\u0003H%\u0019!\u0011J%\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\t=#Q\u000b\t\u0004\u0011\nE\u0013b\u0001B*\u0013\n\u0019\u0011I\\=\t\u0011ud\u0013\u0011!a\u0001\u0005\u000b\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u00057\u0002b!a\u0007\u0003^\t=\u0013\u0002\u0002B0\u0003;\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!Q\rB6!\rA%qM\u0005\u0004\u0005SJ%a\u0002\"p_2,\u0017M\u001c\u0005\t{:\n\t\u00111\u0001\u0003P\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0003F\u0005AAo\\*ue&tw\r\u0006\u0002\u0003\u0002\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011I\b\u0005\u0003\u0002\u0000\tm\u0014\u0002\u0002B?\u0003\u0003\u0013aa\u00142kK\u000e$(AD\"p]R\u0014x\u000e\u001c7feJ{G.Z\n\tg\u001d\u0013YCa\f\u00036Q\u0011!Q\u0011\t\u0004\u0005[\u0019D\u0003\u0002B(\u0005\u0013C\u0001\"`\u001c\u0002\u0002\u0003\u0007!Q\t\u000b\u0005\u0005K\u0012i\t\u0003\u0005~s\u0005\u0005\t\u0019\u0001B(\u0003)\u0011%o\\6feJ{G.Z\u0001\u000f\u0007>tGO]8mY\u0016\u0014(k\u001c7f\u0003EIg.\u001b;jC2L'0\u001a'pO\u0012K'o\u001d\u000b\u0004}\n]\u0005\"B,>\u0001\u0004A\u0016\u0001D2p]\u001aLwmU2iK6\fWC\u0001BO!\u0011\u0011yJ!)\u000e\u0005\u0005E\u0011\u0002\u0002BR\u0003#\u0011\u0011cS1gW\u0006\u001cuN\u001c4jON\u001b\u0007.Z7b\u00035\u0019wN\u001c4jON\u001b\u0007.Z7bA\u0001")
public class KafkaRaftServer
implements Server,
Logging {
    private final KafkaConfig config;
    private final Time time;
    private final /* synthetic */ Tuple3 x$1;
    private final MetaProperties metaProps;
    private final BootstrapMetadata bootstrapMetadata;
    private final Seq<String> offlineDirs;
    private final Metrics metrics;
    private final Option<MultiTenantMetadata> multiTenantMetadata;
    private final CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final KafkaRaftManager<ApiMessageAndVersion> raftManager;
    private final Option<ClusterBalanceManager> clusterBalanceManager;
    private final Option<BrokerServer> broker;
    private final Option<ControllerServer> controller;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static KafkaConfigSchema configSchema() {
        return KafkaRaftServer$.MODULE$.configSchema();
    }

    public static Tuple3<MetaProperties, BootstrapMetadata, Seq<String>> initializeLogDirs(KafkaConfig kafkaConfig) {
        return KafkaRaftServer$.MODULE$.initializeLogDirs(kafkaConfig);
    }

    public static Uuid MetadataTopicId() {
        return KafkaRaftServer$.MODULE$.MetadataTopicId();
    }

    public static TopicPartition MetadataPartition() {
        return KafkaRaftServer$.MODULE$.MetadataPartition();
    }

    public static String MetadataTopic() {
        return KafkaRaftServer$.MODULE$.MetadataTopic();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private MetaProperties metaProps() {
        return this.metaProps;
    }

    private BootstrapMetadata bootstrapMetadata() {
        return this.bootstrapMetadata;
    }

    private Seq<String> offlineDirs() {
        return this.offlineDirs;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    public Option<MultiTenantMetadata> multiTenantMetadata() {
        return this.multiTenantMetadata;
    }

    private CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    private KafkaRaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    public Option<ClusterBalanceManager> clusterBalanceManager() {
        return this.clusterBalanceManager;
    }

    private Option<BrokerServer> broker() {
        return this.broker;
    }

    private Option<ControllerServer> controller() {
        return this.controller;
    }

    @Override
    public void startup() {
        Mx4jLoader$.MODULE$.maybeLoad();
        this.raftManager().startup();
        this.controller().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.startup();
            return BoxedUnit.UNIT;
        });
        this.broker().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.startup();
            return BoxedUnit.UNIT;
        });
        AppInfoParser.registerAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString(this.config.brokerId()), (Metrics)this.metrics(), (long)this.time.milliseconds());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> KafkaBroker$.MODULE$.STARTED_MESSAGE());
    }

    @Override
    public void shutdown() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.clusterBalanceManager().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        }), this, CoreUtils$.MODULE$.swallow$default$3());
        this.broker().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        this.raftManager().shutdown();
        this.controller().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.shutdown();
            return BoxedUnit.UNIT;
        });
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AppInfoParser.unregisterAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString($this.config.brokerId()), (Metrics)this.metrics()), this, CoreUtils$.MODULE$.swallow$default$3());
        this.multiTenantMetadata().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.close(this.config.brokerSessionUuid());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void awaitShutdown() {
        this.broker().foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            x$8.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        this.controller().foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            x$9.awaitShutdown();
            return BoxedUnit.UNIT;
        });
    }

    public KafkaRaftServer(KafkaConfig config, Time time, Option<String> threadNamePrefix) {
        None$ none$;
        None$ none$2;
        this.config = config;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(26).append("[KafkaRaftServer nodeId=").append(config.nodeId()).append("] ").toString());
        KafkaMetricsReporter$.MODULE$.startReporters(VerifiableProperties$.MODULE$.apply(config.originals()));
        KafkaYammerMetrics.INSTANCE.configure(config.originals());
        Tuple3<MetaProperties, BootstrapMetadata, Seq<String>> tuple3 = KafkaRaftServer$.MODULE$.initializeLogDirs(config);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        MetaProperties metaProps = (MetaProperties)tuple3._1();
        BootstrapMetadata bootstrapMetadata = (BootstrapMetadata)tuple3._2();
        Seq offlineDirs = (Seq)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)metaProps, (Object)bootstrapMetadata, (Object)offlineDirs);
        this.x$1 = tuple32;
        this.metaProps = (MetaProperties)this.x$1._1();
        this.bootstrapMetadata = (BootstrapMetadata)this.x$1._2();
        this.offlineDirs = (Seq)this.x$1._3();
        this.metrics = Server$.MODULE$.initializeMetrics(config, time, this.metaProps().clusterId());
        this.multiTenantMetadata = Option$.MODULE$.apply((Object)ConfluentConfigs.buildMultitenantMetadata(config.values(), (Metrics)this.metrics()));
        this.controllerQuorumVotersFuture = CompletableFuture.completedFuture(RaftConfig.parseVoterConnections(config.quorumVoters()));
        this.raftManager = new KafkaRaftManager(this.metaProps(), config, new MetadataRecordSerde(), KafkaRaftServer$.MODULE$.MetadataPartition(), KafkaRaftServer$.MODULE$.MetadataTopicId(), time, this.metrics(), threadNamePrefix, this.controllerQuorumVotersFuture());
        Object object = this.clusterBalanceManager = config.processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$) ? new Some((Object)ClusterBalanceManager.clusterBalanceManager(config)) : None$.MODULE$;
        if (config.processRoles().contains((Object)KafkaRaftServer$BrokerRole$.MODULE$)) {
            BrokerServerMetrics brokerMetrics = BrokerServerMetrics$.MODULE$.apply(this.metrics());
            ProcessExitingFaultHandler fatalFaultHandler = new ProcessExitingFaultHandler();
            LoggingFaultHandler metadataLoadingFaultHandler = new LoggingFaultHandler("metadata loading", () -> brokerMetrics.metadataLoadErrorCount().getAndIncrement());
            LoggingFaultHandler metadataApplyingFaultHandler = new LoggingFaultHandler("metadata application", () -> brokerMetrics.metadataApplyErrorCount().getAndIncrement());
            none$2 = new Some((Object)new BrokerServer(config, this.metaProps(), this.raftManager(), this.clusterBalanceManager(), time, this.metrics(), brokerMetrics, threadNamePrefix, this.offlineDirs(), this.controllerQuorumVotersFuture(), (FaultHandler)fatalFaultHandler, (FaultHandler)metadataLoadingFaultHandler, (FaultHandler)metadataApplyingFaultHandler, this.multiTenantMetadata()));
        } else {
            none$2 = this.broker = None$.MODULE$;
        }
        if (config.processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$)) {
            QuorumControllerMetrics controllerMetrics = new QuorumControllerMetrics(KafkaYammerMetrics.defaultRegistry(), time, this.metrics());
            LoggingFaultHandler metadataFaultHandler = new LoggingFaultHandler("controller metadata", () -> controllerMetrics.incrementMetadataErrorCount());
            ProcessExitingFaultHandler fatalFaultHandler = new ProcessExitingFaultHandler();
            none$ = new Some((Object)new ControllerServer(this.metaProps(), config, this.raftManager(), this.clusterBalanceManager(), time, this.metrics(), (ControllerMetrics)controllerMetrics, threadNamePrefix, this.controllerQuorumVotersFuture(), KafkaRaftServer$.MODULE$.configSchema(), this.raftManager().apiVersions(), this.bootstrapMetadata(), (FaultHandler)metadataFaultHandler, (FaultHandler)fatalFaultHandler, this.multiTenantMetadata()));
        } else {
            none$ = None$.MODULE$;
        }
        this.controller = none$;
    }

    public static interface ProcessRole {
    }
}

