/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Optional;
import kafka.cluster.Partition;
import kafka.common.FetchedTimestampAndOffset;
import kafka.common.FetchedTimestampAndOffset$;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperation$;
import kafka.server.ReplicaManager;
import kafka.tier.fetcher.PendingOffsetForTimestamp;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.TraversableLike;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00194Aa\u0003\u0007\u0001#!Ia\u0003\u0001B\u0001B\u0003%q#\b\u0005\t=\u0001\u0011\t\u0011)A\u0005?!A!\u0005\u0001B\u0001B\u0003%1\u0005\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0011!9\u0005A!A!\u0002\u0013A\u0005\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u000ba\u0003A\u0011A-\t\u000b\u0005\u0004A\u0011\t2\t\u000b\r\u0004A\u0011\t3\t\u000b\u0015\u0004A\u0011\t3\u0003%\u0011+G.Y=fI2K7\u000f^(gMN,Go\u001d\u0006\u0003\u001b9\taa]3sm\u0016\u0014(\"A\b\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0005\t\u0003'Qi\u0011\u0001D\u0005\u0003+1\u0011\u0001\u0003R3mCf,Gm\u00149fe\u0006$\u0018n\u001c8\u0002\u000f\u0011,G.Y=NgB\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t!Aj\u001c8h\u0013\t1B#A\ngKR\u001c\u0007n\u00148ms\u001a\u0013x.\u001c'fC\u0012,'\u000f\u0005\u0002\u0019A%\u0011\u0011%\u0007\u0002\b\u0005>|G.Z1o\u0003)awnY1m\u0019&\u001cHo\u001d\t\u0005I%Zc'D\u0001&\u0015\t1s%\u0001\u0003vi&d'\"\u0001\u0015\u0002\t)\fg/Y\u0005\u0003U\u0015\u0012q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002-i5\tQF\u0003\u0002/_\u000511m\\7n_:T!a\u0004\u0019\u000b\u0005E\u0012\u0014AB1qC\u000eDWMC\u00014\u0003\ry'oZ\u0005\u0003k5\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eE\u0002\u0019oeJ!\u0001O\r\u0003\r=\u0003H/[8o!\tQD(D\u0001<\u0015\tqc\"\u0003\u0002>w\tIb)\u001a;dQ\u0016$G+[7fgR\fW\u000e]!oI>3gm]3u\u0003\u001d\u0001XM\u001c3j]\u001e\u0004\"\u0001Q#\u000e\u0003\u0005S!AQ\"\u0002\u000f\u0019,Go\u00195fe*\u0011AID\u0001\u0005i&,'/\u0003\u0002G\u0003\nI\u0002+\u001a8eS:<wJ\u001a4tKR4uN\u001d+j[\u0016\u001cH/Y7q\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\"aE%\n\u0005)c!A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0011e\u0016\u001c\bo\u001c8tK\u000e\u000bG\u000e\u001c2bG.\u0004B\u0001G'P+&\u0011a*\u0007\u0002\n\rVt7\r^5p]F\u0002B\u0001U*,m5\t\u0011K\u0003\u0002S3\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Q\u000b&aA'baB\u0011\u0001DV\u0005\u0003/f\u0011A!\u00168ji\u00061A(\u001b8jiz\"rAW.];z{\u0006\r\u0005\u0002\u0014\u0001!)ac\u0002a\u0001/!)ad\u0002a\u0001?!)!e\u0002a\u0001G!)ah\u0002a\u0001\u007f!)qi\u0002a\u0001\u0011\")1j\u0002a\u0001\u0019\u0006YAO]=D_6\u0004H.\u001a;f)\u0005y\u0012\u0001D8o\u000bb\u0004\u0018N]1uS>tG#A+\u0002\u0015=t7i\\7qY\u0016$X\r")
public class DelayedListOffsets
extends DelayedOperation {
    private final boolean fetchOnlyFromLeader;
    private final HashMap<TopicPartition, Option<FetchedTimestampAndOffset>> localLists;
    private final PendingOffsetForTimestamp pending;
    private final ReplicaManager replicaManager;
    private final Function1<Map<TopicPartition, Option<FetchedTimestampAndOffset>>, BoxedUnit> responseCallback;

    @Override
    public boolean tryComplete() {
        ((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(this.localLists).asScala()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            Object object;
            if (x$1 != null) {
                TopicPartition tp = (TopicPartition)x$1._1();
                Option v = (Option)x$1._2();
                try {
                    Partition partition = $this.replicaManager.getPartitionOrException(tp);
                    Option<Object> leaderEpoch = ((FetchedTimestampAndOffset)v.get()).leaderEpoch();
                    object = partition.localLogWithEpochOrThrow(OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(leaderEpoch.map((Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)x))))), $this.fetchOnlyFromLeader);
                }
                catch (Exception e) {
                    $this.pending.completeExceptionally(tp, e);
                    object = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError(null);
            }
            BoxedUnit boxedUnit = object;
            return boxedUnit;
        });
        if (this.pending.isDone()) {
            return this.forceComplete();
        }
        return false;
    }

    @Override
    public void onExpiration() {
        this.pending.cancel();
    }

    @Override
    public void onComplete() {
        scala.collection.mutable.Map tierResponses = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(this.pending.tierTimestampAndOffsets()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            Option timestampAndOffset = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric($this.pending.results().getOrDefault(topicPartition, Optional.of(FetchedTimestampAndOffset$.MODULE$.apply((Exception)((Object)Errors.REQUEST_TIMED_OUT.exception()))))));
            Tuple2 tuple2 = new Tuple2((Object)topicPartition, (Object)timestampAndOffset);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        this.responseCallback.apply((Object)((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(this.localLists).asScala()).$plus$plus((GenTraversableOnce)tierResponses));
    }

    public DelayedListOffsets(long delayMs, boolean fetchOnlyFromLeader, HashMap<TopicPartition, Option<FetchedTimestampAndOffset>> localLists, PendingOffsetForTimestamp pending, ReplicaManager replicaManager, Function1<Map<TopicPartition, Option<FetchedTimestampAndOffset>>, BoxedUnit> responseCallback) {
        this.fetchOnlyFromLeader = fetchOnlyFromLeader;
        this.localLists = localLists;
        this.pending = pending;
        this.replicaManager = replicaManager;
        this.responseCallback = responseCallback;
        super(delayMs, DelayedOperation$.MODULE$.$lessinit$greater$default$2());
    }
}

