/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.server.DelayedDeleteRecordsMetrics$;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperation$;
import kafka.server.DeleteRecordsPartitionStatus;
import kafka.server.HostedPartition;
import kafka.server.HostedPartition$None$;
import kafka.server.HostedPartition$Offline$;
import kafka.server.ReplicaManager;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.DeleteRecordsResponseData;
import org.apache.kafka.common.protocol.Errors;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y3A!\u0003\u0006\u0001\u001f!IA\u0003\u0001B\u0001B\u0003%Qc\u0007\u0005\t9\u0001\u0011\t\u0011)A\u0005;!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007\u0003\u00056\u0001\t\u0005\t\u0015!\u00037\u0011\u00159\u0005\u0001\"\u0001I\u0011\u0015q\u0005\u0001\"\u0011P\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0011\u0015)\u0006\u0001\"\u0011U\u0005Q!U\r\\1zK\u0012$U\r\\3uKJ+7m\u001c:eg*\u00111\u0002D\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u00035\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011CE\u0007\u0002\u0015%\u00111C\u0003\u0002\u0011\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:\fq\u0001Z3mCfl5\u000f\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrC\u0001\u0003M_:<\u0017B\u0001\u000b\u0013\u0003M!W\r\\3uKJ+7m\u001c:egN#\u0018\r^;t!\u0011q\u0012e\t\u0018\u000e\u0003}Q!\u0001I\f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002#?\t\u0019Q*\u00199\u0011\u0005\u0011bS\"A\u0013\u000b\u0005\u0019:\u0013AB2p[6|gN\u0003\u0002\u000eQ)\u0011\u0011FK\u0001\u0007CB\f7\r[3\u000b\u0003-\n1a\u001c:h\u0013\tiSE\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\u0005Ey\u0013B\u0001\u0019\u000b\u0005q!U\r\\3uKJ+7m\u001c:egB\u000b'\u000f^5uS>t7\u000b^1ukN\faB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u0002\u0012g%\u0011AG\u0003\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003A\u0011Xm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000e\u0005\u0003\u0017oe\"\u0015B\u0001\u001d\u0018\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u001fC\rR\u0004CA\u001eB\u001d\tat(D\u0001>\u0015\tqT%A\u0004nKN\u001c\u0018mZ3\n\u0005\u0001k\u0014!\u0007#fY\u0016$XMU3d_J$7OU3ta>t7/\u001a#bi\u0006L!AQ\"\u00039\u0011+G.\u001a;f%\u0016\u001cwN\u001d3t!\u0006\u0014H/\u001b;j_:\u0014Vm];mi*\u0011\u0001)\u0010\t\u0003-\u0015K!AR\f\u0003\tUs\u0017\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b%S5\nT'\u0011\u0005E\u0001\u0001\"\u0002\u000b\u0006\u0001\u0004)\u0002\"\u0002\u000f\u0006\u0001\u0004i\u0002\"B\u0019\u0006\u0001\u0004\u0011\u0004\"B\u001b\u0006\u0001\u00041\u0014a\u0003;ss\u000e{W\u000e\u001d7fi\u0016$\u0012\u0001\u0015\t\u0003-EK!AU\f\u0003\u000f\t{w\u000e\\3b]\u0006aqN\\#ya&\u0014\u0018\r^5p]R\tA)\u0001\u0006p]\u000e{W\u000e\u001d7fi\u0016\u0004")
public class DelayedDeleteRecords
extends DelayedOperation {
    private final Map<TopicPartition, DeleteRecordsPartitionStatus> deleteRecordsStatus;
    private final ReplicaManager replicaManager;
    private final Function1<Map<TopicPartition, DeleteRecordsResponseData.DeleteRecordsPartitionResult>, BoxedUnit> responseCallback;

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean tryComplete() {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, status) -> {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Checking delete records satisfaction for ").append(topicPartition).append(", current status ").append(status).toString());
            if (status.acksPending()) {
                boolean bl;
                Errors errors;
                long l;
                HostedPartition hostedPartition = $this.replicaManager.getPartition((TopicPartition)topicPartition);
                if (hostedPartition instanceof HostedPartition.Online) {
                    boolean bl2;
                    Errors errors2;
                    long l2;
                    Partition partition = ((HostedPartition.Online)hostedPartition).partition();
                    Option<AbstractLog> option = partition.leaderLogIfLocal();
                    if (option instanceof Some) {
                        long leaderLW = partition.lowWatermarkIfLeader();
                        boolean bl3 = leaderLW >= status.requiredOffset();
                        l2 = leaderLW;
                        errors2 = Errors.NONE;
                        bl2 = bl3;
                    } else if (None$.MODULE$.equals(option)) {
                        l2 = -1L;
                        errors2 = Errors.NOT_LEADER_OR_FOLLOWER;
                        bl2 = false;
                    } else {
                        throw new MatchError(option);
                    }
                    l = l2;
                    errors = errors2;
                    bl = bl2;
                } else if (HostedPartition$Offline$.MODULE$.equals(hostedPartition)) {
                    l = -1L;
                    errors = Errors.KAFKA_STORAGE_ERROR;
                    bl = false;
                } else if (HostedPartition$None$.MODULE$.equals(hostedPartition)) {
                    l = -1L;
                    errors = Errors.UNKNOWN_TOPIC_OR_PARTITION;
                    bl = false;
                } else {
                    throw new MatchError((Object)hostedPartition);
                }
                Errors errors3 = errors;
                Errors errors4 = Errors.NONE;
                if ((errors3 != null ? !errors3.equals(errors4) : errors4 != null) || bl) {
                    status.acksPending_$eq(false);
                    status.responseStatus().setErrorCode(errors.code());
                    return status.responseStatus().setLowWatermark(l);
                }
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        };
        Map<TopicPartition, DeleteRecordsPartitionStatus> map = Implicits$.MODULE$.MapExtensionMethods(this.deleteRecordsStatus);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        if (!this.deleteRecordsStatus.values().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.acksPending()))) {
            return this.forceComplete();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onExpiration() {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, status) -> {
            DelayedDeleteRecords.$anonfun$onExpiration$1(topicPartition, status);
            return BoxedUnit.UNIT;
        };
        Map<TopicPartition, DeleteRecordsPartitionStatus> map = Implicits$.MODULE$.MapExtensionMethods(this.deleteRecordsStatus);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
    }

    @Override
    public void onComplete() {
        Map responseStatus = (Map)this.deleteRecordsStatus.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$1._1();
            DeleteRecordsPartitionStatus status = (DeleteRecordsPartitionStatus)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)status.responseStatus());
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        this.responseCallback.apply((Object)responseStatus);
    }

    public static final /* synthetic */ void $anonfun$new$1(DelayedDeleteRecords $this, TopicPartition topicPartition, DeleteRecordsPartitionStatus status) {
        if (status.responseStatus().errorCode() == Errors.NONE.code()) {
            status.acksPending_$eq(true);
            status.responseStatus().setErrorCode(Errors.REQUEST_TIMED_OUT.code());
        } else {
            status.acksPending_$eq(false);
        }
        $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Initial partition status for %s is %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, status})));
    }

    public static final /* synthetic */ void $anonfun$onExpiration$1(TopicPartition topicPartition, DeleteRecordsPartitionStatus status) {
        if (status.acksPending()) {
            DelayedDeleteRecordsMetrics$.MODULE$.recordExpiration(topicPartition);
        }
    }

    /*
     * WARNING - void declaration
     */
    public DelayedDeleteRecords(long delayMs, Map<TopicPartition, DeleteRecordsPartitionStatus> deleteRecordsStatus, ReplicaManager replicaManager, Function1<Map<TopicPartition, DeleteRecordsResponseData.DeleteRecordsPartitionResult>, BoxedUnit> responseCallback) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        this.deleteRecordsStatus = deleteRecordsStatus;
        this.replicaManager = replicaManager;
        this.responseCallback = responseCallback;
        super(delayMs, DelayedOperation$.MODULE$.$lessinit$greater$default$2());
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, status) -> {
            DelayedDeleteRecords.$anonfun$new$1(this, topicPartition, status);
            return BoxedUnit.UNIT;
        };
        Map<TopicPartition, DeleteRecordsPartitionStatus> map = Implicits$.MODULE$.MapExtensionMethods(deleteRecordsStatus);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
    }
}

