/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.LeaderAndIsr;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.AlterPartitionItem;
import kafka.server.AlterPartitionManager;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.OperationNotAttemptedException;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.AlterPartitionResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005uh\u0001\u0002\u000e\u001c\u0001\u0001B\u0001b\u000e\u0001\u0003\u0006\u0004%\t\u0001\u000f\u0005\ty\u0001\u0011\t\u0011)A\u0005s!AQ\b\u0001BC\u0002\u0013\u0005a\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003@\u0011!\u0019\u0005A!b\u0001\n\u0003!\u0005\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u0011I\u0003!Q1A\u0005\u0002MC\u0001b\u0016\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\t1\u0002\u0011)\u0019!C\u00013\"A\u0001\r\u0001B\u0001B\u0003%!\f\u0003\u0005b\u0001\t\u0015\r\u0011\"\u0001c\u0011!Q\u0007A!A!\u0002\u0013\u0019\u0007\"B6\u0001\t\u0003a\u0007\u0002\u0003;\u0001\u0005\u0004%\taG;\t\u000f\u0005-\u0001\u0001)A\u0005m\"I\u0011Q\u0002\u0001C\u0002\u0013%\u0011q\u0002\u0005\t\u0003C\u0001\u0001\u0015!\u0003\u0002\u0012!9\u00111\u0005\u0001\u0005B\u0005\u0015\u0002bBA\u0017\u0001\u0011\u0005\u0013Q\u0005\u0005\b\u0003_\u0001A\u0011IA\u0019\u0011!\t\u0019\u0007\u0001C\u00017\u0005\u0015\u0002\u0002CA3\u0001\u0011\u00051$!\n\t\u000f\u0005\u001d\u0004\u0001\"\u0003\u0002j!9\u0011q\u0011\u0001\u0005\n\u0005%\u0005bBAh\u0001\u0011\u0005\u0011\u0011\u001b\u0002\u001d\t\u00164\u0017-\u001e7u\u00032$XM\u001d)beRLG/[8o\u001b\u0006t\u0017mZ3s\u0015\taR$\u0001\u0004tKJ4XM\u001d\u0006\u0002=\u0005)1.\u00194lC\u000e\u00011#\u0002\u0001\"O-\n\u0004C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g\r\u0005\u0002)S5\t1$\u0003\u0002+7\t)\u0012\t\u001c;feB\u000b'\u000f^5uS>tW*\u00198bO\u0016\u0014\bC\u0001\u00170\u001b\u0005i#B\u0001\u0018\u001e\u0003\u0015)H/\u001b7t\u0013\t\u0001TFA\u0004M_\u001e<\u0017N\\4\u0011\u0005I*T\"A\u001a\u000b\u0005Qj\u0012aB7fiJL7m]\u0005\u0003mM\u0012\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0003a\u0019wN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM]\u000b\u0002sA\u0011\u0001FO\u0005\u0003wm\u0011\u0001E\u0011:pW\u0016\u0014Hk\\\"p]R\u0014x\u000e\u001c7fe\u000eC\u0017M\u001c8fY6\u000bg.Y4fe\u0006I2m\u001c8ue>dG.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:!\u0003%\u00198\r[3ek2,'/F\u0001@!\ta\u0003)\u0003\u0002B[\tI1k\u00195fIVdWM]\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0013\u0001\u0002;j[\u0016,\u0012!\u0012\t\u0003\r>k\u0011a\u0012\u0006\u0003]!S!!\u0013&\u0002\r\r|W.\\8o\u0015\tq2J\u0003\u0002M\u001b\u00061\u0011\r]1dQ\u0016T\u0011AT\u0001\u0004_J<\u0017B\u0001)H\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012\u0001\u0016\t\u0003EUK!AV\u0012\u0003\u0007%sG/A\u0005ce>\\WM]%eA\u0005\u0019\"M]8lKJ,\u0005o\\2i'V\u0004\b\u000f\\5feV\t!\fE\u0002#7vK!\u0001X\u0012\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004C\u0001\u0012_\u0013\ty6E\u0001\u0003M_:<\u0017\u0001\u00062s_.,'/\u00129pG\"\u001cV\u000f\u001d9mS\u0016\u0014\b%A\fnKR\fG-\u0019;b-\u0016\u00148/[8o'V\u0004\b\u000f\\5feV\t1\rE\u0002#7\u0012\u0004\"!\u001a5\u000e\u0003\u0019T!!S4\u000b\u0005qQ\u0015BA5g\u0005=iU\r^1eCR\fg+\u001a:tS>t\u0017\u0001G7fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8TkB\u0004H.[3sA\u00051A(\u001b8jiz\"r!\u001c8paF\u00148\u000f\u0005\u0002)\u0001!)q'\u0004a\u0001s!)Q(\u0004a\u0001\u007f!)1)\u0004a\u0001\u000b\")!+\u0004a\u0001)\")\u0001,\u0004a\u00015\")\u0011-\u0004a\u0001G\u0006\u0001RO\\:f]RL5O]+qI\u0006$Xm]\u000b\u0002mB)q\u000f @\u0002\u00065\t\u0001P\u0003\u0002zu\u0006!Q\u000f^5m\u0015\u0005Y\u0018\u0001\u00026bm\u0006L!! =\u0003\u00075\u000b\u0007\u000fE\u0002\u0000\u0003\u0003i\u0011\u0001S\u0005\u0004\u0003\u0007A%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0004Q\u0005\u001d\u0011bAA\u00057\t\u0011\u0012\t\u001c;feB\u000b'\u000f^5uS>t\u0017\n^3n\u0003E)hn]3oi&\u001b(/\u00169eCR,7\u000fI\u0001\u0010S:4G.[4iiJ+\u0017/^3tiV\u0011\u0011\u0011\u0003\t\u0005\u0003'\ti\"\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003\u0019\tGo\\7jG*\u0019\u00111\u0004=\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002 \u0005U!!D!u_6L7MQ8pY\u0016\fg.\u0001\tj]\u001ad\u0017n\u001a5u%\u0016\fX/Z:uA\u0005)1\u000f^1siR\u0011\u0011q\u0005\t\u0004E\u0005%\u0012bAA\u0016G\t!QK\\5u\u0003!\u0019\b.\u001e;e_^t\u0017AB:vE6LG\u000f\u0006\u0006\u00024\u0005\u001d\u0013\u0011KA+\u00033\u0002b!!\u000e\u00028\u0005mRBAA\r\u0013\u0011\tI$!\u0007\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\r\u0005\u0003\u0002>\u0005\rSBAA \u0015\r\t\t%H\u0001\u0004CBL\u0017\u0002BA#\u0003\u007f\u0011A\u0002T3bI\u0016\u0014\u0018I\u001c3JgJDq!!\u0013\u0015\u0001\u0004\tY%\u0001\tu_BL7-\u00133QCJ$\u0018\u000e^5p]B\u0019q0!\u0014\n\u0007\u0005=\u0003J\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\"9\u00111\u000b\u000bA\u0002\u0005m\u0012\u0001\u00047fC\u0012,'/\u00118e\u0013N\u0014\bBBA,)\u0001\u0007A+A\bd_:$(o\u001c7mKJ,\u0005o\\2i\u0011\u001d\tY\u0006\u0006a\u0001\u0003;\nA\u0003\u001d:pa\u0006<\u0017\r^3J[6,G-[1uK2L\bc\u0001\u0012\u0002`%\u0019\u0011\u0011M\u0012\u0003\u000f\t{w\u000e\\3b]\u0006AR.Y=cKB\u0013x\u000e]1hCR,\u0017j\u001d:DQ\u0006tw-Z:\u0002)\rdW-\u0019:J]\u001ac\u0017n\u001a5u%\u0016\fX/Z:u\u0003-\u0019XM\u001c3SKF,Xm\u001d;\u0015\t\u0005\u001d\u00121\u000e\u0005\b\u0003[:\u0002\u0019AA8\u0003mIgN\u001a7jO\"$\u0018\t\u001c;feB\u000b'\u000f^5uS>t\u0017\n^3ngB1\u0011\u0011OAA\u0003\u000bqA!a\u001d\u0002~9!\u0011QOA>\u001b\t\t9HC\u0002\u0002z}\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0013\n\u0007\u0005}4%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\r\u0015Q\u0011\u0002\u0004'\u0016\f(bAA@G\u0005a!-^5mIJ+\u0017/^3tiR1\u00111RAe\u0003\u0017\u0004rAIAG\u0003#\u000b)+C\u0002\u0002\u0010\u000e\u0012a\u0001V;qY\u0016\u0014\u0004\u0003BAJ\u0003?sA!!&\u0002\u001c6\u0011\u0011q\u0013\u0006\u0004\u00033C\u0015\u0001\u0003:fcV,7\u000f^:\n\t\u0005u\u0015qS\u0001\u0016\u00032$XM\u001d)beRLG/[8o%\u0016\fX/Z:u\u0013\u0011\t\t+a)\u0003\u000f\t+\u0018\u000e\u001c3fe*!\u0011QTAL!!\t9+!-\u00024\u0006eVBAAU\u0015\u0011\tY+!,\u0002\u000f5,H/\u00192mK*\u0019\u0011qV\u0012\u0002\u0015\r|G\u000e\\3di&|g.C\u0002~\u0003S\u00032a`A[\u0013\r\t9\f\u0013\u0002\u0005+VLG\r\u0005\u0003\u0002<\u0006\rg\u0002BA_\u0003\u007f\u00032!!\u001e$\u0013\r\t\tmI\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0017q\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u00057\u0005C\u0004\u0002na\u0001\r!a\u001c\t\r\u00055\u0007\u00041\u0001^\u0003-\u0011'o\\6fe\u0016\u0003xn\u00195\u00029!\fg\u000e\u001a7f\u00032$XM\u001d)beRLG/[8o%\u0016\u001c\bo\u001c8tKRa\u00111[Ap\u0003S\f\u00190a>\u0002zB!\u0011Q[An\u001b\t\t9NC\u0002\u0002Z\"\u000b\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003;\f9N\u0001\u0004FeJ|'o\u001d\u0005\b\u0003CL\u0002\u0019AAr\u00035\u0011X-];fgRDU-\u00193feB!\u0011QSAs\u0013\u0011\t9/a&\u0003\u001bI+\u0017/^3ti\"+\u0017\rZ3s\u0011\u001d\tY/\u0007a\u0001\u0003[\f!#\u00197uKJ\u0004\u0016M\u001d;ji&|gNU3taB!\u0011QSAx\u0013\u0011\t\t0a&\u0003-\u0005cG/\u001a:QCJ$\u0018\u000e^5p]J+7\u000f]8og\u0016Da!!>\u001a\u0001\u0004i\u0016aD:f]R\u0014%o\\6fe\u0016\u0003xn\u00195\t\u000f\u00055\u0014\u00041\u0001\u0002p!9\u00111`\rA\u0002\u0005\u0015\u0016a\u0004;pa&\u001cg*Y7fg\nK\u0018\nZ:")
public class DefaultAlterPartitionManager
implements AlterPartitionManager,
KafkaMetricsGroup {
    private final BrokerToControllerChannelManager controllerChannelManager;
    private final Scheduler scheduler;
    private final Time time;
    private final int brokerId;
    private final Function0<Object> brokerEpochSupplier;
    private final Function0<MetadataVersion> metadataVersionSupplier;
    private final java.util.Map<TopicPartition, AlterPartitionItem> unsentIsrUpdates;
    private final AtomicBoolean inflightRequest;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public <T> Gauge<T> newGauge(MetricName metricName, Gauge<T> metric) {
        return KafkaMetricsGroup.newGauge$(this, metricName, metric);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public void removeMetric(MetricName metricName) {
        KafkaMetricsGroup.removeMetric$(this, metricName);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public BrokerToControllerChannelManager controllerChannelManager() {
        return this.controllerChannelManager;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Time time() {
        return this.time;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Function0<Object> brokerEpochSupplier() {
        return this.brokerEpochSupplier;
    }

    public Function0<MetadataVersion> metadataVersionSupplier() {
        return this.metadataVersionSupplier;
    }

    public java.util.Map<TopicPartition, AlterPartitionItem> unsentIsrUpdates() {
        return this.unsentIsrUpdates;
    }

    private AtomicBoolean inflightRequest() {
        return this.inflightRequest;
    }

    @Override
    public void start() {
        this.controllerChannelManager().start();
    }

    @Override
    public void shutdown() {
        this.controllerChannelManager().shutdown();
    }

    @Override
    public CompletableFuture<LeaderAndIsr> submit(TopicIdPartition topicIdPartition, LeaderAndIsr leaderAndIsr, int controllerEpoch, boolean propagateImmediately) {
        CompletableFuture<LeaderAndIsr> future = new CompletableFuture<LeaderAndIsr>();
        AlterPartitionItem alterPartitionItem = new AlterPartitionItem(topicIdPartition, leaderAndIsr, future, controllerEpoch);
        if (this.unsentIsrUpdates().putIfAbsent(alterPartitionItem.topicIdPartition().topicPartition(), alterPartitionItem) == null) {
            this.maybePropagateIsrChanges();
        } else {
            future.completeExceptionally((Throwable)new OperationNotAttemptedException(new StringBuilder(50).append("Failed to enqueue ISR change state ").append(leaderAndIsr).append(" for partition ").append(topicIdPartition).toString()));
        }
        return future;
    }

    public void maybePropagateIsrChanges() {
        if (!this.unsentIsrUpdates().isEmpty() && this.inflightRequest().compareAndSet(false, true)) {
            ListBuffer inflightAlterPartitionItems = new ListBuffer();
            this.unsentIsrUpdates().values().forEach(item -> inflightAlterPartitionItems.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterPartitionItem[]{item})));
            this.sendRequest((Seq<AlterPartitionItem>)inflightAlterPartitionItems.toSeq());
        }
    }

    public void clearInFlightRequest() {
        if (!this.inflightRequest().compareAndSet(true, false)) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempting to clear AlterPartition in-flight flag when no apparent request is in-flight");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void sendRequest(Seq<AlterPartitionItem> inflightAlterPartitionItems) {
        void var6_5;
        void var5_4;
        long brokerEpoch = this.brokerEpochSupplier().apply$mcJ$sp();
        Tuple2<AlterPartitionRequest.Builder, scala.collection.mutable.Map<Uuid, String>> tuple2 = this.buildRequest(inflightAlterPartitionItems, brokerEpoch);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        AlterPartitionRequest.Builder request = (AlterPartitionRequest.Builder)tuple2._1();
        scala.collection.mutable.Map topicNamesByIds = (scala.collection.mutable.Map)tuple2._2();
        void request2 = var5_4;
        void topicNamesByIds2 = var6_5;
        this.debug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> DefaultAlterPartitionManager.$anonfun$sendRequest$1((AlterPartitionRequest.Builder)request2)));
        this.controllerChannelManager().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)request2, new ControllerRequestCompletionHandler(this, brokerEpoch, inflightAlterPartitionItems, (scala.collection.mutable.Map)topicNamesByIds2){
            private final /* synthetic */ DefaultAlterPartitionManager $outer;
            private final long brokerEpoch$1;
            private final Seq inflightAlterPartitionItems$2;
            private final scala.collection.mutable.Map topicNamesByIds$1;

            public void onComplete(ClientResponse response) {
                Errors errors;
                this.$outer.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Received AlterPartition response ").append(response).toString());
                try {
                    if (response.authenticationException() != null) {
                        errors = Errors.NETWORK_EXCEPTION;
                    } else if (response.versionMismatch() != null) {
                        errors = Errors.UNSUPPORTED_VERSION;
                    } else {
                        AlterPartitionResponse body = (AlterPartitionResponse)response.responseBody();
                        errors = this.$outer.handleAlterPartitionResponse(response.requestHeader(), body, this.brokerEpoch$1, (Seq<AlterPartitionItem>)this.inflightAlterPartitionItems$2, (scala.collection.mutable.Map<Uuid, String>)this.topicNamesByIds$1);
                    }
                }
                finally {
                    this.$outer.clearInFlightRequest();
                }
                Errors error = errors;
                if (Errors.NONE.equals(error)) {
                    this.$outer.maybePropagateIsrChanges();
                    return;
                }
                this.$outer.scheduler().schedule("send-alter-partition", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.$outer.maybePropagateIsrChanges(), 50L, -1L, TimeUnit.MILLISECONDS);
            }

            public void onTimeout() {
                throw new IllegalStateException("Encountered unexpected timeout when sending AlterPartition to the controller");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.brokerEpoch$1 = brokerEpoch$1;
                this.inflightAlterPartitionItems$2 = inflightAlterPartitionItems$2;
                this.topicNamesByIds$1 = topicNamesByIds$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1(org.apache.kafka.clients.ClientResponse ), $anonfun$onComplete$2(kafka.server.DefaultAlterPartitionManager$$anon$1 )}, serializedLambda);
            }
        });
    }

    private Tuple2<AlterPartitionRequest.Builder, scala.collection.mutable.Map<Uuid, String>> buildRequest(Seq<AlterPartitionItem> inflightAlterPartitionItems, long brokerEpoch) {
        MetadataVersion metadataVersion = (MetadataVersion)this.metadataVersionSupplier().apply();
        HashMap topicNamesByIds = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        BooleanRef canUseTopicIds = BooleanRef.create((boolean)metadataVersion.isTopicIdsSupported());
        AlterPartitionRequestData message = new AlterPartitionRequestData().setBrokerId(this.brokerId()).setBrokerEpoch(brokerEpoch);
        inflightAlterPartitionItems.groupBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.topicIdPartition().topic()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DefaultAlterPartitionManager.$anonfun$buildRequest$2(canUseTopicIds, topicNamesByIds, message, metadataVersion, x0$1);
            return BoxedUnit.UNIT;
        });
        return new Tuple2((Object)new AlterPartitionRequest.Builder(message, canUseTopicIds.elem), (Object)topicNamesByIds);
    }

    public Errors handleAlterPartitionResponse(RequestHeader requestHeader, AlterPartitionResponse alterPartitionResp, long sentBrokerEpoch, Seq<AlterPartitionItem> inflightAlterPartitionItems, scala.collection.mutable.Map<Uuid, String> topicNamesByIds) {
        AlterPartitionResponseData data = alterPartitionResp.data();
        Errors errors = Errors.forCode((short)data.errorCode());
        if (Errors.STALE_BROKER_EPOCH.equals(errors)) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Broker had a stale broker epoch (").append(sentBrokerEpoch).append("), retrying.").toString());
        } else if (Errors.CLUSTER_AUTHORIZATION_FAILED.equals(errors)) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Broker is not authorized to send AlterPartition to controller", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> Errors.CLUSTER_AUTHORIZATION_FAILED.exception("Broker is not authorized to send AlterPartition to controller"));
        } else if (Errors.NONE.equals(errors)) {
            HashMap partitionResponses = HashMap$.MODULE$.empty();
            data.topics().forEach(topic -> {
                String topicName;
                String string = topicName = requestHeader.apiVersion() > 1 ? (String)topicNamesByIds.get((Object)topic.topicId()).orNull(Predef$.MODULE$.$conforms()) : topic.topicName();
                if (topicName == null || topicName.isEmpty()) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Received an unexpected topic ").append(topic).append(" in the alter partition response, ignoring it.").toString());
                    return;
                }
                topic.partitions().forEach(partition -> {
                    TopicPartition tp = new TopicPartition(topicName, partition.partitionIndex());
                    partitionResponses.update((Object)tp, partition);
                });
            });
            inflightAlterPartitionItems.foreach((Function1 & Serializable & scala.Serializable)inflightAlterPartition -> {
                Object object;
                Option option = partitionResponses.get((Object)inflightAlterPartition.topicIdPartition().topicPartition());
                if (option instanceof Some) {
                    AlterPartitionResponseData.PartitionData response = (AlterPartitionResponseData.PartitionData)((Some)option).value();
                    this.unsentIsrUpdates().remove(inflightAlterPartition.topicIdPartition().topicPartition());
                    Errors error = Errors.forCode((short)response.errorCode());
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Controller response returned for AlterIsr request for ").append(inflightAlterPartition.topicIdPartition()).append(": ").append(response).toString());
                    Errors errors = error;
                    Errors errors2 = Errors.NONE;
                    object = !(errors != null ? !errors.equals(errors2) : errors2 != null) ? BoxesRunTime.boxToBoolean((boolean)inflightAlterPartition.future().complete(new LeaderAndIsr(response.leaderId(), response.leaderEpoch(), (List<Object>)((List)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(response.isr()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$3)), List$.MODULE$.canBuildFrom())), inflightAlterPartition.leaderAndIsr().leaderRecoveryState(), response.partitionEpoch(), inflightAlterPartition.leaderAndIsr().clusterLinkState()))) : BoxesRunTime.boxToBoolean((boolean)inflightAlterPartition.future().completeExceptionally(error.exception()));
                } else if (None$.MODULE$.equals(option)) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Partition ").append(inflightAlterPartition.topicIdPartition()).append(" was sent but not included in the response").toString());
                    object = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option);
                }
                return object;
            });
        } else {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(88).append("Controller returned an unexpected top-level error when handling AlterPartition request: ").append(errors).toString());
        }
        return Errors.forCode((short)data.errorCode());
    }

    public static final /* synthetic */ String $anonfun$sendRequest$1(AlterPartitionRequest.Builder request$1) {
        return new StringBuilder(37).append("Sending AlterPartition to controller ").append(request$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$buildRequest$3(MetadataVersion metadataVersion$1, AlterPartitionRequestData.TopicData topicData$1, AlterPartitionItem item) {
        LeaderRecoveryState leaderRecoveryState = item.leaderAndIsr().leaderRecoveryState();
        LeaderRecoveryState leaderRecoveryState2 = LeaderRecoveryState.RECOVERING;
        AlterPartitionRequestData.PartitionData partitionData = new AlterPartitionRequestData.PartitionData().setPartitionIndex(item.topicIdPartition().partition()).setLeaderEpoch(item.leaderAndIsr().leaderEpoch()).setNewIsr((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)item.leaderAndIsr().isr().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), List$.MODULE$.canBuildFrom())).asJava()).setPartitionEpoch(item.leaderAndIsr().partitionEpoch()).setIsUnclean(!(leaderRecoveryState != null ? !leaderRecoveryState.equals(leaderRecoveryState2) : leaderRecoveryState2 != null));
        if (metadataVersion$1.isLeaderRecoverySupported()) {
            partitionData.setLeaderRecoveryState(item.leaderAndIsr().leaderRecoveryState().value());
        }
        item.leaderAndIsr().clusterLinkState().foreach((Function1 & Serializable & scala.Serializable)linkState -> partitionData.setClusterLinkState(new AlterPartitionRequestData.ClusterLinkState().setLinkedLeaderEpoch(linkState.linkedLeaderEpoch()).setLinkFailed(linkState.linkFailed())));
        return topicData$1.partitions().add(partitionData);
    }

    public static final /* synthetic */ void $anonfun$buildRequest$2(BooleanRef canUseTopicIds$1, HashMap topicNamesByIds$2, AlterPartitionRequestData message$1, MetadataVersion metadataVersion$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String topicName = (String)x0$1._1();
            Seq items = (Seq)x0$1._2();
            Uuid topicId = ((AlterPartitionItem)items.head()).topicIdPartition().topicId();
            Uuid uuid = topicId;
            Uuid uuid2 = Uuid.ZERO_UUID;
            canUseTopicIds$1.elem = canUseTopicIds$1.elem & (uuid == null ? uuid2 != null : !uuid.equals(uuid2));
            topicNamesByIds$2.update((Object)topicId, (Object)topicName);
            AlterPartitionRequestData.TopicData topicData = new AlterPartitionRequestData.TopicData().setTopicName(topicName).setTopicId(topicId);
            message$1.topics().add(topicData);
            items.foreach((Function1 & Serializable & scala.Serializable)item -> BoxesRunTime.boxToBoolean((boolean)DefaultAlterPartitionManager.$anonfun$buildRequest$3(metadataVersion$1, topicData, item)));
            return;
        }
        throw new MatchError(null);
    }

    public DefaultAlterPartitionManager(BrokerToControllerChannelManager controllerChannelManager, Scheduler scheduler, Time time, int brokerId, Function0<Object> brokerEpochSupplier, Function0<MetadataVersion> metadataVersionSupplier) {
        this.controllerChannelManager = controllerChannelManager;
        this.scheduler = scheduler;
        this.time = time;
        this.brokerId = brokerId;
        this.brokerEpochSupplier = brokerEpochSupplier;
        this.metadataVersionSupplier = metadataVersionSupplier;
        AlterPartitionManager.$init$(this);
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.unsentIsrUpdates = new ConcurrentHashMap<TopicPartition, AlterPartitionItem>();
        this.inflightRequest = new AtomicBoolean(false);
    }
}

