/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.BucketStorageProbe$;
import kafka.server.KafkaConfig;
import kafka.tier.store.BucketHealthResult;
import kafka.tier.store.TierObjectStore;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.KafkaThread;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001B\u0015+\u0001=B\u0001b\u0012\u0001\u0003\u0006\u0004%I\u0001\u0013\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u0013\"Aa\n\u0001BC\u0002\u0013%q\n\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003Q\u0011!I\u0006A!b\u0001\n\u0013Q\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011B.\t\u000b\t\u0004A\u0011A2\t\u000f!\u0004!\u0019!C\u0005S\"1A\u000f\u0001Q\u0001\n)Dq!\u001e\u0001C\u0002\u0013%a\u000f\u0003\u0004{\u0001\u0001\u0006Ia\u001e\u0005\bw\u0002\u0011\r\u0011\"\u0003w\u0011\u0019a\b\u0001)A\u0005o\"9Q\u0010\u0001b\u0001\n\u00131\bB\u0002@\u0001A\u0003%q\u000fC\u0004\u0000\u0001\t\u0007I\u0011\u0002<\t\u000f\u0005\u0005\u0001\u0001)A\u0005o\"Y\u00111\u0001\u0001A\u0002\u0003\u0007I\u0011BA\u0003\u0011-\ty\u0002\u0001a\u0001\u0002\u0004%I!!\t\t\u0017\u00055\u0002\u00011A\u0001B\u0003&\u0011q\u0001\u0005\f\u0003_\u0001\u0001\u0019!a\u0001\n\u0013\t\t\u0004C\u0006\u0002J\u0001\u0001\r\u00111A\u0005\n\u0005-\u0003bCA(\u0001\u0001\u0007\t\u0011)Q\u0005\u0003gA1\"!\u0015\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00022!Y\u00111\u000b\u0001A\u0002\u0003\u0007I\u0011BA+\u0011-\tI\u0006\u0001a\u0001\u0002\u0003\u0006K!a\r\t\u0017\u0005m\u0003\u00011AA\u0002\u0013%\u0011\u0011\u0007\u0005\f\u0003;\u0002\u0001\u0019!a\u0001\n\u0013\ty\u0006C\u0006\u0002d\u0001\u0001\r\u0011!Q!\n\u0005M\u0002bCA3\u0001\u0001\u0007\t\u0019!C\u0005\u0003cA1\"a\u001a\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002j!Y\u0011Q\u000e\u0001A\u0002\u0003\u0005\u000b\u0015BA\u001a\u0011\u001d\ty\u0007\u0001C\u0001\u0003cBq!a\u001d\u0001\t\u0003\t\t\bC\u0004\u0002v\u0001!\t!!\u001d\t\u000f\u0005]\u0004\u0001\"\u0001\u0002r\u001dI\u0011\u0011\u0011\u0016\u0002\u0002#\u0005\u00111\u0011\u0004\tS)\n\t\u0011#\u0001\u0002\u0006\"1!M\nC\u0001\u0003\u001bC\u0011\"a$'#\u0003%\t!!%\u0003%\t+8m[3u'R|'/Y4f!J|'-\u001a\u0006\u0003W1\naa]3sm\u0016\u0014(\"A\u0017\u0002\u000b-\fgm[1\u0004\u0001M)\u0001\u0001\r\u001d<\u0003B\u0011\u0011GN\u0007\u0002e)\u00111\u0007N\u0001\u0005Y\u0006twMC\u00016\u0003\u0011Q\u0017M^1\n\u0005]\u0012$AB(cU\u0016\u001cG\u000f\u0005\u00022s%\u0011!H\r\u0002\t%Vtg.\u00192mKB\u0011AhP\u0007\u0002{)\u0011a\bL\u0001\b[\u0016$(/[2t\u0013\t\u0001UHA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkB\u0004\"AQ#\u000e\u0003\rS!\u0001\u0012\u0017\u0002\u000bU$\u0018\u000e\\:\n\u0005\u0019\u001b%a\u0002'pO\u001eLgnZ\u0001\u0007G>tg-[4\u0016\u0003%\u0003\"AS&\u000e\u0003)J!\u0001\u0014\u0016\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\bG>tg-[4!\u0003=!\u0018.\u001a:PE*,7\r^*u_J,W#\u0001)\u0011\u0005E3V\"\u0001*\u000b\u0005M#\u0016!B:u_J,'BA+-\u0003\u0011!\u0018.\u001a:\n\u0005]\u0013&a\u0004+jKJ|%M[3diN#xN]3\u0002!QLWM](cU\u0016\u001cGo\u0015;pe\u0016\u0004\u0013aC:uCJ$H\u000b\u001b:fC\u0012,\u0012a\u0017\t\u00039~k\u0011!\u0018\u0006\u0002=\u0006)1oY1mC&\u0011\u0001-\u0018\u0002\b\u0005>|G.Z1o\u00031\u0019H/\u0019:u)\"\u0014X-\u00193!\u0003\u0019a\u0014N\\5u}Q!A-\u001a4h!\tQ\u0005\u0001C\u0003H\u000f\u0001\u0007\u0011\nC\u0003O\u000f\u0001\u0007\u0001\u000bC\u0004Z\u000fA\u0005\t\u0019A.\u0002\u0019MDW\u000f\u001e3po:4E.Y4\u0016\u0003)\u0004\"a\u001b:\u000e\u00031T!!\u001c8\u0002\r\u0005$x.\\5d\u0015\ty\u0007/\u0001\u0006d_:\u001cWO\u001d:f]RT!!\u001d\u001b\u0002\tU$\u0018\u000e\\\u0005\u0003g2\u0014Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017!D:ikR$wn\u001e8GY\u0006<\u0007%A\tcs>\\WI\u001d:peJ\u000bG/\u001a(b[\u0016,\u0012a\u001e\t\u0003caL!!\u001f\u001a\u0003\rM#(/\u001b8h\u0003I\u0011\u0017p\\6FeJ|'OU1uK:\u000bW.\u001a\u0011\u0002/A,'/\\5tg&|g.\u0012:s_J\u0014\u0016\r^3OC6,\u0017\u0001\u00079fe6L7o]5p]\u0016\u0013(o\u001c:SCR,g*Y7fA\u0005)RO\\2mCN\u001c\u0018NZ5fI\u0016\u0013(o\u001c:SCR,\u0017AF;oG2\f7o]5gS\u0016$WI\u001d:peJ\u000bG/\u001a\u0011\u0002\u001f!,\u0017\r\u001c;isJ\u000bG/\u001a(b[\u0016\f\u0001\u0003[3bYRD\u0017PU1uK:\u000bW.\u001a\u0011\u0002\rQD'/Z1e+\t\t9\u0001\u0005\u0003\u0002\n\u0005mQBAA\u0006\u0015\r!\u0015Q\u0002\u0006\u0005\u0003\u001f\t\t\"\u0001\u0004d_6lwN\u001c\u0006\u0004[\u0005M!\u0002BA\u000b\u0003/\ta!\u00199bG\",'BAA\r\u0003\ry'oZ\u0005\u0005\u0003;\tYAA\u0006LC\u001a\\\u0017\r\u00165sK\u0006$\u0017A\u0003;ie\u0016\fGm\u0018\u0013fcR!\u00111EA\u0015!\ra\u0016QE\u0005\u0004\u0003Oi&\u0001B+oSRD\u0011\"a\u000b\u0014\u0003\u0003\u0005\r!a\u0002\u0002\u0007a$\u0013'A\u0004uQJ,\u0017\r\u001a\u0011\u0002\u0015\tLxn[#se>\u00148/\u0006\u0002\u00024A!\u0011QGA#\u001b\t\t9D\u0003\u0003\u0002:\u0005m\u0012\u0001B2pe\u0016T1APA\u001f\u0015\u0011\ty$!\u0011\u0002\re\fW.\\3s\u0015\t\t\u0019%A\u0002d_6LA!a\u0012\u00028\t)Q*\u001a;fe\u0006q!-_8l\u000bJ\u0014xN]:`I\u0015\fH\u0003BA\u0012\u0003\u001bB\u0011\"a\u000b\u0017\u0003\u0003\u0005\r!a\r\u0002\u0017\tLxn[#se>\u00148\u000fI\u0001\u0011a\u0016\u0014X.[:tS>tWI\u001d:peN\fA\u0003]3s[&\u001c8/[8o\u000bJ\u0014xN]:`I\u0015\fH\u0003BA\u0012\u0003/B\u0011\"a\u000b\u001a\u0003\u0003\u0005\r!a\r\u0002#A,'/\\5tg&|g.\u0012:s_J\u001c\b%\u0001\nv]\u000ed\u0017m]:jM&,G-\u0012:s_J\u001c\u0018AF;oG2\f7o]5gS\u0016$WI\u001d:peN|F%Z9\u0015\t\u0005\r\u0012\u0011\r\u0005\n\u0003Wa\u0012\u0011!a\u0001\u0003g\t1#\u001e8dY\u0006\u001c8/\u001b4jK\u0012,%O]8sg\u0002\nq\u0001[3bYRD\u00170A\u0006iK\u0006dG\u000f[=`I\u0015\fH\u0003BA\u0012\u0003WB\u0011\"a\u000b \u0003\u0003\u0005\r!a\r\u0002\u0011!,\u0017\r\u001c;is\u0002\nqa\u001d;beR,\b\u000f\u0006\u0002\u0002$\u0005A1\u000f[;uI><h.A\u0003qe>\u0014W-A\u0002sk:D3\u0001JA>!\r\t\u0014QP\u0005\u0004\u0003\u007f\u0012$\u0001C(wKJ\u0014\u0018\u000eZ3\u0002%\t+8m[3u'R|'/Y4f!J|'-\u001a\t\u0003\u0015\u001a\u001a2AJAD!\ra\u0016\u0011R\u0005\u0004\u0003\u0017k&AB!osJ+g\r\u0006\u0002\u0002\u0004\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"!a%+\u0007m\u000b)j\u000b\u0002\u0002\u0018B!\u0011\u0011TAR\u001b\t\tYJ\u0003\u0003\u0002\u001e\u0006}\u0015!C;oG\",7m[3e\u0015\r\t\t+X\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAS\u00037\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class BucketStorageProbe
implements Runnable,
KafkaMetricsGroup {
    private final KafkaConfig config;
    private final TierObjectStore tierObjectStore;
    private final boolean startThread;
    private final AtomicBoolean shutdownFlag;
    private final String byokErrorRateName;
    private final String permissionErrorRateName;
    private final String unclassifiedErrorRate;
    private final String healthyRateName;
    private KafkaThread thread;
    private Meter byokErrors;
    private Meter permissionErrors;
    private Meter unclassifiedErrors;
    private Meter healthy;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$3() {
        return BucketStorageProbe$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public <T> Gauge<T> newGauge(MetricName metricName, Gauge<T> metric) {
        return KafkaMetricsGroup.newGauge$(this, metricName, metric);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public void removeMetric(MetricName metricName) {
        KafkaMetricsGroup.removeMetric$(this, metricName);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private TierObjectStore tierObjectStore() {
        return this.tierObjectStore;
    }

    private boolean startThread() {
        return this.startThread;
    }

    private AtomicBoolean shutdownFlag() {
        return this.shutdownFlag;
    }

    private String byokErrorRateName() {
        return this.byokErrorRateName;
    }

    private String permissionErrorRateName() {
        return this.permissionErrorRateName;
    }

    private String unclassifiedErrorRate() {
        return this.unclassifiedErrorRate;
    }

    private String healthyRateName() {
        return this.healthyRateName;
    }

    private KafkaThread thread() {
        return this.thread;
    }

    private void thread_$eq(KafkaThread x$1) {
        this.thread = x$1;
    }

    private Meter byokErrors() {
        return this.byokErrors;
    }

    private void byokErrors_$eq(Meter x$1) {
        this.byokErrors = x$1;
    }

    private Meter permissionErrors() {
        return this.permissionErrors;
    }

    private void permissionErrors_$eq(Meter x$1) {
        this.permissionErrors = x$1;
    }

    private Meter unclassifiedErrors() {
        return this.unclassifiedErrors;
    }

    private void unclassifiedErrors_$eq(Meter x$1) {
        this.unclassifiedErrors = x$1;
    }

    private Meter healthy() {
        return this.healthy;
    }

    private void healthy_$eq(Meter x$1) {
        this.healthy = x$1;
    }

    public void startup() {
        this.byokErrors_$eq(this.newMeter(this.byokErrorRateName(), "error", TimeUnit.SECONDS, this.newMeter$default$4()));
        this.permissionErrors_$eq(this.newMeter(this.permissionErrorRateName(), "error", TimeUnit.SECONDS, this.newMeter$default$4()));
        this.healthy_$eq(this.newMeter(this.healthyRateName(), "error", TimeUnit.SECONDS, this.newMeter$default$4()));
        this.unclassifiedErrors_$eq(this.newMeter(this.unclassifiedErrorRate(), "error", TimeUnit.SECONDS, this.newMeter$default$4()));
        if (Predef$.MODULE$.Long2long(this.config().confluentConfig().tierBucketProbePeriodMs()) > 0L) {
            String nonDaemon_name = "BucketStorageProbe";
            this.thread_$eq(new KafkaThread(nonDaemon_name, (Runnable)this, false));
            if (this.startThread()) {
                this.thread().start();
                return;
            }
        }
    }

    public void shutdown() {
        this.removeMetric(this.byokErrorRateName(), this.removeMetric$default$2());
        this.removeMetric(this.permissionErrorRateName(), this.removeMetric$default$2());
        this.removeMetric(this.healthyRateName(), this.removeMetric$default$2());
        this.removeMetric(this.unclassifiedErrorRate(), this.removeMetric$default$2());
        this.shutdownFlag().set(true);
    }

    public void probe() {
        block6: {
            try {
                BucketHealthResult bucketHealthResult = this.tierObjectStore().checkBucketHealth();
                if (((Object)((Object)BucketHealthResult.BYOK)).equals((Object)bucketHealthResult)) {
                    this.byokErrors().mark();
                    break block6;
                }
                if (((Object)((Object)BucketHealthResult.HEALTHY)).equals((Object)bucketHealthResult)) {
                    this.healthy().mark();
                    break block6;
                }
                if (((Object)((Object)BucketHealthResult.PERMISSION)).equals((Object)bucketHealthResult)) {
                    this.permissionErrors().mark();
                    break block6;
                }
                if (((Object)((Object)BucketHealthResult.UNCLASSIFIED)).equals((Object)bucketHealthResult)) {
                    this.unclassifiedErrors().mark();
                    break block6;
                }
                throw new MatchError((Object)bucketHealthResult);
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed checking bucket.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            }
        }
    }

    @Override
    public void run() {
        do {
            this.probe();
            Thread.sleep(Predef$.MODULE$.Long2long(this.config().confluentConfig().tierBucketProbePeriodMs()));
        } while (!this.shutdownFlag().get());
    }

    public BucketStorageProbe(KafkaConfig config, TierObjectStore tierObjectStore, boolean startThread) {
        this.config = config;
        this.tierObjectStore = tierObjectStore;
        this.startThread = startThread;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.shutdownFlag = new AtomicBoolean(false);
        this.byokErrorRateName = "ByokErrorRate";
        this.permissionErrorRateName = "PermissionErrorRate";
        this.unclassifiedErrorRate = "UnclassifiedErrorRate";
        this.healthyRateName = "HealthyRate";
    }
}

