/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.statemachine.transitions;

import java.util.Date;
import kafka.restore.MessageEmitter;
import kafka.restore.messages.KafkaFetchFtpsResponse;
import kafka.restore.messages.RestoreFtpsRequest;
import kafka.restore.statemachine.api.Event;
import kafka.restore.statemachine.api.FiniteStateMachine;
import kafka.restore.statemachine.api.State;
import kafka.restore.statemachine.transitions.AbstractTransition;

public class PartitionFencedToFtpsFetchedTransition
extends AbstractTransition {
    public PartitionFencedToFtpsFetchedTransition(MessageEmitter messageEmitter) {
        super(messageEmitter);
    }

    @Override
    public State getSourceState() {
        return State.PARTITION_FENCED;
    }

    @Override
    public State getTargetState() {
        return State.FTPS_FETCHED;
    }

    public boolean handleEvent(FiniteStateMachine fsm, Event event) {
        KafkaFetchFtpsResponse response = (KafkaFetchFtpsResponse)event.getData("message_response");
        long restoreFrom = (Long)fsm.getMetadata("restore_from_timestamp");
        String ftpsFilePath = response.getFtpsFileName().get();
        fsm.addMetadata("ftps_file_path", ftpsFilePath);
        RestoreFtpsRequest request = new RestoreFtpsRequest(0, response.getTopic(), response.getPartition(), response.getFtpsFileName().get(), new Date(restoreFrom));
        LOGGER.debug(String.format("[%s-%d]: %s handled the event, %s in queue", response.getTopic(), response.getPartition(), this.getName(), request.name()));
        this.messageEmitter.submitRequest(request);
        return true;
    }
}

