/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.statemachine.transitions;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kafka.restore.MessageEmitter;
import kafka.restore.messages.ReconcileFtpsRequest;
import kafka.restore.messages.RestoreObjectsInStoreResponse;
import kafka.restore.operators.SegmentStateAndPath;
import kafka.restore.statemachine.api.Event;
import kafka.restore.statemachine.api.FiniteStateMachine;
import kafka.restore.statemachine.api.State;
import kafka.restore.statemachine.transitions.AbstractTransition;
import kafka.tier.state.SegmentState;

public class FtpsRepairedToSegmentsRepairedTransition
extends AbstractTransition {
    public FtpsRepairedToSegmentsRepairedTransition(MessageEmitter messageEmitter) {
        super(messageEmitter);
    }

    @Override
    public State getSourceState() {
        return State.FTPS_REPAIRED;
    }

    @Override
    public State getTargetState() {
        return State.SEGMENTS_REPAIRED;
    }

    public boolean handleEvent(FiniteStateMachine fsm, Event event) {
        Object responseObject = event.getData("message_response");
        if (!(responseObject instanceof RestoreObjectsInStoreResponse)) {
            return false;
        }
        RestoreObjectsInStoreResponse response = (RestoreObjectsInStoreResponse)event.getData("message_response");
        Set<UUID> failedSegmentIds = response.getFailedSegmentIds();
        ReconcileFtpsRequest request = null;
        if (failedSegmentIds.size() == 0) {
            return false;
        }
        long restoreFrom = (Long)fsm.getMetadata("restore_from_timestamp");
        Map restoreSegmentStateMap = (Map)fsm.getMetadata("restore_segment_map");
        Map<UUID, SegmentState> reconcileSegmentStateMap = failedSegmentIds.stream().collect(Collectors.toMap(id -> id, id -> ((SegmentStateAndPath)restoreSegmentStateMap.get(id)).segmentState()));
        request = new ReconcileFtpsRequest(0, response.getTopic(), response.getPartition(), (String)fsm.getMetadata("ftps_file_path"), restoreFrom, reconcileSegmentStateMap);
        LOGGER.debug(String.format("[%s-%d]: %s handled the event, %s in queue", response.getTopic(), response.getPartition(), this.getName(), request.name()));
        this.messageEmitter.submitRequest(request);
        return true;
    }
}

