/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.statemachine.transitions;

import java.io.File;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import kafka.restore.MessageEmitter;
import kafka.restore.RestoreConfig;
import kafka.restore.configmap.NodeConfig;
import kafka.restore.messages.KafkaForceRestoreRequest;
import kafka.restore.messages.UploadFtpsToStoreResponse;
import kafka.restore.operators.OperatorUtil;
import kafka.restore.statemachine.api.Event;
import kafka.restore.statemachine.api.FiniteStateMachine;
import kafka.restore.statemachine.api.State;
import kafka.restore.statemachine.transitions.AbstractTransition;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.Header;
import kafka.utils.checksum.CheckedFileIO;

public class FtpsReconciledToFtpsUploadedTransition
extends AbstractTransition {
    public FtpsReconciledToFtpsUploadedTransition(MessageEmitter messageEmitter) {
        super(messageEmitter);
    }

    @Override
    public State getSourceState() {
        return State.FTPS_RECONCILED;
    }

    @Override
    public State getTargetState() {
        return State.FTPS_UPLOADED;
    }

    public boolean handleEvent(FiniteStateMachine fsm, Event event) {
        Object responseObject = event.getData("message_response");
        if (!(responseObject instanceof UploadFtpsToStoreResponse)) {
            return false;
        }
        UploadFtpsToStoreResponse response = (UploadFtpsToStoreResponse)event.getData("message_response");
        int messageId = 0;
        String topic = response.getTopic();
        int partition = response.getPartition();
        NodeConfig broker = (NodeConfig)fsm.getMetadata("partition_leader");
        String contentHash = "";
        long logStartOffset = 0L;
        long logEndOffset = 0L;
        File ftps = new File((String)fsm.getMetadata("ftps_file_path"));
        if (!RestoreConfig.localMode) {
            try (CheckedFileIO fileChannel = CheckedFileIO.open(ftps.toPath(), StandardOpenOption.READ);){
                Optional<Header> headerOpt = FileTierPartitionState.readHeader(fileChannel);
                if (!headerOpt.isPresent()) {
                    throw new Exception("Header is not present for TierPartitionState being recovered");
                }
                Header header = headerOpt.get();
                contentHash = OperatorUtil.computeMd5(fileChannel);
                logStartOffset = header.startOffset();
                logEndOffset = header.endOffset();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }
        fsm.addMetadata("ftps_log_start_offset", logStartOffset);
        fsm.addMetadata("ftps_log_end_offset", logEndOffset);
        fsm.addMetadata("ftps_content_hash", contentHash);
        KafkaForceRestoreRequest request = new KafkaForceRestoreRequest(messageId, topic, partition, broker, logStartOffset, logEndOffset, contentHash);
        LOGGER.debug(String.format("[%s-%d]: %s handled the event, %s in queue", response.getTopic(), response.getPartition(), this.getName(), request.name()));
        this.messageEmitter.submitRequest(request);
        return true;
    }
}

