/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.schedulers;

import kafka.restore.RestoreConfig;
import kafka.restore.RestoreMetricsManager;
import kafka.restore.messages.KafkaFetchFtpsRequest;
import kafka.restore.messages.KafkaRequest;
import kafka.restore.messages.KafkaTierPartitionStatusRequest;
import kafka.restore.messages.KafkaValidateLogRangeRequest;
import kafka.restore.messages.MessageResult;
import kafka.restore.messages.MessageStatusCode;
import kafka.restore.schedulers.AsyncServiceSchedulerResultsReceiver;
import kafka.restore.schedulers.KafkaConnectionPoolImpl;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DryrunKafkaConnectionPoolImpl
extends KafkaConnectionPoolImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(DryrunKafkaConnectionPoolImpl.class);

    public DryrunKafkaConnectionPoolImpl(AsyncServiceSchedulerResultsReceiver resultsReceiver, int poolSize, String ftpsDirPath, RestoreMetricsManager metricsManager, Time time) {
        super(resultsReceiver, poolSize, ftpsDirPath, metricsManager, time);
    }

    @Override
    protected void submitKafkaEventRequest(KafkaRequest request) {
        if (RestoreConfig.dryRun || RestoreConfig.localMode) {
            LOGGER.debug(String.format("[%s-%s]: dry run: %s", request.getTopic(), request.getPartition(), request.name()));
            this.reportKafkaResponse(request, MessageStatusCode.OK, MessageResult.SUCCESS);
        } else {
            super.submitKafkaEventRequest(request);
        }
    }

    @Override
    protected void submitFetchFtpsRequest(KafkaFetchFtpsRequest request) {
        if (RestoreConfig.localMode) {
            LOGGER.debug(String.format("[%s-%s]: local mode: %s", request.getTopic(), request.getPartition(), request.name()));
            this.reportFetchFtpsResponse(request, MessageStatusCode.OK, MessageResult.SUCCESS, "/tmp/00000000000000000000.tierstate");
        } else {
            super.submitFetchFtpsRequest(request);
        }
    }

    @Override
    protected void submitTierPartitionStatusRequest(KafkaTierPartitionStatusRequest request) {
        if (RestoreConfig.dryRun || RestoreConfig.localMode) {
            LOGGER.debug(String.format("[%s-%s]: dry run: %s", request.getTopic(), request.getPartition(), request.name()));
            this.reportKafkaResponse(request, MessageStatusCode.OK, MessageResult.SUCCESS);
        } else {
            super.submitTierPartitionStatusRequest(request);
        }
    }

    @Override
    protected void submitKafkaValidateLogRangeRequest(KafkaValidateLogRangeRequest request) {
        if (RestoreConfig.dryRun || RestoreConfig.localMode) {
            LOGGER.debug(String.format("[%s-%s]: dry run: %s", request.getTopic(), request.getPartition(), request.name()));
            this.reportKafkaResponse(request, MessageStatusCode.OK, MessageResult.SUCCESS);
        } else {
            super.submitKafkaValidateLogRangeRequest(request);
        }
    }
}

