/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.schedulers;

import java.util.HashMap;
import java.util.UUID;
import kafka.restore.RestoreConfig;
import kafka.restore.RestorePartitionOperatorFactory;
import kafka.restore.messages.MessageRequest;
import kafka.restore.messages.MessageResult;
import kafka.restore.messages.MessageStatusCode;
import kafka.restore.messages.ReconcileFtpsRequest;
import kafka.restore.messages.ReconcileFtpsResponse;
import kafka.restore.messages.RestoreFtpsRequest;
import kafka.restore.messages.RestoreFtpsResponse;
import kafka.restore.operators.SegmentStateAndPath;
import kafka.restore.schedulers.AsyncServiceSchedulerResultsReceiver;
import kafka.restore.schedulers.AsyncTaskScheduler;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.SegmentState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DryrunAsyncTaskScheduler
extends AsyncTaskScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DryrunAsyncTaskScheduler.class);

    public DryrunAsyncTaskScheduler(AsyncServiceSchedulerResultsReceiver resultsReceiver, int poolSize, RestorePartitionOperatorFactory restoreOperatorFactory) {
        super(resultsReceiver, poolSize, restoreOperatorFactory);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void processRequestFromRequestQueue(MessageRequest request) {
        if (RestoreConfig.localMode) {
            LOGGER.debug(String.format("[%s-%s]: local mode: %s", request.getTopic(), request.getPartition(), request.name()));
            if (RestoreFtpsRequest.class.equals(request.getClass())) {
                RestoreFtpsRequest restoreFtpsRequest = (RestoreFtpsRequest)request;
                HashMap<UUID, SegmentStateAndPath> segmentPathsMap = new HashMap<UUID, SegmentStateAndPath>();
                segmentPathsMap.put(UUID.randomUUID(), new SegmentStateAndPath(null, this.fakeSegmentState(), "/fakePath1/fakeObject1.segment"));
                segmentPathsMap.put(UUID.randomUUID(), new SegmentStateAndPath(null, this.fakeSegmentState(), "/fakePath2/fakeObject2.segment"));
                RestoreFtpsResponse response = new RestoreFtpsResponse(0, restoreFtpsRequest.getTopic(), restoreFtpsRequest.getPartition(), restoreFtpsRequest.getUuid(), MessageStatusCode.OK, MessageResult.SUCCESS, segmentPathsMap);
                this.getResultsReceiver().reportServiceSchedulerResponse(response);
                return;
            } else {
                if (!ReconcileFtpsRequest.class.equals(request.getClass())) throw new RuntimeException("Illegal request type " + request.getClass() + " was added to request queue");
                ReconcileFtpsRequest reconcileFtpsRequest = (ReconcileFtpsRequest)request;
                ReconcileFtpsResponse response = new ReconcileFtpsResponse(0, reconcileFtpsRequest.getTopic(), reconcileFtpsRequest.getPartition(), reconcileFtpsRequest.getUuid(), 0, MessageStatusCode.OK, MessageResult.SUCCESS);
                this.getResultsReceiver().reportServiceSchedulerResponse(response);
            }
            return;
        } else {
            super.processRequestFromRequestQueue(request);
        }
    }

    private SegmentState fakeSegmentState() {
        return new SegmentState(0, UUID.randomUUID(), 0L, 0L, 0L, 0L, 0L, 0, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, true, true, true, TierUploadType.Archive, null, TierObjectMetadata.State.INVALID, 0L);
    }
}

