/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.schedulers;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletableFutureRetryer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompletableFutureRetryer.class);
    private ThreadPoolExecutor executor;
    private Duration waitBetween;

    public CompletableFutureRetryer(ThreadPoolExecutor executor, Duration waitBetween) {
        this.executor = executor;
        this.waitBetween = waitBetween;
    }

    public <T> CompletableFuture<T> withRetries(Supplier<CompletableFuture<T>> attempter, Predicate<Throwable> shouldRetry, int attempts) {
        CompletableFuture<T> firstAttempt = attempter.get();
        return this.flatten((CompletableFuture<CompletableFuture<T>>)((CompletableFuture)firstAttempt.thenApply(CompletableFuture::completedFuture)).exceptionally(throwable -> this.retry(attempter, 1, (Throwable)throwable, shouldRetry, attempts)));
    }

    private <T> CompletableFuture<T> retry(Supplier<CompletableFuture<T>> attempter, int attemptsSoFar, Throwable throwable, Predicate<Throwable> shouldRetry, int maxAttempts) {
        int nextAttempt = attemptsSoFar + 1;
        if (nextAttempt > maxAttempts || !shouldRetry.test(throwable.getCause())) {
            LOGGER.warn("exhaust retry, completed exceptionally: " + throwable.getMessage(), throwable);
            return this.failedFuture(throwable);
        }
        try {
            LOGGER.debug("retrying: #" + attemptsSoFar + ", sleeping " + this.waitBetween.toMillis() + " ms before retrying");
            Thread.sleep(this.waitBetween.toMillis());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.flatten((CompletableFuture<CompletableFuture<T>>)((CompletableFuture)this.flatten(CompletableFuture.supplyAsync(attempter, this.executor)).thenApply(CompletableFuture::completedFuture)).exceptionally(nextThrowable -> this.retry(attempter, nextAttempt, (Throwable)nextThrowable, shouldRetry, maxAttempts)));
    }

    private <T> CompletableFuture<T> flatten(CompletableFuture<CompletableFuture<T>> completableCompletable) {
        return completableCompletable.thenCompose(Function.identity());
    }

    private <U> CompletableFuture<U> failedFuture(Throwable ex) {
        CompletableFuture completableFuture = new CompletableFuture();
        completableFuture.completeExceptionally(ex);
        return completableFuture;
    }
}

