/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kafka.restore.configmap.PartitionConfig;
import kafka.restore.configmap.RestoreTopicListConfig;
import kafka.restore.configmap.TopicConfig;
import kafka.restore.db.Job;
import kafka.restore.db.PartitionRestoreContext;
import kafka.restore.db.RestoreDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    public static void loadPartitionsIntoRestoreDB(File partitionFile, RestoreDB restoreDB) {
        Utils.loadPartitionsIntoRestoreDB(partitionFile, restoreDB, null);
    }

    public static void loadPartitionsIntoRestoreDB(File partitionFile, RestoreDB restoreDB, Set<String> topics) {
        Job job = Utils.loadTopicPartitions(partitionFile, topics);
        restoreDB.getJobs().add(job);
    }

    public static Job loadTopicPartitions(File partitionFile, Set<String> topics) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
        FileInputStream inputStream = null;
        Job job = new Job();
        try {
            inputStream = new FileInputStream(partitionFile);
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Partition file not found: " + partitionFile.getAbsolutePath() + ", return empty job");
            return job;
        }
        Map configMap = (Map)yaml.load((InputStream)inputStream);
        RestoreTopicListConfig topicListConfig = RestoreTopicListConfig.fromMap(configMap);
        List<TopicConfig> topicConfigList = topicListConfig.getTopicConfigs();
        try {
            if (topics != null && topics.size() > 0) {
                topicConfigList = topicConfigList.stream().filter(tc -> topics.contains(tc.getName())).collect(Collectors.toList());
            }
            for (TopicConfig topicConfig : topicConfigList) {
                String topicName = topicConfig.getName();
                long timestamp = topicConfig.getFromTimestamp();
                for (PartitionConfig partitionConfig : topicConfig.getPartitionConfigs()) {
                    PartitionRestoreContext partitionCtx = new PartitionRestoreContext(topicName, partitionConfig, timestamp, PartitionRestoreContext.RestoreStatus.NOT_STARTED, PartitionRestoreContext.RestoreState.NOT_STARTED);
                    job.addPartitionRestoreContext(partitionCtx);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to load partitions from file: %s", (Object)ex.getMessage());
        }
        return job;
    }

    public static boolean isRestoreDBEmpty(RestoreDB db) {
        return db.getJobs() == null || db.getJobs().size() == 0;
    }
}

