/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.db;

import java.util.HashMap;
import java.util.Map;
import kafka.restore.db.PartitionRestoreContext;
import org.apache.kafka.common.TopicPartition;

public class Job {
    public int id;
    public long startTime;
    public long endTime;
    public int version;
    public JobStatus status;
    public int partitionError;
    public Map<TopicPartition, PartitionRestoreContext> partitionRestoreContextMap = new HashMap<TopicPartition, PartitionRestoreContext>();

    public Job() {
        this.status = JobStatus.NOT_STARTED;
    }

    public synchronized void addPartitionRestoreContext(PartitionRestoreContext partitionRestoreContext) {
        TopicPartition tp = new TopicPartition(partitionRestoreContext.topic, partitionRestoreContext.partitionConfig.getPartition());
        this.partitionRestoreContextMap.put(tp, partitionRestoreContext);
    }

    public int getPartitionCount() {
        return this.partitionRestoreContextMap.size();
    }

    public Map<PartitionRestoreContext.RestoreStatus, Integer> partitionRestoreStatusMap() {
        HashMap<PartitionRestoreContext.RestoreStatus, Integer> restoreStatusMap = new HashMap<PartitionRestoreContext.RestoreStatus, Integer>();
        for (PartitionRestoreContext pctx : this.partitionRestoreContextMap.values()) {
            PartitionRestoreContext.RestoreStatus status = pctx.status;
            restoreStatusMap.put(status, restoreStatusMap.getOrDefault((Object)status, 0) + 1);
        }
        return restoreStatusMap;
    }

    public boolean isDone() {
        return this.status == JobStatus.COMPLETE || this.status == JobStatus.ABORT || this.status == JobStatus.ERROR;
    }

    public static enum JobStatus {
        NOT_STARTED,
        IN_PROGRESS,
        ERROR,
        PAUSE,
        ABORT,
        COMPLETE;

    }
}

