/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.configmap;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kafka.restore.configmap.NodeConfig;

public class PartitionConfig {
    private int partition;
    private NodeConfig leader;
    private List<NodeConfig> replicas;

    public PartitionConfig() {
        this.replicas = new ArrayList<NodeConfig>();
    }

    public PartitionConfig(int partition, NodeConfig leader) {
        this(partition, leader, new ArrayList<NodeConfig>());
    }

    public PartitionConfig(int partition, NodeConfig leader, List<NodeConfig> replicas) {
        this.partition = partition;
        this.leader = leader;
        this.replicas = replicas;
    }

    public void addReplica(NodeConfig node) {
        this.replicas.add(node);
    }

    public int getPartition() {
        return this.partition;
    }

    public void setPartition(int partition) {
        this.partition = partition;
    }

    public NodeConfig getLeader() {
        return this.leader;
    }

    public void setLeader(NodeConfig leader) {
        this.leader = leader;
    }

    public List<NodeConfig> getReplicas() {
        return this.replicas;
    }

    public void setReplicas(List<NodeConfig> replicas) {
        this.replicas = replicas;
    }

    public static PartitionConfig fromMap(Map<String, Object> map) {
        PartitionConfig partitionConfig = new PartitionConfig();
        if (map.containsKey("leader")) {
            partitionConfig.leader = NodeConfig.fromMap((Map)map.get("leader"));
        }
        if (map.containsKey("partition")) {
            partitionConfig.partition = (Integer)map.get("partition");
        }
        if (map.containsKey("replicas")) {
            List replicaList = (List)map.get("replicas");
            for (Object replica : replicaList) {
                partitionConfig.replicas.add(NodeConfig.fromMap((Map)replica));
            }
        }
        return partitionConfig;
    }
}

