/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.configmap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import kafka.restore.configmap.NodeConfig;
import kafka.restore.configmap.PartitionConfig;
import kafka.restore.configmap.RestoreTopicListConfig;
import kafka.restore.configmap.TopicConfig;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigResource;

public class ConfigmapUtil {
    public static final String CLEANUP_POLICY = "cleanup.policy";
    public static final String RETENTION_MS = "retention.ms";
    public static final String COMPACT = "compact";

    public static Map<ConfigResource, Config> describeConfigs(AdminClient adminClient, Set<String> topics) throws ExecutionException, InterruptedException {
        ArrayList<ConfigResource> crs = new ArrayList<ConfigResource>();
        for (String topic : topics) {
            crs.add(new ConfigResource(ConfigResource.Type.TOPIC, topic));
        }
        DescribeConfigsResult configsResult = adminClient.describeConfigs(crs);
        Map allConfigs = (Map)configsResult.all().get();
        return allConfigs;
    }

    public static RestoreTopicListConfig buildRestorePartitionConfig(AdminClient adminClient, long fromTimestamp, Set<String> topics) throws ExecutionException, InterruptedException {
        if (topics == null || topics.size() == 0) {
            topics = (Set)adminClient.listTopics(new ListTopicsOptions().listInternal(false)).names().get();
        }
        Map<ConfigResource, Config> topicConfigs = ConfigmapUtil.describeConfigs(adminClient, topics);
        Map topicDescriptions = (Map)adminClient.describeTopics(topics).allTopicNames().get();
        RestoreTopicListConfig restoreTopicListConfig = new RestoreTopicListConfig();
        for (ConfigResource cr : topicConfigs.keySet()) {
            Config config = topicConfigs.get(cr);
            Iterator propertyIterator = config.entries().iterator();
            boolean isCompactTopic = false;
            long effectFromTimestamp = fromTimestamp;
            while (propertyIterator.hasNext()) {
                long retentionMs;
                ConfigEntry property = (ConfigEntry)propertyIterator.next();
                if (property.name().equals(CLEANUP_POLICY) && property.value().contains(COMPACT)) {
                    isCompactTopic = true;
                    break;
                }
                if (!property.name().equals(RETENTION_MS) || (retentionMs = Long.parseLong(property.value())) <= 0L) continue;
                effectFromTimestamp = Math.max(effectFromTimestamp, System.currentTimeMillis() - retentionMs);
            }
            if (isCompactTopic) continue;
            TopicConfig topicConfig = new TopicConfig(cr.name(), effectFromTimestamp);
            TopicDescription topicDescription = (TopicDescription)topicDescriptions.get(cr.name());
            for (TopicPartitionInfo tpi : topicDescription.partitions()) {
                NodeConfig leader = new NodeConfig(tpi.leader().id(), tpi.leader().host(), tpi.leader().port());
                PartitionConfig partitionConfig = new PartitionConfig(tpi.partition(), leader);
                for (Node replica : tpi.replicas()) {
                    partitionConfig.addReplica(new NodeConfig(replica.id(), replica.host(), replica.port()));
                }
                topicConfig.addPartition(partitionConfig);
            }
            restoreTopicListConfig.addTopicConfig(topicConfig);
        }
        return restoreTopicListConfig;
    }
}

