/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.log.MergedLog$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.KafkaNetworkChannel;
import kafka.raft.KafkaRaftManager$;
import kafka.raft.MetadataLogConfig$;
import kafka.raft.RaftManager;
import kafka.raft.TimingWheelExpirationService;
import kafka.server.KafkaConfig;
import kafka.server.MetaProperties;
import kafka.utils.KafkaScheduler;
import kafka.utils.KafkaScheduler$;
import kafka.utils.Logging;
import kafka.utils.ShutdownableThread;
import kafka.utils.timer.SystemTimer;
import kafka.utils.timer.SystemTimer$;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.ExpirationService;
import org.apache.kafka.raft.FileBasedStateStore;
import org.apache.kafka.raft.KafkaRaftClient;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.NetworkChannel;
import org.apache.kafka.raft.QuorumStateStore;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.raft.RaftRequest;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.server.common.serialization.RecordSerde;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\r\rr!\u0002\u001f>\u0011\u0003\u0011e!\u0002#>\u0011\u0003)\u0005\"\u0002'\u0002\t\u0003ie\u0001\u0002(\u0002\u0001=C\u0001BV\u0002\u0003\u0002\u0003\u0006Ia\u0016\u0005\t[\u000e\u0011\t\u0011)A\u0005]\")Aj\u0001C\u0001s\"9\u0011QA\u0002\u0005B\u0005\u001d\u0001bBA\b\u0007\u0011\u0005\u0013\u0011\u0003\u0005\b\u00033\u0019A\u0011IA\u000e\u0011\u001d\ti\"\u0001C\u0005\u0003?1Q\u0001R\u001f\u0001\u0003sA!\"a\u0014\f\u0005\u000b\u0007I\u0011AA)\u0011)\tyf\u0003B\u0001B\u0003%\u00111\u000b\u0005\u000b\u0003CZ!\u0011!Q\u0001\n\u0005\r\u0004BCA5\u0017\t\u0005\t\u0015!\u0003\u0002l!Q\u0011QP\u0006\u0003\u0002\u0003\u0006I!a \t\u0015\u0005%5B!A!\u0002\u0013\tY\t\u0003\u0006\u0002\u0012.\u0011\t\u0011)A\u0005\u0003'C!\"!(\f\u0005\u0003\u0005\u000b\u0011BAP\u0011)\tIk\u0003B\u0001B\u0003%\u00111\u0016\u0005\u000b\u0003c[!Q1A\u0005\u0002\u0005M\u0006BCA|\u0017\t\u0005\t\u0015!\u0003\u00026\"1Aj\u0003C\u0001\u0003sD\u0011Ba\u0004\f\u0005\u0004%IA!\u0005\t\u0011\t}1\u0002)A\u0005\u0005'A\u0011B!\t\f\u0005\u0004%\tAa\t\t\u0011\tE2\u0002)A\u0005\u0005KA\u0011Ba\r\f\u0005\u0004%IA!\u000e\t\u0011\tu2\u0002)A\u0005\u0005oA\u0001\"\\\u0006C\u0002\u0013%!q\b\u0005\b\u0005\u0003Z\u0001\u0015!\u0003o\u0011%\u0011\u0019e\u0003b\u0001\n\u0013\u0011)\u0005\u0003\u0005\u0003N-\u0001\u000b\u0011\u0002B$\u0011%\u0011ye\u0003b\u0001\n\u0013\u0011\t\u0006\u0003\u0005\u0003Z-\u0001\u000b\u0011\u0002B*\u0011%\u0011Yf\u0003b\u0001\n\u0013\u0011i\u0006\u0003\u0005\u0003`-\u0001\u000b\u0011BA\u0011\u0011%\u0011\tg\u0003b\u0001\n\u0003\u0012\u0019\u0007\u0003\u0005\u0003l-\u0001\u000b\u0011\u0002B3\u0011%\u0011ig\u0003b\u0001\n\u0013\u0011y\u0007\u0003\u0005\u0003x-\u0001\u000b\u0011\u0002B9\u0011%\u0011Ih\u0003b\u0001\n\u0013\u0011Y\b\u0003\u0005\u0003\n.\u0001\u000b\u0011\u0002B?\u0011%\u0011Yi\u0003b\u0001\n\u0013\u0011i\t\u0003\u0005\u0003\u0016.\u0001\u000b\u0011\u0002BH\u0011!16B1A\u0005B\t]\u0005\u0002\u0003BN\u0017\u0001\u0006IA!'\t\u0013\tu5B1A\u0005\n\t}\u0005\u0002\u0003BW\u0017\u0001\u0006IA!)\t\u000f\t=6\u0002\"\u0001\u0002\b!9!\u0011W\u0006\u0005\u0002\u0005\u001d\u0001b\u0002BZ\u0017\u0011\u0005#Q\u0017\u0005\b\u0005\u0013\\A\u0011\tBf\u0011\u001d\u0011Ip\u0003C\u0005\u0005wDqA!@\f\t\u0013\u0011y\u0010C\u0004\u0004\u0002-!Iaa\u0001\t\u000f\r\u00151\u0002\"\u0003\u0004\b!91qB\u0006\u0005\n\rE\u0001bBB\r\u0017\u0011\u000531D\u0001\u0011\u0017\u000647.\u0019*bMRl\u0015M\\1hKJT!AP \u0002\tI\fg\r\u001e\u0006\u0002\u0001\u0006)1.\u00194lC\u000e\u0001\u0001CA\"\u0002\u001b\u0005i$\u0001E&bM.\f'+\u00194u\u001b\u0006t\u0017mZ3s'\t\ta\t\u0005\u0002H\u00156\t\u0001JC\u0001J\u0003\u0015\u00198-\u00197b\u0013\tY\u0005J\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\t\u0013ABU1gi&{G\u000b\u001b:fC\u0012\u001c\"a\u0001)\u0011\u0005E#V\"\u0001*\u000b\u0005M{\u0014!B;uS2\u001c\u0018BA+S\u0005I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\u0002\r\rd\u0017.\u001a8ua\tAF\rE\u0002ZA\nl\u0011A\u0017\u0006\u0003}mS!\u0001\u0011/\u000b\u0005us\u0016AB1qC\u000eDWMC\u0001`\u0003\ry'oZ\u0005\u0003Cj\u0013qbS1gW\u0006\u0014\u0016M\u001a;DY&,g\u000e\u001e\t\u0003G\u0012d\u0001\u0001B\u0005f\t\u0005\u0005\t\u0011!B\u0001M\n\u0019q\fJ\u0019\u0012\u0005\u001dT\u0007CA$i\u0013\tI\u0007JA\u0004O_RD\u0017N\\4\u0011\u0005\u001d[\u0017B\u00017I\u0005\r\te._\u0001\u0011i\"\u0014X-\u00193OC6,\u0007K]3gSb\u0004\"a\u001c<\u000f\u0005A$\bCA9I\u001b\u0005\u0011(BA:B\u0003\u0019a$o\\8u}%\u0011Q\u000fS\u0001\u0007!J,G-\u001a4\n\u0005]D(AB*ue&twM\u0003\u0002v\u0011R!!\u0010`A\u0002!\tY8!D\u0001\u0002\u0011\u00151f\u00011\u0001~a\rq\u0018\u0011\u0001\t\u00043\u0002|\bcA2\u0002\u0002\u0011IQ\r`A\u0001\u0002\u0003\u0015\tA\u001a\u0005\u0006[\u001a\u0001\rA\\\u0001\u0007I><vN]6\u0015\u0005\u0005%\u0001cA$\u0002\f%\u0019\u0011Q\u0002%\u0003\tUs\u0017\u000e^\u0001\u0011S:LG/[1uKNCW\u000f\u001e3po:$\"!a\u0005\u0011\u0007\u001d\u000b)\"C\u0002\u0002\u0018!\u0013qAQ8pY\u0016\fg.A\u0005jgJ+hN\\5oOV\u0011\u00111C\u0001\u0013GJ,\u0017\r^3M_\u001e$\u0015N]3di>\u0014\u0018\u0010\u0006\u0004\u0002\"\u0005E\u0012Q\u0007\t\u0005\u0003G\ti#\u0004\u0002\u0002&)!\u0011qEA\u0015\u0003\tIwN\u0003\u0002\u0002,\u0005!!.\u0019<b\u0013\u0011\ty#!\n\u0003\t\u0019KG.\u001a\u0005\b\u0003gQ\u0001\u0019AA\u0011\u0003\u0019awn\u001a#je\"1\u0011q\u0007\u0006A\u00029\f!\u0002\\8h\t&\u0014h*Y7f+\u0011\tY$!\u0012\u0014\r-1\u0015QHA%!\u0015\u0019\u0015qHA\"\u0013\r\t\t%\u0010\u0002\f%\u00064G/T1oC\u001e,'\u000fE\u0002d\u0003\u000b\"a!a\u0012\f\u0005\u00041'!\u0001+\u0011\u0007E\u000bY%C\u0002\u0002NI\u0013q\u0001T8hO&tw-\u0001\bnKR\f\u0007K]8qKJ$\u0018.Z:\u0016\u0005\u0005M\u0003\u0003BA+\u00037j!!a\u0016\u000b\u0007\u0005es(\u0001\u0004tKJ4XM]\u0005\u0005\u0003;\n9F\u0001\bNKR\f\u0007K]8qKJ$\u0018.Z:\u0002\u001f5,G/\u0019)s_B,'\u000f^5fg\u0002\naaY8oM&<\u0007\u0003BA+\u0003KJA!a\u001a\u0002X\tY1*\u00194lC\u000e{gNZ5h\u0003-\u0011XmY8sIN+'\u000fZ3\u0011\r\u00055\u0014\u0011PA\"\u001b\t\tyG\u0003\u0003\u0002r\u0005M\u0014!D:fe&\fG.\u001b>bi&|gN\u0003\u0003\u0002v\u0005]\u0014AB2p[6|gNC\u0002\u0002ZmKA!a\u001f\u0002p\tY!+Z2pe\u0012\u001cVM\u001d3f\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004B!!!\u0002\u00066\u0011\u00111\u0011\u0006\u0004\u0003kZ\u0016\u0002BAD\u0003\u0007\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\u0004u_BL7-\u00133\u0011\t\u0005\u0005\u0015QR\u0005\u0005\u0003\u001f\u000b\u0019I\u0001\u0003Vk&$\u0017\u0001\u0002;j[\u0016\u0004B!!&\u0002\u001a6\u0011\u0011q\u0013\u0006\u0004'\u0006\r\u0015\u0002BAN\u0003/\u0013A\u0001V5nK\u00069Q.\u001a;sS\u000e\u001c\b\u0003BAQ\u0003Kk!!a)\u000b\t\u0005u\u00151Q\u0005\u0005\u0003O\u000b\u0019KA\u0004NKR\u0014\u0018nY:\u0002'QD'/Z1e\u001d\u0006lW\r\u0015:fM&Dx\n\u001d;\u0011\t\u001d\u000biK\\\u0005\u0004\u0003_C%AB(qi&|g.\u0001\u000fd_:$(o\u001c7mKJ\fVo\u001c:v[Z{G/\u001a:t\rV$XO]3\u0016\u0005\u0005U\u0006CBA\\\u0003\u0003\f)-\u0004\u0002\u0002:*!\u00111XA_\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003\u007f\u000bI#\u0001\u0003vi&d\u0017\u0002BAb\u0003s\u0013\u0011cQ8na2,G/\u00192mK\u001a+H/\u001e:f!!\t9-!3\u0002N\u0006eWBAA_\u0013\u0011\tY-!0\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002P\u0006UWBAAi\u0015\u0011\t\u0019.!\u000b\u0002\t1\fgnZ\u0005\u0005\u0003/\f\tNA\u0004J]R,w-\u001a:\u0011\t\u0005m\u0017\u0011\u001f\b\u0005\u0003;\fiO\u0004\u0003\u0002`\u0006-h\u0002BAq\u0003StA!a9\u0002h:\u0019\u0011/!:\n\u0003}K!!\u00180\n\u0005\u0001c\u0016B\u0001 \\\u0013\r\tyOW\u0001\u000b%\u00064GoQ8oM&<\u0017\u0002BAz\u0003k\u00141\"\u00113ee\u0016\u001c8o\u00159fG*\u0019\u0011q\u001e.\u0002;\r|g\u000e\u001e:pY2,'/U;peVlgk\u001c;feN4U\u000f^;sK\u0002\"B#a?\u0002~\u0006}(\u0011\u0001B\u0002\u0005\u000b\u00119A!\u0003\u0003\f\t5\u0001\u0003B\"\f\u0003\u0007Bq!a\u0014\u0018\u0001\u0004\t\u0019\u0006C\u0004\u0002b]\u0001\r!a\u0019\t\u000f\u0005%t\u00031\u0001\u0002l!9\u0011QP\fA\u0002\u0005}\u0004bBAE/\u0001\u0007\u00111\u0012\u0005\b\u0003#;\u0002\u0019AAJ\u0011\u001d\tij\u0006a\u0001\u0003?Cq!!+\u0018\u0001\u0004\tY\u000bC\u0004\u00022^\u0001\r!!.\u0002\r\rdwn]3e+\t\u0011\u0019\u0002\u0005\u0003\u0003\u0016\tmQB\u0001B\f\u0015\u0011\u0011I\"!/\u0002\r\u0005$x.\\5d\u0013\u0011\u0011iBa\u0006\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003\u001d\u0019Gn\\:fI\u0002\n1\"\u00199j-\u0016\u00148/[8ogV\u0011!Q\u0005\t\u0005\u0005O\u0011i#\u0004\u0002\u0003*)\u0019!1F.\u0002\u000f\rd\u0017.\u001a8ug&!!q\u0006B\u0015\u0005-\t\u0005/\u001b,feNLwN\\:\u0002\u0019\u0005\u0004\u0018NV3sg&|gn\u001d\u0011\u0002\u0015I\fg\r^\"p]\u001aLw-\u0006\u0002\u00038A\u0019\u0011L!\u000f\n\u0007\tm\"L\u0001\u0006SC\u001a$8i\u001c8gS\u001e\f1B]1gi\u000e{gNZ5hAU\ta.A\tuQJ,\u0017\r\u001a(b[\u0016\u0004&/\u001a4jq\u0002\n!\u0002\\8h\u0007>tG/\u001a=u+\t\u00119\u0005\u0005\u0003\u0002\u0016\n%\u0013\u0002\u0002B&\u0003/\u0013!\u0002T8h\u0007>tG/\u001a=u\u0003-awnZ\"p]R,\u0007\u0010\u001e\u0011\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014XC\u0001B*!\r\t&QK\u0005\u0004\u0005/\u0012&AD&bM.\f7k\u00195fIVdWM]\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0013a\u00023bi\u0006$\u0015N]\u000b\u0003\u0003C\t\u0001\u0002Z1uC\u0012K'\u000fI\u0001\u000ee\u0016\u0004H.[2bi\u0016$Gj\\4\u0016\u0005\t\u0015\u0004cA-\u0003h%\u0019!\u0011\u000e.\u0003\u001bI+\u0007\u000f\\5dCR,G\rT8h\u00039\u0011X\r\u001d7jG\u0006$X\r\u001a'pO\u0002\n!B\\3u\u0007\"\fgN\\3m+\t\u0011\t\bE\u0002D\u0005gJ1A!\u001e>\u0005MY\u0015MZ6b\u001d\u0016$xo\u001c:l\u0007\"\fgN\\3m\u0003-qW\r^\"iC:tW\r\u001c\u0011\u0002\u001f\u0015D\b/\u001b:bi&|g\u000eV5nKJ,\"A! \u0011\t\t}$QQ\u0007\u0003\u0005\u0003S1Aa!S\u0003\u0015!\u0018.\\3s\u0013\u0011\u00119I!!\u0003\u0017MK8\u000f^3n)&lWM]\u0001\u0011Kb\u0004\u0018N]1uS>tG+[7fe\u0002\n\u0011#\u001a=qSJ\fG/[8o'\u0016\u0014h/[2f+\t\u0011y\tE\u0002D\u0005#K1Aa%>\u0005q!\u0016.\\5oO^CW-\u001a7FqBL'/\u0019;j_:\u001cVM\u001d<jG\u0016\f!#\u001a=qSJ\fG/[8o'\u0016\u0014h/[2fAU\u0011!\u0011\u0014\t\u00053\u0002\f\u0019%A\u0004dY&,g\u000e\u001e\u0011\u0002\u0019I\fg\r^%p)\"\u0014X-\u00193\u0016\u0005\t\u0005\u0006c\u0001BR\u00079\u0019!Q\u0015\u0001\u000f\t\t\u001d&1\u0016\b\u0004c\n%\u0016\"\u0001!\n\u0005yz\u0014!\u0004:bMRLu\u000e\u00165sK\u0006$\u0007%A\u0004ti\u0006\u0014H/\u001e9\u0002\u0011MDW\u000f\u001e3po:\f\u0001B]3hSN$XM\u001d\u000b\u0005\u0003\u0013\u00119\fC\u0004\u0003:R\u0002\rAa/\u0002\u00111L7\u000f^3oKJ\u0004bA!0\u0003D\u0006\rcbA-\u0003@&\u0019!\u0011\u0019.\u0002\u0015I\u000bg\r^\"mS\u0016tG/\u0003\u0003\u0003F\n\u001d'\u0001\u0003'jgR,g.\u001a:\u000b\u0007\t\u0005',A\u0007iC:$G.\u001a*fcV,7\u000f\u001e\u000b\t\u0005\u001b\u0014YNa;\u0003pB1\u0011qWAa\u0005\u001f\u0004BA!5\u0003X6\u0011!1\u001b\u0006\u0005\u0005+\f\u0019)\u0001\u0005qe>$xnY8m\u0013\u0011\u0011INa5\u0003\u0015\u0005\u0003\u0018.T3tg\u0006<W\rC\u0004\u0003^V\u0002\rAa8\u0002\r!,\u0017\rZ3s!\u0011\u0011\tOa:\u000e\u0005\t\r(\u0002\u0002Bs\u0003\u0007\u000b\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0005S\u0014\u0019OA\u0007SKF,Xm\u001d;IK\u0006$WM\u001d\u0005\b\u0005[,\u0004\u0019\u0001Bh\u0003\u001d\u0011X-];fgRDqA!=6\u0001\u0004\u0011\u00190A\u0007de\u0016\fG/\u001a3US6,Wj\u001d\t\u0004\u000f\nU\u0018b\u0001B|\u0011\n!Aj\u001c8h\u0003=\u0011W/\u001b7e%\u00064Go\u00117jK:$HC\u0001BM\u0003M\u0011W/\u001b7e\u001d\u0016$xo\u001c:l\u0007\"\fgN\\3m)\t\u0011\t(A\u0007de\u0016\fG/\u001a#bi\u0006$\u0015N\u001d\u000b\u0003\u0003C\t\u0001CY;jY\u0012lU\r^1eCR\fGj\\4\u0015\u0005\r%\u0001cA\"\u0004\f%\u00191QB\u001f\u0003!-\u000bgm[1NKR\fG-\u0019;b\u0019><\u0017A\u00052vS2$g*\u001a;x_J\\7\t\\5f]R$\"aa\u0005\u0011\t\t\u001d2QC\u0005\u0005\u0007/\u0011ICA\u0007OKR<xN]6DY&,g\u000e^\u0001\u000fY\u0016\fG-\u001a:B]\u0012,\u0005o\\2i+\t\u0019i\u0002E\u0002Z\u0007?I1a!\t[\u00059aU-\u00193fe\u0006sG-\u00129pG\"\u0004")
public class KafkaRaftManager<T>
implements RaftManager<T>,
Logging {
    private final MetaProperties metaProperties;
    private final KafkaConfig config;
    private final RecordSerde<T> recordSerde;
    private final TopicPartition topicPartition;
    private final Uuid topicId;
    private final Time time;
    private final Metrics metrics;
    private final CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final AtomicBoolean closed;
    private final ApiVersions apiVersions;
    private final RaftConfig raftConfig;
    private final String threadNamePrefix;
    private final LogContext logContext;
    private final KafkaScheduler scheduler;
    private final File dataDir;
    private final ReplicatedLog replicatedLog;
    private final KafkaNetworkChannel netChannel;
    private final SystemTimer expirationTimer;
    private final TimingWheelExpirationService expirationService;
    private final KafkaRaftClient<T> client;
    private final RaftIoThread raftIoThread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public MetaProperties metaProperties() {
        return this.metaProperties;
    }

    public CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    private AtomicBoolean closed() {
        return this.closed;
    }

    public ApiVersions apiVersions() {
        return this.apiVersions;
    }

    private RaftConfig raftConfig() {
        return this.raftConfig;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File dataDir() {
        return this.dataDir;
    }

    @Override
    public ReplicatedLog replicatedLog() {
        return this.replicatedLog;
    }

    private KafkaNetworkChannel netChannel() {
        return this.netChannel;
    }

    private SystemTimer expirationTimer() {
        return this.expirationTimer;
    }

    private TimingWheelExpirationService expirationService() {
        return this.expirationService;
    }

    @Override
    public KafkaRaftClient<T> client() {
        return this.client;
    }

    private RaftIoThread raftIoThread() {
        return this.raftIoThread;
    }

    public void startup() {
        java.util.Map<Integer, RaftConfig.AddressSpec> voterAddresses = this.controllerQuorumVotersFuture().get();
        ((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(voterAddresses.entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)voterAddressEntry -> {
            KafkaRaftManager.$anonfun$startup$1(this, voterAddressEntry);
            return BoxedUnit.UNIT;
        });
        this.netChannel().start();
        this.raftIoThread().start();
    }

    public void shutdown() {
        if (!this.closed().getAndSet(true)) {
            this.expirationService().shutdown();
            this.expirationTimer().shutdown();
            this.raftIoThread().shutdown();
            this.client().close();
            this.scheduler().shutdown();
            this.netChannel().close();
            this.replicatedLog().close();
        }
    }

    @Override
    public void register(RaftClient.Listener<T> listener) {
        this.client().register(listener);
    }

    @Override
    public CompletableFuture<ApiMessage> handleRequest(RequestHeader header, ApiMessage request, long createdTimeMs) {
        RaftRequest.Inbound inboundRequest = new RaftRequest.Inbound(header.correlationId(), request, createdTimeMs);
        this.client().handle(inboundRequest);
        return inboundRequest.completion.thenApply(response -> response.data());
    }

    /*
     * WARNING - void declaration
     */
    private KafkaRaftClient<T> buildRaftClient() {
        void var3_3;
        FileBasedStateStore quorumStateStore = new FileBasedStateStore(new File(this.dataDir(), "quorum-state"));
        OptionalInt nodeId = OptionalInt.of(this.config.nodeId());
        KafkaRaftClient client = new KafkaRaftClient(this.recordSerde, (NetworkChannel)this.netChannel(), this.replicatedLog(), (QuorumStateStore)quorumStateStore, this.time, this.metrics, (ExpirationService)this.expirationService(), this.logContext(), this.metaProperties().clusterId(), nodeId, this.raftConfig());
        client.initialize();
        return var3_3;
    }

    private KafkaNetworkChannel buildNetworkChannel() {
        NetworkClient netClient = this.buildNetworkClient();
        return new KafkaNetworkChannel(this.time, (KafkaClient)netClient, Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), this.threadNamePrefix());
    }

    private File createDataDir() {
        String logDirName = MergedLog$.MODULE$.logDirName(this.topicPartition);
        return KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$createLogDirectory(new File(this.config.metadataLogDir()), logDirName);
    }

    private KafkaMetadataLog buildMetadataLog() {
        return KafkaMetadataLog$.MODULE$.apply(this.topicPartition, this.topicId, this.dataDir(), this.time, this.metrics, this.scheduler(), MetadataLogConfig$.MODULE$.apply(this.config, 0x800000, 0x800000));
    }

    private NetworkClient buildNetworkClient() {
        ListenerName controllerListenerName = new ListenerName((String)this.config.controllerListenerNames().head());
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)((SecurityProtocol)this.config.effectiveListenerSecurityProtocolMap().getOrElse((Object)controllerListenerName, (Function0 & Serializable & scala.Serializable)() -> SecurityProtocol.forName((String)controllerListenerName.value()))), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)this.config, (ListenerName)controllerListenerName, (String)this.config.saslMechanismControllerProtocol(), (Time)this.time, (boolean)this.config.saslInterBrokerHandshakeRequestEnable(), (LogContext)this.logContext());
        String metricGroupPrefix = "raft-channel";
        boolean collectPerConnectionMetrics = false;
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(this.config.connectionsMaxIdleMs()), this.metrics, this.time, metricGroupPrefix, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava(), collectPerConnectionMetrics, channelBuilder, this.logContext());
        String clientId = new StringBuilder(12).append("raft-client-").append(this.config.nodeId()).toString();
        int maxInflightRequestsPerConnection = 1;
        int reconnectBackoffMs = 50;
        int reconnectBackoffMsMs = 500;
        boolean discoverBrokerVersions = true;
        return new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId, maxInflightRequestsPerConnection, (long)reconnectBackoffMs, (long)reconnectBackoffMsMs, -1, Predef$.MODULE$.Integer2int(this.config.socketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, discoverBrokerVersions, this.apiVersions(), this.logContext());
    }

    @Override
    public LeaderAndEpoch leaderAndEpoch() {
        return this.client().leaderAndEpoch();
    }

    public static final /* synthetic */ void $anonfun$startup$1(KafkaRaftManager $this, Map.Entry voterAddressEntry) {
        RaftConfig.AddressSpec addressSpec = (RaftConfig.AddressSpec)voterAddressEntry.getValue();
        if (addressSpec instanceof RaftConfig.InetAddressSpec) {
            RaftConfig.InetAddressSpec inetAddressSpec = (RaftConfig.InetAddressSpec)addressSpec;
            $this.netChannel().updateEndpoint(Predef$.MODULE$.Integer2int((Integer)voterAddressEntry.getKey()), inetAddressSpec);
            return;
        }
        if (addressSpec instanceof RaftConfig.UnknownAddressSpec) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("Skipping channel update for destination ID: ").append(voterAddressEntry.getKey()).append(" ").append("because of non-routable endpoint: ").append(RaftConfig.NON_ROUTABLE_ADDRESS.toString()).toString());
            return;
        }
        if (addressSpec != null) {
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Unexpected address spec (type: ").append(addressSpec.getClass()).append(") for channel update for ").append("destination ID: ").append(voterAddressEntry.getKey()).toString());
            return;
        }
        throw new MatchError(null);
    }

    public KafkaRaftManager(MetaProperties metaProperties, KafkaConfig config, RecordSerde<T> recordSerde, TopicPartition topicPartition, Uuid topicId, Time time, Metrics metrics, Option<String> threadNamePrefixOpt, CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture) {
        this.metaProperties = metaProperties;
        this.config = config;
        this.recordSerde = recordSerde;
        this.topicPartition = topicPartition;
        this.topicId = topicId;
        this.time = time;
        this.metrics = metrics;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        Logging.$init$(this);
        this.closed = new AtomicBoolean(false);
        this.apiVersions = new ApiVersions();
        this.raftConfig = new RaftConfig((AbstractConfig)config);
        this.threadNamePrefix = (String)threadNamePrefixOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> "kafka-raft");
        this.logContext = new LogContext(new StringBuilder(22).append("[RaftManager nodeId=").append(config.nodeId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.scheduler = new KafkaScheduler(1, new StringBuilder(10).append(this.threadNamePrefix()).append("-scheduler").toString(), KafkaScheduler$.MODULE$.$lessinit$greater$default$3(), KafkaScheduler$.MODULE$.$lessinit$greater$default$4());
        this.scheduler().startup();
        this.dataDir = this.createDataDir();
        this.replicatedLog = this.buildMetadataLog();
        this.netChannel = this.buildNetworkChannel();
        this.expirationTimer = new SystemTimer("raft-expiration-executor", SystemTimer$.MODULE$.$lessinit$greater$default$2(), SystemTimer$.MODULE$.$lessinit$greater$default$3(), SystemTimer$.MODULE$.$lessinit$greater$default$4());
        this.expirationService = new TimingWheelExpirationService(this.expirationTimer());
        this.client = this.buildRaftClient();
        this.raftIoThread = new RaftIoThread(this.client(), this.threadNamePrefix());
    }

    public static class RaftIoThread
    extends ShutdownableThread {
        private final KafkaRaftClient<?> client;

        @Override
        public void doWork() {
            this.client.poll();
        }

        @Override
        public boolean initiateShutdown() {
            if (super.initiateShutdown()) {
                this.client.shutdown(5000).whenComplete((x$1, exception) -> {
                    if (exception != null) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Graceful shutdown of RaftClient failed", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> exception);
                        return;
                    }
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Completed graceful shutdown of RaftClient");
                });
                return true;
            }
            return false;
        }

        @Override
        public boolean isRunning() {
            return this.client.isRunning() && !this.isThreadFailed();
        }

        public RaftIoThread(KafkaRaftClient<?> client, String threadNamePrefix) {
            this.client = client;
            super(new StringBuilder(10).append(threadNamePrefix).append("-io-thread").toString(), false);
        }
    }
}

