/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.common.TenantHelpers;
import kafka.coordinator.group.GroupOverview;
import kafka.coordinator.group.GroupSummary;
import kafka.coordinator.group.MemberSummary;
import kafka.metrics.ConsumerLagEmitter$;
import kafka.metrics.ConsumerLagEmitterSummary;
import kafka.metrics.MemberTopicPartition;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.KafkaScheduler;
import kafka.utils.KafkaScheduler$;
import kafka.utils.Scheduler;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.internals.GaugeSuite;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r=q!\u0002(P\u0011\u0003!f!\u0002,P\u0011\u00039\u0006\"\u00020\u0002\t\u0003y\u0006\"\u00021\u0002\t\u0003\t\u0007\"\u0003BQ\u0003E\u0005I\u0011\u0001BR\u0011%\u0011I,\u0001b\u0001\n\u0003\u0011Y\f\u0003\u0005\u0003B\u0006\u0001\u000b\u0011\u0002B_\u0011%\u0011\u0019-\u0001b\u0001\n\u0003\u0011Y\f\u0003\u0005\u0003F\u0006\u0001\u000b\u0011\u0002B_\u0011%\u00119-\u0001b\u0001\n\u0003\u0011Y\f\u0003\u0005\u0003J\u0006\u0001\u000b\u0011\u0002B_\u0011%\u0011Y-\u0001b\u0001\n\u0003\u0011Y\f\u0003\u0005\u0003N\u0006\u0001\u000b\u0011\u0002B_\u0011%\u0011y-\u0001b\u0001\n\u0003\u0011Y\f\u0003\u0005\u0003R\u0006\u0001\u000b\u0011\u0002B_\u0011%\u0011\u0019.\u0001b\u0001\n\u0003\u0011Y\f\u0003\u0005\u0003V\u0006\u0001\u000b\u0011\u0002B_\u0011%\u00119.\u0001b\u0001\n\u0003\u0011Y\f\u0003\u0005\u0003Z\u0006\u0001\u000b\u0011\u0002B_\u0011%\u0011Y.\u0001b\u0001\n\u0003\u0011Y\f\u0003\u0005\u0003^\u0006\u0001\u000b\u0011\u0002B_\u0011%\u0011y.\u0001b\u0001\n\u0003\u0011Y\f\u0003\u0005\u0003b\u0006\u0001\u000b\u0011\u0002B_\u0011)\u0011\u0019/\u0001b\u0001\n\u0003y%Q\u001d\u0005\t\u0005c\f\u0001\u0015!\u0003\u0003h\"I!1_\u0001C\u0002\u0013%!Q\u001d\u0005\t\u0005k\f\u0001\u0015!\u0003\u0003h\"I!q_\u0001C\u0002\u0013%!\u0011 \u0005\t\u0007\u000f\t\u0001\u0015!\u0003\u0003|\"I1\u0011B\u0001C\u0002\u0013%!\u0011 \u0005\t\u0007\u0017\t\u0001\u0015!\u0003\u0003|\"I1QB\u0001\u0012\u0002\u0013\u0005!1\u0015\u0004\u0005->\u00031\r\u0003\u0005QA\t\u0015\r\u0011\"\u0001e\u0011!\t\bE!A!\u0002\u0013)\u0007\u0002\u0003:!\u0005\u000b\u0007I\u0011A:\t\u0011i\u0004#\u0011!Q\u0001\nQD\u0001b\u001f\u0011\u0003\u0006\u0004%\t\u0001 \u0005\n\u0003#\u0002#\u0011!Q\u0001\nuD!\"a\u0015!\u0005\u000b\u0007I\u0011AA+\u0011)\t\t\u0007\tB\u0001B\u0003%\u0011q\u000b\u0005\u000b\u0003G\u0002#Q1A\u0005\u0002\u0005\u0015\u0004BCAJA\t\u0005\t\u0015!\u0003\u0002h!Q\u0011Q\u0013\u0011\u0003\u0006\u0004%\t!a&\t\u0015\u0005}\u0005E!A!\u0002\u0013\tI\n\u0003\u0006\u0002\"\u0002\u0012)\u0019!C\u0001\u0003GC!\"a-!\u0005\u0003\u0005\u000b\u0011BAS\u0011\u0019q\u0006\u0005\"\u0001\u00026\"Q\u0011Q\u0019\u0011C\u0002\u0013\u0005q*a2\t\u0011\u0005\u0015\b\u0005)A\u0005\u0003\u0013D\u0011\"a:!\u0001\u0004%I!!;\t\u0013\u0005E\b\u00051A\u0005\n\u0005M\b\u0002CA\u0000A\u0001\u0006K!a;\t\u0013\t%\u0001\u00051A\u0005\n\u0005%\b\"\u0003B\u0006A\u0001\u0007I\u0011\u0002B\u0007\u0011!\u0011\t\u0002\tQ!\n\u0005-\b\"\u0003B\u000bA\u0001\u0007I\u0011BAu\u0011%\u00119\u0002\ta\u0001\n\u0013\u0011I\u0002\u0003\u0005\u0003\u001e\u0001\u0002\u000b\u0015BAv\u0011%\u0011\t\u0003\ta\u0001\n\u0013\tI\u000fC\u0005\u0003$\u0001\u0002\r\u0011\"\u0003\u0003&!A!\u0011\u0006\u0011!B\u0013\tY\u000fC\u0005\u0003.\u0001\u0002\r\u0011\"\u0003\u0002\u0018\"I!q\u0006\u0011A\u0002\u0013%!\u0011\u0007\u0005\t\u0005k\u0001\u0003\u0015)\u0003\u0002\u001a\"I!\u0011\b\u0011A\u0002\u0013%\u0011q\u0013\u0005\n\u0005w\u0001\u0003\u0019!C\u0005\u0005{A\u0001B!\u0011!A\u0003&\u0011\u0011\u0014\u0005\n\u0005\u000b\u0002\u0003\u0019!C\u0005\u0003/C\u0011Ba\u0012!\u0001\u0004%IA!\u0013\t\u0011\t5\u0003\u0005)Q\u0005\u00033CqA!\u0015!\t\u0003\u0011\u0019\u0006C\u0004\u0003V\u0001\"\tAa\u0015\t\u000f\t]\u0003\u0005\"\u0001\u0003T!A!\u0011\f\u0011\u0005\u0002=\u0013Y\u0006C\u0004\u0003d\u0001\"IA!\u001a\t\u000f\t-\u0004\u0005\"\u0003\u0003n!A!q\u000e\u0011\u0005\u0002=\u0013\t(\u0001\nD_:\u001cX/\\3s\u0019\u0006<W)\\5ui\u0016\u0014(B\u0001)R\u0003\u001diW\r\u001e:jGNT\u0011AU\u0001\u0006W\u000647.Y\u0002\u0001!\t)\u0016!D\u0001P\u0005I\u0019uN\\:v[\u0016\u0014H*Y4F[&$H/\u001a:\u0014\u0005\u0005A\u0006CA-]\u001b\u0005Q&\"A.\u0002\u000bM\u001c\u0017\r\\1\n\u0005uS&AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002)\u0006)\u0011\r\u001d9msRi!M!\u001f\u0003|\tu$q\u0010BA\u0005\u0007\u0003\"!\u0016\u0011\u0014\u0005\u0001BV#A3\u0011\u0005\u0019|W\"A4\u000b\u0005AC'BA5k\u0003\u0019\u0019w.\\7p]*\u0011!k\u001b\u0006\u0003Y6\fa!\u00199bG\",'\"\u00018\u0002\u0007=\u0014x-\u0003\u0002qO\n9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014X#\u0001;\u0011\u0005UDX\"\u0001<\u000b\u0005]\f\u0016!B;uS2\u001c\u0018BA=w\u0005%\u00196\r[3ek2,'/\u0001\u0006tG\",G-\u001e7fe\u0002\n\u0011\u0003\\5ti\u001e\u0013x.\u001e9t\u0011\u0006tG\r\\3s+\u0005i\bCB-\u007f\u0003\u0003\ti\"\u0003\u0002\u00005\nIa)\u001e8di&|g.\r\t\u0007\u0003\u0007\t\t\"a\u0006\u000f\t\u0005\u0015\u0011Q\u0002\t\u0004\u0003\u000fQVBAA\u0005\u0015\r\tYaU\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005=!,\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003'\t)BA\u0002TKRT1!a\u0004[!\u0011\t\u0019!!\u0007\n\t\u0005m\u0011Q\u0003\u0002\u0007'R\u0014\u0018N\\4\u0011\u000fe\u000by\"a\t\u00020%\u0019\u0011\u0011\u0005.\u0003\rQ+\b\u000f\\33!\u0011\t)#a\u000b\u000e\u0005\u0005\u001d\"bAA\u0015Q\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u0002.\u0005\u001d\"AB#se>\u00148\u000f\u0005\u0004\u00022\u0005m\u0012\u0011\t\b\u0005\u0003g\t9D\u0004\u0003\u0002\b\u0005U\u0012\"A.\n\u0007\u0005e\",A\u0004qC\u000e\\\u0017mZ3\n\t\u0005u\u0012q\b\u0002\u0005\u0019&\u001cHOC\u0002\u0002:i\u0003B!a\u0011\u0002N5\u0011\u0011Q\t\u0006\u0005\u0003\u000f\nI%A\u0003he>,\bOC\u0002\u0002LE\u000b1bY8pe\u0012Lg.\u0019;pe&!\u0011qJA#\u000559%o\\;q\u001fZ,'O^5fo\u0006\u0011B.[:u\u000fJ|W\u000f]:IC:$G.\u001a:!\u0003Q!Wm]2sS\n,wI]8va\"\u000bg\u000e\u001a7feV\u0011\u0011q\u000b\t\u00073z\f9\"!\u0017\u0011\u000fe\u000by\"a\t\u0002\\A!\u00111IA/\u0013\u0011\ty&!\u0012\u0003\u0019\u001d\u0013x.\u001e9Tk6l\u0017M]=\u0002+\u0011,7o\u0019:jE\u0016<%o\\;q\u0011\u0006tG\r\\3sA\u0005\u0019b-\u001a;dQ>3gm]3ug\"\u000bg\u000e\u001a7feV\u0011\u0011q\r\t\u00073z\f9\"!\u001b\u0011\u000fe\u000by\"a\t\u0002lAA\u0011QNA:\u0003o\ny(\u0004\u0002\u0002p)\u0019\u0011\u0011\u000f.\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002v\u0005=$aA'baB!\u0011\u0011PA>\u001b\u0005A\u0017bAA?Q\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0003BAA\u0003\u001bsA!a!\u0002\n6\u0011\u0011Q\u0011\u0006\u0004\u0003\u000fC\u0017\u0001\u0003:fcV,7\u000f^:\n\t\u0005-\u0015QQ\u0001\u0014\u001f\u001a47/\u001a;GKR\u001c\u0007NU3ta>t7/Z\u0005\u0005\u0003\u001f\u000b\tJA\u0007QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u0006\u0005\u0003\u0017\u000b))\u0001\u000bgKR\u001c\u0007n\u00144gg\u0016$8\u000fS1oI2,'\u000fI\u0001\u000fK6LG/\u00138uKJ4\u0018\r\\'t+\t\tI\nE\u0002Z\u00037K1!!([\u0005\u0011auN\\4\u0002\u001f\u0015l\u0017\u000e^%oi\u0016\u0014h/\u00197Ng\u0002\nQ!\u00193nS:,\"!!*\u0011\t\u0005\u001d\u0016qV\u0007\u0003\u0003SSA!!)\u0002,*\u0019\u0011Q\u00166\u0002\u000f\rd\u0017.\u001a8ug&!\u0011\u0011WAU\u0005\u0015\tE-\\5o\u0003\u0019\tG-\\5oAQy!-a.\u0002:\u0006m\u0016QXA`\u0003\u0003\f\u0019\rC\u0003Q_\u0001\u0007Q\rC\u0003s_\u0001\u0007A\u000fC\u0003|_\u0001\u0007Q\u0010C\u0004\u0002T=\u0002\r!a\u0016\t\u000f\u0005\rt\u00061\u0001\u0002h!I\u0011QS\u0018\u0011\u0002\u0003\u0007\u0011\u0011\u0014\u0005\b\u0003C{\u0003\u0019AAS\u0003I\u0019wN\\:v[\u0016\u0014H*Y4NKR\u0014\u0018nY:\u0016\u0005\u0005%\u0007\u0003CAf\u0003#\f9\"a5\u000e\u0005\u00055'\u0002BAh\u0003_\nq!\\;uC\ndW-\u0003\u0003\u0002v\u00055\u0007\u0003CAk\u00037\fy.!'\u000e\u0005\u0005]'bAAmO\u0006I\u0011N\u001c;fe:\fGn]\u0005\u0005\u0003;\f9N\u0001\u0006HCV<WmU;ji\u0016\u00042!VAq\u0013\r\t\u0019o\u0014\u0002\u0015\u001b\u0016l'-\u001a:U_BL7\rU1si&$\u0018n\u001c8\u0002'\r|gn];nKJd\u0015mZ'fiJL7m\u001d\u0011\u0002!U\u0004H-\u0019;fI\u001e\u0013x.\u001e9TSj,WCAAv!\rI\u0016Q^\u0005\u0004\u0003_T&aA%oi\u0006!R\u000f\u001d3bi\u0016$wI]8vaNK'0Z0%KF$B!!>\u0002|B\u0019\u0011,a>\n\u0007\u0005e(L\u0001\u0003V]&$\b\"CA\u007fg\u0005\u0005\t\u0019AAv\u0003\rAH%M\u0001\u0012kB$\u0017\r^3e\u000fJ|W\u000f]*ju\u0016\u0004\u0003f\u0001\u001b\u0003\u0004A\u0019\u0011L!\u0002\n\u0007\t\u001d!L\u0001\u0005w_2\fG/\u001b7f\u0003Q\u0011XMY1mC:\u001c\u0017N\\4He>,\boU5{K\u0006A\"/\u001a2bY\u0006t7-\u001b8h\u000fJ|W\u000f]*ju\u0016|F%Z9\u0015\t\u0005U(q\u0002\u0005\n\u0003{4\u0014\u0011!a\u0001\u0003W\fQC]3cC2\fgnY5oO\u001e\u0013x.\u001e9TSj,\u0007\u0005K\u00028\u0005\u0007\tqBZ1jY\u0016$wI]8vaNK'0Z\u0001\u0014M\u0006LG.\u001a3He>,\boU5{K~#S-\u001d\u000b\u0005\u0003k\u0014Y\u0002C\u0005\u0002~f\n\t\u00111\u0001\u0002l\u0006\u0001b-Y5mK\u0012<%o\\;q'&TX\r\t\u0015\u0004u\t\r\u0011\u0001E3ya&\u0014X\rZ$s_V\u00048+\u001b>f\u0003Q)\u0007\u0010]5sK\u0012<%o\\;q'&TXm\u0018\u0013fcR!\u0011Q\u001fB\u0014\u0011%\ti\u0010PA\u0001\u0002\u0004\tY/A\tfqBL'/\u001a3He>,\boU5{K\u0002B3!\u0010B\u0002\u0003-iW\r\u001e:jGN\u001c\u0016N_3\u0002\u001f5,GO]5dgNK'0Z0%KF$B!!>\u00034!I\u0011Q` \u0002\u0002\u0003\u0007\u0011\u0011T\u0001\r[\u0016$(/[2t'&TX\r\t\u0015\u0004\u0001\n\r\u0011!D3yK\u000e,H/[8o)&lW-A\tfq\u0016\u001cW\u000f^5p]RKW.Z0%KF$B!!>\u0003@!I\u0011Q \"\u0002\u0002\u0003\u0007\u0011\u0011T\u0001\u000fKb,7-\u001e;j_:$\u0016.\\3!Q\r\u0019%1A\u0001\u0014Y\u0006\u001cHoU;dG\u0016\u001c8OZ;m%VtWj]\u0001\u0018Y\u0006\u001cHoU;dG\u0016\u001c8OZ;m%VtWj]0%KF$B!!>\u0003L!I\u0011Q`#\u0002\u0002\u0003\u0007\u0011\u0011T\u0001\u0015Y\u0006\u001cHoU;dG\u0016\u001c8OZ;m%VtWj\u001d\u0011)\u0007\u0019\u0013\u0019!A\u0003ti\u0006\u0014H\u000f\u0006\u0002\u0002v\u0006A1\u000f[;uI><h.A\bf[&$8i\u001c8tk6,'\u000fT1h\u0003a1W\r^2i\u001f\u001a47/\u001a;t\u0003:$'+Z2pe\u0012d\u0015m\u001a\u000b\u0003\u0005;\u00022!\u0016B0\u0013\r\u0011\tg\u0014\u0002\u001a\u0007>t7/^7fe2\u000bw-R7jiR,'oU;n[\u0006\u0014\u00180\u0001\tde\u0016\fG/Z$bk\u001e,7+^5uKR!\u00111\u001bB4\u0011\u001d\u0011Ig\u0013a\u0001\u0003/\tqa\u001a:pkBLE-\u0001\ndkJ\u0014XM\u001c;NKR\u0014\u0018nY:TSj,GCAAM\u00031j\u0017-\u001f2f!J,g-\u001b=U_BL7\rU1si&$\u0018n\u001c8t/&$\b\u000eV3oC:$h)\u001e8di&|g\u000e\u0006\u0003\u0003t\t]\u0004CB-\u007f\u0005k\u0012)\b\u0005\u0004\u00022\u0005m\u0012q\u000f\u0005\b\u0005Sj\u0005\u0019AA\f\u0011\u0015\u00016\u00011\u0001f\u0011\u0015Y8\u00011\u0001~\u0011\u001d\t\u0019f\u0001a\u0001\u0003/Bq!a\u0019\u0004\u0001\u0004\t9\u0007C\u0005\u0002\u0016\u000e\u0001\n\u00111\u0001\u0002\u001a\"9!QQ\u0002A\u0002\t\u001d\u0015AC1e[&t\u0007K]8qgBA!\u0011\u0012BJ\u0003/\u0011)*\u0004\u0002\u0003\f*!!Q\u0012BH\u0003\u0011)H/\u001b7\u000b\u0005\tE\u0015\u0001\u00026bm\u0006LA!!\u001e\u0003\fB!!q\u0013BO\u001b\t\u0011IJ\u0003\u0003\u0003\u001c\n=\u0015\u0001\u00027b]\u001eLAAa(\u0003\u001a\n1qJ\u00196fGR\fq\"\u00199qYf$C-\u001a4bk2$H%N\u000b\u0003\u0005KSC!!'\u0003(.\u0012!\u0011\u0016\t\u0005\u0005W\u0013),\u0004\u0002\u0003.*!!q\u0016BY\u0003%)hn\u00195fG.,GMC\u0002\u00034j\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u00119L!,\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000bD_:\u001cX/\\3s\u0019\u0006<W*\u001a;sS\u000et\u0015-\\3\u0016\u0005\tu\u0006\u0003\u0002BL\u0005\u007fKA!a\u0007\u0003\u001a\u000612i\u001c8tk6,'\u000fT1h\u001b\u0016$(/[2OC6,\u0007%A\bNKR\u0014\u0018nY$s_V\u0004h*Y7f\u0003AiU\r\u001e:jG\u001e\u0013x.\u001e9OC6,\u0007%\u0001\u000eVa\u0012\fG/\u001a3He>,\boU5{K6+GO]5d\u001d\u0006lW-A\u000eVa\u0012\fG/\u001a3He>,\boU5{K6+GO]5d\u001d\u0006lW\rI\u0001\u001f%\u0016\u0014\u0017\r\\1oG&twm\u0012:pkB\u001c\u0016N_3NKR\u0014\u0018n\u0019(b[\u0016\fqDU3cC2\fgnY5oO\u001e\u0013x.\u001e9TSj,W*\u001a;sS\u000et\u0015-\\3!\u0003e1\u0015-\u001b7fI\u001e\u0013x.\u001e9TSj,W*\u001a;sS\u000et\u0015-\\3\u00025\u0019\u000b\u0017\u000e\\3e\u000fJ|W\u000f]*ju\u0016lU\r\u001e:jG:\u000bW.\u001a\u0011\u00025\u0015C\b/\u001b:fI\u001e\u0013x.\u001e9TSj,W*\u001a;sS\u000et\u0015-\\3\u00027\u0015C\b/\u001b:fI\u001e\u0013x.\u001e9TSj,W*\u001a;sS\u000et\u0015-\\3!\u0003UiU\r\u001e:jGN\u001c\u0016N_3NKR\u0014\u0018n\u0019(b[\u0016\fa#T3ue&\u001c7oU5{K6+GO]5d\u001d\u0006lW\rI\u0001\u0018\u000bb,7-\u001e;j_:$\u0016.\\3NKR\u0014\u0018n\u0019(b[\u0016\f\u0001$\u0012=fGV$\u0018n\u001c8US6,W*\u001a;sS\u000et\u0015-\\3!\u0003\u0019\"\u0016.\\3TS:\u001cW\rT1tiN+8mY3tg\u001a,HNU;o\u001bNlU\r\u001e:jG:\u000bW.Z\u0001()&lWmU5oG\u0016d\u0015m\u001d;Tk\u000e\u001cWm]:gk2\u0014VO\\'t\u001b\u0016$(/[2OC6,\u0007%A\u0006WC2LGm\u0015;bi\u0016\u001cXC\u0001Bt!\u0019\u0011IOa<\u0003>6\u0011!1\u001e\u0006\u0005\u0005[\fy'A\u0005j[6,H/\u00192mK&!\u00111\u0003Bv\u000311\u0016\r\\5e'R\fG/Z:!\u0003E\u0011VMY1mC:\u001c\u0017N\\4Ti\u0006$Xm]\u0001\u0013%\u0016\u0014\u0017\r\\1oG&twm\u0015;bi\u0016\u001c\b%A\u0002m_\u001e,\"Aa?\u0011\t\tu81A\u0007\u0003\u0005\u007fT1a!\u0001n\u0003\u0015\u0019HN\u001a\u001bk\u0013\u0011\u0019)Aa@\u0003\r1{wmZ3s\u0003\u0011awn\u001a\u0011\u0002\u001b\u001d\fWoZ3Tk&$X\rT8h\u000399\u0017-^4f'VLG/\u001a'pO\u0002\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u00122\u0004")
public class ConsumerLagEmitter {
    private final Metrics metrics;
    private final Scheduler scheduler;
    private final Function1<scala.collection.immutable.Set<String>, Tuple2<Errors, List<GroupOverview>>> listGroupsHandler;
    private final Function1<String, Tuple2<Errors, GroupSummary>> describeGroupHandler;
    private final Function1<String, Tuple2<Errors, Map<TopicPartition, OffsetFetchResponse.PartitionData>>> fetchOffsetsHandler;
    private final long emitIntervalMs;
    private final Admin admin;
    private final scala.collection.mutable.Map<String, GaugeSuite<MemberTopicPartition, Object>> consumerLagMetrics;
    private volatile int kafka$metrics$ConsumerLagEmitter$$updatedGroupSize;
    private volatile int kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize;
    private volatile int kafka$metrics$ConsumerLagEmitter$$failedGroupSize;
    private volatile int kafka$metrics$ConsumerLagEmitter$$expiredGroupSize;
    private volatile long kafka$metrics$ConsumerLagEmitter$$metricsSize;
    private volatile long kafka$metrics$ConsumerLagEmitter$$executionTime;
    private volatile long kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs;

    public static long $lessinit$greater$default$6() {
        return ConsumerLagEmitter$.MODULE$.$lessinit$greater$default$6();
    }

    public static String TimeSinceLastSuccessfulRunMsMetricName() {
        return ConsumerLagEmitter$.MODULE$.TimeSinceLastSuccessfulRunMsMetricName();
    }

    public static String ExecutionTimeMetricName() {
        return ConsumerLagEmitter$.MODULE$.ExecutionTimeMetricName();
    }

    public static String MetricsSizeMetricName() {
        return ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName();
    }

    public static String ExpiredGroupSizeMetricName() {
        return ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName();
    }

    public static String FailedGroupSizeMetricName() {
        return ConsumerLagEmitter$.MODULE$.FailedGroupSizeMetricName();
    }

    public static String RebalancingGroupSizeMetricName() {
        return ConsumerLagEmitter$.MODULE$.RebalancingGroupSizeMetricName();
    }

    public static String UpdatedGroupSizeMetricName() {
        return ConsumerLagEmitter$.MODULE$.UpdatedGroupSizeMetricName();
    }

    public static String MetricGroupName() {
        return ConsumerLagEmitter$.MODULE$.MetricGroupName();
    }

    public static String ConsumerLagMetricName() {
        return ConsumerLagEmitter$.MODULE$.ConsumerLagMetricName();
    }

    public static long apply$default$5() {
        return ConsumerLagEmitter$.MODULE$.apply$default$5();
    }

    public static ConsumerLagEmitter apply(Metrics metrics, Function1<scala.collection.immutable.Set<String>, Tuple2<Errors, List<GroupOverview>>> function1, Function1<String, Tuple2<Errors, GroupSummary>> function12, Function1<String, Tuple2<Errors, Map<TopicPartition, OffsetFetchResponse.PartitionData>>> function13, long l, java.util.Map<String, Object> map) {
        if (ConsumerLagEmitter$.MODULE$ == null) {
            throw null;
        }
        map.put("client.id", "consumer-lag-emitter");
        map.remove("metric.reporters");
        return new ConsumerLagEmitter(metrics, new KafkaScheduler(1, "consumer-lag-emitter-", true, KafkaScheduler$.MODULE$.$lessinit$greater$default$4()), function1, function12, function13, l, Admin.create(map));
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Function1<scala.collection.immutable.Set<String>, Tuple2<Errors, List<GroupOverview>>> listGroupsHandler() {
        return this.listGroupsHandler;
    }

    public Function1<String, Tuple2<Errors, GroupSummary>> describeGroupHandler() {
        return this.describeGroupHandler;
    }

    public Function1<String, Tuple2<Errors, Map<TopicPartition, OffsetFetchResponse.PartitionData>>> fetchOffsetsHandler() {
        return this.fetchOffsetsHandler;
    }

    public long emitIntervalMs() {
        return this.emitIntervalMs;
    }

    public Admin admin() {
        return this.admin;
    }

    public scala.collection.mutable.Map<String, GaugeSuite<MemberTopicPartition, Object>> consumerLagMetrics() {
        return this.consumerLagMetrics;
    }

    public int kafka$metrics$ConsumerLagEmitter$$updatedGroupSize() {
        return this.kafka$metrics$ConsumerLagEmitter$$updatedGroupSize;
    }

    private void kafka$metrics$ConsumerLagEmitter$$updatedGroupSize_$eq(int x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$updatedGroupSize = x$1;
    }

    public int kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize() {
        return this.kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize;
    }

    private void kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize_$eq(int x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize = x$1;
    }

    public int kafka$metrics$ConsumerLagEmitter$$failedGroupSize() {
        return this.kafka$metrics$ConsumerLagEmitter$$failedGroupSize;
    }

    private void kafka$metrics$ConsumerLagEmitter$$failedGroupSize_$eq(int x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$failedGroupSize = x$1;
    }

    public int kafka$metrics$ConsumerLagEmitter$$expiredGroupSize() {
        return this.kafka$metrics$ConsumerLagEmitter$$expiredGroupSize;
    }

    private void kafka$metrics$ConsumerLagEmitter$$expiredGroupSize_$eq(int x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$expiredGroupSize = x$1;
    }

    public long kafka$metrics$ConsumerLagEmitter$$metricsSize() {
        return this.kafka$metrics$ConsumerLagEmitter$$metricsSize;
    }

    private void kafka$metrics$ConsumerLagEmitter$$metricsSize_$eq(long x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$metricsSize = x$1;
    }

    public long kafka$metrics$ConsumerLagEmitter$$executionTime() {
        return this.kafka$metrics$ConsumerLagEmitter$$executionTime;
    }

    private void kafka$metrics$ConsumerLagEmitter$$executionTime_$eq(long x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$executionTime = x$1;
    }

    public long kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs() {
        return this.kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs;
    }

    private void kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs_$eq(long x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs = x$1;
    }

    public void start() {
        ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().info("Consumer lag emitter starting up.");
        this.scheduler().startup();
        this.scheduler().schedule("emit-consumer-lag-", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.emitConsumerLag(), this.emitIntervalMs(), this.emitIntervalMs(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public void shutdown() {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().info("Consumer lag emitter shutting down.");
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x$1, gaugeSuite) -> {
            gaugeSuite.close();
            return BoxedUnit.UNIT;
        };
        Map<String, GaugeSuite<MemberTopicPartition, Object>> map = Implicits$.MODULE$.MapExtensionMethods(this.consumerLagMetrics());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.UpdatedGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.RebalancingGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.FailedGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.ExecutionTimeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.TimeSinceLastSuccessfulRunMsMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.scheduler().shutdown();
        if (this.admin() != null) {
            this.admin().close();
        }
        ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().info("Consumer lag emitter shutdown complete.");
    }

    public void emitConsumerLag() {
        try {
            ConsumerLagEmitterSummary result = this.fetchOffsetsAndRecordLag();
            this.kafka$metrics$ConsumerLagEmitter$$updatedGroupSize_$eq(result.updatedGroupSize());
            this.kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize_$eq(result.rebalancingGroupSize());
            this.kafka$metrics$ConsumerLagEmitter$$failedGroupSize_$eq(result.failedGroupSize());
            this.kafka$metrics$ConsumerLagEmitter$$expiredGroupSize_$eq(result.expiredGroupSize());
            this.kafka$metrics$ConsumerLagEmitter$$metricsSize_$eq(result.metricsSize());
            this.kafka$metrics$ConsumerLagEmitter$$executionTime_$eq(result.executionTime());
            this.kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs_$eq(System.currentTimeMillis());
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().info(new StringBuilder(113).append("Updated lag of ").append(this.kafka$metrics$ConsumerLagEmitter$$updatedGroupSize()).append(" groups, ").append("ignored ").append(this.kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize()).append(" rebalancing groups, ").append("failed to update ").append(this.kafka$metrics$ConsumerLagEmitter$$failedGroupSize()).append(" groups due to errors, ").append("and expired ").append(this.kafka$metrics$ConsumerLagEmitter$$expiredGroupSize()).append(" groups.").toString());
            return;
        }
        catch (Throwable t) {
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().error("Could not update consumer lag metrics.", t);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ConsumerLagEmitterSummary fetchOffsetsAndRecordLag() {
        void var8_7;
        void var7_6;
        long startTime = System.currentTimeMillis();
        scala.collection.mutable.Map groupsToCurrentOffsets = Map$.MODULE$.empty();
        scala.collection.mutable.Set rebalancingGroups = Set$.MODULE$.empty();
        scala.collection.mutable.Set failedGroups = Set$.MODULE$.empty();
        Tuple2 tuple2 = (Tuple2)this.listGroupsHandler().apply(ConsumerLagEmitter$.MODULE$.ValidStates());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        List groups = (List)tuple2._2();
        void error2 = var7_6;
        void groups2 = var8_7;
        void v0 = error2;
        Errors errors = Errors.NONE;
        if (v0 == null ? errors != null : !v0.equals(errors)) {
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().error(new StringBuilder(57).append("Could not list groups due to ").append(error2).append(". Will retry in the next run").toString());
            return new ConsumerLagEmitterSummary(0, 0, 0, 0, this.currentMetricsSize(), 0L);
        }
        groups2.foreach((Function1 & Serializable & scala.Serializable)groupOverview -> {
            void var8_8;
            void var7_7;
            String groupId = groupOverview.groupId();
            Tuple2 tuple2 = (Tuple2)this.describeGroupHandler().apply((Object)groupId);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Errors error = (Errors)tuple2._1();
            GroupSummary groupSummary = (GroupSummary)tuple2._2();
            void error2 = var7_7;
            void groupSummary2 = var8_8;
            void v0 = error2;
            Errors errors = Errors.NOT_COORDINATOR;
            if (!(v0 != null ? !v0.equals(errors) : errors != null)) {
                ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(69).append("Ignoring group ").append(groupId).append(" because it is not hosted on this coordinator anymore.").toString());
                return BoxedUnit.UNIT;
            }
            void v1 = error2;
            Errors errors2 = Errors.NONE;
            if (v1 == null ? errors2 != null : !v1.equals(errors2)) {
                ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(62).append("Could not describe group ").append(groupId).append(" due to ").append(error2).append(". Will retry in the next run.").toString());
                return failedGroups.$plus$eq((Object)groupId);
            }
            String string = groupSummary2.protocolType();
            String string2 = "consumer";
            if (string == null || !string.equals(string2)) {
                ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(44).append("Group ").append(groupId).append(" is not a consumer group. Ignoring it.").toString());
                return BoxedUnit.UNIT;
            }
            if (ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$RebalancingStates().contains((Object)groupSummary2.state())) {
                return rebalancingGroups.$plus$eq((Object)groupId);
            }
            String string3 = groupSummary2.state();
            String string4 = ConsumerGroupState.STABLE.toString();
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                void var17_17;
                void var16_16;
                Tuple2 tuple22 = (Tuple2)this.fetchOffsetsHandler().apply((Object)groupId);
                if (tuple22 == null) {
                    throw new MatchError(null);
                }
                Errors error3 = (Errors)tuple22._1();
                Map currentOffsets = (Map)tuple22._2();
                void error4 = var16_16;
                void currentOffsets2 = var17_17;
                void v4 = error4;
                Errors errors3 = Errors.NOT_COORDINATOR;
                if (!(v4 != null ? !v4.equals(errors3) : errors3 != null)) {
                    ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(69).append("Ignoring group ").append(groupId).append(" because it is not hosted on this coordinator anymore.").toString());
                    return BoxedUnit.UNIT;
                }
                void v5 = error4;
                Errors errors4 = Errors.NONE;
                if (v5 == null ? errors4 != null : !v5.equals(errors4)) {
                    ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(70).append("Could not fetch offsets of group ").append(groupId).append(" due to ").append(error4).append(". Will retry in the next run.").toString());
                    return failedGroups.$plus$eq((Object)groupId);
                }
                scala.collection.mutable.Map memberTopicPartitions = (scala.collection.mutable.Map)groupsToCurrentOffsets.getOrElse((Object)groupId, (Function0 & Serializable & scala.Serializable)() -> Map$.MODULE$.empty());
                Function1<List<TopicPartition>, List<TopicPartition>> maybePrefixTopicPartitions = this.maybePrefixTopicPartitionsWithTenantFunction(groupId);
                groupSummary2.members().foreach(arg_0 -> ConsumerLagEmitter.$anonfun$fetchOffsetsAndRecordLag$3$adapted(maybePrefixTopicPartitions, (Map)currentOffsets2, groupId, (Errors)error4, memberTopicPartitions, arg_0));
                if (memberTopicPartitions.nonEmpty()) {
                    return groupsToCurrentOffsets.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)groupId), (Object)memberTopicPartitions));
                }
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        if (groupsToCurrentOffsets.nonEmpty()) {
            void forKeyValue$extension_f;
            void forKeyValue$extension_$this;
            java.util.Map latestOffsetSpec = (java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)groupsToCurrentOffsets.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                scala.collection.mutable.Map map = (scala.collection.mutable.Map)((scala.collection.mutable.Map)x0$1._2()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    if (x0$2 == null) {
                        throw new MatchError(null);
                    }
                    MemberTopicPartition memberTopicPartition = (MemberTopicPartition)x0$2._1();
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)memberTopicPartition.topicPartition()), (Object)OffsetSpec.latest());
                    return tuple2;
                }, Map$.MODULE$.canBuildFrom());
                return map;
            }, Map$.MODULE$.canBuildFrom())).asJava();
            ListOffsetsResult result = this.admin().listOffsets(latestOffsetSpec);
            Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(groupId, memberTopicPartitions) -> {
                void forKeyValue$extension_f;
                void forKeyValue$extension_$this;
                GaugeSuite groupGaugeSuite = (GaugeSuite)this.consumerLagMetrics().getOrElse(groupId, (Function0 & Serializable & scala.Serializable)() -> this.createGaugeSuite((String)groupId));
                Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(memberTopicPartition, currentOffset) -> {
                    ConsumerLagEmitter.$anonfun$fetchOffsetsAndRecordLag$9(result, groupGaugeSuite, memberTopicPartition, BoxesRunTime.unboxToLong((Object)currentOffset));
                    return BoxedUnit.UNIT;
                };
                Map map = Implicits$.MODULE$.MapExtensionMethods(memberTopicPartitions);
                if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                    throw null;
                }
                MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
                return (scala.collection.mutable.Map)this.consumerLagMetrics().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(groupId), (Object)groupGaugeSuite));
            };
            Map map = Implicits$.MODULE$.MapExtensionMethods(groupsToCurrentOffsets);
            if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                throw null;
            }
            MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        }
        Set expiredGroups = this.consumerLagMetrics().filterNot((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ConsumerLagEmitter.$anonfun$fetchOffsetsAndRecordLag$10(groupsToCurrentOffsets, rebalancingGroups, failedGroups, x0$3))).keySet();
        expiredGroups.foreach((Function1 & Serializable & scala.Serializable)groupId -> {
            ConsumerLagEmitter.$anonfun$fetchOffsetsAndRecordLag$12(this, groupId);
            return BoxedUnit.UNIT;
        });
        long executionTime = System.currentTimeMillis() - startTime;
        return new ConsumerLagEmitterSummary(groupsToCurrentOffsets.keySet().size(), rebalancingGroups.size(), failedGroups.size(), expiredGroups.size(), this.currentMetricsSize(), executionTime);
    }

    private GaugeSuite<MemberTopicPartition, Object> createGaugeSuite(String groupId) {
        return new GaugeSuite(ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$gaugeSuiteLog(), new StringBuilder(21).append("consumer-lag-emitter-").append(groupId).toString(), this.metrics(), memberTopicPartition -> this.metrics().metricName(ConsumerLagEmitter$.MODULE$.ConsumerLagMetricName(), "tenant-metrics", "The group member's consumer lag in offsets.", (java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter(memberTopicPartition.tags()).asJava()));
    }

    private long currentMetricsSize() {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.consumerLagMetrics().map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)ConsumerLagEmitter.$anonfun$currentMetricsSize$1(x0$1)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public Function1<List<TopicPartition>, List<TopicPartition>> maybePrefixTopicPartitionsWithTenantFunction(String groupId) {
        if (TenantHelpers.isTenantPrefixed(groupId)) {
            return arg_0 -> ConsumerLagEmitter.$anonfun$maybePrefixTopicPartitionsWithTenantFunction$1(TenantHelpers.extractTenantPrefix(groupId), arg_0);
        }
        return (Function1 & Serializable & scala.Serializable)topicPartitions -> topicPartitions;
    }

    public static final /* synthetic */ void $anonfun$fetchOffsetsAndRecordLag$3(Function1 maybePrefixTopicPartitions$1, Map currentOffsets$1, String groupId$1, Errors error$1, scala.collection.mutable.Map memberTopicPartitions$1, MemberSummary member) {
        try {
            ConsumerPartitionAssignor.Assignment assignment = ConsumerProtocol.deserializeAssignment((ByteBuffer)ByteBuffer.wrap(member.assignment()));
            ((List)maybePrefixTopicPartitions$1.apply((Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(assignment.partitions()).asScala()).toList())).foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
                BoxedUnit boxedUnit;
                Option option = currentOffsets$1.get(topicPartition);
                if (option instanceof Some) {
                    scala.collection.mutable.MapLike mapLike;
                    OffsetFetchResponse.PartitionData currentOffset = (OffsetFetchResponse.PartitionData)((Some)option).value();
                    Errors errors = currentOffset.error;
                    Errors errors2 = Errors.NONE;
                    if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                        ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(93).append("Could not get committed offset for group ").append(groupId$1).append(" and partition ").append(topicPartition).append(" due to ").append(error$1).append(". Will retry in the next run.").toString());
                        mapLike = BoxedUnit.UNIT;
                    } else {
                        MemberTopicPartition memberTopicPartition = new MemberTopicPartition(groupId$1, member.groupInstanceId(), member.memberId(), member.clientId(), (TopicPartition)topicPartition);
                        mapLike = memberTopicPartitions$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)memberTopicPartition), (Object)BoxesRunTime.boxToLong((long)currentOffset.offset)));
                    }
                    boxedUnit = mapLike;
                } else if (None$.MODULE$.equals(option)) {
                    ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(72).append("Group coordinator does not have offsets for group ").append(groupId$1).append(" and topic partition ").append(topicPartition).append(".").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option);
                }
                return boxedUnit;
            });
            return;
        }
        catch (SchemaException e) {
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(66).append("Failed to deserialize assignment(length=").append(member.assignment().length).append(") for group ").append(groupId$1).append(" and member ").append(member.memberId()).append(": ").append(e.getMessage()).toString());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$fetchOffsetsAndRecordLag$9(ListOffsetsResult result$1, GaugeSuite groupGaugeSuite$1, MemberTopicPartition memberTopicPartition, long currentOffset) {
        try {
            long latestOffset = ((ListOffsetsResult.ListOffsetsResultInfo)result$1.partitionResult(memberTopicPartition.topicPartition()).get()).offset();
            long consumerLag = latestOffset - currentOffset;
            if (consumerLag >= 0L) {
                groupGaugeSuite$1.update((Object)memberTopicPartition, (Object)BoxesRunTime.boxToLong((long)consumerLag));
                return;
            }
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().warn(new StringBuilder(115).append("Consumer lag of member ").append(memberTopicPartition).append(" is negative. Latest offset is ").append(latestOffset).append(" ").append("and committed offset is ").append(currentOffset).append(". The topic may have been recreated.").toString());
            groupGaugeSuite$1.update((Object)memberTopicPartition, (Object)BoxesRunTime.boxToLong((long)0L));
        }
        catch (ExecutionException e) {
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(45).append("Could not list offsets for partition ").append(memberTopicPartition.topicPartition()).append(" due to ").append(e.getCause().getMessage()).toString());
            return;
        }
        catch (InterruptedException e) {
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(45).append("Unable to list offsets for partition ").append(memberTopicPartition.topicPartition()).append(" due to ").append(e.getCause()).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffsetsAndRecordLag$10(scala.collection.mutable.Map groupsToCurrentOffsets$1, scala.collection.mutable.Set rebalancingGroups$1, scala.collection.mutable.Set failedGroups$1, Tuple2 x0$3) {
        boolean bl;
        if (x0$3 != null) {
            String groupId = (String)x0$3._1();
            GaugeSuite groupGaugeSuite = (GaugeSuite)x0$3._2();
            if (groupsToCurrentOffsets$1.contains((Object)groupId)) {
                Set currentMemberTopicPartitions = ((MapLike)groupsToCurrentOffsets$1.apply((Object)groupId)).keySet();
                ((scala.collection.mutable.Set)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(groupGaugeSuite.keySet()).asScala()).diff((GenSet)currentMemberTopicPartitions)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    groupGaugeSuite.remove((Object)x$1);
                    return BoxedUnit.UNIT;
                });
                groupGaugeSuite.flush();
                bl = groupGaugeSuite.keySet().size() != 0;
            } else {
                bl = rebalancingGroups$1.contains((Object)groupId) || failedGroups$1.contains((Object)groupId);
            }
        } else {
            throw new MatchError(null);
        }
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ void $anonfun$fetchOffsetsAndRecordLag$12(ConsumerLagEmitter $this, String groupId) {
        $this.consumerLagMetrics().remove((Object)groupId).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.close();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ int $anonfun$currentMetricsSize$1(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        int n = ((GaugeSuite)x0$1._2()).keySet().size();
        return n;
    }

    public static final /* synthetic */ List $anonfun$maybePrefixTopicPartitionsWithTenantFunction$1(String prefix$1, List topicPartitions) {
        return (List)topicPartitions.map((Function1 & Serializable & scala.Serializable)x$6 -> TenantHelpers.prefixWithTenant(prefix$1, x$6), List$.MODULE$.canBuildFrom());
    }

    public ConsumerLagEmitter(Metrics metrics, Scheduler scheduler, Function1<scala.collection.immutable.Set<String>, Tuple2<Errors, List<GroupOverview>>> listGroupsHandler, Function1<String, Tuple2<Errors, GroupSummary>> describeGroupHandler, Function1<String, Tuple2<Errors, Map<TopicPartition, OffsetFetchResponse.PartitionData>>> fetchOffsetsHandler, long emitIntervalMs, Admin admin) {
        this.metrics = metrics;
        this.scheduler = scheduler;
        this.listGroupsHandler = listGroupsHandler;
        this.describeGroupHandler = describeGroupHandler;
        this.fetchOffsetsHandler = fetchOffsetsHandler;
        this.emitIntervalMs = emitIntervalMs;
        this.admin = admin;
        this.consumerLagMetrics = Map$.MODULE$.empty();
        this.kafka$metrics$ConsumerLagEmitter$$updatedGroupSize = 0;
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.UpdatedGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), (MetricValueProvider)new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public int value(MetricConfig config, long now) {
                return this.$outer.kafka$metrics$ConsumerLagEmitter$$updatedGroupSize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize = 0;
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.RebalancingGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), (MetricValueProvider)new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public int value(MetricConfig config, long now) {
                return this.$outer.kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$metrics$ConsumerLagEmitter$$failedGroupSize = 0;
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.FailedGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), (MetricValueProvider)new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public int value(MetricConfig config, long now) {
                return this.$outer.kafka$metrics$ConsumerLagEmitter$$failedGroupSize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$metrics$ConsumerLagEmitter$$expiredGroupSize = 0;
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), (MetricValueProvider)new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public int value(MetricConfig config, long now) {
                return this.$outer.kafka$metrics$ConsumerLagEmitter$$expiredGroupSize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$metrics$ConsumerLagEmitter$$metricsSize = 0L;
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), (MetricValueProvider)new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public long value(MetricConfig config, long now) {
                return this.$outer.kafka$metrics$ConsumerLagEmitter$$metricsSize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$metrics$ConsumerLagEmitter$$executionTime = 0L;
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.ExecutionTimeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), (MetricValueProvider)new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public long value(MetricConfig config, long now) {
                return this.$outer.kafka$metrics$ConsumerLagEmitter$$executionTime();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs = System.currentTimeMillis();
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.TimeSinceLastSuccessfulRunMsMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), (MetricValueProvider)new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public long value(MetricConfig config, long now) {
                return System.currentTimeMillis() - this.$outer.kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static final /* synthetic */ Object $anonfun$fetchOffsetsAndRecordLag$3$adapted(Function1 maybePrefixTopicPartitions$1, Map currentOffsets$1, String groupId$1, Errors error$1, scala.collection.mutable.Map memberTopicPartitions$1, MemberSummary member) {
        try {
            ConsumerPartitionAssignor.Assignment $anonfun$fetchOffsetsAndRecordLag$3_assignment = ConsumerProtocol.deserializeAssignment((ByteBuffer)ByteBuffer.wrap(member.assignment()));
            ((List)maybePrefixTopicPartitions$1.apply((Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter($anonfun$fetchOffsetsAndRecordLag$3_assignment.partitions()).asScala()).toList())).foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
                BoxedUnit boxedUnit;
                Option option = currentOffsets$1.get(topicPartition);
                if (option instanceof Some) {
                    scala.collection.mutable.MapLike mapLike;
                    OffsetFetchResponse.PartitionData currentOffset = (OffsetFetchResponse.PartitionData)((Some)option).value();
                    Errors errors = currentOffset.error;
                    Errors errors2 = Errors.NONE;
                    if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                        ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(93).append("Could not get committed offset for group ").append(groupId$1).append(" and partition ").append(topicPartition).append(" due to ").append(error$1).append(". Will retry in the next run.").toString());
                        mapLike = BoxedUnit.UNIT;
                    } else {
                        MemberTopicPartition memberTopicPartition = new MemberTopicPartition(groupId$1, member.groupInstanceId(), member.memberId(), member.clientId(), (TopicPartition)topicPartition);
                        mapLike = memberTopicPartitions$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)memberTopicPartition), (Object)BoxesRunTime.boxToLong((long)currentOffset.offset)));
                    }
                    boxedUnit = mapLike;
                } else if (None$.MODULE$.equals(option)) {
                    ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(72).append("Group coordinator does not have offsets for group ").append(groupId$1).append(" and topic partition ").append(topicPartition).append(".").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option);
                }
                return boxedUnit;
            });
        }
        catch (SchemaException $anonfun$fetchOffsetsAndRecordLag$3_e) {
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(66).append("Failed to deserialize assignment(length=").append(member.assignment().length).append(") for group ").append(groupId$1).append(" and member ").append(member.memberId()).append(": ").append($anonfun$fetchOffsetsAndRecordLag$3_e.getMessage()).toString());
        }
        return BoxedUnit.UNIT;
    }
}

