/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.availability.FilesWrapper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import kafka.log.AbortedTxn;
import kafka.log.AbortedTxn$;
import kafka.log.CorruptIndexException;
import kafka.log.TransactionIndex$;
import kafka.log.TxnIndexSearchResult;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001B\u0012%\u0001%B\u0001B\u000e\u0001\u0003\u0006\u0004%\ta\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005q!AA\b\u0001BA\u0002\u0013%Q\b\u0003\u0005G\u0001\t\u0005\r\u0011\"\u0003H\u0011!i\u0005A!A!B\u0013q\u0004\u0002\u0003*\u0001\u0005\u000b\u0007I\u0011A*\t\u0011]\u0003!\u0011!Q\u0001\nQCQ\u0001\u0017\u0001\u0005\u0002eCqa\u0018\u0001A\u0002\u0013%\u0001\rC\u0004m\u0001\u0001\u0007I\u0011B7\t\r=\u0004\u0001\u0015)\u0003b\u0011\u001d\t\b\u00011A\u0005\nIDq\u0001\u001e\u0001A\u0002\u0013%Q\u000f\u0003\u0004x\u0001\u0001\u0006Ka\u001d\u0005\u0006q\u0002!\t!\u001f\u0005\u0007\u007f\u0002!\t!!\u0001\t\r\u0005\r\u0001\u0001\"\u0001>\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000fAq!!\u0004\u0001\t\u0003\ty\u0001C\u0004\u0002\u0012\u0001!I!a\u0005\t\u000f\u0005U\u0001\u0001\"\u0003\u0002\u0014!9\u0011q\u0003\u0001\u0005\u0002\u0005\u0005\u0001bBA\r\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u00037\u0001A\u0011AA\u000f\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003KAq!a\u000b\u0001\t\u0013\ti\u0003C\u0005\u0002f\u0001\t\n\u0011\"\u0003\u0002h!9\u0011Q\u0010\u0001\u0005\u0002\u0005}\u0004bBAD\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u00033\u0003A\u0011AA\u0001\u000f%\t\u0019\u000bJA\u0001\u0012\u0003\t)K\u0002\u0005$I\u0005\u0005\t\u0012AAT\u0011\u0019A\u0006\u0005\"\u0001\u0002*\"I\u00111\u0016\u0011\u0012\u0002\u0013\u0005\u0011Q\u0016\u0002\u0011)J\fgn]1di&|g.\u00138eKbT!!\n\u0014\u0002\u00071|wMC\u0001(\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u00161!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0019\te.\u001f*fMB\u0011\u0011\u0007N\u0007\u0002e)\u00111GJ\u0001\u0006kRLGn]\u0005\u0003kI\u0012q\u0001T8hO&tw-A\u0006ti\u0006\u0014Ho\u00144gg\u0016$X#\u0001\u001d\u0011\u0005-J\u0014B\u0001\u001e-\u0005\u0011auN\\4\u0002\u0019M$\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0011\u0002\u000b}3\u0017\u000e\\3\u0016\u0003y\u0002\"a\u0010#\u000e\u0003\u0001S!!\u0011\"\u0002\u0005%|'\"A\"\u0002\t)\fg/Y\u0005\u0003\u000b\u0002\u0013AAR5mK\u0006IqLZ5mK~#S-\u001d\u000b\u0003\u0011.\u0003\"aK%\n\u0005)c#\u0001B+oSRDq\u0001\u0014\u0003\u0002\u0002\u0003\u0007a(A\u0002yIE\naa\u00184jY\u0016\u0004\u0003FA\u0003P!\tY\u0003+\u0003\u0002RY\tAao\u001c7bi&dW-A\tgS2,\u0017\t\u001c:fC\u0012LX\t_5tiN,\u0012\u0001\u0016\t\u0003WUK!A\u0016\u0017\u0003\u000f\t{w\u000e\\3b]\u0006\u0011b-\u001b7f\u00032\u0014X-\u00193z\u000bbL7\u000f^:!\u0003\u0019a\u0014N\\5u}Q!!\fX/_!\tY\u0006!D\u0001%\u0011\u00151\u0004\u00021\u00019\u0011\u0015a\u0004\u00021\u0001?\u0011\u001d\u0011\u0006\u0002%AA\u0002Q\u000bA\"\\1zE\u0016\u001c\u0005.\u00198oK2,\u0012!\u0019\t\u0004W\t$\u0017BA2-\u0005\u0019y\u0005\u000f^5p]B\u0011QM[\u0007\u0002M*\u0011q\r[\u0001\tG\"\fgN\\3mg*\u0011\u0011NQ\u0001\u0004]&|\u0017BA6g\u0005-1\u0015\u000e\\3DQ\u0006tg.\u001a7\u0002!5\f\u0017PY3DQ\u0006tg.\u001a7`I\u0015\fHC\u0001%o\u0011\u001da%\"!AA\u0002\u0005\fQ\"\\1zE\u0016\u001c\u0005.\u00198oK2\u0004\u0003FA\u0006P\u0003)a\u0017m\u001d;PM\u001a\u001cX\r^\u000b\u0002gB\u00191F\u0019\u001d\u0002\u001d1\f7\u000f^(gMN,Go\u0018\u0013fcR\u0011\u0001J\u001e\u0005\b\u00196\t\t\u00111\u0001t\u0003-a\u0017m\u001d;PM\u001a\u001cX\r\u001e\u0011\u0002\r\u0005\u0004\b/\u001a8e)\tA%\u0010C\u0003|\u001f\u0001\u0007A0\u0001\u0006bE>\u0014H/\u001a3Uq:\u0004\"aW?\n\u0005y$#AC!c_J$X\r\u001a+y]\u0006)a\r\\;tQR\t\u0001*\u0001\u0003gS2,\u0017aD;qI\u0006$X\rU1sK:$H)\u001b:\u0015\u0007!\u000bI\u0001\u0003\u0004\u0002\fI\u0001\rAP\u0001\na\u0006\u0014XM\u001c;ESJ\fa\u0002Z3mKR,\u0017JZ#ySN$8\u000fF\u0001U\u0003\u001d\u0019\u0007.\u00198oK2$\u0012\u0001Z\u0001\f_B,gn\u00115b]:,G.A\u0003sKN,G/A\u0003dY>\u001cX-\u0001\u0005sK:\fW.\u001a+p)\rA\u0015q\u0004\u0005\u0007\u0003CA\u0002\u0019\u0001 \u0002\u0003\u0019\f!\u0002\u001e:v]\u000e\fG/\u001a+p)\rA\u0015q\u0005\u0005\u0007\u0003SI\u0002\u0019\u0001\u001d\u0002\r=4gm]3u\u0003!IG/\u001a:bi>\u0014H\u0003BA\u0018\u0003'\u0002b!!\r\u0002B\u0005\u001dc\u0002BA\u001a\u0003{qA!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0004\u0003sA\u0013A\u0002\u001fs_>$h(C\u0001.\u0013\r\ty\u0004L\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019%!\u0012\u0003\u0011%#XM]1u_JT1!a\u0010-!\u0019Y\u0013\u0011\n?\u0002N%\u0019\u00111\n\u0017\u0003\rQ+\b\u000f\\33!\rY\u0013qJ\u0005\u0004\u0003#b#aA%oi\"I\u0011Q\u000b\u000e\u0011\u0002\u0003\u0007\u0011qK\u0001\tC2dwnY1uKB)1&!\u0017\u0002^%\u0019\u00111\f\u0017\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004\u0003BA0\u0003Cj\u0011\u0001[\u0005\u0004\u0003GB'A\u0003\"zi\u0016\u0014UO\u001a4fe\u0006\u0011\u0012\u000e^3sCR|'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\tIG\u000b\u0003\u0002X\u0005-4FAA7!\u0011\ty'!\u001f\u000e\u0005\u0005E$\u0002BA:\u0003k\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]D&\u0001\u0006b]:|G/\u0019;j_:LA!a\u001f\u0002r\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\u0005dG.\u00112peR,G\r\u0016=ogV\u0011\u0011\u0011\u0011\t\u0006\u0003c\t\u0019\t`\u0005\u0005\u0003\u000b\u000b)E\u0001\u0003MSN$\u0018AE2pY2,7\r^!c_J$X\r\u001a+y]N$b!a#\u0002\u0012\u0006U\u0005cA.\u0002\u000e&\u0019\u0011q\u0012\u0013\u0003)QCh.\u00138eKb\u001cV-\u0019:dQJ+7/\u001e7u\u0011\u0019\t\u0019*\ba\u0001q\u0005Ya-\u001a;dQ>3gm]3u\u0011\u0019\t9*\ba\u0001q\u0005\u0001R\u000f\u001d9fe\n{WO\u001c3PM\u001a\u001cX\r^\u0001\fg\u0006t\u0017\u000e^=DQ\u0016\u001c7\u000eK\u0002\u0001\u0003;\u00032!MAP\u0013\r\t\tK\r\u0002\u000e]>tG\u000f\u001b:fC\u0012\u001c\u0018MZ3\u0002!Q\u0013\u0018M\\:bGRLwN\\%oI\u0016D\bCA.!'\t\u0001#\u0006\u0006\u0002\u0002&\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"!a,+\u0007Q\u000bY\u0007")
public class TransactionIndex
implements Logging {
    private final long startOffset;
    private volatile File _file;
    private final boolean fileAlreadyExists;
    private volatile Option<FileChannel> maybeChannel;
    private Option<Object> lastOffset;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$3() {
        return TransactionIndex$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public long startOffset() {
        return this.startOffset;
    }

    private File _file() {
        return this._file;
    }

    private void _file_$eq(File x$1) {
        this._file = x$1;
    }

    public boolean fileAlreadyExists() {
        return this.fileAlreadyExists;
    }

    private Option<FileChannel> maybeChannel() {
        return this.maybeChannel;
    }

    private void maybeChannel_$eq(Option<FileChannel> x$1) {
        this.maybeChannel = x$1;
    }

    private Option<Object> lastOffset() {
        return this.lastOffset;
    }

    private void lastOffset_$eq(Option<Object> x$1) {
        this.lastOffset = x$1;
    }

    public void append(AbortedTxn abortedTxn) {
        this.lastOffset().foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)offset -> {
            if (offset >= abortedTxn.lastOffset()) {
                throw new IllegalArgumentException(new java.lang.StringBuilder(124).append("The last offset of appended transactions must increase sequentially, but ").append(abortedTxn.lastOffset()).append(" is not greater than current last offset ").append(offset).append(" of index ").append(this.file().getAbsolutePath()).toString());
            }
        });
        this.lastOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)abortedTxn.lastOffset())));
        Utils.writeFully((FileChannel)this.channel(), (ByteBuffer)abortedTxn.buffer().duplicate());
    }

    public void flush() {
        this.maybeChannel().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.force(true);
            return BoxedUnit.UNIT;
        });
    }

    public File file() {
        return this._file();
    }

    public void updateParentDir(File parentDir) {
        this._file_$eq(new File(parentDir, this.file().getName()));
    }

    public boolean deleteIfExists() {
        this.close();
        return FilesWrapper.deleteIfExists((Path)this.file().toPath());
    }

    private FileChannel channel() {
        FileChannel fileChannel;
        Option<FileChannel> option = this.maybeChannel();
        if (option instanceof Some) {
            fileChannel = (FileChannel)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            fileChannel = this.openChannel();
        } else {
            throw new MatchError(option);
        }
        return fileChannel;
    }

    /*
     * WARNING - void declaration
     */
    private FileChannel openChannel() {
        void var1_1;
        FileChannel channel = FileChannel.open(this.file().toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        if (!this.fileAlreadyExists() && channel.size() > 0L) {
            channel.close();
            throw new IllegalStateException(new java.lang.StringBuilder(68).append("Non-empty transaction index file ").append(this.file()).append(" already exists while it shouldn't.").toString());
        }
        this.maybeChannel_$eq((Option<FileChannel>)new Some((Object)channel));
        channel.position(channel.size());
        return var1_1;
    }

    public void reset() {
        this.maybeChannel().foreach((Function1 & Serializable & scala.Serializable)x$2 -> x$2.truncate(0L));
        this.lastOffset_$eq((Option<Object>)None$.MODULE$);
    }

    public void close() {
        this.maybeChannel().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        });
        this.maybeChannel_$eq((Option<FileChannel>)None$.MODULE$);
    }

    public void renameTo(File f) {
        try {
            if (this.file().exists()) {
                Utils.atomicMoveWithFallback((Path)this.file().toPath(), (Path)f.toPath(), (boolean)false);
            }
        }
        finally {
            this._file_$eq(f);
        }
    }

    public void truncateTo(long offset) {
        Object object = new Object();
        try {
            Iterator iterator;
            ByteBuffer buffer = ByteBuffer.allocate(AbortedTxn$.MODULE$.TotalSize());
            ObjectRef newLastOffset = ObjectRef.create((Object)None$.MODULE$);
            Function0 & Serializable & scala.Serializable iterator_allocate = (Function0 & Serializable & scala.Serializable)() -> buffer;
            Option<FileChannel> option = this.maybeChannel();
            if (None$.MODULE$.equals(option)) {
                iterator = package$.MODULE$.Iterator().empty();
            } else if (option instanceof Some) {
                FileChannel iterator_channel = (FileChannel)((Some)option).value();
                IntRef iterator_position = IntRef.create((int)0);
                iterator = new Iterator<Tuple2<AbortedTxn, Object>>(this, iterator_channel, iterator_position, (Function0)iterator_allocate){
                    private final /* synthetic */ TransactionIndex $outer;
                    private final FileChannel channel$1;
                    private final IntRef position$1;
                    private final Function0 allocate$1;

                    public Iterator<Tuple2<AbortedTxn, Object>> seq() {
                        return Iterator.seq$((Iterator)this);
                    }

                    public boolean isEmpty() {
                        return Iterator.isEmpty$((Iterator)this);
                    }

                    public boolean isTraversableAgain() {
                        return Iterator.isTraversableAgain$((Iterator)this);
                    }

                    public boolean hasDefiniteSize() {
                        return Iterator.hasDefiniteSize$((Iterator)this);
                    }

                    public Iterator<Tuple2<AbortedTxn, Object>> take(int n) {
                        return Iterator.take$((Iterator)this, (int)n);
                    }

                    public Iterator<Tuple2<AbortedTxn, Object>> drop(int n) {
                        return Iterator.drop$((Iterator)this, (int)n);
                    }

                    public Iterator<Tuple2<AbortedTxn, Object>> slice(int from, int until) {
                        return Iterator.slice$((Iterator)this, (int)from, (int)until);
                    }

                    public Iterator<Tuple2<AbortedTxn, Object>> sliceIterator(int from, int until) {
                        return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                    }

                    public <B> Iterator<B> map(Function1<Tuple2<AbortedTxn, Object>, B> f) {
                        return Iterator.map$((Iterator)this, f);
                    }

                    public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                        return Iterator.$plus$plus$((Iterator)this, that);
                    }

                    public <B> Iterator<B> flatMap(Function1<Tuple2<AbortedTxn, Object>, GenTraversableOnce<B>> f) {
                        return Iterator.flatMap$((Iterator)this, f);
                    }

                    public Iterator<Tuple2<AbortedTxn, Object>> filter(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                        return Iterator.filter$((Iterator)this, p);
                    }

                    public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Tuple2<AbortedTxn, Object>, B, Object> p) {
                        return Iterator.corresponds$((Iterator)this, that, p);
                    }

                    public Iterator<Tuple2<AbortedTxn, Object>> withFilter(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                        return Iterator.withFilter$((Iterator)this, p);
                    }

                    public Iterator<Tuple2<AbortedTxn, Object>> filterNot(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                        return Iterator.filterNot$((Iterator)this, p);
                    }

                    public <B> Iterator<B> collect(PartialFunction<Tuple2<AbortedTxn, Object>, B> pf) {
                        return Iterator.collect$((Iterator)this, pf);
                    }

                    public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple2<AbortedTxn, Object>, B> op) {
                        return Iterator.scanLeft$((Iterator)this, z, op);
                    }

                    public <B> Iterator<B> scanRight(B z, Function2<Tuple2<AbortedTxn, Object>, B, B> op) {
                        return Iterator.scanRight$((Iterator)this, z, op);
                    }

                    public Iterator<Tuple2<AbortedTxn, Object>> takeWhile(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                        return Iterator.takeWhile$((Iterator)this, p);
                    }

                    public Tuple2<Iterator<Tuple2<AbortedTxn, Object>>, Iterator<Tuple2<AbortedTxn, Object>>> partition(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                        return Iterator.partition$((Iterator)this, p);
                    }

                    public Tuple2<Iterator<Tuple2<AbortedTxn, Object>>, Iterator<Tuple2<AbortedTxn, Object>>> span(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                        return Iterator.span$((Iterator)this, p);
                    }

                    public Iterator<Tuple2<AbortedTxn, Object>> dropWhile(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                        return Iterator.dropWhile$((Iterator)this, p);
                    }

                    public <B> Iterator<Tuple2<Tuple2<AbortedTxn, Object>, B>> zip(Iterator<B> that) {
                        return Iterator.zip$((Iterator)this, that);
                    }

                    public <A1> Iterator<A1> padTo(int len, A1 elem) {
                        return Iterator.padTo$((Iterator)this, (int)len, elem);
                    }

                    public Iterator<Tuple2<Tuple2<AbortedTxn, Object>, Object>> zipWithIndex() {
                        return Iterator.zipWithIndex$((Iterator)this);
                    }

                    public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                        return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                    }

                    public <U> void foreach(Function1<Tuple2<AbortedTxn, Object>, U> f) {
                        Iterator.foreach$((Iterator)this, f);
                    }

                    public boolean forall(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                        return Iterator.forall$((Iterator)this, p);
                    }

                    public boolean exists(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                        return Iterator.exists$((Iterator)this, p);
                    }

                    public boolean contains(Object elem) {
                        return Iterator.contains$((Iterator)this, (Object)elem);
                    }

                    public Option<Tuple2<AbortedTxn, Object>> find(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                        return Iterator.find$((Iterator)this, p);
                    }

                    public int indexWhere(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                        return Iterator.indexWhere$((Iterator)this, p);
                    }

                    public int indexWhere(Function1<Tuple2<AbortedTxn, Object>, Object> p, int from) {
                        return Iterator.indexWhere$((Iterator)this, p, (int)from);
                    }

                    public <B> int indexOf(B elem) {
                        return Iterator.indexOf$((Iterator)this, elem);
                    }

                    public <B> int indexOf(B elem, int from) {
                        return Iterator.indexOf$((Iterator)this, elem, (int)from);
                    }

                    public BufferedIterator<Tuple2<AbortedTxn, Object>> buffered() {
                        return Iterator.buffered$((Iterator)this);
                    }

                    public <B> Iterator.GroupedIterator<B> grouped(int size) {
                        return Iterator.grouped$((Iterator)this, (int)size);
                    }

                    public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                        return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                    }

                    public <B> int sliding$default$2() {
                        return Iterator.sliding$default$2$((Iterator)this);
                    }

                    public int length() {
                        return Iterator.length$((Iterator)this);
                    }

                    public Tuple2<Iterator<Tuple2<AbortedTxn, Object>>, Iterator<Tuple2<AbortedTxn, Object>>> duplicate() {
                        return Iterator.duplicate$((Iterator)this);
                    }

                    public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                        return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                    }

                    public <B> void copyToArray(Object xs, int start, int len) {
                        Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
                    }

                    public boolean sameElements(Iterator<?> that) {
                        return Iterator.sameElements$((Iterator)this, that);
                    }

                    public Traversable<Tuple2<AbortedTxn, Object>> toTraversable() {
                        return Iterator.toTraversable$((Iterator)this);
                    }

                    public Iterator<Tuple2<AbortedTxn, Object>> toIterator() {
                        return Iterator.toIterator$((Iterator)this);
                    }

                    public Stream<Tuple2<AbortedTxn, Object>> toStream() {
                        return Iterator.toStream$((Iterator)this);
                    }

                    public String toString() {
                        return Iterator.toString$((Iterator)this);
                    }

                    public List<Tuple2<AbortedTxn, Object>> reversed() {
                        return TraversableOnce.reversed$((TraversableOnce)this);
                    }

                    public int size() {
                        return TraversableOnce.size$((TraversableOnce)this);
                    }

                    public boolean nonEmpty() {
                        return TraversableOnce.nonEmpty$((TraversableOnce)this);
                    }

                    public int count(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                        return TraversableOnce.count$((TraversableOnce)this, p);
                    }

                    public <B> Option<B> collectFirst(PartialFunction<Tuple2<AbortedTxn, Object>, B> pf) {
                        return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                    }

                    public <B> B $div$colon(B z, Function2<B, Tuple2<AbortedTxn, Object>, B> op) {
                        return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                    }

                    public <B> B $colon$bslash(B z, Function2<Tuple2<AbortedTxn, Object>, B, B> op) {
                        return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                    }

                    public <B> B foldLeft(B z, Function2<B, Tuple2<AbortedTxn, Object>, B> op) {
                        return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                    }

                    public <B> B foldRight(B z, Function2<Tuple2<AbortedTxn, Object>, B, B> op) {
                        return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
                    }

                    public <B> B reduceLeft(Function2<B, Tuple2<AbortedTxn, Object>, B> op) {
                        return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                    }

                    public <B> B reduceRight(Function2<Tuple2<AbortedTxn, Object>, B, B> op) {
                        return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceLeftOption(Function2<B, Tuple2<AbortedTxn, Object>, B> op) {
                        return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceRightOption(Function2<Tuple2<AbortedTxn, Object>, B, B> op) {
                        return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                    }

                    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                    }

                    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                        return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                    }

                    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                    }

                    public <B> B aggregate(Function0<B> z, Function2<B, Tuple2<AbortedTxn, Object>, B> seqop, Function2<B, B, B> combop) {
                        return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                    }

                    public <B> B sum(Numeric<B> num) {
                        return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                    }

                    public <B> B product(Numeric<B> num) {
                        return (B)TraversableOnce.product$((TraversableOnce)this, num);
                    }

                    public Object min(Ordering cmp) {
                        return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object max(Ordering cmp) {
                        return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object maxBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public Object minBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public <B> void copyToBuffer(Buffer<B> dest) {
                        TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                    }

                    public <B> void copyToArray(Object xs, int start) {
                        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                    }

                    public <B> void copyToArray(Object xs) {
                        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                    }

                    public <B> Object toArray(ClassTag<B> evidence$1) {
                        return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                    }

                    public List<Tuple2<AbortedTxn, Object>> toList() {
                        return TraversableOnce.toList$((TraversableOnce)this);
                    }

                    public Iterable<Tuple2<AbortedTxn, Object>> toIterable() {
                        return TraversableOnce.toIterable$((TraversableOnce)this);
                    }

                    public Seq<Tuple2<AbortedTxn, Object>> toSeq() {
                        return TraversableOnce.toSeq$((TraversableOnce)this);
                    }

                    public IndexedSeq<Tuple2<AbortedTxn, Object>> toIndexedSeq() {
                        return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                    }

                    public <B> Buffer<B> toBuffer() {
                        return TraversableOnce.toBuffer$((TraversableOnce)this);
                    }

                    public <B> Set<B> toSet() {
                        return TraversableOnce.toSet$((TraversableOnce)this);
                    }

                    public Vector<Tuple2<AbortedTxn, Object>> toVector() {
                        return TraversableOnce.toVector$((TraversableOnce)this);
                    }

                    public <Col> Col to(CanBuildFrom<Nothing$, Tuple2<AbortedTxn, Object>, Col> cbf) {
                        return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
                    }

                    public <T, U> Map<T, U> toMap(Predef.$less$colon$less<Tuple2<AbortedTxn, Object>, Tuple2<T, U>> ev) {
                        return TraversableOnce.toMap$((TraversableOnce)this, ev);
                    }

                    public String mkString(String start, String sep, String end) {
                        return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                    }

                    public String mkString(String sep) {
                        return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                    }

                    public String mkString() {
                        return TraversableOnce.mkString$((TraversableOnce)this);
                    }

                    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                    }

                    public StringBuilder addString(StringBuilder b, String sep) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                    }

                    public StringBuilder addString(StringBuilder b) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                    }

                    public int sizeHintIfCheap() {
                        return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                    }

                    public boolean hasNext() {
                        return this.channel$1.position() - (long)this.position$1.elem >= (long)AbortedTxn$.MODULE$.TotalSize();
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public Tuple2<AbortedTxn, Object> next() {
                        try {
                            void var3_3;
                            ByteBuffer buffer = (ByteBuffer)this.allocate$1.apply();
                            Utils.readFully((FileChannel)this.channel$1, (ByteBuffer)buffer, (long)this.position$1.elem);
                            buffer.flip();
                            AbortedTxn abortedTxn = new AbortedTxn(buffer);
                            if (abortedTxn.version() > AbortedTxn$.MODULE$.CurrentVersion()) {
                                throw new KafkaException(new java.lang.StringBuilder(82).append("Unexpected aborted transaction version ").append(abortedTxn.version()).append(" ").append("in transaction index ").append(this.$outer.file().getAbsolutePath()).append(", current version is ").append(AbortedTxn$.MODULE$.CurrentVersion()).toString());
                            }
                            Tuple2 nextEntry = new Tuple2((Object)abortedTxn, (Object)BoxesRunTime.boxToInteger((int)this.position$1.elem));
                            this.position$1.elem += AbortedTxn$.MODULE$.TotalSize();
                            return var3_3;
                        }
                        catch (IOException e) {
                            throw new KafkaException(new java.lang.StringBuilder(42).append("Failed to read from the transaction index ").append(this.$outer.file().getAbsolutePath()).toString(), (Throwable)e);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.channel$1 = channel$1;
                        this.position$1 = position$1;
                        this.allocate$1 = allocate$1;
                        GenTraversableOnce.$init$((GenTraversableOnce)this);
                        TraversableOnce.$init$((TraversableOnce)this);
                        Iterator.$init$((Iterator)this);
                    }
                };
            } else {
                throw new MatchError(option);
            }
            iterator.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                TransactionIndex.$anonfun$truncateTo$3(this, offset, newLastOffset, object, x$4);
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    private Iterator<Tuple2<AbortedTxn, Object>> iterator(Function0<ByteBuffer> allocate) {
        Iterator iterator;
        Option<FileChannel> option = this.maybeChannel();
        if (None$.MODULE$.equals(option)) {
            iterator = package$.MODULE$.Iterator().empty();
        } else if (option instanceof Some) {
            FileChannel channel = (FileChannel)((Some)option).value();
            IntRef position = IntRef.create((int)0);
            iterator = new /* invalid duplicate definition of identical inner class */;
        } else {
            throw new MatchError(option);
        }
        return iterator;
    }

    private Function0<ByteBuffer> iterator$default$1() {
        return (Function0 & Serializable & scala.Serializable)() -> ByteBuffer.allocate(AbortedTxn$.MODULE$.TotalSize());
    }

    public List<AbortedTxn> allAbortedTxns() {
        return this.iterator(this.iterator$default$1()).map((Function1 & Serializable & scala.Serializable)x$5 -> (AbortedTxn)x$5._1()).toList();
    }

    public TxnIndexSearchResult collectAbortedTxns(long fetchOffset, long upperBoundOffset) {
        Object object = new Object();
        try {
            ListBuffer abortedTransactions = (ListBuffer)ListBuffer$.MODULE$.empty();
            this.iterator(this.iterator$default$1()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                TransactionIndex.$anonfun$collectAbortedTxns$2(fetchOffset, upperBoundOffset, abortedTransactions, object, x$6);
                return BoxedUnit.UNIT;
            });
            return new TxnIndexSearchResult((List<AbortedTxn>)abortedTransactions.toList(), false);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (TxnIndexSearchResult)ex.value();
            }
            throw ex;
        }
    }

    public void sanityCheck() {
        Iterator iterator;
        Function0 & Serializable & scala.Serializable iterator_allocate = () -> TransactionIndex.$anonfun$sanityCheck$1(ByteBuffer.allocate(AbortedTxn$.MODULE$.TotalSize()));
        Option<FileChannel> option = this.maybeChannel();
        if (None$.MODULE$.equals(option)) {
            iterator = package$.MODULE$.Iterator().empty();
        } else if (option instanceof Some) {
            FileChannel iterator_channel = (FileChannel)((Some)option).value();
            IntRef iterator_position = IntRef.create((int)0);
            iterator = new /* invalid duplicate definition of identical inner class */;
        } else {
            throw new MatchError(option);
        }
        iterator.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$3 != null))).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            TransactionIndex.$anonfun$sanityCheck$3(this, x$7);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$truncateTo$3(TransactionIndex $this, long offset$1, ObjectRef newLastOffset$1, Object nonLocalReturnKey1$1, Tuple2 x$4) {
        if (x$4 != null) {
            AbortedTxn abortedTxn = (AbortedTxn)x$4._1();
            int position = x$4._2$mcI$sp();
            if (abortedTxn.lastOffset() >= offset$1) {
                $this.channel().truncate(position);
                $this.lastOffset_$eq((Option<Object>)((Option)newLastOffset$1.elem));
                throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
            }
            newLastOffset$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)abortedTxn.lastOffset()));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$collectAbortedTxns$2(long fetchOffset$1, long upperBoundOffset$1, ListBuffer abortedTransactions$1, Object nonLocalReturnKey2$1, Tuple2 x$6) {
        if (x$6 != null) {
            AbortedTxn abortedTxn = (AbortedTxn)x$6._1();
            if (abortedTxn.lastOffset() >= fetchOffset$1 && abortedTxn.firstOffset() < upperBoundOffset$1) {
                abortedTransactions$1.$plus$eq((Object)abortedTxn);
            }
            if (abortedTxn.lastStableOffset() >= upperBoundOffset$1) {
                throw new NonLocalReturnControl(nonLocalReturnKey2$1, (Object)new TxnIndexSearchResult((List<AbortedTxn>)abortedTransactions$1.toList(), true));
            }
        } else {
            throw new MatchError(null);
        }
    }

    public static final /* synthetic */ ByteBuffer $anonfun$sanityCheck$1(ByteBuffer buffer$2) {
        return buffer$2;
    }

    public static final /* synthetic */ void $anonfun$sanityCheck$3(TransactionIndex $this, Tuple2 x$7) {
        if (x$7 != null) {
            AbortedTxn abortedTxn = (AbortedTxn)x$7._1();
            if (abortedTxn.lastOffset() < $this.startOffset()) {
                throw new CorruptIndexException(new java.lang.StringBuilder(72).append("Last offset of aborted transaction ").append(abortedTxn).append(" in index ").append($this.file().getAbsolutePath()).append(" is less than start offset ").append($this.startOffset()).toString());
            }
        } else {
            throw new MatchError(null);
        }
    }

    public TransactionIndex(long startOffset, File _file, boolean fileAlreadyExists) {
        this.startOffset = startOffset;
        this._file = _file;
        this.fileAlreadyExists = fileAlreadyExists;
        Logging.$init$(this);
        this.maybeChannel = None$.MODULE$;
        this.lastOffset = None$.MODULE$;
        if (this._file().exists()) {
            this.openChannel();
        }
    }
}

