/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.availability.ThreadCountersManager;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.NoSuchFileException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import kafka.log.AppendOrigin;
import kafka.log.CompletedTxn;
import kafka.log.CorruptSnapshotException;
import kafka.log.MergedLog$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager$;
import kafka.log.SnapshotFile;
import kafka.log.SnapshotFile$;
import kafka.log.TxnMetadata;
import kafka.server.LogOffsetMetadata;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011Eq!\u00029r\u0011\u00031h!\u0002=r\u0011\u0003I\bbBA\u0001\u0003\u0011\u0005\u00111\u0001\u0005\n\u0003\u000b\t!\u0019!C\u0001\u0003\u000fA\u0001\"a\u0004\u0002A\u0003%\u0011\u0011\u0002\u0005\n\u0003#\t!\u0019!C\u0005\u0003'A\u0001\"a\u0007\u0002A\u0003%\u0011Q\u0003\u0005\n\u0003;\t!\u0019!C\u0005\u0003?A\u0001\"!\r\u0002A\u0003%\u0011\u0011\u0005\u0005\n\u0003g\t!\u0019!C\u0005\u0003?A\u0001\"!\u000e\u0002A\u0003%\u0011\u0011\u0005\u0005\n\u0003o\t!\u0019!C\u0005\u0003?A\u0001\"!\u000f\u0002A\u0003%\u0011\u0011\u0005\u0005\n\u0003w\t!\u0019!C\u0005\u0003?A\u0001\"!\u0010\u0002A\u0003%\u0011\u0011\u0005\u0005\n\u0003\u007f\t!\u0019!C\u0005\u0003?A\u0001\"!\u0011\u0002A\u0003%\u0011\u0011\u0005\u0005\n\u0003\u0007\n!\u0019!C\u0005\u0003?A\u0001\"!\u0012\u0002A\u0003%\u0011\u0011\u0005\u0005\n\u0003\u000f\n!\u0019!C\u0005\u0003?A\u0001\"!\u0013\u0002A\u0003%\u0011\u0011\u0005\u0005\n\u0003\u0017\n!\u0019!C\u0005\u0003?A\u0001\"!\u0014\u0002A\u0003%\u0011\u0011\u0005\u0005\n\u0003\u001f\n!\u0019!C\u0005\u0003?A\u0001\"!\u0015\u0002A\u0003%\u0011\u0011\u0005\u0005\n\u0003'\n!\u0019!C\u0005\u0003?A\u0001\"!\u0016\u0002A\u0003%\u0011\u0011\u0005\u0005\n\u0003/\n!\u0019!C\u0005\u0003?A\u0001\"!\u0017\u0002A\u0003%\u0011\u0011\u0005\u0005\n\u00037\n!\u0019!C\u0005\u0003\u000fA\u0001\"!\u0018\u0002A\u0003%\u0011\u0011\u0002\u0005\n\u0003?\n!\u0019!C\u0005\u0003\u000fA\u0001\"!\u0019\u0002A\u0003%\u0011\u0011\u0002\u0005\n\u0003G\n!\u0019!C\u0005\u0003\u000fA\u0001\"!\u001a\u0002A\u0003%\u0011\u0011\u0002\u0005\n\u0003O\n!\u0019!C\u0001\u0003SB\u0001\"!#\u0002A\u0003%\u00111\u000e\u0005\n\u0003\u0017\u000b!\u0019!C\u0001\u0003SB\u0001\"!$\u0002A\u0003%\u00111\u000e\u0005\b\u0003\u001f\u000bA\u0011AAI\u0011\u001d\ty)\u0001C\u0001\u0003\u0003Dq!a5\u0002\t\u0013\t)\u000eC\u0004\u0003\u0002\u0005!IAa\u0001\t\u000f\t5\u0011\u0001\"\u0001\u0003\u0010\u0019)\u00010\u001d\u0001\u0003\u001c!Q!\u0011\u0006\u0017\u0003\u0006\u0004%\tAa\u000b\t\u0015\tUBF!A!\u0002\u0013\u0011i\u0003\u0003\u0006\u000381\u0012\t\u0019!C\u0001\u0005sA!Ba\u000f-\u0005\u0003\u0007I\u0011\u0001B\u001f\u0011)\u0011\u0019\u0005\fB\u0001B\u0003&\u0011Q\u0017\u0005\u000b\u0005\u001bb#Q1A\u0005\u0002\u0005\u001d\u0001B\u0003B(Y\t\u0005\t\u0015!\u0003\u0002\n!Q!\u0011\u000b\u0017\u0003\u0006\u0004%\t!a\u0002\t\u0015\tMCF!A!\u0002\u0013\tI\u0001\u0003\u0006\u0003V1\u0012)\u0019!C\u0001\u0005/B!Ba\u0019-\u0005\u0003\u0005\u000b\u0011\u0002B-\u0011\u001d\t\t\u0001\fC\u0001\u0005KB\u0011Ba\u001d-\u0001\u0004%IA!\u001e\t\u0013\t-E\u00061A\u0005\n\t5\u0005\u0002\u0003BIY\u0001\u0006KAa\u001e\t\u0013\tMEF1A\u0005\n\tU\u0005\u0002\u0003BLY\u0001\u0006I!a;\t\u0013\teE\u00061A\u0005\n\tm\u0005\"\u0003BOY\u0001\u0007I\u0011\u0002BP\u0011!\u0011\u0019\u000b\fQ!\n\u0005m\b\"\u0003BSY\u0001\u0007I\u0011\u0002BN\u0011%\u00119\u000b\fa\u0001\n\u0013\u0011I\u000b\u0003\u0005\u0003.2\u0002\u000b\u0015BA~\u0011%\u0011y\u000b\fa\u0001\n\u0013\u0011Y\nC\u0005\u000322\u0002\r\u0011\"\u0003\u00034\"A!q\u0017\u0017!B\u0013\tY\u0010C\u0005\u0003<2\u0012\r\u0011\"\u0003\u0003>\"A!Q\u001a\u0017!\u0002\u0013\u0011y\fC\u0005\u0003P2\u0012\r\u0011\"\u0003\u0003>\"A!\u0011\u001b\u0017!\u0002\u0013\u0011y\fC\u0004\u0003T2\"\tA!6\t\u000f\t\rH\u0006\"\u0003\u0003f\"A!q\u001d\u0017\u0005\u0002E\u0014I\u000fC\u0004\u0003r2\"\tAa=\t\u000f\tEH\u0006\"\u0001\u0003~\"91\u0011\u0001\u0017\u0005\u0002\r\r\u0001bBB\fY\u0011\u00051\u0011\u0004\u0005\t\u0007?aC\u0011A9\u0004\"!91Q\u0005\u0017\u0005\u0002\tm\u0005bBB\u0014Y\u0011\u00051\u0011\u0006\u0005\b\u0007kaC\u0011AB\u001c\u0011\u001d\u0019I\u0004\fC\u0005\u0007wA\u0001ba\u0011-\t\u0003\t8Q\t\u0005\b\u0007\u001fbC\u0011BB)\u0011\u001d\u0019I\u0006\fC\u0001\u00077Bqaa\u0018-\t\u0003\u0019\t\u0007C\u0004\u0004l1\"\ta!\u001c\t\u000f\rmD\u0006\"\u0001\u0004~!91Q\u0013\u0017\u0005\u0002\r]\u0005bBBOY\u0011%1q\u0014\u0005\b\u0007CcC\u0011ABR\u0011\u001d\u0019I\u000b\fC\u0001\u0007WCqa!--\t\u0003\u0019y\nC\u0004\u000442\"\ta!.\t\u000f\rmF\u0006\"\u0001\u0004\"!91Q\u0018\u0017\u0005\u0002\r\u0005\u0002bBB`Y\u0011\u00051\u0011\u0019\u0005\b\u0007\u000bdC\u0011BBd\u0011\u001d\u0019i\r\fC\u0001\u0007\u001fDqaa5-\t\u0003\u0019)\u000eC\u0004\u0004b2\"\taa9\t\u000f\r\u001dH\u0006\"\u0001\u0004j\"91q\u001e\u0017\u0005\n\rE\bbBB{Y\u0011%1\u0011\u001f\u0005\b\u0007odC\u0011AB}\u0011\u001d\u0019i\u0010\fC\u0005\u0007\u007fD\u0001\u0002b\u0001-\t\u0003\tHQA\u0001\u0015!J|G-^2feN#\u0018\r^3NC:\fw-\u001a:\u000b\u0005I\u001c\u0018a\u00017pO*\tA/A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005]\fQ\"A9\u0003)A\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s'\t\t!\u0010\u0005\u0002|}6\tAPC\u0001~\u0003\u0015\u00198-\u00197b\u0013\tyHP\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\fq\u0003T1uKR\u0013\u0018M\\:bGRLwN\u001c\"vM\u001a,'/T:\u0016\u0005\u0005%\u0001cA>\u0002\f%\u0019\u0011Q\u0002?\u0003\u0007%sG/\u0001\rMCR,GK]1og\u0006\u001cG/[8o\u0005V4g-\u001a:Ng\u0002\nq\u0003\u0015:pIV\u001cWM]*oCB\u001c\bn\u001c;WKJ\u001c\u0018n\u001c8\u0016\u0005\u0005U\u0001cA>\u0002\u0018%\u0019\u0011\u0011\u0004?\u0003\u000bMCwN\u001d;\u00021A\u0013x\u000eZ;dKJ\u001cf.\u00199tQ>$h+\u001a:tS>t\u0007%\u0001\u0007WKJ\u001c\u0018n\u001c8GS\u0016dG-\u0006\u0002\u0002\"A!\u00111EA\u0017\u001b\t\t)C\u0003\u0003\u0002(\u0005%\u0012\u0001\u00027b]\u001eT!!a\u000b\u0002\t)\fg/Y\u0005\u0005\u0003_\t)C\u0001\u0004TiJLgnZ\u0001\u000e-\u0016\u00148/[8o\r&,G\u000e\u001a\u0011\u0002\u0011\r\u00138MR5fY\u0012\f\u0011b\u0011:d\r&,G\u000e\u001a\u0011\u0002\u001fA\u0013x\u000eZ;dKJLEMR5fY\u0012\f\u0001\u0003\u0015:pIV\u001cWM]%e\r&,G\u000e\u001a\u0011\u0002#1\u000b7\u000f^*fcV,gnY3GS\u0016dG-\u0001\nMCN$8+Z9vK:\u001cWMR5fY\u0012\u0004\u0013A\u0005)s_\u0012,8-\u001a:Fa>\u001c\u0007NR5fY\u0012\f1\u0003\u0015:pIV\u001cWM]#q_\u000eDg)[3mI\u0002\nq\u0002T1ti>3gm]3u\r&,G\u000eZ\u0001\u0011\u0019\u0006\u001cHo\u00144gg\u0016$h)[3mI\u0002\n\u0001c\u00144gg\u0016$H)\u001a7uC\u001aKW\r\u001c3\u0002#=3gm]3u\t\u0016dG/\u0019$jK2$\u0007%\u0001\bUS6,7\u000f^1na\u001aKW\r\u001c3\u0002\u001fQKW.Z:uC6\u0004h)[3mI\u0002\nA\u0003\u0015:pIV\u001cWM]#oiJLWm\u001d$jK2$\u0017!\u0006)s_\u0012,8-\u001a:F]R\u0014\u0018.Z:GS\u0016dG\rI\u0001\u0016\u0007>|'\u000fZ5oCR|'/\u00129pG\"4\u0015.\u001a7e\u0003Y\u0019un\u001c:eS:\fGo\u001c:Fa>\u001c\u0007NR5fY\u0012\u0004\u0013AG\"veJ,g\u000e\u001e+y]\u001aK'o\u001d;PM\u001a\u001cX\r\u001e$jK2$\u0017aG\"veJ,g\u000e\u001e+y]\u001aK'o\u001d;PM\u001a\u001cX\r\u001e$jK2$\u0007%A\u0007WKJ\u001c\u0018n\u001c8PM\u001a\u001cX\r^\u0001\u000f-\u0016\u00148/[8o\u001f\u001a47/\u001a;!\u0003%\u0019%oY(gMN,G/\u0001\u0006De\u000e|eMZ:fi\u0002\nQ\u0003\u0015:pIV\u001cWM]#oiJLWm](gMN,G/\u0001\fQe>$WoY3s\u000b:$(/[3t\u001f\u001a47/\u001a;!\u0003m\u0001&o\u001c3vG\u0016\u00148K\\1qg\"|G/\u00128uef\u001c6\r[3nCV\u0011\u00111\u000e\t\u0005\u0003[\n))\u0004\u0002\u0002p)!\u0011\u0011OA:\u0003\u0015!\u0018\u0010]3t\u0015\u0011\t)(a\u001e\u0002\u0011A\u0014x\u000e^8d_2TA!!\u001f\u0002|\u000511m\\7n_:T1\u0001^A?\u0015\u0011\ty(!!\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t\u0019)A\u0002pe\u001eLA!a\"\u0002p\t11k\u00195f[\u0006\fA\u0004\u0015:pIV\u001cWM]*oCB\u001c\bn\u001c;F]R\u0014\u0018pU2iK6\f\u0007%\u0001\u000bQS\u0012\u001cf.\u00199tQ>$X*\u00199TG\",W.Y\u0001\u0016!&$7K\\1qg\"|G/T1q'\u000eDW-\\1!\u00031\u0011X-\u00193T]\u0006\u00048\u000f[8u)\u0011\t\u0019*!-\u0011\r\u0005U\u0015QUAV\u001d\u0011\t9*!)\u000f\t\u0005e\u0015qT\u0007\u0003\u00037S1!!(v\u0003\u0019a$o\\8u}%\tQ0C\u0002\u0002$r\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002(\u0006%&\u0001C%uKJ\f'\r\\3\u000b\u0007\u0005\rF\u0010E\u0002x\u0003[K1!a,r\u0005I\u0001&o\u001c3vG\u0016\u00148\u000b^1uK\u0016sGO]=\t\u000f\u0005Mv\u00051\u0001\u00026\u0006!a-\u001b7f!\u0011\t9,!0\u000e\u0005\u0005e&\u0002BA^\u0003S\t!![8\n\t\u0005}\u0016\u0011\u0018\u0002\u0005\r&dW\r\u0006\u0003\u0002\u0014\u0006\r\u0007bBAcQ\u0001\u0007\u0011qY\u0001\u0007EV4g-\u001a:\u0011\t\u0005%\u0017qZ\u0007\u0003\u0003\u0017TA!!4\u0002*\u0005\u0019a.[8\n\t\u0005E\u00171\u001a\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\u0018!D<sSR,7K\\1qg\"|G\u000f\u0006\u0004\u0002X\u0006u\u0017q\u001d\t\u0004w\u0006e\u0017bAAny\n!QK\\5u\u0011\u001d\ty.\u000ba\u0001\u0003C\fAb\u001d8baNDw\u000e\u001e$jY\u0016\u00042a^Ar\u0013\r\t)/\u001d\u0002\r':\f\u0007o\u001d5pi\u001aKG.\u001a\u0005\b\u0003SL\u0003\u0019AAv\u0003\u001d)g\u000e\u001e:jKN\u0004\u0002\"!<\u0002x\u0006m\u00181V\u0007\u0003\u0003_TA!!=\u0002t\u00069Q.\u001e;bE2,'bAA{y\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005e\u0018q\u001e\u0002\u0004\u001b\u0006\u0004\bcA>\u0002~&\u0019\u0011q ?\u0003\t1{gnZ\u0001\u000fSN\u001cf.\u00199tQ>$h)\u001b7f)\u0011\u0011)Aa\u0003\u0011\u0007m\u00149!C\u0002\u0003\nq\u0014qAQ8pY\u0016\fg\u000eC\u0004\u00024*\u0002\r!!.\u0002#1L7\u000f^*oCB\u001c\bn\u001c;GS2,7\u000f\u0006\u0003\u0003\u0012\t]\u0001CBAK\u0005'\t\t/\u0003\u0003\u0003\u0016\u0005%&aA*fc\"9!\u0011D\u0016A\u0002\u0005U\u0016a\u00013jeN!AF\u001fB\u000f!\u0011\u0011yB!\n\u000e\u0005\t\u0005\"b\u0001B\u0012g\u0006)Q\u000f^5mg&!!q\u0005B\u0011\u0005\u001daunZ4j]\u001e\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0006\u0002\u0003.A!!q\u0006B\u0019\u001b\t\t9(\u0003\u0003\u00034\u0005]$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA\u00059q\f\\8h\t&\u0014XCAA[\u0003-yFn\\4ESJ|F%Z9\u0015\t\u0005]'q\b\u0005\n\u0005\u0003\u0002\u0014\u0011!a\u0001\u0003k\u000b1\u0001\u001f\u00132\u0003!yFn\\4ESJ\u0004\u0003fA\u0019\u0003HA\u00191P!\u0013\n\u0007\t-CP\u0001\u0005w_2\fG/\u001b7f\u0003]i\u0017\r\u001f+sC:\u001c\u0018m\u0019;j_:$\u0016.\\3pkRl5/\u0001\rnCb$&/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;Ng\u0002\n\u0011$\\1y!J|G-^2fe&#W\t\u001f9je\u0006$\u0018n\u001c8Ng\u0006QR.\u0019=Qe>$WoY3s\u0013\u0012,\u0005\u0010]5sCRLwN\\'tA\u0005!A/[7f+\t\u0011I\u0006\u0005\u0003\u0003\\\t}SB\u0001B/\u0015\u0011\u0011\u0019#a\u001e\n\t\t\u0005$Q\f\u0002\u0005)&lW-A\u0003uS6,\u0007\u0005\u0006\u0007\u0003h\t%$1\u000eB7\u0005_\u0012\t\b\u0005\u0002xY!9!\u0011\u0006\u001dA\u0002\t5\u0002b\u0002B\u001cq\u0001\u0007\u0011Q\u0017\u0005\b\u0005\u001bB\u0004\u0019AA\u0005\u0011\u001d\u0011\t\u0006\u000fa\u0001\u0003\u0013AqA!\u00169\u0001\u0004\u0011I&A\u0005t]\u0006\u00048\u000f[8ugV\u0011!q\u000f\t\t\u0005s\u0012\u0019Ia\"\u0002b6\u0011!1\u0010\u0006\u0005\u0005{\u0012y(\u0001\u0006d_:\u001cWO\u001d:f]RTAA!!\u0002*\u0005!Q\u000f^5m\u0013\u0011\u0011)Ia\u001f\u0003+\r{gnY;se\u0016tGoU6ja2K7\u000f^'baB!\u00111\u0005BE\u0013\u0011\ty0!\n\u0002\u001bMt\u0017\r]:i_R\u001cx\fJ3r)\u0011\t9Na$\t\u0013\t\u0005#(!AA\u0002\t]\u0014AC:oCB\u001c\bn\u001c;tA\u0005I\u0001O]8ek\u000e,'o]\u000b\u0003\u0003W\f!\u0002\u001d:pIV\u001cWM]:!\u00035a\u0017m\u001d;NCB|eMZ:fiV\u0011\u00111`\u0001\u0012Y\u0006\u001cH/T1q\u001f\u001a47/\u001a;`I\u0015\fH\u0003BAl\u0005CC\u0011B!\u0011@\u0003\u0003\u0005\r!a?\u0002\u001d1\f7\u000f^'ba>3gm]3uA\u0005qA.Y:u':\f\u0007o\u00144gg\u0016$\u0018A\u00057bgR\u001cf.\u00199PM\u001a\u001cX\r^0%KF$B!a6\u0003,\"I!\u0011\t\"\u0002\u0002\u0003\u0007\u00111`\u0001\u0010Y\u0006\u001cHo\u00158ba>3gm]3uA\u00059r\u000e\u001c3fgR$\u0006P\\*uCJ$H+[7fgR\fW\u000e]\u0001\u001c_2$Wm\u001d;Uq:\u001cF/\u0019:u)&lWm\u001d;b[B|F%Z9\u0015\t\u0005]'Q\u0017\u0005\n\u0005\u0003*\u0015\u0011!a\u0001\u0003w\f\u0001d\u001c7eKN$H\u000b\u001f8Ti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9!Q\r1%qI\u0001\f_:<w.\u001b8h)bt7/\u0006\u0002\u0003@BA!\u0011\u0019Bb\u0003w\u00149-\u0004\u0002\u0003\u0000%!!Q\u0019B@\u0005\u001d!&/Z3NCB\u00042a\u001eBe\u0013\r\u0011Y-\u001d\u0002\f)btW*\u001a;bI\u0006$\u0018-\u0001\u0007p]\u001e|\u0017N\\4Uq:\u001c\b%\u0001\tv]J,\u0007\u000f\\5dCR,G\r\u0016=og\u0006\tRO\u001c:fa2L7-\u0019;fIRChn\u001d\u0011\u0002%!\f7\u000fT1uKR\u0013\u0018M\\:bGRLwN\u001c\u000b\u0005\u0005\u000b\u00119\u000eC\u0004\u0003Z.\u0003\r!a?\u0002\u001b\r,(O]3oiRKW.Z'tQ\rY%Q\u001c\t\u0005\u0005?\u0011y.\u0003\u0003\u0003b\n\u0005\"A\u0003;ie\u0016\fGm]1gK\u0006iAn\\1e':\f\u0007o\u001d5piN$\"Aa\u001e\u0002)I,Wn\u001c<f'R\u0014\u0018-_*oCB\u001c\bn\u001c;t)\u0011\t9Na;\t\u000f\t5X\n1\u0001\u0003p\u0006\u00112/Z4nK:$()Y:f\u001f\u001a47/\u001a;t!\u0019\t)Ja\u0005\u0002|\u0006qa\r\\;tQNs\u0017\r]:i_R\u001cHCBAl\u0005k\u0014I\u0010C\u0004\u0003x:\u0003\r!a?\u0002\u0015\u0019\u0014x.\\(gMN,G\u000fC\u0004\u0003|:\u0003\r!a?\u0002\u0011Q|wJ\u001a4tKR$B!a6\u0003\u0000\"9!q_(A\u0002\u0005m\u0018a\u00054jeN$XK\\:uC\ndWm\u00144gg\u0016$XCAB\u0003!\u0015Y8qAB\u0006\u0013\r\u0019I\u0001 \u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\r511C\u0007\u0003\u0007\u001fQ1a!\u0005t\u0003\u0019\u0019XM\u001d<fe&!1QCB\b\u0005EaunZ(gMN,G/T3uC\u0012\fG/Y\u0001\u0017_:D\u0015n\u001a5XCR,'/\\1sWV\u0003H-\u0019;fIR!\u0011q[B\u000e\u0011\u001d\u0019i\"\u0015a\u0001\u0003w\fQ\u0002[5hQ^\u000bG/\u001a:nCJ\\\u0017\u0001\u00064jeN$XK\u001c3fG&$W\rZ(gMN,G/\u0006\u0002\u0004$A)1pa\u0002\u0002|\u0006aQ.\u00199F]\u0012|eMZ:fi\u0006y\u0011m\u0019;jm\u0016\u0004&o\u001c3vG\u0016\u00148/\u0006\u0002\u0004,AA1QFB\u001a\u0003w\fY+\u0004\u0002\u00040)!1\u0011GAz\u0003%IW.\\;uC\ndW-\u0003\u0003\u0002z\u000e=\u0012aB5t\u000b6\u0004H/_\u000b\u0003\u0005\u000b\t\u0001\u0003\\8bI\u001a\u0013x.\\*oCB\u001c\bn\u001c;\u0015\r\u0005]7QHB!\u0011\u001d\u0019yD\u0016a\u0001\u0003w\fa\u0002\\8h'R\f'\u000f^(gMN,G\u000fC\u0004\u0003ZZ\u0003\r!a?\u0002#1|\u0017\r\u001a)s_\u0012,8-\u001a:F]R\u0014\u0018\u0010\u0006\u0004\u0002X\u000e\u001d31\n\u0005\b\u0007\u0013:\u0006\u0019AAV\u0003\u0015)g\u000e\u001e:z\u0011\u001d\u0019ie\u0016a\u0001\u0003w\f!\u0002\\8bIRKW.Z't\u0003EI7\u000f\u0015:pIV\u001cWM]#ya&\u0014X\r\u001a\u000b\u0007\u0005\u000b\u0019\u0019f!\u0016\t\u000f\te\u0007\f1\u0001\u0002|\"91q\u000b-A\u0002\u0005-\u0016!\u00049s_\u0012,8-\u001a:Ti\u0006$X-\u0001\fsK6|g/Z#ya&\u0014X\r\u001a)s_\u0012,8-\u001a:t)\u0011\t9n!\u0018\t\u000f\te\u0017\f1\u0001\u0002|\u0006\tBO];oG\u0006$X-\u00118e%\u0016dw.\u00193\u0015\u0011\u0005]71MB3\u0007SBqaa\u0010[\u0001\u0004\tY\u0010C\u0004\u0004hi\u0003\r!a?\u0002\u00191|w-\u00128e\u001f\u001a47/\u001a;\t\u000f\r5#\f1\u0001\u0002|\u0006A\"/\u001a7pC\u00124%o\\7US\u0016\u0014X\rZ*oCB\u001c\bn\u001c;\u0015\u0015\u0005]7qNB9\u0007g\u001a9\bC\u0004\u0004@m\u0003\r!a?\t\u000f\te7\f1\u0001\u0002|\"91QO.A\u0002\u0005\u001d\u0017AD:oCB\u001c\bn\u001c;Ck\u001a4WM\u001d\u0005\b\u0007sZ\u0006\u0019AA~\u00039\u0019h.\u00199tQ>$xJ\u001a4tKR\fQ\u0002\u001d:fa\u0006\u0014X-\u00169eCR,G\u0003CB@\u0007\u000b\u001bIia%\u0011\u0007]\u001c\t)C\u0002\u0004\u0004F\u0014!\u0003\u0015:pIV\u001cWM]!qa\u0016tG-\u00138g_\"91q\u0011/A\u0002\u0005m\u0018A\u00039s_\u0012,8-\u001a:JI\"911\u0012/A\u0002\r5\u0015AB8sS\u001eLg\u000eE\u0002x\u0007\u001fK1a!%r\u00051\t\u0005\u000f]3oI>\u0013\u0018nZ5o\u0011\u001d\u0011I\u000e\u0018a\u0001\u0003w\fa!\u001e9eCR,G\u0003BAl\u00073Cqaa'^\u0001\u0004\u0019y(\u0001\u0006baB,g\u000eZ%oM>\f\u0001$\u001e9eCR,w\n\u001c3fgR$\u0006P\u001c+j[\u0016\u001cH/Y7q)\t\t9.\u0001\nva\u0012\fG/Z'ba\u0016sGm\u00144gg\u0016$H\u0003BAl\u0007KCqaa*`\u0001\u0004\tY0\u0001\u0006mCN$xJ\u001a4tKR\f\u0011\u0002\\1ti\u0016sGO]=\u0015\t\r56q\u0016\t\u0006w\u000e\u001d\u00111\u0016\u0005\b\u0007\u000f\u0003\u0007\u0019AA~\u00031!\u0018m[3T]\u0006\u00048\u000f[8u\u0003=)\b\u000fZ1uKB\u000b'/\u001a8u\t&\u0014H\u0003BAl\u0007oCqa!/c\u0001\u0004\t),A\u0005qCJ,g\u000e\u001e#je\u0006!B.\u0019;fgR\u001cf.\u00199tQ>$xJ\u001a4tKR\fAc\u001c7eKN$8K\\1qg\"|Go\u00144gg\u0016$\u0018aG8o\u0019><7\u000b^1si>3gm]3u\u0013:\u001c'/Z7f]R,G\r\u0006\u0003\u0002X\u000e\r\u0007bBB K\u0002\u0007\u00111`\u0001\u001fe\u0016lwN^3V]J,\u0007\u000f\\5dCR,G\r\u0016:b]N\f7\r^5p]N$B!a6\u0004J\"911\u001a4A\u0002\u0005m\u0018AB8gMN,G/A\fueVt7-\u0019;f\rVdG._!oIN#\u0018M\u001d;BiR!\u0011q[Bi\u0011\u001d\u0019Ym\u001aa\u0001\u0003w\f\u0001\u0004\u001d:pa>\u001cX\r\u001a'bgR\u001cF/\u00192mK>3gm]3u)\u0011\tYpa6\t\u000f\re\u0007\u000e1\u0001\u0004\\\u0006a1m\\7qY\u0016$X\r\u001a+y]B\u0019qo!8\n\u0007\r}\u0017O\u0001\u0007D_6\u0004H.\u001a;fIRCh.A\u0006d_6\u0004H.\u001a;f)btG\u0003BAl\u0007KDqa!7j\u0001\u0004\u0019Y.A\u000beK2,G/Z*oCB\u001c\bn\u001c;t\u0005\u00164wN]3\u0015\t\u0005]71\u001e\u0005\b\u0007\u0017T\u0007\u0019AA~Q\rQ'Q\\\u0001\u0013_2$Wm\u001d;T]\u0006\u00048\u000f[8u\r&dW-\u0006\u0002\u0004tB)1pa\u0002\u0002b\u0006\u0011B.\u0019;fgR\u001cf.\u00199tQ>$h)\u001b7f\u0003U\u0019h.\u00199tQ>$h)\u001b7f\r>\u0014xJ\u001a4tKR$Baa=\u0004|\"911Z7A\u0002\u0005m\u0018a\u0006:f[>4X-\u00118e\t\u0016dW\r^3T]\u0006\u00048\u000f[8u)\u0011\t9\u000e\"\u0001\t\u000f\red\u000e1\u0001\u0002|\u0006\u0001#/Z7pm\u0016\fe\u000eZ'be.\u001cf.\u00199tQ>$hi\u001c:EK2,G/[8o)\u0011\u0019\u0019\u0010b\u0002\t\u000f\ret\u000e1\u0001\u0002|\"\u001aA\u0006b\u0003\u0011\t\t}AQB\u0005\u0005\t\u001f\u0011\tCA\u0007o_:$\bN]3bIN\fg-\u001a")
public class ProducerStateManager
implements Logging {
    private final TopicPartition topicPartition;
    private volatile File _logDir;
    private final int maxTransactionTimeoutMs;
    private final int maxProducerIdExpirationMs;
    private final Time time;
    private ConcurrentSkipListMap<Long, SnapshotFile> snapshots;
    private final Map<Object, ProducerStateEntry> producers;
    private long lastMapOffset;
    private long lastSnapOffset;
    private volatile long oldestTxnStartTimestamp;
    private final TreeMap<Object, TxnMetadata> ongoingTxns;
    private final TreeMap<Object, TxnMetadata> unreplicatedTxns;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Seq<SnapshotFile> listSnapshotFiles(File file) {
        return ProducerStateManager$.MODULE$.listSnapshotFiles(file);
    }

    public static Iterable<ProducerStateEntry> readSnapshot(ByteBuffer byteBuffer) {
        return ProducerStateManager$.MODULE$.readSnapshot(byteBuffer);
    }

    public static Iterable<ProducerStateEntry> readSnapshot(File file) {
        return ProducerStateManager$.MODULE$.readSnapshot(file);
    }

    public static Schema PidSnapshotMapSchema() {
        return ProducerStateManager$.MODULE$.PidSnapshotMapSchema();
    }

    public static Schema ProducerSnapshotEntrySchema() {
        return ProducerStateManager$.MODULE$.ProducerSnapshotEntrySchema();
    }

    public static int LateTransactionBufferMs() {
        return ProducerStateManager$.MODULE$.LateTransactionBufferMs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public File _logDir() {
        return this._logDir;
    }

    public void _logDir_$eq(File x$1) {
        this._logDir = x$1;
    }

    public int maxTransactionTimeoutMs() {
        return this.maxTransactionTimeoutMs;
    }

    public int maxProducerIdExpirationMs() {
        return this.maxProducerIdExpirationMs;
    }

    public Time time() {
        return this.time;
    }

    private ConcurrentSkipListMap<Long, SnapshotFile> snapshots() {
        return this.snapshots;
    }

    private void snapshots_$eq(ConcurrentSkipListMap<Long, SnapshotFile> x$1) {
        this.snapshots = x$1;
    }

    private Map<Object, ProducerStateEntry> producers() {
        return this.producers;
    }

    private long lastMapOffset() {
        return this.lastMapOffset;
    }

    private void lastMapOffset_$eq(long x$1) {
        this.lastMapOffset = x$1;
    }

    private long lastSnapOffset() {
        return this.lastSnapOffset;
    }

    private void lastSnapOffset_$eq(long x$1) {
        this.lastSnapOffset = x$1;
    }

    private long oldestTxnStartTimestamp() {
        return this.oldestTxnStartTimestamp;
    }

    private void oldestTxnStartTimestamp_$eq(long x$1) {
        this.oldestTxnStartTimestamp = x$1;
    }

    private TreeMap<Object, TxnMetadata> ongoingTxns() {
        return this.ongoingTxns;
    }

    private TreeMap<Object, TxnMetadata> unreplicatedTxns() {
        return this.unreplicatedTxns;
    }

    public boolean hasLateTransaction(long currentTimeMs) {
        long lastTimestamp = this.oldestTxnStartTimestamp();
        return lastTimestamp > 0L && currentTimeMs - lastTimestamp > (long)(this.maxTransactionTimeoutMs() + ProducerStateManager$.MODULE$.LateTransactionBufferMs());
    }

    /*
     * WARNING - void declaration
     */
    private ConcurrentSkipListMap<Long, SnapshotFile> loadSnapshots() {
        void var1_1;
        ConcurrentSkipListMap tm = new ConcurrentSkipListMap();
        ((IterableLike)ThreadCountersManager.wrapIO(() -> ProducerStateManager$.MODULE$.listSnapshotFiles(this._logDir()))).foreach((Function1 & Serializable & scala.Serializable)f -> tm.put(Predef$.MODULE$.long2Long(f.offset()), f));
        return var1_1;
    }

    public void removeStraySnapshots(Seq<Object> segmentBaseOffsets) {
        None$ maxSegmentBaseOffset = segmentBaseOffsets.isEmpty() ? None$.MODULE$ : new Some(segmentBaseOffsets.max((Ordering)Ordering.Long$.MODULE$));
        Set baseOffsets = segmentBaseOffsets.toSet();
        ObjectRef latestStraySnapshot = ObjectRef.create((Object)None$.MODULE$);
        ConcurrentSkipListMap<Long, SnapshotFile> ss = this.loadSnapshots();
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(ss.values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)snapshot -> {
            ProducerStateManager.$anonfun$removeStraySnapshots$1(latestStraySnapshot, baseOffsets, ss, snapshot);
            return BoxedUnit.UNIT;
        });
        ((Option)latestStraySnapshot.elem).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.offset())).foreach((Function1)((JFunction1.mcVJ.sp & Serializable & scala.Serializable)arg_0 -> ProducerStateManager.$anonfun$removeStraySnapshots$3((Option)maxSegmentBaseOffset, ss, arg_0)));
        this.snapshots_$eq(ss);
    }

    public void flushSnapshots(long fromOffset, long toOffset) {
        if (toOffset < fromOffset) {
            throw new IllegalArgumentException(new StringBuilder(105).append("Invalid producer snapshot range: requested snapshots in ").append(this.topicPartition()).append(" ").append("from offset ").append(fromOffset).append(" which is greater than limit offset ").append(toOffset).toString());
        }
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.snapshots().subMap((Object)Predef$.MODULE$.long2Long(fromOffset), true, (Object)Predef$.MODULE$.long2Long(toOffset), true).values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)snapshotFile -> {
            ProducerStateManager.$anonfun$flushSnapshots$1(snapshotFile);
            return BoxedUnit.UNIT;
        });
    }

    public void flushSnapshots(long fromOffset) {
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.snapshots().tailMap((Object)Predef$.MODULE$.long2Long(fromOffset)).values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)snapshotFile -> {
            ProducerStateManager.$anonfun$flushSnapshots$2(snapshotFile);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public Option<LogOffsetMetadata> firstUnstableOffset() {
        void var1_1;
        Option unreplicatedFirstOffset = Option$.MODULE$.apply(this.unreplicatedTxns().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$4 -> ((TxnMetadata)x$4.getValue()).firstOffset());
        Option undecidedFirstOffset = Option$.MODULE$.apply(this.ongoingTxns().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$5 -> ((TxnMetadata)x$5.getValue()).firstOffset());
        if (unreplicatedFirstOffset.isEmpty()) {
            return undecidedFirstOffset;
        }
        if (undecidedFirstOffset.isEmpty()) {
            return unreplicatedFirstOffset;
        }
        if (((LogOffsetMetadata)undecidedFirstOffset.get()).messageOffset() < ((LogOffsetMetadata)unreplicatedFirstOffset.get()).messageOffset()) {
            return undecidedFirstOffset;
        }
        return var1_1;
    }

    public void onHighWatermarkUpdated(long highWatermark) {
        this.removeUnreplicatedTransactions(highWatermark);
    }

    public Option<Object> firstUndecidedOffset() {
        return Option$.MODULE$.apply(this.ongoingTxns().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)ProducerStateManager.$anonfun$firstUndecidedOffset$1(x$6)));
    }

    public long mapEndOffset() {
        return this.lastMapOffset();
    }

    public scala.collection.immutable.Map<Object, ProducerStateEntry> activeProducers() {
        return this.producers().toMap(Predef$.MODULE$.$conforms());
    }

    public boolean isEmpty() {
        return this.producers().isEmpty() && this.unreplicatedTxns().isEmpty();
    }

    private void loadFromSnapshot(long logStartOffset, long currentTimeMs) {
        Option<SnapshotFile> option;
        while ((option = this.latestSnapshotFile()) instanceof Some) {
            SnapshotFile snapshot = (SnapshotFile)((Some)option).value();
            try {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Loading producer state from snapshot file '").append(snapshot).append("'").toString());
                ((Iterable)ProducerStateManager$.MODULE$.readSnapshot(snapshot.file()).filter((Function1 & Serializable & scala.Serializable)producerEntry -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$loadFromSnapshot$2(this, currentTimeMs, producerEntry)))).foreach((Function1 & Serializable & scala.Serializable)producer -> {
                    this.loadProducerEntry(producer, currentTimeMs);
                    return BoxedUnit.UNIT;
                });
                this.lastSnapOffset_$eq(snapshot.offset());
                this.lastMapOffset_$eq(this.lastSnapOffset());
                this.updateOldestTxnTimestamp();
                return;
            }
            catch (CorruptSnapshotException e) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Failed to load producer snapshot from '").append(snapshot.file()).append("': ").append(e.getMessage()).toString());
                this.removeAndDeleteSnapshot(snapshot.offset());
            }
        }
        if (None$.MODULE$.equals(option)) {
            this.lastSnapOffset_$eq(logStartOffset);
            this.lastMapOffset_$eq(logStartOffset);
            return;
        }
        throw new MatchError(option);
    }

    public void loadProducerEntry(ProducerStateEntry entry, long loadTimeMs) {
        long producerId = entry.producerId();
        this.producers().put((Object)BoxesRunTime.boxToLong((long)producerId), (Object)entry);
        entry.currentTxnFirstOffset().foreach((Function1 & Serializable & scala.Serializable)offset -> ProducerStateManager.$anonfun$loadProducerEntry$1(this, producerId, loadTimeMs, BoxesRunTime.unboxToLong((Object)offset)));
    }

    private boolean isProducerExpired(long currentTimeMs, ProducerStateEntry producerState) {
        return producerState.currentTxnFirstOffset().isEmpty() && currentTimeMs - producerState.lastTimestamp() >= (long)this.maxProducerIdExpirationMs();
    }

    public void removeExpiredProducers(long currentTimeMs) {
        this.producers().$minus$minus$eq((TraversableOnce)((MapLike)this.producers().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$removeExpiredProducers$1(this, currentTimeMs, x0$1)))).keySet());
    }

    public void truncateAndReload(long logStartOffset, long logEndOffset, long loadTimeMs) {
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.snapshots().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)snapshot -> {
            ProducerStateManager.$anonfun$truncateAndReload$1(this, logEndOffset, logStartOffset, snapshot);
            return BoxedUnit.UNIT;
        });
        if (logEndOffset != this.mapEndOffset()) {
            this.producers().clear();
            this.ongoingTxns().clear();
            this.updateOldestTxnTimestamp();
            this.unreplicatedTxns().clear();
            this.loadFromSnapshot(logStartOffset, loadTimeMs);
            return;
        }
        this.onLogStartOffsetIncremented(logStartOffset);
    }

    public void reloadFromTieredSnapshot(long logStartOffset, long currentTimeMs, ByteBuffer snapshotBuffer, long snapshotOffset) {
        if (this.activeProducers().nonEmpty()) {
            throw new IllegalStateException("expected producer state to be fully truncated before reloading tiered snapshot");
        }
        try {
            Iterable loadedProducers = (Iterable)ProducerStateManager$.MODULE$.readSnapshot(snapshotBuffer).filter((Function1 & Serializable & scala.Serializable)producerEntry -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$reloadFromTieredSnapshot$1(this, currentTimeMs, producerEntry)));
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("restored state for ").append(loadedProducers.size()).append(" producers from tiered storage").toString());
            loadedProducers.foreach((Function1 & Serializable & scala.Serializable)producer -> {
                this.loadProducerEntry(producer, currentTimeMs);
                return BoxedUnit.UNIT;
            });
            this.lastMapOffset_$eq(snapshotOffset);
            return;
        }
        catch (CorruptSnapshotException e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Failed to load producer snapshot from buffer: ").append(e.getMessage()).toString());
            throw e;
        }
    }

    public ProducerAppendInfo prepareUpdate(long producerId, AppendOrigin origin, long currentTimeMs) {
        ProducerStateEntry currentEntry = (ProducerStateEntry)this.lastEntry(producerId).getOrElse((Function0 & Serializable & scala.Serializable)() -> ProducerStateEntry$.MODULE$.empty(producerId));
        return new ProducerAppendInfo(this.topicPartition(), producerId, currentEntry, origin, currentTimeMs);
    }

    public void update(ProducerAppendInfo appendInfo) {
        if (appendInfo.producerId() == -1L) {
            throw new IllegalArgumentException(new StringBuilder(52).append("Invalid producer id ").append(appendInfo.producerId()).append(" passed to update ").append("for partition ").append(this.topicPartition()).toString());
        }
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Updated producer ").append(appendInfo.producerId()).append(" state to ").append(appendInfo).toString());
        ProducerStateEntry updatedEntry = appendInfo.toEntry();
        Option option = this.producers().get((Object)BoxesRunTime.boxToLong((long)appendInfo.producerId()));
        if (option instanceof Some) {
            ((ProducerStateEntry)((Some)option).value()).update(updatedEntry);
        } else if (None$.MODULE$.equals(option)) {
            this.producers().put((Object)BoxesRunTime.boxToLong((long)appendInfo.producerId()), (Object)updatedEntry);
        } else {
            throw new MatchError((Object)option);
        }
        appendInfo.startedTransactions().foreach((Function1 & Serializable & scala.Serializable)txn -> this.ongoingTxns().put(BoxesRunTime.boxToLong((long)txn.firstOffset().messageOffset()), (TxnMetadata)txn));
        this.updateOldestTxnTimestamp();
    }

    private void updateOldestTxnTimestamp() {
        Map.Entry<Object, TxnMetadata> firstEntry = this.ongoingTxns().firstEntry();
        if (firstEntry == null) {
            this.oldestTxnStartTimestamp_$eq(-1L);
            return;
        }
        this.oldestTxnStartTimestamp_$eq(firstEntry.getValue().startTimeUpperBoundMs());
    }

    public void updateMapEndOffset(long lastOffset) {
        this.lastMapOffset_$eq(lastOffset);
    }

    public Option<ProducerStateEntry> lastEntry(long producerId) {
        return this.producers().get((Object)BoxesRunTime.boxToLong((long)producerId));
    }

    public void takeSnapshot() {
        if (this.lastMapOffset() > this.lastSnapOffset()) {
            SnapshotFile snapshotFile = (SnapshotFile)ThreadCountersManager.wrapIO(() -> SnapshotFile$.MODULE$.apply(MergedLog$.MODULE$.producerSnapshotFile(this._logDir(), this.lastMapOffset())));
            long start = this.time().hiResClockMs();
            ThreadCountersManager.wrapIO(() -> {
                ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$writeSnapshot(snapshotFile, this.producers());
                return BoxedUnit.UNIT;
            });
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Wrote producer snapshot at offset ").append(this.lastMapOffset()).append(" with ").append(this.producers().size()).append(" producer ids in ").append(this.time().hiResClockMs() - start).append(" ms.").toString());
            this.snapshots().put(Predef$.MODULE$.long2Long(snapshotFile.offset()), snapshotFile);
            this.lastSnapOffset_$eq(this.lastMapOffset());
        }
    }

    public void updateParentDir(File parentDir) {
        this._logDir_$eq(parentDir);
        this.snapshots().forEach((x$7, s) -> s.updateParentDir(parentDir));
    }

    public Option<Object> latestSnapshotOffset() {
        return this.latestSnapshotFile().map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.offset()));
    }

    public Option<Object> oldestSnapshotOffset() {
        return this.oldestSnapshotFile().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.offset()));
    }

    public void onLogStartOffsetIncremented(long logStartOffset) {
        this.removeUnreplicatedTransactions(logStartOffset);
        if (this.lastMapOffset() < logStartOffset) {
            this.lastMapOffset_$eq(logStartOffset);
        }
        this.lastSnapOffset_$eq(BoxesRunTime.unboxToLong((Object)this.latestSnapshotOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> logStartOffset)));
    }

    private void removeUnreplicatedTransactions(long offset) {
        Iterator<Map.Entry<Object, TxnMetadata>> iterator = this.unreplicatedTxns().entrySet().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getValue().lastOffset().exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$10 -> x$10 < offset)) continue;
            iterator.remove();
        }
    }

    public void truncateFullyAndStartAt(long offset) {
        this.producers().clear();
        this.ongoingTxns().clear();
        this.unreplicatedTxns().clear();
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.snapshots().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)snapshot -> {
            this.removeAndDeleteSnapshot(snapshot.offset());
            return BoxedUnit.UNIT;
        });
        this.lastSnapOffset_$eq(0L);
        this.lastMapOffset_$eq(offset);
        this.updateOldestTxnTimestamp();
    }

    public long proposedLastStableOffset(CompletedTxn completedTxn) {
        return BoxesRunTime.unboxToLong((Object)((IterableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(this.ongoingTxns()).asScala()).find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$proposedLastStableOffset$1(completedTxn, x0$1))).map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToLong((long)ProducerStateManager.$anonfun$proposedLastStableOffset$2(x0$2))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> completedTxn.lastOffset() + 1L));
    }

    public void completeTxn(CompletedTxn completedTxn) {
        TxnMetadata txnMetadata = this.ongoingTxns().remove(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()));
        if (txnMetadata == null) {
            throw new IllegalArgumentException(new StringBuilder(70).append("Attempted to complete transaction ").append(completedTxn).append(" on partition ").append(this.topicPartition()).append(" ").append("which was not started").toString());
        }
        txnMetadata.lastOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)completedTxn.lastOffset())));
        this.unreplicatedTxns().put(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()), txnMetadata);
        this.updateOldestTxnTimestamp();
    }

    public void deleteSnapshotsBefore(long offset) {
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.snapshots().subMap((Object)Predef$.MODULE$.long2Long(0L), (Object)Predef$.MODULE$.long2Long(offset)).values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)snapshot -> {
            this.removeAndDeleteSnapshot(snapshot.offset());
            return BoxedUnit.UNIT;
        });
    }

    private Option<SnapshotFile> oldestSnapshotFile() {
        return Option$.MODULE$.apply(this.snapshots().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$11 -> (SnapshotFile)x$11.getValue());
    }

    private Option<SnapshotFile> latestSnapshotFile() {
        return Option$.MODULE$.apply(this.snapshots().lastEntry()).map((Function1 & Serializable & scala.Serializable)x$12 -> (SnapshotFile)x$12.getValue());
    }

    public Option<SnapshotFile> snapshotFileForOffset(long offset) {
        return Option$.MODULE$.apply((Object)this.snapshots().get(BoxesRunTime.boxToLong((long)offset)));
    }

    private void removeAndDeleteSnapshot(long snapshotOffset) {
        Option$.MODULE$.apply((Object)this.snapshots().remove(BoxesRunTime.boxToLong((long)snapshotOffset))).foreach((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.deleteIfExists()));
    }

    public Option<SnapshotFile> removeAndMarkSnapshotForDeletion(long snapshotOffset) {
        return Option$.MODULE$.apply((Object)this.snapshots().remove(BoxesRunTime.boxToLong((long)snapshotOffset))).flatMap((Function1 & Serializable & scala.Serializable)snapshot -> {
            try {
                snapshot.close();
                snapshot.renameTo(MergedLog$.MODULE$.DeletedFileSuffix());
                return new Some(snapshot);
            }
            catch (NoSuchFileException noSuchFileException) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(93).append("Failed to rename producer state snapshot ").append(snapshot.file().getAbsoluteFile()).append(" with deletion suffix because it was already deleted").toString());
                return None$.MODULE$;
            }
        });
    }

    public static final /* synthetic */ void $anonfun$removeStraySnapshots$1(ObjectRef latestStraySnapshot$1, Set baseOffsets$1, ConcurrentSkipListMap ss$1, SnapshotFile snapshot) {
        long key = snapshot.offset();
        Option option = (Option)latestStraySnapshot$1.elem;
        if (option instanceof Some) {
            SnapshotFile prev = (SnapshotFile)((Some)option).value();
            if (!baseOffsets$1.contains((Object)BoxesRunTime.boxToLong((long)key))) {
                prev.deleteIfExists();
                ss$1.remove(BoxesRunTime.boxToLong((long)prev.offset()));
                latestStraySnapshot$1.elem = new Some((Object)snapshot);
                return;
            }
        } else if (None$.MODULE$.equals(option)) {
            if (!baseOffsets$1.contains((Object)BoxesRunTime.boxToLong((long)key))) {
                latestStraySnapshot$1.elem = new Some((Object)snapshot);
                return;
            }
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ void $anonfun$removeStraySnapshots$3(Option maxSegmentBaseOffset$1, ConcurrentSkipListMap ss$1, long strayOffset) {
        maxSegmentBaseOffset$1.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)maxOffset -> {
            if (strayOffset < maxOffset) {
                Option$.MODULE$.apply(ss$1.remove(BoxesRunTime.boxToLong((long)strayOffset))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.deleteIfExists()));
            }
        });
    }

    public static final /* synthetic */ void $anonfun$flushSnapshots$1(SnapshotFile snapshotFile) {
        snapshotFile.flush();
        snapshotFile.close();
    }

    public static final /* synthetic */ void $anonfun$flushSnapshots$2(SnapshotFile snapshotFile) {
        snapshotFile.flush();
        snapshotFile.close();
    }

    public static final /* synthetic */ long $anonfun$firstUndecidedOffset$1(Map.Entry x$6) {
        return ((TxnMetadata)x$6.getValue()).firstOffset().messageOffset();
    }

    public static final /* synthetic */ boolean $anonfun$loadFromSnapshot$2(ProducerStateManager $this, long currentTimeMs$1, ProducerStateEntry producerEntry) {
        return !$this.isProducerExpired(currentTimeMs$1, producerEntry);
    }

    public static final /* synthetic */ TxnMetadata $anonfun$loadProducerEntry$1(ProducerStateManager $this, long producerId$1, long loadTimeMs$1, long offset) {
        return $this.ongoingTxns().put(BoxesRunTime.boxToLong((long)offset), new TxnMetadata(producerId$1, offset, loadTimeMs$1));
    }

    public static final /* synthetic */ boolean $anonfun$removeExpiredProducers$1(ProducerStateManager $this, long currentTimeMs$2, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        ProducerStateEntry lastEntry = (ProducerStateEntry)x0$1._2();
        boolean bl = $this.isProducerExpired(currentTimeMs$2, lastEntry);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$truncateAndReload$1(ProducerStateManager $this, long logEndOffset$1, long logStartOffset$1, SnapshotFile snapshot) {
        if (snapshot.offset() > logEndOffset$1 || snapshot.offset() <= logStartOffset$1) {
            $this.removeAndDeleteSnapshot(snapshot.offset());
        }
    }

    public static final /* synthetic */ boolean $anonfun$reloadFromTieredSnapshot$1(ProducerStateManager $this, long currentTimeMs$3, ProducerStateEntry producerEntry) {
        return !$this.isProducerExpired(currentTimeMs$3, producerEntry);
    }

    public static final /* synthetic */ boolean $anonfun$proposedLastStableOffset$1(CompletedTxn completedTxn$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = x0$1._1$mcJ$sp() != completedTxn$1.firstOffset();
        return bl;
    }

    public static final /* synthetic */ long $anonfun$proposedLastStableOffset$2(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        long l = ((TxnMetadata)x0$2._2()).firstOffset().messageOffset();
        return l;
    }

    public ProducerStateManager(TopicPartition topicPartition, File _logDir, int maxTransactionTimeoutMs, int maxProducerIdExpirationMs, Time time) {
        this.topicPartition = topicPartition;
        this._logDir = _logDir;
        this.maxTransactionTimeoutMs = maxTransactionTimeoutMs;
        this.maxProducerIdExpirationMs = maxProducerIdExpirationMs;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(34).append("[ProducerStateManager partition=").append(topicPartition).append("] ").toString());
        this.snapshots = (ConcurrentSkipListMap)Predef$.MODULE$.locally(this.loadSnapshots());
        this.producers = Map$.MODULE$.empty();
        this.lastMapOffset = 0L;
        this.lastSnapOffset = 0L;
        this.oldestTxnStartTimestamp = -1L;
        this.ongoingTxns = new TreeMap();
        this.unreplicatedTxns = new TreeMap();
    }
}

