/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.nio.ByteBuffer;
import kafka.log.OffsetMap;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00194Aa\u0005\u000b\u00013!AA\u0005\u0001B\u0001B\u0003%\u0001\u0005C\u0003&\u0001\u0011\u0005a\u0005C\u0004*\u0001\t\u0007I\u0011\u0002\u0016\t\r9\u0002\u0001\u0015!\u0003,\u0011\u001dy\u0003\u00011A\u0005\nABq\u0001\u000e\u0001A\u0002\u0013%Q\u0007\u0003\u0004<\u0001\u0001\u0006K!\r\u0005\u0006y\u0001!I!\u0010\u0005\u0006\u0007\u0002!\t\u0005\r\u0005\u0006\t\u0002!\t%\u0012\u0005\u0006\t\u0002!\t%\u0015\u0005\u0006-\u0002!\te\u0016\u0005\u00063\u0002!\tE\u0017\u0005\u00069\u0002!\t%\u0018\u0005\u0006=\u0002!\t\u0005\r\u0005\u0006?\u0002!\t\u0005\u0019\u0005\u0006I\u0002!\tE\u000b\u0005\u0006K\u0002!\t\u0001\r\u0002\u0012\u000bb$XM\u001c3fI>3gm]3u\u001b\u0006\u0004(BA\u000b\u0017\u0003\rawn\u001a\u0006\u0002/\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\u001bAA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t1\u0011I\\=SK\u001a\u0004\"!\t\u0012\u000e\u0003QI!a\t\u000b\u0003\u0013=3gm]3u\u001b\u0006\u0004\u0018!E5oi\u0016\u0014h.\u00197PM\u001a\u001cX\r^'ba\u00061A(\u001b8jiz\"\"a\n\u0015\u0011\u0005\u0005\u0002\u0001\"\u0002\u0013\u0003\u0001\u0004\u0001\u0013!\u0004;p[\n\u001cHo\u001c8f\u001b\u0006\u001c8.F\u0001,!\tYB&\u0003\u0002.9\t!Aj\u001c8h\u00039!x.\u001c2ti>tW-T1tW\u0002\n\u0001\u0003^8nEN$xN\\3F]R\u0014\u0018.Z:\u0016\u0003E\u0002\"a\u0007\u001a\n\u0005Mb\"aA%oi\u0006!Bo\\7cgR|g.Z#oiJLWm]0%KF$\"AN\u001d\u0011\u0005m9\u0014B\u0001\u001d\u001d\u0005\u0011)f.\u001b;\t\u000fi2\u0011\u0011!a\u0001c\u0005\u0019\u0001\u0010J\u0019\u0002#Q|WNY:u_:,WI\u001c;sS\u0016\u001c\b%\u0001\tjgR{WNY:u_:,WI\u001c;ssR\u0011a(\u0011\t\u00037}J!\u0001\u0011\u000f\u0003\u000f\t{w\u000e\\3b]\")!\t\u0003a\u0001W\u00051qN\u001a4tKR\fQa\u001d7piN\f1\u0001];u)\r1d\t\u0015\u0005\u0006\u000f*\u0001\r\u0001S\u0001\u0004W\u0016L\bCA%O\u001b\u0005Q%BA&M\u0003\rq\u0017n\u001c\u0006\u0002\u001b\u0006!!.\u0019<b\u0013\ty%J\u0001\u0006CsR,')\u001e4gKJDQA\u0011\u0006A\u0002-\"BA\u000e*T)\")qi\u0003a\u0001\u0011\")!i\u0003a\u0001W!)Qk\u0003a\u0001}\u0005Y\u0011n\u001d+p[\n\u001cHo\u001c8f\u0003\r9W\r\u001e\u000b\u0003WaCQa\u0012\u0007A\u0002!\u000b!#\u001e9eCR,G*\u0019;fgR|eMZ:fiR\u0011ag\u0017\u0005\u0006\u00056\u0001\raK\u0001\u0006G2,\u0017M\u001d\u000b\u0002m\u0005!1/\u001b>f\u0003-)H/\u001b7ju\u0006$\u0018n\u001c8\u0016\u0003\u0005\u0004\"a\u00072\n\u0005\rd\"A\u0002#pk\ndW-\u0001\u0007mCR,7\u000f^(gMN,G/\u0001\bu_6\u00147\u000f^8oK\u000e{WO\u001c;")
public class ExtendedOffsetMap
implements OffsetMap {
    private final OffsetMap internalOffsetMap;
    private final long tombstoneMask;
    private int tombstoneEntries;

    private long tombstoneMask() {
        return this.tombstoneMask;
    }

    private int tombstoneEntries() {
        return this.tombstoneEntries;
    }

    private void tombstoneEntries_$eq(int x$1) {
        this.tombstoneEntries = x$1;
    }

    private boolean isTombstoneEntry(long offset) {
        return (offset & this.tombstoneMask()) != 0L;
    }

    @Override
    public int slots() {
        return this.internalOffsetMap.slots();
    }

    @Override
    public void put(ByteBuffer key, long offset) {
        this.internalOffsetMap.put(key, offset);
    }

    @Override
    public void put(ByteBuffer key, long offset, boolean isTombstone) {
        long oldOffset = this.internalOffsetMap.get(key);
        if (!isTombstone) {
            this.internalOffsetMap.put(key, offset);
            if (oldOffset != -1L && this.isTombstoneEntry(oldOffset)) {
                this.tombstoneEntries_$eq(this.tombstoneEntries() - 1);
                return;
            }
        } else {
            this.internalOffsetMap.put(key, offset | this.tombstoneMask());
            if (oldOffset == -1L || !this.isTombstoneEntry(oldOffset)) {
                this.tombstoneEntries_$eq(this.tombstoneEntries() + 1);
            }
        }
    }

    @Override
    public long get(ByteBuffer key) {
        long res = this.internalOffsetMap.get(key);
        if (res == -1L) {
            return res;
        }
        return res & (this.tombstoneMask() ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public void updateLatestOffset(long offset) {
        this.internalOffsetMap.updateLatestOffset(offset);
    }

    @Override
    public void clear() {
        this.internalOffsetMap.clear();
        this.tombstoneEntries_$eq(0);
    }

    @Override
    public int size() {
        return this.internalOffsetMap.size();
    }

    @Override
    public double utilization() {
        return this.internalOffsetMap.utilization();
    }

    @Override
    public long latestOffset() {
        return this.internalOffsetMap.latestOffset();
    }

    public int tombstoneCount() {
        return this.tombstoneEntries();
    }

    public ExtendedOffsetMap(OffsetMap internalOffsetMap) {
        this.internalOffsetMap = internalOffsetMap;
        OffsetMap.$init$(this);
        this.tombstoneMask = Long.MIN_VALUE;
        this.tombstoneEntries = 0;
    }
}

