/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.Date;
import kafka.common.LogCleaningAbortedException;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.AbortedTxn;
import kafka.log.AbstractLog;
import kafka.log.CleanParams;
import kafka.log.CleanedTransactionMetadata;
import kafka.log.Cleaner$;
import kafka.log.CleanerStats;
import kafka.log.ExtendedOffsetMap;
import kafka.log.LastRecord;
import kafka.log.LocalLogSegmentReadAdapter;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerMetrics;
import kafka.log.LogSegment;
import kafka.log.LogSegmentReadAdapter;
import kafka.log.MergedLog$;
import kafka.log.OffsetMap;
import kafka.log.TransactionIndex;
import kafka.utils.Logging;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.CloseableIterator;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tmh\u0001\u0002\u0015*\u00019B\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0001\u0010\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005{!A\u0011\t\u0001BC\u0002\u0013\u0005!\t\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003D\u0011!A\u0005A!A!\u0002\u0013i\u0004\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u0011)\u0003!\u0011!Q\u0001\n-C\u0001B\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\t%\u0002\u0011\t\u0011)A\u0005'\"Aq\f\u0001B\u0001B\u0003%\u0001\r\u0003\u0005k\u0001\t\u0005\t\u0015!\u0003l\u0011\u0015q\u0007\u0001\"\u0001p\u0011\u0015Q\b\u0001\"\u0015|\u0011%\tI\u0001\u0001a\u0001\n\u0013\tY\u0001C\u0005\u0002\u001a\u0001\u0001\r\u0011\"\u0003\u0002\u001c!A\u0011\u0011\u0005\u0001!B\u0013\ti\u0001C\u0005\u0002$\u0001\u0001\r\u0011\"\u0003\u0002\f!I\u0011Q\u0005\u0001A\u0002\u0013%\u0011q\u0005\u0005\t\u0003W\u0001\u0001\u0015)\u0003\u0002\u000e!I\u0011Q\u0006\u0001C\u0002\u0013%\u0011q\u0006\u0005\t\u0003o\u0001\u0001\u0015!\u0003\u00022!9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0002\u0002CA-\u0001\u0011\u0005\u0011&a\u0017\t\u0011\u0005\r\u0004\u0001\"\u0001*\u0003KBq!!(\u0001\t\u0003\ty\nC\u0004\u0002n\u0002!I!a<\t\u000f\t%\u0001\u0001\"\u0003\u0003\f!9!\u0011\u0004\u0001\u0005\n\tm\u0001b\u0002B\u001a\u0001\u0011\u0005!Q\u0007\u0005\b\u0005s\u0001A\u0011\u0001B\u001e\u0011!\u0011i\u0004\u0001C\u0001S\t}\u0002b\u0002B4\u0001\u0011%!\u0011\u000e\u0005\b\u0005g\u0002A\u0011\u0001B;\u0011\u001d\u0011\u0019\b\u0001C\u0005\u0005\u000bCqA!&\u0001\t\u0013\u00119\nC\u0004\u0003.\u0002!\tAa,\t\u000f\t\r\u0007\u0001\"\u0003\u0003F\"9!1\u001c\u0001\u0005\u0002\tu\u0007b\u0002Bu\u0001\u0011\u0005!1\u001e\u0002\b\u00072,\u0017M\\3s\u0015\tQ3&A\u0002m_\u001eT\u0011\u0001L\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001q&\u000e\t\u0003aMj\u0011!\r\u0006\u0002e\u0005)1oY1mC&\u0011A'\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005YJT\"A\u001c\u000b\u0005aZ\u0013!B;uS2\u001c\u0018B\u0001\u001e8\u0005\u001daunZ4j]\u001e\f!!\u001b3\u0016\u0003u\u0002\"\u0001\r \n\u0005}\n$aA%oi\u0006\u0019\u0011\u000e\u001a\u0011\u0002\u0013=4gm]3u\u001b\u0006\u0004X#A\"\u0011\u0005\u0011+U\"A\u0015\n\u0005\u0019K#!C(gMN,G/T1q\u0003)ygMZ:fi6\u000b\u0007\u000fI\u0001\rS>\u0014UO\u001a4feNK'0Z\u0001\u0010[\u0006D\u0018j\u001c\"vM\u001a,'oU5{K\u0006\u0019B-\u001e9Ck\u001a4WM\u001d'pC\u00124\u0015m\u0019;peB\u0011\u0001\u0007T\u0005\u0003\u001bF\u0012a\u0001R8vE2,\u0017!\u0003;ie>$H\u000f\\3s!\t1\u0004+\u0003\u0002Ro\tIA\u000b\u001b:piRdWM]\u0001\u0005i&lW\r\u0005\u0002U;6\tQK\u0003\u00029-*\u0011q\u000bW\u0001\u0007G>lWn\u001c8\u000b\u00051J&B\u0001.\\\u0003\u0019\t\u0007/Y2iK*\tA,A\u0002pe\u001eL!AX+\u0003\tQKW.Z\u0001\nG\",7m\u001b#p]\u0016\u0004B\u0001M1dO&\u0011!-\r\u0002\n\rVt7\r^5p]F\u0002\"\u0001Z3\u000e\u0003YK!A\u001a,\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0011\u0001\u0007[\u0005\u0003SF\u0012A!\u00168ji\u0006q1\r\\3b]\u0016\u0014X*\u001a;sS\u000e\u001c\bC\u0001#m\u0013\ti\u0017FA\tM_\u001e\u001cE.Z1oKJlU\r\u001e:jGN\fa\u0001P5oSRtDC\u00039reN$XO^<ysB\u0011A\t\u0001\u0005\u0006w1\u0001\r!\u0010\u0005\u0006\u00032\u0001\ra\u0011\u0005\u0006\u00112\u0001\r!\u0010\u0005\u0006\u00132\u0001\r!\u0010\u0005\u0006\u00152\u0001\ra\u0013\u0005\u0006\u001d2\u0001\ra\u0014\u0005\u0006%2\u0001\ra\u0015\u0005\u0006?2\u0001\r\u0001\u0019\u0005\u0006U2\u0001\ra[\u0001\u000bY><w-\u001a:OC6,W#\u0001?\u0011\u0007u\f)!D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0004\u0005!!.\u0019<b\u0013\r\t9A \u0002\u0007'R\u0014\u0018N\\4\u0002\u0015I,\u0017\r\u001a\"vM\u001a,'/\u0006\u0002\u0002\u000eA!\u0011qBA\u000b\u001b\t\t\tB\u0003\u0003\u0002\u0014\u0005\u0005\u0011a\u00018j_&!\u0011qCA\t\u0005)\u0011\u0015\u0010^3Ck\u001a4WM]\u0001\u000fe\u0016\fGMQ;gM\u0016\u0014x\fJ3r)\r9\u0017Q\u0004\u0005\n\u0003?y\u0011\u0011!a\u0001\u0003\u001b\t1\u0001\u001f\u00132\u0003-\u0011X-\u00193Ck\u001a4WM\u001d\u0011\u0002\u0017]\u0014\u0018\u000e^3Ck\u001a4WM]\u0001\u0010oJLG/\u001a\"vM\u001a,'o\u0018\u0013fcR\u0019q-!\u000b\t\u0013\u0005}!#!AA\u0002\u00055\u0011\u0001D<sSR,')\u001e4gKJ\u0004\u0013a\u00073fG>l\u0007O]3tg&|gNQ;gM\u0016\u00148+\u001e9qY&,'/\u0006\u0002\u00022A\u0019A+a\r\n\u0007\u0005URK\u0001\bCk\u001a4WM]*vaBd\u0017.\u001a:\u00029\u0011,7m\\7qe\u0016\u001c8/[8o\u0005V4g-\u001a:TkB\u0004H.[3sA\u0005)1\r\\3b]R!\u0011QHA(!\u001d\u0001\u0014qHA\"\u0003\u0013J1!!\u00112\u0005\u0019!V\u000f\u001d7feA\u0019\u0001'!\u0012\n\u0007\u0005\u001d\u0013G\u0001\u0003M_:<\u0007c\u0001#\u0002L%\u0019\u0011QJ\u0015\u0003\u0019\rcW-\u00198feN#\u0018\r^:\t\u000f\u0005Ec\u00031\u0001\u0002T\u0005I1\r\\3b]\u0006\u0014G.\u001a\t\u0004\t\u0006U\u0013bAA,S\tY1\t\\3b]B\u000b'/Y7t\u0003\u001d!wn\u00117fC:$b!!\u0010\u0002^\u0005}\u0003bBA)/\u0001\u0007\u00111\u000b\u0005\b\u0003C:\u0002\u0019AA\"\u0003-\u0019WO\u001d:f]R$\u0016.\\3\u0002\u001b\rdW-\u00198TK\u001elWM\u001c;t)=9\u0017qMA8\u0003\u000b\u000bI)a#\u0002\u0010\u0006e\u0005B\u0002\u0016\u0019\u0001\u0004\tI\u0007E\u0002E\u0003WJ1!!\u001c*\u0005-\t%m\u001d;sC\u000e$Hj\\4\t\u000f\u0005E\u0004\u00041\u0001\u0002t\u0005A1/Z4nK:$8\u000f\u0005\u0004\u0002v\u0005m\u0014qP\u0007\u0003\u0003oR1!!\u001f2\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003{\n9HA\u0002TKF\u00042\u0001RAA\u0013\r\t\u0019)\u000b\u0002\u000b\u0019><7+Z4nK:$\bBBAD1\u0001\u00071)A\u0002nCBDq!!\u0019\u0019\u0001\u0004\t\u0019\u0005C\u0004\u0002\u000eb\u0001\r!!\u0013\u0002\u000bM$\u0018\r^:\t\u000f\u0005E\u0005\u00041\u0001\u0002\u0014\u0006\u0019BO]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uCB\u0019A)!&\n\u0007\u0005]\u0015F\u0001\u000eDY\u0016\fg.\u001a3Ue\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\rC\u0004\u0002\u001cb\u0001\r!a\u0011\u0002+1,w-Y2z\t\u0016dW\r^3I_JL'p\u001c8Ng\u0006I1\r\\3b]&sGo\u001c\u000b\u0018O\u0006\u0005\u0016QUAX\u0003g\u000b),a0\u0002D\u0006\u001d\u0017\u0011ZAu\u0003WDa!a)\u001a\u0001\u0004\u0019\u0017A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003OK\u0002\u0019AAU\u0003\u0019\u0019x.\u001e:dKB\u0019A)a+\n\u0007\u00055\u0016FA\u000bM_\u001e\u001cVmZ7f]R\u0014V-\u00193BI\u0006\u0004H/\u001a:\t\u000f\u0005E\u0016\u00041\u0001\u0002\u0000\u0005!A-Z:u\u0011\u0019\t9)\u0007a\u0001\u0007\"9\u0011qW\rA\u0002\u0005e\u0016\u0001\t:fi\u0006Lg\u000eT3hC\u000eLH)\u001a7fi\u0016\u001c\u0018I\u001c3Uq:l\u0015M]6feN\u00042\u0001MA^\u0013\r\ti,\r\u0002\b\u0005>|G.Z1o\u0011\u001d\t\t-\u0007a\u0001\u0003\u0007\n\u0011\u0003Z3mKR,'+\u001a;f]RLwN\\'t\u0011\u0019\t)-\u0007a\u0001{\u0005\tR.\u0019=M_\u001elUm]:bO\u0016\u001c\u0016N_3\t\u000f\u0005E\u0015\u00041\u0001\u0002\u0014\"9\u00111Z\rA\u0002\u00055\u0017\u0001\b7bgR\u0014VmY8sIN|e-Q2uSZ,\u0007K]8ek\u000e,'o\u001d\t\t\u0003\u001f\fi.a\u0011\u0002d:!\u0011\u0011[Am!\r\t\u0019.M\u0007\u0003\u0003+T1!a6.\u0003\u0019a$o\\8u}%\u0019\u00111\\\u0019\u0002\rA\u0013X\rZ3g\u0013\u0011\ty.!9\u0003\u00075\u000b\u0007OC\u0002\u0002\\F\u00022\u0001RAs\u0013\r\t9/\u000b\u0002\u000b\u0019\u0006\u001cHOU3d_J$\u0007bBAG3\u0001\u0007\u0011\u0011\n\u0005\b\u0003CJ\u0002\u0019AA\"\u0003E9'o\\<Ck\u001a4WM]:Pe\u001a\u000b\u0017\u000e\u001c\u000b\nO\u0006E\u00181_A|\u0003sDq!a*\u001b\u0001\u0004\tI\u000b\u0003\u0004\u0002vj\u0001\r!P\u0001\ta>\u001c\u0018\u000e^5p]\"1\u0011Q\u0019\u000eA\u0002uBq!a?\u001b\u0001\u0004\ti0A\u0007nK6|'/\u001f*fG>\u0014Hm\u001d\t\u0005\u0003\u007f\u0014)!\u0004\u0002\u0003\u0002)\u0019!1\u0001,\u0002\rI,7m\u001c:e\u0013\u0011\u00119A!\u0001\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0003I\u0019\bn\\;mI\u0012K7oY1sI\n\u000bGo\u00195\u0015\r\u0005e&Q\u0002B\f\u0011\u001d\u0011ya\u0007a\u0001\u0005#\tQAY1uG\"\u0004B!a@\u0003\u0014%!!Q\u0003B\u0001\u0005-\u0011VmY8sI\n\u000bGo\u00195\t\u000f\u0005E5\u00041\u0001\u0002\u0014\u0006\u00112\u000f[8vY\u0012\u0014V\r^1j]J+7m\u001c:e)A\tIL!\b\u0003 \t\r\"Q\u0005B\u0017\u0005_\u0011\t\u0004\u0003\u0004\u0002\br\u0001\ra\u0011\u0005\b\u0005Ca\u0002\u0019AA]\u0003u\u0011X\r^1j]\u0012+G.\u001a;fg\u001a{'\u000fT3hC\u000eL(+Z2pe\u0012\u001c\bb\u0002B\b9\u0001\u0007!\u0011\u0003\u0005\b\u0005\u0007a\u0002\u0019\u0001B\u0014!\u0011\tyP!\u000b\n\t\t-\"\u0011\u0001\u0002\u0007%\u0016\u001cwN\u001d3\t\u000f\u00055E\u00041\u0001\u0002J!9\u0011\u0011\r\u000fA\u0002\u0005\r\u0003bBAa9\u0001\u0007\u00111I\u0001\fOJ|wOQ;gM\u0016\u00148\u000fF\u0002h\u0005oAa!!2\u001e\u0001\u0004i\u0014A\u0004:fgR|'/\u001a\"vM\u001a,'o\u001d\u000b\u0002O\u0006\u0019rM]8vaN+w-\\3oiN\u0014\u0015pU5{KRQ!\u0011\tB*\u00057\u0012yFa\u0019\u0011\r\t\r#QJA:\u001d\u0011\u0011)E!\u0013\u000f\t\u0005M'qI\u0005\u0002e%\u0019!1J\u0019\u0002\u000fA\f7m[1hK&!!q\nB)\u0005\u0011a\u0015n\u001d;\u000b\u0007\t-\u0013\u0007C\u0004\u0002r}\u0001\rA!\u0016\u0011\r\u0005U$qKA@\u0013\u0011\u0011I&a\u001e\u0003\u0011%#XM]1cY\u0016DaA!\u0018 \u0001\u0004i\u0014aB7bqNK'0\u001a\u0005\u0007\u0005Cz\u0002\u0019A\u001f\u0002\u00195\f\u00070\u00138eKb\u001c\u0016N_3\t\u000f\t\u0015t\u00041\u0001\u0002D\u00051b-\u001b:tiVs7\r\\3b]\u0006\u0014G.Z(gMN,G/A\rmCN$xJ\u001a4tKR4uN\u001d$jeN$8+Z4nK:$HCBA\"\u0005W\u0012\t\bC\u0004\u0003n\u0001\u0002\rAa\u001c\u0002\tM,wm\u001d\t\u0007\u0005\u0007\u0012i%a \t\u000f\t\u0015\u0004\u00051\u0001\u0002D\u0005q!-^5mI>3gm]3u\u001b\u0006\u0004H\u0003DA]\u0005o\u0012IH! \u0003\u0002\n\r\u0005B\u0002\u0016\"\u0001\u0004\tI\u0007C\u0004\u0003|\u0005\u0002\r!a\u0011\u0002\u000bM$\u0018M\u001d;\t\u000f\t}\u0014\u00051\u0001\u0002D\u0005\u0019QM\u001c3\t\r\u0005\u001d\u0015\u00051\u0001D\u0011\u001d\ti)\ta\u0001\u0003\u0013\"b\"!/\u0003\b\n%%Q\u0012BH\u0005#\u0013\u0019\n\u0003\u0004+E\u0001\u0007\u0011\u0011\u000e\u0005\b\u0003c\u0012\u0003\u0019\u0001BF!\u0019\t)Ha\u0016\u0002*\"9!1\u0010\u0012A\u0002\u0005\r\u0003b\u0002B@E\u0001\u0007\u00111\t\u0005\u0007\u0003\u000f\u0013\u0003\u0019A\"\t\u000f\u00055%\u00051\u0001\u0002J\u0005A\"-^5mI>3gm]3u\u001b\u0006\u0004hi\u001c:TK\u001elWM\u001c;\u0015%\u0005e&\u0011\u0014BN\u0005;\u0013yJa)\u0003(\n%&1\u0016\u0005\u0007\u0003G\u001b\u0003\u0019A2\t\u000f\u0005\u001d6\u00051\u0001\u0002*\"1\u0011qQ\u0012A\u0002\rCqA!)$\u0001\u0004\t\u0019%A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\bb\u0002BSG\u0001\u0007\u00111I\u0001\u0011kB\u0004XM\u001d\"pk:$wJ\u001a4tKRDa!!2$\u0001\u0004i\u0004bBAIG\u0001\u0007\u00111\u0013\u0005\b\u0003\u001b\u001b\u0003\u0019AA%\u0003-1\u0018\r\\5eCR,Gj\\4\u0015\u0019\u0005e&\u0011\u0017BZ\u0005k\u00139L!1\t\r)\"\u0003\u0019AA5\u0011\u001d\u0011Y\b\na\u0001\u0003\u0007BqAa %\u0001\u0004\t\u0019\u0005C\u0004\u0003:\u0012\u0002\rAa/\u0002\u001b\t\f7/Z(gMN,G/T1q!\r!%QX\u0005\u0004\u0005\u007fK#!E#yi\u0016tG-\u001a3PM\u001a\u001cX\r^'ba\"9\u0011Q\u0012\u0013A\u0002\u0005%\u0013A\u0005<bY&$\u0017\r^3M_\u001e\u001cVmZ7f]R$\"#a\u0011\u0003H\n%'1\u001aBh\u0005'\u0014)Na6\u0003Z\"1\u00111U\u0013A\u0002\rDq!a*&\u0001\u0004\tI\u000bC\u0004\u0003N\u0016\u0002\rAa/\u0002\u000f\t\f7/Z'ba\"9!\u0011[\u0013A\u0002\tm\u0016a\u00023jM\u001al\u0015\r\u001d\u0005\b\u0005C+\u0003\u0019AA\"\u0011\u0019\t)-\na\u0001{!9\u0011\u0011S\u0013A\u0002\u0005M\u0005bBAGK\u0001\u0007\u0011\u0011J\u0001\fY><7+Z4nK:$8\u000f\u0006\u0005\u0003\f\n}'\u0011\u001dBs\u0011\u0019Qc\u00051\u0001\u0002j!9!1\u001d\u0014A\u0002\u0005\r\u0013\u0001\u00024s_6DqAa:'\u0001\u0004\t\u0019%\u0001\u0002u_\u0006Q2m\u001c7mK\u000e$\u0018IY8si\u0016$GK]1og\u0006\u001cG/[8ogRA!Q\u001eB{\u0005o\u0014I\u0010\u0005\u0004\u0003D\t5#q\u001e\t\u0004\t\nE\u0018b\u0001BzS\tQ\u0011IY8si\u0016$G\u000b\u001f8\t\r):\u0003\u0019AA5\u0011\u001d\u0011Yh\na\u0001\u0003\u0007BqAa (\u0001\u0004\t\u0019\u0005")
public class Cleaner
implements Logging {
    private final int id;
    private final OffsetMap offsetMap;
    private final int ioBufferSize;
    private final int maxIoBufferSize;
    private final double dupBufferLoadFactor;
    private final Throttler throttler;
    private final Time time;
    private final Function1<TopicPartition, BoxedUnit> checkDone;
    private final LogCleanerMetrics cleanerMetrics;
    private ByteBuffer readBuffer;
    private ByteBuffer writeBuffer;
    private final BufferSupplier decompressionBufferSupplier;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int id() {
        return this.id;
    }

    public OffsetMap offsetMap() {
        return this.offsetMap;
    }

    @Override
    public String loggerName() {
        return LogCleaner.class.getName();
    }

    private ByteBuffer readBuffer() {
        return this.readBuffer;
    }

    private void readBuffer_$eq(ByteBuffer x$1) {
        this.readBuffer = x$1;
    }

    private ByteBuffer writeBuffer() {
        return this.writeBuffer;
    }

    private void writeBuffer_$eq(ByteBuffer x$1) {
        this.writeBuffer = x$1;
    }

    private BufferSupplier decompressionBufferSupplier() {
        return this.decompressionBufferSupplier;
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Object, CleanerStats> clean(CleanParams cleanable) {
        void var3_3;
        void var5_4;
        if (cleanable.firstDirtyOffset() >= cleanable.firstUncleanableOffset()) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(103).append("Skip cleaning for log ").append(cleanable.log().name()).append(" because dirty range is not cleanable. ").append("firstDirtyOffset=").append(cleanable.firstDirtyOffset()).append(", firstUncleanableOffset=").append(cleanable.firstUncleanableOffset()).toString());
            return new Tuple2((Object)BoxesRunTime.boxToLong((long)cleanable.firstDirtyOffset()), (Object)new CleanerStats(this.time, this.cleanerMetrics));
        }
        Tuple2<Object, CleanerStats> tuple2 = this.doClean(cleanable, this.time.milliseconds());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long nextDirtyOffset = tuple2._1$mcJ$sp();
        CleanerStats cleanerStats = (CleanerStats)tuple2._2();
        double bytesShrinkageRatio = 1.0 - (double)var5_4.bytesWritten() / (double)var5_4.bytesRead();
        cleanable.log().updateLastShrinkageRatio(bytesShrinkageRatio);
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)var3_3), (Object)var5_4);
    }

    public Tuple2<Object, CleanerStats> doClean(CleanParams cleanable, long currentTime) {
        long l;
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Beginning cleaning of log %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.log().name()})));
        Option option = cleanable.log().localLogSegments(0L, cleanable.firstDirtyOffset()).lastOption();
        if (None$.MODULE$.equals(option)) {
            l = 0L;
        } else if (option instanceof Some) {
            l = ((LogSegment)((Some)option).value()).lastModified() - Predef$.MODULE$.Long2long(cleanable.log().config().deleteRetentionMs());
        } else {
            throw new MatchError((Object)option);
        }
        AbstractLog log = cleanable.log();
        CleanerStats stats = new CleanerStats(this.time, this.cleanerMetrics);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Building offset map for %s...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.log().name()})));
        long upperBoundOffset = cleanable.firstUncleanableOffset();
        boolean isOffsetMapFull = this.buildOffsetMap(log, cleanable.firstDirtyOffset(), upperBoundOffset, this.offsetMap(), stats);
        long endOffset = this.offsetMap().latestOffset() + 1L;
        stats.indexDone(isOffsetMapFull);
        long cleanableHorizonMs = BoxesRunTime.unboxToLong((Object)log.localLogSegments(0L, cleanable.firstUncleanableOffset()).lastOption().map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToLong((long)x$15.lastModified())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Cleaning log %s (cleaning prior to %s, discarding tombstones prior to upper bound deletion horizon %s)...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), new Date(cleanableHorizonMs), new Date(l)})));
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        this.groupSegmentsBySize(log.localLogSegments(cleanable.startOffset(), endOffset), Predef$.MODULE$.Integer2int(log.config().segmentSize()), Predef$.MODULE$.Integer2int(log.config().maxIndexSize()), cleanable.firstUncleanableOffset()).foreach((Function1 & Serializable & scala.Serializable)group -> {
            this.cleanSegments(log, (Seq<LogSegment>)group, this.offsetMap(), currentTime, stats, transactionMetadata, l);
            return BoxedUnit.UNIT;
        });
        stats.bufferUtilization_$eq(this.offsetMap().utilization());
        stats.allDone();
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)endOffset), (Object)stats);
    }

    public void cleanSegments(AbstractLog log, Seq<LogSegment> segments, OffsetMap map, long currentTime, CleanerStats stats, CleanedTransactionMetadata transactionMetadata, long legacyDeleteHorizonMs) {
        LogSegment cleaned = MergedLog$.MODULE$.createNewCleanedSegment(log.dir(), log.config(), ((LogSegment)segments.head()).baseOffset());
        transactionMetadata.cleanedIndex_$eq((Option<TransactionIndex>)new Some((Object)cleaned.txnIndex()));
        try {
            Iterator iter = segments.iterator();
            Some currentSegmentOpt = new Some(iter.next());
            Map<Object, LastRecord> lastOffsetOfActiveProducers = log.lastRecordsOfActiveProducers();
            while (currentSegmentOpt.isDefined()) {
                LogSegment currentSegment = (LogSegment)currentSegmentOpt.get();
                None$ nextSegmentOpt = iter.hasNext() ? new Some(iter.next()) : None$.MODULE$;
                long startOffset = currentSegment.baseOffset();
                long upperBoundOffset = BoxesRunTime.unboxToLong((Object)nextSegmentOpt.map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToLong((long)x$16.baseOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> currentSegment.readNextOffset()));
                List<AbortedTxn> abortedTransactions = this.collectAbortedTransactions(log, startOffset, upperBoundOffset);
                transactionMetadata.addAbortedTransactions(abortedTransactions);
                boolean retainLegacyDeletesAndTxnMarkers = currentSegment.lastModified() > legacyDeleteHorizonMs;
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(120).append("Cleaning ").append(currentSegment).append(" in log ").append(log.name()).append(" into ").append(cleaned.baseOffset()).append(" ").append("with an upper bound deletion horizon ").append(legacyDeleteHorizonMs).append(" computed from ").append("the segment last modified time of ").append(currentSegment.lastModified()).append(",").append((Object)(retainLegacyDeletesAndTxnMarkers ? "retaining" : "discarding")).append(" deletes.").toString());
                try {
                    LocalLogSegmentReadAdapter segmentAdapter = new LocalLogSegmentReadAdapter(log, currentSegment);
                    this.cleanInto(log.topicPartition(), segmentAdapter, cleaned, map, retainLegacyDeletesAndTxnMarkers, Predef$.MODULE$.Long2long(log.config().deleteRetentionMs()), Predef$.MODULE$.Integer2int(log.config().maxMessageSize()), transactionMetadata, lastOffsetOfActiveProducers, stats, currentTime);
                }
                catch (LogSegmentOffsetOverflowException e) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Caught segment overflow error during cleaning: ").append(e.getMessage()).toString());
                    log.splitOverflowedSegment(currentSegment);
                    throw new LogCleaningAbortedException();
                }
                currentSegmentOpt = nextSegmentOpt;
            }
            cleaned.onBecomeInactiveSegment();
            cleaned.flush();
            long modified = ((LogSegment)segments.last()).lastModified();
            cleaned.lastModified_$eq(modified);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Swapping in cleaned segment ").append(cleaned).append(" for segment(s) ").append(segments).append(" in log ").append(log).toString());
            log.replaceSegments((Seq<LogSegment>)new .colon.colon((Object)cleaned, (List)Nil$.MODULE$), segments);
            return;
        }
        catch (LogCleaningAbortedException e) {
            try {
                try {
                    cleaned.deleteIfExists();
                }
                catch (Exception deleteException) {
                    e.addSuppressed(deleteException);
                }
            }
            catch (Throwable throwable) {
                throw e;
            }
            throw e;
        }
    }

    public void cleanInto(TopicPartition topicPartition, LogSegmentReadAdapter source, LogSegment dest, OffsetMap map, boolean retainLegacyDeletesAndTxnMarkers, long deleteRetentionMs, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, Map<Object, LastRecord> lastRecordsOfActiveProducers, CleanerStats stats, long currentTime) {
        MemoryRecords.RecordFilter logCleanerFilter = new MemoryRecords.RecordFilter(this, currentTime, deleteRetentionMs, transactionMetadata, lastRecordsOfActiveProducers, map, retainLegacyDeletesAndTxnMarkers, stats){
            private boolean discardBatchRecords;
            private final /* synthetic */ Cleaner $outer;
            private final CleanedTransactionMetadata transactionMetadata$2;
            private final Map lastRecordsOfActiveProducers$1;
            private final OffsetMap map$1;
            private final boolean retainLegacyDeletesAndTxnMarkers$2;
            private final CleanerStats stats$3;

            private boolean discardBatchRecords() {
                return this.discardBatchRecords;
            }

            private void discardBatchRecords_$eq(boolean x$1) {
                this.discardBatchRecords = x$1;
            }

            public MemoryRecords.RecordFilter.BatchRetentionResult checkBatchRetention(RecordBatch batch) {
                boolean canDiscardBatch = this.$outer.kafka$log$Cleaner$$shouldDiscardBatch(batch, this.transactionMetadata$2);
                if (batch.isControlBatch()) {
                    if (batch.deleteHorizonMs().isPresent()) {
                        this.discardBatchRecords_$eq(canDiscardBatch && batch.deleteHorizonMs().getAsLong() <= this.currentTime);
                    } else {
                        this.discardBatchRecords_$eq(canDiscardBatch && this.deleteRetentionMs == 0L);
                    }
                } else {
                    this.discardBatchRecords_$eq(canDiscardBatch);
                }
                MemoryRecords.RecordFilter.BatchRetention batchRetention = batch.hasProducerId() && this.lastRecordsOfActiveProducers$1.get((Object)BoxesRunTime.boxToLong((long)batch.producerId())).exists((Function1 & Serializable & scala.Serializable)lastRecord -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$checkBatchRetention$1(batch, lastRecord))) ? MemoryRecords.RecordFilter.BatchRetention.RETAIN_EMPTY : (this.discardBatchRecords() ? MemoryRecords.RecordFilter.BatchRetention.DELETE : MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY);
                return new MemoryRecords.RecordFilter.BatchRetentionResult(batchRetention, canDiscardBatch && batch.isControlBatch());
            }

            public boolean shouldRetainRecord(RecordBatch batch, Record record) {
                if (this.discardBatchRecords()) {
                    return false;
                }
                if (batch.isControlBatch()) {
                    return true;
                }
                return this.$outer.kafka$log$Cleaner$$shouldRetainRecord(this.map$1, this.retainLegacyDeletesAndTxnMarkers$2, batch, record, this.stats$3, this.currentTime, this.deleteRetentionMs);
            }

            public void onBatchRetained(RecordBatch batch) {
                this.transactionMetadata$2.onBatchRetained(batch);
            }

            public static final /* synthetic */ boolean $anonfun$checkBatchRetention$1(RecordBatch batch$1, LastRecord lastRecord) {
                boolean bl;
                Option<Object> option = lastRecord.lastDataOffset();
                if (option instanceof Some) {
                    long offset = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                    bl = batch$1.lastOffset() == offset;
                } else if (None$.MODULE$.equals(option)) {
                    bl = batch$1.isControlBatch() && batch$1.producerEpoch() == lastRecord.producerEpoch() && batch$1.maxTimestamp() >= lastRecord.lastTimestamp();
                } else {
                    throw new MatchError(option);
                }
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.transactionMetadata$2 = transactionMetadata$2;
                this.lastRecordsOfActiveProducers$1 = lastRecordsOfActiveProducers$1;
                this.map$1 = map$1;
                this.retainLegacyDeletesAndTxnMarkers$2 = retainLegacyDeletesAndTxnMarkers$2;
                this.stats$3 = stats$3;
                super(currentTime$2, deleteRetentionMs$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$checkBatchRetention$1$adapted(org.apache.kafka.common.record.RecordBatch kafka.log.LastRecord )}, serializedLambda);
            }
        };
        int position = source.startPosition();
        while (position < source.endPosition()) {
            this.checkDone.apply((Object)topicPartition);
            this.readBuffer().clear();
            this.writeBuffer().clear();
            source.readBytes(this.readBuffer(), position);
            MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.readBuffer());
            this.throttler.maybeThrottle(records.sizeInBytes());
            MemoryRecords.FilterResult result = records.filterTo(topicPartition, logCleanerFilter, this.writeBuffer(), maxLogMessageSize, this.decompressionBufferSupplier());
            stats.readMessages(result.messagesRead(), result.bytesRead());
            stats.recopyMessages(result.messagesRetained(), result.bytesRetained());
            position += result.bytesRead();
            ByteBuffer outputBuffer = result.outputBuffer();
            if (outputBuffer.position() > 0) {
                outputBuffer.flip();
                MemoryRecords retained = MemoryRecords.readableRecords((ByteBuffer)outputBuffer);
                dest.append(result.maxOffset(), retained);
                this.throttler.maybeThrottle(outputBuffer.limit());
            }
            if (this.readBuffer().limit() <= 0 || result.bytesRead() != 0) continue;
            this.growBuffersOrFail(source, position, maxLogMessageSize, records);
        }
        this.restoreBuffers();
    }

    private void growBuffersOrFail(LogSegmentReadAdapter source, int position, int maxLogMessageSize, MemoryRecords memoryRecords) {
        int n;
        if (this.readBuffer().capacity() >= maxLogMessageSize) {
            Integer nextBatchSize = memoryRecords.firstBatchSize();
            String logDesc = new StringBuilder(13).append(source).append(" at position ").append(position).toString();
            if (nextBatchSize == null) {
                throw new IllegalStateException(new StringBuilder(40).append("Could not determine next batch size for ").append(logDesc).toString());
            }
            if (Predef$.MODULE$.Integer2int(nextBatchSize) <= 0) {
                throw new IllegalStateException(new StringBuilder(24).append("Invalid batch size ").append(nextBatchSize).append(" for ").append(logDesc).toString());
            }
            if (Predef$.MODULE$.Integer2int(nextBatchSize) <= this.readBuffer().capacity()) {
                throw new IllegalStateException(new StringBuilder(50).append("Batch size ").append(nextBatchSize).append(" < buffer size ").append(this.readBuffer().capacity()).append(", but not processed for ").append(logDesc).toString());
            }
            int bytesLeft = source.endPosition() - position;
            if (Predef$.MODULE$.Integer2int(nextBatchSize) > bytesLeft) {
                throw new CorruptRecordException(new StringBuilder(69).append("Log segment may be corrupt, batch size ").append(nextBatchSize).append(" > ").append(bytesLeft).append(" bytes left in segment for ").append(logDesc).toString());
            }
            n = nextBatchSize;
        } else {
            n = maxLogMessageSize;
        }
        int maxSize = n;
        this.growBuffers(maxSize);
    }

    public boolean kafka$log$Cleaner$$shouldDiscardBatch(RecordBatch batch, CleanedTransactionMetadata transactionMetadata) {
        if (batch.isControlBatch()) {
            return transactionMetadata.onControlBatchRead(batch);
        }
        return transactionMetadata.onBatchRead(batch);
    }

    public boolean kafka$log$Cleaner$$shouldRetainRecord(OffsetMap map, boolean retainDeletesForLegacyRecords, RecordBatch batch, Record record, CleanerStats stats, long currentTime, long deleteRetentionMs) {
        if (record.offset() > map.latestOffset()) {
            return true;
        }
        if (record.hasKey()) {
            boolean isRetainedValue;
            ByteBuffer key = record.key();
            long foundOffset = map.get(key);
            boolean latestOffsetForKey = record.offset() >= foundOffset;
            boolean legacyRecord = batch.magic() < 2;
            boolean bl = isRetainedValue = record.hasValue() || Cleaner.shouldRetainDeletes$1(legacyRecord, deleteRetentionMs, batch, currentTime, retainDeletesForLegacyRecords);
            return latestOffsetForKey && isRetainedValue;
        }
        stats.invalidMessage();
        return false;
    }

    public void growBuffers(int maxLogMessageSize) {
        int maxBufferSize = package$.MODULE$.max(maxLogMessageSize, this.maxIoBufferSize);
        if (this.readBuffer().capacity() >= maxBufferSize || this.writeBuffer().capacity() >= maxBufferSize) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("This log contains a message larger than maximum allowable size of %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxBufferSize)})));
        }
        int newSize = package$.MODULE$.min(this.readBuffer().capacity() * 2, maxBufferSize);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Growing cleaner I/O buffers from ").append(this.readBuffer().capacity()).append(" bytes to ").append(newSize).append(" bytes.").toString());
        this.readBuffer_$eq(ByteBuffer.allocate(newSize));
        this.writeBuffer_$eq(ByteBuffer.allocate(newSize));
    }

    public void restoreBuffers() {
        if (this.readBuffer().capacity() > this.ioBufferSize) {
            this.readBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
        if (this.writeBuffer().capacity() > this.ioBufferSize) {
            this.writeBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
    }

    public List<Seq<LogSegment>> groupSegmentsBySize(Iterable<LogSegment> segments, int maxSize, int maxIndexSize, long firstUncleanableOffset) {
        Nil$ grouped = Nil$.MODULE$;
        List segs = segments.toList();
        while (segs.nonEmpty()) {
            .colon.colon group = new .colon.colon((Object)((LogSegment)segs.head()), (List)Nil$.MODULE$);
            long logSize = ((LogSegment)segs.head()).size();
            long indexSize = ((LogSegment)segs.head()).offsetIndex().sizeInBytes();
            long timeIndexSize = ((LogSegment)segs.head()).timeIndex().sizeInBytes();
            segs = (List)segs.tail();
            while (segs.nonEmpty() && logSize + (long)((LogSegment)segs.head()).size() <= (long)maxSize && indexSize + (long)((LogSegment)segs.head()).offsetIndex().sizeInBytes() <= (long)maxIndexSize && timeIndexSize + (long)((LogSegment)segs.head()).timeIndex().sizeInBytes() <= (long)maxIndexSize && (((LogSegment)segs.head()).size() == 0 || this.lastOffsetForFirstSegment((List<LogSegment>)segs, firstUncleanableOffset) - ((LogSegment)group.last()).baseOffset() <= Integer.MAX_VALUE)) {
                LogSegment logSegment = (LogSegment)segs.head();
                group = group.$colon$colon((Object)logSegment);
                logSize += (long)((LogSegment)segs.head()).size();
                indexSize += (long)((LogSegment)segs.head()).offsetIndex().sizeInBytes();
                timeIndexSize += (long)((LogSegment)segs.head()).timeIndex().sizeInBytes();
                segs = (List)segs.tail();
            }
            grouped = grouped.$colon$colon((Object)group.reverse());
        }
        return grouped.reverse();
    }

    private long lastOffsetForFirstSegment(List<LogSegment> segs, long firstUncleanableOffset) {
        if (segs.size() > 1) {
            return ((LogSegment)segs.apply(1)).baseOffset() - 1L;
        }
        return firstUncleanableOffset - 1L;
    }

    public boolean buildOffsetMap(AbstractLog log, long start, long end, OffsetMap map, CleanerStats stats) {
        Iterable<LogSegmentReadAdapter> dirty = this.logSegments(log, start, end);
        return this.buildOffsetMap(log, dirty, start, end, map, stats);
    }

    private boolean buildOffsetMap(AbstractLog log, Iterable<LogSegmentReadAdapter> segments, long start, long end, OffsetMap map, CleanerStats stats) {
        map.clear();
        Buffer dirty = segments.toBuffer();
        ListBuffer nextSegmentStartOffsets = new ListBuffer();
        if (dirty.nonEmpty()) {
            ((IterableLike)dirty.tail()).foreach((Function1 & Serializable & scala.Serializable)nextSegment -> {
                nextSegmentStartOffsets.append((Seq)Predef$.MODULE$.wrapLongArray(new long[]{nextSegment.baseOffset()}));
                return BoxedUnit.UNIT;
            });
            nextSegmentStartOffsets.append((Seq)Predef$.MODULE$.wrapLongArray(new long[]{end}));
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Building offset map for log %s for %d segments in offset range [%d, %d).")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), BoxesRunTime.boxToInteger((int)dirty.size()), BoxesRunTime.boxToLong((long)start), BoxesRunTime.boxToLong((long)end)})));
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        List<AbortedTxn> abortedTransactions = this.collectAbortedTransactions(log, start, end);
        transactionMetadata.addAbortedTransactions(abortedTransactions);
        BooleanRef full = BooleanRef.create((boolean)false);
        IntRef mappedSegmentCount = IntRef.create((int)0);
        ((TraversableLike)dirty.zip((GenIterable)nextSegmentStartOffsets, Buffer$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).withFilter((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)Cleaner.$anonfun$buildOffsetMap$4(full, x$18))).foreach((Function1 & Serializable & scala.Serializable)x$19 -> {
            Cleaner.$anonfun$buildOffsetMap$5(this, log, mappedSegmentCount, dirty, full, map, start, transactionMetadata, stats, x$19);
            return BoxedUnit.UNIT;
        });
        return full.elem;
    }

    private boolean buildOffsetMapForSegment(TopicPartition topicPartition, LogSegmentReadAdapter source, OffsetMap map, long startOffset, long upperBoundOffset, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, CleanerStats stats) {
        Object object = new Object();
        try {
            int position = source.startPosition();
            int maxDesiredMapSize = (int)((double)map.slots() * this.dupBufferLoadFactor);
            while (position < source.endPosition() && map.latestOffset() < upperBoundOffset - 1L) {
                this.checkDone.apply((Object)topicPartition);
                this.readBuffer().clear();
                source.readBytes(this.readBuffer(), position);
                MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.readBuffer());
                this.throttler.maybeThrottle(records.sizeInBytes());
                int startPosition = position;
                java.util.Iterator batchIter = records.batches().iterator();
                while (batchIter.hasNext() && map.latestOffset() < upperBoundOffset - 1L) {
                    MutableRecordBatch batch = (MutableRecordBatch)batchIter.next();
                    if (batch.isControlBatch()) {
                        transactionMetadata.onControlBatchRead((RecordBatch)batch);
                        stats.indexMessagesRead(1);
                    } else if (transactionMetadata.onBatchRead((RecordBatch)batch)) {
                        stats.indexMessagesRead(Predef$.MODULE$.Integer2int(batch.countOrNull()));
                    } else {
                        try (CloseableIterator recordsIterator = batch.streamingIterator(this.decompressionBufferSupplier());){
                            ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)recordsIterator).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
                                Cleaner.$anonfun$buildOffsetMapForSegment$1(startOffset, map, maxDesiredMapSize, object, stats, record);
                                return BoxedUnit.UNIT;
                            });
                        }
                    }
                    if (batch.lastOffset() < startOffset) continue;
                    map.updateLatestOffset(batch.lastOffset());
                }
                int bytesRead = records.validBytes();
                stats.indexBytesRead(bytesRead);
                if ((position += bytesRead) != startPosition) continue;
                this.growBuffersOrFail(source, position, maxLogMessageSize, records);
            }
            map.updateLatestOffset(upperBoundOffset - 1L);
            this.restoreBuffers();
            return false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public boolean validateLog(AbstractLog log, long start, long end, ExtendedOffsetMap baseOffsetMap, CleanerStats stats) {
        this.offsetMap().clear();
        ExtendedOffsetMap diffOffsetMap = new ExtendedOffsetMap(this.offsetMap());
        Iterable<LogSegmentReadAdapter> segments = this.logSegments(log, start, end);
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        List<AbortedTxn> abortedTransactions = this.collectAbortedTransactions(log, start, end);
        transactionMetadata.addAbortedTransactions(abortedTransactions);
        LongRef totalValidatedCount = LongRef.create((long)0L);
        segments.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            Cleaner.$anonfun$validateLog$1(this, totalValidatedCount, log, baseOffsetMap, diffOffsetMap, start, transactionMetadata, stats, segment);
            return BoxedUnit.UNIT;
        });
        if (totalValidatedCount.elem != (long)(baseOffsetMap.size() - baseOffsetMap.tombstoneCount()) || diffOffsetMap.size() != diffOffsetMap.tombstoneCount()) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(215).append(log.topicPartition()).append(": log validation failed. Log data in offset range [").append(start).append(", ").append(end).append(") is inconsistent with baseOffsetMap.").append("baseOffsetMap.size: ").append(baseOffsetMap.size()).append(", baseOffsetMap.tombstoneCount=").append(baseOffsetMap.tombstoneCount()).append(". ").append("diffOffsetMap.size=").append(diffOffsetMap.size()).append(", diffOffsetMap.tombstoneCount=").append(diffOffsetMap.tombstoneCount()).append(". ").append("found record count: ").append(totalValidatedCount$1.elem).toString());
            return false;
        }
        return true;
    }

    private long validateLogSegment(TopicPartition topicPartition, LogSegmentReadAdapter source, ExtendedOffsetMap baseMap, ExtendedOffsetMap diffMap, long startOffset, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, CleanerStats stats) {
        IntRef validatedRecordCount = IntRef.create((int)0);
        int position = source.startPosition();
        while (position < source.endPosition()) {
            this.checkDone.apply((Object)topicPartition);
            this.readBuffer().clear();
            source.readBytes(this.readBuffer(), position);
            MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.readBuffer());
            this.throttler.maybeThrottle(records.sizeInBytes());
            int startPosition = position;
            ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                Cleaner.$anonfun$validateLogSegment$1(this, transactionMetadata, stats, startOffset, baseMap, diffMap, validatedRecordCount, batch);
                return BoxedUnit.UNIT;
            });
            int bytesRead = records.validBytes();
            stats.indexBytesRead(bytesRead);
            if ((position += bytesRead) != startPosition) continue;
            this.growBuffersOrFail(source, position, maxLogMessageSize, records);
        }
        this.restoreBuffers();
        return validatedRecordCount.elem;
    }

    public Iterable<LogSegmentReadAdapter> logSegments(AbstractLog log, long from, long to) {
        return (Iterable)((TraversableLike)log.localLogSegments(from, to).map((Function1 & Serializable & scala.Serializable)x$20 -> new LocalLogSegmentReadAdapter(log, (LogSegment)x$20), Iterable$.MODULE$.canBuildFrom())).dropWhile((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)Cleaner.$anonfun$logSegments$2(from, x)));
    }

    public List<AbortedTxn> collectAbortedTransactions(AbstractLog log, long start, long end) {
        return log.collectAbortedTransactions(start, end);
    }

    private static final boolean shouldRetainDeletes$1(boolean legacyRecord$1, long deleteRetentionMs$2, RecordBatch batch$2, long currentTime$3, boolean retainDeletesForLegacyRecords$1) {
        if (!legacyRecord$1) {
            if (deleteRetentionMs$2 != 0L) {
                return !batch$2.deleteHorizonMs().isPresent() || currentTime$3 < batch$2.deleteHorizonMs().getAsLong();
            }
            return false;
        }
        return retainDeletesForLegacyRecords$1;
    }

    public static final /* synthetic */ boolean $anonfun$buildOffsetMap$4(BooleanRef full$1, Tuple2 x$18) {
        if (x$18 == null) {
            throw new MatchError(null);
        }
        boolean bl = !full$1.elem;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMap$5(Cleaner $this, AbstractLog log$4, IntRef mappedSegmentCount$1, Buffer dirty$1, BooleanRef full$1, OffsetMap map$2, long start$1, CleanedTransactionMetadata transactionMetadata$3, CleanerStats stats$4, Tuple2 x$19) {
        if (x$19 != null) {
            LogSegmentReadAdapter segment = (LogSegmentReadAdapter)x$19._1();
            long nextSegmentStartOffset = x$19._2$mcJ$sp();
            $this.checkDone.apply((Object)log$4.topicPartition());
            if (segment.endOffset() < log$4.logStartOffset() && segment.baseOffset() < log$4.logStartOffset()) {
                $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(111).append("End offset of segment: ").append(segment).append(" is smaller than log start offset ").append(log$4.logStartOffset()).append(". Abort current cleaning operation and will be retried").toString());
                throw new LogCleaningAbortedException();
            }
            ++mappedSegmentCount$1.elem;
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Building offset map for segment ").append(mappedSegmentCount$1.elem).append("/").append(dirty$1.size()).append(": ").append(segment).toString());
            full$1.elem = $this.buildOffsetMapForSegment(log$4.topicPartition(), segment, map$2, start$1, nextSegmentStartOffset, Predef$.MODULE$.Integer2int(log$4.config().maxMessageSize()), transactionMetadata$3, stats$4);
            if (full$1.elem) {
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Offset map is full, %d segments fully mapped, segment with base offset %d is partially mapped")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(mappedSegmentCount$1.elem - 1)), BoxesRunTime.boxToLong((long)segment.baseOffset())})));
                return;
            }
        } else {
            throw new MatchError(null);
        }
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMapForSegment$1(long startOffset$1, OffsetMap map$3, int maxDesiredMapSize$1, Object nonLocalReturnKey2$1, CleanerStats stats$5, Record record) {
        if (record.hasKey() && record.offset() >= startOffset$1) {
            if (map$3.size() < maxDesiredMapSize$1) {
                map$3.put(record.key(), record.offset(), !record.hasValue());
            } else {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey2$1, true);
            }
        }
        stats$5.indexMessagesRead(1);
    }

    public static final /* synthetic */ void $anonfun$validateLog$1(Cleaner $this, LongRef totalValidatedCount$1, AbstractLog log$5, ExtendedOffsetMap baseOffsetMap$1, ExtendedOffsetMap diffOffsetMap$1, long start$2, CleanedTransactionMetadata transactionMetadata$4, CleanerStats stats$6, LogSegmentReadAdapter segment) {
        totalValidatedCount$1.elem += $this.validateLogSegment(log$5.topicPartition(), segment, baseOffsetMap$1, diffOffsetMap$1, start$2, 0, transactionMetadata$4, stats$6);
    }

    public static final /* synthetic */ void $anonfun$validateLogSegment$2(long startOffset$2, ExtendedOffsetMap baseMap$1, ExtendedOffsetMap diffMap$1, IntRef validatedRecordCount$1, CleanerStats stats$7, Record record) {
        if (record.hasKey() && record.offset() >= startOffset$2) {
            long off = baseMap$1.get(record.key());
            if (off == -1L) {
                diffMap$1.put(record.key(), record.offset(), !record.hasValue());
            } else if (record.offset() >= off) {
                if (record.offset() == off) {
                    if (record.hasValue()) {
                        ++validatedRecordCount$1.elem;
                    }
                } else {
                    diffMap$1.put(record.key(), record.offset(), !record.hasValue());
                }
            }
        }
        stats$7.indexMessagesRead(1);
    }

    public static final /* synthetic */ void $anonfun$validateLogSegment$1(Cleaner $this, CleanedTransactionMetadata transactionMetadata$5, CleanerStats stats$7, long startOffset$2, ExtendedOffsetMap baseMap$1, ExtendedOffsetMap diffMap$1, IntRef validatedRecordCount$1, MutableRecordBatch batch) {
        if (batch.isControlBatch()) {
            transactionMetadata$5.onControlBatchRead((RecordBatch)batch);
            stats$7.indexMessagesRead(1);
            return;
        }
        if (transactionMetadata$5.onBatchRead((RecordBatch)batch)) {
            stats$7.indexMessagesRead(Predef$.MODULE$.Integer2int(batch.countOrNull()));
            return;
        }
        try (CloseableIterator recordsIterator = batch.streamingIterator($this.decompressionBufferSupplier());){
            ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)recordsIterator).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
                Cleaner.$anonfun$validateLogSegment$2(startOffset$2, baseMap$1, diffMap$1, validatedRecordCount$1, stats$7, record);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$logSegments$2(long from$1, LocalLogSegmentReadAdapter x) {
        return x.endOffset() < from$1;
    }

    public Cleaner(int id, OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, Time time, Function1<TopicPartition, BoxedUnit> checkDone, LogCleanerMetrics cleanerMetrics) {
        this.id = id;
        this.offsetMap = offsetMap;
        this.ioBufferSize = ioBufferSize;
        this.maxIoBufferSize = maxIoBufferSize;
        this.dupBufferLoadFactor = dupBufferLoadFactor;
        this.throttler = throttler;
        this.time = time;
        this.checkDone = checkDone;
        this.cleanerMetrics = cleanerMetrics;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(10).append("Cleaner ").append(id).append(": ").toString());
        this.readBuffer = ByteBuffer.allocate(ioBufferSize);
        this.writeBuffer = ByteBuffer.allocate(ioBufferSize);
        this.decompressionBufferSupplier = BufferSupplier.create();
        Predef$.MODULE$.require((double)offsetMap.slots() * dupBufferLoadFactor > 1.0, (Function0 & Serializable & scala.Serializable)() -> "offset map is too small to fit in even a single message, so log cleaning will never make progress. You can increase log.cleaner.dedupe.buffer.size or decrease log.cleaner.threads");
    }
}

