/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.materialization;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import kafka.durability.Utils$;
import kafka.durability.audit.AuditReporter;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.PartitionState;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.DeletePartitionEvent;
import kafka.durability.events.DeleteRecordsEvent;
import kafka.durability.events.Deserializer$;
import kafka.durability.events.EpochChangeEvent;
import kafka.durability.events.HealthCheckEvent;
import kafka.durability.events.InjectStateEvent;
import kafka.durability.events.IsrExpandEvent;
import kafka.durability.events.OffsetChangeEvent;
import kafka.durability.events.RetentionChangeEvent;
import kafka.durability.events.RetentionType$;
import kafka.durability.events.StartOffsetChangeEvent;
import kafka.durability.events.StartOffsetChangeEvent$;
import kafka.durability.materialization.Validator;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import scala.Enumeration;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t-d\u0001B\u0012%\u0001-B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\u007f\u0001\u0011)\u0019!C\u0001\u0001\"Aa\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003I\u0011!q\u0005A!A!\u0002\u0013y\u0005\"B.\u0001\t\u0003a\u0006\u0002C2\u0001\u0005\u0004%\t\u0001\n3\t\r!\u0004\u0001\u0015!\u0003f\u0011\u0015I\u0007\u0001\"\u0001k\u0011\u0019q\b\u0001\"\u0001%\u007f\"A\u0011q\u0003\u0001\u0005\u0002\u0011\nI\u0002\u0003\u0005\u0002H\u0001!\t\u0001JA%\u0011)\ti\u0006AI\u0001\n\u0003!\u0013q\f\u0005\u000b\u0003k\u0002\u0011\u0013!C\u0001I\u0005]\u0004\u0002CA>\u0001\u0011\u0005A%! \t\u0015\u0005E\u0006!%A\u0005\u0002\u0011\ny\u0006\u0003\u0006\u00024\u0002\t\n\u0011\"\u0001%\u0003oBq!!.\u0001\t\u0013\t9\fC\u0005\u0002T\u0002\t\n\u0011\"\u0003\u0002V\"A\u0011\u0011\u001c\u0001\u0005\u0002\u0011\nY\u000e\u0003\u0006\u0002h\u0002\t\n\u0011\"\u0001%\u0003?B!\"!;\u0001#\u0003%\t\u0001JA<\u0011!\tY\u000f\u0001C\u0001I\u00055\bBCA\u007f\u0001E\u0005I\u0011\u0001\u0013\u0002`!A\u0011q \u0001\u0005\u0002\u0011\u0012\t\u0001\u0003\u0006\u0003\u0012\u0001\t\n\u0011\"\u0001%\u0003?B\u0001Ba\u0005\u0001\t\u0003!#Q\u0003\u0005\t\u0005G\u0001A\u0011\u0001\u0013\u0003&!A!q\u0006\u0001\u0005\u0002\u0011\u0012\t\u0004\u0003\u0005\u0003>\u0001!\t\u0001\nB \u0011\u001d\u0011I\u0005\u0001C\u0001\u0005\u0017BqAa\u0016\u0001\t\u0003\u0011I\u0006C\u0004\u0003`\u0001!\tA!\u0019\t\u0013\t%\u0004!%A\u0005\u0002\u0005}#a\u0007#ve\u0006\u0014\u0017\u000e\\5us\u00163XM\u001c;t\u001b\u0006$XM]5bY&TXM\u0003\u0002&M\u0005yQ.\u0019;fe&\fG.\u001b>bi&|gN\u0003\u0002(Q\u0005QA-\u001e:bE&d\u0017\u000e^=\u000b\u0003%\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001YI\u0002\"!\f\u0019\u000e\u00039R\u0011aL\u0001\u0006g\u000e\fG.Y\u0005\u0003c9\u0012a!\u00118z%\u00164\u0007CA\u001a7\u001b\u0005!$BA\u001b)\u0003\u0015)H/\u001b7t\u0013\t9DGA\u0004M_\u001e<\u0017N\\4\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB\u0011!(P\u0007\u0002w)\u0011A\bK\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005yZ$A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0003I\n,\u0012!\u0011\t\u0003\u0005\u0012k\u0011a\u0011\u0006\u0003\u007f\u0019J!!R\"\u0003\u0019\u0011+(/\u00192jY&$\u0018\u0010\u0012\"\u0002\u0007\u0011\u0014\u0007%\u0001\u0005sKB|'\u000f^3s!\tIE*D\u0001K\u0015\tYe%A\u0003bk\u0012LG/\u0003\u0002N\u0015\ni\u0011)\u001e3jiJ+\u0007o\u001c:uKJ\fA\u0001^5nKB\u0011\u0001+W\u0007\u0002#*\u0011QG\u0015\u0006\u0003'R\u000baaY8n[>t'BA\u0015V\u0015\t1v+\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00021\u0006\u0019qN]4\n\u0005i\u000b&\u0001\u0002+j[\u0016\fa\u0001P5oSRtD#B/`A\u0006\u0014\u0007C\u00010\u0001\u001b\u0005!\u0003\"\u0002\u001d\u0007\u0001\u0004I\u0004\"B \u0007\u0001\u0004\t\u0005\"B$\u0007\u0001\u0004A\u0005\"\u0002(\u0007\u0001\u0004y\u0015!\u0003<bY&$\u0017\r^8s+\u0005)\u0007C\u00010g\u0013\t9GEA\u0005WC2LG-\u0019;pe\u0006Qa/\u00197jI\u0006$xN\u001d\u0011\u0002\u00175\fG/\u001a:jC2L'0\u001a\u000b\u0003W:\u0004\"!\f7\n\u00055t#a\u0002\"p_2,\u0017M\u001c\u0005\u0006_&\u0001\r\u0001]\u0001\u0007e\u0016\u001cwN\u001d3\u0011\tE4\b\u0010_\u0007\u0002e*\u00111\u000f^\u0001\tG>t7/^7fe*\u0011Q\u000fV\u0001\bG2LWM\u001c;t\u0013\t9(O\u0001\bD_:\u001cX/\\3s%\u0016\u001cwN\u001d3\u0011\u00075J80\u0003\u0002{]\t)\u0011I\u001d:bsB\u0011Q\u0006`\u0005\u0003{:\u0012AAQ=uK\u0006AR.\u0019;fe&\fG.\u001b>f\u0013:TWm\u0019;fIN#\u0018\r^3\u0015\t\u0005\u0005\u0011q\u0001\t\u0004[\u0005\r\u0011bAA\u0003]\t!QK\\5u\u0011\u001d\tIA\u0003a\u0001\u0003\u0017\tQ!\u001a<f]R\u0004B!!\u0004\u0002\u00145\u0011\u0011q\u0002\u0006\u0004\u0003#1\u0013AB3wK:$8/\u0003\u0003\u0002\u0016\u0005=!\u0001E%oU\u0016\u001cGo\u0015;bi\u0016,e/\u001a8u\u0003qi\u0017\r^3sS\u0006d\u0017N_3PM\u001a\u001cX\r^\"iC:<W-\u0012<f]R$\u0002\"!\u0001\u0002\u001c\u0005\r\u0012Q\u0006\u0005\b\u0003\u0013Y\u0001\u0019AA\u000f!\u0011\ti!a\b\n\t\u0005\u0005\u0012q\u0002\u0002\u0012\u001f\u001a47/\u001a;DQ\u0006tw-Z#wK:$\bbBA\u0013\u0017\u0001\u0007\u0011qE\u0001\u0006gR\fG/\u001a\t\u0004\u0005\u0006%\u0012bAA\u0016\u0007\nq\u0001+\u0019:uSRLwN\\*uCR,\u0007bBA\u0018\u0017\u0001\u0007\u0011\u0011G\u0001\t[\u0016$\u0018\rZ1uCB!\u00111GA!\u001d\u0011\t)$!\u0010\u0011\u0007\u0005]b&\u0004\u0002\u0002:)\u0019\u00111\b\u0016\u0002\rq\u0012xn\u001c;?\u0013\r\tyDL\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0013Q\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005}b&\u0001\u000fnCR,'/[1mSj,G)\u001a7fi\u0016\u0014VmY8sI\u00163XM\u001c;\u0015\u0015\u0005\u0005\u00111JA+\u0003/\nI\u0006C\u0004\u0002N1\u0001\r!a\u0014\u0002%\u0011,G.\u001a;f%\u0016\u001cwN\u001d3t\u000bZ,g\u000e\u001e\t\u0005\u0003\u001b\t\t&\u0003\u0003\u0002T\u0005=!A\u0005#fY\u0016$XMU3d_J$7/\u0012<f]RDq!!\n\r\u0001\u0004\t9\u0003C\u0005\u000201\u0001\n\u00111\u0001\u00022!A\u00111\f\u0007\u0011\u0002\u0003\u00071.A\u000eva\u0012\fG/Z(oYf\u001cu.\\7jiN#\u0018M\u001d;PM\u001a\u001cX\r^\u0001'[\u0006$XM]5bY&TX\rR3mKR,'+Z2pe\u0012,e/\u001a8uI\u0011,g-Y;mi\u0012\u001aTCAA1U\u0011\t\t$a\u0019,\u0005\u0005\u0015\u0004\u0003BA4\u0003cj!!!\u001b\u000b\t\u0005-\u0014QN\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u001c/\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003g\nIGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fa%\\1uKJL\u0017\r\\5{K\u0012+G.\u001a;f%\u0016\u001cwN\u001d3Fm\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\tIHK\u0002l\u0003G\nq$\\1uKJL\u0017\r\\5{K\"Kw\r[,bi\u0016\u0014X.\u0019:l\u0007\"\fgnZ3t)A\t\t!a \u0002\f\u0006U\u0015qTAU\u0003W\u000bi\u000bC\u0004\u0002\u0002>\u0001\r!a!\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B!\u0011QQAD\u001b\u0005\u0011\u0016bAAE%\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBAG\u001f\u0001\u0007\u0011qR\u0001\u0006KB|7\r\u001b\t\u0004[\u0005E\u0015bAAJ]\t\u0019\u0011J\u001c;\t\u000f\u0005]u\u00021\u0001\u0002\u001a\u0006\u0019\u0001n^7\u0011\u00075\nY*C\u0002\u0002\u001e:\u0012A\u0001T8oO\"9\u0011\u0011U\bA\u0002\u0005\r\u0016aA5teB1\u00111GAS\u0003\u001fKA!a*\u0002F\t\u00191+\u001a;\t\u000f\u0005\u0015r\u00021\u0001\u0002(!I\u0011qF\b\u0011\u0002\u0003\u0007\u0011\u0011\u0007\u0005\t\u0003_{\u0001\u0013!a\u0001W\u00061BO]5hO\u0016\u0014X\r\u001a\"z\u000bB|7\r[\"iC:<W-A\u0015nCR,'/[1mSj,\u0007*[4i/\u0006$XM]7be.\u001c\u0005.\u00198hKN$C-\u001a4bk2$HEN\u0001*[\u0006$XM]5bY&TX\rS5hQ^\u000bG/\u001a:nCJ\\7\t[1oO\u0016\u001cH\u0005Z3gCVdG\u000fJ\u001c\u0002C5\f7.Z$f]\u0016\u0014\u0018nY*uCJ$xJ\u001a4tKR\u001c\u0005.\u00198hK\u00163XM\u001c;\u0015\u0019\u0005e\u0016qXAe\u0003\u0017\fy-!5\u0011\t\u00055\u00111X\u0005\u0005\u0003{\u000byA\u0001\fTi\u0006\u0014Ho\u00144gg\u0016$8\t[1oO\u0016,e/\u001a8u\u0011\u001d\t\tM\u0005a\u0001\u0003\u0007\f!!\u001b3\u0011\t\u0005\u0015\u0015QY\u0005\u0004\u0003\u000f\u0014&\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0011\u001d\tiI\u0005a\u0001\u0003\u001fCq!!4\u0013\u0001\u0004\tI*A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\bbBAL%\u0001\u0007\u0011\u0011\u0014\u0005\n\u0003C\u0013\u0002\u0013!a\u0001\u0003G\u000b1&\\1lK\u001e+g.\u001a:jGN#\u0018M\u001d;PM\u001a\u001cX\r^\"iC:<W-\u0012<f]R$C-\u001a4bk2$H%N\u000b\u0003\u0003/TC!a)\u0002d\u00051R.\u0019;fe&\fG.\u001b>f'R\f'\u000f^(gMN,G\u000f\u0006\u0006\u0002\u0002\u0005u\u0017q\\Aq\u0003GDq!!\u0003\u0015\u0001\u0004\tI\fC\u0004\u0002&Q\u0001\r!a\n\t\u0013\u0005=B\u0003%AA\u0002\u0005E\u0002\u0002CAs)A\u0005\t\u0019A6\u0002\u0017Y\fG.\u001b3bi\u0016Du+T\u0001![\u0006$XM]5bY&TXm\u0015;beR|eMZ:fi\u0012\"WMZ1vYR$3'\u0001\u0011nCR,'/[1mSj,7\u000b^1si>3gm]3uI\u0011,g-Y;mi\u0012\"\u0014aG7bi\u0016\u0014\u0018.\u00197ju\u0016,\u0005o\\2i\u0007\"\fgnZ3Fm\u0016tG\u000f\u0006\u0005\u0002\u0002\u0005=\u0018\u0011`A~\u0011\u001d\t\tp\u0006a\u0001\u0003g\f\u0001#\u001a9pG\"\u001c\u0005.\u00198hK\u00163XM\u001c;\u0011\t\u00055\u0011Q_\u0005\u0005\u0003o\fyA\u0001\tFa>\u001c\u0007n\u00115b]\u001e,WI^3oi\"9\u0011QE\fA\u0002\u0005\u001d\u0002\"CA\u0018/A\u0005\t\u0019AA\u0019\u0003\u0015j\u0017\r^3sS\u0006d\u0017N_3Fa>\u001c\u0007n\u00115b]\u001e,WI^3oi\u0012\"WMZ1vYR$3'A\rnCR,'/[1mSj,\u0017j\u0015*FqB\fg\u000eZ#wK:$H\u0003CA\u0001\u0005\u0007\u0011iAa\u0004\t\u000f\t\u0015\u0011\u00041\u0001\u0003\b\u0005q\u0011n\u001d:FqB\fg\u000eZ#wK:$\b\u0003BA\u0007\u0005\u0013IAAa\u0003\u0002\u0010\tq\u0011j\u001d:FqB\fg\u000eZ#wK:$\bbBA\u00133\u0001\u0007\u0011q\u0005\u0005\n\u0003_I\u0002\u0013!a\u0001\u0003c\t1%\\1uKJL\u0017\r\\5{K&\u001b&+\u0012=qC:$WI^3oi\u0012\"WMZ1vYR$3'A\u0010nCR,'/[1mSj,'+\u001a;f]RLwN\\\"iC:<W-\u0012<f]R$b!!\u0001\u0003\u0018\t\u0005\u0002b\u0002B\r7\u0001\u0007!1D\u0001\u0015e\u0016$XM\u001c;j_:\u001c\u0005.\u00198hK\u00163XM\u001c;\u0011\t\u00055!QD\u0005\u0005\u0005?\tyA\u0001\u000bSKR,g\u000e^5p]\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\u0005\b\u0003KY\u0002\u0019AA\u0014\u0003ii\u0017\r^3sS\u0006d\u0017N_3EK2,G/\u001a)beRLG/[8o)\u0011\t\tAa\n\t\u000f\u0005%A\u00041\u0001\u0003*A!\u0011Q\u0002B\u0016\u0013\u0011\u0011i#a\u0004\u0003)\u0011+G.\u001a;f!\u0006\u0014H/\u001b;j_:,e/\u001a8u\u0003Yi\u0017\r^3sS\u0006d\u0017N_3IK\u0006dG\u000f[\"iK\u000e\\G\u0003BA\u0001\u0005gAqA!\u000e\u001e\u0001\u0004\u00119$\u0001\tiK\u0006dG\u000f[\"iK\u000e\\WI^3oiB!\u0011Q\u0002B\u001d\u0013\u0011\u0011Y$a\u0004\u0003!!+\u0017\r\u001c;i\u0007\",7m[#wK:$\u0018\u0001E7bi\u0016\u0014\u0018.\u00197ju\u0016\u001cF/\u0019;f)!\t\tA!\u0011\u0003D\t\u0015\u0003bBA\u0013=\u0001\u0007\u0011q\u0005\u0005\b\u0003\u001bs\u0002\u0019AAH\u0011\u001d\u00119E\ba\u0001\u0003\u0007\f\u0001\u0003^8qS\u000eLE\rU1si&$\u0018n\u001c8\u0002%M$\u0018\r\\3U_BL7-\u00133Fm\u0016tGo\u001d\u000b\u0006W\n5#Q\u000b\u0005\b\u0003\u0013y\u0002\u0019\u0001B(!\u0011\tiA!\u0015\n\t\tM\u0013q\u0002\u0002\u0018\u0003\n\u001cHO]1di\u0012+(/\u00192jY&$\u00180\u0012<f]RDq!!\n \u0001\u0004\t9#A\rdQ\u0016\u001c7.T5tg&tw\rV8qS\u000e$U\r\\3uS>tGCBA\u0001\u00057\u0012i\u0006C\u0004\u0002\n\u0001\u0002\rAa\u0014\t\u000f\u0005\u0015\u0002\u00051\u0001\u0002(\u0005\t\u0002.\u00198eY\u0016\u001cF/\u00197f\u000bZ,g\u000e^:\u0015\u000f-\u0014\u0019G!\u001a\u0003h!9\u0011\u0011B\u0011A\u0002\t=\u0003bBA\u0013C\u0001\u0007\u0011q\u0005\u0005\n\u0003_\t\u0003\u0013!a\u0001\u0003c\t1\u0004[1oI2,7\u000b^1mK\u00163XM\u001c;tI\u0011,g-Y;mi\u0012\u001a\u0004")
public class DurabilityEventsMaterialize
implements Logging {
    private final ReplicaManager replicaManager;
    private final DurabilityDB db;
    private final AuditReporter reporter;
    private final Validator validator;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public DurabilityDB db() {
        return this.db;
    }

    public Validator validator() {
        return this.validator;
    }

    public synchronized boolean materialize(ConsumerRecord<byte[], byte[]> record) {
        AbstractDurabilityEvent event = Deserializer$.MODULE$.deserialize((byte[])((byte[])record.key()).clone(), (byte[])((byte[])record.value()).clone());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        if (event instanceof HealthCheckEvent) {
            HealthCheckEvent healthCheckEvent = (HealthCheckEvent)event;
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("DurabilityMaterialization: Materialization request for ").append(event.eventType()).append(" ").append(event).toString());
            if (healthCheckEvent.brokerId() == Utils$.MODULE$.getBrokerId(this.replicaManager)) {
                this.materializeHealthCheck(healthCheckEvent);
            }
            return true;
        }
        if (event instanceof InjectStateEvent) {
            InjectStateEvent injectStateEvent = (InjectStateEvent)event;
            this.materializeInjectedState(injectStateEvent);
            return true;
        }
        Option<PartitionState> stateOpt = this.db().fetchPartitionState(event.topicIdPartition().topicPartition());
        if (stateOpt.isEmpty()) {
            return false;
        }
        PartitionState state = (PartitionState)stateOpt.get();
        if (event.epoch() == state.latestEpoch() && record.timestamp() < state.latestTimestamp()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(104).append("Ignoring event ").append(event).append(" with epoch ").append(event.epoch()).append(" as it's from retry and duplicate.").append("Current epoch is ").append(state.latestEpoch()).append(" and state ts: record ts: ").append(record.timestamp()).toString());
            return false;
        }
        this.checkMissingTopicDeletion(event, state);
        if (event.epoch() < state.latestEpoch() || this.staleTopicIdEvents(event, state)) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Ignoring event ").append(event).append(". Current state is ").append(state).toString());
            return this.handleStaleEvents(event, state, metadata);
        }
        state.latestTimestamp_$eq(record.timestamp());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("DurabilityMaterialization: Materialization request for ").append(event.eventType()).append(" ").append(event).append(" for state: ").append(state).toString());
        if (event instanceof OffsetChangeEvent) {
            OffsetChangeEvent offsetChangeEvent = (OffsetChangeEvent)event;
            this.materializeOffsetChangeEvent(offsetChangeEvent, state, metadata);
        } else if (event instanceof DeleteRecordsEvent) {
            DeleteRecordsEvent deleteRecordsEvent = (DeleteRecordsEvent)event;
            this.materializeDeleteRecordEvent(deleteRecordsEvent, state, metadata, false);
        } else if (event instanceof EpochChangeEvent) {
            EpochChangeEvent epochChangeEvent = (EpochChangeEvent)event;
            this.materializeEpochChangeEvent(epochChangeEvent, state, metadata);
        } else if (event instanceof IsrExpandEvent) {
            IsrExpandEvent isrExpandEvent = (IsrExpandEvent)event;
            this.materializeISRExpandEvent(isrExpandEvent, state, metadata);
        } else if (event instanceof RetentionChangeEvent) {
            RetentionChangeEvent retentionChangeEvent = (RetentionChangeEvent)event;
            this.materializeRetentionChangeEvent(retentionChangeEvent, state);
        } else if (event instanceof StartOffsetChangeEvent) {
            StartOffsetChangeEvent startOffsetChangeEvent = (StartOffsetChangeEvent)event;
            this.materializeStartOffset(startOffsetChangeEvent, state, metadata, true);
        } else {
            if (event instanceof DeletePartitionEvent) {
                DeletePartitionEvent deletePartitionEvent = (DeletePartitionEvent)event;
                this.materializeDeletePartition(deletePartitionEvent);
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("DurabilityMaterialization: Materialization done for ").append(event).append(" ").append(state).append(" ").append(metadata).toString());
                return true;
            }
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(81).append("DurabilityMaterialization: Ignoring unexpected durability event type ").append(event).append(".eventType ").append(event).append(" ").append(metadata).toString());
            return false;
        }
        this.materializeState(state, event.epoch(), event.topicIdPartition());
        this.db().addPartition(event.topicIdPartition().topicPartition(), state);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("DurabilityMaterialization: Materialization done for ").append(event).append(" ").append(state).toString());
        return true;
    }

    public void materializeInjectedState(InjectStateEvent event) {
        Option<PartitionState> stateOpt = this.db().fetchPartitionState(event.topicIdPartition().topicPartition());
        if (stateOpt.isEmpty()) {
            return;
        }
        PartitionState state = (PartitionState)stateOpt.get();
        if (event.removePartition()) {
            this.db().deletePartition(event.topicIdPartition().topicPartition());
        } else {
            if (event.epoch() != -1) {
                state.latestEpoch_$eq(event.epoch());
            }
            if (event.highWatermark() != -1L) {
                state.highWatermark_$eq(event.highWatermark());
            }
            if (event.logStartOffset() != -1L) {
                state.committedStartOffset_$eq(event.logStartOffset());
                state.startOffset_$eq(event.logStartOffset());
            }
            if (event.config() != -1L) {
                state.config_$eq(event.config());
            }
            this.db().addPartition(event.topicIdPartition().topicPartition(), state);
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Updated the durabilityDB due to injected Event ").append(event).append(" with new state ").append(state).toString());
    }

    public void materializeOffsetChangeEvent(OffsetChangeEvent event, PartitionState state, String metadata) {
        this.materializeHighWatermarkChanges(event.topicIdPartition().topicPartition(), event.epoch(), event.highWatermark(), event.isr(), state, metadata, this.materializeHighWatermarkChanges$default$7());
        this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(event.topicIdPartition(), event.epoch(), event.logStartOffset(), event.highWatermark(), event.isr()), state, metadata, this.materializeStartOffset$default$4());
    }

    public void materializeDeleteRecordEvent(DeleteRecordsEvent deleteRecordsEvent, PartitionState state, String metadata, boolean updateOnlyCommitStartOffset) {
        state.committedStartOffset_$eq(Math.max(state.committedStartOffset(), deleteRecordsEvent.trimOffset()));
        state.lapseWatchStartTime_$eq(0L);
        if (updateOnlyCommitStartOffset) {
            return;
        }
        this.materializeHighWatermarkChanges(deleteRecordsEvent.topicIdPartition().topicPartition(), deleteRecordsEvent.epoch(), deleteRecordsEvent.highWatermark(), deleteRecordsEvent.isr(), state, metadata, this.materializeHighWatermarkChanges$default$7());
        this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(deleteRecordsEvent.topicIdPartition(), deleteRecordsEvent.epoch(), deleteRecordsEvent.logStartOffset(), deleteRecordsEvent.highWatermark(), this.makeGenericStartOffsetChangeEvent$default$5()), state, metadata, this.materializeStartOffset$default$4());
    }

    public String materializeDeleteRecordEvent$default$3() {
        return "";
    }

    public boolean materializeDeleteRecordEvent$default$4() {
        return false;
    }

    public void materializeHighWatermarkChanges(TopicPartition topicPartition, int epoch, long hwm, Set<Object> isr, PartitionState state, String metadata, boolean triggeredByEpochChange) {
        this.validator().validateDBHighWatermark(topicPartition, epoch, hwm, state, metadata, triggeredByEpochChange);
        if (this.validator().isInSync(isr)) {
            this.validator().validateLocalLogEndOffset(topicPartition, epoch, hwm, state, metadata);
        }
        state.highWatermark_$eq(hwm);
    }

    public String materializeHighWatermarkChanges$default$6() {
        return "";
    }

    public boolean materializeHighWatermarkChanges$default$7() {
        return false;
    }

    private StartOffsetChangeEvent makeGenericStartOffsetChangeEvent(TopicIdPartition id, int epoch, long startOffset, long hwm, Set<Object> isr) {
        return StartOffsetChangeEvent$.MODULE$.apply(id, epoch, hwm, startOffset, (byte)RetentionType$.MODULE$.Other().id(), -1L, isr);
    }

    private Set<Object> makeGenericStartOffsetChangeEvent$default$5() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-1}));
    }

    public void materializeStartOffset(StartOffsetChangeEvent event, PartitionState state, String metadata, boolean validateHWM) {
        block12: {
            block11: {
                Enumeration.Value value;
                Enumeration.Value value2;
                block10: {
                    if (state.startOffset() <= 0L) {
                        state.committedStartOffset_$eq(event.logStartOffset());
                        state.lapseWatchStartTime_$eq(0L);
                    } else if (this.validator().isInSync(event.isr()) && state.committedStartOffset() < event.logStartOffset() && this.validator().validateDBLogStartOffset(event, state, metadata)) {
                        this.validator().validateLocalLogStartOffset(event.topicIdPartition().topicPartition(), event.logStartOffset(), metadata);
                        state.committedStartOffset_$eq(event.logStartOffset());
                        state.lapseWatchStartTime_$eq(0L);
                    }
                    if (validateHWM) {
                        this.materializeHighWatermarkChanges(event.topicIdPartition().topicPartition(), event.epoch(), event.highWatermark(), event.isr(), state, metadata, this.materializeHighWatermarkChanges$default$7());
                    }
                    state.startOffset_$eq(event.logStartOffset());
                    Enumeration.Value value3 = RetentionType$.MODULE$.apply(event.retentionType());
                    Enumeration.Value value4 = RetentionType$.MODULE$.SizeBasedRetention();
                    if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                        state.retentionSz_$eq(event.retentionValue());
                        return;
                    }
                    value2 = RetentionType$.MODULE$.apply(event.retentionType());
                    value = RetentionType$.MODULE$.TimeBasedRetention();
                    if (value2 != null) break block10;
                    if (value != null) {
                        return;
                    }
                    break block11;
                }
                if (!value2.equals(value)) break block12;
            }
            state.retentionMs_$eq(event.retentionValue());
        }
    }

    public String materializeStartOffset$default$3() {
        return "";
    }

    public boolean materializeStartOffset$default$4() {
        return false;
    }

    public void materializeEpochChangeEvent(EpochChangeEvent epochChangeEvent, PartitionState state, String metadata) {
        this.validator().validateDBEpochChange(epochChangeEvent, state, metadata);
        this.materializeHighWatermarkChanges(epochChangeEvent.topicIdPartition().topicPartition(), epochChangeEvent.epoch(), epochChangeEvent.highWatermark(), epochChangeEvent.isr(), state, metadata, true);
        this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(epochChangeEvent.topicIdPartition(), epochChangeEvent.epoch(), epochChangeEvent.logStartOffset(), epochChangeEvent.highWatermark(), epochChangeEvent.isr()), state, metadata, this.materializeStartOffset$default$4());
        this.validator().validateEpochChangeWithLocal(epochChangeEvent, metadata);
        state.epochChain().put((Object)BoxesRunTime.boxToInteger((int)epochChangeEvent.epoch()), (Object)BoxesRunTime.boxToLong((long)epochChangeEvent.firstOffset()));
    }

    public String materializeEpochChangeEvent$default$3() {
        return "";
    }

    public void materializeISRExpandEvent(IsrExpandEvent isrExpandEvent, PartitionState state, String metadata) {
        if (Utils$.MODULE$.getBrokerId(this.replicaManager) != isrExpandEvent.expandBrokerId()) {
            return;
        }
        this.validator().validateEpochChainWithLocal(isrExpandEvent.topicIdPartition().topicPartition(), state, metadata);
    }

    public String materializeISRExpandEvent$default$3() {
        return "";
    }

    public void materializeRetentionChangeEvent(RetentionChangeEvent retentionChangeEvent, PartitionState state) {
        if (retentionChangeEvent.timeMs() != state.retentionMs() || retentionChangeEvent.size() != state.retentionSz()) {
            state.committedStartOffset_$eq(Math.max(state.committedStartOffset(), state.startOffset()));
            state.lapseWatchStartTime_$eq(0L);
            state.retentionSz_$eq(retentionChangeEvent.size());
            state.retentionMs_$eq(retentionChangeEvent.timeMs());
        }
    }

    public void materializeDeletePartition(DeletePartitionEvent event) {
        this.db().deletePartition(event.topicIdPartition().topicPartition());
    }

    public void materializeHealthCheck(HealthCheckEvent healthCheckEvent) {
        this.reporter.updateHealthCheck(Integer.toString(healthCheckEvent.brokerId()), healthCheckEvent.timeStamp());
    }

    public void materializeState(PartitionState state, int epoch, TopicIdPartition topicIdPartition) {
        if (epoch != -1) {
            state.latestEpoch_$eq(epoch);
        }
        state.topicId_$eq(topicIdPartition.topicId());
    }

    public boolean staleTopicIdEvents(AbstractDurabilityEvent event, PartitionState state) {
        Uuid uuid = state.topicId();
        Uuid uuid2 = Uuid.ZERO_UUID;
        if (uuid == null ? uuid2 != null : !uuid.equals(uuid2)) {
            Uuid uuid3 = event.topicIdPartition().topicId();
            Uuid uuid4 = Uuid.ZERO_UUID;
            if (!(uuid3 != null ? !uuid3.equals(uuid4) : uuid4 != null)) {
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void checkMissingTopicDeletion(AbstractDurabilityEvent event, PartitionState state) {
        v0 = state.topicId();
        var5_3 = Uuid.ZERO_UUID;
        if (!(v0 == null ? var5_3 != null : v0.equals(var5_3) == false)) ** GOTO lbl-1000
        v1 = event.topicIdPartition().topicId();
        var6_4 = Uuid.ZERO_UUID;
        if (!(v1 == null ? var6_4 != null : v1.equals(var6_4) == false)) ** GOTO lbl-1000
        v2 = event.topicIdPartition().topicId();
        var7_5 = state.topicId();
        if (v2 == null ? var7_5 != null : v2.equals(var7_5) == false) {
            reset = true;
        } else lbl-1000:
        // 3 sources

        {
            var3_8 = event instanceof EpochChangeEvent != false ? (var8_7 = (EpochChangeEvent)event).epoch() == 0 && var8_7.firstOffset() == 0L && var8_7.highWatermark() <= 0L : false;
            reset = var3_8;
        }
        if (reset) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$checkMissingTopicDeletion$1(kafka.durability.events.AbstractDurabilityEvent kafka.durability.db.PartitionState ), ()Ljava/lang/String;)((AbstractDurabilityEvent)event, (PartitionState)state));
            state.reset();
            state.topicId_$eq(event.topicIdPartition().topicId());
        }
    }

    public boolean handleStaleEvents(AbstractDurabilityEvent event, PartitionState state, String metadata) {
        boolean bl;
        if (event instanceof DeleteRecordsEvent) {
            DeleteRecordsEvent deleteRecordsEvent = (DeleteRecordsEvent)event;
            this.materializeDeleteRecordEvent(deleteRecordsEvent, state, metadata, true);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public String handleStaleEvents$default$3() {
        return "";
    }

    public static final /* synthetic */ String $anonfun$checkMissingTopicDeletion$1(AbstractDurabilityEvent event$3, PartitionState state$3) {
        return new StringBuilder(44).append("Durability partition reset for ").append(event$3).append(" old topicID ").append(state$3.topicId()).toString();
    }

    public DurabilityEventsMaterialize(ReplicaManager replicaManager, DurabilityDB db, AuditReporter reporter, Time time) {
        this.replicaManager = replicaManager;
        this.db = db;
        this.reporter = reporter;
        Logging.$init$(this);
        this.validator = new Validator(replicaManager, reporter, time);
    }
}

