/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.quota;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import kafka.coordinator.quota.QuotaEntity;
import kafka.coordinator.quota.QuotaEntry;
import kafka.coordinator.quota.QuotaValue;
import kafka.coordinator.quota.QuotaValue$;
import kafka.internals.generated.ComputedQuotaKey;
import kafka.internals.generated.ComputedQuotaValue;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.record.Record;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;

public final class QuotaStateManager$ {
    public static QuotaStateManager$ MODULE$;
    private final String MetricsGroup;
    private final String LoadTimeSensor;

    static {
        new QuotaStateManager$();
    }

    public String MetricsGroup() {
        return this.MetricsGroup;
    }

    public String LoadTimeSensor() {
        return this.LoadTimeSensor;
    }

    public QuotaEntity readMessageKey(ByteBuffer buffer) {
        short version = buffer.getShort();
        if (version >= 0 && version <= 0) {
            ComputedQuotaKey key = new ComputedQuotaKey((Readable)new ByteBufferAccessor(buffer), version);
            return new QuotaEntity((Map<String, String>)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(key.quotaEntity()).asScala()).map((Function1 & Serializable & scala.Serializable)entityData -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entityData.entityType()), (Object)entityData.entityName()), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        }
        throw new IllegalStateException(new StringBuilder(31).append("Unknown quota message version: ").append(version).toString());
    }

    public Option<QuotaEntry> readMessageValue(QuotaEntity quotaEntity, ByteBuffer buffer) {
        if (buffer == null) {
            return None$.MODULE$;
        }
        short version = buffer.getShort();
        if (version >= 0 && version <= 0) {
            ComputedQuotaValue value = new ComputedQuotaValue((Readable)new ByteBufferAccessor(buffer), version);
            QuotaEntry quotaEntry = new QuotaEntry(quotaEntity, value.lastUpdatedTimestamp());
            ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(value.computedBrokerQuotas()).asScala()).foreach((Function1 & Serializable & scala.Serializable)computedBrokerQuota -> {
                QuotaStateManager$.$anonfun$readMessageValue$1(quotaEntry, computedBrokerQuota);
                return BoxedUnit.UNIT;
            });
            return new Some((Object)quotaEntry);
        }
        throw new IllegalStateException(new StringBuilder(31).append("Unknown quota message version: ").append(version).toString());
    }

    public byte[] quotaEntryKey(QuotaEntity quotaEntity) {
        return MessageUtil.toVersionPrefixedBytes((short)0, (Message)new ComputedQuotaKey().setQuotaEntity((List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)quotaEntity.entityTypes().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String entityName;
            String entityType;
            block3: {
                block2: {
                    if (x0$1 == null) break block2;
                    entityType = (String)x0$1._1();
                    entityName = (String)x0$1._2();
                    if (entityType != null && entityName != null) break block3;
                }
                throw new MatchError(x0$1);
            }
            ComputedQuotaKey.EntityData entityData = new ComputedQuotaKey.EntityData().setEntityType(entityType).setEntityName(entityName);
            return entityData;
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toList()).asJava()));
    }

    public byte[] quotaEntryValue(QuotaEntry quotaEntry) {
        return MessageUtil.toVersionPrefixedBytes((short)0, (Message)new ComputedQuotaValue().setComputedBrokerQuotas((List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)quotaEntry.computedQuotas().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int brokerId = x0$1._1$mcI$sp();
            scala.collection.mutable.Map computedQuotas = (scala.collection.mutable.Map)x0$1._2();
            ComputedQuotaValue.ComputedBrokerQuota computedBrokerQuota = new ComputedQuotaValue.ComputedBrokerQuota().setBrokerId(brokerId).setComputedQuotas((List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)computedQuotas.map((Function1 & Serializable & scala.Serializable)computedQuota -> new ComputedQuotaValue.ComputedQuota().setQuotaType((String)computedQuota._1()).setQuota(((QuotaValue)computedQuota._2()).quota()).setUsage(((QuotaValue)computedQuota._2()).usage()).setThrottled(((QuotaValue)computedQuota._2()).throttled()).setLastUsageReportTimestamp(((QuotaValue)computedQuota._2()).lastUsageReportTimestamp()), Iterable$.MODULE$.canBuildFrom())).toList()).asJava());
            return computedBrokerQuota;
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toList()).asJava()).setLastUpdatedTimestamp(quotaEntry.lastUpdatedTimestamp()));
    }

    public Tuple2<Option<String>, Option<String>> formatRecordKeyAndValue(Record record) {
        String string;
        QuotaEntity quotaEntity = this.readMessageKey(record.key());
        String keyString = new StringBuilder(26).append("quota_entity::entityTypes=").append(quotaEntity.entityTypes()).toString();
        Option<QuotaEntry> option = this.readMessageValue(quotaEntity, record.value());
        if (None$.MODULE$.equals(option)) {
            string = "<DELETE>";
        } else if (option instanceof Some) {
            QuotaEntry quotaEntry = (QuotaEntry)((Some)option).value();
            string = new StringBuilder(37).append("computedQuotas:").append(quotaEntry.computedQuotasString()).append(",").append("lastUpdatedTimestamp:").append(quotaEntry.lastUpdatedTimestamp()).toString();
        } else {
            throw new MatchError(option);
        }
        return new Tuple2((Object)new Some((Object)keyString), (Object)new Some((Object)string));
    }

    public static final /* synthetic */ void $anonfun$readMessageValue$1(QuotaEntry quotaEntry$1, ComputedQuotaValue.ComputedBrokerQuota computedBrokerQuota) {
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(computedBrokerQuota.computedQuotas()).asScala()).foreach((Function1 & Serializable & scala.Serializable)computedQuota -> {
            quotaEntry$1.putQuotaValue(computedBrokerQuota.brokerId(), computedQuota.quotaType(), QuotaValue$.MODULE$.loadValue(computedQuota.usage(), computedQuota.throttled(), computedQuota.quota(), computedQuota.lastUsageReportTimestamp()));
            return BoxedUnit.UNIT;
        });
    }

    private QuotaStateManager$() {
        MODULE$ = this;
        this.MetricsGroup = "quota-coordinator-metrics";
        this.LoadTimeSensor = "QuotaPartitionLoadTime";
    }
}

