/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.quota;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import kafka.coordinator.quota.QuotaConsumption;
import kafka.coordinator.quota.QuotaCoordinator$;
import kafka.coordinator.quota.QuotaCoordinatorConfig;
import kafka.coordinator.quota.QuotaDescription;
import kafka.coordinator.quota.QuotaEntity;
import kafka.coordinator.quota.QuotaEntityAndConsumptions;
import kafka.coordinator.quota.QuotaEntry;
import kafka.coordinator.quota.QuotaStateManager;
import kafka.coordinator.quota.QuotaValue;
import kafka.coordinator.quota.ReportQuotaResult;
import kafka.log.LogConfig$;
import kafka.message.ProducerCompressionCodec$;
import kafka.server.BrokerReconfigurable;
import kafka.server.InternalAdmin;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.apache.kafka.server.quota.ClusterLevelQuotaCallback;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t=t!B\u0014)\u0011\u0003yc!B\u0019)\u0011\u0003\u0011\u0004\"B\u001d\u0002\t\u0003Q\u0004bB\u001e\u0002\u0005\u0004%\t\u0001\u0010\u0005\u0007\u001d\u0006\u0001\u000b\u0011B\u001f\t\u000b=\u000bA\u0011\u0001)\t\u000f\t%\u0014\u0001\"\u0003\u0003l\u0019!\u0011\u0007\u000b\u0001S\u0011!yvA!b\u0001\n\u0003\u0001\u0007\u0002\u00033\b\u0005\u0003\u0005\u000b\u0011B1\t\u0011\u0015<!Q1A\u0005\u0002\u0019D\u0001B[\u0004\u0003\u0002\u0003\u0006Ia\u001a\u0005\tW\u001e\u0011)\u0019!C\u0001Y\"A\u0001o\u0002B\u0001B\u0003%Q\u000e\u0003\u0005r\u000f\t\u0015\r\u0011\"\u0001s\u0011!1xA!A!\u0002\u0013\u0019\b\u0002C<\b\u0005\u000b\u0007I\u0011\u0001=\t\u0013\u00055qA!A!\u0002\u0013I\bBCA\b\u000f\t\u0015\r\u0011\"\u0001\u0002\u0012!Q\u0011\u0011F\u0004\u0003\u0002\u0003\u0006I!a\u0005\t\u0015\u0005-rA!b\u0001\n\u0003\ti\u0003\u0003\u0006\u0002>\u001d\u0011\t\u0011)A\u0005\u0003_Aa!O\u0004\u0005\u0002\u0005}\u0002\"CA(\u000f\t\u0007I\u0011AA)\u0011!\t\u0019g\u0002Q\u0001\n\u0005M\u0003bBA3\u000f\u0011\u0005\u0011q\r\u0005\b\u0003s:A\u0011AA>\u0011\u001d\tii\u0002C\u0001\u0003\u001fCq!a0\b\t\u0003\t\t\rC\u0004\u0002f\u001e!\t!a:\t\u000f\u0005Ex\u0001\"\u0001\u0002t\"9\u0011q_\u0004\u0005\u0002\u0005e\bb\u0002B\u0002\u000f\u0011\u0005!Q\u0001\u0005\b\u0005\u001f9A\u0011\u0001B\t\u0011\u001d\u0011Ib\u0002C\u0001\u00057AqAa\n\b\t\u0003\u0011I\u0003\u0003\u0004\u0003,\u001d!\t\u0005\u0010\u0005\b\u0005[9A\u0011\tB\u0018\u0011\u001d\u0011Yd\u0002C\u0001\u0005{\t\u0001#U;pi\u0006\u001cun\u001c:eS:\fGo\u001c:\u000b\u0005%R\u0013!B9v_R\f'BA\u0016-\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u000b\u00035\nQa[1gW\u0006\u001c\u0001\u0001\u0005\u00021\u00035\t\u0001F\u0001\tRk>$\u0018mQ8pe\u0012Lg.\u0019;peN\u0011\u0011a\r\t\u0003i]j\u0011!\u000e\u0006\u0002m\u0005)1oY1mC&\u0011\u0001(\u000e\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005y\u0013!\u0006*fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm]\u000b\u0002{A\u0019a(Q\"\u000e\u0003}R!\u0001Q\u001b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002C\u007f\t\u00191+\u001a;\u0011\u0005\u0011[eBA#J!\t1U'D\u0001H\u0015\tAe&\u0001\u0004=e>|GOP\u0005\u0003\u0015V\na\u0001\u0015:fI\u00164\u0017B\u0001'N\u0005\u0019\u0019FO]5oO*\u0011!*N\u0001\u0017%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4tA\u0005)\u0011\r\u001d9msRy\u0011K!\u0012\u0003J\t-#Q\u000bB,\u00053\u00129\u0007\u0005\u00021\u000fM!qaM*Z!\t!v+D\u0001V\u0015\t1F&A\u0003vi&d7/\u0003\u0002Y+\n9Aj\\4hS:<\u0007C\u0001.^\u001b\u0005Y&B\u0001/-\u0003\u0019\u0019XM\u001d<fe&\u0011al\u0017\u0002\u0015\u0005J|7.\u001a:SK\u000e|gNZ5hkJ\f'\r\\3\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012!\u0019\t\u0003i\tL!aY\u001b\u0003\u0007%sG/A\u0005ce>\\WM]%eA\u0005Y\u0011/^8uC\u000e{gNZ5h+\u00059\u0007C\u0001\u0019i\u0013\tI\u0007F\u0001\fRk>$\u0018mQ8pe\u0012Lg.\u0019;pe\u000e{gNZ5h\u00031\tXo\u001c;b\u0007>tg-[4!\u0003E\tXo\u001c;b'R\fG/Z'b]\u0006<WM]\u000b\u0002[B\u0011\u0001G\\\u0005\u0003_\"\u0012\u0011#U;pi\u0006\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0003I\tXo\u001c;b'R\fG/Z'b]\u0006<WM\u001d\u0011\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014X#A:\u0011\u0005Q#\u0018BA;V\u0005%\u00196\r[3ek2,'/\u0001\u0006tG\",G-\u001e7fe\u0002\nQ#\u001b8uKJt\u0017\r\\!e[&t7+\u001e9qY&,'/F\u0001z!\u0015Q\u00181AA\u0004\u001b\u0005Y(B\u0001?~\u0003!1WO\\2uS>t'B\u0001@\u0000\u0003\u0011)H/\u001b7\u000b\u0005\u0005\u0005\u0011\u0001\u00026bm\u0006L1!!\u0002|\u0005!\u0019V\u000f\u001d9mS\u0016\u0014\bc\u0001.\u0002\n%\u0019\u00111B.\u0003\u001b%sG/\u001a:oC2\fE-\\5o\u0003YIg\u000e^3s]\u0006d\u0017\tZ7j]N+\b\u000f\u001d7jKJ\u0004\u0013!G2mkN$XM\u001d'fm\u0016d\u0017+^8uC\u000e\u000bG\u000e\u001c2bG.,\"!a\u0005\u0011\t\u0005U\u0011QE\u0007\u0003\u0003/Q1!KA\r\u0015\ra\u00161\u0004\u0006\u0004[\u0005u!\u0002BA\u0010\u0003C\ta!\u00199bG\",'BAA\u0012\u0003\ry'oZ\u0005\u0005\u0003O\t9BA\rDYV\u001cH/\u001a:MKZ,G.U;pi\u0006\u001c\u0015\r\u001c7cC\u000e\\\u0017AG2mkN$XM\u001d'fm\u0016d\u0017+^8uC\u000e\u000bG\u000e\u001c2bG.\u0004\u0013\u0001\u0002;j[\u0016,\"!a\f\u0011\t\u0005E\u0012\u0011H\u0007\u0003\u0003gQ1AVA\u001b\u0015\u0011\t9$a\u0007\u0002\r\r|W.\\8o\u0013\u0011\tY$a\r\u0003\tQKW.Z\u0001\u0006i&lW\r\t\u000b\u0010#\u0006\u0005\u00131IA#\u0003\u000f\nI%a\u0013\u0002N!)qL\u0006a\u0001C\")QM\u0006a\u0001O\")1N\u0006a\u0001[\")\u0011O\u0006a\u0001g\")qO\u0006a\u0001s\"9\u0011q\u0002\fA\u0002\u0005M\u0001bBA\u0016-\u0001\u0007\u0011qF\u0001\tSN\f5\r^5wKV\u0011\u00111\u000b\t\u0005\u0003+\ny&\u0004\u0002\u0002X)!\u0011\u0011LA.\u0003\u0019\tGo\\7jG*\u0019\u0011QL?\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002b\u0005]#!D!u_6L7MQ8pY\u0016\fg.A\u0005jg\u0006\u001bG/\u001b<fA\u0005I1/\u001a;BGRLg/\u001a\u000b\u0005\u0003S\ny\u0007E\u00025\u0003WJ1!!\u001c6\u0005\u0011)f.\u001b;\t\u000f\u0005E\u0014\u00041\u0001\u0002t\u00051\u0011m\u0019;jm\u0016\u00042\u0001NA;\u0013\r\t9(\u000e\u0002\b\u0005>|G.Z1o\u0003M9W\r\u001e\"s_.,'/U;pi\u0006d\u0015.\\5u)\u0011\ti(a!\u0011\u0007Q\ny(C\u0002\u0002\u0002V\u0012a\u0001R8vE2,\u0007bBAC5\u0001\u0007\u0011qQ\u0001\ncV|G/\u0019+za\u0016\u0004B!!\u0006\u0002\n&!\u00111RA\f\u0005=\u0019E.[3oiF+x\u000e^1UsB,\u0017!D2p[B,H/Z)v_R\f7\u000f\u0006\u0005\u0002j\u0005E\u00151SAX\u0011\u0015y6\u00041\u0001b\u0011\u001d\t)j\u0007a\u0001\u0003/\u000bA\"];pi\u0006,e\u000e\u001e:jKN\u0004b!!'\u0002$\u0006%f\u0002BAN\u0003?s1ARAO\u0013\u00051\u0014bAAQk\u00059\u0001/Y2lC\u001e,\u0017\u0002BAS\u0003O\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0003C+\u0004c\u0001\u0019\u0002,&\u0019\u0011Q\u0016\u0015\u00035E+x\u000e^1F]RLG/_!oI\u000e{gn];naRLwN\\:\t\u000f\u0005E6\u00041\u0001\u00024\u0006\u0001\"/Z:q_:\u001cXmQ1mY\n\f7m\u001b\t\bi\u0005U\u0016\u0011XA5\u0013\r\t9,\u000e\u0002\n\rVt7\r^5p]F\u00022\u0001MA^\u0013\r\ti\f\u000b\u0002\u0012%\u0016\u0004xN\u001d;Rk>$\u0018MU3tk2$\u0018!\u00043fg\u000e\u0014\u0018NY3Rk>$\u0018\r\u0006\u0003\u0002D\u0006m\u0007c\u0002\u001b\u0002F\u0006%\u0017Q[\u0005\u0004\u0003\u000f,$A\u0002+va2,'\u0007\u0005\u0003\u0002L\u0006EWBAAg\u0015\u0011\ty-!\u000e\u0002\u0011A\u0014x\u000e^8d_2LA!a5\u0002N\n1QI\u001d:peN\u00042\u0001MAl\u0013\r\tI\u000e\u000b\u0002\u0011#V|G/\u0019#fg\u000e\u0014\u0018\u000e\u001d;j_:Dq!!8\u001d\u0001\u0004\ty.A\u0006rk>$\u0018-\u00128uSRL\bc\u0001\u0019\u0002b&\u0019\u00111\u001d\u0015\u0003\u0017E+x\u000e^1F]RLG/_\u0001\u0013cV|G/Y:U_BL7mQ8oM&<7/\u0006\u0002\u0002jB!\u00111^Aw\u001b\u0005i\u0018bAAx{\nQ\u0001K]8qKJ$\u0018.Z:\u0002\u0019A\f'\u000f^5uS>tgi\u001c:\u0015\u0007\u0005\f)\u0010C\u0004\u0002^z\u0001\r!a8\u0002'Y\fG.\u001b3bi\u0016\fVo\u001c;b\u000b:$\u0018\u000e^=\u0015\t\u0005m(\u0011\u0001\t\u0006i\u0005u\u0018\u0011Z\u0005\u0004\u0003\u007f,$AB(qi&|g\u000eC\u0004\u0002^~\u0001\r!a8\u0002\u0015=tW\t\\3di&|g\u000e\u0006\u0004\u0002j\t\u001d!1\u0002\u0005\u0007\u0005\u0013\u0001\u0003\u0019A1\u0002+E,x\u000e^1U_BL7\rU1si&$\u0018n\u001c8JI\"1!Q\u0002\u0011A\u0002\u0005\f\u0001cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195\u0002\u001b=t'+Z:jO:\fG/[8o)\u0019\tIGa\u0005\u0003\u0016!1!\u0011B\u0011A\u0002\u0005DqA!\u0004\"\u0001\u0004\u00119\u0002\u0005\u00035\u0003{\f\u0017aB:uCJ$X\u000f\u001d\u000b\u0005\u0003S\u0012i\u0002C\u0004\u0003 \t\u0002\rA!\t\u0002AI,GO]5fm\u0016\fVo\u001c;b)>\u0004\u0018n\u0019)beRLG/[8o\u0007>,h\u000e\u001e\t\u0005i\t\r\u0012-C\u0002\u0003&U\u0012\u0011BR;oGRLwN\u001c\u0019\u0002\u0011MDW\u000f\u001e3po:$\"!!\u001b\u0002+I,7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hg\u00069b/\u00197jI\u0006$XMU3d_:4\u0017nZ;sCRLwN\u001c\u000b\u0005\u0003S\u0012\t\u0004C\u0004\u00034\u0015\u0002\rA!\u000e\u0002\u00139,woQ8oM&<\u0007c\u0001.\u00038%\u0019!\u0011H.\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\fe\u0016\u001cwN\u001c4jOV\u0014X\r\u0006\u0004\u0002j\t}\"1\t\u0005\b\u0005\u00032\u0003\u0019\u0001B\u001b\u0003%yGnY\"p]\u001aLw\rC\u0004\u00034\u0019\u0002\rA!\u000e\t\u000f\t\u001dS\u00011\u0001\u00036\u000511m\u001c8gS\u001eDQ!]\u0003A\u0002MDqA!\u0014\u0006\u0001\u0004\u0011y%\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\u0007i\u0013\t&C\u0002\u0003Tm\u0013aBU3qY&\u001c\u0017-T1oC\u001e,'\u000fC\u0003x\u000b\u0001\u0007\u0011\u0010C\u0004\u0002\u0010\u0015\u0001\r!a\u0005\t\u000f\tmS\u00011\u0001\u0003^\u00059Q.\u001a;sS\u000e\u001c\b\u0003\u0002B0\u0005Gj!A!\u0019\u000b\t\tm\u0013QG\u0005\u0005\u0005K\u0012\tGA\u0004NKR\u0014\u0018nY:\t\u000f\u0005-R\u00011\u0001\u00020\u00051\u0012/^8uC\u000e{wN\u001d3j]\u0006$xN]\"p]\u001aLw\rF\u0002h\u0005[BqAa\u0012\u0007\u0001\u0004\u0011)\u0004")
public class QuotaCoordinator
implements Logging,
BrokerReconfigurable {
    private final int brokerId;
    private final QuotaCoordinatorConfig quotaConfig;
    private final QuotaStateManager quotaStateManager;
    private final Scheduler scheduler;
    private final Supplier<InternalAdmin> internalAdminSupplier;
    private final ClusterLevelQuotaCallback clusterLevelQuotaCallback;
    private final Time time;
    private final AtomicBoolean isActive;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static QuotaCoordinator apply(KafkaConfig kafkaConfig, Scheduler scheduler, ReplicaManager replicaManager, Supplier<InternalAdmin> supplier, ClusterLevelQuotaCallback clusterLevelQuotaCallback, Metrics metrics, Time time) {
        QuotaCoordinator$ quotaCoordinator$ = QuotaCoordinator$.MODULE$;
        if (quotaCoordinator$ == null) {
            throw null;
        }
        QuotaCoordinatorConfig apply_quotaConfig = quotaCoordinator$.kafka$coordinator$quota$QuotaCoordinator$$quotaCoordinatorConfig(kafkaConfig);
        QuotaStateManager apply_quotaStateManager = new QuotaStateManager(apply_quotaConfig, scheduler, replicaManager, metrics, time);
        return new QuotaCoordinator(kafkaConfig.brokerId(), apply_quotaConfig, apply_quotaStateManager, scheduler, supplier, clusterLevelQuotaCallback, time);
    }

    public static Set<String> ReconfigurableConfigs() {
        return QuotaCoordinator$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public QuotaCoordinatorConfig quotaConfig() {
        return this.quotaConfig;
    }

    public QuotaStateManager quotaStateManager() {
        return this.quotaStateManager;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Supplier<InternalAdmin> internalAdminSupplier() {
        return this.internalAdminSupplier;
    }

    public ClusterLevelQuotaCallback clusterLevelQuotaCallback() {
        return this.clusterLevelQuotaCallback;
    }

    public Time time() {
        return this.time;
    }

    public AtomicBoolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive().set(active);
    }

    public double getBrokerQuotaLimit(ClientQuotaType quotaType) {
        double d;
        if (ClientQuotaType.FETCH.equals(quotaType)) {
            d = this.quotaConfig().quotasBrokerLimitConsumer();
        } else if (ClientQuotaType.PRODUCE.equals(quotaType)) {
            d = this.quotaConfig().quotasBrokerLimitProducer();
        } else {
            throw new IllegalArgumentException(new StringBuilder(25).append("Not a client quota type: ").append(quotaType).toString());
        }
        return d;
    }

    public void computeQuotas(int brokerId, Iterable<QuotaEntityAndConsumptions> quotaEntries, Function1<ReportQuotaResult, BoxedUnit> responseCallback) {
        if (!this.isActive().get()) {
            responseCallback.apply((Object)new ReportQuotaResult((Map<QuotaEntity, Errors>)((TraversableOnce)quotaEntries.map((Function1 & Serializable & scala.Serializable)quotaEntityAndConsumptions -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaEntityAndConsumptions.entity()), (Object)Errors.COORDINATOR_NOT_AVAILABLE), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())));
            return;
        }
        scala.collection.mutable.Map invalidQuotaEntries = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Buffer validQuotaEntries = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        quotaEntries.foreach((Function1 & Serializable & scala.Serializable)quotaEntityAndConsumptions -> {
            this.processQuotaEntry$1(quotaEntityAndConsumptions, invalidQuotaEntries, brokerId, validQuotaEntries);
            return BoxedUnit.UNIT;
        });
        if (invalidQuotaEntries.nonEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("Skipping quota computation for ").append(invalidQuotaEntries.size()).append(" quota entries because they failed validation").toString());
        }
        scala.collection.immutable.Map quotaEntriesPerPartition = validQuotaEntries.groupBy((Function1 & Serializable & scala.Serializable)quotaEntry -> new TopicPartition("_confluent-quotas", this.partitionFor(quotaEntry.quotaEntity())));
        this.quotaStateManager().storeQuotas((Map<TopicPartition, Iterable<QuotaEntry>>)quotaEntriesPerPartition, (Function1<Map<Object, Errors>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)responseStatus -> {
            scala.collection.immutable.Map $anonfun$computeQuotas$9_storeQuotaCallback$1_entityResults = ((TraversableOnce)quotaEntries.map((Function1 & Serializable & scala.Serializable)quotaEntry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaEntry.entity()), responseStatus.getOrElse((Object)BoxesRunTime.boxToInteger((int)this.partitionFor(quotaEntry.entity())), (Function0 & Serializable & scala.Serializable)() -> Errors.UNKNOWN_SERVER_ERROR)), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply((Object)new ReportQuotaResult((Map<QuotaEntity, Errors>)$anonfun$computeQuotas$9_storeQuotaCallback$1_entityResults.$plus$plus((GenTraversableOnce)invalidQuotaEntries)));
            return BoxedUnit.UNIT;
        }, this.quotaStateManager().storeQuotas$default$3());
    }

    public Tuple2<Errors, QuotaDescription> describeQuota(QuotaEntity quotaEntity) {
        Tuple2 tuple2;
        if (!this.isActive().get()) {
            return new Tuple2((Object)Errors.COORDINATOR_NOT_AVAILABLE, (Object)new QuotaDescription((Map<Object, Map<String, Object>>)scala.collection.Map$.MODULE$.empty()));
        }
        Option<Errors> option = this.validateQuotaEntity(quotaEntity);
        if (option instanceof Some) {
            Errors error = (Errors)((Some)option).value();
            tuple2 = new Tuple2((Object)error, (Object)new QuotaDescription((Map<Object, Map<String, Object>>)scala.collection.Map$.MODULE$.empty()));
        } else if (None$.MODULE$.equals(option)) {
            Tuple2 tuple22;
            Option<QuotaEntry> option2 = this.quotaStateManager().getQuota(quotaEntity);
            if (option2 instanceof Some) {
                QuotaEntry quotaEntry = (QuotaEntry)((Some)option2).value();
                tuple22 = new Tuple2((Object)Errors.NONE, (Object)new QuotaDescription((Map<Object, Map<String, Object>>)((TraversableOnce)((TraversableLike)quotaEntry.computedQuotas().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)QuotaCoordinator.$anonfun$describeQuota$1(x$1)))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    if (x0$1 == null) {
                        throw new MatchError(null);
                    }
                    int brokerId = x0$1._1$mcI$sp();
                    scala.collection.mutable.Map perBrokerQuotas = (scala.collection.mutable.Map)x0$1._2();
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)brokerId)), (Object)((TraversableOnce)perBrokerQuotas.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        if (x0$2 == null) {
                            throw new MatchError(null);
                        }
                        String quotaType = (String)x0$2._1();
                        QuotaValue quotaValue = (QuotaValue)x0$2._2();
                        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaType), (Object)BoxesRunTime.boxToDouble((double)quotaValue.quota()));
                        return tuple2;
                    }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
                    return tuple2;
                }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())));
            } else if (None$.MODULE$.equals(option2)) {
                tuple22 = new Tuple2((Object)Errors.QUOTA_ENTITY_NOT_FOUND, (Object)new QuotaDescription((Map<Object, Map<String, Object>>)scala.collection.Map$.MODULE$.empty()));
            } else {
                throw new MatchError(option2);
            }
            tuple2 = tuple22;
        } else {
            throw new MatchError(option);
        }
        return tuple2;
    }

    /*
     * WARNING - void declaration
     */
    public Properties quotasTopicConfigs() {
        void var1_1;
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        props.put(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(this.quotaConfig().quotasTopicSegmentBytes()));
        props.put(LogConfig$.MODULE$.CompressionTypeProp(), ProducerCompressionCodec$.MODULE$.name());
        props.put(LogConfig$.MODULE$.TopicPlacementConstraintsProp(), this.quotaConfig().quotasTopicPlacementConstraints());
        return var1_1;
    }

    public int partitionFor(QuotaEntity quotaEntity) {
        return this.quotaStateManager().partitionFor(quotaEntity);
    }

    public Option<Errors> validateQuotaEntity(QuotaEntity quotaEntity) {
        if (this.quotaStateManager().isLoadingQuotaEntity(quotaEntity)) {
            return new Some((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS);
        }
        if (!this.quotaStateManager().ownsQuotaEntity(quotaEntity)) {
            return new Some((Object)Errors.NOT_COORDINATOR);
        }
        return None$.MODULE$;
    }

    public void onElection(int quotaTopicPartitionId, int coordinatorEpoch) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Elected as the quota coordinator for partition ").append(quotaTopicPartitionId).append(" at epoch ").append(coordinatorEpoch).toString());
        this.quotaStateManager().loadQuotaState(quotaTopicPartitionId, coordinatorEpoch);
    }

    public void onResignation(int quotaTopicPartitionId, Option<Object> coordinatorEpoch) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Resigned as the quota coordinator for partition ").append(quotaTopicPartitionId).append(" at epoch ").append(coordinatorEpoch).toString());
        this.quotaStateManager().unloadQuotaState(quotaTopicPartitionId, coordinatorEpoch);
    }

    public void startup(Function0<Object> retrieveQuotaTopicPartitionCount) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting up.");
        this.scheduler().startup();
        this.quotaStateManager().startup(retrieveQuotaTopicPartitionCount, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.maybeCreateQuotaTopic$1());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Startup complete.");
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down.");
        this.isActive().set(false);
        this.quotaStateManager().shutdown();
        this.scheduler().shutdown();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown complete.");
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return QuotaCoordinator$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
    }

    @Override
    public void reconfigure(KafkaConfig olcConfig, KafkaConfig newConfig) {
        this.quotaStateManager().reconfigure(QuotaCoordinator$.MODULE$.kafka$coordinator$quota$QuotaCoordinator$$quotaCoordinatorConfig(newConfig));
    }

    public static final /* synthetic */ void $anonfun$computeQuotas$3(QuotaCoordinator $this, QuotaEntry quotaEntry$1, int brokerId$1, QuotaConsumption quotaConsumption) {
        ClientQuotaType clientQuotaType = ClientQuotaType.valueOf((String)quotaConsumption.quotaType());
        Double clusterQuotaLimit = $this.clusterLevelQuotaCallback().clusterQuotaLimit(clientQuotaType, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(quotaEntry$1.quotaEntity().entityTypes()).asJava());
        quotaEntry$1.updateConsumptionAndRecomputeQuotas(brokerId$1, quotaConsumption, Predef$.MODULE$.Double2double(clusterQuotaLimit), $this.getBrokerQuotaLimit(clientQuotaType), $this.time().milliseconds(), $this.quotaConfig().quotasConsumptionExpirationTimeMs(), $this.quotaConfig().quotasRecomputeIntervalMs());
    }

    private final void processQuotaEntry$1(QuotaEntityAndConsumptions quotaEntityAndConsumptions, scala.collection.mutable.Map invalidQuotaEntries$1, int brokerId$1, Buffer validQuotaEntries$1) {
        Option<Errors> option = this.validateQuotaEntity(quotaEntityAndConsumptions.entity());
        if (option instanceof Some) {
            Errors error = (Errors)((Some)option).value();
            invalidQuotaEntries$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaEntityAndConsumptions.entity()), (Object)error));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            QuotaEntry quotaEntry = this.quotaStateManager().getAndMaybePutQuota(quotaEntityAndConsumptions.entity());
            quotaEntry.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> quotaEntityAndConsumptions.consumptions().foreach((Function1 & Serializable & scala.Serializable)quotaConsumption -> {
                QuotaCoordinator.$anonfun$computeQuotas$3(this, quotaEntry, brokerId$1, quotaConsumption);
                return BoxedUnit.UNIT;
            }));
            validQuotaEntries$1.$plus$eq((Object)quotaEntry);
            return;
        }
        throw new MatchError(option);
    }

    private final void storeQuotaCallback$1(Map responseStatus, Iterable quotaEntries$1, Function1 responseCallback$1, scala.collection.mutable.Map invalidQuotaEntries$1) {
        scala.collection.immutable.Map entityResults = ((TraversableOnce)quotaEntries$1.map((Function1 & Serializable & scala.Serializable)quotaEntry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaEntry.entity()), responseStatus.getOrElse((Object)BoxesRunTime.boxToInteger((int)this.partitionFor(quotaEntry.entity())), (Function0 & Serializable & scala.Serializable)() -> Errors.UNKNOWN_SERVER_ERROR)), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        responseCallback$1.apply((Object)new ReportQuotaResult((Map<QuotaEntity, Errors>)entityResults.$plus$plus((GenTraversableOnce)invalidQuotaEntries$1)));
    }

    public static final /* synthetic */ void $anonfun$computeQuotas$9(QuotaCoordinator $this, Iterable quotaEntries$1, Function1 responseCallback$1, scala.collection.mutable.Map invalidQuotaEntries$1, Map responseStatus) {
        scala.collection.immutable.Map storeQuotaCallback$1_entityResults = ((TraversableOnce)quotaEntries$1.map((Function1 & Serializable & scala.Serializable)quotaEntry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaEntry.entity()), responseStatus.getOrElse((Object)BoxesRunTime.boxToInteger((int)this.partitionFor(quotaEntry.entity())), (Function0 & Serializable & scala.Serializable)() -> Errors.UNKNOWN_SERVER_ERROR)), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        responseCallback$1.apply((Object)new ReportQuotaResult((Map<QuotaEntity, Errors>)storeQuotaCallback$1_entityResults.$plus$plus((GenTraversableOnce)invalidQuotaEntries$1)));
    }

    public static final /* synthetic */ boolean $anonfun$describeQuota$1(Tuple2 x$1) {
        return ((TraversableOnce)x$1._2()).nonEmpty();
    }

    private final void maybeCreateQuotaTopic$1() {
        boolean topicCreated = false;
        while (!topicCreated) {
            try {
                this.internalAdminSupplier().get().ensureTopic("_confluent-quotas", this.quotaConfig().quotasTopicPartitions(), this.quotaConfig().quotasTopicReplicationFactor(), this.quotasTopicConfigs());
                topicCreated = true;
                this.isActive().set(true);
            }
            catch (Throwable t) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Failed to create topic ").append("_confluent-quotas").append(" with error ").append(t).append(", retrying after 5 seconds").toString());
                Thread.sleep(5000L);
            }
        }
    }

    public QuotaCoordinator(int brokerId, QuotaCoordinatorConfig quotaConfig, QuotaStateManager quotaStateManager, Scheduler scheduler, Supplier<InternalAdmin> internalAdminSupplier, ClusterLevelQuotaCallback clusterLevelQuotaCallback, Time time) {
        this.brokerId = brokerId;
        this.quotaConfig = quotaConfig;
        this.quotaStateManager = quotaStateManager;
        this.scheduler = scheduler;
        this.internalAdminSupplier = internalAdminSupplier;
        this.clusterLevelQuotaCallback = clusterLevelQuotaCallback;
        this.time = time;
        Logging.$init$(this);
        this.isActive = new AtomicBoolean(false);
        this.logIdent_$eq(new StringBuilder(30).append("[QuotaCoordinator brokerId=").append(brokerId).append("]: ").toString());
    }
}

