/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog.event;

import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.confluent.protobuf.events.catalog.v1.MetadataChange;
import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import java.util.Map;
import java.util.Optional;
import kafka.catalog.MetadataEventUtils;
import kafka.catalog.TopicInfo;
import kafka.catalog.ZKTopicMetadataCollector;
import kafka.catalog.ZKTopicMetadataCollectorContext;
import kafka.catalog.event.MetadataCollectorEvent;
import kafka.catalog.exceptions.CollectorContextNotInitializedException;
import kafka.catalog.exceptions.TopicConfigFetchRequestException;
import kafka.common.TenantHelpers;
import kafka.log.LogConfig;
import org.apache.kafka.common.utils.Time;

public class TopicCreationEvent
extends MetadataCollectorEvent {
    private final Map<String, TopicInfo> newTopicWithInfo;

    public TopicCreationEvent(ZKTopicMetadataCollector collector, Map<String, TopicInfo> newTopicWithInfo, Time time) {
        super(collector, time);
        this.newTopicWithInfo = newTopicWithInfo;
    }

    public void run() throws CollectorContextNotInitializedException {
        ZKTopicMetadataCollectorContext context = this.context();
        LOG.debug("Creating topics {}", this.newTopicWithInfo.keySet());
        Timestamp observeTimestamp = Timestamps.fromNanos((long)this.eventObserveTime);
        for (String topic : this.newTopicWithInfo.keySet()) {
            TopicInfo topicInfo = this.newTopicWithInfo.get(topic);
            String logicalClusterId = topicInfo.logicalClusterId();
            try {
                Optional<LogConfig> logConfigsMap = this.getLogConfigsForTopic(context, topic);
                if (logConfigsMap.isPresent()) {
                    MetadataEvent topicMetadataEvent = MetadataEventUtils.topicMetadataEventFromLogConfig(logConfigsMap.get(), TenantHelpers.extractLogicalName(topic), topicInfo.topicId(), topicInfo.partitions(), topicInfo.replicationFactors(), observeTimestamp, null);
                    context.localStore().addMetadataEvent(logicalClusterId, topic, topicMetadataEvent);
                    MetadataChange topicMetadataChange = MetadataEventUtils.topicCreateEvent(logicalClusterId, topicMetadataEvent);
                    this.emitDeltaEvent(context, topicMetadataChange);
                }
                context.removeTopicFromInitialSnapshot(topic);
            }
            catch (TopicConfigFetchRequestException e) {
                LOG.error("Skipping topic {} due to", (Object)topic, (Object)e);
                context.catalogMetrics().collectorEventHandleErrorSensor.record();
            }
        }
    }

    public String toString() {
        return "TopicCreationEvent(newTopics=" + this.newTopicWithInfo.keySet() + ')';
    }
}

