/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import joptsimple.OptionSpec;
import kafka.admin.AdminOperationException;
import kafka.admin.LeadershipPriorityCommandOptions;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.AlterLeadershipPriorityOptions;
import org.apache.kafka.clients.admin.AlterLeadershipPrioritySpec;
import org.apache.kafka.clients.admin.BrokerLeadershipPriorityResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeLeadershipPriorityOptions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

public final class LeadershipPriorityCommand$
implements Logging {
    public static LeadershipPriorityCommand$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new LeadershipPriorityCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void main(String[] args) {
        int exitCode = 0;
        try {
            try {
                this.run(args, this.run$default$2());
            }
            catch (Throwable e) {
                exitCode = 1;
                this.printException(e);
            }
        }
        catch (Throwable throwable) {
            throw Exit$.MODULE$.exit(exitCode, Exit$.MODULE$.exit$default$2());
        }
        throw Exit$.MODULE$.exit(exitCode, Exit$.MODULE$.exit$default$2());
    }

    public void run(String[] args, Option<ConfluentAdmin> clientOption) {
        LeadershipPriorityCommandOptions opts = (LeadershipPriorityCommandOptions)new Some((Object)new LeadershipPriorityCommandOptions(args)).get();
        try (ConfluentAdmin client = (ConfluentAdmin)clientOption.getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.createAdminClient(opts));){
            try {
                if (opts.options().has((OptionSpec)opts.describeOpt())) {
                    this.describeLeadershipPriority(client);
                } else {
                    this.alterLeadershipPriority(client, opts);
                }
            }
            catch (ExecutionException e) {
                if (e.getCause() != null) {
                    throw e.getCause();
                }
                throw e;
            }
        }
    }

    public Option<ConfluentAdmin> run$default$2() {
        return None$.MODULE$;
    }

    private void printException(Throwable e) {
        Predef$.MODULE$.println((Object)new StringBuilder(50).append("Error while running leadership priority command : ").append(e.getMessage()).toString());
    }

    private void describeLeadershipPriority(ConfluentAdmin client) {
        ((Collection)client.describeLeadershipPriority(new DescribeLeadershipPriorityOptions()).future().get()).forEach(result -> {
            Predef$.MODULE$.print((Object)new StringBuilder(17).append("\tDemoted Broker: ").append(result.brokerId()).toString());
            Predef$.MODULE$.print((Object)new StringBuilder(10).append("\tReasons: ").append(((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(result.reasons()).asScala()).mkString(", ")).toString());
            Predef$.MODULE$.println();
        });
    }

    private void alterLeadershipPriority(ConfluentAdmin client, LeadershipPriorityCommandOptions opts) {
        int controllerId;
        AlterLeadershipPrioritySpec.PriorityOperationEnum priorityOperationEnum = opts.options().has((OptionSpec)opts.demoteOpt()) ? AlterLeadershipPrioritySpec.PriorityOperationEnum.DEMOTE : AlterLeadershipPrioritySpec.PriorityOperationEnum.PROMOTE;
        scala.collection.immutable.Set<Integer> brokerIds = this.parseBrokerIds((String)opts.options().valueOf(opts.brokerIdsOpt()));
        if (brokerIds.contains((Object)(controllerId = ((Node)client.describeCluster().controller().get()).id()))) {
            AlterLeadershipPrioritySpec.PriorityOperationEnum priorityOperationEnum2 = priorityOperationEnum;
            AlterLeadershipPrioritySpec.PriorityOperationEnum priorityOperationEnum3 = AlterLeadershipPrioritySpec.PriorityOperationEnum.DEMOTE;
            if (!(priorityOperationEnum2 != null ? !priorityOperationEnum2.equals(priorityOperationEnum3) : priorityOperationEnum3 != null)) {
                Predef$.MODULE$.println((Object)new StringBuilder(35).append("The controller:(").append(controllerId).append(") is being demoted.").toString());
            }
        }
        AlterLeadershipPrioritySpec requestData = new AlterLeadershipPrioritySpec((Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(this.parseBrokerIds((String)opts.options().valueOf(opts.brokerIdsOpt()))).asJava(), priorityOperationEnum, (String)opts.options().valueOf(opts.reasonOpt()), opts.options().has((OptionSpec)opts.forceOpt()));
        client.alterLeadershipPriority(requestData, new AlterLeadershipPriorityOptions()).values().forEach((x0$1, x1$1) -> {
            Integer brokerId = x0$1;
            try {
                String string;
                BrokerLeadershipPriorityResult result = (BrokerLeadershipPriorityResult)x1$1.get();
                Predef$.MODULE$.print((Object)new StringBuilder(9).append("\tBroker: ").append(result.brokerId()).toString());
                BrokerLeadershipPriorityResult.LeadershipPriorityEnum leadershipPriorityEnum = result.leadershipPriority();
                if (BrokerLeadershipPriorityResult.LeadershipPriorityEnum.UNKNOWN.equals(leadershipPriorityEnum)) {
                    string = "UNKNOWN";
                } else if (BrokerLeadershipPriorityResult.LeadershipPriorityEnum.NORMAL.equals(leadershipPriorityEnum)) {
                    string = "NORMAL";
                } else if (BrokerLeadershipPriorityResult.LeadershipPriorityEnum.DEMOTED.equals(leadershipPriorityEnum)) {
                    string = "DEMOTED";
                } else {
                    throw new MatchError((Object)leadershipPriorityEnum);
                }
                Predef$.MODULE$.print((Object)new StringBuilder(15).append("\tBroker state: ").append(string).toString());
                Predef$.MODULE$.println();
                return;
            }
            catch (ExecutionException e) {
                if (e.getCause() != null) {
                    MODULE$.printBrokerFailedMessage(e.getCause(), brokerId);
                    return;
                }
                MODULE$.printBrokerFailedMessage(e, brokerId);
                return;
            }
            catch (InterruptedException e) {
                MODULE$.printBrokerFailedMessage(e, brokerId);
                return;
            }
        });
    }

    private void printBrokerFailedMessage(Throwable throwable, Integer brokerId) {
        Predef$.MODULE$.print((Object)new StringBuilder(19).append("\tBroker: ").append(brokerId).append("\tFailed: ").append(throwable.getMessage()).append("\n").toString());
    }

    private ConfluentAdmin createAdminClient(LeadershipPriorityCommandOptions opts) {
        Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options().valueOf(opts.commandConfigOpt()))) : new Properties();
        props.setProperty("bootstrap.servers", (String)opts.options().valueOf(opts.bootstrapServer()));
        return ConfluentAdmin.create((Properties)props);
    }

    private scala.collection.immutable.Set<Integer> parseBrokerIds(String brokerIdsString) {
        new StringOps(Predef$.MODULE$.augmentString(brokerIdsString)).foreach((Function1 & Serializable & scala.Serializable)ch -> {
            LeadershipPriorityCommand$.$anonfun$parseBrokerIds$1(brokerIdsString, BoxesRunTime.unboxToChar((Object)ch));
            return BoxedUnit.UNIT;
        });
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])brokerIdsString.split(","))).map((Function1 & Serializable & scala.Serializable)brokerId -> Predef$.MODULE$.int2Integer(new StringOps(Predef$.MODULE$.augmentString(brokerId)).toInt()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Integer.class))))).toSet();
    }

    public static final /* synthetic */ void $anonfun$parseBrokerIds$1(String brokerIdsString$1, char ch) {
        if (!((Object)BoxesRunTime.boxToCharacter((char)ch)).equals(BoxesRunTime.boxToCharacter((char)',')) && !RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(ch))) {
            throw new AdminOperationException(new StringBuilder(54).append("Broker ids: ").append(brokerIdsString$1).append(", must not include invalid character - '").append(ch).append("'.").toString());
        }
    }

    private LeadershipPriorityCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

