/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import java.util.Random;
import kafka.admin.AdminOperationException;
import kafka.admin.BrokerMetadata;
import kafka.utils.Logging;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class AdminUtils$
implements Logging {
    public static AdminUtils$ MODULE$;
    private final Random rand;
    private final String AdminClientId;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new AdminUtils$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Random rand() {
        return this.rand;
    }

    public String AdminClientId() {
        return this.AdminClientId;
    }

    public Map<Object, Seq<Object>> assignReplicasToBrokers(Iterable<BrokerMetadata> brokerMetadatas, int nPartitions, int replicationFactor, int fixedStartIndex, int startPartitionId) {
        if (nPartitions <= 0) {
            throw new InvalidPartitionsException("Number of partitions must be larger than 0.");
        }
        if (replicationFactor <= 0) {
            throw new InvalidReplicationFactorException("Replication factor must be larger than 0.");
        }
        if (replicationFactor > brokerMetadatas.size()) {
            throw new InvalidReplicationFactorException(new StringBuilder(53).append("Replication factor: ").append(replicationFactor).append(" larger than available brokers: ").append(brokerMetadatas.size()).append(".").toString());
        }
        if (brokerMetadatas.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AdminUtils$.$anonfun$assignReplicasToBrokers$1(x$1)))) {
            return this.assignReplicasToBrokersRackUnaware(nPartitions, replicationFactor, (Iterable<Object>)((Iterable)brokerMetadatas.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), Iterable$.MODULE$.canBuildFrom())), fixedStartIndex, startPartitionId);
        }
        if (brokerMetadatas.exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AdminUtils$.$anonfun$assignReplicasToBrokers$3(x$3)))) {
            throw new AdminOperationException("Not all brokers have rack information for replica rack aware assignment.");
        }
        return this.assignReplicasToBrokersRackAware(nPartitions, replicationFactor, brokerMetadatas, fixedStartIndex, startPartitionId);
    }

    public int assignReplicasToBrokers$default$4() {
        return -1;
    }

    public int assignReplicasToBrokers$default$5() {
        return -1;
    }

    private Map<Object, Seq<Object>> assignReplicasToBrokersRackUnaware(int nPartitions, int replicationFactor, Iterable<Object> brokerList, int fixedStartIndex, int startPartitionId) {
        scala.collection.mutable.Map ret = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        int[] brokerArray = (int[])brokerList.toArray(ClassTag$.MODULE$.Int());
        int startIndex = fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(brokerArray.length);
        IntRef currentPartitionId = IntRef.create((int)package$.MODULE$.max(0, startPartitionId));
        IntRef nextReplicaShift = IntRef.create((int)(fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(brokerArray.length)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            if (currentPartitionId$1.elem > 0 && currentPartitionId$1.elem % brokerArray.length == 0) {
                ++nextReplicaShift$1.elem;
            }
            int firstReplicaIndex = (currentPartitionId$1.elem + startIndex) % brokerArray.length;
            ArrayBuffer replicaBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{brokerArray[firstReplicaIndex]}));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), replicationFactor - 1).foreach((Function1 & Serializable & scala.Serializable)j -> replicaBuffer.$plus$eq((Object)BoxesRunTime.boxToInteger((int)brokerArray[AdminUtils$.MODULE$.replicaIndex(firstReplicaIndex, nextReplicaShift.elem, BoxesRunTime.unboxToInt((Object)j), brokerArray.length)])));
            ret.put((Object)BoxesRunTime.boxToInteger((int)currentPartitionId$1.elem), (Object)replicaBuffer);
            ++currentPartitionId$1.elem;
        });
        return ret;
    }

    private Map<Object, Seq<Object>> assignReplicasToBrokersRackAware(int nPartitions, int replicationFactor, Iterable<BrokerMetadata> brokerMetadatas, int fixedStartIndex, int startPartitionId) {
        scala.collection.immutable.Map brokerRackMap = ((TraversableOnce)brokerMetadatas.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends BrokerMetadata, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    int id = x1.id();
                    Option<String> option = x1.rack();
                    if (option instanceof Some) {
                        String rack = (String)((Some)option).value();
                        object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)id)), (Object)rack);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(BrokerMetadata x1) {
                boolean bl = x1 != null && x1.rack() instanceof Some;
                return bl;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        int numRacks = brokerRackMap.values().toSet().size();
        IndexedSeq<Object> arrangedBrokerList = this.getRackAlternatedBrokerList((Map<Object, String>)brokerRackMap);
        int numBrokers = arrangedBrokerList.size();
        scala.collection.mutable.Map ret = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        int startIndex = fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(arrangedBrokerList.size());
        IntRef currentPartitionId = IntRef.create((int)package$.MODULE$.max(0, startPartitionId));
        IntRef nextReplicaShift = IntRef.create((int)(fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(arrangedBrokerList.size())));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_2 -> {
            if (currentPartitionId$2.elem > 0 && currentPartitionId$2.elem % arrangedBrokerList.size() == 0) {
                ++nextReplicaShift$2.elem;
            }
            int firstReplicaIndex = (currentPartitionId$2.elem + startIndex) % arrangedBrokerList.size();
            int leader = BoxesRunTime.unboxToInt((Object)arrangedBrokerList.apply(firstReplicaIndex));
            ArrayBuffer replicaBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader}));
            Set racksWithReplicas = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)brokerRackMap.apply((Object)BoxesRunTime.boxToInteger((int)leader))}));
            Set brokersWithReplicas = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader}));
            IntRef k = IntRef.create((int)0);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), replicationFactor - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                boolean done = false;
                while (!done) {
                    int broker = BoxesRunTime.unboxToInt((Object)arrangedBrokerList.apply(MODULE$.replicaIndex(firstReplicaIndex, nextReplicaShift$2.elem * numRacks, k$1.elem, arrangedBrokerList.size())));
                    String rack = (String)brokerRackMap.apply((Object)BoxesRunTime.boxToInteger((int)broker));
                    if (!(racksWithReplicas.contains((Object)rack) && racksWithReplicas.size() != numRacks || brokersWithReplicas.contains((Object)BoxesRunTime.boxToInteger((int)broker)) && brokersWithReplicas.size() != numBrokers)) {
                        replicaBuffer.$plus$eq((Object)BoxesRunTime.boxToInteger((int)broker));
                        racksWithReplicas.$plus$eq((Object)rack);
                        brokersWithReplicas.$plus$eq((Object)BoxesRunTime.boxToInteger((int)broker));
                        done = true;
                    }
                    ++k$1.elem;
                }
            });
            ret.put((Object)BoxesRunTime.boxToInteger((int)currentPartitionId$2.elem), (Object)replicaBuffer);
            ++currentPartitionId$2.elem;
        });
        return ret;
    }

    public IndexedSeq<Object> getRackAlternatedBrokerList(Map<Object, String> brokerRackMap) {
        Map brokersIteratorByRack = (Map)this.getInverseMap(brokerRackMap).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String rack = (String)x0$1._1();
            Seq brokers = (Seq)x0$1._2();
            Tuple2 tuple2 = new Tuple2((Object)rack, (Object)brokers.iterator());
            return tuple2;
        }, scala.collection.Map$.MODULE$.canBuildFrom());
        String[] racks = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])brokersIteratorByRack.keys().toArray(ClassTag$.MODULE$.apply(String.class)))).sorted((Ordering)Ordering.String$.MODULE$);
        ArrayBuffer result = new ArrayBuffer();
        int rackIndex = 0;
        while (result.size() < brokerRackMap.size()) {
            Iterator rackIterator = (Iterator)brokersIteratorByRack.apply((Object)racks[rackIndex]);
            if (rackIterator.hasNext()) {
                result.$plus$eq(rackIterator.next());
            }
            rackIndex = (rackIndex + 1) % racks.length;
        }
        return result;
    }

    public Map<String, Seq<Object>> getInverseMap(Map<Object, String> brokerRackMap) {
        return (Map)((TraversableLike)brokerRackMap.toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int id = x0$1._1$mcI$sp();
            String rack = (String)x0$1._2();
            Tuple2 tuple2 = new Tuple2((Object)rack, (Object)BoxesRunTime.boxToInteger((int)id));
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x0$2 -> {
            void var1_1;
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            String rack = (String)x0$2._1();
            return var1_1;
        }).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            if (x0$3 == null) {
                throw new MatchError(null);
            }
            String rack = (String)x0$3._1();
            Seq rackAndIdList = (Seq)x0$3._2();
            Tuple2 tuple2 = new Tuple2((Object)rack, ((SeqLike)rackAndIdList.map((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToInteger((int)AdminUtils$.$anonfun$getInverseMap$4(x0$4)), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Int$.MODULE$));
            return tuple2;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
    }

    public Properties parseConfigs(String configs) {
        String pattern = "(?=[^\\]]*(?:\\[|$))";
        String[][] splitConfigs = (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configs.split(new StringBuilder(1).append(",").append(pattern).toString()))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.split(new StringBuilder(7).append("\\s*=\\s*").append(pattern).toString(), -1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])splitConfigs)).forall((Function1 & Serializable & scala.Serializable)config -> BoxesRunTime.boxToBoolean((boolean)AdminUtils$.$anonfun$parseConfigs$2(config))), (Function0 & Serializable & scala.Serializable)() -> "Invalid config: all configs must be in the format \"key=val\".");
        Properties props = new Properties();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])splitConfigs)).foreach((Function1 & Serializable & scala.Serializable)pair -> props.setProperty(pair[0].trim(), pair[1].replaceAll("\\[?\\]?", "").trim()));
        return props;
    }

    private int replicaIndex(int firstReplicaIndex, int secondReplicaShift, int replicaIndex, int nBrokers) {
        int shift = 1 + (secondReplicaShift + replicaIndex) % (nBrokers - 1);
        return (firstReplicaIndex + shift) % nBrokers;
    }

    public static final /* synthetic */ boolean $anonfun$assignReplicasToBrokers$1(BrokerMetadata x$1) {
        return x$1.rack().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$assignReplicasToBrokers$3(BrokerMetadata x$3) {
        return x$3.rack().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$getInverseMap$4(Tuple2 x0$4) {
        void var1_1;
        if (x0$4 == null) {
            throw new MatchError(null);
        }
        int id = x0$4._2$mcI$sp();
        return (int)var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$parseConfigs$2(String[] config) {
        return config.length == 2;
    }

    private AdminUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.rand = new Random();
        this.AdminClientId = "__admin_client";
    }
}

