/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;

public class RequestQueueMap<K, V> {
    private boolean shutdown = false;
    private final Random rand = new Random();
    private final HashMap<K, ArrayList<V>> requestQueueMap = new HashMap();
    private final HashSet<K> inFlightKeys = new HashSet();
    private final ArrayList<K> randomAccessList = new ArrayList();

    public synchronized void shutDown() {
        this.shutdown = true;
        this.notifyAll();
    }

    public synchronized void addRequest(K key, V value) {
        ArrayList<Object> queue = this.requestQueueMap.get(key);
        if (queue == null) {
            queue = new ArrayList();
            this.requestQueueMap.put(key, queue);
            if (!this.inFlightKeys.contains(key)) {
                this.addAvailableKey(key);
            }
        }
        queue.add(value);
    }

    public synchronized Map.Entry<K, ArrayList<V>> getRandomNonEmptyQueue() {
        while (this.randomAccessList.isEmpty() && !this.shutdown) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.shutdown || this.randomAccessList.isEmpty()) {
            return null;
        }
        K randomKey = this.removeRandomKey();
        this.inFlightKeys.add(randomKey);
        return new AbstractMap.SimpleEntry<K, ArrayList<V>>(randomKey, this.requestQueueMap.remove(randomKey));
    }

    public synchronized void returnKey(K key) {
        this.inFlightKeys.remove(key);
        if (this.requestQueueMap.containsKey(key)) {
            this.addAvailableKey(key);
        }
    }

    private void addAvailableKey(K key) {
        this.randomAccessList.add(key);
        this.notifyAll();
    }

    private K removeRandomKey() {
        int lastind = this.randomAccessList.size() - 1;
        int randomind = this.rand.nextInt(this.randomAccessList.size());
        K randomKey = this.randomAccessList.get(randomind);
        Collections.swap(this.randomAccessList, randomind, lastind);
        this.randomAccessList.remove(lastind);
        return randomKey;
    }

    public synchronized void unsetShutdown() {
        this.shutdown = false;
    }
}

