/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.coordinator.group.GroupMetadataManager$;
import kafka.coordinator.quota.QuotaStateManager$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.serializer.Decoder;
import kafka.tools.DumpLogSegments$;
import kafka.utils.CommandDefaultOptions;
import kafka.utils.CommandDefaultOptions$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.common.metadata.MetadataJsonConverters;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r\u0005u!B,Y\u0011\u0003if!B0Y\u0011\u0003\u0001\u0007\"B4\u0002\t\u0003A\u0007\u0002C5\u0002\u0005\u0004%\t\u0001\u00176\t\rM\f\u0001\u0015!\u0003l\u0011\u0015!\u0018\u0001\"\u0001v\u0011\u001d\t\t\"\u0001C\u0005\u0003'Aq!!\n\u0002\t\u0013\t9\u0003C\u0004\u0002,\u0005!I!!\f\t\u0011\u0005E\u0012\u0001\"\u0001Y\u0003gA\u0001\"!!\u0002\t\u0003A\u00161\u0011\u0004\u000b\u00037\f\u0001\u0013aI\u00015\u0006u\u0007bBAq\u0017\u0019\u0005\u00111\u001d\u0004\u0007\u0005O\tAA!\u000b\t\u0015\t]RB!A!\u0002\u0013\u0011I\u0004\u0003\u0006\u0003F5\u0011\t\u0011)A\u0005\u0005\u000fBaaZ\u0007\u0005\u0002\t%\u0003bBAq\u001b\u0011\u0005#\u0011\u000b\u0005\b\u00057\nA\u0011\u0002B/\u0011\u001d\u0011I)\u0001C\u0005\u0005\u00173a!a%\u0002\u0001\u0005U\u0005BB4\u0015\t\u0003\t9\nC\u0005\u0002\u001aR\u0011\r\u0011\"\u0001\u0002\u001c\"A\u0011Q\u0015\u000b!\u0002\u0013\ti\nC\u0005\u0002(R\u0011\r\u0011\"\u0001\u0002\u001c\"A\u0011\u0011\u0016\u000b!\u0002\u0013\ti\nC\u0005\u0002,R\u0011\r\u0011\"\u0001\u0002\u001c\"A\u0011Q\u0016\u000b!\u0002\u0013\ti\nC\u0004\u00020R!\t!!-\t\u000f\u0005uF\u0003\"\u0001\u0002@\"9\u0011\u0011\u001a\u000b\u0005\u0002\u0005-\u0007bBAl)\u0011\u0005\u0011\u0011\u001c\u0004\u0007\u0005G\u000bAA!*\t\r\u001d\u0004C\u0011\u0001BU\u0011\u001d\t\t\u000f\tC!\u0005[3aA!.\u0002\t\t]\u0006BB4$\t\u0003\u0011I\fC\u0004\u0002b\u000e\"\tE!0\u0007\r\t\u0005\u0017\u0001\u0002Bb\u0011\u00199g\u0005\"\u0001\u0003F\"9\u0011\u0011\u001d\u0014\u0005B\t%gA\u0002Bg\u0003\u0011\u0011y\r\u0003\u0004hS\u0011\u0005!\u0011\u001b\u0005\n\u0005+L#\u0019!C\u0001\u0005/D\u0001B!:*A\u0003%!\u0011\u001c\u0005\b\u0003CLC\u0011\tBt\r\u0019\u0011Y/\u0001\u0003\u0003n\"Q!P\fB\u0001B\u0003%1Pa?\t\r\u001dtC\u0011\u0001B\u007f\u0011%\u0019\u0019A\fb\u0001\n\u0003\u0019)\u0001\u0003\u0005\u0004\u00149\u0002\u000b\u0011BB\u0004\u0011%\u0019)B\fb\u0001\n\u0003\u0019)\u0001\u0003\u0005\u0004\u00189\u0002\u000b\u0011BB\u0004\u0011%\u0019IB\fb\u0001\n\u0003\u0019)\u0001\u0003\u0005\u0004\u001c9\u0002\u000b\u0011BB\u0004\u0011%\u0019iB\fb\u0001\n\u0003\u0019y\u0002\u0003\u0005\u0004(9\u0002\u000b\u0011BB\u0011\u0011%\u0019IC\fb\u0001\n\u0003\u0019Y\u0003\u0003\u0005\u000469\u0002\u000b\u0011BB\u0017\u0011%\u00199D\fb\u0001\n\u0003\u0019Y\u0003\u0003\u0005\u0004:9\u0002\u000b\u0011BB\u0017\u0011%\u0019YD\fb\u0001\n\u0003\u0019)\u0001\u0003\u0005\u0004>9\u0002\u000b\u0011BB\u0004\u0011%\u0019yD\fb\u0001\n\u0003\u0019\t\u0005\u0003\u0005\u0004F9\u0002\u000b\u0011BB\"\u0011%\u00199E\fb\u0001\n\u0003\u0019\t\u0005\u0003\u0005\u0004J9\u0002\u000b\u0011BB\"\u0011%\u0019YE\fb\u0001\n\u0003\u0019)\u0001\u0003\u0005\u0004N9\u0002\u000b\u0011BB\u0004\u0011%\u0019yE\fb\u0001\n\u0003\u0019)\u0001\u0003\u0005\u0004R9\u0002\u000b\u0011BB\u0004\u0011%\u0019\u0019F\fb\u0001\n\u0003\u0019)\u0001\u0003\u0005\u0004V9\u0002\u000b\u0011BB\u0004\u0011%\u00199F\fb\u0001\n\u0003\u0019)\u0001\u0003\u0005\u0004Z9\u0002\u000b\u0011BB\u0004\u0011%\u0019YF\fb\u0001\n\u0003\u0019)\u0001\u0003\u0005\u0004^9\u0002\u000b\u0011BB\u0004\u0011\u001d\u0019yF\fC\u0001\u0007CB!ba\u001d/\u0011\u000b\u0007I\u0011AB;\u0011)\u0011\u0019I\fEC\u0002\u0013\u00051Q\u000f\u0005\u000b\u0005Wr\u0003R1A\u0005\u0002\rU\u0004BCA\"]!\u0015\r\u0011\"\u0001\u0004v!Q\u0011\u0011\b\u0018\t\u0006\u0004%\ta!\u001e\t\u0015\r]d\u0006#b\u0001\n\u0003\u0019I\b\u0003\u0006\u0002z9B)\u0019!C\u0001\u0007{B!Ba\"/\u0011\u000b\u0007I\u0011AB?\u0011\u001d\u0019yH\fC\u0001\u00033\fq\u0002R;na2{wmU3h[\u0016tGo\u001d\u0006\u00033j\u000bQ\u0001^8pYNT\u0011aW\u0001\u0006W\u000647.Y\u0002\u0001!\tq\u0016!D\u0001Y\u0005=!U/\u001c9M_\u001e\u001cVmZ7f]R\u001c8CA\u0001b!\t\u0011W-D\u0001d\u0015\u0005!\u0017!B:dC2\f\u0017B\u00014d\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!X\u0001\r%\u0016\u001cwN\u001d3J]\u0012,g\u000e^\u000b\u0002WB\u0011A.]\u0007\u0002[*\u0011an\\\u0001\u0005Y\u0006twMC\u0001q\u0003\u0011Q\u0017M^1\n\u0005Il'AB*ue&tw-A\u0007SK\u000e|'\u000fZ%oI\u0016tG\u000fI\u0001\u0005[\u0006Lg\u000e\u0006\u0002wsB\u0011!m^\u0005\u0003q\u000e\u0014A!\u00168ji\")!0\u0002a\u0001w\u0006!\u0011M]4t!\r\u0011GP`\u0005\u0003{\u000e\u0014Q!\u0011:sCf\u00042a`A\u0007\u001d\u0011\t\t!!\u0003\u0011\u0007\u0005\r1-\u0004\u0002\u0002\u0006)\u0019\u0011q\u0001/\u0002\rq\u0012xn\u001c;?\u0013\r\tYaY\u0001\u0007!J,G-\u001a4\n\u0007I\fyAC\u0002\u0002\f\r\fQ\u0002Z;naRKWM]*uCR,Gc\u0001<\u0002\u0016!9\u0011q\u0003\u0004A\u0002\u0005e\u0011\u0001\u00024jY\u0016\u0004B!a\u0007\u0002\"5\u0011\u0011Q\u0004\u0006\u0004\u0003?y\u0017AA5p\u0013\u0011\t\u0019#!\b\u0003\t\u0019KG.Z\u0001\rIVl\u0007\u000f\u0016=o\u0013:$W\r\u001f\u000b\u0004m\u0006%\u0002bBA\f\u000f\u0001\u0007\u0011\u0011D\u0001\u0017IVl\u0007\u000f\u0015:pIV\u001cWM]%e':\f\u0007o\u001d5piR\u0019a/a\f\t\u000f\u0005]\u0001\u00021\u0001\u0002\u001a\u0005IA-^7q\u0013:$W\r\u001f\u000b\fm\u0006U\u0012qGA!\u0003\u000b\n9\bC\u0004\u0002\u0018%\u0001\r!!\u0007\t\u000f\u0005e\u0012\u00021\u0001\u0002<\u0005y\u0011N\u001c3fqN\u000bg.\u001b;z\u001f:d\u0017\u0010E\u0002c\u0003{I1!a\u0010d\u0005\u001d\u0011un\u001c7fC:Dq!a\u0011\n\u0001\u0004\tY$\u0001\u0006wKJLg-_(oYfDq!a\u0012\n\u0001\u0004\tI%\u0001\u000enSNl\u0015\r^2iKN4uN]%oI\u0016Dh)\u001b7fg6\u000b\u0007\u000fE\u0004\u0002L\u0005Uc0!\u0017\u000e\u0005\u00055#\u0002BA(\u0003#\nq!\\;uC\ndWMC\u0002\u0002T\r\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9&!\u0014\u0003\u00075\u000b\u0007\u000f\u0005\u0004\u0002\\\u0005\u0015\u00141\u000e\b\u0005\u0003;\n\tG\u0004\u0003\u0002\u0004\u0005}\u0013\"\u00013\n\u0007\u0005\r4-A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0014\u0011\u000e\u0002\u0005\u0019&\u001cHOC\u0002\u0002d\r\u0004rAYA7\u0003c\n\t(C\u0002\u0002p\r\u0014a\u0001V;qY\u0016\u0014\u0004c\u00012\u0002t%\u0019\u0011QO2\u0003\t1{gn\u001a\u0005\b\u0003sJ\u0001\u0019AA>\u00039i\u0017\r_'fgN\fw-Z*ju\u0016\u00042AYA?\u0013\r\tyh\u0019\u0002\u0004\u0013:$\u0018!\u00043v[B$\u0016.\\3J]\u0012,\u0007\u0010F\u0005w\u0003\u000b\u000b9)!#\u0002\f\"9\u0011q\u0003\u0006A\u0002\u0005e\u0001bBA\u001d\u0015\u0001\u0007\u00111\b\u0005\b\u0003\u0007R\u0001\u0019AA\u001e\u0011\u001d\tiI\u0003a\u0001\u0003\u001f\u000b1\u0003^5nK&sG-\u001a=Ek6\u0004XI\u001d:peN\u00042!!%\u0015\u001b\u0005\t!a\u0005+j[\u0016Le\u000eZ3y\tVl\u0007/\u0012:s_J\u001c8C\u0001\u000bb)\t\ty)\u0001\u0010nSNl\u0015\r^2iKN4uN\u001d+j[\u0016Le\u000eZ3y\r&dWm]'baV\u0011\u0011Q\u0014\t\b\u0003\u0017\n)F`AP!\u0019\tY%!)\u0002l%!\u00111UA'\u0005-\t%O]1z\u0005V4g-\u001a:\u0002?5L7/T1uG\",7OR8s)&lW-\u00138eKb4\u0015\u000e\\3t\u001b\u0006\u0004\b%A\npkR|em\u0014:eKJ$\u0016.\\3ti\u0006l\u0007/\u0001\u000bpkR|em\u0014:eKJ$\u0016.\\3ti\u0006l\u0007\u000fI\u0001\u0016g\"\fG\u000e\\8x\u001f\u001a47/\u001a;O_R4u.\u001e8e\u0003Y\u0019\b.\u00197m_^|eMZ:fi:{GOR8v]\u0012\u0004\u0013a\u0006:fG>\u0014H-T5t[\u0006$8\r\u001b+j[\u0016Le\u000eZ3y)\u001d1\u00181WA[\u0003sCq!a\u0006\u001d\u0001\u0004\tI\u0002C\u0004\u00028r\u0001\r!!\u001d\u0002\u001d%tG-\u001a=US6,7\u000f^1na\"9\u00111\u0018\u000fA\u0002\u0005E\u0014\u0001\u00047pORKW.Z:uC6\u0004\u0018A\b:fG>\u0014HmT;u\u001f\u001a|%\u000fZ3s\u0013:$W\r\u001f+j[\u0016\u001cH/Y7q)\u001d1\u0018\u0011YAb\u0003\u000bDq!a\u0006\u001e\u0001\u0004\tI\u0002C\u0004\u00028v\u0001\r!!\u001d\t\u000f\u0005\u001dW\u00041\u0001\u0002r\u0005\u0011\u0002O]3w\u0013:$W\r\u001f+j[\u0016\u001cH/Y7q\u0003m\u0011XmY8sINC\u0017\r\u001c7po>3gm]3u\u001d>$hi\\;oIR9a/!4\u0002P\u0006M\u0007bBA\f=\u0001\u0007\u0011\u0011\u0004\u0005\b\u0003#t\u0002\u0019AA9\u0003-Ig\u000eZ3y\u001f\u001a47/\u001a;\t\u000f\u0005Ug\u00041\u0001\u0002r\u0005IAn\\4PM\u001a\u001cX\r^\u0001\faJLg\u000e^#se>\u00148\u000fF\u0001w\u00055iUm]:bO\u0016\u0004\u0016M]:feV1\u0011q\\Ay\u0005\u000f\u0019\"aC1\u0002\u000bA\f'o]3\u0015\t\u0005\u0015(1\u0002\t\bE\u00065\u0014q\u001dB\u0002!\u0015\u0011\u0017\u0011^Aw\u0013\r\tYo\u0019\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005=\u0018\u0011\u001f\u0007\u0001\t\u001d\t\u0019p\u0003b\u0001\u0003k\u0014\u0011aS\t\u0005\u0003o\fi\u0010E\u0002c\u0003sL1!a?d\u0005\u001dqu\u000e\u001e5j]\u001e\u00042AYA\u0000\u0013\r\u0011\ta\u0019\u0002\u0004\u0003:L\b#\u00022\u0002j\n\u0015\u0001\u0003BAx\u0005\u000f!qA!\u0003\f\u0005\u0004\t)PA\u0001W\u0011\u001d\u0011i\u0001\u0004a\u0001\u0005\u001f\taA]3d_J$\u0007\u0003\u0002B\t\u0005Gi!Aa\u0005\u000b\t\t5!Q\u0003\u0006\u0005\u0005/\u0011I\"\u0001\u0004d_6lwN\u001c\u0006\u00047\nm!\u0002\u0002B\u000f\u0005?\ta!\u00199bG\",'B\u0001B\u0011\u0003\ry'oZ\u0005\u0005\u0005K\u0011\u0019B\u0001\u0004SK\u000e|'\u000f\u001a\u0002\u0015\t\u0016\u001cw\u000eZ3s\u001b\u0016\u001c8/Y4f!\u0006\u00148/\u001a:\u0016\r\t-\"\u0011\u0007B\u001b'\u0011i\u0011M!\f\u0011\u000f\u0005E5Ba\f\u00034A!\u0011q\u001eB\u0019\t\u001d\t\u00190\u0004b\u0001\u0003k\u0004B!a<\u00036\u00119!\u0011B\u0007C\u0002\u0005U\u0018AC6fs\u0012+7m\u001c3feB1!1\bB!\u0005_i!A!\u0010\u000b\u0007\t}\",\u0001\u0006tKJL\u0017\r\\5{KJLAAa\u0011\u0003>\t9A)Z2pI\u0016\u0014\u0018\u0001\u0004<bYV,G)Z2pI\u0016\u0014\bC\u0002B\u001e\u0005\u0003\u0012\u0019\u0004\u0006\u0004\u0003L\t5#q\n\t\b\u0003#k!q\u0006B\u001a\u0011\u001d\u00119\u0004\u0005a\u0001\u0005sAqA!\u0012\u0011\u0001\u0004\u00119\u0005\u0006\u0003\u0003T\te\u0003c\u00022\u0002n\tU#q\u000b\t\u0006E\u0006%(q\u0006\t\u0006E\u0006%(1\u0007\u0005\b\u0005\u001b\t\u0002\u0019\u0001B\b\u0003\u001d!W/\u001c9M_\u001e$rB\u001eB0\u0005C\u0012)G!\u001b\u0003n\t\u0005%Q\u0011\u0005\b\u0003/\u0011\u0002\u0019AA\r\u0011\u001d\u0011\u0019G\u0005a\u0001\u0003w\tQ\u0002\u001d:j]R\u001cuN\u001c;f]R\u001c\bb\u0002B4%\u0001\u0007\u0011\u0011J\u0001\"]>t7i\u001c8tK\u000e,H/\u001b<f!\u0006L'o\u001d$pe2{wMR5mKNl\u0015\r\u001d\u0005\b\u0005W\u0012\u0002\u0019AA\u001e\u0003=I7\u000fR3fa&#XM]1uS>t\u0007b\u0002B8%\u0001\u0007!\u0011O\u0001\u0007a\u0006\u00148/\u001a:1\r\tM$q\u000fB?!\u001d\t\tj\u0003B;\u0005w\u0002B!a<\u0003x\u0011a!\u0011\u0010B7\u0003\u0003\u0005\tQ!\u0001\u0002v\n\u0019q\fJ\u0019\u0011\t\u0005=(Q\u0010\u0003\r\u0005\u007f\u0012i'!A\u0001\u0002\u000b\u0005\u0011Q\u001f\u0002\u0004?\u0012\u0012\u0004b\u0002BB%\u0001\u0007\u00111H\u0001\u0013g.L\u0007OU3d_J$W*\u001a;bI\u0006$\u0018\rC\u0004\u0003\bJ\u0001\r!a\u001f\u0002\u00115\f\u0007PQ=uKN\fq\u0002\u001d:j]R\u0014\u0015\r^2i\u0019\u00164X\r\u001c\u000b\u0006m\n5%q\u0014\u0005\b\u0005\u001f\u001b\u0002\u0019\u0001BI\u0003\u0015\u0011\u0017\r^2i!\u0011\u0011\u0019J!'\u000f\t\tE!QS\u0005\u0005\u0005/\u0013\u0019\"\u0001\nGS2,Gj\\4J]B,Ho\u0015;sK\u0006l\u0017\u0002\u0002BN\u0005;\u0013aCR5mK\u000eC\u0017M\u001c8fYJ+7m\u001c:e\u0005\u0006$8\r\u001b\u0006\u0005\u0005/\u0013\u0019\u0002C\u0004\u0003\"N\u0001\r!!\u001d\u0002#\u0005\u001c7-^7vY\u0006$\u0018N^3CsR,7O\u0001\u000bPM\u001a\u001cX\r^:NKN\u001c\u0018mZ3QCJ\u001cXM]\n\u0005A\u0005\u00149\u000bE\u0003\u0002\u0012.qh\u0010\u0006\u0002\u0003,B\u0019\u0011\u0011\u0013\u0011\u0015\t\t=&1\u0017\t\bE\u00065$\u0011\u0017BY!\u0011\u0011\u0017\u0011\u001e@\t\u000f\t5!\u00051\u0001\u0003\u0010\tYBK]1og\u0006\u001cG/[8o\u0019><W*Z:tC\u001e,\u0007+\u0019:tKJ\u001cBaI1\u0003(R\u0011!1\u0018\t\u0004\u0003#\u001bC\u0003\u0002BX\u0005\u007fCqA!\u0004&\u0001\u0004\u0011yAA\nRk>$\u0018m]'fgN\fw-\u001a)beN,'o\u0005\u0003'C\n\u001dFC\u0001Bd!\r\t\tJ\n\u000b\u0005\u0005_\u0013Y\rC\u0004\u0003\u000e!\u0002\rAa\u0004\u0003?\rcWo\u001d;fe6+G/\u00193bi\u0006dunZ'fgN\fw-\u001a)beN,'o\u0005\u0003*C\n\u001dFC\u0001Bj!\r\t\t*K\u0001\u0014[\u0016$\u0018\rZ1uCJ+7m\u001c:e'\u0016\u0014H-Z\u000b\u0003\u00053\u0004BAa7\u0003b6\u0011!Q\u001c\u0006\u0005\u0005?\u0014I\"\u0001\u0005nKR\fG-\u0019;b\u0013\u0011\u0011\u0019O!8\u0003'5+G/\u00193bi\u0006\u0014VmY8sIN+'\u000fZ3\u0002)5,G/\u00193bi\u0006\u0014VmY8sIN+'\u000fZ3!)\u0011\u0011yK!;\t\u000f\t5Q\u00061\u0001\u0003\u0010\t1B)^7q\u0019><7+Z4nK:$8o\u00149uS>t7oE\u0002/\u0005_\u0004BA!=\u0003x6\u0011!1\u001f\u0006\u0004\u0005kT\u0016!B;uS2\u001c\u0018\u0002\u0002B}\u0005g\u0014QcQ8n[\u0006tG\rR3gCVdGo\u00149uS>t7/C\u0002{\u0005o$BAa@\u0004\u0002A\u0019\u0011\u0011\u0013\u0018\t\u000bi\u0004\u0004\u0019A>\u0002\u0011A\u0014\u0018N\u001c;PaR,\"aa\u0002\u0011\t\r%1qB\u0007\u0003\u0007\u0017Q!a!\u0004\u0002\u0015)|\u0007\u000f^:j[BdW-\u0003\u0003\u0004\u0012\r-!!E(qi&|gn\u00159fG\n+\u0018\u000e\u001c3fe\u0006I\u0001O]5oi>\u0003H\u000fI\u0001\nm\u0016\u0014\u0018NZ=PaR\f!B^3sS\u001aLx\n\u001d;!\u00039Ig\u000eZ3y'\u0006t\u0017\u000e^=PaR\fq\"\u001b8eKb\u001c\u0016M\\5us>\u0003H\u000fI\u0001\tM&dWm](qiV\u00111\u0011\u0005\t\u0006\u0007\u0013\u0019\u0019C`\u0005\u0005\u0007K\u0019YAA\u000eBe\u001e,X.\u001a8u\u0003\u000e\u001cW\r\u001d;j]\u001e|\u0005\u000f^5p]N\u0003XmY\u0001\nM&dWm](qi\u0002\n\u0011#\\1y\u001b\u0016\u001c8/Y4f'&TXm\u00149u+\t\u0019i\u0003\u0005\u0004\u0004\n\r\r2q\u0006\t\u0004Y\u000eE\u0012bAB\u001a[\n9\u0011J\u001c;fO\u0016\u0014\u0018AE7bq6+7o]1hKNK'0Z(qi\u0002\n1\"\\1y\u0005f$Xm](qi\u0006aQ.\u0019=CsR,7o\u00149uA\u0005\u0001B-Z3q\u0013R,'/\u0019;j_:|\u0005\u000f^\u0001\u0012I\u0016,\u0007/\u0013;fe\u0006$\u0018n\u001c8PaR\u0004\u0013a\u0004<bYV,G)Z2pI\u0016\u0014x\n\u001d;\u0016\u0005\r\r\u0003#BB\u0005\u0007GY\u0017\u0001\u0005<bYV,G)Z2pI\u0016\u0014x\n\u001d;!\u00035YW-\u001f#fG>$WM](qi\u0006q1.Z=EK\u000e|G-\u001a:PaR\u0004\u0013AC8gMN,Go](qi\u0006YqN\u001a4tKR\u001cx\n\u001d;!\u0003E!(/\u00198tC\u000e$\u0018n\u001c8M_\u001e|\u0005\u000f^\u0001\u0013iJ\fgn]1di&|g\u000eT8h\u001fB$\b%\u0001\ndYV\u001cH/\u001a:NKR\fG-\u0019;b\u001fB$\u0018aE2mkN$XM]'fi\u0006$\u0017\r^1PaR\u0004\u0013!F:lSB\u0014VmY8sI6+G/\u00193bi\u0006|\u0005\u000f^\u0001\u0017g.L\u0007OU3d_J$W*\u001a;bI\u0006$\u0018m\u00149uA\u0005I\u0011/^8uCN|\u0005\u000f^\u0001\u000bcV|G/Y:PaR\u0004\u0013!D7fgN\fw-\u001a)beN,'/\u0006\u0002\u0004dA21QMB5\u0007_\u0002r!!%\f\u0007O\u001ai\u0007\u0005\u0003\u0002p\u000e%DaCB6\u001b\u0006\u0005\t\u0011!B\u0001\u0003k\u00141a\u0018\u00134!\u0011\tyoa\u001c\u0005\u0017\rET*!A\u0001\u0002\u000b\u0005\u0011Q\u001f\u0002\u0004?\u0012\"\u0014AE:i_VdG\r\u0015:j]R$\u0015\r^1M_\u001e,\"!a\u000f\u0002\u000b\u0019LG.Z:\u0016\u0005\rm\u0004c\u00012}WV\u0011\u00111P\u0001\nG\",7m[!sON\u0004")
public final class DumpLogSegments {
    public static void main(String[] stringArray) {
        DumpLogSegments$.MODULE$.main(stringArray);
    }

    private static class ClusterMetadataLogMessageParser
    implements MessageParser<String, String> {
        private final MetadataRecordSerde metadataRecordSerde = new MetadataRecordSerde();

        public MetadataRecordSerde metadataRecordSerde() {
            return this.metadataRecordSerde;
        }

        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            String string;
            try {
                ApiMessageAndVersion messageAndVersion = this.metadataRecordSerde().read((Readable)new ByteBufferAccessor(record.value()), record.valueSize());
                ObjectNode json = new ObjectNode(JsonNodeFactory.instance);
                json.set("type", (JsonNode)new TextNode(MetadataRecordType.fromId((short)messageAndVersion.message().apiKey()).toString()));
                json.set("version", (JsonNode)new IntNode((int)messageAndVersion.version()));
                json.set("data", MetadataJsonConverters.writeJson((ApiMessage)messageAndVersion.message(), (short)messageAndVersion.version()));
                string = json.toString();
            }
            catch (Throwable e) {
                string = new StringBuilder(21).append("Error at ").append(record.offset()).append(", skipping. ").append(e.getMessage()).toString();
            }
            String output = string;
            return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)output));
        }
    }

    private static class DecoderMessageParser<K, V>
    implements MessageParser<K, V> {
        private final Decoder<K> keyDecoder;
        private final Decoder<V> valueDecoder;

        @Override
        public Tuple2<Option<K>, Option<V>> parse(Record record) {
            None$ key;
            Object object = key = record.hasKey() ? new Some(this.keyDecoder.fromBytes(Utils.readBytes((ByteBuffer)record.key()))) : None$.MODULE$;
            if (!record.hasValue()) {
                return new Tuple2((Object)key, (Object)None$.MODULE$);
            }
            Some payload = new Some(this.valueDecoder.fromBytes(Utils.readBytes((ByteBuffer)record.value())));
            return new Tuple2((Object)key, (Object)payload);
        }

        public DecoderMessageParser(Decoder<K> keyDecoder, Decoder<V> valueDecoder) {
            this.keyDecoder = keyDecoder;
            this.valueDecoder = valueDecoder;
        }
    }

    private static class DumpLogSegmentsOptions
    extends CommandDefaultOptions {
        private boolean shouldPrintDataLog;
        private boolean skipRecordMetadata;
        private boolean isDeepIteration;
        private boolean verifyOnly;
        private boolean indexSanityOnly;
        private String[] files;
        private int maxMessageSize;
        private int maxBytes;
        private final OptionSpecBuilder printOpt = this.parser().accepts("print-data-log", "if set, printing the messages content when dumping data logs. Automatically set if any decoder option is specified.");
        private final OptionSpecBuilder verifyOpt = this.parser().accepts("verify-index-only", "if set, just verify the index log without printing its content.");
        private final OptionSpecBuilder indexSanityOpt = this.parser().accepts("index-sanity-check", "if set, just checks the index sanity without printing its content. This is the same check that is executed on broker startup to determine if an index needs rebuilding or not.");
        private final ArgumentAcceptingOptionSpec<String> filesOpt = this.parser().accepts("files", "REQUIRED: The comma separated list of files to be dumped. The supported file types include log files, index files, time index files, transaction index files, producer snapshots and tier state files.").withRequiredArg().describedAs("file1, file2, ...").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt = this.parser().accepts("max-message-size", "Size of largest message.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x500000), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> maxBytesOpt = this.parser().accepts("max-bytes", "Limit the amount of total batches read in bytes avoiding reading the whole .log file(s).").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(Integer.MAX_VALUE), (Object[])new Integer[0]);
        private final OptionSpecBuilder deepIterationOpt = this.parser().accepts("deep-iteration", "if set, uses deep instead of shallow iteration. Automatically set if print-data-log is enabled.");
        private final ArgumentAcceptingOptionSpec<String> valueDecoderOpt = this.parser().accepts("value-decoder-class", "if set, used to deserialize the messages. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)"kafka.serializer.StringDecoder", (Object[])new String[0]);
        private final ArgumentAcceptingOptionSpec<String> keyDecoderOpt = this.parser().accepts("key-decoder-class", "if set, used to deserialize the keys. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)"kafka.serializer.StringDecoder", (Object[])new String[0]);
        private final OptionSpecBuilder offsetsOpt = this.parser().accepts("offsets-decoder", "if set, log data will be parsed as offset data from the __consumer_offsets topic.");
        private final OptionSpecBuilder transactionLogOpt = this.parser().accepts("transaction-log-decoder", "if set, log data will be parsed as transaction metadata from the __transaction_state topic.");
        private final OptionSpecBuilder clusterMetadataOpt = this.parser().accepts("cluster-metadata-decoder", "if set, log data will be parsed as cluster metadata records.");
        private final OptionSpecBuilder skipRecordMetadataOpt = this.parser().accepts("skip-record-metadata", "whether to skip printing metadata for each record.");
        private final OptionSpecBuilder quotasOpt = this.parser().accepts("quotas-decoder", "if set, log data will be parsed as quotas data from the _confluent-quotas topic");
        private volatile byte bitmap$0;

        public OptionSpecBuilder printOpt() {
            return this.printOpt;
        }

        public OptionSpecBuilder verifyOpt() {
            return this.verifyOpt;
        }

        public OptionSpecBuilder indexSanityOpt() {
            return this.indexSanityOpt;
        }

        public ArgumentAcceptingOptionSpec<String> filesOpt() {
            return this.filesOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt() {
            return this.maxMessageSizeOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> maxBytesOpt() {
            return this.maxBytesOpt;
        }

        public OptionSpecBuilder deepIterationOpt() {
            return this.deepIterationOpt;
        }

        public ArgumentAcceptingOptionSpec<String> valueDecoderOpt() {
            return this.valueDecoderOpt;
        }

        public ArgumentAcceptingOptionSpec<String> keyDecoderOpt() {
            return this.keyDecoderOpt;
        }

        public OptionSpecBuilder offsetsOpt() {
            return this.offsetsOpt;
        }

        public OptionSpecBuilder transactionLogOpt() {
            return this.transactionLogOpt;
        }

        public OptionSpecBuilder clusterMetadataOpt() {
            return this.clusterMetadataOpt;
        }

        public OptionSpecBuilder skipRecordMetadataOpt() {
            return this.skipRecordMetadataOpt;
        }

        public OptionSpecBuilder quotasOpt() {
            return this.quotasOpt;
        }

        public MessageParser<?, ?> messageParser() {
            if (this.options().has((OptionSpec)this.offsetsOpt())) {
                return new OffsetsMessageParser();
            }
            if (this.options().has((OptionSpec)this.transactionLogOpt())) {
                return new TransactionLogMessageParser();
            }
            if (this.options().has((OptionSpec)this.clusterMetadataOpt())) {
                return new ClusterMetadataLogMessageParser();
            }
            if (this.options().has((OptionSpec)this.quotasOpt())) {
                return new QuotasMessageParser();
            }
            Decoder valueDecoder = (Decoder)CoreUtils$.MODULE$.createObject((String)this.options().valueOf(this.valueDecoderOpt()), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
            Decoder keyDecoder = (Decoder)CoreUtils$.MODULE$.createObject((String)this.options().valueOf(this.keyDecoderOpt()), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
            return new DecoderMessageParser(keyDecoder, valueDecoder);
        }

        private boolean shouldPrintDataLog$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.shouldPrintDataLog = this.options().has((OptionSpec)this.printOpt()) || this.options().has((OptionSpec)this.offsetsOpt()) || this.options().has((OptionSpec)this.transactionLogOpt()) || this.options().has((OptionSpec)this.clusterMetadataOpt()) || this.options().has((OptionSpec)this.quotasOpt()) || this.options().has(this.valueDecoderOpt()) || this.options().has(this.keyDecoderOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            return this.shouldPrintDataLog;
        }

        public boolean shouldPrintDataLog() {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                return this.shouldPrintDataLog$lzycompute();
            }
            return this.shouldPrintDataLog;
        }

        private boolean skipRecordMetadata$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.skipRecordMetadata = this.options().has((OptionSpec)this.skipRecordMetadataOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            return this.skipRecordMetadata;
        }

        public boolean skipRecordMetadata() {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                return this.skipRecordMetadata$lzycompute();
            }
            return this.skipRecordMetadata;
        }

        private boolean isDeepIteration$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 4) == 0) {
                    this.isDeepIteration = this.options().has((OptionSpec)this.deepIterationOpt()) || this.shouldPrintDataLog();
                    this.bitmap$0 = (byte)(this.bitmap$0 | 4);
                }
            }
            return this.isDeepIteration;
        }

        public boolean isDeepIteration() {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                return this.isDeepIteration$lzycompute();
            }
            return this.isDeepIteration;
        }

        private boolean verifyOnly$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 8) == 0) {
                    this.verifyOnly = this.options().has((OptionSpec)this.verifyOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 8);
                }
            }
            return this.verifyOnly;
        }

        public boolean verifyOnly() {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                return this.verifyOnly$lzycompute();
            }
            return this.verifyOnly;
        }

        private boolean indexSanityOnly$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x10) == 0) {
                    this.indexSanityOnly = this.options().has((OptionSpec)this.indexSanityOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
                }
            }
            return this.indexSanityOnly;
        }

        public boolean indexSanityOnly() {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                return this.indexSanityOnly$lzycompute();
            }
            return this.indexSanityOnly;
        }

        private String[] files$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x20) == 0) {
                    this.files = ((String)this.options().valueOf(this.filesOpt())).split(",");
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
                }
            }
            return this.files;
        }

        public String[] files() {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                return this.files$lzycompute();
            }
            return this.files;
        }

        private int maxMessageSize$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x40) == 0) {
                    this.maxMessageSize = (Integer)this.options().valueOf(this.maxMessageSizeOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
                }
            }
            return this.maxMessageSize;
        }

        public int maxMessageSize() {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                return this.maxMessageSize$lzycompute();
            }
            return this.maxMessageSize;
        }

        private int maxBytes$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x80) == 0) {
                    this.maxBytes = (Integer)this.options().valueOf(this.maxBytesOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x80);
                }
            }
            return this.maxBytes;
        }

        public int maxBytes() {
            if ((byte)(this.bitmap$0 & 0x80) == 0) {
                return this.maxBytes$lzycompute();
            }
            return this.maxBytes;
        }

        public void checkArgs() {
            CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.filesOpt()}));
        }

        public DumpLogSegmentsOptions(String[] args) {
            super(args, CommandDefaultOptions$.MODULE$.$lessinit$greater$default$2());
            this.options_$eq(this.parser().parse(super.args()));
        }
    }

    public static interface MessageParser<K, V> {
        public Tuple2<Option<K>, Option<V>> parse(Record var1);
    }

    private static class OffsetsMessageParser
    implements MessageParser<String, String> {
        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            return GroupMetadataManager$.MODULE$.formatRecordKeyAndValue(record);
        }
    }

    private static class QuotasMessageParser
    implements MessageParser<String, String> {
        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            return QuotaStateManager$.MODULE$.formatRecordKeyAndValue(record);
        }
    }

    public static class TimeIndexDumpErrors {
        private final Map<String, ArrayBuffer<Tuple2<Object, Object>>> misMatchesForTimeIndexFilesMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        private final Map<String, ArrayBuffer<Tuple2<Object, Object>>> outOfOrderTimestamp = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        private final Map<String, ArrayBuffer<Tuple2<Object, Object>>> shallowOffsetNotFound = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);

        public Map<String, ArrayBuffer<Tuple2<Object, Object>>> misMatchesForTimeIndexFilesMap() {
            return this.misMatchesForTimeIndexFilesMap;
        }

        public Map<String, ArrayBuffer<Tuple2<Object, Object>>> outOfOrderTimestamp() {
            return this.outOfOrderTimestamp;
        }

        public Map<String, ArrayBuffer<Tuple2<Object, Object>>> shallowOffsetNotFound() {
            return this.shallowOffsetNotFound;
        }

        public void recordMismatchTimeIndex(File file, long indexTimestamp, long logTimestamp) {
            ArrayBuffer misMatchesSeq = (ArrayBuffer)this.misMatchesForTimeIndexFilesMap().getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
            if (misMatchesSeq.isEmpty()) {
                this.misMatchesForTimeIndexFilesMap().put((Object)file.getAbsolutePath(), (Object)misMatchesSeq);
            }
            misMatchesSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexTimestamp, logTimestamp));
        }

        public void recordOutOfOrderIndexTimestamp(File file, long indexTimestamp, long prevIndexTimestamp) {
            ArrayBuffer outOfOrderSeq = (ArrayBuffer)this.outOfOrderTimestamp().getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
            if (outOfOrderSeq.isEmpty()) {
                this.outOfOrderTimestamp().put((Object)file.getAbsolutePath(), (Object)outOfOrderSeq);
            }
            outOfOrderSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexTimestamp, prevIndexTimestamp));
        }

        public void recordShallowOffsetNotFound(File file, long indexOffset, long logOffset) {
            ArrayBuffer shallowOffsetNotFoundSeq = (ArrayBuffer)this.shallowOffsetNotFound().getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
            if (shallowOffsetNotFoundSeq.isEmpty()) {
                this.shallowOffsetNotFound().put((Object)file.getAbsolutePath(), (Object)shallowOffsetNotFoundSeq);
            }
            shallowOffsetNotFoundSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexOffset, logOffset));
        }

        public void printErrors() {
            this.misMatchesForTimeIndexFilesMap().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$1(x0$1);
                return BoxedUnit.UNIT;
            });
            this.outOfOrderTimestamp().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$3(x0$2);
                return BoxedUnit.UNIT;
            });
            this.shallowOffsetNotFound().values().foreach((Function1 & Serializable & scala.Serializable)listOfShallowOffsetNotFound -> {
                TimeIndexDumpErrors.$anonfun$printErrors$5(listOfShallowOffsetNotFound);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ void $anonfun$printErrors$1(Tuple2 x0$1) {
            if (x0$1 != null) {
                String fileName = (String)x0$1._1();
                ArrayBuffer listOfMismatches = (ArrayBuffer)x0$1._2();
                System.err.println(new StringBuilder(29).append("Found timestamp mismatch in :").append(fileName).toString());
                listOfMismatches.foreach((Function1 & Serializable & scala.Serializable)m -> {
                    System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index timestamp: %d, log timestamp: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printErrors$3(Tuple2 x0$2) {
            if (x0$2 != null) {
                String fileName = (String)x0$2._1();
                ArrayBuffer outOfOrderTimestamps = (ArrayBuffer)x0$2._2();
                System.err.println(new StringBuilder(33).append("Found out of order timestamp in :").append(fileName).toString());
                outOfOrderTimestamps.foreach((Function1 & Serializable & scala.Serializable)m -> {
                    System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index timestamp: %d, Previously indexed timestamp: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printErrors$6(Tuple2 x0$3) {
            if (x0$3 != null) {
                long indexedOffset = x0$3._1$mcJ$sp();
                long logOffset = x0$3._2$mcJ$sp();
                System.err.println(new StringBuilder(36).append("Indexed offset: ").append(indexedOffset).append(", found log offset: ").append(logOffset).toString());
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printErrors$5(ArrayBuffer listOfShallowOffsetNotFound) {
            System.err.println("The following indexed offsets are not found in the log.");
            listOfShallowOffsetNotFound.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$6(x0$3);
                return BoxedUnit.UNIT;
            });
        }
    }

    private static class TransactionLogMessageParser
    implements MessageParser<String, String> {
        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            return TransactionLog$.MODULE$.formatRecordKeyAndValue(record);
        }
    }
}

