/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.UUID;
import kafka.cluster.Partition;
import kafka.common.NoSuchLogSegmentException;
import kafka.log.AbstractLog;
import kafka.log.LogSegment;
import kafka.log.UploadableSegment;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.exceptions.NotTierablePartitionException;
import kafka.tier.exceptions.TierArchiverFailedException;
import kafka.tier.exceptions.TierArchiverFatalException;
import kafka.tier.exceptions.TierArchiverFatalException$;
import kafka.tier.exceptions.TierArchiverFencedException;
import kafka.tier.exceptions.TierArchiverFencedException$;
import kafka.tier.exceptions.TierArchiverRestoreFencedException;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiveTaskState;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.FailedState;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.TraversableOnce;
import scala.compat.java8.FutureConverters;
import scala.compat.java8.FutureConverters$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;

public final class ArchiveTask$
implements Logging {
    public static ArchiveTask$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ArchiveTask$();
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return ArchiveTask.class.getName();
    }

    public ArchiveTask apply(CancellationContext ctx, TopicIdPartition topicIdPartition, int leaderEpoch, ArchiverMetrics archiverMetrics, int brokerId) {
        return new ArchiveTask(ctx, topicIdPartition, new BeforeLeader(leaderEpoch), archiverMetrics, brokerId);
    }

    public Future<ArchiveTaskState> checkFailedState(FailedState state, TopicIdPartition topicIdPartition, ReplicaManager replicaManager) {
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Product)replicaManager.getLog(topicIdPartition.topicPartition()).map((Function1 & Serializable & scala.Serializable)log -> {
            int tierEpoch = log.tierPartitionState().tierEpoch();
            int leaderEpoch = state.leaderEpoch();
            if (log.tierPartitionState().status().hasError()) {
                throw new TierArchiverFailedException(topicIdPartition);
            }
            if (tierEpoch > leaderEpoch) {
                throw new TierArchiverFencedException(topicIdPartition, TierArchiverFencedException$.MODULE$.$lessinit$greater$default$2());
            }
            if (tierEpoch == leaderEpoch) {
                return new BeforeUpload(leaderEpoch);
            }
            if (tierEpoch < leaderEpoch) {
                return new BeforeLeader(leaderEpoch);
            }
            throw new TierArchiverFatalException(new StringBuilder(81).append("attempted to transition from a FailedState for ").append(topicIdPartition).append(" while in non-transitionable state").toString(), TierArchiverFatalException$.MODULE$.$lessinit$greater$default$2());
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> state)));
    }

    public Future<BeforeUpload> establishLeadership(BeforeLeader state, TopicIdPartition topicIdPartition, TierTopicAppender tierTopicAppender, int brokerId, ReplicaManager replicaManager, ExecutionContext ec) {
        return Future$.MODULE$.unit().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> {
            Either<Errors, Partition> either = replicaManager.getPartitionOrError(topicIdPartition.topicPartition());
            if (either instanceof Left) {
                Errors error = (Errors)((Left)either).value();
                throw new TierArchiverFencedException(topicIdPartition, (Throwable)error.exception());
            }
            if (!(either instanceof Right)) {
                throw new MatchError(either);
            }
            Partition partition = (Partition)((Right)either).value();
            Future future = FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(tierTopicAppender.addMetadata(new TierTopicInitLeader(topicIdPartition, state.leaderEpoch(), UUID.randomUUID(), brokerId, OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(partition.metadataOffsetAndEpoch())))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (((Object)((Object)TierPartitionState.AppendResult.ACCEPTED)).equals(x0$1)) {
                    ArchiveTask$ archiveTask$ = MODULE$;
                    if (archiveTask$ == null) {
                        throw null;
                    }
                    ArchiveTask$ info_this = archiveTask$;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent(ArchiveTask$.$anonfun$establishLeadership$3(topicIdPartition)));
                    }
                } else {
                    if (((Object)((Object)TierPartitionState.AppendResult.FAILED)).equals(x0$1)) {
                        throw new TierArchiverFailedException(topicIdPartition);
                    }
                    if (((Object)((Object)TierPartitionState.AppendResult.NOT_TIERABLE)).equals(x0$1)) {
                        throw new NotTierablePartitionException(topicIdPartition);
                    }
                    if (((Object)((Object)TierPartitionState.AppendResult.FENCED)).equals(x0$1)) {
                        throw new TierArchiverFencedException(topicIdPartition, TierArchiverFencedException$.MODULE$.$lessinit$greater$default$2());
                    }
                    if (((Object)((Object)TierPartitionState.AppendResult.RESTORE_FENCED)).equals(x0$1)) {
                        throw new TierArchiverRestoreFencedException(topicIdPartition);
                    }
                    throw new TierArchiverFatalException(new StringBuilder(21).append("Unknown AppendResult ").append(x0$1).toString(), TierArchiverFatalException$.MODULE$.$lessinit$greater$default$2());
                }
                BeforeUpload beforeUpload = new BeforeUpload(state.leaderEpoch());
                return beforeUpload;
            }, ec);
            return future;
        }, ec);
    }

    public Future<ArchiveTaskState> maybeInitiateUpload(BeforeUpload state, TopicIdPartition topicIdPartition, Time time, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, ReplicaManager replicaManager, ExecutionContext ec) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Either<Errors, Partition> either = replicaManager.getPartitionOrError(topicIdPartition.topicPartition());
            if (either instanceof Left) {
                Errors error = (Errors)((Left)either).value();
                throw new TierArchiverFencedException(topicIdPartition, (Throwable)error.exception());
            }
            if (!(either instanceof Right)) throw new MatchError(either);
            Partition partition = (Partition)((Right)either).value();
            if (partition.isUncleanLeader()) {
                throw new TierMetadataRetriableException(new StringBuilder(53).append("Backing off as ").append(topicIdPartition).append(" is undergoing unclean leader recovery").toString());
            }
            Option option = partition.log().flatMap((Function1 & Serializable & scala.Serializable)log -> {
                if (!log.tierPartitionState().isTieringEnabled()) {
                    throw new NotTierablePartitionException(topicIdPartition);
                }
                if (log.tierPartitionState().tierEpoch() != state.leaderEpoch()) {
                    throw new TierArchiverFencedException(topicIdPartition, TierArchiverFencedException$.MODULE$.$lessinit$greater$default$2());
                }
                OffsetAndEpoch stateOffset = log.tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch();
                return ((TraversableOnce)log.tierableLogSegments().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ArchiveTask$.$anonfun$maybeInitiateUpload$3(x$3)))).collectFirst((PartialFunction)new scala.Serializable((AbstractLog)log, stateOffset){
                    public static final long serialVersionUID = 0L;
                    private final AbstractLog log$1;
                    private final OffsetAndEpoch stateOffset$1;

                    public final <A1 extends LogSegment, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object = x1 != null ? new Tuple3((Object)this.log$1, (Object)this.stateOffset$1, x1) : function1.apply(null);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogSegment x1) {
                        boolean bl = x1 != null;
                        return bl;
                    }
                    {
                        this.log$1 = log$1;
                        this.stateOffset$1 = stateOffset$1;
                    }
                });
            });
            if (None$.MODULE$.equals(option)) {
                ArchiveTask$ archiveTask$ = MODULE$;
                if (archiveTask$ == null) {
                    throw null;
                }
                ArchiveTask$ debug_this = archiveTask$;
                if (!debug_this.logger().underlying().isDebugEnabled()) return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> state, ec);
                debug_this.logger().underlying().debug(debug_this.msgWithLogIdent(ArchiveTask$.$anonfun$maybeInitiateUpload$4(topicIdPartition)));
                return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> state, ec);
            }
            if (!(option instanceof Some)) throw new MatchError((Object)option);
            Tuple3 tuple3 = (Tuple3)((Some)option).value();
            if (tuple3 == null) throw new MatchError((Object)option);
            AbstractLog log2 = (AbstractLog)tuple3._1();
            OffsetAndEpoch stateOffset = (OffsetAndEpoch)tuple3._2();
            LogSegment logSegment = (LogSegment)tuple3._3();
            if (log2 == null) throw new MatchError((Object)option);
            if (stateOffset == null) throw new MatchError((Object)option);
            if (logSegment == null) throw new MatchError((Object)option);
            UploadableSegment segment = MODULE$.uploadableSegment(log2, logSegment, topicIdPartition);
            if (log2.isDeleted()) {
                throw new NotTierablePartitionException(topicIdPartition);
            }
            TierObjectStore.OpaqueData opaqueData = (TierObjectStore.OpaqueData)Option$.MODULE$.apply((Object)tierObjectStore.prepPutSegment()).getOrElse((Function0 & Serializable & scala.Serializable)() -> TierObjectStore.OpaqueData.ZEROED);
            TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, state.leaderEpoch(), UUID.randomUUID(), logSegment.baseOffset(), segment.nextOffset() - 1L, logSegment.largestTimestamp(), logSegment.getFirstBatchTimestamp(), logSegment.size(), segment.leaderEpochStateOpt().isDefined(), segment.abortedTxnIndexOpt().isDefined(), segment.producerStateOpt().isDefined(), TierUploadType.Archive, stateOffset, opaqueData);
            long startTimeMs = time.milliseconds();
            return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(tierTopicAppender.addMetadata(uploadInitiate))))).flatMap((Function1 & Serializable & scala.Serializable)x -> (Future)Predef$.MODULE$.identity(x), ec).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (((Object)((Object)TierPartitionState.AppendResult.ACCEPTED)).equals(x0$1)) {
                    ArchiveTask$ archiveTask$ = MODULE$;
                    if (archiveTask$ == null) {
                        throw null;
                    }
                    ArchiveTask$ info_this = archiveTask$;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent(ArchiveTask$.$anonfun$maybeInitiateUpload$10(uploadInitiate, topicIdPartition, time, startTimeMs)));
                    }
                } else {
                    if (((Object)((Object)TierPartitionState.AppendResult.FAILED)).equals(x0$1)) {
                        throw new TierArchiverFailedException(topicIdPartition);
                    }
                    if (((Object)((Object)TierPartitionState.AppendResult.NOT_TIERABLE)).equals(x0$1)) {
                        throw new NotTierablePartitionException(topicIdPartition);
                    }
                    if (((Object)((Object)TierPartitionState.AppendResult.FENCED)).equals(x0$1)) {
                        throw new TierArchiverFencedException(topicIdPartition, TierArchiverFencedException$.MODULE$.$lessinit$greater$default$2());
                    }
                    if (((Object)((Object)TierPartitionState.AppendResult.RESTORE_FENCED)).equals(x0$1)) {
                        throw new TierArchiverRestoreFencedException(topicIdPartition);
                    }
                    throw new MatchError((Object)x0$1);
                }
                Upload upload = new Upload(state.leaderEpoch(), uploadInitiate, segment);
                return upload;
            }, ec);
        }, ec).flatMap((Function1 & Serializable & scala.Serializable)x -> (Future)Predef$.MODULE$.identity(x), ec);
    }

    public Future<AfterUpload> upload(Upload state, TopicIdPartition topicIdPartition, Time time, CancellationContext ctx, TierObjectStore tierObjectStore, ExecutionContext ec) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            UploadableSegment uploadableSegment = state.uploadableSegment();
            TierSegmentUploadInitiate uploadInitiate = state.uploadInitiate();
            TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(uploadInitiate.topicIdPartition(), uploadInitiate.objectId(), uploadInitiate.tierEpoch(), uploadInitiate.baseOffset(), uploadableSegment.abortedTxnIndexOpt().isDefined(), uploadableSegment.producerStateOpt().isDefined(), uploadableSegment.leaderEpochStateOpt().isDefined(), state.uploadInitiate().opaqueData());
            return (AfterUpload)package$.MODULE$.blocking((Function0 & Serializable & scala.Serializable)() -> {
                if (ctx.isCancelled()) {
                    throw new TierArchiverFencedException(topicIdPartition, TierArchiverFencedException$.MODULE$.$lessinit$greater$default$2());
                }
                long startTimeMs = time.milliseconds();
                try {
                    tierObjectStore.putSegment(metadata, uploadableSegment.logSegmentFile(), uploadableSegment.offsetIndex(), uploadableSegment.timeIndex(), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(uploadableSegment.producerStateOpt())), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(uploadableSegment.abortedTxnIndexOpt().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.duplicate()))), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(uploadableSegment.leaderEpochStateOpt().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.duplicate()))));
                }
                catch (Throwable throwable) {
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        if (!MODULE$.segmentFilesExist(state.uploadableSegment())) {
                            throw new ArchiveTask.SegmentDeletedException(new StringBuilder(33).append("Segment ").append(uploadableSegment.logSegmentFile().getAbsolutePath()).append(" of ").append(topicIdPartition).append(" deleted when tiering").toString(), exception);
                        }
                    }
                    throw throwable;
                }
                ArchiveTask$ archiveTask$ = MODULE$;
                if (archiveTask$ == null) {
                    throw null;
                }
                ArchiveTask$ info_this = archiveTask$;
                if (info_this.logger().underlying().isInfoEnabled()) {
                    info_this.logger().underlying().info(info_this.msgWithLogIdent(ArchiveTask$.$anonfun$upload$5(topicIdPartition, time, startTimeMs)));
                }
                return new AfterUpload(state.leaderEpoch(), uploadInitiate, state.uploadableSegment().uploadedSize());
            });
        }, ec);
    }

    public Future<BeforeUpload> finalizeUpload(AfterUpload state, TopicIdPartition topicIdPartition, Time time, TierTopicAppender tierTopicAppender, Option<Meter> byteRateMetric, ExecutionContext ec) {
        TierSegmentUploadComplete uploadComplete = new TierSegmentUploadComplete(state.uploadInitiate());
        long startTimeMs = time.milliseconds();
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(tierTopicAppender.addMetadata(uploadComplete))))).flatMap((Function1 & Serializable & scala.Serializable)x -> (Future)Predef$.MODULE$.identity(x), ec).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (((Object)((Object)TierPartitionState.AppendResult.ACCEPTED)).equals(x0$1)) {
                ArchiveTask$ archiveTask$ = MODULE$;
                if (archiveTask$ == null) {
                    throw null;
                }
                ArchiveTask$ info_this = archiveTask$;
                if (info_this.logger().underlying().isInfoEnabled()) {
                    info_this.logger().underlying().info(info_this.msgWithLogIdent(ArchiveTask$.$anonfun$finalizeUpload$4(uploadComplete, topicIdPartition, time, startTimeMs)));
                }
            } else {
                if (((Object)((Object)TierPartitionState.AppendResult.FAILED)).equals(x0$1)) {
                    throw new TierArchiverFailedException(topicIdPartition);
                }
                if (((Object)((Object)TierPartitionState.AppendResult.NOT_TIERABLE)).equals(x0$1)) {
                    throw new NotTierablePartitionException(topicIdPartition);
                }
                if (((Object)((Object)TierPartitionState.AppendResult.FENCED)).equals(x0$1)) {
                    throw new TierArchiverFencedException(topicIdPartition, TierArchiverFencedException$.MODULE$.$lessinit$greater$default$2());
                }
                if (((Object)((Object)TierPartitionState.AppendResult.RESTORE_FENCED)).equals(x0$1)) {
                    throw new TierArchiverRestoreFencedException(topicIdPartition);
                }
                throw new MatchError((Object)x0$1);
            }
            byteRateMetric.foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                x$6.mark(state.uploadedSize());
                return BoxedUnit.UNIT;
            });
            BeforeUpload beforeUpload = new BeforeUpload(state.leaderEpoch());
            return beforeUpload;
        }, ec);
    }

    public UploadableSegment uploadableSegment(AbstractLog log, LogSegment logSegment, TopicIdPartition topicIdPartition) {
        try {
            return log.createUploadableSegment(logSegment);
        }
        catch (NoSuchLogSegmentException e) {
            throw new ArchiveTask.SegmentDeletedException(new StringBuilder(33).append("Segment ").append(logSegment).append(" of ").append(topicIdPartition).append(" deleted when tiering").toString(), e);
        }
    }

    private boolean segmentFilesExist(UploadableSegment uploadableSegment) {
        return uploadableSegment.allFiles().forall((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.exists()));
    }

    public static final /* synthetic */ String $anonfun$establishLeadership$3(TopicIdPartition topicIdPartition$2) {
        return new StringBuilder(27).append("established leadership for ").append(topicIdPartition$2).toString();
    }

    public static final /* synthetic */ boolean $anonfun$maybeInitiateUpload$3(LogSegment x$3) {
        return x$3.size() != 0;
    }

    public static final /* synthetic */ String $anonfun$maybeInitiateUpload$4(TopicIdPartition topicIdPartition$3) {
        return new StringBuilder(78).append("Retrying BeforeUpload for ").append(topicIdPartition$3).append(" as log has moved or no tierable segments were found").toString();
    }

    public static final /* synthetic */ String $anonfun$maybeInitiateUpload$10(TierSegmentUploadInitiate uploadInitiate$1, TopicIdPartition topicIdPartition$3, Time time$2, long startTimeMs$1) {
        return new StringBuilder(21).append("Completed ").append(uploadInitiate$1).append(" for ").append(topicIdPartition$3).append(" in ").append(time$2.milliseconds() - startTimeMs$1).append("ms").toString();
    }

    public static final /* synthetic */ String $anonfun$upload$5(TopicIdPartition topicIdPartition$4, Time time$3, long startTimeMs$2) {
        return new StringBuilder(27).append("Uploaded segment for ").append(topicIdPartition$4).append(" in ").append(time$3.milliseconds() - startTimeMs$2).append("ms").toString();
    }

    public static final /* synthetic */ String $anonfun$finalizeUpload$4(TierSegmentUploadComplete uploadComplete$1, TopicIdPartition topicIdPartition$5, Time time$4, long startTimeMs$3) {
        return new StringBuilder(22).append("Finalized ").append(uploadComplete$1).append(" for ").append(topicIdPartition$5).append(" in ").append(time$4.milliseconds() - startTimeMs$3).append(" ms").toString();
    }

    private ArchiveTask$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

