/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.backupobjectlifecycle;

import java.util.Random;

public class RetryPolicy {
    private final int maxRetries;
    private final long retryBackoffMaxMs;
    private final long retryBackoffMinMs;

    public RetryPolicy(int maxRetries, long retryBackoffMaxMs, long retryBackoffMinMs) {
        this.maxRetries = maxRetries;
        this.retryBackoffMaxMs = retryBackoffMaxMs;
        this.retryBackoffMinMs = retryBackoffMinMs;
    }

    public int maxRetries() {
        return this.maxRetries;
    }

    public long backOffMs(int attempts) {
        int randomFactor = 1000 + new Random().nextInt(1000);
        return Math.min(this.retryBackoffMaxMs, Math.max(this.retryBackoffMinMs, (long)Math.pow(2.0, attempts) * (long)randomFactor));
    }
}

