/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.backupobjectlifecycle;

import java.util.function.Function;
import org.apache.kafka.common.errors.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryFramework<U, V> {
    int maxRetries;
    private static final Logger log = LoggerFactory.getLogger(RetryFramework.class);

    public RetryFramework(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public V call(Function<U, V> fn, U u) throws InterruptedException {
        int numRetries = 0;
        V v = null;
        while (numRetries <= this.maxRetries) {
            try {
                v = fn.apply(u);
                break;
            }
            catch (TimeoutException e) {
                if (++numRetries <= this.maxRetries) {
                    log.warn(e.getMessage() + " Retry " + numRetries);
                    Thread.sleep(500L);
                    continue;
                }
                throw e;
            }
        }
        return v;
    }
}

