/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kafka.log.AbstractLog;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.AbstractFetchDataInfo;
import kafka.server.BrokerReconfigurable;
import kafka.server.FetchDataInfo;
import kafka.server.FetchHighWatermark$;
import kafka.server.HostedPartition;
import kafka.server.HostedPartition$None$;
import kafka.server.HostedPartition$Offline$;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.tier.Config;
import kafka.tier.DeletedPartitionsChangeListener;
import kafka.tier.DeletionState;
import kafka.tier.ImmigratedTierTopicPartition;
import kafka.tier.InProgressDeletion;
import kafka.tier.InProgressDeletion$;
import kafka.tier.MaterializationComplete$;
import kafka.tier.TierDeletedPartitionsCoordinator$;
import kafka.tier.TierObjectGarbageCollector;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierPartitionDeleteComplete;
import kafka.tier.domain.TierPartitionDeleteInitiate;
import kafka.tier.domain.TierPartitionDeletePreInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicConsumer;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.OffsetAndEpoch;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r=c\u0001B\"E\u0001%C\u0001B\u0019\u0001\u0003\u0002\u0003\u0006Ia\u0019\u0005\tM\u0002\u0011\t\u0011)A\u0005O\"A!\u000e\u0001B\u0001B\u0003%1\u000e\u0003\u0005r\u0001\t\u0005\t\u0015!\u0003s\u0011!)\bA!A!\u0002\u00131\b\u0002C=\u0001\u0005\u0003\u0005\u000b\u0011\u0002:\t\u0011i\u0004!\u0011!Q\u0001\nmD!\"!\u0004\u0001\u0005\u0003\u0005\u000b\u0011BA\b\u0011)\t9\u0003\u0001B\u0001B\u0003%\u0011\u0011\u0006\u0005\b\u0003{\u0001A\u0011AA \u0011%\t)\u0006\u0001b\u0001\n\u0013\t9\u0006\u0003\u0005\u0002r\u0001\u0001\u000b\u0011BA-\u0011%\t\u0019\b\u0001b\u0001\n\u0013\t)\b\u0003\u0005\u0002~\u0001\u0001\u000b\u0011BA<\u0011%\ty\b\u0001b\u0001\n\u0013\t\t\t\u0003\u0005\u0002\u000e\u0002\u0001\u000b\u0011BAB\u0011-\ty\t\u0001a\u0001\u0002\u0004%I!!%\t\u0017\u0005e\u0005\u00011AA\u0002\u0013%\u00111\u0014\u0005\f\u0003O\u0003\u0001\u0019!A!B\u0013\t\u0019\nC\u0005\u0002*\u0002\u0001\r\u0011\"\u0003\u0002,\"I\u0011Q\u0016\u0001A\u0002\u0013%\u0011q\u0016\u0005\b\u0003g\u0003\u0001\u0015)\u0003s\u0011%\t)\f\u0001a\u0001\n\u0013\t9\fC\u0005\u0002:\u0002\u0001\r\u0011\"\u0003\u0002<\"9\u0011q\u0018\u0001!B\u00131\bBCAa\u0001\t\u0007I\u0011\u0001#\u0002D\"A\u00111\u001c\u0001!\u0002\u0013\t)\rC\u0006\u0002^\u0002\u0001\r\u00111A\u0005\n\u0005}\u0007b\u0003B\u0006\u0001\u0001\u0007\t\u0019!C\u0005\u0005\u001bA1\"a=\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002b\"I!\u0011\u0004\u0001A\u0002\u0013%!1\u0004\u0005\n\u0005G\u0001\u0001\u0019!C\u0005\u0005KA\u0001B!\u000b\u0001A\u0003&!Q\u0004\u0005\b\u0005[\u0001A\u0011\tB\u0018\u0011\u001d\u0011I\u0004\u0001C!\u0005wAqAa\u0012\u0001\t\u0003\u0012I\u0005C\u0004\u0003R\u0001!\tAa\u0015\t\u000f\tU\u0003\u0001\"\u0001\u0003X!9!Q\f\u0001\u0005\u0002\t}\u0003b\u0002B2\u0001\u0011\u0005!Q\r\u0005\b\u0005S\u0002A\u0011\u0001B*\u0011\u001d\u0011Y\u0007\u0001C\u0005\u0005[B\u0011Ba\u001d\u0001#\u0003%IA!\u001e\t\u000f\t-\u0005\u0001\"\u0003\u0003T!A!Q\u0012\u0001\u0005\u0002\u0011\u0013\u0019\u0006\u0003\u0005\u0003\u0010\u0002!\t\u0001\u0012B*\u0011\u001d\u0011\t\n\u0001C\u0005\u0005'BqAa%\u0001\t\u0013\u0011\u0019\u0006\u0003\u0005\u0003\u0016\u0002!\t\u0001\u0012BL\u0011!\u0011y\f\u0001C\u0001\t\nM\u0003\u0002\u0003Ba\u0001\u0011\u0005AIa\u0015\t\u0011\t\r\u0007\u0001\"\u0001E\u0005'B\u0001B!2\u0001\t\u0003!%q\u0019\u0005\t\u0005O\u0004A\u0011\u0001#\u0003j\"A!Q\u001f\u0001\u0005\u0002\u0011\u00139\u0010\u0003\u0005\u0004\u0002\u0001!\t\u0001RB\u0002\u0011!\u00119\u0005\u0001C\u0001\t\u000e%\u0001bBB\b\u0001\u0011%1\u0011\u0003\u0005\b\u00073\u0001A\u0011BB\u000e\u0011\u001d\u0019\u0019\u0003\u0001C\u0005\u0007K9qa!\rE\u0011\u0003\u0019\u0019D\u0002\u0004D\t\"\u00051Q\u0007\u0005\b\u0003{qD\u0011AB\u001c\u0011%\u0019ID\u0010b\u0001\n\u0003\u0019Y\u0004\u0003\u0005\u0004Hy\u0002\u000b\u0011BB\u001f\u0011%\u0019IEPI\u0001\n\u0003\u0019YE\u0001\u0011US\u0016\u0014H)\u001a7fi\u0016$\u0007+\u0019:uSRLwN\\:D_>\u0014H-\u001b8bi>\u0014(BA#G\u0003\u0011!\u0018.\u001a:\u000b\u0003\u001d\u000bQa[1gW\u0006\u001c\u0001aE\u0003\u0001\u0015B3F\f\u0005\u0002L\u001d6\tAJC\u0001N\u0003\u0015\u00198-\u00197b\u0013\tyEJ\u0001\u0004B]f\u0014VM\u001a\t\u0003#Rk\u0011A\u0015\u0006\u0003'\u001a\u000bQ!\u001e;jYNL!!\u0016*\u0003\u000f1{wmZ5oOB\u0011qKW\u0007\u00021*\u0011\u0011LR\u0001\b[\u0016$(/[2t\u0013\tY\u0006LA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkB\u0004\"!\u00181\u000e\u0003yS!a\u0018$\u0002\rM,'O^3s\u0013\t\tgL\u0001\u000bCe>\\WM\u001d*fG>tg-[4ve\u0006\u0014G.Z\u0001\ng\u000eDW\rZ;mKJ\u0004\"!\u00153\n\u0005\u0015\u0014&!C*dQ\u0016$W\u000f\\3s\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\"!\u00185\n\u0005%t&A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0012i&,'\u000fV8qS\u000e\u001cuN\\:v[\u0016\u0014\bC\u00017p\u001b\u0005i'B\u00018E\u0003\u0015!x\u000e]5d\u0013\t\u0001XNA\tUS\u0016\u0014Hk\u001c9jG\u000e{gn];nKJ\f\u0011#\u001b8ji&\fG.\u00138uKJ4\u0018\r\\'t!\tY5/\u0003\u0002u\u0019\n!Aj\u001c8h\u0003yIg.\u001b;jC2l\u0015\r_%oaJ|wM]3tgB\u000b'\u000f^5uS>t7\u000f\u0005\u0002Lo&\u0011\u0001\u0010\u0014\u0002\u0004\u0013:$\u0018\u0001E5oSRL\u0017\r\u001c\"bG.|gMZ't\u00035!\u0018.\u001a:OC6,7\u000f]1dKB\u0019A0a\u0002\u000f\u0007u\f\u0019\u0001\u0005\u0002\u007f\u00196\tqPC\u0002\u0002\u0002!\u000ba\u0001\u0010:p_Rt\u0014bAA\u0003\u0019\u00061\u0001K]3eK\u001aLA!!\u0003\u0002\f\t11\u000b\u001e:j]\u001eT1!!\u0002M\u0003\u0011!\u0018.\\3\u0011\t\u0005E\u00111E\u0007\u0003\u0003'Q1aUA\u000b\u0015\u0011\t9\"!\u0007\u0002\r\r|W.\\8o\u0015\r9\u00151\u0004\u0006\u0005\u0003;\ty\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003C\t1a\u001c:h\u0013\u0011\t)#a\u0005\u0003\tQKW.Z\u0001\u0015i&,'o\u00142kK\u000e$xiQ*vaBd\u0017.\u001a:\u0011\u000b-\u000bY#a\f\n\u0007\u00055BJ\u0001\u0004PaRLwN\u001c\t\u0006\u0017\u0006E\u0012QG\u0005\u0004\u0003ga%!\u0003$v]\u000e$\u0018n\u001c81!\u0011\t9$!\u000f\u000e\u0003\u0011K1!a\u000fE\u0005i!\u0016.\u001a:PE*,7\r^$be\n\fw-Z\"pY2,7\r^8s\u0003\u0019a\u0014N\\5u}Q!\u0012\u0011IA\"\u0003\u000b\n9%!\u0013\u0002L\u00055\u0013qJA)\u0003'\u00022!a\u000e\u0001\u0011\u0015\u0011'\u00021\u0001d\u0011\u00151'\u00021\u0001h\u0011\u0015Q'\u00021\u0001l\u0011\u0015\t(\u00021\u0001s\u0011\u0015)(\u00021\u0001w\u0011\u0015I(\u00021\u0001s\u0011\u0015Q(\u00021\u0001|\u0011\u001d\tiA\u0003a\u0001\u0003\u001fA\u0011\"a\n\u000b!\u0003\u0005\r!!\u000b\u0002\u001f1\f7\u000f\u001e%fCJ$(-Z1u\u001bN,\"!!\u0017\u0011\t\u0005m\u0013QN\u0007\u0003\u0003;RA!a\u0018\u0002b\u00051\u0011\r^8nS\u000eTA!a\u0019\u0002f\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005\u001d\u0014\u0011N\u0001\u0005kRLGN\u0003\u0002\u0002l\u0005!!.\u0019<b\u0013\u0011\ty'!\u0018\u0003\u0015\u0005#x.\\5d\u0019>tw-\u0001\tmCN$\b*Z1si\n,\u0017\r^'tA\u0005a\u0011n]%o/>\u00148\u000eT8paV\u0011\u0011q\u000f\t\u0005\u00037\nI(\u0003\u0003\u0002|\u0005u#!D!u_6L7MQ8pY\u0016\fg.A\u0007jg&swk\u001c:l\u0019>|\u0007\u000fI\u0001\u000ei&,'\u000fV8qS\u000et\u0015-\\3\u0016\u0005\u0005\r\u0005\u0003BAC\u0003\u0017k!!a\"\u000b\t\u0005%\u0015\u0011N\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\n\u0005\u001d\u0015A\u0004;jKJ$v\u000e]5d\u001d\u0006lW\rI\u0001\tY&\u001cH/\u001a8feV\u0011\u00111\u0013\t\u0005\u0003o\t)*C\u0002\u0002\u0018\u0012\u0013q\u0004R3mKR,G\rU1si&$\u0018n\u001c8t\u0007\"\fgnZ3MSN$XM\\3s\u00031a\u0017n\u001d;f]\u0016\u0014x\fJ3r)\u0011\ti*a)\u0011\u0007-\u000by*C\u0002\u0002\"2\u0013A!\u00168ji\"I\u0011Q\u0015\n\u0002\u0002\u0003\u0007\u00111S\u0001\u0004q\u0012\n\u0014!\u00037jgR,g.\u001a:!\u0003ma\u0017m\u001d;EK2,G/\u001a3QCJ$\u0018\u000e^5p]\u000eCWmY6NgV\t!/A\u0010mCN$H)\u001a7fi\u0016$\u0007+\u0019:uSRLwN\\\"iK\u000e\\Wj]0%KF$B!!(\u00022\"A\u0011QU\u000b\u0002\u0002\u0003\u0007!/\u0001\u000fmCN$H)\u001a7fi\u0016$\u0007+\u0019:uSRLwN\\\"iK\u000e\\Wj\u001d\u0011\u0002\u001b9,X.\u00138Qe><'/Z:t+\u00051\u0018!\u00058v[&s\u0007K]8he\u0016\u001c8o\u0018\u0013fcR!\u0011QTA_\u0011!\t)\u000bGA\u0001\u0002\u00041\u0018A\u00048v[&s\u0007K]8he\u0016\u001c8\u000fI\u0001\u0015S6l\u0017n\u001a:bi\u0016$\u0007+\u0019:uSRLwN\\:\u0016\u0005\u0005\u0015\u0007cBAd\u0003#4\u0018Q[\u0007\u0003\u0003\u0013TA!a3\u0002N\u00069Q.\u001e;bE2,'bAAh\u0019\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005M\u0017\u0011\u001a\u0002\u0004\u001b\u0006\u0004\b\u0003BA\u001c\u0003/L1!!7E\u0005qIU.\\5he\u0006$X\r\u001a+jKJ$v\u000e]5d!\u0006\u0014H/\u001b;j_:\fQ#[7nS\u001e\u0014\u0018\r^3e!\u0006\u0014H/\u001b;j_:\u001c\b%A\bd_>\u0014H-\u001b8bi>\u0014H+Y:l+\t\t\t\u000f\r\u0003\u0002d\u0006=\bCBAs\u0003O\fY/\u0004\u0002\u0002b%!\u0011\u0011^A1\u0005=\u00196\r[3ek2,GMR;ukJ,\u0007\u0003BAw\u0003_d\u0001\u0001B\u0006\u0002rz\t\t\u0011!A\u0003\u0002\u0005u(aA0%c\u0005\u00012m\\8sI&t\u0017\r^8s)\u0006\u001c8\u000e\t\u0015\u0004=\u0005]\bcA&\u0002z&\u0019\u00111 '\u0003\u0011Y|G.\u0019;jY\u0016\fB!a@\u0003\u0006A\u00191J!\u0001\n\u0007\t\rAJA\u0004O_RD\u0017N\\4\u0011\u0007-\u00139!C\u0002\u0003\n1\u00131!\u00118z\u0003M\u0019wn\u001c:eS:\fGo\u001c:UCN\\w\fJ3r)\u0011\tiJa\u0004\t\u0013\u0005\u0015V$!AA\u0002\tE\u0001\u0007\u0002B\n\u0005/\u0001b!!:\u0002h\nU\u0001\u0003BAw\u0005/!A\"!=\u0003\u0010\u0005\u0005\t\u0011!B\u0001\u0003{\faaY8oM&<WC\u0001B\u000f!\u0011\t9Da\b\n\u0007\t\u0005BI\u0001\u0004D_:4\u0017nZ\u0001\u000bG>tg-[4`I\u0015\fH\u0003BAO\u0005OA\u0011\"!*!\u0003\u0003\u0005\rA!\b\u0002\u000f\r|gNZ5hA!\u001a\u0011%a>\u0002+I,7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hgV\u0011!\u0011\u0007\t\u0006\u0005g\u0011)d_\u0007\u0003\u0003\u001bLAAa\u000e\u0002N\n\u00191+\u001a;\u0002/Y\fG.\u001b3bi\u0016\u0014VmY8oM&<WO]1uS>tG\u0003BAO\u0005{AqAa\u0010$\u0001\u0004\u0011\t%A\u0005oK^\u001cuN\u001c4jOB\u0019QLa\u0011\n\u0007\t\u0015cLA\u0006LC\u001a\\\u0017mQ8oM&<\u0017a\u0003:fG>tg-[4ve\u0016$b!!(\u0003L\t=\u0003b\u0002B'I\u0001\u0007!\u0011I\u0001\n_2$7i\u001c8gS\u001eDqAa\u0010%\u0001\u0004\u0011\t%A\u0004ti\u0006\u0014H/\u001e9\u0015\u0005\u0005u\u0015!\u00055b]\u0012dW-S7nS\u001e\u0014\u0018\r^5p]R!\u0011Q\u0014B-\u0011\u0019\u0011YF\na\u0001m\u0006!B/[3s)>\u0004\u0018n\u0019)beRLG/[8o\u0013\u0012\f\u0001\u0003[1oI2,W)\\5he\u0006$\u0018n\u001c8\u0015\t\u0005u%\u0011\r\u0005\u0007\u00057:\u0003\u0019\u0001<\u0002!I,w-[:uKJd\u0015n\u001d;f]\u0016\u0014H\u0003BAO\u0005OBq!a$)\u0001\u0004\t\u0019*\u0001\u0005tQV$Hm\\<o\u0003A\u0019H/\u0019:u\u0007>|'\u000fZ5oCR|'\u000f\u0006\u0003\u0002\u001e\n=\u0004\u0002\u0003B9UA\u0005\t\u0019\u0001<\u0002\u000b\u0011,G.Y=\u00025M$\u0018M\u001d;D_>\u0014H-\u001b8bi>\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t]$f\u0001<\u0003z-\u0012!1\u0010\t\u0005\u0005{\u00129)\u0004\u0002\u0003\u0000)!!\u0011\u0011BB\u0003%)hn\u00195fG.,GMC\u0002\u0003\u00062\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011IIa \u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\bti>\u00048i\\8sI&t\u0017\r^8s\u0003%AW-\u0019:uE\u0016\fG/\u0001\u0004e_^{'o[\u0001\u0016M&tG\rR3mKR,G\rU1si&$\u0018n\u001c8t\u0003=i\u0017m[3Ue\u0006t7/\u001b;j_:\u001c\u0018\u0001G2pY2,7\r\u001e#fY\u0016$X\r\u001a)beRLG/[8ogRA!\u0011\u0014BV\u0005o\u0013Y\f\u0005\u0004L\u00057\u0013(qT\u0005\u0004\u0005;c%A\u0002+va2,'\u0007\u0005\u0003\u0003\"\n\u001dVB\u0001BR\u0015\u0011\u0011)+!\u001b\u0002\u00079Lw.\u0003\u0003\u0003*\n\r&A\u0003\"zi\u0016\u0014UO\u001a4fe\"9!QV\u0019A\u0002\t=\u0016A\u0005;jKJ$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004BA!-\u000346\u0011\u0011QC\u0005\u0005\u0005k\u000b)B\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\r\te\u0016\u00071\u0001s\u0003-\u0019H/\u0019:u\u001f\u001a47/\u001a;\t\u000f\tu\u0016\u00071\u0001\u0003 \u0006y\u0011\r\u001c7pG\u0006$X\r\u001a\"vM\u001a,'/\u0001\rsk:<\u0015M\u001d2bO\u0016\u001cu\u000e\u001c7fGR|'\u000fV1tWN\f\u0011$\\1zE\u0016\u0014UmZ5o\u001b\u0006$XM]5bY&T\u0018\r^5p]\u0006\u0011R.Y=cK\n+w-\u001b8EK2,G/[8o\u0003=!(/Y2l\u0013:LG\u000fT3bI\u0016\u0014H\u0003CAO\u0005\u0013\u0014YM!6\t\r\tmS\u00071\u0001w\u0011\u001d\u0011i-\u000ea\u0001\u0005\u001f\fAB\\3x!\u0006\u0014H/\u001b;j_:\u0004B!a\u000e\u0003R&\u0019!1\u001b#\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0007b\u0002Blk\u0001\u0007!\u0011\\\u0001\u001aGJ,\u0017\r^5p]>3gm]3u\u0003:$W\t]8dQ>\u0003H\u000fE\u0003L\u0003W\u0011Y\u000e\u0005\u0003\u0003^\n\rXB\u0001Bp\u0015\u0011\u0011\t/!\u0007\u0002\tI\fg\r^\u0005\u0005\u0005K\u0014yN\u0001\bPM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195\u0002?Q\u0014\u0018mY6Qe\u0016Le.\u001b;jCR,\u0007+\u0019:uSRLwN\u001c#fY\u0016$X\r\u0006\u0005\u0002\u001e\n-(Q\u001eBy\u0011\u0019\u0011YF\u000ea\u0001m\"9!q\u001e\u001cA\u0002\t=\u0017\u0001\u00053fY\u0016$X\r\u001a)beRLG/[8o\u0011\u0019\u0011\u0019P\u000ea\u0001e\u0006IA/[7fgR\fW\u000e]\u0001\u001diJ\f7m[%oSRL\u0017\r^3QCJ$\u0018\u000e^5p]\u0012+G.\u001a;f)!\tiJ!?\u0003|\nu\bB\u0002B.o\u0001\u0007a\u000fC\u0004\u0003p^\u0002\rAa4\t\r\t}x\u00071\u0001s\u0003\u0019ygMZ:fi\u0006aBO]1dW\u000e{W\u000e\u001d7fi\u0016\u0004\u0016M\u001d;ji&|g\u000eR3mKR,GCBAO\u0007\u000b\u00199\u0001\u0003\u0004\u0003\\a\u0002\rA\u001e\u0005\b\u0005_D\u0004\u0019\u0001Bh)\u0011\tija\u0003\t\u000f\r5\u0011\b1\u0001\u0003\u001e\u0005q\u0001O]8q_N,GmQ8oM&<\u0017!E;qI\u0006$Xm\u0015;beR|eMZ:fiR1\u0011QTB\n\u0007+AaAa\u0017;\u0001\u00041\bBBB\fu\u0001\u0007!/\u0001\boK^\u001cF/\u0019:u\u001f\u001a47/\u001a;\u0002?QLWM\u001d+pa&\u001c\u0007+\u0019:uSRLwN\\:XSRD\u0007k\\:ji&|g.\u0006\u0002\u0004\u001eAA!1GB\u0010\u0005_\u001b\t#\u0003\u0003\u0002T\u00065\u0007\u0003B&\u0002,I\f\u0001cY1oG\u0016d\u0017J\u001c)s_\u001e\u0014Xm]:\u0015\t\u0005u5q\u0005\u0005\b\u0007Sa\u0004\u0019AB\u0016\u0003IIg\u000e\u0015:pOJ,7o\u001d#fY\u0016$\u0018n\u001c8\u0011\t\u0005]2QF\u0005\u0004\u0007_!%AE%o!J|wM]3tg\u0012+G.\u001a;j_:\f\u0001\u0005V5fe\u0012+G.\u001a;fIB\u000b'\u000f^5uS>t7oQ8pe\u0012Lg.\u0019;peB\u0019\u0011q\u0007 \u0014\u0005yRECAB\u001a\u0003U\u0011VmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON,\"a!\u0010\u0011\r\r}2QIAB\u001b\t\u0019\tE\u0003\u0003\u0004D\u00055\u0017!C5n[V$\u0018M\u00197f\u0013\u0011\u00119d!\u0011\u0002-I+7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hg\u0002\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012JTCAB'U\u0011\tIC!\u001f")
public class TierDeletedPartitionsCoordinator
implements KafkaMetricsGroup,
BrokerReconfigurable {
    private final Scheduler scheduler;
    private final ReplicaManager replicaManager;
    private final TierTopicConsumer tierTopicConsumer;
    public final Time kafka$tier$TierDeletedPartitionsCoordinator$$time;
    private final Option<Function0<TierObjectGarbageCollector>> tierObjectGCSupplier;
    private final AtomicLong kafka$tier$TierDeletedPartitionsCoordinator$$lastHeartbeatMs;
    private final AtomicBoolean isInWorkLoop;
    private final String tierTopicName;
    private DeletedPartitionsChangeListener listener;
    private long lastDeletedPartitionCheckMs;
    private int kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress;
    private final scala.collection.mutable.Map<Object, ImmigratedTierTopicPartition> immigratedPartitions;
    private volatile ScheduledFuture<?> coordinatorTask;
    private volatile Config config;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<Function0<TierObjectGarbageCollector>> $lessinit$greater$default$9() {
        return TierDeletedPartitionsCoordinator$.MODULE$.$lessinit$greater$default$9();
    }

    public static scala.collection.immutable.Set<String> ReconfigurableConfigs() {
        return TierDeletedPartitionsCoordinator$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public <T> Gauge<T> newGauge(MetricName metricName, Gauge<T> metric) {
        return KafkaMetricsGroup.newGauge$(this, metricName, metric);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public void removeMetric(MetricName metricName) {
        KafkaMetricsGroup.removeMetric$(this, metricName);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public AtomicLong kafka$tier$TierDeletedPartitionsCoordinator$$lastHeartbeatMs() {
        return this.kafka$tier$TierDeletedPartitionsCoordinator$$lastHeartbeatMs;
    }

    private AtomicBoolean isInWorkLoop() {
        return this.isInWorkLoop;
    }

    private String tierTopicName() {
        return this.tierTopicName;
    }

    private DeletedPartitionsChangeListener listener() {
        return this.listener;
    }

    private void listener_$eq(DeletedPartitionsChangeListener x$1) {
        this.listener = x$1;
    }

    private long lastDeletedPartitionCheckMs() {
        return this.lastDeletedPartitionCheckMs;
    }

    private void lastDeletedPartitionCheckMs_$eq(long x$1) {
        this.lastDeletedPartitionCheckMs = x$1;
    }

    public int kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress() {
        return this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress;
    }

    private void kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress_$eq(int x$1) {
        this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress = x$1;
    }

    public scala.collection.mutable.Map<Object, ImmigratedTierTopicPartition> immigratedPartitions() {
        return this.immigratedPartitions;
    }

    private ScheduledFuture<?> coordinatorTask() {
        return this.coordinatorTask;
    }

    private void coordinatorTask_$eq(ScheduledFuture<?> x$1) {
        this.coordinatorTask = x$1;
    }

    private Config config() {
        return this.config;
    }

    private void config_$eq(Config x$1) {
        this.config = x$1;
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return TierDeletedPartitionsCoordinator$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        Config proposedConfigs = new Config(Predef$.MODULE$.Long2long(newConfig.confluentConfig().tierTopicDeleteCheckIntervalMs()), Predef$.MODULE$.Integer2int(newConfig.confluentConfig().tierTopicDeleteMaxInprogressPartitions()), Predef$.MODULE$.Long2long(newConfig.confluentConfig().tierTopicDeleteBackoffMs()));
        this.reconfigure(proposedConfigs);
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Starting up TierDeletedPartitionCoordinator with config=").append(this.config()).toString());
        this.startCoordinator(100);
    }

    public void handleImmigration(int tierTopicPartitionId) {
        synchronized (this) {
            Option tierObjectGarbageCollectorOpt = this.tierObjectGCSupplier.map((Function1 & Serializable & scala.Serializable)x$2 -> (TierObjectGarbageCollector)x$2.apply());
            ImmigratedTierTopicPartition cfr_ignored_0 = (ImmigratedTierTopicPartition)this.immigratedPartitions().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId), (Function0 & Serializable & scala.Serializable)() -> new ImmigratedTierTopicPartition((Option<TierObjectGarbageCollector>)tierObjectGarbageCollectorOpt));
            return;
        }
    }

    public synchronized void handleEmigration(int tierTopicPartitionId) {
        this.immigratedPartitions().remove((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId)).foreach((Function1 & Serializable & scala.Serializable)emigratedPartition -> {
            TierDeletedPartitionsCoordinator.$anonfun$handleEmigration$1(this, emigratedPartition);
            return BoxedUnit.UNIT;
        });
    }

    public void registerListener(DeletedPartitionsChangeListener listener) {
        this.listener_$eq(listener);
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down TierDeletedPartitionCoordinator.");
        this.stopCoordinator();
        this.removeMetrics$1();
    }

    private void startCoordinator(int delay) {
        if (this.coordinatorTask() != null) {
            throw new IllegalStateException("Attempt to start a duplicate coordinator");
        }
        this.coordinatorTask_$eq(this.scheduler.schedule("tier-deleted-partition-task", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.doWork(), delay, Math.min(60000L, this.config().intervalMs()), TimeUnit.MILLISECONDS));
    }

    private int startCoordinator$default$1() {
        return 0;
    }

    private void stopCoordinator() {
        if (this.coordinatorTask() != null) {
            this.coordinatorTask().cancel(false);
            this.coordinatorTask_$eq(null);
        }
    }

    public void heartbeat() {
        this.kafka$tier$TierDeletedPartitionsCoordinator$$lastHeartbeatMs().set(this.kafka$tier$TierDeletedPartitionsCoordinator$$time.milliseconds());
    }

    public void doWork() {
        block8: {
            block7: {
                try {
                    try {
                        if (!this.isInWorkLoop().compareAndSet(false, true)) {
                            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Work loop is already running; backing off");
                            break block7;
                        }
                        this.heartbeat();
                        long now = this.kafka$tier$TierDeletedPartitionsCoordinator$$time.hiResClockMs();
                        if (this.lastDeletedPartitionCheckMs() == 0L || now - this.lastDeletedPartitionCheckMs() >= this.config().intervalMs()) {
                            this.findDeletedPartitions();
                            this.runGarbageCollectorTasks();
                            this.lastDeletedPartitionCheckMs_$eq(now);
                        }
                        this.makeTransitions();
                    }
                    catch (Exception e) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Caught exception in work loop", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    }
                    break block8;
                }
                finally {
                    this.isInWorkLoop().set(false);
                }
            }
            return;
        }
    }

    private void findDeletedPartitions() {
        ObjectRef allocatedBuffer = ObjectRef.create((Object)ByteBuffer.allocate(10000));
        this.tierTopicPartitionsWithPosition().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TierDeletedPartitionsCoordinator.$anonfun$findDeletedPartitions$1(this, allocatedBuffer, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void makeTransitions() {
        this.maybeBeginMaterialization();
        this.maybeBeginDeletion();
    }

    public Tuple2<Object, ByteBuffer> collectDeletedPartitions(TopicPartition tierTopicPartition, long startOffset, ByteBuffer allocatedBuffer) {
        Tuple2 tuple2;
        ByteBuffer buffer = allocatedBuffer;
        HostedPartition hostedPartition = this.replicaManager.getPartition(tierTopicPartition);
        if (hostedPartition instanceof HostedPartition.Online) {
            AbstractLog log = ((HostedPartition.Online)hostedPartition).partition().localLogOrException();
            long lastOffset = log.highWatermark();
            LongRef currentOffset = LongRef.create((long)startOffset);
            while (currentOffset.elem < lastOffset) {
                MemoryRecords memoryRecords;
                if (!this.immigratedPartitions().contains((Object)BoxesRunTime.boxToInteger((int)tierTopicPartition.partition()))) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append(tierTopicPartition).append(" no longer hosted on this broker, stopping materialization from offset ").append(startOffset).append(" to ").append(currentOffset$1.elem).toString());
                    return new Tuple2((Object)BoxesRunTime.boxToLong((long)currentOffset.elem), (Object)buffer);
                }
                AbstractFetchDataInfo abstractFetchDataInfo = log.read(currentOffset.elem, buffer.capacity(), FetchHighWatermark$.MODULE$, true, false);
                if (!(abstractFetchDataInfo instanceof FetchDataInfo)) {
                    throw new IllegalStateException(new StringBuilder(44).append("Unexpected tiered segment for tier topic in ").append(tierTopicPartition).toString());
                }
                FetchDataInfo fetchDataInfo = (FetchDataInfo)abstractFetchDataInfo;
                Records records = fetchDataInfo.records();
                if (records instanceof MemoryRecords) {
                    memoryRecords = (MemoryRecords)records;
                } else if (records instanceof FileRecords) {
                    FileRecords fileRecords = (FileRecords)records;
                    buffer.clear();
                    if (buffer.capacity() < fileRecords.sizeInBytes()) {
                        buffer = ByteBuffer.allocate(fileRecords.sizeInBytes());
                    }
                    fileRecords.readInto(buffer, 0);
                    memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
                } else {
                    throw new IllegalArgumentException(new StringBuilder(23).append("Unexpected record type ").append(records).toString());
                }
                ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(memoryRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                    TierDeletedPartitionsCoordinator.$anonfun$collectDeletedPartitions$2(this, tierTopicPartition, currentOffset, batch);
                    return BoxedUnit.UNIT;
                });
                lastOffset = Math.min(lastOffset, log.highWatermark());
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Processed messages in ").append(tierTopicPartition).append(" from offset ").append(startOffset).append(" to ").append(currentOffset$1.elem).toString());
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)currentOffset.elem), (Object)buffer);
        } else {
            boolean bl = HostedPartition$None$.MODULE$.equals(hostedPartition) ? true : (HostedPartition$Offline$.MODULE$.equals(hostedPartition) ? true : true);
            if (bl) {
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)startOffset), (Object)buffer);
            } else {
                throw new MatchError((Object)hostedPartition);
            }
        }
        return tuple2;
    }

    public synchronized void runGarbageCollectorTasks() {
        this.immigratedPartitions().values().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            TierDeletedPartitionsCoordinator.$anonfun$runGarbageCollectorTasks$1(this, x$4);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void maybeBeginMaterialization() {
        Iterator immigratedPartitionIt = this.immigratedPartitions().iterator();
        scala.collection.mutable.Map newDeletions = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (this.capacity$1() > 0 && immigratedPartitionIt.hasNext()) {
            Tuple2 tuple2 = (Tuple2)immigratedPartitionIt.next();
            if (tuple2 != null) {
                int tierTopicPartitionId = tuple2._1$mcI$sp();
                ImmigratedTierTopicPartition partitionState = (ImmigratedTierTopicPartition)tuple2._2();
                if (!partitionState.inProgressDeletions().isEmpty()) continue;
                scala.collection.mutable.Map<TopicIdPartition, Object> pendingDeletions = partitionState.pendingDeletions();
                ((TraversableOnce)pendingDeletions.take(this.capacity$1())).toList().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    TierDeletedPartitionsCoordinator.$anonfun$maybeBeginMaterialization$1(this, tierTopicPartitionId, partitionState, newDeletions, pendingDeletions, x0$1);
                    return BoxedUnit.UNIT;
                });
                continue;
            }
            throw new MatchError(null);
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Beginning tier partition state materialization for ").append(newDeletions.map((Function1 & Serializable & scala.Serializable)x$5 -> (TopicIdPartition)x$5._1(), scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toString());
        newDeletions.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            TierDeletedPartitionsCoordinator.$anonfun$maybeBeginMaterialization$4(this, x0$2);
            return BoxedUnit.UNIT;
        });
        this.tierTopicConsumer.register((java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter(newDeletions).asJava());
    }

    public synchronized void maybeBeginDeletion() {
        this.immigratedPartitions().values().foreach((Function1 & Serializable & scala.Serializable)immigratedPartition -> {
            TierDeletedPartitionsCoordinator.$anonfun$maybeBeginDeletion$1(this, immigratedPartition);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void trackInitLeader(int tierTopicPartitionId, TopicIdPartition newPartition, Option<OffsetAndEpoch> creationOffsetAndEpochOpt) {
        this.immigratedPartitions().get((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId)).foreach((Function1 & Serializable & scala.Serializable)immigratedTierTopicPartition -> {
            TierDeletedPartitionsCoordinator.$anonfun$trackInitLeader$1(this, newPartition, creationOffsetAndEpochOpt, immigratedTierTopicPartition);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void trackPreInitiatePartitionDelete(int tierTopicPartitionId, TopicIdPartition deletedPartition, long timestamp) {
        this.immigratedPartitions().get((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId)).foreach((Function1 & Serializable & scala.Serializable)immigratedTierTopicPartition -> {
            TierDeletedPartitionsCoordinator.$anonfun$trackPreInitiatePartitionDelete$1(this, deletedPartition, timestamp, immigratedTierTopicPartition);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void trackInitiatePartitionDelete(int tierTopicPartitionId, TopicIdPartition deletedPartition, long offset) {
        this.immigratedPartitions().get((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId)).foreach((Function1 & Serializable & scala.Serializable)immigratedTierTopicPartition -> {
            TierDeletedPartitionsCoordinator.$anonfun$trackInitiatePartitionDelete$1(this, deletedPartition, offset, immigratedTierTopicPartition);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void trackCompletePartitionDelete(int tierTopicPartitionId, TopicIdPartition deletedPartition) {
        this.immigratedPartitions().get((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId)).foreach((Function1 & Serializable & scala.Serializable)immigratedTierTopicPartition -> {
            TierDeletedPartitionsCoordinator.$anonfun$trackCompletePartitionDelete$1(this, deletedPartition, immigratedTierTopicPartition);
            return BoxedUnit.UNIT;
        });
    }

    public void reconfigure(Config proposedConfig) {
        Config currentConfig;
        Config config = currentConfig = this.config();
        if (config == null ? proposedConfig != null : !((Object)config).equals(proposedConfig)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Reconfiguring from ").append(currentConfig).append(" to ").append(proposedConfig).toString());
            long oldIntervalMs = currentConfig.intervalMs();
            long newIntervalMs = proposedConfig.intervalMs();
            this.config_$eq(proposedConfig);
            if (oldIntervalMs != newIntervalMs) {
                this.stopCoordinator();
                this.startCoordinator(this.startCoordinator$default$1());
                return;
            }
        }
    }

    private synchronized void updateStartOffset(int tierTopicPartitionId, long newStartOffset) {
        this.immigratedPartitions().get((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId)).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.lastReadOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)newStartOffset)));
            return BoxedUnit.UNIT;
        });
    }

    private synchronized Map<TopicPartition, Option<Object>> tierTopicPartitionsWithPosition() {
        return ((TraversableOnce)this.immigratedPartitions().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int tierTopicPartitionId = x0$1._1$mcI$sp();
            ImmigratedTierTopicPartition immigratedPartition = (ImmigratedTierTopicPartition)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.tierTopicName(), tierTopicPartitionId)), immigratedPartition.lastReadOffset());
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private void cancelInProgress(InProgressDeletion inProgressDeletion) {
        this.listener().stopPartitionDeletion(inProgressDeletion.topicIdPartition());
        inProgressDeletion.stopMaterialization();
        this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress_$eq(this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress() - 1);
    }

    public static final /* synthetic */ void $anonfun$handleEmigration$2(TierDeletedPartitionsCoordinator $this, InProgressDeletion inProgressDeletion) {
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Cancelling segment deletion for ").append(inProgressDeletion.topicIdPartition()).append(" on partition emigration").toString());
        $this.cancelInProgress(inProgressDeletion);
    }

    public static final /* synthetic */ void $anonfun$handleEmigration$1(TierDeletedPartitionsCoordinator $this, ImmigratedTierTopicPartition emigratedPartition) {
        emigratedPartition.inProgressDeletions().values().foreach((Function1 & Serializable & scala.Serializable)inProgressDeletion -> {
            TierDeletedPartitionsCoordinator.$anonfun$handleEmigration$2($this, inProgressDeletion);
            return BoxedUnit.UNIT;
        });
    }

    private final void removeMetrics$1() {
        this.removeMetric("TierNumInProgressPartitionDeletions", this.removeMetric$default$2());
        this.removeMetric("TierNumQueuedPartitionDeletions", this.removeMetric$default$2());
        this.removeMetric("HeartbeatMs", this.removeMetric$default$2());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$findDeletedPartitions$1(TierDeletedPartitionsCoordinator $this, ObjectRef allocatedBuffer$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            void var8_7;
            void var6_6;
            Option startOffsetOpt;
            TopicPartition tierTopicPartition = (TopicPartition)x0$1._1();
            Tuple2<Object, ByteBuffer> tuple2 = $this.collectDeletedPartitions(tierTopicPartition, BoxesRunTime.unboxToLong((Object)(startOffsetOpt = (Option)x0$1._2()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), (ByteBuffer)allocatedBuffer$1.elem);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            long endOffset = tuple2._1$mcJ$sp();
            ByteBuffer buffer = (ByteBuffer)tuple2._2();
            $this.updateStartOffset(tierTopicPartition.partition(), (long)var6_6);
            allocatedBuffer$1.elem = var8_7;
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$collectDeletedPartitions$4(TierDeletedPartitionsCoordinator $this, TopicPartition tierTopicPartition$1, Record record$1, AbstractTierMetadata x0$1) {
        if (x0$1 instanceof TierTopicInitLeader) {
            TierTopicInitLeader tierTopicInitLeader = (TierTopicInitLeader)x0$1;
            $this.trackInitLeader(tierTopicPartition$1.partition(), tierTopicInitLeader.topicIdPartition(), (Option<OffsetAndEpoch>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(tierTopicInitLeader.partitionCreationOffsetAndEpoch())));
            return;
        }
        if (x0$1 instanceof TierPartitionDeletePreInitiate) {
            TierPartitionDeletePreInitiate tierPartitionDeletePreInitiate = (TierPartitionDeletePreInitiate)x0$1;
            $this.trackPreInitiatePartitionDelete(tierTopicPartition$1.partition(), tierPartitionDeletePreInitiate.topicIdPartition(), record$1.timestamp());
            return;
        }
        if (x0$1 instanceof TierPartitionDeleteInitiate) {
            TierPartitionDeleteInitiate tierPartitionDeleteInitiate = (TierPartitionDeleteInitiate)x0$1;
            $this.trackInitiatePartitionDelete(tierTopicPartition$1.partition(), tierPartitionDeleteInitiate.topicIdPartition(), record$1.offset());
            return;
        }
        if (x0$1 instanceof TierPartitionDeleteComplete) {
            TierPartitionDeleteComplete tierPartitionDeleteComplete = (TierPartitionDeleteComplete)x0$1;
            $this.trackCompletePartitionDelete(tierTopicPartition$1.partition(), tierPartitionDeleteComplete.topicIdPartition());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$collectDeletedPartitions$3(TierDeletedPartitionsCoordinator $this, TopicPartition tierTopicPartition$1, Record record) {
        OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(AbstractTierMetadata.deserialize(record.key(), record.value(), record.timestamp()))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TierDeletedPartitionsCoordinator.$anonfun$collectDeletedPartitions$4($this, tierTopicPartition$1, record, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$collectDeletedPartitions$2(TierDeletedPartitionsCoordinator $this, TopicPartition tierTopicPartition$1, LongRef currentOffset$1, MutableRecordBatch batch) {
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            TierDeletedPartitionsCoordinator.$anonfun$collectDeletedPartitions$3($this, tierTopicPartition$1, record);
            return BoxedUnit.UNIT;
        });
        currentOffset$1.elem = batch.nextOffset();
    }

    public static final /* synthetic */ void $anonfun$runGarbageCollectorTasks$2(TierDeletedPartitionsCoordinator $this, TierObjectGarbageCollector garbageCollector) {
        garbageCollector.maybePreInitiatePartitionDeletion();
        garbageCollector.maybeDeletePartitions($this.config().deleteBackoffMs());
    }

    public static final /* synthetic */ void $anonfun$runGarbageCollectorTasks$1(TierDeletedPartitionsCoordinator $this, ImmigratedTierTopicPartition x$4) {
        x$4.tierObjectGarbageCollectorOpt().foreach((Function1 & Serializable & scala.Serializable)garbageCollector -> {
            TierDeletedPartitionsCoordinator.$anonfun$runGarbageCollectorTasks$2($this, garbageCollector);
            return BoxedUnit.UNIT;
        });
    }

    private final int capacity$1() {
        return this.config().maxInprogressPartitions() - this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress();
    }

    public static final /* synthetic */ void $anonfun$maybeBeginMaterialization$1(TierDeletedPartitionsCoordinator $this, int tierTopicPartitionId$1, ImmigratedTierTopicPartition partitionState$1, scala.collection.mutable.Map newDeletions$1, scala.collection.mutable.Map pendingDeletions$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicIdPartition partitionToDelete = (TopicIdPartition)x0$1._1();
            long deleteInitiateOffset = x0$1._2$mcJ$sp();
            InProgressDeletion inProgressDeletion = new InProgressDeletion(tierTopicPartitionId$1, partitionToDelete, deleteInitiateOffset, $this.tierTopicConsumer, InProgressDeletion$.MODULE$.$lessinit$greater$default$5(), InProgressDeletion$.MODULE$.$lessinit$greater$default$6(), InProgressDeletion$.MODULE$.$lessinit$greater$default$7());
            partitionState$1.inProgressDeletions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionToDelete), (Object)inProgressDeletion));
            newDeletions$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionToDelete), (Object)inProgressDeletion));
            pendingDeletions$1.remove((Object)partitionToDelete);
            $this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress_$eq($this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress() + 1);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$maybeBeginMaterialization$4(TierDeletedPartitionsCoordinator $this, Tuple2 x0$2) {
        if (x0$2 != null) {
            TopicIdPartition partitionId = (TopicIdPartition)x0$2._1();
            $this.tierTopicConsumer.deregister(partitionId);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$maybeBeginDeletion$2(TierDeletedPartitionsCoordinator $this, InProgressDeletion inProgressDeletion) {
        DeletionState deletionState = inProgressDeletion.deletionState();
        if (MaterializationComplete$.MODULE$.equals(deletionState)) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Beginning segment deletion for ").append(inProgressDeletion.topicIdPartition()).toString());
            inProgressDeletion.awaitDeleteComplete();
            $this.listener().initiatePartitionDeletion(inProgressDeletion.topicIdPartition(), inProgressDeletion.allTieredObjects());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$maybeBeginDeletion$1(TierDeletedPartitionsCoordinator $this, ImmigratedTierTopicPartition immigratedPartition) {
        immigratedPartition.inProgressDeletions().values().foreach((Function1 & Serializable & scala.Serializable)inProgressDeletion -> {
            TierDeletedPartitionsCoordinator.$anonfun$maybeBeginDeletion$2($this, inProgressDeletion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$trackInitLeader$2(TierDeletedPartitionsCoordinator $this, TopicIdPartition newPartition$1, Option creationOffsetAndEpochOpt$1, TierObjectGarbageCollector garbageCollector) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Processing InitLeader for ").append(newPartition$1).toString());
        if (creationOffsetAndEpochOpt$1.isEmpty()) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(178).append("Init leader metadata for ").append(newPartition$1).append(" is ignored because topic creation OffsetAndEpoch is missing. ").append("It is possible that this event was generated before the cluster was upgraded to KRaft mode.").toString());
            return;
        }
        garbageCollector.addTopicPartition(newPartition$1, (OffsetAndEpoch)creationOffsetAndEpochOpt$1.get());
    }

    public static final /* synthetic */ void $anonfun$trackInitLeader$1(TierDeletedPartitionsCoordinator $this, TopicIdPartition newPartition$1, Option creationOffsetAndEpochOpt$1, ImmigratedTierTopicPartition immigratedTierTopicPartition) {
        immigratedTierTopicPartition.tierObjectGarbageCollectorOpt().foreach((Function1 & Serializable & scala.Serializable)garbageCollector -> {
            TierDeletedPartitionsCoordinator.$anonfun$trackInitLeader$2($this, newPartition$1, creationOffsetAndEpochOpt$1, garbageCollector);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$trackPreInitiatePartitionDelete$2(TierDeletedPartitionsCoordinator $this, TopicIdPartition deletedPartition$1, long timestamp$1, TierObjectGarbageCollector garbageCollector) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Processing PreInitiateDelete for ").append(deletedPartition$1).toString());
        garbageCollector.onPartitionDeletePreInitiate(deletedPartition$1, timestamp$1);
    }

    public static final /* synthetic */ void $anonfun$trackPreInitiatePartitionDelete$1(TierDeletedPartitionsCoordinator $this, TopicIdPartition deletedPartition$1, long timestamp$1, ImmigratedTierTopicPartition immigratedTierTopicPartition) {
        immigratedTierTopicPartition.tierObjectGarbageCollectorOpt().foreach((Function1 & Serializable & scala.Serializable)garbageCollector -> {
            TierDeletedPartitionsCoordinator.$anonfun$trackPreInitiatePartitionDelete$2($this, deletedPartition$1, timestamp$1, garbageCollector);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$trackInitiatePartitionDelete$1(TierDeletedPartitionsCoordinator $this, TopicIdPartition deletedPartition$2, long offset$1, ImmigratedTierTopicPartition immigratedTierTopicPartition) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Processing InitiateDelete for ").append(deletedPartition$2).append(" at offset ").append(offset$1).toString());
        if (!immigratedTierTopicPartition.inProgressDeletions().contains((Object)deletedPartition$2)) {
            immigratedTierTopicPartition.pendingDeletions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)deletedPartition$2), (Object)BoxesRunTime.boxToLong((long)offset$1)));
        }
        immigratedTierTopicPartition.tierObjectGarbageCollectorOpt().foreach((Function1 & Serializable & scala.Serializable)garbageCollector -> {
            garbageCollector.onPartitionDeleteInitiate(deletedPartition$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$trackCompletePartitionDelete$3(TierDeletedPartitionsCoordinator $this, TopicIdPartition deletedPartition$3, InProgressDeletion inProgress) {
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Completed deleting segments for ").append(deletedPartition$3).toString());
        $this.cancelInProgress(inProgress);
    }

    public static final /* synthetic */ void $anonfun$trackCompletePartitionDelete$1(TierDeletedPartitionsCoordinator $this, TopicIdPartition deletedPartition$3, ImmigratedTierTopicPartition immigratedTierTopicPartition) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Processing CompleteDelete for ").append(deletedPartition$3).toString());
        immigratedTierTopicPartition.pendingDeletions().$minus$eq((Object)deletedPartition$3);
        immigratedTierTopicPartition.inProgressDeletions().remove((Object)deletedPartition$3).foreach((Function1 & Serializable & scala.Serializable)inProgress -> {
            TierDeletedPartitionsCoordinator.$anonfun$trackCompletePartitionDelete$3($this, deletedPartition$3, inProgress);
            return BoxedUnit.UNIT;
        });
        immigratedTierTopicPartition.tierObjectGarbageCollectorOpt().foreach((Function1 & Serializable & scala.Serializable)garbageCollector -> {
            garbageCollector.onPartitionDeleteComplete(deletedPartition$3);
            return BoxedUnit.UNIT;
        });
    }

    public TierDeletedPartitionsCoordinator(Scheduler scheduler, ReplicaManager replicaManager, TierTopicConsumer tierTopicConsumer, long initialIntervalMs, int initialMaxInprogressPartitions, long initialBackoffMs, String tierNamespace, Time time, Option<Function0<TierObjectGarbageCollector>> tierObjectGCSupplier) {
        this.scheduler = scheduler;
        this.replicaManager = replicaManager;
        this.tierTopicConsumer = tierTopicConsumer;
        this.kafka$tier$TierDeletedPartitionsCoordinator$$time = time;
        this.tierObjectGCSupplier = tierObjectGCSupplier;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.kafka$tier$TierDeletedPartitionsCoordinator$$lastHeartbeatMs = new AtomicLong(time.milliseconds());
        this.isInWorkLoop = new AtomicBoolean(false);
        this.tierTopicName = TierTopic.topicName(tierNamespace);
        this.lastDeletedPartitionCheckMs = 0L;
        this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress = 0;
        this.immigratedPartitions = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.config = new Config(initialIntervalMs, initialMaxInprogressPartitions, initialBackoffMs);
        this.newGauge("TierNumInProgressPartitionDeletions", new Gauge<Object>(this){
            private final /* synthetic */ TierDeletedPartitionsCoordinator $outer;

            public synchronized long value() {
                return this.$outer.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("TierNumQueuedPartitionDeletions", new Gauge<Object>(this){
            private final /* synthetic */ TierDeletedPartitionsCoordinator $outer;

            public synchronized long value() {
                return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.$outer.immigratedPartitions().values().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)$anon$2.$anonfun$value$1(x$1)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            }

            public static final /* synthetic */ long $anonfun$value$1(ImmigratedTierTopicPartition x$1) {
                return x$1.pendingDeletions().size();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1$adapted(kafka.tier.ImmigratedTierTopicPartition )}, serializedLambda);
            }
        }, this.newGauge$default$3());
        this.newGauge("HeartbeatMs", new Gauge<Object>(this){
            private final /* synthetic */ TierDeletedPartitionsCoordinator $outer;

            public synchronized long value() {
                return this.$outer.kafka$tier$TierDeletedPartitionsCoordinator$$time.milliseconds() - this.$outer.kafka$tier$TierDeletedPartitionsCoordinator$$lastHeartbeatMs().get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }
}

