/*
 * Decompiled with CFR 0.152.
 */
package kafka.shell;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import kafka.raft.KafkaRaftManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer;
import kafka.server.MetaProperties;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.metadata.util.ClusterMetadataSource;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.shell.TrackingListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.compat.java8.OptionConverters;

public class MetadataShellObserver
implements ClusterMetadataSource {
    private static final Logger log = LoggerFactory.getLogger(MetadataShellObserver.class);
    private final CompletableFuture<Void> caughtUpFuture = new CompletableFuture();
    private final String quorumVoters;
    private final String clusterId;
    private final KafkaRaftManager<ApiMessageAndVersion> raftManager;
    private final Path tempDir;

    static MetadataShellObserver create(String quorumVoters, String clusterId) throws Exception {
        Path tempDir = Files.createTempDirectory("MetadataShell", new FileAttribute[0]);
        Exit.addShutdownHook((String)"delete-metadata-shell-temp-dir", () -> MetadataShellObserver.cleanup(null, tempDir));
        KafkaRaftManager<ApiMessageAndVersion> raftManager = null;
        try {
            MetaProperties metaProperties = new MetaProperties(clusterId, Integer.MAX_VALUE);
            HashMap<String, String> configMap = new HashMap<String, String>();
            configMap.put("controller.quorum.voters", quorumVoters);
            configMap.put(KafkaConfig.MetadataLogDirProp(), tempDir.toAbsolutePath().toString());
            configMap.put(KafkaConfig.ProcessRolesProp(), "broker");
            configMap.put(KafkaConfig.NodeIdProp(), String.valueOf(Integer.MAX_VALUE));
            configMap.put(KafkaConfig.ControllerListenerNamesProp(), "CONTROLLER");
            KafkaConfig config = new KafkaConfig(configMap);
            CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> votersFuture = CompletableFuture.completedFuture(RaftConfig.parseVoterConnections(config.quorumVoters()));
            raftManager = new KafkaRaftManager<ApiMessageAndVersion>(metaProperties, config, (RecordSerde<ApiMessageAndVersion>)MetadataRecordSerde.INSTANCE, KafkaRaftServer.MetadataPartition(), KafkaRaftServer.MetadataTopicId(), Time.SYSTEM, new Metrics(), (Option<String>)OptionConverters.toScala(Optional.of("MetadataShellObserver")), votersFuture);
            return new MetadataShellObserver(quorumVoters, clusterId, raftManager, tempDir);
        }
        catch (Throwable e) {
            MetadataShellObserver.cleanup(raftManager, tempDir);
            throw e;
        }
    }

    static void cleanup(KafkaRaftManager<ApiMessageAndVersion> raftManager, Path tempDir) {
        if (raftManager != null) {
            try {
                raftManager.shutdown();
            }
            catch (Exception e) {
                log.error("Got exception while shutting down raftManager", (Throwable)e);
            }
        }
        if (tempDir != null) {
            try {
                Utils.delete((File)tempDir.toFile());
            }
            catch (Exception e) {
                log.error("Got exception while removing temporary directory {}", (Throwable)e);
            }
        }
    }

    public MetadataShellObserver(String quorumVoters, String clusterId, KafkaRaftManager<ApiMessageAndVersion> raftManager, Path tempDir) {
        this.quorumVoters = quorumVoters;
        this.clusterId = clusterId;
        this.raftManager = raftManager;
        this.tempDir = tempDir;
    }

    public void start(ClusterMetadataSource.Listener<ApiMessageAndVersion> listener) throws Exception {
        TrackingListener trackingListener = new TrackingListener(this.caughtUpFuture, () -> this.raftManager.client().highWatermark(), listener);
        this.caughtUpFuture.thenRun(() -> listener.refreshNodes());
        this.raftManager.register((RaftClient.Listener<ApiMessageAndVersion>)trackingListener);
        this.raftManager.startup();
    }

    public CompletableFuture<Void> caughtUpFuture() {
        return this.caughtUpFuture;
    }

    public void close() throws Exception {
        MetadataShellObserver.cleanup(this.raftManager, this.tempDir);
    }

    public String toString() {
        return "MetadataShellObserver(quorumVoters=" + this.quorumVoters + ", clusterId=" + this.clusterId + ")";
    }
}

