/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import kafka.server.link.ClusterLinkClientManager;
import kafka.server.link.ClusterLinkFilterInfo;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkStopMirrorTopic$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTopicState$StoppedMirror$;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.LocalClusterLinkAdminClient;
import kafka.server.link.MirrorTopicConfigsDelegate;
import kafka.server.link.TopicLinkPendingStoppedMirror$;
import kafka.server.link.TopicLinkState;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsSpec;
import org.apache.kafka.clients.admin.ListConsumerGroupsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rud\u0001B&M\u0001MC\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006I!\u0018\u0005\tU\u0002\u0011\t\u0011)A\u0005W\"Aa\u000e\u0001B\u0001B\u0003%q\u000e\u0003\u0006\u0002\u0002\u0001\u0011\t\u0011)A\u0005\u0003\u0007AA\"!\u0003\u0001\u0005\u0003\u0005\u000b\u0011BA\u0006\u0003#Aq!!\u0006\u0001\t\u0003\t9\u0002C\u0005\u0002&\u0001\u0001\r\u0011\"\u0003\u0002(!I\u0011q\u0006\u0001A\u0002\u0013%\u0011\u0011\u0007\u0005\t\u0003{\u0001\u0001\u0015)\u0003\u0002*!I\u0011q\b\u0001A\u0002\u0013%\u0011q\u0005\u0005\n\u0003\u0003\u0002\u0001\u0019!C\u0005\u0003\u0007B\u0001\"a\u0012\u0001A\u0003&\u0011\u0011\u0006\u0005\n\u0003\u0013\u0002\u0001\u0019!C\u0005\u0003OA\u0011\"a\u0013\u0001\u0001\u0004%I!!\u0014\t\u0011\u0005E\u0003\u0001)Q\u0005\u0003SA\u0011\"a\u0015\u0001\u0001\u0004%I!a\n\t\u0013\u0005U\u0003\u00011A\u0005\n\u0005]\u0003\u0002CA.\u0001\u0001\u0006K!!\u000b\t\u0013\u0005u\u0003\u00011A\u0005\n\u0005}\u0003\"CA9\u0001\u0001\u0007I\u0011BA:\u0011!\t9\b\u0001Q!\n\u0005\u0005\u0004\"CA=\u0001\u0001\u0007I\u0011BA0\u0011%\tY\b\u0001a\u0001\n\u0013\ti\b\u0003\u0005\u0002\u0002\u0002\u0001\u000b\u0015BA1\u0011-\t\u0019\t\u0001a\u0001\u0002\u0004%I!!\"\t\u0017\u0005e\u0005\u00011AA\u0002\u0013%\u00111\u0014\u0005\f\u0003?\u0003\u0001\u0019!A!B\u0013\t9\tC\u0006\u0002\"\u0002\u0001\r\u00111A\u0005\n\u0005\r\u0006bCAY\u0001\u0001\u0007\t\u0019!C\u0005\u0003gC1\"a.\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002&\"Y\u0011\u0011\u0018\u0001A\u0002\u0003\u0007I\u0011BA^\u0011-\t)\u000e\u0001a\u0001\u0002\u0004%I!a6\t\u0017\u0005m\u0007\u00011A\u0001B\u0003&\u0011Q\u0018\u0005\n\u0003;\u0004!\u0019!C\u0005\u0003?Dq!!9\u0001A\u0003%1\u000fC\u0005\u0002d\u0002\u0011\r\u0011\"\u0003\u0002f\"A\u0011Q\u001e\u0001!\u0002\u0013\t9\u000fC\u0004\u0002p\u0002!\t&!=\t\u000f\u0005M\b\u0001\"\u0001\u0002r\"9\u0011Q\u001f\u0001\u0005\n\u0005E\bbBA|\u0001\u0011%\u0011\u0011 \u0005\b\u0005?\u0001A\u0011\u0002B\u0011\u0011\u001d\u0011Y\u0003\u0001C\u0005\u0003cDqA!\f\u0001\t\u0013\u0011y\u0003C\u0004\u0003>\u0001!IAa\u0010\t\u000f\t\u0015\u0003\u0001\"\u0003\u0003H!9!\u0011\u000b\u0001\u0005\n\u0005E\bb\u0002B*\u0001\u0011%!Q\u000b\u0005\b\u0005O\u0002A\u0011\u0002B5\u0011\u001d\u0011\t\b\u0001C\u0005\u0005gBqAa\u001e\u0001\t\u0013\u0011I\bC\u0004\u0003\u0014\u0002!IA!&\t\u000f\t\u0005\u0006\u0001\"\u0003\u0003$\"9!1\u0016\u0001\u0005\n\t5\u0006b\u0002B_\u0001\u0011%\u0011q\u0005\u0005\b\u0005\u007f\u0003A\u0011BAy\u0011\u001d\u0011\t\r\u0001C\u0005\u0005\u0007DqAa3\u0001\t\u0013\u0011i\rC\u0004\u0003n\u0002!IAa<\t\u000f\tm\b\u0001\"\u0003\u0003~\"91\u0011\u0002\u0001\u0005\n\r-\u0001bBB\r\u0001\u0011%\u0011\u0011\u001f\u0005\b\u00077\u0001A\u0011BB\u000f\u00119\u0019I\b\u0001I\u0001\u0004\u0003\u0005I\u0011BB>\u0003#9qaa\tM\u0011\u0003\u0019)C\u0002\u0004L\u0019\"\u00051q\u0005\u0005\b\u0003+\u0011E\u0011AB\u0018\r\u0019\u0019\tD\u0011\u0001\u00044!I11\b#\u0003\u0002\u0003\u0006I!\u0018\u0005\u000b\u0007{!%\u0011!Q\u0001\n\r}\u0002bBA\u000b\t\u0012\u00051Q\t\u0005\t\u0007\u001f\u0012E\u0011\u0001'\u0004R!91q\u000b\"\u0005\n\re\u0003\"CB/\u0005F\u0005I\u0011AB0\u0005i\u0019E.^:uKJd\u0015N\\6Ti>\u0004X*\u001b:s_J$v\u000e]5d\u0015\tie*\u0001\u0003mS:\\'BA(Q\u0003\u0019\u0019XM\u001d<fe*\t\u0011+A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001!\u0006CA+Z\u001d\t1v+D\u0001M\u0013\tAF*\u0001\u000bDYV\u001cH/\u001a:MS:\\7k\u00195fIVdWM]\u0005\u00035n\u0013A\u0002U3sS>$\u0017n\u0019+bg.T!\u0001\u0017'\u0002\u000bQ|\u0007/[2\u0011\u0005y;gBA0f!\t\u00017-D\u0001b\u0015\t\u0011'+\u0001\u0004=e>|GO\u0010\u0006\u0002I\u0006)1oY1mC&\u0011amY\u0001\u0007!J,G-\u001a4\n\u0005!L'AB*ue&twM\u0003\u0002gG\u0006i1\r\\5f]Rl\u0015M\\1hKJ\u0004\"A\u00167\n\u00055d%\u0001G\"mkN$XM\u001d'j].\u001cE.[3oi6\u000bg.Y4fe\u0006\tBn\\2bY\u0006#W.\u001b8GC\u000e$xN]=\u0011\u0007A\f8/D\u0001d\u0013\t\u00118MA\u0005Gk:\u001cG/[8oaA\u0011AO`\u0007\u0002k*\u0011ao^\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003qf\fqa\u00197jK:$8O\u0003\u0002Ru*\u00111\u0010`\u0001\u0007CB\f7\r[3\u000b\u0003u\f1a\u001c:h\u0013\tyXO\u0001\bD_:4G.^3oi\u0006#W.\u001b8\u0002\u00151|7-\u00197BI6Lg\u000eE\u0002W\u0003\u000bI1!a\u0002M\u0005maunY1m\u00072,8\u000f^3s\u0019&t7.\u00113nS:\u001cE.[3oi\u0006Q\u0011N\u001c;feZ\fG.T:\u0011\u0007A\fi!C\u0002\u0002\u0010\r\u00141!\u00138u\u0013\r\t\u0019\"W\u0001\u0012e\u0016\u001c8\r[3ek2,G)\u001a7bs6\u001b\u0018A\u0002\u001fj]&$h\b\u0006\u0007\u0002\u001a\u0005m\u0011QDA\u0010\u0003C\t\u0019\u0003\u0005\u0002W\u0001!)AL\u0002a\u0001;\")!N\u0002a\u0001W\")aN\u0002a\u0001_\"9\u0011\u0011\u0001\u0004A\u0002\u0005\r\u0001\"CA\u0005\rA\u0005\t\u0019AA\u0006\u0003-\u0019\u0018P\\2ie>t\u0017N_3\u0016\u0005\u0005%\u0002c\u00019\u0002,%\u0019\u0011QF2\u0003\u000f\t{w\u000e\\3b]\u0006y1/\u001f8dQJ|g.\u001b>f?\u0012*\u0017\u000f\u0006\u0003\u00024\u0005e\u0002c\u00019\u00026%\u0019\u0011qG2\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003wA\u0011\u0011!a\u0001\u0003S\t1\u0001\u001f\u00132\u00031\u0019\u0018P\\2ie>t\u0017N_3!\u0003I)\b\u000fZ1uK\u0012$v\u000e]5d\u0007>tg-[4\u0002-U\u0004H-\u0019;fIR{\u0007/[2D_:4\u0017nZ0%KF$B!a\r\u0002F!I\u00111H\u0006\u0002\u0002\u0003\u0007\u0011\u0011F\u0001\u0014kB$\u0017\r^3e)>\u0004\u0018nY\"p]\u001aLw\rI\u0001\u0014kB$\u0017\r^3e\u000fJ|W\u000f](gMN,Go]\u0001\u0018kB$\u0017\r^3e\u000fJ|W\u000f](gMN,Go]0%KF$B!a\r\u0002P!I\u00111\b\b\u0002\u0002\u0003\u0007\u0011\u0011F\u0001\u0015kB$\u0017\r^3e\u000fJ|W\u000f](gMN,Go\u001d\u0011\u0002)U\u0004H-\u0019;fIJ+\u0007\u000f\\5dCN#\u0018\r^;t\u0003a)\b\u000fZ1uK\u0012\u0014V\r\u001d7jG\u0006\u001cF/\u0019;vg~#S-\u001d\u000b\u0005\u0003g\tI\u0006C\u0005\u0002<E\t\t\u00111\u0001\u0002*\u0005)R\u000f\u001d3bi\u0016$'+\u001a9mS\u000e\f7\u000b^1ukN\u0004\u0013A\u00078v[J+\u0007\u000f\\5dCN#\u0018\r^;t\u000bb\u001cW\r\u001d;j_:\u001cXCAA1!\u0011\t\u0019'!\u001c\u000e\u0005\u0005\u0015$\u0002BA4\u0003S\nA\u0001\\1oO*\u0011\u00111N\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002p\u0005\u0015$aB%oi\u0016<WM]\u0001\u001f]Vl'+\u001a9mS\u000e\f7\u000b^1ukN,\u0005pY3qi&|gn]0%KF$B!a\r\u0002v!I\u00111\b\u000b\u0002\u0002\u0003\u0007\u0011\u0011M\u0001\u001c]Vl'+\u001a9mS\u000e\f7\u000b^1ukN,\u0005pY3qi&|gn\u001d\u0011\u000219,X\u000eV8qS\u000e\u001cuN\u001c4jO\u0016C8-\u001a9uS>t7/\u0001\u000fok6$v\u000e]5d\u0007>tg-[4Fq\u000e,\u0007\u000f^5p]N|F%Z9\u0015\t\u0005M\u0012q\u0010\u0005\n\u0003w9\u0012\u0011!a\u0001\u0003C\n\u0011D\\;n)>\u0004\u0018nY\"p]\u001aLw-\u0012=dKB$\u0018n\u001c8tA\u0005Q\u0001/\u0019:uSRLwN\\:\u0016\u0005\u0005\u001d\u0005#\u00020\u0002\n\u00065\u0015bAAFS\n\u00191+\u001a;\u0011\t\u0005=\u0015QS\u0007\u0003\u0003#S1!a%z\u0003\u0019\u0019w.\\7p]&!\u0011qSAI\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fa\u0002]1si&$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0003\u00024\u0005u\u0005\"CA\u001e5\u0005\u0005\t\u0019AAD\u0003-\u0001\u0018M\u001d;ji&|gn\u001d\u0011\u0002-A\f'\u000f^5uS>tGj\\4F]\u0012|eMZ:fiN,\"!!*\u0011\u000fy\u000b9+!$\u0002,&\u0019\u0011\u0011V5\u0003\u00075\u000b\u0007\u000fE\u0002q\u0003[K1!a,d\u0005\u0011auN\\4\u00025A\f'\u000f^5uS>tGj\\4F]\u0012|eMZ:fiN|F%Z9\u0015\t\u0005M\u0012Q\u0017\u0005\n\u0003wi\u0012\u0011!a\u0001\u0003K\u000bq\u0003]1si&$\u0018n\u001c8M_\u001e,e\u000eZ(gMN,Go\u001d\u0011\u0002\u0019\u001d\u0014x.\u001e9GS2$XM]:\u0016\u0005\u0005u\u0006CBA`\u0003\u0013\fyM\u0004\u0003\u0002B\u0006\u0015gb\u00011\u0002D&\tA-C\u0002\u0002H\u000e\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002L\u00065'aA*fc*\u0019\u0011qY2\u0011\u0007Y\u000b\t.C\u0002\u0002T2\u0013Qc\u00117vgR,'\u000fT5oW\u001aKG\u000e^3s\u0013:4w.\u0001\the>,\bOR5mi\u0016\u00148o\u0018\u0013fcR!\u00111GAm\u0011%\tY\u0004IA\u0001\u0002\u0004\ti,A\u0007he>,\bOR5mi\u0016\u00148\u000fI\u0001\nI\u0016\u001cH/\u00113nS:,\u0012a]\u0001\u000bI\u0016\u001cH/\u00113nS:\u0004\u0013aD7fi\u0006$\u0017\r^1NC:\fw-\u001a:\u0016\u0005\u0005\u001d\bc\u0001,\u0002j&\u0019\u00111\u001e'\u00035\rcWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1NC:\fw-\u001a:\u0002!5,G/\u00193bi\u0006l\u0015M\\1hKJ\u0004\u0013a\u0001:v]R\u0011\u0011\u0011F\u0001\u000biJ\fgn]5uS>t\u0017\u0001\u00049s_\u000e,7o\u001d+pa&\u001c\u0017a\u00055b]\u0012dWMU3qY&\u001c\u0017m\u0015;biV\u001cH\u0003BA\u0015\u0003wDq!!@*\u0001\u0004\ty0\u0001\u0004sKN,H\u000e\u001e\t\b=\u0006\u001d\u0016Q\u0012B\u0001!\u0019\tyIa\u0001\u0003\b%!!QAAI\u0005-Y\u0015MZ6b\rV$XO]3\u0011\r\t%!q\u0002B\n\u001b\t\u0011YA\u0003\u0003\u0003\u000e\u0005%\u0014\u0001B;uS2LAA!\u0005\u0003\f\t!A*[:u!\u0011\u0011)Ba\u0007\u000e\u0005\t]!\u0002\u0002B\r\u0003#\u000bqA]3qY&\u001c\u0017-\u0003\u0003\u0003\u001e\t]!!\u0004*fa2L7-Y*uCR,8/\u0001\u000bqe>\u001cWm]:SKBd\u0017nY1Ti\u0006$Xo\u001d\u000b\u0005\u0003S\u0011\u0019\u0003C\u0004\u0002~*\u0002\rA!\n\u0011\u000fy\u000b9+!$\u0003(A1\u0011q\u0018B\u0015\u0005'IAA!\u0005\u0002N\u0006y1/\u001f8d)>\u0004\u0018nY\"p]\u001aLw-A\u000biC:$G.Z*z]\u000e$v\u000e]5d\u0007>tg-[4\u0015\t\u0005%\"\u0011\u0007\u0005\b\u0005ga\u0003\u0019\u0001B\u001b\u0003\u00191W\u000f^;sKB1\u0011q\u0012B\u0002\u0005o\u00012\u0001\u001eB\u001d\u0013\r\u0011Y$\u001e\u0002\u0007\u0007>tg-[4\u0002-A\u0014xnY3tgNKhn\u0019+pa&\u001c7i\u001c8gS\u001e$B!!\u000b\u0003B!9!1I\u0017A\u0002\t]\u0012a\u0003;pa&\u001c7i\u001c8gS\u001e\fa\u0003[1oI2,\u0017\t\u001c;feR{\u0007/[2D_:4\u0017n\u001a\u000b\u0005\u0003S\u0011I\u0005C\u0004\u0002~:\u0002\rAa\u0013\u0011\u0007Q\u0014i%C\u0002\u0003PU\u0014!#\u00117uKJ\u001cuN\u001c4jON\u0014Vm];mi\u0006QA.[:u\u000fJ|W\u000f]:\u0002!!\fg\u000e\u001a7f\u0019&\u001cHo\u0012:pkB\u001cH\u0003BA\u0015\u0005/BqAa\r1\u0001\u0004\u0011I\u0006\u0005\u0004\u0002\u0010\n\r!1\f\t\u0007\u0005\u0013\u0011iF!\u0019\n\t\t}#1\u0002\u0002\u000b\u0007>dG.Z2uS>t\u0007c\u0001;\u0003d%\u0019!QM;\u0003)\r{gn];nKJ<%o\\;q\u0019&\u001cH/\u001b8h\u0003E\u0001(o\\2fgNd\u0015n\u001d;He>,\bo\u001d\u000b\u0005\u0003S\u0011Y\u0007C\u0004\u0003nE\u0002\rAa\u001c\u0002\r\u001d\u0014x.\u001e9t!\u0011q\u0016\u0011R/\u0002!1L7\u000f^$s_V\u0004xJ\u001a4tKR\u001cH\u0003BA\u0015\u0005kBqA!\u001c3\u0001\u0004\u0011y'\u0001\fiC:$G.\u001a'jgR<%o\\;q\u001f\u001a47/\u001a;t)\u0011\tICa\u001f\t\u000f\tu4\u00071\u0001\u0003\u0000\u00059a-\u001e;ve\u0016\u001c\bC\u00020\u0002(v\u0013\t\t\u0005\u0004\u0002\u0010\n\r!1\u0011\t\t\u0005\u0013\u0011))!$\u0003\b&!\u0011\u0011\u0016B\u0006!\u0011\u0011IIa$\u000e\u0005\t-%b\u0001BGo\u0006A1m\u001c8tk6,'/\u0003\u0003\u0003\u0012\n-%!E(gMN,G/\u00118e\u001b\u0016$\u0018\rZ1uC\u00061b-\u001b7uKJd\u0015n\u001d;He>,\bo\u00144gg\u0016$8\u000f\u0006\u0004\u0003\u0018\ne%Q\u0014\t\b=\u0006\u001d\u0016Q\u0012BD\u0011\u0019\u0011Y\n\u000ea\u0001;\u0006)qM]8va\"9!q\u0014\u001bA\u0002\t]\u0015aB8gMN,Go]\u0001\u0012C2$XM]$s_V\u0004xJ\u001a4tKR\u001cH\u0003BA\u0015\u0005KCqAa*6\u0001\u0004\u0011I+\u0001\u0007he>,\bo\u00144gg\u0016$8\u000f\u0005\u0004_\u0003Ok&qS\u0001\u0018Q\u0006tG\r\\3BYR,'o\u0012:pkB|eMZ:fiN$B!!\u000b\u00030\"9!\u0011\u0017\u001cA\u0002\tM\u0016a\u0002:fgVdGo\u001d\t\u0007=\u0006\u001dVL!.\u0011\r\u0005=%1\u0001B\\!\u0011\t\u0019G!/\n\t\tm\u0016Q\r\u0002\u0005->LG-\u0001\u000ejgR{\u0007/[2Ti\u0006$X\rU3oI&twm\u0015;paB,G-A\bti>\u0004X*\u001b:s_J$v\u000e]5d\u0003E9'o\\;q\u001f\u001a47/\u001a;t\u0003\u0012l\u0017N\\\u000b\u0003\u0005\u000b\u00042\u0001\u001eBd\u0013\r\u0011I-\u001e\u0002\u0006\u0003\u0012l\u0017N\\\u0001\u0007S:4xn[3\u0016\t\t='Q\u001b\u000b\u0005\u0005#\u00149\u000f\u0005\u0003\u0003T\nUG\u0002\u0001\u0003\b\u0005/T$\u0019\u0001Bm\u0005\u0005!\u0016\u0003\u0002Bn\u0005C\u00042\u0001\u001dBo\u0013\r\u0011yn\u0019\u0002\b\u001d>$\b.\u001b8h!\r\u0001(1]\u0005\u0004\u0005K\u001c'aA!os\"9!\u0011\u001e\u001eA\u0002\t-\u0018AA2c!\u0011\u0001\u0018O!5\u0002'%tgo\\6f%\u0016\u0004H.[2b'R\fG/^:\u0016\t\tE(Q\u001f\u000b\u0005\u0005g\u00149\u0010\u0005\u0003\u0003T\nUHa\u0002Blw\t\u0007!\u0011\u001c\u0005\b\u0005S\\\u0004\u0019\u0001B}!\u0011\u0001\u0018Oa=\u0002+%tgo\\6f'ft7\rV8qS\u000e\u001cuN\u001c4jOV!!q`B\u0002)\u0011\u0019\ta!\u0002\u0011\t\tM71\u0001\u0003\b\u0005/d$\u0019\u0001Bm\u0011\u001d\u0011I\u000f\u0010a\u0001\u0007\u000f\u0001B\u0001]9\u0004\u0002\u00051\u0012N\u001c<pW\u0016\u001c\u0016P\\2He>,\bo\u00144gg\u0016$8/\u0006\u0003\u0004\u000e\rEACBB\b\u0007'\u0019)\u0002\u0005\u0003\u0003T\u000eEAa\u0002Bl{\t\u0007!\u0011\u001c\u0005\u0007\u00057k\u0004\u0019A/\t\u000f\t%X\b1\u0001\u0004\u0018A!\u0001/]B\b\u00031ygnQ8na2,G/[8o\u0003%)\u0007pY3qi&|g\u000e\u0006\u0004\u0004 \rU4q\u000f\t\u0004\u0007C!eB\u0001,B\u0003i\u0019E.^:uKJd\u0015N\\6Ti>\u0004X*\u001b:s_J$v\u000e]5d!\t1&iE\u0002C\u0007S\u00012\u0001]B\u0016\u0013\r\u0019ic\u0019\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\r\u0015\"!C#yG\u0016\u0004H/[8o'\r!5Q\u0007\t\u0005\u0003\u001f\u001b9$\u0003\u0003\u0004:\u0005E%AD&bM.\fW\t_2faRLwN\\\u0001\b[\u0016\u001c8/Y4f\u0003\u0005)\u0007\u0003BA`\u0007\u0003JAaa\u0011\u0002N\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u000b\u0007\u0007\u000f\u001aYe!\u0014\u0011\u0007\r%C)D\u0001C\u0011\u0019\u0019Yd\u0012a\u0001;\"91QH$A\u0002\r}\u0012aC5t%\u0016$(/[1cY\u0016$B!!\u000b\u0004T!91Q\u000b%A\u0002\r}\u0012AA3y\u000319W\r^#yG\u0016\u0004H/[8o)\u0011\u0019yda\u0017\t\u000f\rU\u0013\n1\u0001\u0004@\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*\"a!\u0019+\t\u0005-11M\u0016\u0003\u0007K\u0002Baa\u001a\u0004r5\u00111\u0011\u000e\u0006\u0005\u0007W\u001ai'A\u0005v]\u000eDWmY6fI*\u00191qN2\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004t\r%$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"111H A\u0002uCqa!\u0016@\u0001\u0004\u0019y$A\ftkB,'\u000f\n:fg\u000eDW\rZ;mK\u0012+G.Y=NgV\u0011\u00111\u0002")
public class ClusterLinkStopMirrorTopic
extends ClusterLinkScheduler.PeriodicTask {
    private final String topic;
    private final ClusterLinkClientManager clientManager;
    private final LocalClusterLinkAdminClient localAdmin;
    private boolean synchronize;
    private boolean updatedTopicConfig;
    private boolean updatedGroupOffsets;
    private boolean updatedReplicaStatus;
    private Integer numReplicaStatusExceptions;
    private Integer numTopicConfigExceptions;
    private scala.collection.immutable.Set<TopicPartition> partitions;
    private scala.collection.immutable.Map<TopicPartition, Object> partitionLogEndOffsets;
    private Seq<ClusterLinkFilterInfo> groupFilters;
    private final ConfluentAdmin destAdmin;
    private final ClusterLinkMetadataManager metadataManager;

    public static int $lessinit$greater$default$5() {
        return ClusterLinkStopMirrorTopic$.MODULE$.$lessinit$greater$default$5();
    }

    private /* synthetic */ int super$rescheduleDelayMs() {
        return super.rescheduleDelayMs();
    }

    private boolean synchronize() {
        return this.synchronize;
    }

    private void synchronize_$eq(boolean x$1) {
        this.synchronize = x$1;
    }

    private boolean updatedTopicConfig() {
        return this.updatedTopicConfig;
    }

    private void updatedTopicConfig_$eq(boolean x$1) {
        this.updatedTopicConfig = x$1;
    }

    private boolean updatedGroupOffsets() {
        return this.updatedGroupOffsets;
    }

    private void updatedGroupOffsets_$eq(boolean x$1) {
        this.updatedGroupOffsets = x$1;
    }

    private boolean updatedReplicaStatus() {
        return this.updatedReplicaStatus;
    }

    private void updatedReplicaStatus_$eq(boolean x$1) {
        this.updatedReplicaStatus = x$1;
    }

    private Integer numReplicaStatusExceptions() {
        return this.numReplicaStatusExceptions;
    }

    private void numReplicaStatusExceptions_$eq(Integer x$1) {
        this.numReplicaStatusExceptions = x$1;
    }

    private Integer numTopicConfigExceptions() {
        return this.numTopicConfigExceptions;
    }

    private void numTopicConfigExceptions_$eq(Integer x$1) {
        this.numTopicConfigExceptions = x$1;
    }

    private scala.collection.immutable.Set<TopicPartition> partitions() {
        return this.partitions;
    }

    private void partitions_$eq(scala.collection.immutable.Set<TopicPartition> x$1) {
        this.partitions = x$1;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> partitionLogEndOffsets() {
        return this.partitionLogEndOffsets;
    }

    private void partitionLogEndOffsets_$eq(scala.collection.immutable.Map<TopicPartition, Object> x$1) {
        this.partitionLogEndOffsets = x$1;
    }

    private Seq<ClusterLinkFilterInfo> groupFilters() {
        return this.groupFilters;
    }

    private void groupFilters_$eq(Seq<ClusterLinkFilterInfo> x$1) {
        this.groupFilters = x$1;
    }

    private ConfluentAdmin destAdmin() {
        return this.destAdmin;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean run() {
        this.partitions_$eq(this.metadataManager().topicPartitions(this.topic));
        if (this.partitions().isEmpty()) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(84).append("Cannot stop mirror topic for deleted topic '").append($this.topic).append("'. Shutting down stop mirror topic task.").toString());
            return this.onCompletion();
        }
        Option mirrorState = this.metadataManager().clusterLinkTopicState((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic})))).get((Object)this.topic);
        boolean bl = false;
        Some some = null;
        if (mirrorState instanceof Some) {
            bl = true;
            some = (Some)mirrorState;
            ClusterLinkTopicState clusterLinkTopicState = (ClusterLinkTopicState)some.value();
            if (clusterLinkTopicState instanceof ClusterLinkTopicState.PendingStoppedMirror) {
                boolean sync = ((ClusterLinkTopicState.PendingStoppedMirror)clusterLinkTopicState).synchronize();
                this.synchronize_$eq(sync);
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Attempting to stop mirror topic ").append($this.topic).append(" with synchronize=").append(this.synchronize()).toString());
                return this.updatedReplicaStatus() ? this.transition() : this.processTopic();
            }
        }
        if (bl) {
            ClusterLinkTopicState state = (ClusterLinkTopicState)some.value();
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("See mirror '").append(state).append("' for mirror topic '").append($this.topic).append("', not performing stop mirror topic task").toString());
            return this.onCompletion();
        }
        if (!None$.MODULE$.equals(mirrorState)) throw new MatchError((Object)mirrorState);
        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("No mirror state for mirror topic '").append($this.topic).append("', not performing stop mirror topic task").toString());
        return this.onCompletion();
    }

    public boolean transition() {
        if (this.synchronize() && !this.updatedTopicConfig()) {
            return this.syncTopicConfig();
        }
        if (!this.updatedGroupOffsets() && this.clientManager.currentConfig().consumerOffsetSyncEnable()) {
            return this.listGroups();
        }
        return this.stopMirrorTopic();
    }

    private boolean processTopic() {
        ReplicaStatusOptions options = new ReplicaStatusOptions();
        try {
            ReplicaStatusResult replicaStatusResult;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Invoking replica status on mirror topic ").append($this.topic).toString());
            try {
                ReplicaStatusResult replicaStatusResult2;
                try {
                    replicaStatusResult2 = ClusterLinkStopMirrorTopic.$anonfun$processTopic$2(this, options);
                }
                catch (ExecutionException invokeReplicaStatus_invoke_e) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered execution exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_invoke_e.getCause());
                    throw invokeReplicaStatus_invoke_e.getCause();
                }
                catch (Throwable invokeReplicaStatus_invoke_e) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_invoke_e);
                    throw invokeReplicaStatus_invoke_e;
                }
                replicaStatusResult = replicaStatusResult2;
            }
            catch (Throwable invokeReplicaStatus_e) {
                throw this.exception(new StringBuilder(36).append("While fetching replica status for '").append(this.topic).append("'").toString(), invokeReplicaStatus_e);
            }
            ReplicaStatusResult result = replicaStatusResult;
            this.numReplicaStatusExceptions_$eq(Predef$.MODULE$.int2Integer(0));
            this.scheduleWhenComplete(result.all(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.handleReplicaStatus((scala.collection.immutable.Map<TopicPartition, KafkaFuture<java.util.List<ReplicaStatus>>>)((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(result.result()).asScala()).toMap(Predef$.MODULE$.$conforms())));
            return false;
        }
        catch (Throwable e) {
            if (BoxesRunTime.equalsNumObject((Number)this.numReplicaStatusExceptions(), (Object)BoxesRunTime.boxToInteger((int)0))) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Encountered exception when trying to invoke replica status for mirror topic ").append($this.topic).append(": ").append(ClusterLinkStopMirrorTopic$.MODULE$.kafka$server$link$ClusterLinkStopMirrorTopic$$getException(e)).toString());
            } else {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(123).append("Encountered exception when trying to invoke replica status for mirror topic ").append($this.topic).append(". Replica status invocation has failed ").append(this.numReplicaStatusExceptions()).append(" times: ").append(ClusterLinkStopMirrorTopic$.MODULE$.kafka$server$link$ClusterLinkStopMirrorTopic$$getException(e)).toString());
            }
            this.numReplicaStatusExceptions_$eq(Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(this.numReplicaStatusExceptions()) + 1));
            if (ClusterLinkStopMirrorTopic$.MODULE$.isRetriable(e)) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Encountered retriable exception, will retry in ").append(this.super$rescheduleDelayMs()).toString());
                return true;
            }
            throw e;
        }
    }

    private boolean handleReplicaStatus(scala.collection.immutable.Map<TopicPartition, KafkaFuture<java.util.List<ReplicaStatus>>> result) {
        try {
            scala.collection.immutable.Map map;
            try {
                scala.collection.immutable.Map map2;
                try {
                    map2 = ClusterLinkStopMirrorTopic.$anonfun$handleReplicaStatus$1(result);
                }
                catch (ExecutionException invokeReplicaStatus_invoke_e) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered execution exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_invoke_e.getCause());
                    throw invokeReplicaStatus_invoke_e.getCause();
                }
                catch (Throwable invokeReplicaStatus_invoke_e) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_invoke_e);
                    throw invokeReplicaStatus_invoke_e;
                }
                map = map2;
            }
            catch (Throwable invokeReplicaStatus_e) {
                throw this.exception(new StringBuilder(36).append("While fetching replica status for '").append(this.topic).append("'").toString(), invokeReplicaStatus_e);
            }
            scala.collection.immutable.Map res = map;
            this.numReplicaStatusExceptions_$eq(Predef$.MODULE$.int2Integer(0));
            return this.processReplicaStatus((scala.collection.immutable.Map<TopicPartition, List<ReplicaStatus>>)res);
        }
        catch (Throwable e) {
            if (BoxesRunTime.equalsNumObject((Number)this.numReplicaStatusExceptions(), (Object)BoxesRunTime.boxToInteger((int)0))) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Encountered exception when trying to handle replica status for mirror topic ").append($this.topic).append(": ").append(ClusterLinkStopMirrorTopic$.MODULE$.kafka$server$link$ClusterLinkStopMirrorTopic$$getException(e)).toString());
            } else {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(112).append("Encountered exception when trying to handle replica status for mirror topic ").append($this.topic).append(". Replica status has failed ").append(this.numReplicaStatusExceptions()).append(" times: ").append(ClusterLinkStopMirrorTopic$.MODULE$.kafka$server$link$ClusterLinkStopMirrorTopic$$getException(e)).toString());
            }
            this.numReplicaStatusExceptions_$eq(Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(this.numReplicaStatusExceptions()) + 1));
            if (ClusterLinkStopMirrorTopic$.MODULE$.isRetriable(e)) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Encountered retriable exception, will retry in ").append(this.super$rescheduleDelayMs()).toString());
                return true;
            }
            throw e;
        }
    }

    private boolean processReplicaStatus(scala.collection.immutable.Map<TopicPartition, List<ReplicaStatus>> result) {
        this.partitionLogEndOffsets_$eq((scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)result.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition part = (TopicPartition)x0$1._1();
            List rsList = (List)x0$1._2();
            ReplicaStatus leader = (ReplicaStatus)((IterableLike)rsList.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isLeader()))).head();
            Iterable iterable = Option$.MODULE$.apply(leader.mirrorInfo().orElse(null)).exists((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkStopMirrorTopic.$anonfun$processReplicaStatus$3(this, info))) && ((LinearSeqOptimized)rsList.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isInIsr()))).forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkStopMirrorTopic.$anonfun$processReplicaStatus$5(leader, x$3))) ? Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)part), (Object)BoxesRunTime.boxToLong((long)leader.logEndOffset())))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            return iterable;
        }, Map$.MODULE$.canBuildFrom())));
        if (this.partitionLogEndOffsets().size() == result.size()) {
            this.updatedReplicaStatus_$eq(true);
            return this.transition();
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(111).append("Not all mirror partitions are ready to be stopped for mirror topic '").append($this.topic).append("', ").append("awaiting state change. Will retry in ").append(this.super$rescheduleDelayMs()).append(" ms").toString());
        return true;
    }

    private boolean syncTopicConfig() {
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, this.topic);
        ConfluentAdmin admin = this.clientManager.getAdmin();
        DescribeConfigsOptions options = new DescribeConfigsOptions();
        try {
            DescribeConfigsResult describeConfigsResult;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Syncing topic configs for mirror topic ").append($this.topic).toString());
            try {
                DescribeConfigsResult describeConfigsResult2;
                try {
                    describeConfigsResult2 = admin.describeConfigs(Collections.singleton(resource), options);
                }
                catch (ExecutionException invokeSyncTopicConfig_invoke_e) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered execution exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_invoke_e.getCause());
                    throw invokeSyncTopicConfig_invoke_e.getCause();
                }
                catch (Throwable invokeSyncTopicConfig_invoke_e) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_invoke_e);
                    throw invokeSyncTopicConfig_invoke_e;
                }
                describeConfigsResult = describeConfigsResult2;
            }
            catch (Throwable invokeSyncTopicConfig_e) {
                throw this.exception(new StringBuilder(36).append("While describing topic config for '").append(this.topic).append("'").toString(), invokeSyncTopicConfig_e);
            }
            DescribeConfigsResult result = describeConfigsResult;
            this.numTopicConfigExceptions_$eq(Predef$.MODULE$.int2Integer(0));
            this.scheduleWhenComplete(result.all(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.handleSyncTopicConfig((KafkaFuture<Config>)((KafkaFuture)result.values().get(resource))));
            return false;
        }
        catch (Throwable e) {
            if (BoxesRunTime.equalsNumObject((Number)this.numTopicConfigExceptions(), (Object)BoxesRunTime.boxToInteger((int)0))) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Encountered exception when trying invoke describeConfigs for ").append($this.topic).append(": ").append(ClusterLinkStopMirrorTopic$.MODULE$.kafka$server$link$ClusterLinkStopMirrorTopic$$getException(e)).toString());
            } else {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(100).append("Encountered exception when trying invoke describeConfigs for ").append($this.topic).append(". Topic ").append("config sync has failed ").append(this.numTopicConfigExceptions()).append(" times: ").append(ClusterLinkStopMirrorTopic$.MODULE$.kafka$server$link$ClusterLinkStopMirrorTopic$$getException(e)).toString());
            }
            this.numTopicConfigExceptions_$eq(Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(this.numTopicConfigExceptions()) + 1));
            if (ClusterLinkStopMirrorTopic$.MODULE$.isRetriable(e)) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Encountered retriable exception, will retry in ").append(this.super$rescheduleDelayMs()).toString());
                return true;
            }
            throw e;
        }
    }

    private boolean handleSyncTopicConfig(KafkaFuture<Config> future) {
        try {
            Config config;
            try {
                Config config2;
                try {
                    config2 = ClusterLinkStopMirrorTopic.$anonfun$handleSyncTopicConfig$1(future);
                }
                catch (ExecutionException invokeSyncTopicConfig_invoke_e) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered execution exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_invoke_e.getCause());
                    throw invokeSyncTopicConfig_invoke_e.getCause();
                }
                catch (Throwable invokeSyncTopicConfig_invoke_e) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_invoke_e);
                    throw invokeSyncTopicConfig_invoke_e;
                }
                config = config2;
            }
            catch (Throwable invokeSyncTopicConfig_e) {
                throw this.exception(new StringBuilder(36).append("While describing topic config for '").append(this.topic).append("'").toString(), invokeSyncTopicConfig_e);
            }
            Config config3 = config;
            this.numTopicConfigExceptions_$eq(Predef$.MODULE$.int2Integer(0));
            return this.processSyncTopicConfig(config3);
        }
        catch (Throwable e) {
            if (BoxesRunTime.equalsNumObject((Number)this.numTopicConfigExceptions(), (Object)BoxesRunTime.boxToInteger((int)0))) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Encountered exception when trying to process topic configs for mirror topic ").append($this.topic).append(": ").append(ClusterLinkStopMirrorTopic$.MODULE$.kafka$server$link$ClusterLinkStopMirrorTopic$$getException(e)).toString());
            } else {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(115).append("Encountered exception when trying to process topic configs for mirror topic ").append($this.topic).append(". Topic config sync has failed ").append(this.numTopicConfigExceptions()).append(" times: ").append(ClusterLinkStopMirrorTopic$.MODULE$.kafka$server$link$ClusterLinkStopMirrorTopic$$getException(e)).toString());
            }
            this.numTopicConfigExceptions_$eq(Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(this.numTopicConfigExceptions()) + 1));
            if (ClusterLinkStopMirrorTopic$.MODULE$.isRetriable(e)) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Encountered retriable exception, will retry in ").append(this.super$rescheduleDelayMs()).toString());
                return true;
            }
            throw e;
        }
    }

    private boolean processSyncTopicConfig(Config topicConfig) {
        boolean bl;
        block7: {
            try {
                Properties newProps;
                Properties curProps = this.metadataManager().getTopicConfig(this.topic);
                MirrorTopicConfigsDelegate mirrorTopicConfigsDelegate = new MirrorTopicConfigsDelegate(curProps, topicConfig, this.clientManager.topicConfigSyncRules());
                Properties properties = newProps = ClusterLinkUtils$.MODULE$.restrictValidateTopicConfigPolicy(this.topic, mirrorTopicConfigsDelegate.updateMirrorProps(this.topic), this.clientManager.alterConfigPolicy());
                if (properties == null ? curProps != null : !((Object)properties).equals(curProps)) {
                    if (!this.isTopicStatePendingStopped()) {
                        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(127).append("Detected stopped topic '").append($this.topic).append("' unexpectedly right before topic config was going to be changed. Shutting down stop mirror topic task.").toString());
                        bl = this.onCompletion();
                    } else {
                        HashSet newConfigs = new HashSet();
                        ((IterableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(newProps).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)newConfigs.add(new AlterConfigOp(new ConfigEntry((String)entry._1(), (String)entry._2()), AlterConfigOp.OpType.SET))));
                        AlterConfigsResult result = this.localAdmin.incrementalAlterMirrorTopicConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.TOPIC, this.topic), newConfigs));
                        this.scheduleWhenComplete(result.all(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.handleAlterTopicConfig(result));
                        bl = false;
                    }
                    break block7;
                }
                this.updatedTopicConfig_$eq(true);
                return this.transition();
            }
            catch (PolicyViolationException e) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Encountered policy violation when finalizing topic configuration for '").append($this.topic).append("', skipping topic config update").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                this.updatedTopicConfig_$eq(true);
                return this.transition();
            }
            catch (Throwable e) {
                if ((ClusterLinkStopMirrorTopic$.MODULE$.isRetriable(e) || ClusterLinkStopMirrorTopic$.MODULE$.isRetriable(e.getCause())) && this.synchronize()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Encountered retriable exception, will retry in ").append(this.super$rescheduleDelayMs()).toString());
                    return true;
                }
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(91).append("Error encountered while updating topic configuration for '").append($this.topic).append("', skipping topic config update: ").append(e).toString());
                this.updatedTopicConfig_$eq(true);
                bl = this.transition();
            }
        }
        return bl;
    }

    private boolean handleAlterTopicConfig(AlterConfigsResult result) {
        Object object = new Object();
        try {
            ((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(result.values().entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
                ClusterLinkStopMirrorTopic.$anonfun$handleAlterTopicConfig$1(this, object, entry);
                return BoxedUnit.UNIT;
            });
            this.updatedTopicConfig_$eq(true);
            return this.transition();
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    private boolean listGroups() {
        Option<String> clusterLinkPrefix = Predef$.MODULE$.Boolean2boolean(this.clientManager.currentConfig().clusterLinkPrefixConsumerGroupEnable()) ? this.clientManager.currentConfig().clusterLinkPrefix() : None$.MODULE$;
        this.groupFilters_$eq(ClusterLinkUtils$.MODULE$.clusterLinkFilters(this.clientManager.currentConfig().consumerGroupFilters(), this.clientManager.linkData().tenantPrefix(), clusterLinkPrefix));
        if (this.groupFilters().isEmpty()) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Found empty group filters, no consumer group offsets to sync.");
            this.updatedGroupOffsets_$eq(true);
            return this.transition();
        }
        Admin admin = this.groupOffsetsAdmin();
        ListConsumerGroupsOptions options = new ListConsumerGroupsOptions();
        try {
            ListConsumerGroupsResult listConsumerGroupsResult;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Syncing consumer group offsets for mirror topic ").append($this.topic).toString());
            String invokeSyncGroupOffsets_group = "(none)";
            try {
                ListConsumerGroupsResult listConsumerGroupsResult2;
                try {
                    listConsumerGroupsResult2 = admin.listConsumerGroups(options);
                }
                catch (ExecutionException invokeSyncGroupOffsets_invoke_e) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered execution exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_invoke_e.getCause());
                    throw invokeSyncGroupOffsets_invoke_e.getCause();
                }
                catch (Throwable invokeSyncGroupOffsets_invoke_e) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_invoke_e);
                    throw invokeSyncGroupOffsets_invoke_e;
                }
                listConsumerGroupsResult = listConsumerGroupsResult2;
            }
            catch (Throwable invokeSyncGroupOffsets_e) {
                throw this.exception(new StringBuilder(61).append("While updating group offsets for mirror topic '").append(this.topic).append("' and group ").append("'").append(invokeSyncGroupOffsets_group).append("'").toString(), invokeSyncGroupOffsets_e);
            }
            ListConsumerGroupsResult result = listConsumerGroupsResult;
            this.scheduleWhenComplete(result.all(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.handleListGroups((KafkaFuture<Collection<ConsumerGroupListing>>)result.all()));
            return false;
        }
        catch (Throwable e) {
            if (!this.synchronize()) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(94).append("Unable to list consumer groups. Skipping over syncing consumer group").append(" offsets for mirror topic ").append($this.topic).toString());
                this.updatedGroupOffsets_$eq(true);
                return this.transition();
            }
            if (ClusterLinkStopMirrorTopic$.MODULE$.isRetriable(e)) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Encountered exception when trying to list groups: ").append(ClusterLinkStopMirrorTopic$.MODULE$.kafka$server$link$ClusterLinkStopMirrorTopic$$getException(e)).append(" Will retry in ").append(this.super$rescheduleDelayMs()).toString());
                return true;
            }
            throw e;
        }
    }

    private boolean handleListGroups(KafkaFuture<Collection<ConsumerGroupListing>> future) {
        try {
            Collection collection;
            String invokeSyncGroupOffsets_group = "(none)";
            try {
                Collection collection2;
                try {
                    collection2 = ClusterLinkStopMirrorTopic.$anonfun$handleListGroups$1(future);
                }
                catch (ExecutionException invokeSyncGroupOffsets_invoke_e) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered execution exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_invoke_e.getCause());
                    throw invokeSyncGroupOffsets_invoke_e.getCause();
                }
                catch (Throwable invokeSyncGroupOffsets_invoke_e) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_invoke_e);
                    throw invokeSyncGroupOffsets_invoke_e;
                }
                collection = collection2;
            }
            catch (Throwable invokeSyncGroupOffsets_e) {
                throw this.exception(new StringBuilder(61).append("While updating group offsets for mirror topic '").append(this.topic).append("' and group ").append("'").append(invokeSyncGroupOffsets_group).append("'").toString(), invokeSyncGroupOffsets_e);
            }
            Collection result = collection;
            return this.processListGroups((scala.collection.immutable.Set<String>)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(result).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.groupId(), Iterable$.MODULE$.canBuildFrom())).toSet());
        }
        catch (Throwable e) {
            if (!this.synchronize()) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(110).append("Unable to process list consumer groups request. Skipping over syncing").append(" consumer group offsets for mirror topic ").append($this.topic).toString());
                this.updatedGroupOffsets_$eq(true);
                return this.transition();
            }
            if (ClusterLinkStopMirrorTopic$.MODULE$.isRetriable(e)) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Encountered exception when trying to handle list groups: ").append(ClusterLinkStopMirrorTopic$.MODULE$.kafka$server$link$ClusterLinkStopMirrorTopic$$getException(e)).append(" Will retry in ").append(this.super$rescheduleDelayMs()).toString());
                return true;
            }
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean processListGroups(scala.collection.immutable.Set<String> groups) {
        void var3_3;
        Tuple2<scala.collection.immutable.Set<String>, Seq<ClusterLinkFilterInfo>> tuple2 = ClusterLinkUtils$.MODULE$.doFilter(groups, this.groupFilters());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set matchedGroups = (scala.collection.immutable.Set)tuple2._1();
        if (var3_3.isEmpty()) {
            this.updatedGroupOffsets_$eq(true);
            return this.transition();
        }
        return this.listGroupOffsets((scala.collection.immutable.Set<String>)var3_3);
    }

    private boolean listGroupOffsets(scala.collection.immutable.Set<String> groups) {
        ListConsumerGroupOffsetsSpec spec = new ListConsumerGroupOffsetsSpec().topicPartitions((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)this.partitions().toList()).asJava());
        Admin admin = this.groupOffsetsAdmin();
        ObjectRef futures = ObjectRef.create((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        scala.collection.mutable.Set unSyncedGroups = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        groups.foreach((Function1 & Serializable & scala.Serializable)group -> {
            ClusterLinkStopMirrorTopic.$anonfun$listGroupOffsets$1(this, admin, spec, futures, unSyncedGroups, group);
            return BoxedUnit.UNIT;
        });
        if (unSyncedGroups.nonEmpty()) {
            if (!this.synchronize()) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(146).append("Got errors when trying to sync the following consumer groups' offsets when").append(" listing consumer group offsets. These consumer groups will be ").append("skipped: ").append(unSyncedGroups).toString());
            } else {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("Got errors when trying to sync consumer groups' offsets when listing consumer").append(" group offsets. Will retry again in ").append(this.super$rescheduleDelayMs()).append(".").toString());
                return true;
            }
        }
        if (((scala.collection.immutable.Map)futures.elem).isEmpty()) {
            this.updatedGroupOffsets_$eq(true);
            return this.transition();
        }
        KafkaFuture all = KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])((scala.collection.immutable.Map)futures.elem).values().toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class))));
        this.scheduleWhenComplete(all, (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.handleListGroupOffsets((scala.collection.immutable.Map<String, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>>)((scala.collection.immutable.Map)futures$1.elem)));
        return false;
    }

    private boolean handleListGroupOffsets(scala.collection.immutable.Map<String, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>> futures) {
        scala.collection.mutable.Set unSyncedGroups = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.immutable.Map groupOffsets = (scala.collection.immutable.Map)((MapLike)futures.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> map;
            String group;
            if (x0$1 != null) {
                group = (String)x0$1._1();
                try {
                    java.util.Map map2;
                    try {
                        java.util.Map map3;
                        try {
                            map3 = ClusterLinkStopMirrorTopic.$anonfun$handleListGroupOffsets$2((KafkaFuture)x0$1._2());
                        }
                        catch (ExecutionException invokeSyncGroupOffsets_invoke_e) {
                            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered execution exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_invoke_e.getCause());
                            throw invokeSyncGroupOffsets_invoke_e.getCause();
                        }
                        catch (Throwable invokeSyncGroupOffsets_invoke_e) {
                            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_invoke_e);
                            throw invokeSyncGroupOffsets_invoke_e;
                        }
                        map2 = map3;
                    }
                    catch (Throwable invokeSyncGroupOffsets_e) {
                        throw this.exception(new StringBuilder(61).append("While updating group offsets for mirror topic '").append($this.topic).append("' and group ").append("'").append(group).append("'").toString(), invokeSyncGroupOffsets_e);
                    }
                    java.util.Map result = map2;
                    map = this.filterListGroupOffsets(group, (scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(result).asScala()).toMap(Predef$.MODULE$.$conforms()));
                }
                catch (Throwable e) {
                    unSyncedGroups.$plus$eq((Object)group);
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Encountered error when trying to handle list consumer offsets request for ").append("group ").append(group).append(": ").append(e).toString());
                    map = Predef$.MODULE$.Map().empty();
                }
            } else {
                throw new MatchError(null);
            }
            scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> res = map;
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group), res);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkStopMirrorTopic.$anonfun$handleListGroupOffsets$4(x$5)));
        if (unSyncedGroups.nonEmpty()) {
            if (!this.synchronize()) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(163).append("Got errors when trying to sync the following consumer groups' offsets ").append("when handling the list consumer group offset request. These consumer ").append("groups will be skipped: ").append(unSyncedGroups).toString());
            } else {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(145).append("Got errors when trying to sync the following consumer groups' offsets").append(" when handling the list consumer group offset request. Will retry again in").append(" ").append(this.super$rescheduleDelayMs()).append(".").toString());
                return true;
            }
        }
        if (groupOffsets.isEmpty()) {
            this.updatedGroupOffsets_$eq(true);
            return this.transition();
        }
        if (!this.isTopicStatePendingStopped()) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(129).append("Detected stopped topic '").append($this.topic).append("' unexpectedly right before group offsets were going to be altered. Shutting down stop mirror topic task.").toString());
            return this.onCompletion();
        }
        return this.alterGroupOffsets((scala.collection.immutable.Map<String, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)groupOffsets);
    }

    private scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> filterListGroupOffsets(String group, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets) {
        return (scala.collection.immutable.Map)offsets.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) throw new MatchError(null);
            TopicPartition partition = (TopicPartition)x0$1._1();
            OffsetAndMetadata offsetMeta = (OffsetAndMetadata)x0$1._2();
            Option option = this.partitionLogEndOffsets().get((Object)partition);
            if (option instanceof Some) {
                Object object;
                long logEndOffset = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                if (offsetMeta == null) {
                    object = None$.MODULE$;
                } else if (logEndOffset < offsetMeta.offset()) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Rolling back offset for group '").append(group).append("' and topic '").append($this.topic).append("' from '").append(offsetMeta.offset()).append(" to '").append(logEndOffset).append("'").toString());
                    object = new Some((Object)BoxesRunTime.boxToLong((long)logEndOffset));
                } else {
                    object = this.synchronize() ? new Some((Object)BoxesRunTime.boxToLong((long)offsetMeta.offset())) : None$.MODULE$;
                }
                None$ offset = object;
                return Option$.MODULE$.option2Iterable(offset.map((Function1 & Serializable & scala.Serializable)off -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)new OffsetAndMetadata(BoxesRunTime.unboxToLong((Object)off), offsetMeta.leaderEpoch(), offsetMeta.metadata()))));
            }
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Unexpected partition '").append(partition).append("', skipping").toString());
            return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }, Map$.MODULE$.canBuildFrom());
    }

    private boolean alterGroupOffsets(scala.collection.immutable.Map<String, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> groupOffsets) {
        AlterConsumerGroupOffsetsOptions options = new AlterConsumerGroupOffsetsOptions();
        ObjectRef futures = ObjectRef.create((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        scala.collection.mutable.Set unSyncedGroups = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        groupOffsets.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClusterLinkStopMirrorTopic.$anonfun$alterGroupOffsets$1(this, options, futures, unSyncedGroups, x0$1);
            return BoxedUnit.UNIT;
        });
        if (unSyncedGroups.nonEmpty()) {
            if (!this.synchronize()) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(151).append("Got errors when trying to sync the following consumer groups' offsets when ").append("altering the consumer group offsets. These consumer groups will be skipped: ").append(unSyncedGroups).toString());
            } else {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(133).append("Got errors when trying to sync the following consumer groups' offsets when ").append("altering the consumer group offsets. Will retry again in ").append(this.super$rescheduleDelayMs()).append(".").toString());
                return true;
            }
        }
        if (((scala.collection.immutable.Map)futures.elem).isEmpty()) {
            this.updatedGroupOffsets_$eq(true);
            return this.transition();
        }
        KafkaFuture all = KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])((scala.collection.immutable.Map)futures.elem).values().toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class))));
        this.scheduleWhenComplete(all, (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.handleAlterGroupOffsets((scala.collection.immutable.Map<String, KafkaFuture<Void>>)((scala.collection.immutable.Map)futures$2.elem)));
        return false;
    }

    private boolean handleAlterGroupOffsets(scala.collection.immutable.Map<String, KafkaFuture<Void>> results) {
        scala.collection.mutable.Set unSyncedGroups = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        results.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Void void_;
            if (x0$1 != null) {
                String group = (String)x0$1._1();
                try {
                    Void void_2;
                    try {
                        Void void_3;
                        try {
                            void_3 = ClusterLinkStopMirrorTopic.$anonfun$handleAlterGroupOffsets$2((KafkaFuture)x0$1._2());
                        }
                        catch (ExecutionException invokeSyncGroupOffsets_invoke_e) {
                            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered execution exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_invoke_e.getCause());
                            throw invokeSyncGroupOffsets_invoke_e.getCause();
                        }
                        catch (Throwable invokeSyncGroupOffsets_invoke_e) {
                            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_invoke_e);
                            throw invokeSyncGroupOffsets_invoke_e;
                        }
                        void_2 = void_3;
                    }
                    catch (Throwable invokeSyncGroupOffsets_e) {
                        throw this.exception(new StringBuilder(61).append("While updating group offsets for mirror topic '").append($this.topic).append("' and group ").append("'").append(group).append("'").toString(), invokeSyncGroupOffsets_e);
                    }
                    void_ = void_2;
                }
                catch (Throwable e) {
                    unSyncedGroups.$plus$eq((Object)group);
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(83).append("Encountered error when trying to handle alter consumer offsets request for ").append("group ").append(group).append(": ").append(e).toString());
                    void_ = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError(null);
            }
            Void void_4 = void_;
            return void_4;
        });
        if (unSyncedGroups.nonEmpty()) {
            if (!this.synchronize()) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(164).append("Got errors when trying to sync the following consumer groups' offsets when ").append("handling the alter consumer group offset request. These consumer groups will be ").append("skipped: ").append(unSyncedGroups).toString());
            } else {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(146).append("Got errors when trying to sync the following consumer groups' offsets when ").append("handling the alter consumer group offset request. Will retry again in ").append(this.super$rescheduleDelayMs()).append(".").toString());
                return true;
            }
        }
        this.updatedGroupOffsets_$eq(true);
        return this.transition();
    }

    private boolean isTopicStatePendingStopped() {
        return this.metadataManager().clusterLinkTopicState((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic})))).get((Object)this.topic).exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkStopMirrorTopic.$anonfun$isTopicStatePendingStopped$1(x$6)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean stopMirrorTopic() {
        if (this.metadataManager().topicPartitions(this.topic).size() != this.partitions().size()) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Detected change in partitions while stopping mirror topic. Retrying consumer group offset sync.");
            this.updatedGroupOffsets_$eq(false);
            return this.transition();
        }
        boolean bl = false;
        Some some = null;
        Option option = this.metadataManager().clusterLinkTopicState((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic})))).get((Object)this.topic);
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            ClusterLinkTopicState clusterLinkTopicState = (ClusterLinkTopicState)some.value();
            if (clusterLinkTopicState instanceof ClusterLinkTopicState.PendingStoppedMirror) {
                ClusterLinkTopicState.PendingStoppedMirror pendingStoppedMirror = (ClusterLinkTopicState.PendingStoppedMirror)clusterLinkTopicState;
                String linkName = pendingStoppedMirror.linkName();
                UUID linkId = pendingStoppedMirror.linkId();
                Uuid sourceTopicId = pendingStoppedMirror.sourceTopicId();
                long timeMs = pendingStoppedMirror.timeMs();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(80).append("Recording stopped log end offsets for mirror topic ").append($this.topic).append(" and setting state to Stopped").toString());
                List logEndOffsets = (List)((List)this.partitionLogEndOffsets().toList().sortBy((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)ClusterLinkStopMirrorTopic.$anonfun$stopMirrorTopic$3(x$7)), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8._2$mcJ$sp()), List$.MODULE$.canBuildFrom());
                ClusterLinkTopicState.StoppedMirror newState = new ClusterLinkTopicState.StoppedMirror(linkName, linkId, sourceTopicId, (Seq<Object>)logEndOffsets, ClusterLinkTopicState$StoppedMirror$.MODULE$.apply$default$5());
                try {
                    this.clientManager.metadataManager().setMirrorTopicState(this.topic, (Option<ClusterLinkTopicState>)new Some((Object)newState));
                    long timeToStopMirrorTopicMs = Time.SYSTEM.milliseconds() - timeMs;
                    if (this.synchronize()) {
                        this.clientManager.metrics().timeToStopMirrorTopicPromoteSensor().record((double)timeToStopMirrorTopicMs);
                    } else {
                        this.clientManager.metrics().timeToStopMirrorTopicFailoverSensor().record((double)timeToStopMirrorTopicMs);
                    }
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Mirror topic ").append($this.topic).append(" took ").append(timeToStopMirrorTopicMs).append(" ms to transition to STOPPED state with synchronize=").append(this.synchronize()).append(".").toString());
                    return this.onCompletion();
                }
                catch (Throwable ex) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(90).append("Failed to update the stopped state for mirror topic ").append($this.topic).append(". Retrying the ").append("task to stop the mirror").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> ex);
                    throw ex;
                }
            }
        }
        if (bl) {
            ClusterLinkTopicState state = (ClusterLinkTopicState)some.value();
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(84).append("See cluster link state '").append(state).append("' for mirror topic '").append($this.topic).append("', not performing stop ").append("mirror topic task").toString());
            return this.onCompletion();
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(80).append("No cluster link state for mirror topic '").append($this.topic).append("', not performing stop mirror ").append("topic task").toString());
        return this.onCompletion();
    }

    private Admin groupOffsetsAdmin() {
        if (this.synchronize()) {
            return this.clientManager.getAdmin();
        }
        return this.destAdmin();
    }

    private <T> T invoke(Function0<T> cb) {
        try {
            return (T)cb.apply();
        }
        catch (ExecutionException e) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered execution exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_invoke_e.getCause());
            throw e.getCause();
        }
        catch (Throwable e) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_invoke_e);
            throw e;
        }
    }

    private <T> T invokeReplicaStatus(Function0<T> cb) {
        try {
            Object object;
            try {
                object = cb.apply();
            }
            catch (ExecutionException invoke_e) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered execution exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_invoke_e.getCause());
                throw invoke_e.getCause();
            }
            catch (Throwable invoke_e) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_invoke_e);
                throw invoke_e;
            }
            return (T)object;
        }
        catch (Throwable e) {
            throw this.exception(new StringBuilder(36).append("While fetching replica status for '").append(this.topic).append("'").toString(), e);
        }
    }

    private <T> T invokeSyncTopicConfig(Function0<T> cb) {
        try {
            Object object;
            try {
                object = cb.apply();
            }
            catch (ExecutionException invoke_e) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered execution exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_invoke_e.getCause());
                throw invoke_e.getCause();
            }
            catch (Throwable invoke_e) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_invoke_e);
                throw invoke_e;
            }
            return (T)object;
        }
        catch (Throwable e) {
            throw this.exception(new StringBuilder(36).append("While describing topic config for '").append(this.topic).append("'").toString(), e);
        }
    }

    private <T> T invokeSyncGroupOffsets(String group, Function0<T> cb) {
        try {
            Object object;
            try {
                object = cb.apply();
            }
            catch (ExecutionException invoke_e) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered execution exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_invoke_e.getCause());
                throw invoke_e.getCause();
            }
            catch (Throwable invoke_e) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_invoke_e);
                throw invoke_e;
            }
            return (T)object;
        }
        catch (Throwable e) {
            throw this.exception(new StringBuilder(61).append("While updating group offsets for mirror topic '").append(this.topic).append("' and group ").append("'").append(group).append("'").toString(), e);
        }
    }

    private boolean onCompletion() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down stop mirror topic task.");
        this.shutdown();
        return true;
    }

    private Exception exception(String message, Throwable ex) {
        Exception exception;
        if (ex instanceof ExecutionException) {
            ExecutionException executionException = (ExecutionException)ex;
            exception = new Exception(message, executionException.getCause());
        } else if (ex != null) {
            exception = new Exception(message, ex);
        } else {
            throw new MatchError(null);
        }
        return exception;
    }

    public static final /* synthetic */ ReplicaStatusResult $anonfun$processTopic$2(ClusterLinkStopMirrorTopic $this, ReplicaStatusOptions options$1) {
        return $this.destAdmin().replicaStatus((Set)CollectionConverters$.MODULE$.setAsJavaSetConverter($this.partitions()).asJava(), options$1);
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$handleReplicaStatus$1(scala.collection.immutable.Map result$2) {
        return (scala.collection.immutable.Map)result$2.map((Function1 & Serializable & scala.Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e._1()), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)((KafkaFuture)e._2()).get()).asScala()).toList()), Map$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$processReplicaStatus$3(ClusterLinkStopMirrorTopic $this, ReplicaStatus.MirrorInfo info) {
        block3: {
            block2: {
                ReplicaStatus.MirrorInfo.State state = info.state();
                ReplicaStatus.MirrorInfo.State state2 = ReplicaStatus.MirrorInfo.State.PENDING_STOPPED;
                if (!(state == null ? state2 != null : !state.equals(state2))) break block2;
                if ($this.synchronize()) break block3;
                ReplicaStatus.MirrorInfo.State state3 = info.state();
                ReplicaStatus.MirrorInfo.State state4 = ReplicaStatus.MirrorInfo.State.LINK_FAILED;
                if (state3 != null ? !state3.equals(state4) : state4 != null) break block3;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$processReplicaStatus$5(ReplicaStatus leader$1, ReplicaStatus x$3) {
        return x$3.logEndOffset() == leader$1.logEndOffset();
    }

    public static final /* synthetic */ Config $anonfun$handleSyncTopicConfig$1(KafkaFuture future$1) {
        return (Config)future$1.get();
    }

    public static final /* synthetic */ void $anonfun$handleAlterTopicConfig$1(ClusterLinkStopMirrorTopic $this, Object nonLocalReturnKey1$1, Map.Entry entry) {
        String topic = ((ConfigResource)entry.getKey()).name();
        try {
            ((KafkaFuture)entry.getValue()).get();
            $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Successfully updated configuration for mirror topic ").append(topic).toString());
            return;
        }
        catch (Throwable e) {
            if ((ClusterLinkStopMirrorTopic$.MODULE$.isRetriable(e) || ClusterLinkStopMirrorTopic$.MODULE$.isRetriable(e.getCause())) && $this.synchronize()) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Encountered retriable exception, will retry in ").append($this.super$rescheduleDelayMs()).toString());
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Error encountered while altering configuration on mirror topic ").append(topic).append(": ").append(e).toString());
            return;
        }
    }

    public static final /* synthetic */ Collection $anonfun$handleListGroups$1(KafkaFuture future$2) {
        return (Collection)future$2.get();
    }

    public static final /* synthetic */ void $anonfun$listGroupOffsets$1(ClusterLinkStopMirrorTopic $this, Admin admin$3, ListConsumerGroupOffsetsSpec spec$1, ObjectRef futures$1, scala.collection.mutable.Set unSyncedGroups$1, String group) {
        try {
            ListConsumerGroupOffsetsResult listConsumerGroupOffsetsResult;
            try {
                ListConsumerGroupOffsetsResult listConsumerGroupOffsetsResult2;
                try {
                    listConsumerGroupOffsetsResult2 = admin$3.listConsumerGroupOffsets(Collections.singletonMap(group, spec$1), new ListConsumerGroupOffsetsOptions());
                }
                catch (ExecutionException invokeSyncGroupOffsets_invoke_e) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered execution exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_invoke_e.getCause());
                    throw invokeSyncGroupOffsets_invoke_e.getCause();
                }
                catch (Throwable invokeSyncGroupOffsets_invoke_e) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_invoke_e);
                    throw invokeSyncGroupOffsets_invoke_e;
                }
                listConsumerGroupOffsetsResult = listConsumerGroupOffsetsResult2;
            }
            catch (Throwable invokeSyncGroupOffsets_e) {
                throw $this.exception(new StringBuilder(61).append("While updating group offsets for mirror topic '").append($this.topic).append("' and group ").append("'").append(group).append("'").toString(), invokeSyncGroupOffsets_e);
            }
            ListConsumerGroupOffsetsResult result = listConsumerGroupOffsetsResult;
            futures$1.elem = ((scala.collection.immutable.Map)futures$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group), (Object)result.partitionsToOffsetAndMetadata()));
            return;
        }
        catch (Throwable e) {
            unSyncedGroups$1.$plus$eq((Object)group);
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Encountered error when trying to list consumer offsets for group ").append(group).append(": ").append(e).toString());
            return;
        }
    }

    public static final /* synthetic */ java.util.Map $anonfun$handleListGroupOffsets$2(KafkaFuture future$3) {
        return (java.util.Map)future$3.get();
    }

    public static final /* synthetic */ boolean $anonfun$handleListGroupOffsets$4(Tuple2 x$5) {
        return ((MapLike)x$5._2()).isEmpty();
    }

    public static final /* synthetic */ AlterConsumerGroupOffsetsResult $anonfun$alterGroupOffsets$2(ClusterLinkStopMirrorTopic $this, String group$4, scala.collection.immutable.Map offsets$1, AlterConsumerGroupOffsetsOptions options$4) {
        return $this.destAdmin().alterConsumerGroupOffsets(group$4, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsets$1).asJava(), options$4);
    }

    public static final /* synthetic */ void $anonfun$alterGroupOffsets$1(ClusterLinkStopMirrorTopic $this, AlterConsumerGroupOffsetsOptions options$4, ObjectRef futures$2, scala.collection.mutable.Set unSyncedGroups$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            String group = (String)x0$1._1();
            scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)x0$1._2();
            try {
                AlterConsumerGroupOffsetsResult alterConsumerGroupOffsetsResult;
                try {
                    AlterConsumerGroupOffsetsResult alterConsumerGroupOffsetsResult2;
                    try {
                        alterConsumerGroupOffsetsResult2 = ClusterLinkStopMirrorTopic.$anonfun$alterGroupOffsets$2($this, group, offsets, options$4);
                    }
                    catch (ExecutionException invokeSyncGroupOffsets_invoke_e) {
                        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered execution exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_invoke_e.getCause());
                        throw invokeSyncGroupOffsets_invoke_e.getCause();
                    }
                    catch (Throwable invokeSyncGroupOffsets_invoke_e) {
                        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_invoke_e);
                        throw invokeSyncGroupOffsets_invoke_e;
                    }
                    alterConsumerGroupOffsetsResult = alterConsumerGroupOffsetsResult2;
                }
                catch (Throwable invokeSyncGroupOffsets_e) {
                    throw $this.exception(new StringBuilder(61).append("While updating group offsets for mirror topic '").append($this.topic).append("' and group ").append("'").append(group).append("'").toString(), invokeSyncGroupOffsets_e);
                }
                AlterConsumerGroupOffsetsResult result = alterConsumerGroupOffsetsResult;
                futures$2.elem = ((scala.collection.immutable.Map)futures$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group), (Object)result.all()));
                return;
            }
            catch (Throwable e) {
                unSyncedGroups$3.$plus$eq((Object)group);
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Encountered error when trying to alter consumer offsets for group ").append(group).append(": ").append(e).toString());
                return;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Void $anonfun$handleAlterGroupOffsets$2(KafkaFuture future$4) {
        return (Void)future$4.get();
    }

    public static final /* synthetic */ boolean $anonfun$isTopicStatePendingStopped$1(ClusterLinkTopicState x$6) {
        TopicLinkState topicLinkState = x$6.state();
        TopicLinkPendingStoppedMirror$ topicLinkPendingStoppedMirror$ = TopicLinkPendingStoppedMirror$.MODULE$;
        return !(topicLinkState != null ? !topicLinkState.equals(topicLinkPendingStoppedMirror$) : topicLinkPendingStoppedMirror$ != null);
    }

    public static final /* synthetic */ int $anonfun$stopMirrorTopic$3(Tuple2 x$7) {
        return ((TopicPartition)x$7._1()).partition();
    }

    public ClusterLinkStopMirrorTopic(String topic, ClusterLinkClientManager clientManager, Function0<ConfluentAdmin> localAdminFactory, LocalClusterLinkAdminClient localAdmin, int intervalMs) {
        this.topic = topic;
        this.clientManager = clientManager;
        this.localAdmin = localAdmin;
        super(clientManager.scheduler(), "StopMirrorTopic", intervalMs);
        this.synchronize = true;
        this.updatedTopicConfig = false;
        this.updatedGroupOffsets = false;
        this.updatedReplicaStatus = false;
        this.numReplicaStatusExceptions = Predef$.MODULE$.int2Integer(0);
        this.numTopicConfigExceptions = Predef$.MODULE$.int2Integer(0);
        this.destAdmin = (ConfluentAdmin)localAdminFactory.apply();
        this.metadataManager = clientManager.metadataManager();
    }

    public static class Exception
    extends KafkaException {
        public Exception(String message, Throwable e) {
            super(message, e);
        }
    }
}

