/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import kafka.network.SocketServer;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkConnectionManager;
import kafka.server.link.ClusterLinkDestConnectionManager;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetadataThread;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.ConnectionMode;
import kafka.server.link.ConnectionMode$Outbound$;
import kafka.server.link.CoordinatorListener;
import kafka.server.link.LinkMode;
import kafka.server.link.LinkMode$Source$;
import kafka.server.link.RemoteNetworkClient;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientInterceptor;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.clients.admin.internals.ConfluentAdminUtils;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.NetworkException;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.message.InitiateReverseConnectionsRequestData;
import org.apache.kafka.common.message.ReverseConnectionRequestData;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ReverseChannel;
import org.apache.kafka.common.network.ReverseNode;
import org.apache.kafka.common.requests.InitiateReverseConnectionsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\rua\u0001B\u001d;\u0001\u0005C\u0011\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!U,\t\u0011a\u0003!\u0011!Q\u0001\neC\u0011\u0002\u0018\u0001\u0003\u0002\u0003\u0006I!\u00186\t\u0011-\u0004!\u0011!Q\u0001\n1D\u0001b\u001f\u0001\u0003\u0002\u0003\u0006I\u0001 \u0005\n\u007f\u0002\u0011\t\u0011)A\u0005\u0003\u0003A!\"a\u0002\u0001\u0005\u0003\u0005\u000b\u0011BA\u0005\u0011)\t)\u0002\u0001B\u0001B\u0003%\u0011q\u0003\u0005\u000b\u0003?\u0001!\u0011!Q\u0001\n\u0005\u0005\u0002BCA\u0018\u0001\t\u0005\t\u0015!\u0003\u00022!9\u0011\u0011\t\u0001\u0005\u0002\u0005\r\u0003\"CA.\u0001\t\u0007I\u0011BA/\u0011!\ty\u0007\u0001Q\u0001\n\u0005}\u0003\"CA9\u0001\t\u0007I\u0011BA:\u0011!\tY\n\u0001Q\u0001\n\u0005U\u0004\"CAO\u0001\t\u0007I\u0011BA:\u0011!\ty\n\u0001Q\u0001\n\u0005U\u0004bCAQ\u0001\u0001\u0007\t\u0019!C\u0005\u0003GC1\"!,\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00020\"Y\u00111\u0018\u0001A\u0002\u0003\u0005\u000b\u0015BAS\u0011-\t)\r\u0001a\u0001\u0002\u0004%I!a2\t\u0017\u0005M\u0007\u00011AA\u0002\u0013%\u0011Q\u001b\u0005\f\u00033\u0004\u0001\u0019!A!B\u0013\tI\rC\u0006\u0002^\u0002\u0001\r\u00111A\u0005\n\u0005}\u0007bCAw\u0001\u0001\u0007\t\u0019!C\u0005\u0003_D1\"a=\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002b\"I\u0011q\u001f\u0001A\u0002\u0013%\u0011\u0011 \u0005\n\u0005\u0007\u0001\u0001\u0019!C\u0005\u0005\u000bA\u0001B!\u0003\u0001A\u0003&\u00111 \u0005\b\u0005\u001b\u0001A\u0011\tB\b\u0011!\u0011\t\u0002\u0001C!u\tM\u0001b\u0002B\u0015\u0001\u0011\u0005#q\u0002\u0005\b\u0005W\u0001A\u0011\tB\u0017\u0011\u001d\u0011I\u0005\u0001C!\u0005\u0017BqA!\"\u0001\t\u0003\u00129\tC\u0004\u0003\u001e\u0002!IAa(\t\u000f\tU\u0006\u0001\"\u0003\u00038\"9!q\u0018\u0001\u0005B\t\u0005\u0007b\u0002Bg\u0001\u0011\u0005#q\u001a\u0005\b\u00057\u0004A\u0011\tB\b\u0011\u001d\u0011i\u000e\u0001C\u0005\u0005\u001fAqAa8\u0001\t#\u0012y\u0001C\u0004\u0003b\u0002!\tFa\u0004\t\u0011\t\r\b\u0001\"\u0001;\u0005KD\u0001Ba:\u0001\t\u0003Q$\u0011\u001e\u0005\b\u0005W\u0004A\u0011\u0002Bw\u0011\u001d\u0011\u0019\u0010\u0001C\u0005\u0005kDqA!@\u0001\t\u0013\u0011y\u0001C\u0004\u0003~\u0002!IAa@\t\u000f\r\r\u0001\u0001\"\u0003\u0003\u0010!91Q\u0001\u0001\u0005\n\t=\u0001bBB\u0004\u0001\u0011%!q\u0002\u0005\b\u0007\u0013\u0001A\u0011BB\u0006\u0011\u001d\u0019\t\u0002\u0001C\t\u0007'Aqaa\u0006\u0001\t\u0003\u001aI\u0002C\u0004\u0004\u001c\u0001!\te!\u0007\u0003E\rcWo\u001d;fe2Kgn[*pkJ\u001cWmQ8o]\u0016\u001cG/[8o\u001b\u0006t\u0017mZ3s\u0015\tYD(\u0001\u0003mS:\\'BA\u001f?\u0003\u0019\u0019XM\u001d<fe*\tq(A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001\u0011e)\u0014\t\u0003\u0007\u0012k\u0011AO\u0005\u0003\u000bj\u0012Ad\u00117vgR,'\u000fT5oW\u000e{gN\\3di&|g.T1oC\u001e,'\u000f\u0005\u0002H\u0015:\u00111\tS\u0005\u0003\u0013j\n!c\u00117vgR,'\u000fT5oW\u001a\u000b7\r^8ss&\u00111\n\u0014\u0002\u0018'>,(oY3D_:tWm\u0019;j_:l\u0015M\\1hKJT!!\u0013\u001e\u0011\u0005\rs\u0015BA(;\u0005M\u0019un\u001c:eS:\fGo\u001c:MSN$XM\\3s\u0003!a\u0017N\\6ECR\f\u0007C\u0001*V\u001b\u0005\u0019&B\u0001+?\u0003\tQ8.\u0003\u0002W'\ny1\t\\;ti\u0016\u0014H*\u001b8l\t\u0006$\u0018-\u0003\u0002Q\t\u0006i\u0011N\\5uS\u0006d7i\u001c8gS\u001e\u0004\"a\u0011.\n\u0005mS$!E\"mkN$XM\u001d'j].\u001cuN\u001c4jO\u0006\u0019Bn\\2bY2{w-[2bY\u000ecWo\u001d;feB\u0011al\u001a\b\u0003?\u0016\u0004\"\u0001Y2\u000e\u0003\u0005T!A\u0019!\u0002\rq\u0012xn\u001c;?\u0015\u0005!\u0017!B:dC2\f\u0017B\u00014d\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001.\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0019\u001c\u0017B\u0001/E\u0003E\u0019G.[3oi&sG/\u001a:dKB$xN\u001d\t\u0004[:\u0004X\"A2\n\u0005=\u001c'AB(qi&|g\u000e\u0005\u0002rs6\t!O\u0003\u0002ti\u000691\r\\5f]R\u001c(BA v\u0015\t1x/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002q\u0006\u0019qN]4\n\u0005i\u0014(!E\"mS\u0016tG/\u00138uKJ\u001cW\r\u001d;pe\u00069Q.\u001a;sS\u000e\u001c\bCA\"~\u0013\tq(H\u0001\nDYV\u001cH/\u001a:MS:\\W*\u001a;sS\u000e\u001c\u0018aD7fi\u0006$\u0017\r^1NC:\fw-\u001a:\u0011\u0007\r\u000b\u0019!C\u0002\u0002\u0006i\u0012!d\u00117vgR,'\u000fT5oW6+G/\u00193bi\u0006l\u0015M\\1hKJ\fAb]8dW\u0016$8+\u001a:wKJ\u0004B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001fq\u0014a\u00028fi^|'o[\u0005\u0005\u0003'\tiA\u0001\u0007T_\u000e\\W\r^*feZ,'/\u0001\u0007ce>\\WM]\"p]\u001aLw\r\u0005\u0003\u0002\u001a\u0005mQ\"\u0001\u001f\n\u0007\u0005uAHA\u0006LC\u001a\\\u0017mQ8oM&<\u0017AC:feZ,'/\u00138g_B!\u00111EA\u0016\u001b\t\t)C\u0003\u0003\u0002(\u0005%\u0012AC1vi\"|'/\u001b>fe*\u0011Q\b^\u0005\u0005\u0003[\t)C\u0001\u000bBkRDwN]5{KJ\u001cVM\u001d<fe&sgm\\\u0001\u0005i&lW\r\u0005\u0003\u00024\u0005uRBAA\u001b\u0015\u0011\t9$!\u000f\u0002\u000bU$\u0018\u000e\\:\u000b\u0007\u0005mB/\u0001\u0004d_6lwN\\\u0005\u0005\u0003\u007f\t)D\u0001\u0003US6,\u0017A\u0002\u001fj]&$h\b\u0006\f\u0002F\u0005\u001d\u0013\u0011JA&\u0003\u001b\ny%!\u0015\u0002T\u0005U\u0013qKA-!\t\u0019\u0005\u0001C\u0003Q\u0017\u0001\u0007\u0011\u000bC\u0003Y\u0017\u0001\u0007\u0011\fC\u0003]\u0017\u0001\u0007Q\fC\u0003l\u0017\u0001\u0007A\u000eC\u0003|\u0017\u0001\u0007A\u0010\u0003\u0004\u0000\u0017\u0001\u0007\u0011\u0011\u0001\u0005\b\u0003\u000fY\u0001\u0019AA\u0005\u0011\u001d\t)b\u0003a\u0001\u0003/Aq!a\b\f\u0001\u0004\t\t\u0003C\u0004\u00020-\u0001\r!!\r\u0002)\r|gN\\3di&|g.\u00169eCR,Gj\\2l+\t\ty\u0006\u0005\u0003\u0002b\u0005-TBAA2\u0015\u0011\t)'a\u001a\u0002\t1\fgn\u001a\u0006\u0003\u0003S\nAA[1wC&!\u0011QNA2\u0005\u0019y%M[3di\u0006)2m\u001c8oK\u000e$\u0018n\u001c8Va\u0012\fG/\u001a'pG.\u0004\u0013!\u00069feNL7\u000f^3oi\u000e{gN\\3di&|gn]\u000b\u0003\u0003k\u0002\u0002\"a\u001e\u0002\u0002\u0006\u0015\u00151R\u0007\u0003\u0003sRA!a\u001f\u0002~\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005}\u0014qM\u0001\u0005kRLG.\u0003\u0003\u0002\u0004\u0006e$!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u0019Q.a\"\n\u0007\u0005%5MA\u0002J]R\u0004B!!$\u0002\u00186\u0011\u0011q\u0012\u0006\u0005\u0003#\u000b\u0019*\u0001\u0005dQ\u0006tg.\u001a7t\u0015\u0011\t)*a\u001a\u0002\u00079Lw.\u0003\u0003\u0002\u001a\u0006=%!D*pG.,Go\u00115b]:,G.\u0001\fqKJ\u001c\u0018n\u001d;f]R\u001cuN\u001c8fGRLwN\\:!\u0003a\t7\r^5wKJ+g/\u001a:tK\u000e{gN\\3di&|gn]\u0001\u001aC\u000e$\u0018N^3SKZ,'o]3D_:tWm\u0019;j_:\u001c\b%\u0001\u000bmS:\\G*[:uK:,'/\u00128ea>Lg\u000e^\u000b\u0003\u0003K\u0003B!a*\u0002*6\u0011\u0011\u0011H\u0005\u0005\u0003W\u000bID\u0001\u0005F]\u0012\u0004x.\u001b8u\u0003aa\u0017N\\6MSN$XM\\3s\u000b:$\u0007o\\5oi~#S-\u001d\u000b\u0005\u0003c\u000b9\fE\u0002n\u0003gK1!!.d\u0005\u0011)f.\u001b;\t\u0013\u0005e6#!AA\u0002\u0005\u0015\u0016a\u0001=%c\u0005)B.\u001b8l\u0019&\u001cH/\u001a8fe\u0016sG\r]8j]R\u0004\u0003f\u0001\u000b\u0002@B\u0019Q.!1\n\u0007\u0005\r7M\u0001\u0005w_2\fG/\u001b7f\u0003Aa\u0017N\\6MSN$XM\\3s\u001d\u0006lW-\u0006\u0002\u0002JB!\u00111ZAh\u001b\t\tiM\u0003\u0003\u0002\u0010\u0005e\u0012\u0002BAi\u0003\u001b\u0014A\u0002T5ti\u0016tWM\u001d(b[\u0016\fA\u0003\\5oW2K7\u000f^3oKJt\u0015-\\3`I\u0015\fH\u0003BAY\u0003/D\u0011\"!/\u0017\u0003\u0003\u0005\r!!3\u0002#1Lgn\u001b'jgR,g.\u001a:OC6,\u0007\u0005K\u0002\u0018\u0003\u007f\u000b!\u0002\\8dC2\fE-\\5o+\t\t\t\u000f\u0005\u0003\u0002d\u0006%XBAAs\u0015\r\t9O]\u0001\u0006C\u0012l\u0017N\\\u0005\u0005\u0003W\f)O\u0001\bD_:4G.^3oi\u0006#W.\u001b8\u0002\u001d1|7-\u00197BI6Lgn\u0018\u0013fcR!\u0011\u0011WAy\u0011%\tI,GA\u0001\u0002\u0004\t\t/A\u0006m_\u000e\fG.\u00113nS:\u0004\u0003f\u0001\u000e\u0002@\u0006\u0019\"/Z7pi\u0016tU\r^<pe.\u001cE.[3oiV\u0011\u00111 \t\u0005[:\fi\u0010E\u0002D\u0003\u007fL1A!\u0001;\u0005M\u0011V-\\8uK:+Go^8sW\u000ec\u0017.\u001a8u\u0003]\u0011X-\\8uK:+Go^8sW\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0003\u00022\n\u001d\u0001\"CA]9\u0005\u0005\t\u0019AA~\u0003Q\u0011X-\\8uK:+Go^8sW\u000ec\u0017.\u001a8uA!\u001aQ$a0\u0002\u000fM$\u0018M\u001d;vaR\u0011\u0011\u0011W\u0001\fe\u0016\u001cwN\u001c4jOV\u0014X\r\u0006\u0004\u00022\nU!\u0011\u0004\u0005\u0007\u0005/y\u0002\u0019A-\u0002\u00139,woQ8oM&<\u0007b\u0002B\u000e?\u0001\u0007!QD\u0001\fkB$\u0017\r^3e\u0017\u0016L8\u000fE\u0003\u0003 \t\u0015R,\u0004\u0002\u0003\")\u0019!1E2\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003(\t\u0005\"aA*fi\u0006A1\u000f[;uI><h.A\tf]\u0006\u0014G.Z\"mkN$XM\u001d'j].$b!!-\u00030\te\u0002b\u0002B\u0019C\u0001\u0007!1G\u0001\u000e]\u0016$xo\u001c:l\u00072LWM\u001c;\u0011\u0007\r\u0013)$C\u0002\u00038i\u0012\u0001d\u00117vgR,'\u000fT5oW:+Go^8sW\u000ec\u0017.\u001a8u\u0011\u0019y\u0018\u00051\u0001\u0003<A!QN\u001cB\u001f!\u0011\u0011yD!\u0012\u000e\u0005\t\u0005#\u0002\u0002B\"\u0003K\f\u0011\"\u001b8uKJt\u0017\r\\:\n\t\t\u001d#\u0011\t\u0002\u0015\u0003\u0012l\u0017N\\'fi\u0006$\u0017\r^1NC:\fw-\u001a:\u00025%t\u0017\u000e^5bi\u0016\u0014VM^3sg\u0016\u001cuN\u001c8fGRLwN\\:\u0015\r\t5#1\u000eB>!\u0019\u0011yE!\u0017\u0003`9!!\u0011\u000bB+\u001d\r\u0001'1K\u0005\u0002I&\u0019!qK2\u0002\u000fA\f7m[1hK&!!1\fB/\u0005\r\u0019V-\u001d\u0006\u0004\u0005/\u001a\u0007CBA<\u0005C\u0012)'\u0003\u0003\u0003d\u0005e$!E\"p[BdW\r^1cY\u00164U\u000f^;sKB!\u0011\u0011\rB4\u0013\u0011\u0011I'a\u0019\u0003\tY{\u0017\u000e\u001a\u0005\b\u0005[\u0012\u0003\u0019\u0001B8\u0003eIg.\u001b;jCR,7i\u001c8oK\u000e$\u0018n\u001c8SKF,Xm\u001d;\u0011\t\tE$qO\u0007\u0003\u0005gRAA!\u001e\u0002:\u0005A!/Z9vKN$8/\u0003\u0003\u0003z\tM$!I%oSRL\u0017\r^3SKZ,'o]3D_:tWm\u0019;j_:\u001c(+Z9vKN$\bb\u0002B?E\u0001\u0007!qP\u0001\u000fe\u0016\fX/Z:u\u0007>tG/\u001a=u!\u0011\u0011\tH!!\n\t\t\r%1\u000f\u0002\u000f%\u0016\fX/Z:u\u0007>tG/\u001a=u\u0003MygNU3wKJ\u001cXmQ8o]\u0016\u001cG/[8o)\u0019\t\tL!#\u0003\u0014\"9!1R\u0012A\u0002\t5\u0015aB2iC:tW\r\u001c\t\u0005\u0003\u0017\u0014y)\u0003\u0003\u0003\u0012\u00065'\u0001D&bM.\f7\t[1o]\u0016d\u0007b\u0002BKG\u0001\u0007!qS\u0001\fe\u00164XM]:f\u001d>$W\r\u0005\u0003\u0002L\ne\u0015\u0002\u0002BN\u0003\u001b\u00141BU3wKJ\u001cXMT8eK\u00061bm\u001c:xCJ$Gk\\*pkJ\u001cWM\u0011:pW\u0016\u00148\u000f\u0006\u0004\u00022\n\u0005&\u0011\u0017\u0005\b\u0005G#\u0003\u0019\u0001BS\u0003-\u0011X-];fgR$\u0015\r^1\u0011\t\t\u001d&QV\u0007\u0003\u0005SSAAa+\u0002:\u00059Q.Z:tC\u001e,\u0017\u0002\u0002BX\u0005S\u0013Q%\u00138ji&\fG/\u001a*fm\u0016\u00148/Z\"p]:,7\r^5p]N\u0014V-];fgR$\u0015\r^1\t\u000f\tMF\u00051\u0001\u0003N\u00059a-\u001e;ve\u0016\u001c\u0018\u0001G2sK\u0006$XMU3wKJ\u001cXmQ8o]\u0016\u001cG/[8ogRA\u0011\u0011\u0017B]\u0005w\u0013i\fC\u0004\u0003$\u0016\u0002\rA!*\t\u000f\tuT\u00051\u0001\u0003\u0000!9!1W\u0013A\u0002\t5\u0013AG8o\u001d\u0016<(+Z7pi\u0016d\u0015N\\6D_>\u0014H-\u001b8bi>\u0014H\u0003BAY\u0005\u0007DqA!2'\u0001\u0004\u00119-A\u0006d_>\u0014H-\u001b8bi>\u0014\b\u0003BAT\u0005\u0013LAAa3\u0002:\t!aj\u001c3f\u0003IygnQ8oiJ|G\u000e\\3s\u0007\"\fgnZ3\u0015\t\u0005E&\u0011\u001b\u0005\b\u0005'<\u0003\u0019\u0001Bk\u0003!I7/Q2uSZ,\u0007cA7\u0003X&\u0019!\u0011\\2\u0003\u000f\t{w\u000e\\3b]\u0006\u0019sN\u001c'j].lU\r^1eCR\f\u0007+\u0019:uSRLwN\u001c'fC\u0012,'o\u00115b]\u001e,\u0017!H7bs\n,\u0007K]8dKN\u001c8i\\8sI&t\u0017\r^8s\u0007\"\fgnZ3\u00027\rdwn]3SKZ,'o]3D_:tWm\u0019;j_:\fE-\\5o\u0003q\u0019'/Z1uKJ+g/\u001a:tK\u000e{gN\\3di&|g.\u00113nS:\f\u0011c\u0019:fCR,'+Z7pi\u0016\fE-\\5o)\t\ti0\u0001\tde\u0016\fG/\u001a'pG\u0006d\u0017\tZ7j]R\u0011\u0011\u0011]\u0001\u0013kB$\u0017\r^3MS:\\G*[:uK:,'\u000f\u0006\u0003\u00022\n=\bB\u0002By]\u0001\u0007\u0011,\u0001\u0004d_:4\u0017nZ\u0001\re\u00164XM]:bY\u0012\u000bG/Y\u000b\u0003\u0005o\u0004BAa*\u0003z&!!1 BU\u0005q\u0011VM^3sg\u0016\u001cuN\u001c8fGRLwN\u001c*fcV,7\u000f\u001e#bi\u0006\fq$\\1zE\u0016\u001c%/Z1uKB+'o]5ti\u0016tGoQ8o]\u0016\u001cG/[8o)\u0011\t\tl!\u0001\t\u000f\t\u0015\u0017\u00071\u0001\u0003H\u0006)\"/Z9vKN$X*\u001a;bI\u0006$\u0018-\u00169eCR,\u0017AG2m_N,\u0007+\u001a:tSN$XM\u001c;D_:tWm\u0019;j_:\u001c\u0018!H2m_N,\u0017i\u0019;jm\u0016\u0014VM^3sg\u0016\u001cuN\u001c8fGRLwN\\:\u0002!M|7m[3u\u0007\"\fgN\\3m\u0017\u0016LH\u0003BAC\u0007\u001bAqaa\u00046\u0001\u0004\tY)A\u0007t_\u000e\\W\r^\"iC:tW\r\\\u0001\u0013G2|7/Z*pG.,Go\u00115b]:,G\u000e\u0006\u0003\u00022\u000eU\u0001bBB\bm\u0001\u0007\u00111R\u0001\u001aa\u0016\u00148/[:uK:$8i\u001c8oK\u000e$\u0018n\u001c8D_VtG/\u0006\u0002\u0002\u0006\u00061\"/\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8D_VtG\u000f")
public class ClusterLinkSourceConnectionManager
extends ClusterLinkConnectionManager
implements ClusterLinkFactory.SourceConnectionManager,
CoordinatorListener {
    private final Option<ClientInterceptor> clientInterceptor;
    private final ClusterLinkMetrics metrics;
    private final ClusterLinkMetadataManager metadataManager;
    private final SocketServer socketServer;
    private final KafkaConfig brokerConfig;
    private final AuthorizerServerInfo serverInfo;
    private final Time time;
    private final Object connectionUpdateLock;
    private final ConcurrentHashMap<Object, SocketChannel> persistentConnections;
    private final ConcurrentHashMap<Object, SocketChannel> activeReverseConnections;
    private volatile Endpoint linkListenerEndpoint;
    private volatile ListenerName linkListenerName;
    private volatile ConfluentAdmin localAdmin;
    private volatile Option<RemoteNetworkClient> remoteNetworkClient;

    private Object connectionUpdateLock() {
        return this.connectionUpdateLock;
    }

    private ConcurrentHashMap<Object, SocketChannel> persistentConnections() {
        return this.persistentConnections;
    }

    private ConcurrentHashMap<Object, SocketChannel> activeReverseConnections() {
        return this.activeReverseConnections;
    }

    private Endpoint linkListenerEndpoint() {
        return this.linkListenerEndpoint;
    }

    private void linkListenerEndpoint_$eq(Endpoint x$1) {
        this.linkListenerEndpoint = x$1;
    }

    private ListenerName linkListenerName() {
        return this.linkListenerName;
    }

    private void linkListenerName_$eq(ListenerName x$1) {
        this.linkListenerName = x$1;
    }

    private ConfluentAdmin localAdmin() {
        return this.localAdmin;
    }

    private void localAdmin_$eq(ConfluentAdmin x$1) {
        this.localAdmin = x$1;
    }

    private Option<RemoteNetworkClient> remoteNetworkClient() {
        return this.remoteNetworkClient;
    }

    private void remoteNetworkClient_$eq(Option<RemoteNetworkClient> x$1) {
        this.remoteNetworkClient = x$1;
    }

    @Override
    public void startup() {
        block3: {
            block2: {
                LinkMode linkMode = this.currentConfig().linkMode();
                LinkMode$Source$ linkMode$Source$ = LinkMode$Source$.MODULE$;
                if (linkMode != null ? !linkMode.equals(linkMode$Source$) : linkMode$Source$ != null) break block2;
                ConnectionMode connectionMode = this.currentConfig().connectionMode();
                ConnectionMode$Outbound$ connectionMode$Outbound$ = ConnectionMode$Outbound$.MODULE$;
                if (!(connectionMode == null ? connectionMode$Outbound$ != null : !connectionMode.equals(connectionMode$Outbound$))) break block3;
            }
            throw new IllegalStateException("Source connection manager is supported only for source initiated links");
        }
        super.startup();
    }

    @Override
    public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        if (updatedKeys.contains((Object)ClusterLinkConfig$.MODULE$.LocalListenerNameProp())) {
            this.updateLinkListener(this.currentConfig());
        }
        super.reconfigure(newConfig, updatedKeys);
        if (updatedKeys.exists((Function1 & Serializable & scala.Serializable)configName -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkConfig$.MODULE$.needsConnectionResetOnUpdate(configName)))) {
            this.closeActiveReverseConnections();
        }
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.closeActiveReverseConnections();
    }

    @Override
    public void enableClusterLink(ClusterLinkNetworkClient networkClient, Option<AdminMetadataManager> metadataManager) {
        block8: {
            block7: {
                ConnectionMode$Outbound$ connectionMode$Outbound$;
                ConnectionMode connectionMode;
                block6: {
                    KafkaClient kafkaClient = networkClient.networkClient();
                    if (kafkaClient instanceof NetworkClient) {
                        ((NetworkClient)kafkaClient).enableSourceClusterLink(super.linkData().linkId(), (ClientInterceptor)this.clientInterceptor.orNull(Predef$.MODULE$.$conforms()), this.reversalData(), (ReverseNode.ReverseCallback)this);
                        return;
                    }
                    connectionMode = this.currentConfig().connectionMode();
                    connectionMode$Outbound$ = ConnectionMode$Outbound$.MODULE$;
                    if (connectionMode != null) break block6;
                    if (connectionMode$Outbound$ != null) {
                        return;
                    }
                    break block7;
                }
                if (!connectionMode.equals(connectionMode$Outbound$)) break block8;
            }
            throw new IllegalStateException("Reverse connections are supported only with NetworkClient");
        }
    }

    @Override
    public Seq<CompletableFuture<Void>> initiateReverseConnections(InitiateReverseConnectionsRequest initiateConnectionRequest, RequestContext requestContext) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Initiate or forward reverse connection request: ").append(initiateConnectionRequest).toString());
        this.ensureReverseConnectionsEnabled();
        InitiateReverseConnectionsRequestData connData = initiateConnectionRequest.data();
        List futures = (List)List$.MODULE$.fill(connData.entries().size(), (Function0 & Serializable & scala.Serializable)() -> new CompletableFuture());
        try {
            String string = connData.sourceClusterId();
            String string2 = super.localLogicalCluster();
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new InvalidRequestException(new StringBuilder(67).append("Initiate reverse request for cluster ").append(connData.sourceClusterId()).append(" sent to wrong source cluster ").append(super.localLogicalCluster()).toString());
            }
            if (connData.forwardToBroker()) {
                this.forwardToSourceBrokers(connData, (Seq<CompletableFuture<Void>>)futures);
            } else {
                this.createReverseConnections(connData, requestContext, (Seq<CompletableFuture<Void>>)futures);
            }
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failing reverse connection request", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            futures.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.completeExceptionally(e)));
        }
        return futures;
    }

    public void onReverseConnection(KafkaChannel channel2, ReverseNode reverseNode) {
        Optional requestId = reverseNode.requestId();
        int remoteBrokerId = reverseNode.remoteBrokerId();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Destination has successfully reversed channel ").append(channel2).append(" with requestId ").append(requestId).append(" remoteBrokerId ").append(remoteBrokerId).toString());
        this.ensureReverseConnectionsEnabled();
        if (!requestId.isPresent() && !this.isLinkCoordinator()) {
            String errorMessage = new StringBuilder(88).append("Discarding persistent reverse connection since broker ").append(this.brokerConfig.brokerId()).append(" is no longer the link coordinator").toString();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMessage);
            throw new NotControllerException(errorMessage);
        }
        SocketChannel socketChannel = channel2.socketChannel();
        Object object = this.connectionUpdateLock();
        synchronized (object) {
            this.activeReverseConnections().put(BoxesRunTime.boxToInteger((int)this.socketChannelKey(socketChannel)), socketChannel);
            if (!requestId.isPresent()) {
                if (Option$.MODULE$.apply((Object)this.persistentConnections().get(BoxesRunTime.boxToInteger((int)remoteBrokerId))).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isConnected()))) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Ignoring persistent connection because a connection already exists for ").append(remoteBrokerId).toString());
                    throw new IllegalStateException(new StringBuilder(41).append("A persistent connection is available for ").append(remoteBrokerId).toString());
                }
                this.persistentConnections().put(BoxesRunTime.boxToInteger((int)remoteBrokerId), socketChannel);
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Created persistent connection to ").append(remoteBrokerId).append(", channel=").append(channel2).toString());
            }
        }
        this.metrics.reverseConnectionCreatedSensor().record();
        ReverseChannel reverseChannel = new ReverseChannel(channel2, reverseNode, channel -> this.closeCallback$1((KafkaChannel)channel, socketChannel, requestId, remoteBrokerId));
        this.socketServer.reverseAndAdd(this.linkListenerName(), reverseChannel);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Added reverse connection ").append(channel2).append(" to source socket server, requestId=").append(requestId).toString());
    }

    private void forwardToSourceBrokers(InitiateReverseConnectionsRequestData requestData, Seq<CompletableFuture<Void>> futures) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("Forward initiate reverse connection request from source link coordinator to source brokers: ").append(requestData).toString());
        ConfluentAdmin admin = this.localAdmin();
        scala.collection.immutable.Map resultFutures = ((TraversableOnce)((TraversableLike)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(requestData.entries()).asScala()).zip(futures, Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            InitiateReverseConnectionsRequestData.EntryData entry = (InitiateReverseConnectionsRequestData.EntryData)x0$1._1();
            CompletableFuture future = (CompletableFuture)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)entry.initiateRequestId())), (Object)future);
            return tuple2;
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        ((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(requestData.entries()).asScala()).groupBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.sourceBrokerId())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ClusterLinkSourceConnectionManager.$anonfun$forwardToSourceBrokers$4(this, requestData, admin, resultFutures, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    private void createReverseConnections(InitiateReverseConnectionsRequestData requestData, RequestContext requestContext, Seq<CompletableFuture<Void>> futures) {
        NetworkClient networkClient = ((RemoteNetworkClient)this.remoteNetworkClient().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("Remote client connection manager not available");
        })).networkClient();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Create reverse connections from source brokers to destination brokers: ").append(requestData).toString());
        ((IterableLike)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(requestData.entries()).asScala()).zip(futures, Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            if (x0$1 != null) {
                InitiateReverseConnectionsRequestData.EntryData entry = (InitiateReverseConnectionsRequestData.EntryData)x0$1._1();
                CompletableFuture future = (CompletableFuture)x0$1._2();
                try {
                    if (entry.initiateRequestId() == -1 && Option$.MODULE$.apply((Object)this.persistentConnections().get(BoxesRunTime.boxToInteger((int)entry.targetBrokerId()))).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isConnected()))) {
                        object = BoxesRunTime.boxToBoolean((boolean)future.complete(null));
                    } else if (entry.sourceBrokerId() == $this.brokerConfig.brokerId() || entry.sourceBrokerId() == -1) {
                        ReverseNode reverseNode = networkClient.reverseConnectionManager().createReversibleConnection(entry.initiateRequestId(), entry.targetBrokerId(), requestContext$1.listenerName, requestContext$1.principal, requestContext$1.principalSerde, requestContext$1.authenticationContext, $this.time.milliseconds());
                        object = reverseNode.future().whenComplete((x0$2, x1$1) -> {
                            Void v = x0$2;
                            Throwable e = x1$1;
                            if (e != null) {
                                $this.metrics.sourceReverseConnectionFailedSensor().record();
                                networkClient.requestClusterLinkMetadataUpdate();
                                future.completeExceptionally(e);
                                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Failed to reverse connection for ").append(reverseNode).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                                return;
                            }
                            future.complete(v);
                            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Completed connection reversal for ").append(reverseNode).toString());
                        });
                    } else {
                        object = BoxesRunTime.boxToBoolean((boolean)future.completeExceptionally(new InvalidRequestException(new StringBuilder(49).append("Incorrect source broker id, expected ").append($this.brokerConfig.brokerId()).append(", requested ").append(entry.sourceBrokerId()).toString())));
                    }
                }
                catch (Throwable e) {
                    future.completeExceptionally(e);
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to reverse connection for request ").append(requestData).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    object = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError(null);
            }
            BoxedUnit boxedUnit = object;
            return boxedUnit;
        });
    }

    @Override
    public void onNewRemoteLinkCoordinator(Node coordinator) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Process remote metadata: isLocalCoordinator=").append(this.isLinkCoordinator()).append(" remoteCoordinator=").append(coordinator).toString());
        this.maybeCreatePersistentConnection();
        this.updateActiveLinkCount();
    }

    @Override
    public void onControllerChange(boolean isActive) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Process local controller change, isActiveController=").append(isActive).toString());
        this.maybeProcessCoordinatorChange();
    }

    @Override
    public void onLinkMetadataPartitionLeaderChange() {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Process metadata partition leader change");
        this.maybeProcessCoordinatorChange();
    }

    private void maybeProcessCoordinatorChange() {
        Object object = this.stateChangeLock();
        synchronized (object) {
            boolean isCoordinator = this.isLinkCoordinator();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Process link coordinator change isLocalCoordinator=").append(isCoordinator).toString());
            if (!isCoordinator) {
                this.closePersistentConnections();
            } else {
                this.maybeCreatePersistentConnection();
            }
            return;
        }
    }

    @Override
    public void closeReverseConnectionAdmin() {
        this.remoteNetworkClient().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        if (this.localAdmin() != null) {
            this.localAdmin().close(Duration.ZERO);
        }
    }

    @Override
    public void createReverseConnectionAdmin() {
        this.localAdmin_$eq(this.createLocalAdmin());
        this.remoteNetworkClient_$eq((Option<RemoteNetworkClient>)new Some((Object)this.createRemoteAdmin()));
        this.maybeCreatePersistentConnection();
    }

    public RemoteNetworkClient createRemoteAdmin() {
        ClusterLinkConfig config = this.currentConfig();
        ClusterLinkMetadata metadata = new ClusterLinkMetadata(this.brokerConfig, super.linkData().linkName(), super.linkData().linkId(), config.linkMode(), Predef$.MODULE$.Long2long(config.metadataRefreshBackoffMs()), Predef$.MODULE$.Long2long(config.metadataMaxAgeMs()));
        java.util.List addresses = ClientUtils.parseAndValidateAddresses(config.bootstrapServers(), (ClientDnsLookup)config.dnsLookup());
        metadata.bootstrap(addresses);
        ClusterLinkMetadataThread metadataRefreshThread = new ClusterLinkMetadataThread(this.brokerConfig, config, (Option<ClusterLinkDestConnectionManager>)None$.MODULE$, metadata, this.metrics.metrics(), this.time);
        metadataRefreshThread.addCoordinatorListener(this);
        metadataRefreshThread.start();
        NetworkClient networkClient = (NetworkClient)metadataRefreshThread.clusterLinkClient().networkClient();
        networkClient.enableSourceClusterLink(super.linkData().linkId(), (ClientInterceptor)this.clientInterceptor.orNull(Predef$.MODULE$.$conforms()), this.reversalData(), (ReverseNode.ReverseCallback)this);
        return new RemoteNetworkClient(networkClient, metadataRefreshThread);
    }

    public ConfluentAdmin createLocalAdmin() {
        ClusterLinkConfig config = this.currentConfig();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Creating local admin for reverse connections from source cluster on listener ").append(this.linkListenerEndpoint()).toString());
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.putAll(this.brokerConfig.originals());
        config.localClientConfigOverrides().forEach((x0$1, x1$1) -> {
            String k = x0$1;
            props.put(k, x1$1);
        });
        Map adminConfigs = ConfluentConfigs.interBrokerClientConfigs(props, (Endpoint)this.linkListenerEndpoint());
        adminConfigs.remove("metric.reporters");
        adminConfigs.put("client.id", new StringBuilder(38).append("cluster-link-").append(super.linkData().linkName()).append("-local-source-conn-admin-").append(this.brokerConfig.brokerId()).toString());
        config.localClientConfigOverrides().forEach((x0$2, x1$2) -> {
            String k = x0$2;
            adminConfigs.put(k, x1$2);
        });
        return (ConfluentAdmin)Admin.create((Map)adminConfigs);
    }

    private void updateLinkListener(ClusterLinkConfig config) {
        this.linkListenerEndpoint_$eq(this.serverInfo.endpoints().stream().filter(x$6 -> {
            Optional optional = x$6.listenerName();
            Optional<String> optional2 = Optional.of(config.localListenerName());
            return !(optional != null ? !((Object)optional).equals(optional2) : optional2 != null);
        }).findFirst().orElseThrow(() -> new InvalidRequestException(new StringBuilder(19).append("Listener ").append(config.localListenerName()).append(" not found").toString())));
        this.linkListenerName_$eq(new ListenerName((String)this.linkListenerEndpoint().listenerName().orElseThrow(() -> new IllegalStateException("Listener name not set"))));
    }

    private ReverseConnectionRequestData reversalData() {
        Endpoint endpoint = this.linkListenerEndpoint();
        return new ReverseConnectionRequestData().setClusterLinkId(this.linkId()).setTargetClusterId((String)super.linkData().clusterId().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("Remote cluster id not known");
        })).setSourceClusterId(super.localLogicalCluster()).setSourceBrokerId(this.brokerConfig.brokerId()).setSourceHost(endpoint.host()).setSourcePort(endpoint.port());
    }

    private void maybeCreatePersistentConnection() {
        if (this.isLinkCoordinator()) {
            this.remoteNetworkClient().foreach((Function1 & Serializable & scala.Serializable)client -> {
                ClusterLinkSourceConnectionManager.$anonfun$maybeCreatePersistentConnection$1(this, client);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void maybeCreatePersistentConnection(Node coordinator) {
        if (!Option$.MODULE$.apply((Object)this.persistentConnections().get(BoxesRunTime.boxToInteger((int)coordinator.id()))).exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isConnected()))) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Creating persistent connection to remote link coordinator ").append(coordinator).toString());
            InitiateReverseConnectionsRequestData requestData = new InitiateReverseConnectionsRequestData().setClusterLinkId(new Uuid(super.linkData().linkId().getMostSignificantBits(), super.linkData().linkId().getLeastSignificantBits())).setForwardToBroker(false).setTimeoutMs(Predef$.MODULE$.Integer2int(this.currentConfig().reverseConnectionSetupTimeoutMs())).setSourceClusterId(super.localLogicalCluster()).setTargetClusterId((String)super.linkData().clusterId().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException("Remote cluster id not known");
            })).setEntries(Collections.singletonList(new InitiateReverseConnectionsRequestData.EntryData().setInitiateRequestId(-1).setSourceBrokerId(this.brokerConfig.brokerId()).setTargetBrokerId(coordinator.id())));
            CompletableFuture future = new CompletableFuture();
            this.forwardToSourceBrokers(requestData, (Seq<CompletableFuture<Void>>)new .colon.colon(future, (List)Nil$.MODULE$));
            future.whenComplete((x0$1, x1$1) -> {
                Throwable e = x1$1;
                if (e != null) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to create persistent reverse connection", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    this.requestMetadataUpdate();
                    return;
                }
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Successfully created persistent connection to ").append(coordinator).toString());
            });
            return;
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Not creating persistent connection, remoteController=").append(coordinator).append(", persistentConnections=").append(this.persistentConnections()).toString());
    }

    private void requestMetadataUpdate() {
        if (this.isActive()) {
            try {
                this.remoteNetworkClient().foreach((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)ClusterLinkSourceConnectionManager.$anonfun$requestMetadataUpdate$1(x$8)));
                return;
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to request metadata refresh", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return;
            }
        }
    }

    private void closePersistentConnections() {
        Object object = this.connectionUpdateLock();
        synchronized (object) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing persistent connections");
            this.persistentConnections().values().forEach(socketChannel -> {
                this.closeSocketChannel((SocketChannel)socketChannel);
                if (this.activeReverseConnections().remove(BoxesRunTime.boxToInteger((int)this.socketChannelKey((SocketChannel)socketChannel))) != null) {
                    $this.metrics.reverseConnectionClosedSensor().record();
                }
            });
            this.persistentConnections().clear();
            return;
        }
    }

    private void closeActiveReverseConnections() {
        Object object = this.connectionUpdateLock();
        synchronized (object) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing active reverse connections");
            this.activeReverseConnections().values().forEach(socketChannel -> {
                this.closeSocketChannel((SocketChannel)socketChannel);
                $this.metrics.reverseConnectionClosedSensor().record();
            });
            this.activeReverseConnections().clear();
            this.persistentConnections().clear();
            return;
        }
    }

    private int socketChannelKey(SocketChannel socketChannel) {
        return System.identityHashCode(socketChannel);
    }

    public void closeSocketChannel(SocketChannel socketChannel) {
        try {
            socketChannel.close();
            return;
        }
        catch (Exception e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Failed to close socket channel ").append(socketChannel).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    @Override
    public int persistentConnectionCount() {
        return this.persistentConnections().size();
    }

    @Override
    public int reverseConnectionCount() {
        return this.activeReverseConnections().size();
    }

    private final void closeCallback$1(KafkaChannel channel, SocketChannel socketChannel$1, Optional requestId$1, int remoteBrokerId$1) {
        boolean bl;
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Reverse channel ").append(channel).append(" has been disconnected").toString());
        Object object = this.connectionUpdateLock();
        synchronized (object) {
            boolean bl2;
            if (this.activeReverseConnections().remove(BoxesRunTime.boxToInteger((int)this.socketChannelKey(socketChannel$1))) != null) {
                this.metrics.reverseConnectionClosedSensor().record();
            }
            if (!requestId$1.isPresent() && this.persistentConnections().remove(BoxesRunTime.boxToInteger((int)remoteBrokerId$1)) != null) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Removed persistent connection for ").append(remoteBrokerId$1).append(" because channel ").append(channel.id()).append(" was closed").toString());
                bl2 = true;
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        if (bl) {
            this.requestMetadataUpdate();
        }
    }

    public static final /* synthetic */ boolean $anonfun$forwardToSourceBrokers$10(int brokerId$1, scala.collection.immutable.Map resultFutures$1, InitiateReverseConnectionsRequestData.EntryData entry) {
        NetworkException e = new NetworkException(new StringBuilder(39).append("Source broker with id ").append(brokerId$1).append(" is not available").toString());
        return ((CompletableFuture)resultFutures$1.apply((Object)BoxesRunTime.boxToInteger((int)entry.initiateRequestId()))).completeExceptionally((Throwable)e);
    }

    public static final /* synthetic */ void $anonfun$forwardToSourceBrokers$4(ClusterLinkSourceConnectionManager $this, InitiateReverseConnectionsRequestData requestData$1, ConfluentAdmin admin$1, scala.collection.immutable.Map resultFutures$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            int brokerId = x0$2._1$mcI$sp();
            Buffer entries = (Buffer)x0$2._2();
            if (brokerId == -1 || $this.brokerConfig.brokerId() == brokerId || $this.metadataManager.isBrokerOnline(brokerId)) {
                InitiateReverseConnectionsRequestData brokerRequest = new InitiateReverseConnectionsRequestData().setClusterLinkId(requestData$1.clusterLinkId()).setSourceClusterId(requestData$1.sourceClusterId()).setTargetClusterId(requestData$1.targetClusterId()).setForwardToBroker(false).setEntries((java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(entries).asJava());
                ConfluentAdminUtils.initiateReverseConnections((ConfluentAdmin)admin$1, (InitiateReverseConnectionsRequestData)brokerRequest, (Integer)Predef$.MODULE$.int2Integer(brokerId)).forEach((x0$3, x1$1) -> {
                    Integer requestId = x0$3;
                    x1$1.whenComplete((x0$4, x1$2) -> {
                        Void v = x0$4;
                        Throwable e = x1$2;
                        if (e != null) {
                            ((CompletableFuture)resultFutures$1.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(requestId)))).completeExceptionally(e);
                            $this.metrics.sourceReverseConnectionFailedSensor().record();
                            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Connection reversal request to local broker failed for requestId=").append(requestId).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                            return;
                        }
                        ((CompletableFuture)resultFutures$1.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(requestId)))).complete(v);
                        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Completed initiate reversal request for requestId=").append(requestId).toString());
                    });
                });
                return;
            }
            entries.foreach((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSourceConnectionManager.$anonfun$forwardToSourceBrokers$10(brokerId, resultFutures$1, entry)));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$maybeCreatePersistentConnection$1(ClusterLinkSourceConnectionManager $this, RemoteNetworkClient client) {
        Option<Node> option = client.metadataRefreshThread().remoteLinkCoordinator();
        if (option instanceof Some) {
            Node coordinator = (Node)((Some)option).value();
            $this.maybeCreatePersistentConnection(coordinator);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Remote coordinator not known, request metadata");
            $this.requestMetadataUpdate();
            return;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ int $anonfun$requestMetadataUpdate$1(RemoteNetworkClient x$8) {
        return x$8.metadataRefreshThread().clusterLinkMetadata().requestUpdate();
    }

    public ClusterLinkSourceConnectionManager(ClusterLinkData linkData, ClusterLinkConfig initialConfig, String localLogicalCluster, Option<ClientInterceptor> clientInterceptor, ClusterLinkMetrics metrics, ClusterLinkMetadataManager metadataManager, SocketServer socketServer, KafkaConfig brokerConfig, AuthorizerServerInfo serverInfo, Time time) {
        this.clientInterceptor = clientInterceptor;
        this.metrics = metrics;
        this.metadataManager = metadataManager;
        this.socketServer = socketServer;
        this.brokerConfig = brokerConfig;
        this.serverInfo = serverInfo;
        this.time = time;
        super(linkData, initialConfig, localLogicalCluster, metadataManager, metrics);
        CoordinatorListener.$init$(this);
        this.connectionUpdateLock = new Object();
        this.persistentConnections = new ConcurrentHashMap();
        this.activeReverseConnections = new ConcurrentHashMap();
        this.remoteNetworkClient = None$.MODULE$;
        this.logIdent_$eq(new StringBuilder(46).append("[ClusterLinkSourceConnectionManager-").append(super.linkData().linkName()).append("-broker-").append(brokerConfig.brokerId()).append("] ").toString());
        this.updateLinkListener(initialConfig);
    }
}

