/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.RequestCallback;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.SaslAuthenticateRequest;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001\u0002\u0011\"\u0001!B\u0001B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\"AA\n\u0001B\u0001B\u0003%Q\n\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003\\\u0011!\u0011\u0007A!A!\u0002\u0013\u0019\u0007\u0002\u00036\u0001\u0005\u0003\u0005\u000b\u0011B6\t\u0011A\u0004!\u0011!Q\u0001\nED\u0001b\u001e\u0001\u0003\u0002\u0003\u0006I\u0001\u001f\u0005\t{\u0002\u0011)\u0019!C\u0001}\"Aq\u0010\u0001B\u0001B\u0003%Q\nC\u0005\u0002\u0002\u0001\u0011\t\u0011)A\u0005\u001b\"Q\u00111\u0001\u0001\u0003\u0002\u0003\u0006I!!\u0002\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e!I\u0011q\u0005\u0001C\u0002\u0013%\u0011\u0011\u0006\u0005\t\u0003c\u0001\u0001\u0015!\u0003\u0002,!I\u00111\u0007\u0001C\u0002\u0013%\u0011Q\u0007\u0005\t\u0003\u0007\u0002\u0001\u0015!\u0003\u00028!I\u0011Q\t\u0001C\u0002\u0013%\u0011q\t\u0005\t\u0003\u001f\u0002\u0001\u0015!\u0003\u0002J!I\u0011\u0011\u000b\u0001C\u0002\u0013%\u00111\u000b\u0005\t\u00037\u0002\u0001\u0015!\u0003\u0002V!I\u0011Q\f\u0001C\u0002\u0013\u0005\u0011q\f\u0005\t\u0003O\u0002\u0001\u0015!\u0003\u0002b!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005-\u0004bBAB\u0001\u0011\u0005\u0013Q\u0011\u0005\b\u0003[\u0003A\u0011IAX\u0011\u001d\t9\f\u0001C!\u0003sCq!a2\u0001\t\u0003\nI\rC\u0004\u0002Z\u0002!\t!a7\t\u000f\u0005u\u0007\u0001\"\u0001\u0002\\\"9\u0011q\u001c\u0001\u0005\u0012\u0005\u0005(\u0001G\"mkN$XM\u001d'j].tU\r^<pe.\u001cE.[3oi*\u0011!eI\u0001\u0005Y&t7N\u0003\u0002%K\u000511/\u001a:wKJT\u0011AJ\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0011&\r\u001f\u0011\u0005)zS\"A\u0016\u000b\u00051j\u0013\u0001\u00027b]\u001eT\u0011AL\u0001\u0005U\u00064\u0018-\u0003\u00021W\t1qJ\u00196fGR\u0004\"A\r\u001e\u000e\u0003MR!\u0001N\u001b\u0002\r\r|W.\\8o\u0015\t1cG\u0003\u00028q\u00051\u0011\r]1dQ\u0016T\u0011!O\u0001\u0004_J<\u0017BA\u001e4\u00059\u0011VmY8oM&<WO]1cY\u0016\u0004\"!\u0010!\u000e\u0003yR!aP\u0013\u0002\u000bU$\u0018\u000e\\:\n\u0005\u0005s$a\u0002'pO\u001eLgnZ\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\t\u0003\t\u0016k\u0011aI\u0005\u0003\r\u000e\u00121bS1gW\u0006\u001cuN\u001c4jO\u0006\t2\r\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4\u0011\u0005%SU\"A\u0011\n\u0005-\u000b#!E\"mkN$XM\u001d'j].\u001cuN\u001c4jO\u00061B\u000f\u001b:piRdW\rV5nKN+gn]8s\u001d\u0006lW\r\u0005\u0002O/:\u0011q*\u0016\t\u0003!Nk\u0011!\u0015\u0006\u0003%\u001e\na\u0001\u0010:p_Rt$\"\u0001+\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001b\u0016A\u0002)sK\u0012,g-\u0003\u0002Y3\n11\u000b\u001e:j]\u001eT!AV*\u0002\u00115,G/\u00193bi\u0006\u00042\u0001X/`\u001b\u0005\u0019\u0016B\u00010T\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011\nY\u0005\u0003C\u0006\u00121c\u00117vgR,'\u000fT5oW6+G/\u00193bi\u0006\fq\"\\3uC\u0012\fG/Y+qI\u0006$XM\u001d\t\u00049v#\u0007CA3i\u001b\u00051'BA46\u0003\u001d\u0019G.[3oiNL!!\u001b4\u0003\u001f5+G/\u00193bi\u0006,\u0006\u000fZ1uKJ\fq!\\3ue&\u001c7\u000f\u0005\u0002m]6\tQN\u0003\u0002kg%\u0011q.\u001c\u0002\b\u001b\u0016$(/[2t\u0003)iW\r\u001e:jGR\u000bwm\u001d\t\u0005eVlU*D\u0001t\u0015\t!8+\u0001\u0006d_2dWm\u0019;j_:L!A^:\u0003\u00075\u000b\u0007/\u0001\u0003uS6,\u0007CA=|\u001b\u0005Q(BA 4\u0013\ta(P\u0001\u0003US6,\u0017\u0001C2mS\u0016tG/\u00133\u0016\u00035\u000b\u0011b\u00197jK:$\u0018\n\u001a\u0011\u0002\u0015\rd\u0017.\u001a8u)f\u0004X-\u0001\u0006m_\u001e\u001cuN\u001c;fqR\u00042!_A\u0004\u0013\r\tIA\u001f\u0002\u000b\u0019><7i\u001c8uKb$\u0018A\u0002\u001fj]&$h\b\u0006\r\u0002\u0010\u0005E\u00111CA\u000b\u0003/\tI\"a\u0007\u0002\u001e\u0005}\u0011\u0011EA\u0012\u0003K\u0001\"!\u0013\u0001\t\u000b\tk\u0001\u0019A\"\t\u000b\u001dk\u0001\u0019\u0001%\t\u000b1k\u0001\u0019A'\t\u000bik\u0001\u0019A.\t\u000b\tl\u0001\u0019A2\t\u000b)l\u0001\u0019A6\t\u000bAl\u0001\u0019A9\t\u000b]l\u0001\u0019\u0001=\t\u000bul\u0001\u0019A'\t\r\u0005\u0005Q\u00021\u0001N\u0011\u001d\t\u0019!\u0004a\u0001\u0003\u000b\t!\u0003\u001e5s_R$H.\u001a+j[\u0016\u001cVM\\:peV\u0011\u00111\u0006\t\u0004Y\u00065\u0012bAA\u0018[\n11+\u001a8t_J\f1\u0003\u001e5s_R$H.\u001a+j[\u0016\u001cVM\\:pe\u0002\nqB]3rk\u0016\u001cHoQ1mY\n\f7m[\u000b\u0003\u0003o\u0001B!!\u000f\u0002@5\u0011\u00111\b\u0006\u0004\u0003{\u0019\u0014a\u00028fi^|'o[\u0005\u0005\u0003\u0003\nYDA\bSKF,Xm\u001d;DC2d'-Y2l\u0003A\u0011X-];fgR\u001c\u0015\r\u001c7cC\u000e\\\u0007%\u0001\bdQ\u0006tg.\u001a7Ck&dG-\u001a:\u0016\u0005\u0005%\u0003\u0003BA\u001d\u0003\u0017JA!!\u0014\u0002<\tq1\t[1o]\u0016d')^5mI\u0016\u0014\u0018aD2iC:tW\r\u001c\"vS2$WM\u001d\u0011\u0002\u0011M,G.Z2u_J,\"!!\u0016\u0011\t\u0005e\u0012qK\u0005\u0005\u00033\nYD\u0001\u0005TK2,7\r^8s\u0003%\u0019X\r\\3di>\u0014\b%A\u0007oKR<xN]6DY&,g\u000e^\u000b\u0003\u0003C\u00022!ZA2\u0013\r\t)G\u001a\u0002\f\u0017\u000647.Y\"mS\u0016tG/\u0001\boKR<xN]6DY&,g\u000e\u001e\u0011\u000275\f\u0017PY3BI\u0012tU\r^<pe.\u0014VmZ5p]&#G+Y4t)\u0011\ti'a\u001d\u0011\u0007q\u000by'C\u0002\u0002rM\u0013A!\u00168ji\"9\u0011Q\u000f\rA\u0002\u0005]\u0014a\u0002:fcV,7\u000f\u001e\t\u0005\u0003s\ny(\u0004\u0002\u0002|)\u0019\u0011QP\u001a\u0002\u0011I,\u0017/^3tiNLA!!!\u0002|\ty\u0011IY:ue\u0006\u001cGOU3rk\u0016\u001cH/A\u0005d_:4\u0017nZ;sKR!\u0011QNAD\u0011\u001d\tI)\u0007a\u0001\u0003\u0017\u000bqaY8oM&<7\u000f\r\u0003\u0002\u000e\u0006m\u0005cBAH\u0003+k\u0015qS\u0007\u0003\u0003#S1!a%.\u0003\u0011)H/\u001b7\n\u0007Y\f\t\n\u0005\u0003\u0002\u001a\u0006mE\u0002\u0001\u0003\r\u0003;\u000b9)!A\u0001\u0002\u000b\u0005\u0011q\u0014\u0002\u0004?\u0012\n\u0014\u0003BAQ\u0003O\u00032\u0001XAR\u0013\r\t)k\u0015\u0002\b\u001d>$\b.\u001b8h!\ra\u0016\u0011V\u0005\u0004\u0003W\u001b&aA!os\u0006)\"/Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001cHCAAY!\u0015\ty)a-N\u0013\u0011\t),!%\u0003\u0007M+G/A\fwC2LG-\u0019;f%\u0016\u001cwN\u001c4jOV\u0014\u0018\r^5p]R!\u0011QNA^\u0011\u001d\tIi\u0007a\u0001\u0003{\u0003D!a0\u0002DB9\u0011qRAK\u001b\u0006\u0005\u0007\u0003BAM\u0003\u0007$A\"!2\u0002<\u0006\u0005\t\u0011!B\u0001\u0003?\u00131a\u0018\u00133\u0003-\u0011XmY8oM&<WO]3\u0015\t\u00055\u00141\u001a\u0005\b\u0003\u001bd\u0002\u0019AAh\u0003)qWm^\"p]\u001aLwm\u001d\u0019\u0005\u0003#\f)\u000eE\u0004\u0002\u0010\u0006UU*a5\u0011\t\u0005e\u0015Q\u001b\u0003\r\u0003/\fY-!A\u0001\u0002\u000b\u0005\u0011q\u0014\u0002\u0004?\u0012\u001a\u0014!D5oSRL\u0017\r^3DY>\u001cX\r\u0006\u0002\u0002n\u0005)1\r\\8tK\u0006\u00192M]3bi\u0016tU\r^<pe.\u001cE.[3oiR!\u0011\u0011MAr\u0011\u001d\t\tf\ba\u0001\u0003+\u0002")
public class ClusterLinkNetworkClient
implements Reconfigurable,
Logging {
    private final KafkaConfig brokerConfig;
    private final ClusterLinkConfig clusterLinkConfig;
    private final Option<ClusterLinkMetadata> metadata;
    private final Option<MetadataUpdater> metadataUpdater;
    private final Time time;
    private final String clientId;
    private final LogContext logContext;
    private final Sensor throttleTimeSensor;
    private final RequestCallback requestCallback;
    private final ChannelBuilder channelBuilder;
    private final Selector selector;
    private final KafkaClient networkClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String clientId() {
        return this.clientId;
    }

    private Sensor throttleTimeSensor() {
        return this.throttleTimeSensor;
    }

    private RequestCallback requestCallback() {
        return this.requestCallback;
    }

    private ChannelBuilder channelBuilder() {
        return this.channelBuilder;
    }

    private Selector selector() {
        return this.selector;
    }

    public KafkaClient networkClient() {
        return this.networkClient;
    }

    public void maybeAddNetworkRegionIdTags(AbstractRequest request) {
        if (request instanceof SaslAuthenticateRequest) {
            SaslAuthenticateRequest saslAuthenticateRequest = (SaslAuthenticateRequest)request;
            String networkRegionId = this.brokerConfig.trafficNetworkRegionId();
            if (!networkRegionId.isEmpty() && ClusterLinkUtils$.MODULE$.isOutboundBootstrapCCloudHost(this.clusterLinkConfig)) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("adding NetworkRegionId tag: ").append(networkRegionId).append(" to saslAuthenticateRequest").toString());
                saslAuthenticateRequest.data().setNetworkRegionId(networkRegionId);
                return;
            }
        }
    }

    public void configure(java.util.Map<String, ?> configs) {
    }

    public Set<String> reconfigurableConfigs() {
        ChannelBuilder channelBuilder = this.channelBuilder();
        Set set = channelBuilder instanceof Reconfigurable ? ((Reconfigurable)channelBuilder).reconfigurableConfigs() : Collections.emptySet();
        return set;
    }

    public void validateReconfiguration(java.util.Map<String, ?> configs) {
        ChannelBuilder channelBuilder = this.channelBuilder();
        if (channelBuilder instanceof Reconfigurable) {
            ((Reconfigurable)channelBuilder).validateReconfiguration(configs);
            return;
        }
    }

    public void reconfigure(java.util.Map<String, ?> newConfigs) {
        ChannelBuilder channelBuilder = this.channelBuilder();
        if (channelBuilder instanceof Reconfigurable) {
            ((Reconfigurable)channelBuilder).reconfigure(newConfigs);
            return;
        }
    }

    public void initiateClose() {
        this.networkClient().initiateClose();
    }

    public void close() {
        this.networkClient().close();
    }

    public KafkaClient createNetworkClient(Selector selector) {
        return new NetworkClient((MetadataUpdater)this.metadataUpdater.orNull(Predef$.MODULE$.$conforms()), (Metadata)this.metadata.orNull(Predef$.MODULE$.$conforms()), (Selectable)selector, this.clientId(), 1, Predef$.MODULE$.Long2long(this.clusterLinkConfig.reconnectBackoffMs()), Predef$.MODULE$.Long2long(this.clusterLinkConfig.reconnectBackoffMaxMs()), -1, Predef$.MODULE$.Integer2int(this.clusterLinkConfig.replicaSocketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(this.clusterLinkConfig.requestTimeoutMs()), this.clusterLinkConfig.connectionSetupTimeoutMs(), this.clusterLinkConfig.connectionSetupTimeoutMaxMs(), this.time, true, new ApiVersions(), this.throttleTimeSensor(), this.logContext);
    }

    public ClusterLinkNetworkClient(KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, String throttleTimeSensorName, Option<ClusterLinkMetadata> metadata, Option<MetadataUpdater> metadataUpdater, Metrics metrics, Map<String, String> metricTags, Time time, String clientId, String clientType, LogContext logContext) {
        this.brokerConfig = brokerConfig;
        this.clusterLinkConfig = clusterLinkConfig;
        this.metadata = metadata;
        this.metadataUpdater = metadataUpdater;
        this.time = time;
        this.clientId = clientId;
        this.logContext = logContext;
        Logging.$init$(this);
        this.throttleTimeSensor = metrics.sensor(throttleTimeSensorName);
        this.requestCallback = (x$1, request) -> this.maybeAddNetworkRegionIdTags(request);
        this.channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)clusterLinkConfig.securityProtocol(), (JaasContext.Type)JaasContext.Type.CLIENT, (AbstractConfig)clusterLinkConfig, null, (String)clusterLinkConfig.saslMechanism(), (Time)time, (boolean)true, (LogContext)logContext, (RequestCallback)this.requestCallback());
        this.selector = new Selector(-1, Predef$.MODULE$.Long2long(clusterLinkConfig.connectionsMaxIdleMs()), metrics, time, new StringBuilder(13).append("cluster-link-").append(clientType).toString(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(metricTags).asJava(), false, this.channelBuilder(), logContext);
        this.networkClient = this.createNetworkClient(this.selector());
    }
}

