/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkDestConnectionManager;
import kafka.server.link.ClusterLinkDynamicLogger;
import kafka.server.link.ClusterLinkDynamicLogger$;
import kafka.server.link.ClusterLinkFactory$;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetrics$;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.CoordinatorListener;
import kafka.server.link.MetadataListener;
import kafka.server.link.MetadataRefreshListener;
import kafka.utils.ShutdownableThread;
import kafka.utils.ShutdownableThread$;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.DisconnectException;
import org.apache.kafka.common.message.DescribeClusterLinksResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeClusterLinksRequest;
import org.apache.kafka.common.requests.DescribeClusterLinksResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001\u0002\u0013&\u00011B\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"A1\t\u0001B\u0001B\u0003%A\t\u0003\u0005N\u0001\t\u0015\r\u0011\"\u0001O\u0011!\u0011\u0006A!A!\u0002\u0013y\u0005\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011\u0002+\t\u0011\u0001\u0004!\u0011!Q\u0001\n\u0005DQA\u001a\u0001\u0005\u0002\u001dDqa\u001c\u0001C\u0002\u0013%\u0001\u000f\u0003\u0004u\u0001\u0001\u0006I!\u001d\u0005\tk\u0002\u0011\r\u0011\"\u0001&m\"1!\u0010\u0001Q\u0001\n]Dqa\u001f\u0001C\u0002\u0013%A\u0010C\u0004\u0002\u0002\u0001\u0001\u000b\u0011B?\t\u0013\u0005\r\u0001A1A\u0005\n\u0005\u0015\u0001\u0002CA\u000f\u0001\u0001\u0006I!a\u0002\t\u0013\u0005}\u0001A1A\u0005\n\u0005\u0005\u0002\u0002CA\u0016\u0001\u0001\u0006I!a\t\t\u0017\u00055\u0002\u00011AA\u0002\u0013%\u0011q\u0006\u0005\f\u0003s\u0001\u0001\u0019!a\u0001\n\u0013\tY\u0004C\u0006\u0002H\u0001\u0001\r\u0011!Q!\n\u0005E\u0002bCA)\u0001\u0001\u0007\t\u0019!C\u0005\u0003'B1\"a\u0017\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002^!Y\u0011\u0011\r\u0001A\u0002\u0003\u0005\u000b\u0015BA+\u0011\u001d\t)\u0007\u0001C!\u0003OBq!!\u001b\u0001\t\u0003\nY\u0007C\u0004\u0002t\u0001!\t%a\u001a\t\u000f\u0005U\u0004\u0001\"\u0001\u0002x!9\u0011Q\u0010\u0001\u0005\u0002\u0005}\u0004bBAB\u0001\u0011\u0005\u0011Q\u0011\u0005\b\u0003\u0013\u0003A\u0011CAF\u0011\u001d\t\t\n\u0001C!\u0003OBq!a%\u0001\t\u0013\t9\u0007C\u0004\u0002\u0016\u0002!I!a&\t\u000f\u0005%\u0006\u0001\"\u0003\u0002h\tI2\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$\u0018\rZ1uCRC'/Z1e\u0015\t1s%\u0001\u0003mS:\\'B\u0001\u0015*\u0003\u0019\u0019XM\u001d<fe*\t!&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001i3g\u000e\t\u0003]Ej\u0011a\f\u0006\u0003a%\nQ!\u001e;jYNL!AM\u0018\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\t\u0003iUj\u0011!J\u0005\u0003m\u0015\u0012q#T3uC\u0012\fG/\u0019*fMJ,7\u000f\u001b'jgR,g.\u001a:\u0011\u00059B\u0014BA\u001d0\u0005\u001daunZ4j]\u001e\fAB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u0004\"\u0001P\u001f\u000e\u0003\u001dJ!AP\u0014\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0012G2,8\u000f^3s\u0019&t7nQ8oM&<\u0007C\u0001\u001bB\u0013\t\u0011UEA\tDYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e\fQ\u0003Z3ti\u000e{gN\\3di&|g.T1oC\u001e,'\u000fE\u0002F\u0011*k\u0011A\u0012\u0006\u0002\u000f\u0006)1oY1mC&\u0011\u0011J\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005QZ\u0015B\u0001'&\u0005\u0001\u001aE.^:uKJd\u0015N\\6EKN$8i\u001c8oK\u000e$\u0018n\u001c8NC:\fw-\u001a:\u0002'\rdWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1\u0016\u0003=\u0003\"\u0001\u000e)\n\u0005E+#aE\"mkN$XM\u001d'j].lU\r^1eCR\f\u0017\u0001F2mkN$XM\u001d'j].lU\r^1eCR\f\u0007%A\u0004nKR\u0014\u0018nY:\u0011\u0005UsV\"\u0001,\u000b\u0005M;&B\u0001-Z\u0003\u0019\u0019w.\\7p]*\u0011!F\u0017\u0006\u00037r\u000ba!\u00199bG\",'\"A/\u0002\u0007=\u0014x-\u0003\u0002`-\n9Q*\u001a;sS\u000e\u001c\u0018\u0001\u0002;j[\u0016\u0004\"A\u00193\u000e\u0003\rT!\u0001M,\n\u0005\u0015\u001c'\u0001\u0002+j[\u0016\fa\u0001P5oSRtDc\u00025jU.dWN\u001c\t\u0003i\u0001AQA\u000f\u0005A\u0002mBQa\u0010\u0005A\u0002\u0001CQa\u0011\u0005A\u0002\u0011CQ!\u0014\u0005A\u0002=CQa\u0015\u0005A\u0002QCQ\u0001\u0019\u0005A\u0002\u0005\f!\u0002\\8h\u0007>tG/\u001a=u+\u0005\t\bC\u00012s\u0013\t\u00198M\u0001\u0006M_\u001e\u001cuN\u001c;fqR\f1\u0002\\8h\u0007>tG/\u001a=uA\u0005\t2\r\\;ti\u0016\u0014H*\u001b8l\u00072LWM\u001c;\u0016\u0003]\u0004\"\u0001\u000e=\n\u0005e,#\u0001G\"mkN$XM\u001d'j].tU\r^<pe.\u001cE.[3oi\u0006\u00112\r\\;ti\u0016\u0014H*\u001b8l\u00072LWM\u001c;!\u00035!\u0017P\\1nS\u000edunZ4feV\tQ\u0010\u0005\u00025}&\u0011q0\n\u0002\u0019\u00072,8\u000f^3s\u0019&t7\u000eR=oC6L7\rT8hO\u0016\u0014\u0018A\u00043z]\u0006l\u0017n\u0019'pO\u001e,'\u000fI\u0001\u0012[\u0016$\u0018\rZ1uC2K7\u000f^3oKJ\u001cXCAA\u0004!\u0019\tI!a\u0005\u0002\u00185\u0011\u00111\u0002\u0006\u0005\u0003\u001b\ty!A\u0004nkR\f'\r\\3\u000b\u0007\u0005Ea)\u0001\u0006d_2dWm\u0019;j_:LA!!\u0006\u0002\f\t1!)\u001e4gKJ\u00042\u0001NA\r\u0013\r\tY\"\n\u0002\u0011\u001b\u0016$\u0018\rZ1uC2K7\u000f^3oKJ\f!#\\3uC\u0012\fG/\u0019'jgR,g.\u001a:tA\u0005!2m\\8sI&t\u0017\r^8s\u0019&\u001cH/\u001a8feN,\"!a\t\u0011\r\u0005%\u00111CA\u0013!\r!\u0014qE\u0005\u0004\u0003S)#aE\"p_J$\u0017N\\1u_Jd\u0015n\u001d;f]\u0016\u0014\u0018!F2p_J$\u0017N\\1u_Jd\u0015n\u001d;f]\u0016\u00148\u000fI\u0001\u0017GV\u0014(/\u001a8u\u001b\u0016$\u0018\rZ1uC\u000ecWo\u001d;feV\u0011\u0011\u0011\u0007\t\u0005\u0003g\t)$D\u0001X\u0013\r\t9d\u0016\u0002\b\u00072,8\u000f^3s\u0003i\u0019WO\u001d:f]RlU\r^1eCR\f7\t\\;ti\u0016\u0014x\fJ3r)\u0011\ti$a\u0011\u0011\u0007\u0015\u000by$C\u0002\u0002B\u0019\u0013A!\u00168ji\"I\u0011Q\t\u000b\u0002\u0002\u0003\u0007\u0011\u0011G\u0001\u0004q\u0012\n\u0014aF2veJ,g\u000e^'fi\u0006$\u0017\r^1DYV\u001cH/\u001a:!Q\r)\u00121\n\t\u0004\u000b\u00065\u0013bAA(\r\nAao\u001c7bi&dW-\u0001\ndkJ\u0014XM\u001c;D_>\u0014H-\u001b8bi>\u0014XCAA+!\u0011\t\u0019$a\u0016\n\u0007\u0005esK\u0001\u0003O_\u0012,\u0017AF2veJ,g\u000e^\"p_J$\u0017N\\1u_J|F%Z9\u0015\t\u0005u\u0012q\f\u0005\n\u0003\u000b:\u0012\u0011!a\u0001\u0003+\n1cY;se\u0016tGoQ8pe\u0012Lg.\u0019;pe\u0002B3\u0001GA&\u0003\u0019!wnV8sWR\u0011\u0011QH\u0001\u0011S:LG/[1uKNCW\u000f\u001e3po:$\"!!\u001c\u0011\u0007\u0015\u000by'C\u0002\u0002r\u0019\u0013qAQ8pY\u0016\fg.A\u0007bo\u0006LGo\u00155vi\u0012|wO\\\u0001\fC\u0012$G*[:uK:,'\u000f\u0006\u0003\u0002>\u0005e\u0004bBA>9\u0001\u0007\u0011qC\u0001\tY&\u001cH/\u001a8fe\u00061\u0012\r\u001a3D_>\u0014H-\u001b8bi>\u0014H*[:uK:,'\u000f\u0006\u0003\u0002>\u0005\u0005\u0005bBA>;\u0001\u0007\u0011QE\u0001\u0016e\u0016lw\u000e^3MS:\\7i\\8sI&t\u0017\r^8s+\t\t9\t\u0005\u0003F\u0011\u0006U\u0013aE2sK\u0006$XMT3uo>\u00148n\u00117jK:$H#B<\u0002\u000e\u0006=\u0005\"B  \u0001\u0004\u0001\u0005\"B' \u0001\u0004y\u0015aF8o\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3tiV\u0003H-\u0019;f\u0003Qi\u0017-\u001f2f\r&tGmQ8pe\u0012Lg.\u0019;pe\u0006\u0011\u0003O]8dKN\u001cH)Z:de&\u0014Wm\u00117vgR,'\u000fT5oWJ+7\u000f]8og\u0016$B!!\u0010\u0002\u001a\"9\u00111\u0014\u0012A\u0002\u0005u\u0015\u0001\u0003:fgB|gn]3\u0011\t\u0005}\u0015QU\u0007\u0003\u0003CS1!a)Z\u0003\u001d\u0019G.[3oiNLA!a*\u0002\"\nq1\t\\5f]R\u0014Vm\u001d9p]N,\u0017AH;tK\u000e{g\u000e\u001e:pY2,'/Q:MS:\\7i\\8sI&t\u0017\r^8s\u0001")
public class ClusterLinkMetadataThread
extends ShutdownableThread
implements MetadataRefreshListener {
    private final KafkaConfig brokerConfig;
    private final ClusterLinkConfig clusterLinkConfig;
    private final Option<ClusterLinkDestConnectionManager> destConnectionManager;
    private final ClusterLinkMetadata clusterLinkMetadata;
    private final Metrics metrics;
    private final Time time;
    private final LogContext logContext;
    private final ClusterLinkNetworkClient clusterLinkClient;
    private final ClusterLinkDynamicLogger dynamicLogger;
    private final Buffer<MetadataListener> metadataListeners;
    private final Buffer<CoordinatorListener> coordinatorListeners;
    private volatile Cluster currentMetadataCluster;
    private volatile Node currentCoordinator;

    public ClusterLinkMetadata clusterLinkMetadata() {
        return this.clusterLinkMetadata;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    public ClusterLinkNetworkClient clusterLinkClient() {
        return this.clusterLinkClient;
    }

    private ClusterLinkDynamicLogger dynamicLogger() {
        return this.dynamicLogger;
    }

    private Buffer<MetadataListener> metadataListeners() {
        return this.metadataListeners;
    }

    private Buffer<CoordinatorListener> coordinatorListeners() {
        return this.coordinatorListeners;
    }

    private Cluster currentMetadataCluster() {
        return this.currentMetadataCluster;
    }

    private void currentMetadataCluster_$eq(Cluster x$1) {
        this.currentMetadataCluster = x$1;
    }

    private Node currentCoordinator() {
        return this.currentCoordinator;
    }

    private void currentCoordinator_$eq(Node x$1) {
        this.currentCoordinator = x$1;
    }

    @Override
    public void doWork() {
        try {
            this.clusterLinkClient().networkClient().poll(Long.MAX_VALUE, this.time.milliseconds());
            this.maybeFindCoordinator();
            Cluster newMetadataCluster = this.clusterLinkMetadata().fetch();
            if (newMetadataCluster == this.currentMetadataCluster()) {
                this.clusterLinkMetadata().maybeThrowFatalException();
                return;
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Process cluster link metadata ").append(newMetadataCluster).toString());
            this.metadataListeners().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.onNewMetadata(newMetadataCluster);
                return BoxedUnit.UNIT;
            });
            this.currentMetadataCluster_$eq(newMetadataCluster);
            this.currentCoordinator_$eq(null);
            this.maybeFindCoordinator();
            this.dynamicLogger().resetErrors();
        }
        catch (Throwable throwable) {
            if (throwable instanceof DisconnectException && !this.clusterLinkClient().networkClient().active()) {
                return;
            }
            if (throwable instanceof Exception) {
                Exception exception = (Exception)throwable;
                this.dynamicLogger().error("Failed to refresh metadata", exception);
                this.metadataListeners().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    x$3.onMetadataFailure(exception);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            throw throwable;
        }
    }

    @Override
    public boolean initiateShutdown() {
        if (super.initiateShutdown()) {
            this.clusterLinkClient().initiateClose();
            return true;
        }
        return false;
    }

    @Override
    public void awaitShutdown() {
        try {
            super.awaitShutdown();
        }
        catch (InterruptedException interruptedException) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Interrupted while awaiting metadata shutdown");
            super.awaitShutdown();
        }
        try {
            this.clusterLinkClient().close();
            return;
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to close metadata client after shutting down thread", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    public void addListener(MetadataListener listener) {
        this.metadataListeners().$plus$eq((Object)listener);
    }

    public void addCoordinatorListener(CoordinatorListener listener) {
        this.coordinatorListeners().$plus$eq((Object)listener);
    }

    public Option<Node> remoteLinkCoordinator() {
        return Option$.MODULE$.apply((Object)this.currentCoordinator());
    }

    /*
     * WARNING - void declaration
     */
    public ClusterLinkNetworkClient createNetworkClient(ClusterLinkConfig clusterLinkConfig, ClusterLinkMetadata clusterLinkMetadata) {
        void var3_3;
        ClusterLinkNetworkClient clusterLinkClient = new ClusterLinkNetworkClient(this.brokerConfig, clusterLinkConfig, ClusterLinkMetrics$.MODULE$.throttleTimeSensorName(clusterLinkMetadata.linkName()), (Option<ClusterLinkMetadata>)new Some((Object)clusterLinkMetadata), (Option<MetadataUpdater>)None$.MODULE$, this.metrics, ClusterLinkFactory$.MODULE$.linkMetricTags(clusterLinkMetadata.linkName()), this.time, new StringBuilder(22).append("cluster-link-metadata-").append(clusterLinkMetadata.linkDescription()).toString(), "metadata", this.logContext());
        this.destConnectionManager.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.enableClusterLink(clusterLinkClient, (Option<AdminMetadataManager>)None$.MODULE$);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    @Override
    public void onMetadataRequestUpdate() {
        this.clusterLinkClient().networkClient().wakeup();
    }

    private void maybeFindCoordinator() {
        Node controller;
        Node node = controller = this.currentMetadataCluster() == null ? null : this.currentMetadataCluster().controller();
        if (this.currentCoordinator() == null && this.coordinatorListeners().nonEmpty() && controller != null && controller.id() >= 0) {
            if (this.clusterLinkClient().networkClient().ready(controller, this.time.milliseconds())) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Determine link coordinator using DescribeClusterLinks controllerId=").append(controller).toString());
                DescribeClusterLinksRequest.Builder requestBuilder = new DescribeClusterLinksRequest.Builder(Optional.of(Collections.singleton(this.clusterLinkMetadata().linkName())), false, Predef$.MODULE$.Integer2int(this.clusterLinkConfig.requestTimeoutMs()));
                long now = this.time.milliseconds();
                ClientRequest request = this.clusterLinkClient().networkClient().newClientRequest(controller.idString(), (AbstractRequest.Builder)requestBuilder, now, true, Predef$.MODULE$.Integer2int(this.clusterLinkConfig.requestTimeoutMs()), response -> this.processDescribeClusterLinkResponse(response));
                this.clusterLinkClient().networkClient().send(request, now);
                return;
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Controller connection not yet ready to send DescribeClusterLinks request");
        }
    }

    private void processDescribeClusterLinkResponse(ClientResponse response) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Process DescribeClusterLinks response ").append(response).toString());
        if (response.wasDisconnected()) {
            this.clusterLinkMetadata().requestUpdate();
            return;
        }
        if (response.versionMismatch() != null || response.requestHeader().apiVersion() < 1) {
            this.useControllerAsLinkCoordinator();
            return;
        }
        DescribeClusterLinksResponseData describeResponse = ((DescribeClusterLinksResponse)response.responseBody()).data();
        if (describeResponse.errorCode() == Errors.NONE.code() && !describeResponse.entries().isEmpty()) {
            DescribeClusterLinksResponseData.EntryData entry = (DescribeClusterLinksResponseData.EntryData)describeResponse.entries().get(0);
            if (entry.linkCoordinatorId() != -1) {
                Node coordinator = new Node(entry.linkCoordinatorId(), entry.linkCoordinatorHost(), entry.linkCoordinatorPort());
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Remote link coordinator is ").append(coordinator).toString());
                this.currentCoordinator_$eq(coordinator);
                this.coordinatorListeners().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                    x$5.onNewRemoteLinkCoordinator(coordinator);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (entry.linkState() == ClusterLinkDescription.LinkState.ACTIVE.getValue()) {
                this.useControllerAsLinkCoordinator();
                return;
            }
        } else {
            this.useControllerAsLinkCoordinator();
        }
    }

    private void useControllerAsLinkCoordinator() {
        Node controller;
        Node node = controller = this.currentMetadataCluster() == null ? null : this.currentMetadataCluster().controller();
        if (controller != null && controller.id() != -1) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Cluster link coordinator not known, using controller ").append(controller).append(" instead").toString());
            this.currentCoordinator_$eq(controller);
            this.coordinatorListeners().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                x$6.onNewRemoteLinkCoordinator(controller);
                return BoxedUnit.UNIT;
            });
            return;
        }
        this.clusterLinkMetadata().requestUpdate();
    }

    public ClusterLinkMetadataThread(KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, Option<ClusterLinkDestConnectionManager> destConnectionManager, ClusterLinkMetadata clusterLinkMetadata, Metrics metrics, Time time) {
        this.brokerConfig = brokerConfig;
        this.clusterLinkConfig = clusterLinkConfig;
        this.destConnectionManager = destConnectionManager;
        this.clusterLinkMetadata = clusterLinkMetadata;
        this.metrics = metrics;
        this.time = time;
        super(new StringBuilder(13).append("LinkMetadata-").append(clusterLinkMetadata.linkDescription()).toString(), ShutdownableThread$.MODULE$.$lessinit$greater$default$2());
        this.logContext = new LogContext(new StringBuilder(29).append("[ClusterLinkMetadataClient ").append(clusterLinkMetadata.linkDescription()).append("] ").toString(), (AtomicReference)destConnectionManager.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.maxLogLevel()).orNull(Predef$.MODULE$.$conforms()));
        this.clusterLinkClient = this.createNetworkClient(clusterLinkConfig, clusterLinkMetadata);
        this.dynamicLogger = new ClusterLinkDynamicLogger(this, ClusterLinkDynamicLogger$.MODULE$.$lessinit$greater$default$2(), ClusterLinkDynamicLogger$.MODULE$.$lessinit$greater$default$3(), ClusterLinkDynamicLogger$.MODULE$.$lessinit$greater$default$4());
        this.metadataListeners = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.coordinatorListeners = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        clusterLinkMetadata.setRefreshListener(this);
    }
}

