/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kafka.controller.KafkaController;
import kafka.log.LogConfig$;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.MetadataSupport;
import kafka.server.RaftSupport;
import kafka.server.ReplicaManager;
import kafka.server.ZkSupport;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetadataManager$;
import kafka.server.link.ClusterLinkMetadataManagerWithKRaftSupport;
import kafka.server.link.ClusterLinkMetadataManagerWithZkSupport;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.message.CreateClusterLinksRequestData;
import org.apache.kafka.common.requests.CreateClusterLinksResponse;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00115a!B)S\u0003\u0003I\u0006\u0002\u00034\u0001\u0005\u000b\u0007I\u0011B4\t\u00111\u0004!\u0011!Q\u0001\n!D\u0001\"\u001c\u0001\u0003\u0006\u0004%IA\u001c\u0005\tg\u0002\u0011\t\u0011)A\u0005_\"AA\u000f\u0001BC\u0002\u0013\u0005Q\u000f\u0003\u0005z\u0001\t\u0005\t\u0015!\u0003w\u0011!Q\bA!A!\u0002\u0013Y\bbBA\f\u0001\u0011\u0005\u0011\u0011\u0004\u0005\n\u0003K\u0001!\u0019!C\t\u0003OA\u0001\"a\u0010\u0001A\u0003%\u0011\u0011\u0006\u0005\f\u0003\u0003\u0002\u0001\u0019!a\u0001\n#\t\u0019\u0005C\u0006\u0002F\u0001\u0001\r\u00111A\u0005\u0012\u0005\u001d\u0003BCA*\u0001\u0001\u0007\t\u0011)Q\u0005}\"I\u0011Q\u000b\u0001C\u0002\u0013%\u0011q\u000b\u0005\t\u0003S\u0002\u0001\u0015!\u0003\u0002Z!I\u00111\u000e\u0001C\u0002\u0013%\u0011Q\u000e\u0005\t\u0003\u000b\u0003\u0001\u0015!\u0003\u0002p!I\u0011q\u0011\u0001C\u0002\u0013%\u0011\u0011\u0012\u0005\t\u0003#\u0003\u0001\u0015!\u0003\u0002\f\"Y\u00111\u0013\u0001A\u0002\u0003\u0007I\u0011BAK\u0011-\t9\n\u0001a\u0001\u0002\u0004%I!!'\t\u0017\u0005u\u0005\u00011A\u0001B\u0003&\u0011q\u0010\u0005\n\u0003?\u0003\u0001\u0019!C\u0005\u0003CC\u0011\"!+\u0001\u0001\u0004%I!a+\t\u0011\u0005=\u0006\u0001)Q\u0005\u0003GC\u0011\"!-\u0001\u0001\u0004%I!a-\t\u0013\u0005m\u0006\u00011A\u0005\n\u0005u\u0006\u0002CAa\u0001\u0001\u0006K!!.\t\u0013\u0005\r\u0007\u00011A\u0005\n\u0005\u0015\u0007\"CAn\u0001\u0001\u0007I\u0011BAo\u0011!\t\t\u000f\u0001Q!\n\u0005\u001d\u0007bBAr\u0001\u0011\u0015\u0011Q\u001d\u0005\b\u0003O\u0004A\u0011BAu\u0011\u001d\ty\u000f\u0001C\u0005\u0003KDq!!=\u0001\t\u0013\t\u0019\u0010C\u0004\u0002|\u0002!I!!:\t\u000f\u0005u\b\u0001\"\u0003\u0002\u0000\"9!Q\u0001\u0001\u0005\n\t\u001d\u0001b\u0002B\u000f\u0001\u0011\u0005!q\u0004\u0005\b\u0005C\u0001A\u0011\u0002B\u0012\u0011\u001d\u0011I\u0003\u0001C\u0005\u0005WAqAa\u000e\u0001\t\u0013\u0011I\u0004C\u0004\u0003@\u0001!)A!\u0011\t\u000f\t%\u0003\u0001\"\u0002\u0003L!9!\u0011\u000b\u0001\u0005\n\tM\u0003b\u0002B-\u0001\u0011\u0005!1\f\u0005\n\u0005G\u0002\u0011\u0013!C\u0001\u0005KBqAa\u001f\u0001\t\u0003\u0011i\bC\u0004\u0003\n\u0002!)!!:\t\u000f\t-\u0005\u0001\"\u0002\u0003\u000e\"9!1\u0013\u0001\u0007\u0002\tU\u0005b\u0002BN\u0001\u0019\u0005!Q\u0014\u0005\b\u0005_\u0003a\u0011\u0001BY\u0011\u001d\u0011)\r\u0001D\u0001\u0005\u000fDqAa3\u0001\r\u0003\u0011i\rC\u0004\u0003T\u00021\tA!6\t\u000f\t]\u0007\u0001\"\u0001\u0003Z\"9!Q\u001c\u0001\u0005\u0002\t}\u0007b\u0002Bw\u0001\u0011\u0005!q\u001e\u0005\b\u0005g\u0004a\u0011\u0001B{\u0011\u001d\u0011I\u0010\u0001D\u0001\u0005wDqaa\u0002\u0001\r\u0003\u0019I\u0001C\u0004\u0004\u000e\u00011\taa\u0004\t\u000f\r5\u0001A\"\u0001\u0004\"!91Q\u0005\u0001\u0007\u0002\r\u001d\u0002bBB\u0019\u0001\u0019\u000511\u0007\u0005\b\u0007{\u0001a\u0011AB \u0011\u001d\u0019\u0019\u0005\u0001D\u0001\u0007\u000bBqa!\u0014\u0001\r\u0003\u0019y\u0005C\u0004\u0004^\u00011\taa\u0018\t\u000f\r\u001d\u0004A\"\u0001\u0004j!91Q\u000e\u0001\u0007\u0012\r=\u0004bBBB\u0001\u0019\u00051Q\u0011\u0005\b\u0007\u001f\u0003a\u0011ABI\u0011\u001d\u0019Y\f\u0001D\u0001\u0007{Cqa!1\u0001\t\u000b\u0019\u0019mB\u0004\u0004JJC\taa3\u0007\rE\u0013\u0006\u0012ABg\u0011\u001d\t9B\u0014C\u0001\u0007\u001fDqa!5O\t\u0003\u0019\u0019N\u0001\u000eDYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018-T1oC\u001e,'O\u0003\u0002T)\u0006!A.\u001b8l\u0015\t)f+\u0001\u0004tKJ4XM\u001d\u0006\u0002/\u0006)1.\u00194lC\u000e\u00011c\u0001\u0001[AB\u00111LX\u0007\u00029*\tQ,A\u0003tG\u0006d\u0017-\u0003\u0002`9\n1\u0011I\\=SK\u001a\u0004\"!\u00193\u000e\u0003\tT!a\u0019,\u0002\u000bU$\u0018\u000e\\:\n\u0005\u0015\u0014'a\u0002'pO\u001eLgnZ\u0001\rEJ|7.\u001a:D_:4\u0017nZ\u000b\u0002QB\u0011\u0011N[\u0007\u0002)&\u00111\u000e\u0016\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0007ce>\\WM]\"p]\u001aLw\rI\u0001\ng\u000eDW\rZ;mKJ,\u0012a\u001c\t\u0003aFl\u0011AU\u0005\u0003eJ\u0013Ac\u00117vgR,'\u000fT5oWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018AC:dQ\u0016$W\u000f\\3sA\u0005iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016,\u0012A\u001e\t\u0003S^L!\u0001\u001f+\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u00039iW\r^1eCR\f7)Y2iK\u0002\n\u0011\u0003\\8dC2\fE-\\5o\r\u0006\u001cGo\u001c:z!\rYFP`\u0005\u0003{r\u0013\u0011BR;oGRLwN\u001c\u0019\u0011\u0007}\f\u0019\"\u0004\u0002\u0002\u0002)!\u00111AA\u0003\u0003\u0015\tG-\\5o\u0015\u0011\t9!!\u0003\u0002\u000f\rd\u0017.\u001a8ug*\u0019q+a\u0003\u000b\t\u00055\u0011qB\u0001\u0007CB\f7\r[3\u000b\u0005\u0005E\u0011aA8sO&!\u0011QCA\u0001\u0005\u0015\tE-\\5o\u0003\u0019a\u0014N\\5u}QQ\u00111DA\u000f\u0003?\t\t#a\t\u0011\u0005A\u0004\u0001\"\u00024\t\u0001\u0004A\u0007\"B7\t\u0001\u0004y\u0007\"\u0002;\t\u0001\u00041\b\"\u0002>\t\u0001\u0004Y\u0018!D7fi\u0006$\u0017\r^1U_BL7-\u0006\u0002\u0002*A!\u00111FA\u001d\u001d\u0011\ti#!\u000e\u0011\u0007\u0005=B,\u0004\u0002\u00022)\u0019\u00111\u0007-\u0002\rq\u0012xn\u001c;?\u0013\r\t9\u0004X\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0012Q\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005]B,\u0001\bnKR\fG-\u0019;b)>\u0004\u0018n\u0019\u0011\u0002\u0013\u0011,7\u000f^!e[&tW#\u0001@\u0002\u001b\u0011,7\u000f^!e[&tw\fJ3r)\u0011\tI%a\u0014\u0011\u0007m\u000bY%C\u0002\u0002Nq\u0013A!\u00168ji\"A\u0011\u0011\u000b\u0007\u0002\u0002\u0003\u0007a0A\u0002yIE\n!\u0002Z3ti\u0006#W.\u001b8!\u0003\u0011awnY6\u0016\u0005\u0005e\u0003\u0003BA.\u0003Kj!!!\u0018\u000b\t\u0005}\u0013\u0011M\u0001\u0005Y\u0006twM\u0003\u0002\u0002d\u0005!!.\u0019<b\u0013\u0011\t9'!\u0018\u0003\r=\u0013'.Z2u\u0003\u0015awnY6!\u0003=ywO\\3e!\u0006\u0014H/\u001b;j_:\u001cXCAA8!\u0019\t\t(a\u001f\u0002\u00005\u0011\u00111\u000f\u0006\u0005\u0003k\n9(A\u0004nkR\f'\r\\3\u000b\u0007\u0005eD,\u0001\u0006d_2dWm\u0019;j_:LA!! \u0002t\t\u00191+\u001a;\u0011\u0007m\u000b\t)C\u0002\u0002\u0004r\u00131!\u00138u\u0003AywO\\3e!\u0006\u0014H/\u001b;j_:\u001c\b%A\nqCJ$\u0018\u000e^5p]R{W\t]8dQ6\u000b\u0007/\u0006\u0002\u0002\fBA\u0011\u0011OAG\u0003\u007f\ny(\u0003\u0003\u0002\u0010\u0006M$aA'ba\u0006!\u0002/\u0019:uSRLwN\u001c+p\u000bB|7\r['ba\u0002\nQC\\;n\u001b\u0016$\u0018\rZ1uCB\u000b'\u000f^5uS>t7/\u0006\u0002\u0002\u0000\u0005Ib.^7NKR\fG-\u0019;b!\u0006\u0014H/\u001b;j_:\u001cx\fJ3r)\u0011\tI%a'\t\u0013\u0005ES#!AA\u0002\u0005}\u0014A\u00068v[6+G/\u00193bi\u0006\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\u0017%t\u0017\u000e^5bY&TX\rZ\u000b\u0003\u0003G\u00032aWAS\u0013\r\t9\u000b\u0018\u0002\b\u0005>|G.Z1o\u0003=Ig.\u001b;jC2L'0\u001a3`I\u0015\fH\u0003BA%\u0003[C\u0011\"!\u0015\u0019\u0003\u0003\u0005\r!a)\u0002\u0019%t\u0017\u000e^5bY&TX\r\u001a\u0011\u0002\u00159,XNU3ue&,7/\u0006\u0002\u00026B\u00191,a.\n\u0007\u0005eFL\u0001\u0003M_:<\u0017A\u00048v[J+GO]5fg~#S-\u001d\u000b\u0005\u0003\u0013\ny\fC\u0005\u0002Rm\t\t\u00111\u0001\u00026\u0006Ya.^7SKR\u0014\u0018.Z:!\u0003YiW\r^1eCR\f\u0017*\\1hK2K7\u000f^3oKJ\u001cXCAAd!\u0019\t\t(!3\u0002N&!\u00111ZA:\u0005\u0019\u0011UO\u001a4feB!\u0011qZAk\u001d\r\u0001\u0018\u0011[\u0005\u0004\u0003'\u0014\u0016AE\"mkN$XM\u001d'j].4\u0015m\u0019;pefLA!a6\u0002Z\nIB*\u001b8l\u001b\u0016$\u0018\rZ1uC&k\u0017mZ3MSN$XM\\3s\u0015\r\t\u0019NU\u0001\u001b[\u0016$\u0018\rZ1uC&k\u0017mZ3MSN$XM\\3sg~#S-\u001d\u000b\u0005\u0003\u0013\ny\u000eC\u0005\u0002Ry\t\t\u00111\u0001\u0002H\u00069R.\u001a;bI\u0006$\u0018-S7bO\u0016d\u0015n\u001d;f]\u0016\u00148\u000fI\u0001\bgR\f'\u000f^;q)\t\tI%A\bti\u0006\u0014H/\u001e9J]R,'O\\1m)\u0011\tI%a;\t\u000f\u00055\u0018\u00051\u0001\u00026\u00069A-\u001a7bs6\u001b\u0018!\t7p_.,\b/\u00118e\u001b\u0006L(-Z\"sK\u0006$X-T3uC\u0012\fG/\u0019+pa&\u001c\u0017AH4fi6+G/\u00193bi\u0006$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u+\t\t)\u0010E\u0003\\\u0003o\fy(C\u0002\u0002zr\u0013aa\u00149uS>t\u0017aE2sK\u0006$X-T3uC\u0012\fG/\u0019+pa&\u001c\u0017!G5oSRL\u0017\r\\5{K6+G/\u00193bi\u0006l\u0015M\\1hKJ$B!!\u0013\u0003\u0002!9!1A\u0013A\u0002\u0005}\u0014A\u00049beRLG/[8o\u0007>,h\u000e^\u0001 O\u0016$8\t\\;ti\u0016\u0014H*\u001b8l\u0013\u0012\u001chi\u001c:QCJ$\u0018\u000e^5p]&#G\u0003\u0002B\u0005\u00053\u0001b!a\u000b\u0003\f\t5\u0011\u0002BA?\u0003{\u0001BAa\u0004\u0003\u00165\u0011!\u0011\u0003\u0006\u0005\u0005'\tI!\u0001\u0004d_6lwN\\\u0005\u0005\u0005/\u0011\tB\u0001\u0003Vk&$\u0007b\u0002B\u000eM\u0001\u0007\u0011qP\u0001\fa\u0006\u0014H/\u001b;j_:LE-A\u0015hKR\u001cE.^:uKJd\u0015N\\6JIN<\u0016\u000e\u001e5Po:,G\rT5oW\u000e{wN\u001d3j]\u0006$xN\u001d\u000b\u0003\u0005\u0013\tQ\u0003\\5oW:\u000bW.\u001a+p!\u0006\u0014H/\u001b;j_:LE\r\u0006\u0003\u0002\u0000\t\u0015\u0002b\u0002B\u0014Q\u0001\u0007\u0011\u0011F\u0001\tY&t7NT1nK\u0006\u0019R.\u001a;bI\u0006$\u0018\rV8qS\u000e\u001cuN\u001c4jOV\u0011!Q\u0006\t\t\u0005_\u0011)$!\u000b\u0002*5\u0011!\u0011\u0007\u0006\u0005\u0005g\t\t'\u0001\u0003vi&d\u0017\u0002BAH\u0005c\t!\u0003\\8h\u000bJ\u0014xN]:P]\u001a\u000b\u0017\u000e\\;sKR!\u0011\u0011\nB\u001e\u0011\u001d\u0011iD\u000ba\u0001\u0003S\t1a\u001d;s\u0003)yg.\u00127fGRLwN\u001c\u000b\u0007\u0003\u0013\u0012\u0019E!\u0012\t\u000f\tm1\u00061\u0001\u0002\u0000!9!qI\u0016A\u0002\u0005}\u0014a\u00037fC\u0012,'/\u00129pG\"\fQb\u001c8SKNLwM\\1uS>tGCBA%\u0005\u001b\u0012y\u0005C\u0004\u0003\u001c1\u0002\r!a \t\u000f\t\u001dC\u00061\u0001\u0002v\u0006IR.Y=cKV\u0003H-\u0019;f!\u0006\u0014H/\u001b;j_:,\u0005o\\2i)\u0019\t\u0019K!\u0016\u0003X!9!1D\u0017A\u0002\u0005}\u0004b\u0002B$[\u0001\u0007\u0011Q_\u0001\u0012SNd\u0015N\\6D_>\u0014H-\u001b8bi>\u0014HCBAR\u0005;\u0012y\u0006C\u0004\u0003(9\u0002\r!!\u000b\t\u0013\t\u0005d\u0006%AA\u0002\u0005\r\u0016\u0001G;tK\u000e{g\u000e\u001e:pY2,'/\u00134Bm\u0006LG.\u00192mK\u0006Y\u0012n\u001d'j].\u001cun\u001c:eS:\fGo\u001c:%I\u00164\u0017-\u001e7uII*\"Aa\u001a+\t\u0005\r&\u0011N\u0016\u0003\u0005W\u0002BA!\u001c\u0003x5\u0011!q\u000e\u0006\u0005\u0005c\u0012\u0019(A\u0005v]\u000eDWmY6fI*\u0019!Q\u000f/\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003z\t=$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006yA.\u001b8l\u0007>|'\u000fZ5oCR|'\u000f\u0006\u0003\u0003\u0000\t\u001d\u0005#B.\u0002x\n\u0005\u0005\u0003\u0002B\b\u0005\u0007KAA!\"\u0003\u0012\t!aj\u001c3f\u0011\u001d\u00119\u0003\ra\u0001\u0003S\t\u0001b\u001d5vi\u0012|wO\\\u0001\te\u0016<\u0017n\u001d;feR!\u0011\u0011\nBH\u0011\u001d\u0011\tJ\ra\u0001\u0003\u001b\f\u0001\u0002\\5ti\u0016tWM]\u0001\u0014SN\f5\r^5wK6K'O]8s)>\u0004\u0018n\u0019\u000b\u0005\u0003G\u00139\nC\u0004\u0003\u001aN\u0002\r!!\u000b\u0002\u000bQ|\u0007/[2\u0002\u00175L'O]8s)>\u0004\u0018n\u0019\u000b\u0005\u0005?\u0013i\u000bE\u0003\\\u0003o\u0014\t\u000b\u0005\u0003\u0003$\n%VB\u0001BS\u0015\u0011\u00119+!\u0003\u0002\u00115,G/\u00193bi\u0006LAAa+\u0003&\nYQ*\u001b:s_J$v\u000e]5d\u0011\u001d\u0011I\n\u000ea\u0001\u0003S\tQc\u00197vgR,'\u000fT5oWR{\u0007/[2Ti\u0006$X\r\u0006\u0003\u00034\n}\u0006\u0003\u0003B[\u0005o\u000bIC!/\u000e\u0005\u0005]\u0014\u0002BAH\u0003o\u00022\u0001\u001dB^\u0013\r\u0011iL\u0015\u0002\u0016\u00072,8\u000f^3s\u0019&t7\u000eV8qS\u000e\u001cF/\u0019;f\u0011\u001d\u0011\t-\u000ea\u0001\u0005\u0007\fa\u0001^8qS\u000e\u001c\bCBA\u0016\u0005\u0017\tI#A\nnSJ\u0014xN\u001d+pa&\u001c7OR8s\u0019&t7\u000e\u0006\u0003\u00034\n%\u0007b\u0002B\u0014m\u0001\u0007\u0011\u0011F\u0001\u0010C2dW*\u001b:s_J$v\u000e]5dgR!!1\u0017Bh\u0011\u001d\u0011\tn\u000ea\u0001\u0003G\u000ba\"\u001b8dYV$Wm\u0015;paB,G-A\u000bhKR\fE\u000e\u001c+pa&\u001c7/\u00138DYV\u001cH/\u001a:\u0015\u0005\t\r\u0017!\u00048v[B\u000b'\u000f^5uS>t7\u000f\u0006\u0003\u0002v\nm\u0007b\u0002BMs\u0001\u0007\u0011\u0011F\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogR!!\u0011\u001dBu!\u0019\tYCa\u0003\u0003dB!!q\u0002Bs\u0013\u0011\u00119O!\u0005\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"9!1\u001e\u001eA\u0002\u0005%\u0012!\u0003;pa&\u001cg*Y7f\u0003!A\u0017m\u001d+pa&\u001cG\u0003BAR\u0005cDqA!'<\u0001\u0004\tI#\u0001\u000ejgR{\u0007/[2Rk\u0016,X\rZ+q\r>\u0014H)\u001a7fi&|g\u000e\u0006\u0003\u0002$\n]\bb\u0002BMy\u0001\u0007\u0011\u0011F\u0001\u0018K:\u001cXO]3DYV\u001cH/\u001a:MS:\\W\t_5tiN$B!!\u0013\u0003~\"9!q`\u001fA\u0002\r\u0005\u0011A\u00027j].LE\r\u0005\u0003\u00030\r\r\u0011\u0002BB\u0003\u0005c\u0011A!V+J\t\u0006\t2\r\\;ti\u0016\u0014H*\u001b8l\u000bbL7\u000f^:\u0015\t\u0005\r61\u0002\u0005\b\u0005\u007ft\u0004\u0019AB\u0001\u0003I9W\r^\"mkN$XM\u001d'j].$\u0015\r^1\u0015\t\rE1q\u0004\t\u00067\u0006]81\u0003\t\u0005\u0007+\u0019Y\"\u0004\u0002\u0004\u0018)\u00191\u0011\u0004,\u0002\u0005i\\\u0017\u0002BB\u000f\u0007/\u0011qb\u00117vgR,'\u000fT5oW\u0012\u000bG/\u0019\u0005\b\u0005\u007f|\u0004\u0019AB\u0001)\u0011\u0019\tba\t\t\u000f\t\u001d\u0002\t1\u0001\u0002*\u0005Ir-\u001a;DYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e\u0004&o\u001c9t)\u0011\u0019Ica\f\u0011\t\t=21F\u0005\u0005\u0007[\u0011\tD\u0001\u0006Qe>\u0004XM\u001d;jKNDqAa@B\u0001\u0004\u0019\t!\u0001\u000bhKR\u001cE.^:uKJd\u0015N\\6D_:4\u0017n\u001a\u000b\u0005\u0007k\u0019Y\u0004E\u0002q\u0007oI1a!\u000fS\u0005E\u0019E.^:uKJd\u0015N\\6D_:4\u0017n\u001a\u0005\b\u0005\u007f\u0014\u0005\u0019AB\u0001\u000399W\r\u001e+pa&\u001c7i\u001c8gS\u001e$Ba!\u000b\u0004B!9!\u0011T\"A\u0002\u0005%\u0012aG1mi\u0016\u00148\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4[\u001d>$W\r\u0006\u0004\u0002J\r\u001d3\u0011\n\u0005\b\u0005\u007f$\u0005\u0019AB\u0001\u0011\u001d\u0019Y\u0005\u0012a\u0001\u0007S\tQ\u0001\u001d:paN\f\u0001%\\1zE\u0016\u0014V-\u001a8def\u0004Ho\u00117vgR,'\u000fT5oW\u000e{gNZ5hgR!\u0011\u0011JB)\u0011\u001d\u0019\u0019&\u0012a\u0001\u0007+\n\u0011cY8oM&<GK]1og\u001a|'/\\3s!\u001dY6qKB\u0015\u00077J1a!\u0017]\u0005%1UO\\2uS>t\u0017\u0007E\u0003\\\u0003o\u001cI#\u0001\fde\u0016\fG/Z\"mkN$XM\u001d'j].Tfj\u001c3f)\u0019\tIe!\u0019\u0004f!911\r$A\u0002\rM\u0011aD2mkN$XM\u001d'j].$\u0015\r^1\t\u000f\r-c\t1\u0001\u0004*\u0005\u00192/\u001a;DYV\u001cH/\u001a:MS:\\'LT8eKR!\u0011\u0011JB6\u0011\u001d\u0019\u0019g\u0012a\u0001\u0007'\tqcZ3u\u00032dG*\u001b8lg\u001a\u0013x.\\'fi\u0006$\u0017\r^1\u0015\u0005\rE\u0004CBB:\u0007{\u001a\u0019B\u0004\u0003\u0004v\red\u0002BA\u0018\u0007oJ\u0011!X\u0005\u0004\u0007wb\u0016a\u00029bG.\fw-Z\u0005\u0005\u0007\u007f\u001a\tIA\u0002TKFT1aa\u001f]\u0003M\u0019X\r^'jeJ|'\u000fV8qS\u000e\u001cF/\u0019;f)\u0019\tIea\"\u0004\n\"9!\u0011T%A\u0002\u0005%\u0002bBBF\u0013\u0002\u00071QR\u0001\u0011[&\u0014(o\u001c:U_BL7m\u0015;bi\u0016\u0004RaWA|\u0005s\u000b!c\u0019:fCR,7\t\\;ti\u0016\u0014H*\u001b8lgR!11SBV!\u0019\u0019)ja'\u0004 6\u00111q\u0013\u0006\u0005\u00073\u0013\t$\u0001\u0006d_:\u001cWO\u001d:f]RLAa!(\u0004\u0018\n\t2i\\7qY\u0016$\u0018M\u00197f\rV$XO]3\u0011\t\r\u00056qU\u0007\u0003\u0007GSAa!*\u0003\u0012\u0005A!/Z9vKN$8/\u0003\u0003\u0004*\u000e\r&AG\"sK\u0006$Xm\u00117vgR,'\u000fT5oWN\u0014Vm\u001d9p]N,\u0007bBBW\u0015\u0002\u00071qV\u0001\u001eGJ,\u0017\r^3DYV\u001cH/\u001a:MS:\\7OU3rk\u0016\u001cH\u000fR1uCB!1\u0011WB\\\u001b\t\u0019\u0019L\u0003\u0003\u00046\nE\u0011aB7fgN\fw-Z\u0005\u0005\u0007s\u001b\u0019LA\u000fDe\u0016\fG/Z\"mkN$XM\u001d'j].\u001c(+Z9vKN$H)\u0019;b\u0003Y!W\r\\3uK\u000ecWo\u001d;fe2Kgn\u001b.O_\u0012,G\u0003BA%\u0007\u007fCqAa@L\u0001\u0004\u0019\t!\u0001\bjg\n\u0013xn[3s\u001f:d\u0017N\\3\u0015\t\u0005\r6Q\u0019\u0005\b\u0007\u000fd\u0005\u0019AA@\u0003!\u0011'o\\6fe&#\u0017AG\"mkN$XM\u001d'j].lU\r^1eCR\fW*\u00198bO\u0016\u0014\bC\u00019O'\tq%\f\u0006\u0002\u0004L\u0006\u00013M]3bi\u0016\u001cE.^:uKJd\u0015N\\6NKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s)A\tYb!6\u0004X\u000ee71]Bx\u0007c$\u0019\u0001C\u0003g!\u0002\u0007\u0001\u000eC\u0003n!\u0002\u0007q\u000eC\u0004\u0004\\B\u0003\ra!8\u0002\u001f5,G/\u00193bi\u0006\u001cV\u000f\u001d9peR\u00042![Bp\u0013\r\u0019\t\u000f\u0016\u0002\u0010\u001b\u0016$\u0018\rZ1uCN+\b\u000f]8si\"91Q\u001d)A\u0002\r\u001d\u0018\u0001G2p]R\u0014x\u000e\u001c7fe\u000eC\u0017M\u001c8fY6\u000bg.Y4feB)1,a>\u0004jB\u0019\u0011na;\n\u0007\r5HK\u0001\u0011Ce>\\WM\u001d+p\u0007>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\b\"\u0002>Q\u0001\u0004Y\bbBBz!\u0002\u00071Q_\u0001\u000bg\u0016\u0014h/\u001a:J]\u001a|\u0007\u0003BB|\u0007\u007fl!a!?\u000b\t\rm8Q`\u0001\u000bCV$\bn\u001c:ju\u0016\u0014(bA+\u0002\n%!A\u0011AB}\u0005Q\tU\u000f\u001e5pe&TXM]*feZ,'/\u00138g_\"9AQ\u0001)A\u0002\u0011\u001d\u0011A\u0004:fa2L7-Y'b]\u0006<WM\u001d\t\u0004S\u0012%\u0011b\u0001C\u0006)\nq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b")
public abstract class ClusterLinkMetadataManager
implements Logging {
    private final KafkaConfig brokerConfig;
    private final ClusterLinkScheduler scheduler;
    private final MetadataCache metadataCache;
    private final Function0<Admin> localAdminFactory;
    private final String metadataTopic;
    private Admin destAdmin;
    private final Object lock;
    private final Set<Object> ownedPartitions;
    private final scala.collection.mutable.Map<Object, Object> partitionToEpochMap;
    private int numMetadataPartitions;
    private boolean initialized;
    private long numRetries;
    private Buffer<ClusterLinkFactory.LinkMetadataImageListener> metadataImageListeners;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static ClusterLinkMetadataManager createClusterLinkMetadataManager(KafkaConfig kafkaConfig, ClusterLinkScheduler clusterLinkScheduler, MetadataSupport metadataSupport, Option<BrokerToControllerChannelManager> option, Function0<Admin> function0, AuthorizerServerInfo authorizerServerInfo, ReplicaManager replicaManager) {
        ClusterLinkMetadataManager clusterLinkMetadataManager;
        if (ClusterLinkMetadataManager$.MODULE$ == null) {
            throw null;
        }
        if (metadataSupport instanceof ZkSupport) {
            ZkSupport zkSupport = (ZkSupport)metadataSupport;
            KafkaController createClusterLinkMetadataManager_controller = zkSupport.controller();
            KafkaZkClient createClusterLinkMetadataManager_zkClient = zkSupport.zkClient();
            ZkMetadataCache createClusterLinkMetadataManager_metadataCache = zkSupport.metadataCache();
            clusterLinkMetadataManager = new ClusterLinkMetadataManagerWithZkSupport(kafkaConfig, clusterLinkScheduler, createClusterLinkMetadataManager_metadataCache, createClusterLinkMetadataManager_controller, createClusterLinkMetadataManager_zkClient, function0, replicaManager);
        } else if (metadataSupport instanceof RaftSupport) {
            KRaftMetadataCache createClusterLinkMetadataManager_metadataCache = ((RaftSupport)metadataSupport).metadataCache();
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException("BrokerToControllerChannelManager is not provided to ClusterLinkManager in KRaft mode");
                }
                throw new MatchError(option);
            }
            BrokerToControllerChannelManager createClusterLinkMetadataManager_channelManager = (BrokerToControllerChannelManager)((Some)option).value();
            ClusterLinkMetadataManagerWithKRaftSupport clusterLinkMetadataManagerWithKRaftSupport = new ClusterLinkMetadataManagerWithKRaftSupport(kafkaConfig, clusterLinkScheduler, createClusterLinkMetadataManager_metadataCache, createClusterLinkMetadataManager_channelManager, function0, authorizerServerInfo);
            clusterLinkMetadataManager = clusterLinkMetadataManagerWithKRaftSupport;
        } else {
            throw new MatchError((Object)metadataSupport);
        }
        return clusterLinkMetadataManager;
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public String metadataTopic() {
        return this.metadataTopic;
    }

    public Admin destAdmin() {
        return this.destAdmin;
    }

    public void destAdmin_$eq(Admin x$1) {
        this.destAdmin = x$1;
    }

    private Object lock() {
        return this.lock;
    }

    private Set<Object> ownedPartitions() {
        return this.ownedPartitions;
    }

    private scala.collection.mutable.Map<Object, Object> partitionToEpochMap() {
        return this.partitionToEpochMap;
    }

    private int numMetadataPartitions() {
        return this.numMetadataPartitions;
    }

    private void numMetadataPartitions_$eq(int x$1) {
        this.numMetadataPartitions = x$1;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    private long numRetries() {
        return this.numRetries;
    }

    private void numRetries_$eq(long x$1) {
        this.numRetries = x$1;
    }

    private Buffer<ClusterLinkFactory.LinkMetadataImageListener> metadataImageListeners() {
        return this.metadataImageListeners;
    }

    private void metadataImageListeners_$eq(Buffer<ClusterLinkFactory.LinkMetadataImageListener> x$1) {
        this.metadataImageListeners = x$1;
    }

    public final void startup() {
        if (Predef$.MODULE$.Boolean2boolean(this.brokerConfig().clusterLinkMetadataTopicEnable()) || this.metadataCache() instanceof KRaftMetadataCache) {
            this.startupInternal(0L);
        }
    }

    private void startupInternal(long delayMs) {
        if (this.destAdmin() == null) {
            this.destAdmin_$eq((Admin)this.localAdminFactory.apply());
        }
        this.scheduler().scheduleOnceWithDelay("lookupClusterLinkMetadataTopic", delayMs, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.lookupAndMaybeCreateMetadataTopic());
    }

    private void lookupAndMaybeCreateMetadataTopic() {
        Option<Object> numPartitions = this.getMetadataTopicPartitionCount();
        if (numPartitions.nonEmpty()) {
            if (!BoxesRunTime.equals((Object)numPartitions.get(), (Object)this.brokerConfig().clusterLinkMetadataTopicPartitions())) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Found internal metadata topic with different number of partitions(").append(numPartitions.get()).append(") than in the config(").append(this.brokerConfig().clusterLinkMetadataTopicPartitions()).toString());
            }
            this.initializeMetadataManager(BoxesRunTime.unboxToInt((Object)numPartitions.get()));
            return;
        }
        this.createMetadataTopic();
    }

    private Option<Object> getMetadataTopicPartitionCount() {
        return this.metadataCache().numPartitions(this.metadataTopic());
    }

    private void createMetadataTopic() {
        NewTopic topic = new NewTopic(this.metadataTopic(), Predef$.MODULE$.Integer2int(this.brokerConfig().clusterLinkMetadataTopicPartitions()), Predef$.MODULE$.Short2short(this.brokerConfig().clusterLinkMetadataTopicReplicationFactor()));
        topic.configs(this.metadataTopicConfig());
        CreateTopicsResult createResult = this.destAdmin().createTopics(Collections.singletonList(topic));
        this.scheduler().scheduleWhenComplete("createClusterLinkMetadataTopicResponse", createResult.all(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Long retryDelayMs = this.brokerConfig().clusterLinkMetadataTopicCreateRetryDelayMs();
            try {
                this.initializeMetadataManager(Predef$.MODULE$.Integer2int((Integer)createResult.numPartitions(this.metadataTopic()).get()));
                this.numRetries_$eq(0L);
                return;
            }
            catch (ExecutionException ex) {
                Throwable throwable = ex.getCause();
                if (throwable instanceof TopicExistsException) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cluster link metadata topic creation failed as it is already created.");
                    retryDelayMs = Predef$.MODULE$.long2Long(0L);
                } else if (throwable instanceof TopicAuthorizationException) {
                    TopicAuthorizationException topicAuthorizationException = (TopicAuthorizationException)throwable;
                    this.logErrorsOnFailure(new StringBuilder(54).append("Unable to create cluster link metadata topic due to ").append(topicAuthorizationException).append(": ").append(ex.getMessage()).toString());
                } else if (throwable != null) {
                    this.logErrorsOnFailure(new StringBuilder(45).append("Cluster link metadata topic creation failed: ").append(throwable).toString());
                } else {
                    throw new MatchError(null);
                }
                this.startupInternal(Predef$.MODULE$.Long2long(retryDelayMs));
                return;
            }
            catch (Throwable e) {
                this.logErrorsOnFailure(new StringBuilder(45).append("Cluster link metadata topic creation failed: ").append(e).toString());
                this.startupInternal(Predef$.MODULE$.Long2long(retryDelayMs));
                return;
            }
        });
    }

    private void initializeMetadataManager(int partitionCount) {
        Object object = this.lock();
        synchronized (object) {
            this.numMetadataPartitions_$eq(partitionCount);
            this.initialized_$eq(true);
        }
        scala.collection.immutable.Set<Uuid> linkIds = this.getClusterLinkIdsWithOwnedLinkCoordinator();
        this.metadataImageListeners().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.onClusterLinkCoordinatorElection((scala.collection.immutable.Set<Uuid>)linkIds);
            return BoxedUnit.UNIT;
        });
    }

    private scala.collection.immutable.Set<Uuid> getClusterLinkIdsForPartitionId(int partitionId) {
        block8: {
            Object object = this.lock();
            synchronized (object) {
                scala.collection.immutable.Set set;
                block7: {
                    if (!this.initialized()) {
                        set = Predef$.MODULE$.Set().empty();
                        break block7;
                    }
                    break block8;
                }
                return set;
            }
        }
        Seq<ClusterLinkData> links = this.getAllLinksFromMetadata();
        Object object = this.lock();
        synchronized (object) {
            scala.collection.immutable.Set set = ((TraversableOnce)((TraversableLike)links.filter((Function1 & Serializable & scala.Serializable)cld -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetadataManager.$anonfun$getClusterLinkIdsForPartitionId$1(this, partitionId, cld)))).map((Function1 & Serializable & scala.Serializable)cld -> CoreUtils$.MODULE$.toKafkaUUID(cld.linkId()), Seq$.MODULE$.canBuildFrom())).toSet();
            return set;
        }
    }

    public scala.collection.immutable.Set<Uuid> getClusterLinkIdsWithOwnedLinkCoordinator() {
        return ((TraversableOnce)((TraversableLike)this.getAllLinksFromMetadata().filter((Function1 & Serializable & scala.Serializable)cld -> BoxesRunTime.boxToBoolean((boolean)this.isLinkCoordinator(cld.linkName(), this.isLinkCoordinator$default$2())))).map((Function1 & Serializable & scala.Serializable)cld -> CoreUtils$.MODULE$.toKafkaUUID(cld.linkId()), Seq$.MODULE$.canBuildFrom())).toSet();
    }

    private int linkNameToPartitionId(String linkName) {
        if (!this.initialized()) {
            return -1;
        }
        return Utils.toPositive((int)Utils.murmur2((byte[])linkName.getBytes())) % this.numMetadataPartitions();
    }

    /*
     * WARNING - void declaration
     */
    private java.util.Map<String, String> metadataTopicConfig() {
        void var1_1;
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        props.put(LogConfig$.MODULE$.MinInSyncReplicasProp(), this.brokerConfig().clusterLinkMetadataTopicMinInSyncReplicas().toString());
        return var1_1;
    }

    private void logErrorsOnFailure(String str) {
        this.numRetries_$eq(this.numRetries() + 1L);
        if (this.numRetries() <= 10L) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> str);
            return;
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> str);
    }

    public final void onElection(int partitionId, int leaderEpoch) {
        boolean bl;
        Object object = this.lock();
        synchronized (object) {
            boolean bl2;
            if (this.maybeUpdatePartitionEpoch(partitionId, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)))) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Elected as link coordinator for links with metadata topic partition ").append(partitionId).append(" at").append(" epoch ").append(leaderEpoch).toString());
                bl2 = this.ownedPartitions().add((Object)BoxesRunTime.boxToInteger((int)partitionId));
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        scala.collection.immutable.Set linkIds = bl ? this.getClusterLinkIdsForPartitionId(partitionId) : Predef$.MODULE$.Set().empty();
        this.metadataImageListeners().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.onClusterLinkCoordinatorElection((scala.collection.immutable.Set<Uuid>)linkIds);
            return BoxedUnit.UNIT;
        });
    }

    public final void onResignation(int partitionId, Option<Object> leaderEpoch) {
        boolean bl;
        Object object = this.lock();
        synchronized (object) {
            boolean bl2;
            if (this.maybeUpdatePartitionEpoch(partitionId, leaderEpoch)) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("Resigned as link coordinator for links with metadata topic partition ").append(partitionId).append(" ").append("at epoch ").append(leaderEpoch).toString());
                bl2 = this.ownedPartitions().remove((Object)BoxesRunTime.boxToInteger((int)partitionId));
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        scala.collection.immutable.Set linkIds = bl ? this.getClusterLinkIdsForPartitionId(partitionId) : Predef$.MODULE$.Set().empty();
        this.metadataImageListeners().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.onClusterLinkCoordinatorResignation((scala.collection.immutable.Set<Uuid>)linkIds);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean maybeUpdatePartitionEpoch(int partitionId, Option<Object> leaderEpoch) {
        if (leaderEpoch.isEmpty()) {
            return true;
        }
        int newLeaderEpoch = BoxesRunTime.unboxToInt((Object)leaderEpoch.get());
        boolean bl = false;
        Option option = this.partitionToEpochMap().get((Object)BoxesRunTime.boxToInteger((int)partitionId));
        if (option instanceof Some) {
            bl = true;
            int epoch = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            if (newLeaderEpoch > epoch) {
                this.partitionToEpochMap().put((Object)BoxesRunTime.boxToInteger((int)partitionId), (Object)BoxesRunTime.boxToInteger((int)newLeaderEpoch));
                return true;
            }
        }
        if (None$.MODULE$.equals(option)) {
            this.partitionToEpochMap().put((Object)BoxesRunTime.boxToInteger((int)partitionId), (Object)BoxesRunTime.boxToInteger((int)newLeaderEpoch));
            return true;
        }
        if (!bl) throw new MatchError((Object)option);
        return false;
    }

    public boolean isLinkCoordinator(String linkName, boolean useControllerIfAvailable) {
        Object object = this.lock();
        synchronized (object) {
            boolean bl;
            block4: {
                if (!this.initialized()) {
                    bl = false;
                    break block4;
                }
                boolean bl2 = this.ownedPartitions().contains((Object)BoxesRunTime.boxToInteger((int)this.linkNameToPartitionId(linkName)));
                return bl2;
            }
            return bl;
        }
    }

    public boolean isLinkCoordinator$default$2() {
        return false;
    }

    public Option<Node> linkCoordinator(String linkName) {
        Object object = this.lock();
        synchronized (object) {
            None$ none$;
            block4: {
                if (!this.initialized()) {
                    none$ = None$.MODULE$;
                    break block4;
                }
                Option<Node> option = this.metadataCache().getPartitionLeaderEndpoint(this.metadataTopic(), this.linkNameToPartitionId(linkName), this.brokerConfig().interBrokerListenerName());
                return option;
            }
            return none$;
        }
    }

    public final void shutdown() {
        Object object = this.lock();
        synchronized (object) {
            this.initialized_$eq(false);
            this.partitionToEpochMap().clear();
            this.ownedPartitions().clear();
            this.numMetadataPartitions_$eq(-1);
            return;
        }
    }

    public final void register(ClusterLinkFactory.LinkMetadataImageListener listener) {
        this.metadataImageListeners_$eq((Buffer<ClusterLinkFactory.LinkMetadataImageListener>)this.metadataImageListeners().$plus$eq((Object)listener));
    }

    public abstract boolean isActiveMirrorTopic(String var1);

    public abstract Option<MirrorTopic> mirrorTopic(String var1);

    public abstract Map<String, ClusterLinkTopicState> clusterLinkTopicState(scala.collection.immutable.Set<String> var1);

    public abstract Map<String, ClusterLinkTopicState> mirrorTopicsForLink(String var1);

    public abstract Map<String, ClusterLinkTopicState> allMirrorTopics(boolean var1);

    public abstract scala.collection.immutable.Set<String> getAllTopicsInCluster();

    public Option<Object> numPartitions(String topic) {
        return this.metadataCache().numPartitions(topic);
    }

    public scala.collection.immutable.Set<TopicPartition> topicPartitions(String topicName) {
        return this.metadataCache().getTopicPartitions(topicName).toSet();
    }

    public boolean hasTopic(String topic) {
        return this.metadataCache().contains(topic);
    }

    public abstract boolean isTopicQueuedUpForDeletion(String var1);

    public abstract void ensureClusterLinkExists(UUID var1);

    public abstract boolean clusterLinkExists(UUID var1);

    public abstract Option<ClusterLinkData> getClusterLinkData(UUID var1);

    public abstract Option<ClusterLinkData> getClusterLinkData(String var1);

    public abstract Properties getClusterLinkConfigProps(UUID var1);

    public abstract ClusterLinkConfig getClusterLinkConfig(UUID var1);

    public abstract Properties getTopicConfig(String var1);

    public abstract void alterClusterLinkConfigZNode(UUID var1, Properties var2);

    public abstract void maybeReencryptClusterLinkConfigs(Function1<Properties, Option<Properties>> var1);

    public abstract void createClusterLinkZNode(ClusterLinkData var1, Properties var2);

    public abstract void setClusterLinkZNode(ClusterLinkData var1);

    public abstract Seq<ClusterLinkData> getAllLinksFromMetadata();

    public abstract void setMirrorTopicState(String var1, Option<ClusterLinkTopicState> var2);

    public abstract CompletableFuture<CreateClusterLinksResponse> createClusterLinks(CreateClusterLinksRequestData var1);

    public abstract void deleteClusterLinkZNode(UUID var1);

    public final boolean isBrokerOnline(int brokerId) {
        return this.metadataCache().hasAliveBroker(brokerId);
    }

    public static final /* synthetic */ boolean $anonfun$getClusterLinkIdsForPartitionId$1(ClusterLinkMetadataManager $this, int partitionId$1, ClusterLinkData cld) {
        return $this.linkNameToPartitionId(cld.linkName()) == partitionId$1;
    }

    public ClusterLinkMetadataManager(KafkaConfig brokerConfig, ClusterLinkScheduler scheduler, MetadataCache metadataCache, Function0<Admin> localAdminFactory) {
        this.brokerConfig = brokerConfig;
        this.scheduler = scheduler;
        this.metadataCache = metadataCache;
        this.localAdminFactory = localAdminFactory;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(37).append("[ClusterLinkMetadataManager-broker-").append(brokerConfig.brokerId()).append("] ").toString());
        this.metadataTopic = "_confluent-link-metadata";
        this.lock = new Object();
        this.ownedPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.partitionToEpochMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.initialized = false;
        this.numRetries = 0L;
        this.metadataImageListeners = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

