/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.server.BlockingSend;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFollowerFetchThrottler;
import kafka.server.link.ClusterLinkLeaderEndPoint;
import kafka.server.link.ClusterLinkLeaderRequestBuilder;
import kafka.server.link.ClusterLinkMetrics;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.runtime.BoxesRunTime;

public final class ClusterLinkLeaderEndPoint$ {
    public static ClusterLinkLeaderEndPoint$ MODULE$;

    static {
        new ClusterLinkLeaderEndPoint$();
    }

    public boolean isReadyForFetchForPartition(Partition partition, ClusterLinkMetrics clusterLinkMetrics, Integer linkFetcherFlowControl, boolean updateLagSensor) {
        if (Predef$.MODULE$.Integer2int(linkFetcherFlowControl) >= 0 && partition.leaderLogIfLocal().exists((Function1 & java.io.Serializable & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkLeaderEndPoint$.$anonfun$isReadyForFetchForPartition$1(linkFetcherFlowControl, log)))) {
            if (updateLagSensor) {
                clusterLinkMetrics.destinationLagLinkFetcherThrottleSensor().record();
            }
            return false;
        }
        if (BoxesRunTime.equalsNumObject((Number)linkFetcherFlowControl, (Object)BoxesRunTime.boxToInteger((int)-2))) {
            return !partition.isUnderReplicated();
        }
        return !partition.isUnderMinIsr();
    }

    public ClusterLinkLeaderEndPoint apply(LogContext logContext, Time time, BlockingSend blockingSender, KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, ReplicaManager replicaManager, ReplicaQuota quota, ClusterLinkMetrics clusterLinkMetrics) {
        FetchSessionHandler fetchSessionHandler = new FetchSessionHandler(logContext, blockingSender.brokerEndPoint().id());
        ClusterLinkLeaderRequestBuilder requestBuilder = new ClusterLinkLeaderRequestBuilder(clusterLinkConfig, time);
        ClusterLinkFollowerFetchThrottler throttler = new ClusterLinkFollowerFetchThrottler();
        return new ClusterLinkLeaderEndPoint(logContext.logPrefix(), blockingSender, fetchSessionHandler, requestBuilder, throttler, brokerConfig, clusterLinkConfig, replicaManager, quota, clusterLinkMetrics);
    }

    public static final /* synthetic */ boolean $anonfun$isReadyForFetchForPartition$1(Integer linkFetcherFlowControl$1, AbstractLog log) {
        return log.logEndOffset() - log.highWatermark() > (long)Predef$.MODULE$.Integer2int(linkFetcherFlowControl$1);
    }

    private ClusterLinkLeaderEndPoint$() {
        MODULE$ = this;
    }
}

