/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import kafka.server.ConfigHelper;
import kafka.server.InternalAdmin;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.metadata.ZkConfigRepository;
import kafka.tier.backupobjectlifecycle.NameAndId;
import kafka.utils.Logging;
import kafka.zk.AdminZkClient;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.DescribeConfigsRequestData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}a\u0001\u0002\u0005\n\u00059A\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tM\u0001\u0011\t\u0011)A\u0005O!A!\u0006\u0001B\u0001B\u0003%1\u0006C\u00039\u0001\u0011\u0005\u0011\bC\u0003?\u0001\u0011\u0005s\bC\u0003^\u0001\u0011\u0005c\fC\u0003c\u0001\u0011\u00053MA\b[W&sG/\u001a:oC2\fE-\\5o\u0015\tQ1\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0019\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\u0010+e\u0001\"\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\u0011a!\u00118z%\u00164\u0007C\u0001\f\u0018\u001b\u0005I\u0011B\u0001\r\n\u00055Ie\u000e^3s]\u0006d\u0017\tZ7j]B\u0011!$H\u0007\u00027)\u0011AdC\u0001\u0006kRLGn]\u0005\u0003=m\u0011q\u0001T8hO&tw-\u0001\u0004dY&,g\u000e\u001e\t\u0003C\u0011j\u0011A\t\u0006\u0003G-\t!A_6\n\u0005\u0015\u0012#!D!e[&t'l[\"mS\u0016tG/A\u0007nKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\t\u0003-!J!!K\u0005\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0003MY\u0017MZ6b\u0007>tg-[4TkB\u0004H.[3s!\ra3'N\u0007\u0002[)\u0011afL\u0001\tMVt7\r^5p]*\u0011\u0001'M\u0001\u0005kRLGNC\u00013\u0003\u0011Q\u0017M^1\n\u0005Qj#\u0001C*vaBd\u0017.\u001a:\u0011\u0005Y1\u0014BA\u001c\n\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\rqJg.\u001b;?)\u0011Q4\bP\u001f\u0011\u0005Y\u0001\u0001\"B\u0010\u0005\u0001\u0004\u0001\u0003\"\u0002\u0014\u0005\u0001\u00049\u0003\"\u0002\u0016\u0005\u0001\u0004Y\u0013aC3ogV\u0014X\rV8qS\u000e$R\u0001Q\"Q%^\u0003\"\u0001E!\n\u0005\t\u000b\"aA%oi\")A)\u0002a\u0001\u000b\u0006IAo\u001c9jG:\u000bW.\u001a\t\u0003\r6s!aR&\u0011\u0005!\u000bR\"A%\u000b\u0005)k\u0011A\u0002\u001fs_>$h(\u0003\u0002M#\u00051\u0001K]3eK\u001aL!AT(\u0003\rM#(/\u001b8h\u0015\ta\u0015\u0003C\u0003R\u000b\u0001\u0007\u0001)A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\u0005\u0006'\u0016\u0001\r\u0001V\u0001\u0012e\u0016\u0004H.[2bi&|gNR1di>\u0014\bC\u0001\tV\u0013\t1\u0016CA\u0003TQ>\u0014H\u000fC\u0003Y\u000b\u0001\u0007\u0011,A\u0006u_BL7mQ8oM&<\u0007C\u0001.\\\u001b\u0005y\u0013B\u0001/0\u0005)\u0001&o\u001c9feRLWm]\u0001\u000eY&\u001cH/\u00117m)>\u0004\u0018nY:\u0015\u0003}\u00032A\u00171F\u0013\t\twFA\u0002TKR\f1\u0003^8qS\u000e\u001cuN\u001c4jOV\u0014\u0018\r^5p]N$R\u0001ZA\n\u00037\u0001BAW3h_&\u0011am\f\u0002\u0004\u001b\u0006\u0004\bC\u00015n\u001b\u0005I'B\u00016l\u0003U\u0011\u0017mY6va>\u0014'.Z2uY&4WmY=dY\u0016T!\u0001\\\u0006\u0002\tQLWM]\u0005\u0003]&\u0014\u0011BT1nK\u0006sG-\u00133\u0011\u0007A,\bP\u0004\u0002rg:\u0011\u0001J]\u0005\u0002%%\u0011A/E\u0001\ba\u0006\u001c7.Y4f\u0013\t1xO\u0001\u0003MSN$(B\u0001;\u0012!\rI\u0018Q\u0002\b\u0004u\u0006%Q\"A>\u000b\u0005ql\u0018aB7fgN\fw-\u001a\u0006\u0003}~\faaY8n[>t'b\u0001\u0007\u0002\u0002)!\u00111AA\u0003\u0003\u0019\t\u0007/Y2iK*\u0011\u0011qA\u0001\u0004_J<\u0017bAA\u0006w\u0006YB)Z:de&\u0014WmQ8oM&<7OU3ta>t7/\u001a#bi\u0006LA!a\u0004\u0002\u0012\t)B)Z:de&\u0014WmQ8oM&<7OU3tk2$(bAA\u0006w\"9\u0011QC\u0004A\u0002\u0005]\u0011A\u0002;pa&\u001c7\u000f\u0005\u0003[\u00033)\u0015B\u0001<0\u0011\u001d\tib\u0002a\u0001\u0003/\t!bY8oM&<7*Z=t\u0001")
public final class ZkInternalAdmin
implements InternalAdmin,
Logging {
    private final AdminZkClient client;
    private final MetadataCache metadataCache;
    private final Supplier<KafkaConfig> kafkaConfigSupplier;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public int ensureTopic(String topicName, int numPartitions, short replicationFactor, Properties topicConfig) {
        int n;
        try {
            if (!this.client.topicExists(topicName)) {
                this.client.createTopic(topicName, numPartitions, replicationFactor, topicConfig, this.client.createTopic$default$5(), this.client.createTopic$default$6(), this.client.createTopic$default$7(), this.client.createTopic$default$8());
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(this.msgWithLogIdent(ZkInternalAdmin.$anonfun$ensureTopic$4(topicName, numPartitions)));
                }
                return numPartitions;
            }
            n = this.lookUpNumPartitions$1(topicName, numPartitions);
        }
        catch (TopicExistsException topicExistsException) {
            n = this.lookUpNumPartitions$1(topicName, numPartitions);
        }
        return n;
    }

    @Override
    public Set<String> listAllTopics() {
        return this.metadataCache.topicNamesToIds().keySet();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<NameAndId, List<DescribeConfigsResponseData.DescribeConfigsResult>> topicConfigurations(java.util.List<String> topics, java.util.List<String> configKeys) {
        void var3_3;
        HashMap topicToConfigs = new HashMap();
        ZkConfigRepository configRepository = new ZkConfigRepository(this.client);
        ConfigHelper configHelper = new ConfigHelper(this.metadataCache, this.kafkaConfigSupplier.get(), configRepository, (Option<AlterConfigPolicy>)None$.MODULE$, null);
        topics.stream().forEach(topic -> {
            Uuid tpId = $this.metadataCache.getTopicId((String)topic);
            .colon.colon configResources = new .colon.colon((Object)new DescribeConfigsRequestData.DescribeConfigsResource().setResourceName(topic).setResourceType(ConfigResource.Type.TOPIC.id()).setConfigurationKeys(configKeys), (List)Nil$.MODULE$);
            List<DescribeConfigsResponseData.DescribeConfigsResult> configResults = configHelper.describeConfigs((List<DescribeConfigsRequestData.DescribeConfigsResource>)configResources, false, null, false);
            if (tpId.equals((Object)$this.metadataCache.getTopicId((String)topic))) {
                topicToConfigs.put(new NameAndId((String)topic, tpId), configResults);
                return;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(this.msgWithLogIdent(ZkInternalAdmin.$anonfun$topicConfigurations$2(topic)));
                return;
            }
        });
        return var3_3;
    }

    public static final /* synthetic */ String $anonfun$ensureTopic$2(String topicName$1, int foundNumPartitions$1, int numPartitions$1) {
        return new StringBuilder(98).append("Topic ").append(topicName$1).append(" already exists. Mismatch between existing partition count ").append(foundNumPartitions$1).append(" ").append("and configured partition count ").append(numPartitions$1).append(".").toString();
    }

    public static final /* synthetic */ String $anonfun$ensureTopic$3(String topicName$1, int foundNumPartitions$1) {
        return new StringBuilder(30).append("Topic ").append(topicName$1).append(" exists with ").append(foundNumPartitions$1).append(" partitions").toString();
    }

    /*
     * WARNING - void declaration
     */
    private final int lookUpNumPartitions$1(String topicName$1, int numPartitions$1) {
        void var3_3;
        int foundNumPartitions = BoxesRunTime.unboxToInt((Object)this.client.numPartitions(topicName$1).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new UnknownTopicOrPartitionException(new StringBuilder(22).append(topicName$1).append(" deleted unexpectedly.").toString());
        }));
        if (foundNumPartitions != numPartitions$1) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(ZkInternalAdmin.$anonfun$ensureTopic$2(topicName$1, foundNumPartitions, numPartitions$1)));
            }
        } else if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(this.msgWithLogIdent(ZkInternalAdmin.$anonfun$ensureTopic$3(topicName$1, foundNumPartitions)));
        }
        return (int)var3_3;
    }

    public static final /* synthetic */ String $anonfun$ensureTopic$4(String topicName$1, int numPartitions$1) {
        return new StringBuilder(31).append("Created topic ").append(topicName$1).append(" with ").append(numPartitions$1).append(" partitions").toString();
    }

    public static final /* synthetic */ String $anonfun$topicConfigurations$2(String topic$1) {
        return new StringBuilder(64).append("Ignoring topic ").append(topic$1).append(". It has been deleted or recreated with same name").toString();
    }

    public ZkInternalAdmin(AdminZkClient client, MetadataCache metadataCache, Supplier<KafkaConfig> kafkaConfigSupplier) {
        this.client = client;
        this.metadataCache = metadataCache;
        this.kafkaConfigSupplier = kafkaConfigSupplier;
        Logging.$init$(this);
    }
}

