/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kafka.api.LeaderAndIsr;
import kafka.server.AlterPartitionManager;
import kafka.server.IsrChangePropagationConfig;
import kafka.server.ZkAlterPartitionManager$;
import kafka.utils.Logging;
import kafka.utils.ReplicationUtils$;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidUpdateVersionException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.mutable.HashSet;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\rt!B\f\u0019\u0011\u0003ib!B\u0010\u0019\u0011\u0003\u0001\u0003\"B\u0014\u0002\t\u0003A\u0003bB\u0015\u0002\u0001\u0004%\tA\u000b\u0005\b]\u0005\u0001\r\u0011\"\u00010\u0011\u0019)\u0014\u0001)Q\u0005W\u0019!q\u0004\u0007\u0001;\u0011!!eA!A!\u0002\u0013)\u0005\u0002\u0003%\u0007\u0005\u0003\u0005\u000b\u0011B%\t\u0011U3!\u0011!Q\u0001\nYCQa\n\u0004\u0005\u0002qCq!\u0019\u0004C\u0002\u0013%!\u0006\u0003\u0004c\r\u0001\u0006Ia\u000b\u0005\tG\u001a\u0011\r\u0011\"\u0001\u0019I\"1\u0011O\u0002Q\u0001\n\u0015DqA\u001d\u0004C\u0002\u0013%1\u000fC\u0004\u0002\u0002\u0019\u0001\u000b\u0011\u0002;\t\u0011\u0005\raA1A\u0005\nMDq!!\u0002\u0007A\u0003%A\u000fC\u0004\u0002\b\u0019!\t%!\u0003\t\u000f\u0005-a\u0001\"\u0011\u0002\u000e!A\u0011Q\t\u0004\u0005\u0002a\t9\u0005\u0003\u0006\u0002L\u0019\t\n\u0011\"\u0001\u0019\u0003\u001b\nqCW6BYR,'\u000fU1si&$\u0018n\u001c8NC:\fw-\u001a:\u000b\u0005eQ\u0012AB:feZ,'OC\u0001\u001c\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"AH\u0001\u000e\u0003a\u0011qCW6BYR,'\u000fU1si&$\u0018n\u001c8NC:\fw-\u001a:\u0014\u0005\u0005\t\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002;\u0005YB)\u001a4bk2$\u0018j\u001d:Qe>\u0004\u0018mZ1uS>t7i\u001c8gS\u001e,\u0012a\u000b\t\u0003=1J!!\f\r\u00035%\u001b(o\u00115b]\u001e,\u0007K]8qC\u001e\fG/[8o\u0007>tg-[4\u0002?\u0011+g-Y;mi&\u001b(\u000f\u0015:pa\u0006<\u0017\r^5p]\u000e{gNZ5h?\u0012*\u0017\u000f\u0006\u00021gA\u0011!%M\u0005\u0003e\r\u0012A!\u00168ji\"9A\u0007BA\u0001\u0002\u0004Y\u0013a\u0001=%c\u0005aB)\u001a4bk2$\u0018j\u001d:Qe>\u0004\u0018mZ1uS>t7i\u001c8gS\u001e\u0004\u0003FA\u00038!\t\u0011\u0003(\u0003\u0002:G\tAao\u001c7bi&dWm\u0005\u0003\u0007Cmr\u0004C\u0001\u0010=\u0013\ti\u0004DA\u000bBYR,'\u000fU1si&$\u0018n\u001c8NC:\fw-\u001a:\u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005S\u0012!B;uS2\u001c\u0018BA\"A\u0005\u001daunZ4j]\u001e\f\u0011b]2iK\u0012,H.\u001a:\u0011\u0005}2\u0015BA$A\u0005%\u00196\r[3ek2,'/\u0001\u0003uS6,\u0007C\u0001&T\u001b\u0005Y%BA!M\u0015\tie*\u0001\u0004d_6lwN\u001c\u0006\u00037=S!\u0001U)\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0016aA8sO&\u0011Ak\u0013\u0002\u0005)&lW-\u0001\u0005{W\u000ec\u0017.\u001a8u!\t9&,D\u0001Y\u0015\tI&$\u0001\u0002{W&\u00111\f\u0017\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\u0015\tusv\f\u0019\t\u0003=\u0019AQ\u0001\u0012\u0006A\u0002\u0015CQ\u0001\u0013\u0006A\u0002%CQ!\u0016\u0006A\u0002Y\u000b1$[:s\u0007\"\fgnZ3O_RLg-[2bi&|gnQ8oM&<\u0017\u0001H5te\u000eC\u0017M\\4f\u001d>$\u0018NZ5dCRLwN\\\"p]\u001aLw\rI\u0001\rSN\u00148\t[1oO\u0016\u001cV\r^\u000b\u0002KB\u0019am[7\u000e\u0003\u001dT!\u0001[5\u0002\u000f5,H/\u00192mK*\u0011!nI\u0001\u000bG>dG.Z2uS>t\u0017B\u00017h\u0005\r\u0019V\r\u001e\t\u0003]>l\u0011\u0001T\u0005\u0003a2\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\u0007jgJ\u001c\u0005.\u00198hKN+G\u000fI\u0001\u0010Y\u0006\u001cH/S:s\u0007\"\fgnZ3NgV\tA\u000f\u0005\u0002v}6\taO\u0003\u0002xq\u00061\u0011\r^8nS\u000eT!!\u001f>\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002|y\u0006!Q\u000f^5m\u0015\u0005i\u0018\u0001\u00026bm\u0006L!a <\u0003\u0015\u0005#x.\\5d\u0019>tw-\u0001\tmCN$\u0018j\u001d:DQ\u0006tw-Z'tA\u0005!B.Y:u\u0013N\u0014\bK]8qC\u001e\fG/[8o\u001bN\fQ\u0003\\1ti&\u001b(\u000f\u0015:pa\u0006<\u0017\r^5p]6\u001b\b%A\u0003ti\u0006\u0014H\u000fF\u00011\u0003\u0019\u0019XOY7jiRQ\u0011qBA\u0012\u0003[\t\t$a\u000f\u0011\r\u0005E\u00111CA\f\u001b\u0005A\u0018bAA\u000bq\n\t2i\\7qY\u0016$\u0018M\u00197f\rV$XO]3\u0011\t\u0005e\u0011qD\u0007\u0003\u00037Q1!!\b\u001b\u0003\r\t\u0007/[\u0005\u0005\u0003C\tYB\u0001\u0007MK\u0006$WM]!oI&\u001b(\u000fC\u0004\u0002&Q\u0001\r!a\n\u0002!Q|\u0007/[2JIB\u000b'\u000f^5uS>t\u0007c\u00018\u0002*%\u0019\u00111\u0006'\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0007bBA\u0018)\u0001\u0007\u0011qC\u0001\rY\u0016\fG-\u001a:B]\u0012L5O\u001d\u0005\b\u0003g!\u0002\u0019AA\u001b\u0003=\u0019wN\u001c;s_2dWM]#q_\u000eD\u0007c\u0001\u0012\u00028%\u0019\u0011\u0011H\u0012\u0003\u0007%sG\u000fC\u0004\u0002>Q\u0001\r!a\u0010\u0002)A\u0014x\u000e]1hCR,\u0017*\\7fI&\fG/\u001a7z!\r\u0011\u0013\u0011I\u0005\u0004\u0003\u0007\u001a#a\u0002\"p_2,\u0017M\\\u0001\u0019[\u0006L(-\u001a)s_B\fw-\u0019;f\u0013N\u00148\t[1oO\u0016\u001cHc\u0001\u0019\u0002J!I\u0011QH\u000b\u0011\u0002\u0003\u0007\u0011qH\u0001#[\u0006L(-\u001a)s_B\fw-\u0019;f\u0013N\u00148\t[1oO\u0016\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005=#\u0006BA \u0003#Z#!a\u0015\u0011\t\u0005U\u0013qL\u0007\u0003\u0003/RA!!\u0017\u0002\\\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003;\u001a\u0013AC1o]>$\u0018\r^5p]&!\u0011\u0011MA,\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class ZkAlterPartitionManager
implements AlterPartitionManager,
Logging {
    private final Scheduler scheduler;
    private final Time time;
    private final KafkaZkClient zkClient;
    private final IsrChangePropagationConfig isrChangeNotificationConfig;
    private final scala.collection.mutable.Set<TopicPartition> isrChangeSet;
    private final AtomicLong lastIsrChangeMs;
    private final AtomicLong lastIsrPropagationMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void DefaultIsrPropagationConfig_$eq(IsrChangePropagationConfig isrChangePropagationConfig) {
        ZkAlterPartitionManager$.MODULE$.DefaultIsrPropagationConfig_$eq(isrChangePropagationConfig);
    }

    public static IsrChangePropagationConfig DefaultIsrPropagationConfig() {
        return ZkAlterPartitionManager$.MODULE$.DefaultIsrPropagationConfig();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public void shutdown() {
        AlterPartitionManager.shutdown$(this);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private IsrChangePropagationConfig isrChangeNotificationConfig() {
        return this.isrChangeNotificationConfig;
    }

    public scala.collection.mutable.Set<TopicPartition> isrChangeSet() {
        return this.isrChangeSet;
    }

    private AtomicLong lastIsrChangeMs() {
        return this.lastIsrChangeMs;
    }

    private AtomicLong lastIsrPropagationMs() {
        return this.lastIsrPropagationMs;
    }

    @Override
    public void start() {
        String x$1 = "isr-change-propagation";
        JFunction0.mcV.sp & Serializable & scala.Serializable x$2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.maybePropagateIsrChanges(false);
        long x$3 = this.isrChangeNotificationConfig().checkIntervalMs();
        TimeUnit x$4 = TimeUnit.MILLISECONDS;
        long x$5 = this.scheduler.schedule$default$3();
        this.scheduler.schedule(x$1, (Function0<BoxedUnit>)x$2, x$5, x$3, x$4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompletableFuture<LeaderAndIsr> submit(TopicIdPartition topicIdPartition, LeaderAndIsr leaderAndIsr, int controllerEpoch, boolean propagateImmediately) {
        void var6_6;
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Writing new ISR ").append(leaderAndIsr.isr()).append(" to ZooKeeper with version ").append(leaderAndIsr.partitionEpoch()).append(" for partition ").append(topicIdPartition).toString());
        Tuple2<Object, Object> tuple2 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkClient, topicIdPartition.topicPartition(), leaderAndIsr, controllerEpoch);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean updateSucceeded = tuple2._1$mcZ$sp();
        int newVersion = tuple2._2$mcI$sp();
        CompletableFuture<LeaderAndIsr> future = new CompletableFuture<LeaderAndIsr>();
        if (var6_6 != false) {
            void var7_7;
            scala.collection.mutable.Set<TopicPartition> set = this.isrChangeSet();
            synchronized (set) {
                this.isrChangeSet().$plus$eq((Object)topicIdPartition.topicPartition());
                this.lastIsrChangeMs().set(this.time.milliseconds());
                if (propagateImmediately) {
                    this.maybePropagateIsrChanges(true);
                }
            }
            future.complete(leaderAndIsr.withPartitionEpoch((int)var7_7));
        } else {
            future.completeExceptionally((Throwable)new InvalidUpdateVersionException(new StringBuilder(86).append("ISR update ").append(leaderAndIsr).append(" for partition ").append(topicIdPartition).append(" with controller epoch ").append(controllerEpoch).append(" ").append("failed with an invalid version error").toString()));
        }
        return future;
    }

    public void maybePropagateIsrChanges(boolean propagateImmediately) {
        long now = this.time.milliseconds();
        scala.collection.mutable.Set<TopicPartition> set = this.isrChangeSet();
        synchronized (set) {
            if (this.isrChangeSet().nonEmpty() && (propagateImmediately || this.lastIsrChangeMs().get() + this.isrChangeNotificationConfig().lingerMs() < now || this.lastIsrPropagationMs().get() + this.isrChangeNotificationConfig().maxDelayMs() < now)) {
                this.zkClient.propagateIsrChanges((Set<TopicPartition>)this.isrChangeSet());
                this.isrChangeSet().clear();
                this.lastIsrPropagationMs().set(now);
            }
            return;
        }
    }

    public boolean maybePropagateIsrChanges$default$1() {
        return false;
    }

    public ZkAlterPartitionManager(Scheduler scheduler, Time time, KafkaZkClient zkClient) {
        this.scheduler = scheduler;
        this.time = time;
        this.zkClient = zkClient;
        AlterPartitionManager.$init$(this);
        Logging.$init$(this);
        this.isrChangeNotificationConfig = ZkAlterPartitionManager$.MODULE$.DefaultIsrPropagationConfig();
        this.isrChangeSet = new HashSet();
        this.lastIsrChangeMs = new AtomicLong(time.milliseconds());
        this.lastIsrPropagationMs = new AtomicLong(time.milliseconds());
    }
}

