/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.Future;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LeaderOffsetIncremented$;
import kafka.log.LogAppendInfo;
import kafka.log.TierLogSegment;
import kafka.server.AbstractFetcherThread;
import kafka.server.FailedPartitions;
import kafka.server.KafkaConfig;
import kafka.server.LeaderEndPoint;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.ReplicaFetcherThread$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.TierState;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t=e\u0001B\u0016-\u0001EB\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u000b\"I\u0011\n\u0001B\u0001B\u0003%!*\u0014\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u001f\"A!\u000b\u0001B\u0001B\u0003%1\u000b\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003X\u0011!Q\u0006A!A!\u0002\u0013Y\u0006\u0002\u00030\u0001\u0005\u0003\u0005\u000b\u0011B0\t\u0011=\u0004!\u0011!Q\u0001\nAD\u0001B\u001e\u0001\u0003\u0002\u0003\u0006Ia\u001e\u0005\tw\u0002\u0011\t\u0011)A\u0005o\"AA\u0010\u0001B\u0001B\u0003%Q\u0010C\u0004\u0002\u000e\u0001!\t!a\u0004\t\u0013\u0005-\u0002A1A\u0005\n\u00055\u0002bBA\u0018\u0001\u0001\u0006I!\u0012\u0005\n\u0003c\u0001!\u0019!C\u0005\u0003gAq!!\u000e\u0001A\u0003%!\rC\u0005\u00028\u0001\u0011\r\u0011\"\u0015\u0002:!A\u0011\u0011\t\u0001!\u0002\u0013\tY\u0004C\u0004\u0002D\u0001!\t&!\u0012\t\u000f\u0005U\u0003\u0001\"\u0015\u0002X!9\u00111\f\u0001\u0005R\u0005u\u0003bBA1\u0001\u0011E\u00131\r\u0005\b\u0003g\u0002A\u0011IA;\u0011\u001d\t9\b\u0001C!\u0003sBq!!!\u0001\t\u0003\n\u0019\tC\u0004\u0002&\u0002!\t\"a*\t\u000f\u0005%\u0007\u0001\"\u0011\u0002L\"9\u0011Q\u001c\u0001\u0005B\u0005}\u0007b\u0002B\u0001\u0001\u0011\u0005#1\u0001\u0005\b\u0005\u001b\u0001A\u0011\u0003B\b\u0011\u001d\u0011)\u0003\u0001C\u0001\u0005OAqAa\u000f\u0001\t\u0003\u0012i\u0004C\u0004\u0003N\u0001!\tFa\u0014\t\u001b\t]\u0003\u0001%A\u0002\u0002\u0003%IA!\u0017N\u000f%\u0011Y\u0006LA\u0001\u0012\u0003\u0011iF\u0002\u0005,Y\u0005\u0005\t\u0012\u0001B0\u0011\u001d\ti!\nC\u0001\u0005OB\u0011B!\u001b&#\u0003%\tAa\u001b\t\u0013\t\u0005U%%A\u0005\u0002\t\r\u0005\"\u0003BDKE\u0005I\u0011\u0001BE\u0011%\u0011i)JI\u0001\n\u0003\u0011II\u0001\u000bSKBd\u0017nY1GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\u0006\u0003[9\naa]3sm\u0016\u0014(\"A\u0018\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\r\t\u0003gQj\u0011\u0001L\u0005\u0003k1\u0012Q#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG-\u0001\u0003oC6,\u0007C\u0001\u001dB\u001d\tIt\b\u0005\u0002;{5\t1H\u0003\u0002=a\u00051AH]8pizR\u0011AP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0001v\na\u0001\u0015:fI\u00164\u0017B\u0001\"D\u0005\u0019\u0019FO]5oO*\u0011\u0001)P\u0001\nM\u0016$8\r[3s\u0013\u0012\u0004\"AR$\u000e\u0003uJ!\u0001S\u001f\u0003\u0007%sG/\u0001\u0004mK\u0006$WM\u001d\t\u0003g-K!\u0001\u0014\u0017\u0003\u001d1+\u0017\rZ3s\u000b:$\u0007k\\5oi&\u0011\u0011\nN\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\t\u0003gAK!!\u0015\u0017\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0011M\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N\u0004\"a\r+\n\u0005Uc#\u0001\u0005$bS2,G\rU1si&$\u0018n\u001c8t\u0003)\u0011X\r\u001d7jG\u0006luM\u001d\t\u0003gaK!!\u0017\u0017\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006)\u0011/^8uCB\u00111\u0007X\u0005\u0003;2\u0012ABU3qY&\u001c\u0017-U;pi\u0006\fQ\u0002\\8h\u0007>tG/\u001a=u\u001fB$\bc\u0001$aE&\u0011\u0011-\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\rlW\"\u00013\u000b\u0005\u00154\u0017!B;uS2\u001c(BA4i\u0003\u0019\u0019w.\\7p]*\u0011q&\u001b\u0006\u0003U.\fa!\u00199bG\",'\"\u00017\u0002\u0007=\u0014x-\u0003\u0002oI\nQAj\\4D_:$X\r\u001f;\u0002\u001f\u0015DHO]1NKR\u0014\u0018n\u0019+bON\u0004B!\u001d;8o5\t!O\u0003\u0002t{\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005U\u0014(aA'ba\u0006\tb-\u001a;dQ\n\u000b7m[(gM6\u001bx\n\u001d;\u0011\u0007\u0019\u0003\u0007\u0010\u0005\u0002Gs&\u0011!0\u0010\u0002\u0005\u0019>tw-\u0001\u000bgKR\u001c\u0007NQ1dW>3g-T:NCb|\u0005\u000f^\u0001\u0018[\u0016$\u0018\rZ1uCZ+'o]5p]N+\b\u000f\u001d7jKJ\u0004BA\u0012@\u0002\u0002%\u0011q0\u0010\u0002\n\rVt7\r^5p]B\u0002B!a\u0001\u0002\n5\u0011\u0011Q\u0001\u0006\u0004O\u0006\u001d!BA\u0017i\u0013\u0011\tY!!\u0002\u0003\u001f5+G/\u00193bi\u00064VM]:j_:\fa\u0001P5oSRtDCGA\t\u0003'\t)\"a\u0006\u0002\u001a\u0005m\u0011QDA\u0010\u0003C\t\u0019#!\n\u0002(\u0005%\u0002CA\u001a\u0001\u0011\u00151T\u00021\u00018\u0011\u0015!U\u00021\u0001F\u0011\u0015IU\u00021\u0001K\u0011\u0015qU\u00021\u0001P\u0011\u0015\u0011V\u00021\u0001T\u0011\u00151V\u00021\u0001X\u0011\u0015QV\u00021\u0001\\\u0011\u001dqV\u0002%AA\u0002}Cqa\\\u0007\u0011\u0002\u0003\u0007\u0001\u000fC\u0004w\u001bA\u0005\t\u0019A<\t\u000fml\u0001\u0013!a\u0001o\")A0\u0004a\u0001{\u0006I!/\u001a9mS\u000e\f\u0017\nZ\u000b\u0002\u000b\u0006Q!/\u001a9mS\u000e\f\u0017\n\u001a\u0011\u0002\u00151|wmQ8oi\u0016DH/F\u0001c\u0003-awnZ\"p]R,\u0007\u0010\u001e\u0011\u0002?%\u001cxJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"\u001cV\u000f\u001d9peR,G-\u0006\u0002\u0002<A\u0019a)!\u0010\n\u0007\u0005}RHA\u0004C_>dW-\u00198\u0002A%\u001cxJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"\u001cV\u000f\u001d9peR,G\rI\u0001\fY\u0006$Xm\u001d;Fa>\u001c\u0007\u000e\u0006\u0003\u0002H\u0005%\u0003c\u0001$a\u000b\"9\u00111\n\u000bA\u0002\u00055\u0013A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0005\u0003\u001f\n\t&D\u0001g\u0013\r\t\u0019F\u001a\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u00039awnZ*uCJ$xJ\u001a4tKR$2\u0001_A-\u0011\u001d\tY%\u0006a\u0001\u0003\u001b\nA\u0002\\8h\u000b:$wJ\u001a4tKR$2\u0001_A0\u0011\u001d\tYE\u0006a\u0001\u0003\u001b\n\u0011#\u001a8e\u001f\u001a47/\u001a;G_J,\u0005o\\2i)\u0019\t)'!\u001c\u0002pA!a\tYA4!\r\u0019\u0014\u0011N\u0005\u0004\u0003Wb#AD(gMN,G/\u00118e\u000bB|7\r\u001b\u0005\b\u0003\u0017:\u0002\u0019AA'\u0011\u0019\t\th\u0006a\u0001\u000b\u0006)Q\r]8dQ\u0006\u0001\u0012N\\5uS\u0006$Xm\u00155vi\u0012|wO\u001c\u000b\u0003\u0003w\tQ\"Y<bSR\u001c\u0006.\u001e;e_^tGCAA>!\r1\u0015QP\u0005\u0004\u0003\u007fj$\u0001B+oSR\fA\u0003\u001d:pG\u0016\u001c8\u000fU1si&$\u0018n\u001c8ECR\fG\u0003CAC\u0003'\u000b)*!'\u0011\t\u0019\u0003\u0017q\u0011\t\u0005\u0003\u0013\u000by)\u0004\u0002\u0002\f*\u0019\u0011Q\u0012\u0018\u0002\u00071|w-\u0003\u0003\u0002\u0012\u0006-%!\u0004'pO\u0006\u0003\b/\u001a8e\u0013:4w\u000eC\u0004\u0002Li\u0001\r!!\u0014\t\r\u0005]%\u00041\u0001y\u0003-1W\r^2i\u001f\u001a47/\u001a;\t\u000f\u0005m%\u00041\u0001\u0002\u001e\u0006i\u0001/\u0019:uSRLwN\u001c#bi\u0006\u0004B!a(\u0002\"6\t\u0001!C\u0002\u0002$R\u0012\u0011BR3uG\"$\u0015\r^1\u0002CU\u0004H-\u0019;f\u0011&<\u0007nV1uKJl\u0017M]6B]\u0012\u001cF/\u0019:u\u001f\u001a47/\u001a;\u0015\u0013a\fI+!/\u0002B\u0006\u0015\u0007bBAV7\u0001\u0007\u0011QV\u0001\na\u0006\u0014H/\u001b;j_:\u0004B!a,\u000266\u0011\u0011\u0011\u0017\u0006\u0004\u0003gs\u0013aB2mkN$XM]\u0005\u0005\u0003o\u000b\tLA\u0005QCJ$\u0018\u000e^5p]\"9\u0011QR\u000eA\u0002\u0005m\u0006\u0003BAE\u0003{KA!a0\u0002\f\nY\u0011IY:ue\u0006\u001cG\u000fT8h\u0011\u0019\t\u0019m\u0007a\u0001q\u0006\u0019B.Z1eKJD\u0015n\u001a5XCR,'/\\1sW\"1\u0011qY\u000eA\u0002]\fA\u0003\\3bI\u0016\u0014Hj\\4Ti\u0006\u0014Ho\u00144gg\u0016$\u0018AE8o%\u0016\u001cHo\u001c:f)&,'o\u0015;bi\u0016$\u0002\"a\u001f\u0002N\u0006=\u00171\u001b\u0005\b\u0003\u0017b\u0002\u0019AA'\u0011\u0019\t\t\u000e\ba\u0001q\u0006)\u0002O]8q_N,G\rT8dC2dunZ*uCJ$\bbBAk9\u0001\u0007\u0011q[\u0001\ni&,'o\u0015;bi\u0016\u00042aMAm\u0013\r\tY\u000e\f\u0002\n)&,'o\u0015;bi\u0016\faBZ3uG\"$\u0016.\u001a:Ti\u0006$X\r\u0006\u0004\u0002b\u0006U\u0018q\u001f\t\u0007\u0003G\f\t0a6\u000e\u0005\u0005\u0015(\u0002BAt\u0003S\f!bY8oGV\u0014(/\u001a8u\u0015\u0011\tY/!<\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003_\fAA[1wC&!\u00111_As\u0005\u00191U\u000f^;sK\"9\u00111J\u000fA\u0002\u00055\u0003bBA};\u0001\u0007\u00111`\u0001\fi&,'oU3h[\u0016tG\u000f\u0005\u0003\u0002\n\u0006u\u0018\u0002BA\u0000\u0003\u0017\u0013a\u0002V5fe2{wmU3h[\u0016tG/A\u0010nCR,'/[1mSj,G+[3s'R\fG/Z+oi&dwJ\u001a4tKR$bA!\u0002\u0003\b\t%\u0001CBAr\u0003c\fY\u0010C\u0004\u0002Ly\u0001\r!!\u0014\t\r\t-a\u00041\u0001y\u00031!\u0018M]4fi>3gm]3u\u0003\u0005j\u0017\r^3sS\u0006d\u0017N_3US\u0016\u00148\u000b^1uKVsG/\u001b7PE*,7\r^%e))\u0011)A!\u0005\u0003\u0014\tU!\u0011\u0005\u0005\b\u0003\u0017z\u0002\u0019AA'\u0011\u0019\u0011Ya\ba\u0001q\"9!qC\u0010A\u0002\te\u0011A\u0004;be\u001e,Go\u00142kK\u000e$\u0018\n\u001a\t\u0005\u00057\u0011i\"\u0004\u0002\u0002j&!!qDAu\u0005\u0011)V+\u0013#\t\r\t\rr\u00041\u0001F\u0003I!\u0018M]4fiJ+7\u000f^8sK\u0016\u0003xn\u00195\u000275\f\u0017PY3XCJt\u0017JZ(wKJ\u001c\u0018N_3e%\u0016\u001cwN\u001d3t)\u0019\tYH!\u000b\u0003:!9!1\u0006\u0011A\u0002\t5\u0012a\u0002:fG>\u0014Hm\u001d\t\u0005\u0005_\u0011)$\u0004\u0002\u00032)\u0019!1\u00074\u0002\rI,7m\u001c:e\u0013\u0011\u00119D!\r\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011\u001d\tY\u0005\ta\u0001\u0003\u001b\n\u0001\u0002\u001e:v]\u000e\fG/\u001a\u000b\u0007\u0003w\u0012yDa\u0011\t\u000f\t\u0005\u0013\u00051\u0001\u0002N\u0005\u0011A\u000f\u001d\u0005\b\u0005\u000b\n\u0003\u0019\u0001B$\u0003UygMZ:fiR\u0013XO\\2bi&|gn\u0015;bi\u0016\u00042a\rB%\u0013\r\u0011Y\u0005\f\u0002\u0016\u001f\u001a47/\u001a;UeVt7-\u0019;j_:\u001cF/\u0019;f\u0003]!(/\u001e8dCR,g)\u001e7ms\u0006sGm\u0015;beR\fE\u000f\u0006\u0004\u0002|\tE#1\u000b\u0005\b\u0003\u0017\u0012\u0003\u0019AA'\u0011\u0019\u0011)F\ta\u0001q\u00061qN\u001a4tKR\fAb];qKJ$C.Z1eKJ,\u0012AS\u0001\u0015%\u0016\u0004H.[2b\r\u0016$8\r[3s)\"\u0014X-\u00193\u0011\u0005M*3cA\u0013\u0003bA\u0019aIa\u0019\n\u0007\t\u0015TH\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005;\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012BTC\u0001B7U\ry&qN\u0016\u0003\u0005c\u0002BAa\u001d\u0003~5\u0011!Q\u000f\u0006\u0005\u0005o\u0012I(A\u0005v]\u000eDWmY6fI*\u0019!1P\u001f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0000\tU$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIe*\"A!\"+\u0007A\u0014y'\u0001\u000f%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0019\u0016\u0005\t-%fA<\u0003p\u0005aB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE\n\u0004")
public class ReplicaFetcherThread
extends AbstractFetcherThread {
    private final int fetcherId;
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaMgr;
    private final ReplicaQuota quota;
    private final Function0<MetadataVersion> metadataVersionSupplier;
    private final int replicaId;
    private final LogContext logContext;
    private final boolean isOffsetForLeaderEpochSupported;

    public static Option<Object> $lessinit$greater$default$11() {
        return ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$11();
    }

    public static Option<Object> $lessinit$greater$default$10() {
        return ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$10();
    }

    public static Map<String, String> $lessinit$greater$default$9() {
        return ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$9();
    }

    public static Option<LogContext> $lessinit$greater$default$8() {
        return ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$8();
    }

    private /* synthetic */ LeaderEndPoint super$leader() {
        return super.leader();
    }

    private int replicaId() {
        return this.replicaId;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.localLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean initiateShutdown() {
        void var1_1;
        boolean justShutdown = super.initiateShutdown();
        if (justShutdown) {
            try {
                super.leader().initiateClose();
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(96).append("Failed to initiate shutdown of leader endpoint ").append(this.super$leader()).append(" after initiating replica fetcher thread shutdown").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            }
        }
        return (boolean)var1_1;
    }

    @Override
    public void awaitShutdown() {
        super.awaitShutdown();
        try {
            super.leader().close();
            return;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Failed to close leader endpoint ").append(this.super$leader()).append(" after shutting down replica fetcher thread").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            return;
        }
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
        boolean logTrace = this.isTraceEnabled();
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        AbstractLog log = partition.localLogOrException();
        MemoryRecords records = this.toMemoryRecords(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData));
        this.maybeWarnIfOversizedRecords(records, topicPartition);
        if (fetchOffset != log.logEndOffset()) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Offset mismatch for partition %s: fetched offset = %d, log end offset = %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)log.logEndOffset())})));
        }
        if (logTrace) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Follower has replica log end offset %d for partition %s. Received %d messages and leader hw %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)log.logEndOffset()), topicPartition, BoxesRunTime.boxToInteger((int)records.sizeInBytes()), BoxesRunTime.boxToLong((long)partitionData.highWatermark())})));
        }
        Option<LogAppendInfo> logAppendInfo = partition.appendRecordsToFollowerOrFutureReplica(records, false);
        if (logTrace) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Follower has replica log end offset %d after appending %d bytes of messages for partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)log.logEndOffset()), BoxesRunTime.boxToInteger((int)records.sizeInBytes()), topicPartition})));
        }
        long leaderLogStartOffset = partitionData.logStartOffset();
        None$ maybeFrozenLogStart = !log.isFrozenLogStartOffsetState() ? new Some((Object)BoxesRunTime.boxToLong((long)leaderLogStartOffset)) : None$.MODULE$;
        long followerHighWatermark = this.updateHighWatermarkAndStartOffset(partition, log, partitionData.highWatermark(), (Option<Object>)maybeFrozenLogStart);
        if (logTrace) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Follower set replica high watermark for partition ").append(topicPartition).append(" to ").append(followerHighWatermark).toString());
        }
        if (this.quota.isThrottled(topicPartition)) {
            this.quota.record(records.sizeInBytes());
        }
        if (partition.isReassigning() && partition.isAddingLocalReplica()) {
            this.brokerTopicStats().updateReassignmentBytesIn(records.sizeInBytes());
        }
        this.brokerTopicStats().updateReplicationBytesIn(records.sizeInBytes());
        if (records.sizeInBytes() > 0) {
            this.brokerTopicStats().topicStats(topicPartition.topic()).totalFollowerFetchRequestRate().mark();
            this.brokerTopicStats().allTopicsStats().totalFollowerFetchRequestRate().mark();
        }
        return logAppendInfo;
    }

    public long updateHighWatermarkAndStartOffset(Partition partition, AbstractLog log, long leaderHighWatermark, Option<Object> leaderLogStartOffset) {
        long followerHighWatermark = log.updateHighWatermark(leaderHighWatermark);
        leaderLogStartOffset.foreach((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)offset -> log.maybeIncrementLogStartOffset(offset, LeaderOffsetIncremented$.MODULE$));
        return followerHighWatermark;
    }

    @Override
    public void onRestoreTierState(TopicPartition topicPartition, long proposedLocalLogStart, TierState tierState) {
        AbstractLog log = this.replicaMgr.localLogOrException(topicPartition);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Restoring tier state ").append(topicPartition).append(": ").append(tierState).toString());
        log.truncateAndRestoreTierState(proposedLocalLogStart, tierState);
    }

    @Override
    public Future<TierState> fetchTierState(TopicPartition topicPartition, TierLogSegment tierSegment) {
        return ((Partition)this.replicaMgr.onlinePartition(topicPartition).get()).fetchTierState(tierSegment);
    }

    @Override
    public Future<TierLogSegment> materializeTierStateUntilOffset(TopicPartition topicPartition, long targetOffset) {
        return this.replicaMgr.localLogOrException(topicPartition).materializeTierStateUntilOffset(targetOffset);
    }

    @Override
    public Future<TierLogSegment> materializeTierStateUntilObjectId(TopicPartition topicPartition, long targetOffset, UUID targetObjectId, int targetRestoreEpoch) {
        return this.replicaMgr.localLogOrException(topicPartition).materializeTierStateUntilObjectId(targetOffset, targetObjectId, targetRestoreEpoch);
    }

    public void maybeWarnIfOversizedRecords(MemoryRecords records, TopicPartition topicPartition) {
        if (((MetadataVersion)this.metadataVersionSupplier.apply()).fetchRequestVersion() <= 2 && records.sizeInBytes() > 0 && records.validBytes() <= 0) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(412).append("Replication is failing due to a message that is greater than replica.fetch.max.bytes for partition ").append(topicPartition).append(". ").append("This generally occurs when the max.message.bytes has been overridden to exceed this value and a suitably large ").append("message has also been sent. To fix this problem increase replica.fetch.max.bytes in your broker config to be ").append("equal or larger than your settings for max.message.bytes, both at a broker and topic level.").toString());
        }
    }

    @Override
    public void truncate(TopicPartition tp, OffsetTruncationState offsetTruncationState) {
        Partition partition = this.replicaMgr.getPartitionOrException(tp);
        AbstractLog log = partition.localLogOrException();
        partition.truncateTo(offsetTruncationState.offset(), false);
        if (offsetTruncationState.offset() < log.highWatermark()) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Truncating ").append(tp).append(" to offset ").append(offsetTruncationState.offset()).append(" below high watermark ").append(log.highWatermark()).toString());
        }
        if (offsetTruncationState.truncationCompleted()) {
            this.replicaMgr.replicaAlterLogDirsManager().markPartitionsForTruncation(this.brokerConfig.brokerId(), tp, offsetTruncationState.offset());
        }
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        this.replicaMgr.getPartitionOrException(topicPartition).truncateFullyAndStartAt(offset, false);
    }

    public ReplicaFetcherThread(String name, int fetcherId, LeaderEndPoint leader, KafkaConfig brokerConfig, FailedPartitions failedPartitions, ReplicaManager replicaMgr, ReplicaQuota quota, Option<LogContext> logContextOpt, Map<String, String> extraMetricTags, Option<Object> fetchBackOffMsOpt, Option<Object> fetchBackOffMsMaxOpt, Function0<MetadataVersion> metadataVersionSupplier) {
        this.fetcherId = fetcherId;
        this.brokerConfig = brokerConfig;
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        this.metadataVersionSupplier = metadataVersionSupplier;
        super(name, name, leader, failedPartitions, new ExponentialBackoff(BoxesRunTime.unboxToLong((Object)fetchBackOffMsOpt.getOrElse((Function0)new scala.Serializable(brokerConfig){
            public static final long serialVersionUID = 0L;
            private final KafkaConfig brokerConfig$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.brokerConfig$1.replicaFetchBackoffMs().longValue();
            }
            {
                this.brokerConfig$1 = brokerConfig$1;
            }
        })), 2, BoxesRunTime.unboxToLong((Object)fetchBackOffMsMaxOpt.getOrElse((Function0)new scala.Serializable(brokerConfig){
            public static final long serialVersionUID = 0L;
            private final KafkaConfig brokerConfig$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.brokerConfig$1.replicaFetchBackoffMaxMs().longValue();
            }
            {
                this.brokerConfig$1 = brokerConfig$1;
            }
        })), 0.0), false, replicaMgr.brokerTopicStats(), extraMetricTags);
        this.replicaId = brokerConfig.brokerId();
        this.logContext = (LogContext)logContextOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> new LogContext(new StringBuilder(51).append("[ReplicaFetcher replicaId=").append(this.replicaId()).append(", leaderId=").append(this.super$leader().brokerEndPoint().id()).append(", fetcherId=").append($this.fetcherId).append("] ").toString()));
        this.logIdent_$eq(this.logContext().logPrefix());
        this.isOffsetForLeaderEpochSupported = ((MetadataVersion)metadataVersionSupplier.apply()).isOffsetForLeaderEpochSupported();
    }
}

