/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import kafka.api.Request$;
import kafka.cluster.BrokerEndPoint;
import kafka.server.AbstractFetcherThread;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchParams;
import kafka.server.FetchPartitionData;
import kafka.server.FullPartitionFetchMetadata;
import kafka.server.KafkaConfig;
import kafka.server.LeaderEndPoint;
import kafka.server.PartitionFetchMetadata;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory$UnboundedQuota$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.TierOffsetInfo;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.replica.ClientMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.RequestUtils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005}h\u0001\u0002\u0010 \u0001\u0011B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A\u0001\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003F\u0011\u0015A\u0005\u0001\"\u0001J\u0011\u001dy\u0005A1A\u0005\nACa\u0001\u0016\u0001!\u0002\u0013\t\u0006bB+\u0001\u0005\u0004%IA\u0016\u0005\u0007?\u0002\u0001\u000b\u0011B,\t\u000f\u0001\u0004!\u0019!C\u0005-\"1\u0011\r\u0001Q\u0001\n]CqA\u0019\u0001A\u0002\u0013%1\rC\u0004s\u0001\u0001\u0007I\u0011B:\t\re\u0004\u0001\u0015)\u0003e\u0011\u0015Q\b\u0001\"\u0011|\u0011\u0019y\b\u0001\"\u0011\u0002\u0002!9\u00111\u0001\u0001\u0005B\u0005\u0005\u0001bBA\u0003\u0001\u0011\u0005\u0013q\u0001\u0005\b\u0003\u0013\u0001A\u0011IA\u0006\u0011\u001d\tI\u0004\u0001C!\u0003wAq!a\u0013\u0001\t\u0003\ni\u0005C\u0004\u0002\\\u0001!\t%!\u0018\t\u000f\u0005\r\u0004\u0001\"\u0011\u0002f!9\u0011\u0011\u0012\u0001\u0005B\u0005-\u0005bBAW\u0001\u0011%\u0011q\u0016\u0005\b\u0003{\u0003A\u0011BA`\u0011\u001d\ty\u000e\u0001C\u0005\u0003CDq!!:\u0001\t\u0003\n9\u000fC\u0004\u0002l\u0002!\t%!<\u0003'1{7-\u00197MK\u0006$WM]#oIB{\u0017N\u001c;\u000b\u0005\u0001\n\u0013AB:feZ,'OC\u0001#\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001A\u0013,_A\u0011a%K\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\t1\u0011I\\=SK\u001a\u0004\"\u0001L\u0017\u000e\u0003}I!AL\u0010\u0003\u001d1+\u0017\rZ3s\u000b:$\u0007k\\5oiB\u0011\u0001gM\u0007\u0002c)\u0011!'I\u0001\u0006kRLGn]\u0005\u0003iE\u0012q\u0001T8hO&tw-\u0001\u0007t_V\u00148-\u001a\"s_.,'\u000f\u0005\u00028u5\t\u0001H\u0003\u0002:C\u000591\r\\;ti\u0016\u0014\u0018BA\u001e9\u00059\u0011%o\\6fe\u0016sG\rU8j]R\fAB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u0004\"\u0001\f \n\u0005}z\"aC&bM.\f7i\u001c8gS\u001e\faB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u0002-\u0005&\u00111i\b\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003\u0015\tXo\u001c;b!\tac)\u0003\u0002H?\ta!+\u001a9mS\u000e\f\u0017+^8uC\u00061A(\u001b8jiz\"RAS&M\u001b:\u0003\"\u0001\f\u0001\t\u000bU*\u0001\u0019\u0001\u001c\t\u000bq*\u0001\u0019A\u001f\t\u000b\u0001+\u0001\u0019A!\t\u000b\u0011+\u0001\u0019A#\u0002\u0013I,\u0007\u000f\\5dC&#W#A)\u0011\u0005\u0019\u0012\u0016BA*(\u0005\rIe\u000e^\u0001\u000be\u0016\u0004H.[2b\u0013\u0012\u0004\u0013\u0001C7bq\nKH/Z:\u0016\u0003]\u0003\"\u0001W/\u000e\u0003eS!AW.\u0002\t1\fgn\u001a\u0006\u00029\u0006!!.\u0019<b\u0013\tq\u0016LA\u0004J]R,w-\u001a:\u0002\u00135\f\u0007PQ=uKN\u0004\u0013!\u00034fi\u000eD7+\u001b>f\u0003)1W\r^2i'&TX\rI\u0001\u0014S:\u0004&o\\4sKN\u001c\b+\u0019:uSRLwN\\\u000b\u0002IB\u0019a%Z4\n\u0005\u0019<#AB(qi&|g\u000e\u0005\u0002ia6\t\u0011N\u0003\u0002kW\u000611m\\7n_:T!A\t7\u000b\u00055t\u0017AB1qC\u000eDWMC\u0001p\u0003\ry'oZ\u0005\u0003c&\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\fj]B\u0013xn\u001a:fgN\u0004\u0016M\u001d;ji&|gn\u0018\u0013fcR\u0011Ao\u001e\t\u0003MUL!A^\u0014\u0003\tUs\u0017\u000e\u001e\u0005\bq6\t\t\u00111\u0001e\u0003\rAH%M\u0001\u0015S:\u0004&o\\4sKN\u001c\b+\u0019:uSRLwN\u001c\u0011\u00029%\u001cHK];oG\u0006$\u0018n\u001c8P]\u001a+Go\u00195TkB\u0004xN\u001d;fIV\tA\u0010\u0005\u0002'{&\u0011ap\n\u0002\b\u0005>|G.Z1o\u00035Ig.\u001b;jCR,7\t\\8tKR\tA/A\u0003dY>\u001cX-\u0001\bce>\\WM]#oIB{\u0017N\u001c;\u0015\u0003Y\nQAZ3uG\"$B!!\u0004\u0002\"A9\u0011qBA\u000bO\u0006eQBAA\t\u0015\r\t\u0019bJ\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\f\u0003#\u00111!T1q!\u0011\tY\"!\b\u000e\u0003\u0001I1!a\b.\u0005%1U\r^2i\t\u0006$\u0018\rC\u0004\u0002$M\u0001\r!!\n\u0002\u0019\u0019,Go\u00195SKF,Xm\u001d;\u0011\t\u0005\u001d\u00121\u0007\b\u0005\u0003S\ty#\u0004\u0002\u0002,)\u0019\u0011QF5\u0002\u0011I,\u0017/^3tiNLA!!\r\u0002,\u0005aa)\u001a;dQJ+\u0017/^3ti&!\u0011QGA\u001c\u0005\u001d\u0011U/\u001b7eKJTA!!\r\u0002,\u0005\u0019b-\u001a;dQ\u0016\u000b'\u000f\\5fgR|eMZ:fiR1\u0011QHA\"\u0003\u000f\u00022AJA \u0013\r\t\te\n\u0002\u0005\u0019>tw\r\u0003\u0004\u0002FQ\u0001\raZ\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\tI\u0005\u0006a\u0001#\u0006\u00112-\u001e:sK:$H*Z1eKJ,\u0005o\\2i\u0003y1W\r^2i)&,'/T1uKJL\u0017\r\\5{CRLwN\u001c+be\u001e,G\u000f\u0006\u0004\u0002P\u0005U\u0013q\u000b\t\u0004Y\u0005E\u0013bAA*?\tqA+[3s\u001f\u001a47/\u001a;J]\u001a|\u0007BBA#+\u0001\u0007q\r\u0003\u0004\u0002ZU\u0001\r!U\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007.A\tgKR\u001c\u0007\u000eT1uKN$xJ\u001a4tKR$b!!\u0010\u0002`\u0005\u0005\u0004BBA#-\u0001\u0007q\r\u0003\u0004\u0002JY\u0001\r!U\u0001\u0015M\u0016$8\r[#q_\u000eDWI\u001c3PM\u001a\u001cX\r^:\u0015\t\u0005\u001d\u0014Q\u0010\t\b\u0003\u001f\t)bZA5!\u0011\tY'a\u001e\u000f\t\u00055\u00141O\u0007\u0003\u0003_R1!!\u001dj\u0003\u001diWm]:bO\u0016LA!!\u001e\u0002p\u0005\u0001sJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"\u0014Vm\u001d9p]N,G)\u0019;b\u0013\u0011\tI(a\u001f\u0003\u001d\u0015\u0003xn\u00195F]\u0012|eMZ:fi*!\u0011QOA8\u0011\u001d\tyh\u0006a\u0001\u0003\u0003\u000b!\u0002]1si&$\u0018n\u001c8t!\u001d\ty!!\u0006h\u0003\u0007\u0003B!a\u0007\u0002\u0006&\u0019\u0011qQ\u0017\u0003\u0013\u0015\u0003xn\u00195ECR\f\u0017A\u00032vS2$g)\u001a;dQR!\u0011QRAR!\u0019\ty)!&\u0002\u001c:\u0019A&!%\n\u0007\u0005Mu$A\u000bBEN$(/Y2u\r\u0016$8\r[3s)\"\u0014X-\u00193\n\t\u0005]\u0015\u0011\u0014\u0002\u0015%\u0016\u001cX\u000f\u001c;XSRD\u0007+\u0019:uSRLwN\\:\u000b\u0007\u0005Mu\u0004\u0005\u0003'K\u0006u\u0005\u0003BAH\u0003?KA!!)\u0002\u001a\na!+\u001a9mS\u000e\fg)\u001a;dQ\"9\u0011q\u0010\rA\u0002\u0005\u0015\u0006cBA\b\u0003+9\u0017q\u0015\t\u0004Y\u0005%\u0016bAAV?\t\u0019\u0002+\u0019:uSRLwN\u001c$fi\u000eD7\u000b^1uK\u000612/\u001a7fGR\u0004\u0016M\u001d;ji&|g\u000eV8GKR\u001c\u0007\u000e\u0006\u0003\u00022\u0006e\u0006\u0003\u0002\u0014f\u0003g\u0003bAJA[O\u0006\u001d\u0016bAA\\O\t1A+\u001e9mKJBq!a/\u001a\u0001\u0004\t)+\u0001\u0007qCJ$\u0018\u000e^5p]6\u000b\u0007/\u0001\fck&dGMR3uG\"4uN\u001d)beRLG/[8o)\u0019\t\t-a6\u0002\\B1\u00111YAK\u0003'tA!!2\u0002\u0012:!\u0011qYAi\u001d\u0011\tI-a4\u000e\u0005\u0005-'bAAgG\u00051AH]8pizJ\u0011AI\u0005\u0003A\u0005\u0002BAJ3\u0002VB!\u00111YAP\u0011\u0019\tIN\u0007a\u0001O\u0006\u0011A\u000f\u001d\u0005\b\u0003;T\u0002\u0019AAT\u0003)1W\r^2i'R\fG/Z\u0001\u0013]\u0016DHOU3bIf\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0003\u00022\u0006\r\bbBA^7\u0001\u0007\u0011QU\u0001\u0010SN\u0014V-\u00193z\r>\u0014h)\u001a;dQR\u0019A0!;\t\r\u0005eG\u00041\u0001h\u0003!!xn\u0015;sS:<GCAAx!\u0011\t\t0!?\u000f\t\u0005M\u0018Q\u001f\t\u0004\u0003\u0013<\u0013bAA|O\u00051\u0001K]3eK\u001aLA!a?\u0002~\n11\u000b\u001e:j]\u001eT1!a>(\u0001")
public class LocalLeaderEndPoint
implements LeaderEndPoint,
Logging {
    private final BrokerEndPoint sourceBroker;
    private final ReplicaManager replicaManager;
    private final ReplicaQuota quota;
    private final int replicaId;
    private final Integer maxBytes;
    private final Integer fetchSize;
    private Option<TopicPartition> inProgressPartition;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private int replicaId() {
        return this.replicaId;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    private Option<TopicPartition> inProgressPartition() {
        return this.inProgressPartition;
    }

    private void inProgressPartition_$eq(Option<TopicPartition> x$1) {
        this.inProgressPartition = x$1;
    }

    @Override
    public boolean isTruncationOnFetchSupported() {
        return false;
    }

    @Override
    public void initiateClose() {
    }

    @Override
    public void close() {
    }

    @Override
    public BrokerEndPoint brokerEndPoint() {
        return this.sourceBroker;
    }

    @Override
    public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
        ObjectRef partitionData = ObjectRef.create(null);
        FetchRequest request = (FetchRequest)fetchRequest.build();
        HashMap topicNames = new HashMap();
        request.data().topics().forEach(topic -> topicNames.put((Object)topic.topicId(), (Object)topic.topic()));
        ArrayBuffer partitions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        request.data().topics().forEach(topic -> {
            String name = request.version() < 13 ? topic.topic() : (String)topicNames.apply((Object)topic.topicId());
            topic.partitions().forEach(partition -> partitions.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition(topic.topicId(), partition.partition(), name)), (Object)new FullPartitionFetchMetadata(topic.topicId(), partition.fetchOffset(), partition.logStartOffset(), partition.partitionMaxBytes(), RequestUtils.getLeaderEpoch((int)partition.currentLeaderEpoch()), RequestUtils.getLeaderEpoch((int)partition.lastFetchedEpoch())))));
        });
        short x$1 = request.version();
        long x$22 = 0L;
        int x$3 = Request$.MODULE$.FutureLocalReplicaId();
        int x$4 = request.minBytes();
        int x$5 = request.maxBytes();
        FetchLogEnd$ x$6 = FetchLogEnd$.MODULE$;
        None$ x$7 = None$.MODULE$;
        FetchParams fetchParams = new FetchParams(x$1, x$3, x$22, x$4, x$5, x$6, (Option<ClientMetadata>)x$7);
        this.replicaManager.fetchMessages(fetchParams, (Seq<Tuple2<TopicIdPartition, PartitionFetchMetadata>>)partitions, QuotaFactory$UnboundedQuota$.MODULE$, (Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)responsePartitionData -> {
            LocalLeaderEndPoint.processResponseCallback$1(responsePartitionData, partitionData);
            return BoxedUnit.UNIT;
        });
        if ((Seq)partitionData.elem == null) {
            throw new IllegalStateException(new StringBuilder(36).append("Failed to fetch data for partitions ").append(((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)x$2 -> (TopicIdPartition)x$2._1(), ArrayBuffer$.MODULE$.canBuildFrom())).mkString(",")).toString());
        }
        return ((Seq)partitionData.elem).toMap(Predef$.MODULE$.$conforms());
    }

    @Override
    public long fetchEarliestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        return this.replicaManager.getPartitionOrException(topicPartition).localLogOrException().logStartOffset();
    }

    @Override
    public TierOffsetInfo fetchTierMaterializationTarget(TopicPartition topicPartition, int leaderEpoch) {
        throw new UnsupportedOperationException("Local leader endpoint does not support tiered partitions");
    }

    @Override
    public long fetchLatestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        return this.replicaManager.getPartitionOrException(topicPartition).localLogOrException().logEndOffset();
    }

    @Override
    public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
        return (Map)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                OffsetForLeaderEpochRequestData.OffsetForLeaderPartition epochData = (OffsetForLeaderEpochRequestData.OffsetForLeaderPartition)x0$1._2();
                try {
                    OffsetForLeaderEpochResponseData.EpochEndOffset endOffset = epochData.leaderEpoch() == -1 ? new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(Errors.NONE.code()) : $this.replicaManager.getPartitionOrException(tp).lastOffsetForLeaderEpoch(RequestUtils.getLeaderEpoch((int)epochData.currentLeaderEpoch()), epochData.leaderEpoch(), false);
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)endOffset);
                }
                catch (Throwable t) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error when getting EpochEndOffset for ").append(tp).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(Errors.forException((Throwable)t).code()));
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple22 = tuple2;
            return tuple22;
        }, scala.collection.Map$.MODULE$.canBuildFrom());
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitions) {
        AbstractFetcherThread.ResultWithPartitions<None$> resultWithPartitions;
        Tuple2 tuple2;
        if (this.quota.isQuotaExceeded()) {
            return new AbstractFetcherThread.ResultWithPartitions<None$>(None$.MODULE$, (Map<TopicPartition, Errors>)scala.collection.Map$.MODULE$.empty());
        }
        Option<Tuple2<TopicPartition, PartitionFetchState>> option = this.selectPartitionToFetch(partitions);
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            PartitionFetchState fetchState = (PartitionFetchState)tuple2._2();
            resultWithPartitions = this.buildFetchForPartition(tp, fetchState);
        } else if (None$.MODULE$.equals(option)) {
            resultWithPartitions = new AbstractFetcherThread.ResultWithPartitions<None$>(None$.MODULE$, (Map<TopicPartition, Errors>)scala.collection.Map$.MODULE$.empty());
        } else {
            throw new MatchError(option);
        }
        return resultWithPartitions;
    }

    /*
     * WARNING - void declaration
     */
    private Option<Tuple2<TopicPartition, PartitionFetchState>> selectPartitionToFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        Object object = new Object();
        try {
            void var3_3;
            this.inProgressPartition().foreach((Function1 & Serializable & scala.Serializable)tp -> {
                LocalLeaderEndPoint.$anonfun$selectPartitionToFetch$1(partitionMap, object, tp);
                return BoxedUnit.UNIT;
            });
            this.inProgressPartition_$eq((Option<TopicPartition>)None$.MODULE$);
            Option<Tuple2<TopicPartition, PartitionFetchState>> nextPartitionOpt = this.nextReadyPartition(partitionMap);
            nextPartitionOpt.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                LocalLeaderEndPoint.$anonfun$selectPartitionToFetch$4(this, partitionMap, x0$1);
                return BoxedUnit.UNIT;
            });
            return var3_3;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (Option)ex.value();
            }
            throw ex;
        }
    }

    private AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetchForPartition(TopicPartition tp, PartitionFetchState fetchState) {
        None$ none$;
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        scala.collection.mutable.Map partitionsWithError = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        try {
            long logStartOffset = this.replicaManager.futureLocalLogOrException(tp).logStartOffset();
            Optional lastFetchedEpoch = this.isTruncationOnFetchSupported() ? OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(fetchState.lastFetchedEpoch().map((Function1 & Serializable & scala.Serializable)x$4 -> LocalLeaderEndPoint.$anonfun$buildFetchForPartition$1(BoxesRunTime.unboxToInt((Object)x$4))))) : Optional.empty();
            Uuid topicId = (Uuid)fetchState.topicId().getOrElse((Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID);
            requestMap.put(tp, new FetchRequest.PartitionData(topicId, fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch())), lastFetchedEpoch));
        }
        catch (KafkaStorageException e) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Failed to build fetch for ").append(tp).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            partitionsWithError.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Errors.KAFKA_STORAGE_ERROR));
        }
        if (requestMap.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            FetchRequest.Builder requestBuilder = FetchRequest.Builder.forReplica((short)(fetchState.topicId().isEmpty() ? (short)12 : (short)ApiKeys.FETCH.latestVersion()), (int)this.replicaId(), (int)0, (int)0, requestMap).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes()));
            none$ = new Some((Object)new AbstractFetcherThread.ReplicaFetch(requestMap, requestBuilder));
        }
        None$ fetchRequestOpt = none$;
        return new AbstractFetcherThread.ResultWithPartitions<None$>(fetchRequestOpt, (Map<TopicPartition, Errors>)partitionsWithError);
    }

    private Option<Tuple2<TopicPartition, PartitionFetchState>> nextReadyPartition(Map<TopicPartition, PartitionFetchState> partitionMap) {
        return ((TraversableOnce)partitionMap.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LocalLeaderEndPoint.$anonfun$nextReadyPartition$1(x0$1)))).reduceLeftOption((Function2 & Serializable & scala.Serializable)(left, right) -> {
            block3: {
                block2: {
                    if (new StringOps(Predef$.MODULE$.augmentString(((TopicPartition)left._1()).topic())).$less((Object)((TopicPartition)right._1()).topic())) break block2;
                    String string = ((TopicPartition)left._1()).topic();
                    String string2 = ((TopicPartition)right._1()).topic();
                    if ((string != null ? !string.equals(string2) : string2 != null) || ((TopicPartition)left._1()).partition() >= ((TopicPartition)right._1()).partition()) break block3;
                }
                return left;
            }
            return right;
        });
    }

    @Override
    public boolean isReadyForFetch(TopicPartition tp) {
        return true;
    }

    public String toString() {
        return "LocalLeaderEndPoint";
    }

    private static final void processResponseCallback$1(Seq responsePartitionData, ObjectRef partitionData$1) {
        partitionData$1.elem = (Seq)responsePartitionData.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicIdPartition tp = (TopicIdPartition)x0$1._1();
            FetchPartitionData data = (FetchPartitionData)x0$1._2();
            List abortedTransactions = (List)data.abortedTransactions().map((Function1 & Serializable & scala.Serializable)x$1 -> (List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)x$1).asJava()).orNull(Predef$.MODULE$.$conforms());
            long lastStableOffset = BoxesRunTime.unboxToLong((Object)data.lastStableOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topicPartition()), (Object)new FetchResponseData.PartitionData().setPartitionIndex(tp.topicPartition().partition()).setErrorCode(data.error().code()).setHighWatermark(data.highWatermark()).setLastStableOffset(lastStableOffset).setLogStartOffset(data.logStartOffset()).setAbortedTransactions(abortedTransactions).setRecords((BaseRecords)data.records()));
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$1(Map partitionMap$1, Object nonLocalReturnKey1$1, TopicPartition tp) {
        partitionMap$1.get((Object)tp).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isReadyForFetch())).foreach((Function1 & Serializable & scala.Serializable)fetchState -> {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new Tuple2((Object)tp, fetchState)));
        });
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$4(LocalLeaderEndPoint $this, Map partitionMap$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            PartitionFetchState fetchState = (PartitionFetchState)x0$1._2();
            $this.inProgressPartition_$eq((Option<TopicPartition>)new Some((Object)tp));
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(133).append("Beginning/resuming copy of partition ").append(tp).append(" from offset ").append(fetchState.fetchOffset()).append(". ").append("Including this partition, there are ").append(partitionMap$1.size()).append(" remaining partitions to copy by this thread.").toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Integer $anonfun$buildFetchForPartition$1(int x$4) {
        return BoxesRunTime.boxToInteger((int)x$4);
    }

    public static final /* synthetic */ boolean $anonfun$nextReadyPartition$1(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((PartitionFetchState)x0$1._2()).isReadyForFetch();
        return bl;
    }

    public LocalLeaderEndPoint(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, ReplicaManager replicaManager, ReplicaQuota quota) {
        this.sourceBroker = sourceBroker;
        this.replicaManager = replicaManager;
        this.quota = quota;
        Logging.$init$(this);
        this.replicaId = brokerConfig.brokerId();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.inProgressPartition = None$.MODULE$;
    }
}

