/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.rest.KafkaRestoreRestApiReturnStatus;
import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import kafka.cluster.EndPoint;
import kafka.log.AbstractLog;
import kafka.log.MergedLog$;
import kafka.server.HostedPartition;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierPartitionFence;
import kafka.tier.domain.TierPartitionForceRestore;
import kafka.tier.domain.TierPartitionUnfreezeLogStartOffset;
import kafka.tier.tools.RecoveryUtils;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001B\n\u0015\u0001eA\u0001\u0002\t\u0001\u0003\u0006\u0004%\t!\t\u0005\tM\u0001\u0011\t\u0011)A\u0005E!Aq\u0005\u0001BC\u0002\u0013\u0005\u0001\u0006\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003*\u0011\u0015i\u0003\u0001\"\u0001/\u0011\u001d\u0011\u0004A1A\u0005\u0002MBa\u0001\u0010\u0001!\u0002\u0013!\u0004bB\u001f\u0001\u0005\u0004%\tA\u0010\u0005\u0007\u0005\u0002\u0001\u000b\u0011B \t\u000b\r\u0003A\u0011\u0001#\t\u000bQ\u0003A\u0011A+\t\u000bm\u0003A\u0011\u0001/\t\u000b5\u0004A\u0011\u00028\t\u000be\u0004A\u0011\u0001>\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010!9\u0011Q\u0003\u0001\u0005\u0002\u0005]\u0001bBA\u0015\u0001\u0011\u0005\u00111\u0006\u0005\b\u0003c\u0001A\u0011AA\u001a\u0005\u0005Z\u0015MZ6b)>\u0004\u0018n\u0019)beRLG/[8o%\u0016\u001cHo\u001c:f\u001b\u0006t\u0017mZ3s\u0015\t)b#\u0001\u0004tKJ4XM\u001d\u0006\u0002/\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u001b!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0019\te.\u001f*fM\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014X#\u0001\u0012\u0011\u0005\r\"S\"\u0001\u000b\n\u0005\u0015\"\"A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA\u0005Y1.\u00194lC\u000e{gNZ5h+\u0005I\u0003CA\u0012+\u0013\tYCCA\u0006LC\u001a\\\u0017mQ8oM&<\u0017\u0001D6bM.\f7i\u001c8gS\u001e\u0004\u0013A\u0002\u001fj]&$h\bF\u00020aE\u0002\"a\t\u0001\t\u000b\u0001*\u0001\u0019\u0001\u0012\t\u000b\u001d*\u0001\u0019A\u0015\u0002\r1|wmZ3s+\u0005!\u0004CA\u001b;\u001b\u00051$BA\u001c9\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005I\u0014aA8sO&\u00111H\u000e\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005!\u0001o\u001c:u+\u0005y\u0004CA\u000eA\u0013\t\tEDA\u0002J]R\fQ\u0001]8si\u0002\n\u0011bZ3u\u0019\u0016\fG-\u001a:\u0015\u0007}*%\u000bC\u0003G\u0015\u0001\u0007q)A\u0003u_BL7\r\u0005\u0002I\u001f:\u0011\u0011*\u0014\t\u0003\u0015ri\u0011a\u0013\u0006\u0003\u0019b\ta\u0001\u0010:p_Rt\u0014B\u0001(\u001d\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001+\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059c\u0002\"B*\u000b\u0001\u0004y\u0014!\u00039beRLG/[8o\u0003Y9W\r\u001e+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;biV\u001cHc\u0001,Z5B\u00111dV\u0005\u00031r\u0011A\u0001T8oO\")ai\u0003a\u0001\u000f\")1k\u0003a\u0001\u007f\u0005Yq-\u001a;GiB\u001ch)\u001b7f)\ri6\u000e\u001c\t\u0004=\u000e,W\"A0\u000b\u0005\u0001\f\u0017\u0001B;uS2T\u0011AY\u0001\u0005U\u00064\u0018-\u0003\u0002e?\nAq\n\u001d;j_:\fG\u000e\u0005\u0002gS6\tqM\u0003\u0002iC\u0006\u0011\u0011n\\\u0005\u0003U\u001e\u0014AAR5mK\")a\t\u0004a\u0001\u000f\")1\u000b\u0004a\u0001\u007f\u0005Y\u0011N\u001c6fGR,e/\u001a8u)\tyt\u000eC\u0003q\u001b\u0001\u0007\u0011/A\u0003fm\u0016tG\u000f\u0005\u0002so6\t1O\u0003\u0002uk\u00061Am\\7bS:T!A\u001e\f\u0002\tQLWM]\u0005\u0003qN\u0014A#\u00112tiJ\f7\r\u001e+jKJlU\r^1eCR\f\u0017AB4fi2{w\rF\u0003|\u0003\u0013\tY\u0001E\u0002\u001cyzL!! \u000f\u0003\r=\u0003H/[8o!\ry\u0018QA\u0007\u0003\u0003\u0003Q1!a\u0001\u0017\u0003\rawnZ\u0005\u0005\u0003\u000f\t\tAA\u0006BEN$(/Y2u\u0019><\u0007\"\u0002$\u000f\u0001\u00049\u0005\"B*\u000f\u0001\u0004y\u0014AG:fi\u001a+gnY3US\u0016\u0014Hk\u001c9jGB\u000b'\u000f^5uS>tG#B \u0002\u0012\u0005M\u0001\"\u0002$\u0010\u0001\u00049\u0005\"B*\u0010\u0001\u0004y\u0014\u0001H:fi\u001a{'oY3SKN$xN]3US\u0016\u0014\b+\u0019:uSRLwN\u001c\u000b\f\u007f\u0005e\u00111DA\u000f\u0003C\t)\u0003C\u0003G!\u0001\u0007q\tC\u0003T!\u0001\u0007q\b\u0003\u0004\u0002 A\u0001\rAV\u0001\fgR\f'\u000f^(gMN,G\u000f\u0003\u0004\u0002$A\u0001\rAV\u0001\nK:$wJ\u001a4tKRDa!a\n\u0011\u0001\u00049\u0015aC2p]R,g\u000e\u001e%bg\"\f\u0011d]3u+:4'/Z3{K2{wm\u0015;beR|eMZ:fiR)q(!\f\u00020!)a)\u0005a\u0001\u000f\")1+\u0005a\u0001\u007f\u0005\u0001b/\u00197jI\u0006$X\rT8h%\u0006tw-\u001a\u000b\n\u007f\u0005U\u0012qGA\u001d\u0003{AQA\u0012\nA\u0002\u001dCQa\u0015\nA\u0002}Ba!a\u000f\u0013\u0001\u00041\u0016A\u00047pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\u0007\u0003\u007f\u0011\u0002\u0019\u0001,\u0002\u00191|w-\u00128e\u001f\u001a47/\u001a;")
public class KafkaTopicPartitionRestoreManager {
    private final ReplicaManager replicaManager;
    private final KafkaConfig kafkaConfig;
    private final Logger logger;
    private final int port;

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    public Logger logger() {
        return this.logger;
    }

    public int port() {
        return this.port;
    }

    public int getLeader(String topic, int partition) {
        int n;
        HostedPartition hostedPartition = this.replicaManager().getPartition(new TopicPartition(topic, partition));
        if (hostedPartition instanceof HostedPartition.Online) {
            Option<Object> option = ((HostedPartition.Online)hostedPartition).partition().leaderReplicaIdOpt();
            int n2 = option instanceof Some ? BoxesRunTime.unboxToInt((Object)((Some)option).value()) : KafkaRestoreRestApiReturnStatus.success;
            n = n2;
        } else {
            n = KafkaRestoreRestApiReturnStatus.invalid;
        }
        return n;
    }

    public long getTierPartitionStatus(String topic, int partition) {
        long l;
        Option<AbstractLog> option = this.replicaManager().logManager().getLog(new TopicPartition(topic, partition), this.replicaManager().logManager().getLog$default$2());
        if (option instanceof Some) {
            AbstractLog log = (AbstractLog)((Some)option).value();
            int partitionStatus = log.tierPartitionState().status().ordinal();
            this.logger().info(new StringBuilder(41).append("[").append(topic).append("-").append(partition).append("]: tier partition status as ").append((Object)log.tierPartitionState().status()).append(" (ordinal ").append(partitionStatus).append(")").toString());
            l = partitionStatus;
        } else {
            l = KafkaRestoreRestApiReturnStatus.invalid;
        }
        return l;
    }

    public Optional<File> getFtpsFile(String topic, int partition) {
        Object object = new Object();
        try {
            this.kafkaConfig().logDirs().foreach((Function1 & Serializable & scala.Serializable)logDir -> {
                File dir = new File(new StringBuilder(3).append((String)logDir).append("/").append(topic).append("-").append(partition).append("/").toString());
                throw new NonLocalReturnControl(object, Optional.of(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles())).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)KafkaTopicPartitionRestoreManager.$anonfun$getFtpsFile$2(f))))).head()));
            });
            return Optional.empty();
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (Optional)ex.value();
            }
            throw ex;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int injectEvent(AbstractTierMetadata event) {
        void var2_2;
        int success = KafkaRestoreRestApiReturnStatus.failure;
        Properties properties = new Properties();
        properties.put("bootstrap.servers", new StringBuilder(10).append("localhost:").append(this.port()).toString());
        Some maybeProducer = new Some(RecoveryUtils.createTierTopicProducer(properties, "restore-rest-server"));
        String tierTopicName = "_confluent-tier-state";
        Short partitions = this.kafkaConfig().confluentConfig().tierMetadataNumPartitions();
        try {
            try {
                RecoveryUtils.injectTierTopicEvent((Producer<byte[], byte[]>)((Producer)maybeProducer.get()), event, tierTopicName, Predef$.MODULE$.Short2short(partitions));
                success = KafkaRestoreRestApiReturnStatus.success;
            }
            catch (Exception e) {
                this.logger().error(new StringBuilder(23).append("Exception in injecting ").append(event).toString(), (Throwable)e);
            }
        }
        finally {
            maybeProducer.foreach((Function1 & Serializable & scala.Serializable)producer -> {
                producer.close();
                return BoxedUnit.UNIT;
            });
        }
        return (int)var2_2;
    }

    public Option<AbstractLog> getLog(String topic, int partition) {
        return this.replicaManager().logManager().getLog(new TopicPartition(topic, partition), this.replicaManager().logManager().getLog$default$2());
    }

    public int setFenceTierTopicPartition(String topic, int partition) {
        int n;
        Option eventOpt = this.getLog(topic, partition).flatMap((Function1 & Serializable & scala.Serializable)log -> {
            None$ none$;
            Option<TopicIdPartition> option = log.topicIdPartition();
            if (option instanceof Some) {
                TopicIdPartition topicId = (TopicIdPartition)((Some)option).value();
                none$ = new Some((Object)new TierPartitionFence(topicId, UUID.randomUUID(), true));
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        });
        if (eventOpt instanceof Some) {
            TierPartitionFence event = (TierPartitionFence)((Some)eventOpt).value();
            n = this.injectEvent(event);
        } else {
            n = KafkaRestoreRestApiReturnStatus.failure;
        }
        return n;
    }

    public int setForceRestoreTierPartition(String topic, int partition, long startOffset, long endOffset, String contentHash) {
        int n;
        Option eventOpt = this.getLog(topic, partition).flatMap((Function1 & Serializable & scala.Serializable)log -> {
            None$ none$;
            Option<TopicIdPartition> option = log.topicIdPartition();
            if (option instanceof Some) {
                TopicIdPartition topicId = (TopicIdPartition)((Some)option).value();
                none$ = new Some((Object)new TierPartitionForceRestore(topicId, UUID.randomUUID(), startOffset, endOffset, log.tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch(), contentHash, Predef$.MODULE$.boolean2Boolean(true)));
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        });
        if (eventOpt instanceof Some) {
            TierPartitionForceRestore event = (TierPartitionForceRestore)((Some)eventOpt).value();
            n = this.injectEvent(event);
        } else {
            n = KafkaRestoreRestApiReturnStatus.failure;
        }
        return n;
    }

    public int setUnfreezeLogStartOffset(String topic, int partition) {
        int n;
        Option eventOpt = this.getLog(topic, partition).flatMap((Function1 & Serializable & scala.Serializable)log -> {
            None$ none$;
            Option<TopicIdPartition> option = log.topicIdPartition();
            if (option instanceof Some) {
                TopicIdPartition topicId = (TopicIdPartition)((Some)option).value();
                none$ = new Some((Object)new TierPartitionUnfreezeLogStartOffset(topicId, UUID.randomUUID()));
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        });
        if (eventOpt instanceof Some) {
            TierPartitionUnfreezeLogStartOffset event = (TierPartitionUnfreezeLogStartOffset)((Some)eventOpt).value();
            n = this.injectEvent(event);
        } else {
            n = KafkaRestoreRestApiReturnStatus.failure;
        }
        return n;
    }

    public int validateLogRange(String topic, int partition, long logStartOffset, long logEndOffset) {
        int n;
        Option<AbstractLog> option = this.replicaManager().logManager().getLog(new TopicPartition(topic, partition), this.replicaManager().logManager().getLog$default$2());
        if (option instanceof Some) {
            int n2;
            AbstractLog log = (AbstractLog)((Some)option).value();
            if (logStartOffset >= log.logStartOffset() && logEndOffset <= log.logEndOffset()) {
                n2 = KafkaRestoreRestApiReturnStatus.success;
            } else {
                this.logger().warn(new StringBuilder(88).append("[").append(topic).append("-").append(partition).append("]: validate log range fail, log range to be validated (").append(logStartOffset).append(" - ").append(logEndOffset).append("), log range on broker (").append(log.logStartOffset()).append(" - ").append(log.logEndOffset()).append(")").toString());
                n2 = KafkaRestoreRestApiReturnStatus.failure;
            }
            n = n2;
        } else {
            this.logger().warn(new StringBuilder(42).append("[").append(topic).append("-").append(partition).append("]: logManager doesn't contains log for ").append(topic).append("-").append(partition).toString());
            n = KafkaRestoreRestApiReturnStatus.failure;
        }
        return n;
    }

    public static final /* synthetic */ boolean $anonfun$getFtpsFile$2(File f) {
        return f.isFile() && MergedLog$.MODULE$.isTierStateFile(f);
    }

    public KafkaTopicPartitionRestoreManager(ReplicaManager replicaManager, KafkaConfig kafkaConfig) {
        this.replicaManager = replicaManager;
        this.kafkaConfig = kafkaConfig;
        this.logger = LoggerFactory.getLogger((String)"KafkaTopicPartitionRestoreManager");
        this.port = ((EndPoint)kafkaConfig.listeners().apply(0)).port();
    }
}

