/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import io.confluent.kafka.availability.ThreadCountersManager;
import io.confluent.kafka.availability.ThreadLocalCounters;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.RequestChannel;
import kafka.network.RequestChannel$ShutdownRequest$;
import kafka.server.ApiRequestHandler;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d\u0001\u0002\u000e\u001c\u0001\u0001B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\ts\u0001\u0011\t\u0011)A\u0005u!AQ\t\u0001B\u0001B\u0003%1\u0007\u0003\u0005G\u0001\t\u0015\r\u0011\"\u0001H\u0011!!\u0006A!A!\u0002\u0013A\u0005\u0002C+\u0001\u0005\u000b\u0007I\u0011\u0001,\t\u0011\u0005\u0004!\u0011!Q\u0001\n]C\u0001B\u0019\u0001\u0003\u0006\u0004%\ta\u0019\u0005\tU\u0002\u0011\t\u0011)A\u0005I\"A1\u000e\u0001B\u0001B\u0003%A\u000e\u0003\u0005q\u0001\t\u0005\t\u0015!\u0003r\u0011\u0015i\b\u0001\"\u0001\u007f\u0011%\t\t\u0002\u0001b\u0001\n\u0013\t\u0019\u0002\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0011BA\u000b\u0011%\ty\u0002\u0001b\u0001\n\u0013\t\t\u0003\u0003\u0005\u0002*\u0001\u0001\u000b\u0011BA\u0012\u0011%\tY\u0003\u0001a\u0001\n\u0013\ti\u0003C\u0005\u00026\u0001\u0001\r\u0011\"\u0003\u00028!A\u00111\t\u0001!B\u0013\ty\u0003C\u0004\u0002N\u0001!\t!a\u0014\t\u0011\u0005E\u0003\u0001\"\u0001\u001c\u0003'Bq!!\u0017\u0001\t\u0013\ty\u0005C\u0004\u0002\\\u0001!\t!a\u0014\t\u000f\u0005u\u0003\u0001\"\u0001\u0002P!9\u0011q\f\u0001\u0005\u0002\u0005=#aE&bM.\f'+Z9vKN$\b*\u00198eY\u0016\u0014(B\u0001\u000f\u001e\u0003\u0019\u0019XM\u001d<fe*\ta$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001\t\u0013\u0006\f\t\u0003E\u001dj\u0011a\t\u0006\u0003I\u0015\nA\u0001\\1oO*\ta%\u0001\u0003kCZ\f\u0017B\u0001\u0015$\u0005\u0019y%M[3diB\u0011!EK\u0005\u0003W\r\u0012\u0001BU;o]\u0006\u0014G.\u001a\t\u0003[Aj\u0011A\f\u0006\u0003_u\tQ!\u001e;jYNL!!\r\u0018\u0003\u000f1{wmZ5oO\u0006\u0011\u0011\u000e\u001a\t\u0003i]j\u0011!\u000e\u0006\u0002m\u0005)1oY1mC&\u0011\u0001(\u000e\u0002\u0004\u0013:$\u0018!C2mkN$XM]%e!\tY$I\u0004\u0002=\u0001B\u0011Q(N\u0007\u0002})\u0011qhH\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005+\u0014A\u0002)sK\u0012,g-\u0003\u0002D\t\n11\u000b\u001e:j]\u001eT!!Q\u001b\u0002\u0011\t\u0014xn[3s\u0013\u0012\f!#Y4he\u0016<\u0017\r^3JI2,W*\u001a;feV\t\u0001\n\u0005\u0002J%6\t!J\u0003\u0002L\u0019\u0006!1m\u001c:f\u0015\tie*A\u0004nKR\u0014\u0018nY:\u000b\u0005=\u0003\u0016AB=b[6,'OC\u0001R\u0003\r\u0019w.\\\u0005\u0003'*\u0013Q!T3uKJ\f1#Y4he\u0016<\u0017\r^3JI2,W*\u001a;fe\u0002\n1\u0003^8uC2D\u0015M\u001c3mKJ$\u0006N]3bIN,\u0012a\u0016\t\u00031~k\u0011!\u0017\u0006\u00035n\u000ba!\u0019;p[&\u001c'B\u0001/^\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003=\u0016\nA!\u001e;jY&\u0011\u0001-\u0017\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\u0002)Q|G/\u00197IC:$G.\u001a:UQJ,\u0017\rZ:!\u00039\u0011X-];fgR\u001c\u0005.\u00198oK2,\u0012\u0001\u001a\t\u0003K\"l\u0011A\u001a\u0006\u0003Ov\tqA\\3uo>\u00148.\u0003\u0002jM\nq!+Z9vKN$8\t[1o]\u0016d\u0017a\u0004:fcV,7\u000f^\"iC:tW\r\u001c\u0011\u0002\t\u0005\u0004\u0018n\u001d\t\u0003[:l\u0011aG\u0005\u0003_n\u0011\u0011#\u00119j%\u0016\fX/Z:u\u0011\u0006tG\r\\3s\u0003\u0011!\u0018.\\3\u0011\u0005I\\X\"A:\u000b\u0005=\"(BA;w\u0003\u0019\u0019w.\\7p]*\u0011ad\u001e\u0006\u0003qf\fa!\u00199bG\",'\"\u0001>\u0002\u0007=\u0014x-\u0003\u0002}g\n!A+[7f\u0003\u0019a\u0014N\\5u}Q\tr0!\u0001\u0002\u0004\u0005\u0015\u0011qAA\u0005\u0003\u0017\ti!a\u0004\u0011\u00055\u0004\u0001\"\u0002\u001a\r\u0001\u0004\u0019\u0004\"B\u001d\r\u0001\u0004Q\u0004\"B#\r\u0001\u0004\u0019\u0004\"\u0002$\r\u0001\u0004A\u0005\"B+\r\u0001\u00049\u0006\"\u00022\r\u0001\u0004!\u0007\"B6\r\u0001\u0004a\u0007\"\u00029\r\u0001\u0004\t\u0018\u0001E:ikR$wn\u001e8D_6\u0004H.\u001a;f+\t\t)\u0002\u0005\u0003\u0002\u0018\u0005eQ\"A.\n\u0007\u0005m1L\u0001\bD_VtG\u000fR8x]2\u000bGo\u00195\u0002#MDW\u000f\u001e3po:\u001cu.\u001c9mKR,\u0007%\u0001\u0007sKF,Xm\u001d;M_\u000e\fG.\u0006\u0002\u0002$A\u0019Q.!\n\n\u0007\u0005\u001d2D\u0001\u0007SKF,Xm\u001d;M_\u000e\fG.A\u0007sKF,Xm\u001d;M_\u000e\fG\u000eI\u0001\bgR|\u0007\u000f]3e+\t\ty\u0003E\u00025\u0003cI1!a\r6\u0005\u001d\u0011un\u001c7fC:\f1b\u001d;paB,Gm\u0018\u0013fcR!\u0011\u0011HA !\r!\u00141H\u0005\u0004\u0003{)$\u0001B+oSRD\u0011\"!\u0011\u0013\u0003\u0003\u0005\r!a\f\u0002\u0007a$\u0013'\u0001\u0005ti>\u0004\b/\u001a3!Q\r\u0019\u0012q\t\t\u0004i\u0005%\u0013bAA&k\tAao\u001c7bi&dW-A\u0002sk:$\"!!\u000f\u0002\tA|G\u000e\u001c\u000b\u0005\u0003s\t)\u0006\u0003\u0004\u0002XU\u0001\raM\u0001\ni&lWm\\;u\u001bN\f\u0001cY8na2,G/Z*ikR$wn\u001e8\u0002\tM$x\u000e]\u0001\u0011S:LG/[1uKNCW\u000f\u001e3po:\fQ\"Y<bSR\u001c\u0006.\u001e;e_^t\u0007")
public class KafkaRequestHandler
implements Runnable,
Logging {
    private final int id;
    private final int brokerId;
    private final Meter aggregateIdleMeter;
    private final AtomicInteger totalHandlerThreads;
    private final RequestChannel requestChannel;
    private final ApiRequestHandler apis;
    private final Time time;
    private final CountDownLatch shutdownComplete;
    private final RequestLocal requestLocal;
    private volatile boolean stopped;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    public AtomicInteger totalHandlerThreads() {
        return this.totalHandlerThreads;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    private CountDownLatch shutdownComplete() {
        return this.shutdownComplete;
    }

    private RequestLocal requestLocal() {
        return this.requestLocal;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    @Override
    public void run() {
        try {
            ThreadCountersManager.LocalCounters.setThreadType((ThreadLocalCounters.ThreadGroupType)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
            while (!this.stopped()) {
                this.poll(300);
            }
        }
        finally {
            this.completeShutdown();
        }
    }

    public void poll(int timeoutMs) {
        long startSelectTime = this.time.nanoseconds();
        RequestChannel.BaseRequest req = this.requestChannel().receiveRequest(timeoutMs);
        long endTime = this.time.nanoseconds();
        long idleTime = endTime - startSelectTime;
        this.aggregateIdleMeter().mark(idleTime / (long)this.totalHandlerThreads().get());
        if (RequestChannel$ShutdownRequest$.MODULE$.equals(req)) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Kafka request handler ").append($this.id).append(" on broker ").append($this.brokerId).append(" received shut down command").toString());
            this.stop();
            return;
        }
        if (req instanceof RequestChannel.Request) {
            RequestChannel.Request request = (RequestChannel.Request)req;
            try {
                try {
                    request.requestDequeueTimeNanos_$eq(endTime);
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Kafka request handler ").append($this.id).append(" on broker ").append($this.brokerId).append(" handling request ").append(request).toString());
                    BoxedUnit cfr_ignored_0 = (BoxedUnit)ThreadCountersManager.wrapEngine(() -> {
                        this.apis.handle(request, this.requestLocal());
                        return BoxedUnit.UNIT;
                    });
                }
                catch (FatalExitError e) {
                    this.shutdownComplete().countDown();
                    throw Exit$.MODULE$.exit(e.statusCode(), Exit$.MODULE$.exit$default$2());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception when handling request", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
            }
            finally {
                request.releaseBuffer();
            }
            return;
        }
        if (req == null) {
            return;
        }
        throw new MatchError((Object)req);
    }

    private void completeShutdown() {
        this.requestLocal().close();
        this.shutdownComplete().countDown();
    }

    public void stop() {
        this.stopped_$eq(true);
    }

    public void initiateShutdown() {
        this.requestChannel().sendShutdownRequest();
    }

    public void awaitShutdown() {
        this.shutdownComplete().await();
    }

    public KafkaRequestHandler(int id, String clusterId, int brokerId, Meter aggregateIdleMeter, AtomicInteger totalHandlerThreads, RequestChannel requestChannel, ApiRequestHandler apis, Time time) {
        this.id = id;
        this.brokerId = brokerId;
        this.aggregateIdleMeter = aggregateIdleMeter;
        this.totalHandlerThreads = totalHandlerThreads;
        this.requestChannel = requestChannel;
        this.apis = apis;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(37).append("[Kafka Request Handler ").append(id).append(" on Broker ").append(brokerId).append("], ").toString());
        this.shutdownComplete = new CountDownLatch(1);
        this.requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
        this.stopped = false;
    }
}

