/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.EvictableKey;
import kafka.server.FetchSession;
import kafka.server.FetchSession$;
import kafka.server.IncrementalPartitionFetchMetadata;
import kafka.utils.Logging;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\u0010!\u0001\u0015B\u0001\u0002\u000f\u0001\u0003\u0006\u0004%I!\u000f\u0005\t{\u0001\u0011\t\u0011)A\u0005u!Aa\b\u0001BC\u0002\u0013%q\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003A\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u001dQ\u0005\u00011A\u0005\n}Bqa\u0013\u0001A\u0002\u0013%A\n\u0003\u0004S\u0001\u0001\u0006K\u0001\u0011\u0005\b/\u0002\u0011\r\u0011\"\u0003Y\u0011\u0019!\u0007\u0001)A\u00053\"9Q\r\u0001a\u0001\n\u0003I\u0004b\u00024\u0001\u0001\u0004%\ta\u001a\u0005\u0007S\u0002\u0001\u000b\u0015\u0002\u001e\t\u000f-\u0004!\u0019!C\u0005Y\"11\u000f\u0001Q\u0001\n5Dq\u0001\u001e\u0001C\u0002\u0013%A\u000e\u0003\u0004v\u0001\u0001\u0006I!\u001c\u0005\tm\u0002\u0011\r\u0011\"\u0001!o\"9\u0011q\u0001\u0001!\u0002\u0013A\b\"CA\u0005\u0001\t\u0007I\u0011\u0001\u0011x\u0011\u001d\tY\u0001\u0001Q\u0001\naDq!!\u0004\u0001\t\u0003\ty\u0001\u0003\u0004\u0002\u001c\u0001!\t!\u000f\u0005\u0007\u0003;\u0001A\u0011A \t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"!9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0002bBA*\u0001\u0011\u0005\u0011Q\u000b\u0005\b\u0003?\u0002A\u0011AA1\u0011\u001d\ty\u0006\u0001C\u0001\u0003KBq!a\u001b\u0001\t\u0003\tiGA\tGKR\u001c\u0007nU3tg&|gnQ1dQ\u0016T!!\t\u0012\u0002\rM,'O^3s\u0015\u0005\u0019\u0013!B6bM.\f7\u0001A\n\u0005\u0001\u0019b#\u0007\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003F\u0001\u0004B]f\u0014VM\u001a\t\u0003[Aj\u0011A\f\u0006\u0003_\t\nQ!\u001e;jYNL!!\r\u0018\u0003\u000f1{wmZ5oOB\u00111GN\u0007\u0002i)\u0011QGI\u0001\b[\u0016$(/[2t\u0013\t9DGA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkB\f!\"\\1y\u000b:$(/[3t+\u0005Q\u0004CA\u0014<\u0013\ta\u0004FA\u0002J]R\f1\"\\1y\u000b:$(/[3tA\u0005QQM^5di&|g.T:\u0016\u0003\u0001\u0003\"aJ!\n\u0005\tC#\u0001\u0002'p]\u001e\f1\"\u001a<jGRLwN\\'tA\u00051A(\u001b8jiz\"2A\u0012%J!\t9\u0005!D\u0001!\u0011\u0015AT\u00011\u0001;\u0011\u0015qT\u00011\u0001A\u00035qW/\u001c)beRLG/[8og\u0006\tb.^7QCJ$\u0018\u000e^5p]N|F%Z9\u0015\u00055\u0003\u0006CA\u0014O\u0013\ty\u0005F\u0001\u0003V]&$\bbB)\b\u0003\u0003\u0005\r\u0001Q\u0001\u0004q\u0012\n\u0014A\u00048v[B\u000b'\u000f^5uS>t7\u000f\t\u0015\u0003\u0011Q\u0003\"aJ+\n\u0005YC#\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u0011M,7o]5p]N,\u0012!\u0017\t\u00055~S\u0014-D\u0001\\\u0015\taV,\u0001\u0003vi&d'\"\u00010\u0002\t)\fg/Y\u0005\u0003An\u0013Q\u0002T5oW\u0016$\u0007*Y:i\u001b\u0006\u0004\bCA$c\u0013\t\u0019\u0007E\u0001\u0007GKR\u001c\u0007nU3tg&|g.A\u0005tKN\u001c\u0018n\u001c8tA\u0005a1/Z:tS>t7oU5{K\u0006\u00012/Z:tS>t7oU5{K~#S-\u001d\u000b\u0003\u001b\"Dq!\u0015\u0007\u0002\u0002\u0003\u0007!(A\u0007tKN\u001c\u0018n\u001c8t'&TX\r\t\u0015\u0003\u001bQ\u000ba\"\u001a<jGR\f'\r\\3Cs\u0006cG.F\u0001n!\u0011Qf\u000e]1\n\u0005=\\&a\u0002+sK\u0016l\u0015\r\u001d\t\u0003\u000fFL!A\u001d\u0011\u0003\u0019\u00153\u0018n\u0019;bE2,7*Z=\u0002\u001f\u00154\u0018n\u0019;bE2,')_!mY\u0002\nQ#\u001a<jGR\f'\r\\3CsB\u0013\u0018N^5mK\u001e,G-\u0001\ffm&\u001cG/\u00192mK\nK\bK]5wS2,w-\u001a3!\u00039)g/[2uS>t7/T3uKJ,\u0012\u0001\u001f\t\u0004s\u0006\rQ\"\u0001>\u000b\u0005md\u0018\u0001B2pe\u0016T!!N?\u000b\u0005y|\u0018AB=b[6,'O\u0003\u0002\u0002\u0002\u0005\u00191m\\7\n\u0007\u0005\u0015!PA\u0003NKR,'/A\bfm&\u001cG/[8og6+G/\u001a:!\u0003m\t7\r^5wKN+7o]5p]\u00163\u0018n\u0019;j_:\u001cX*\u001a;fe\u0006a\u0012m\u0019;jm\u0016\u001cVm]:j_:,e/[2uS>t7/T3uKJ\u0004\u0013aA4fiR!\u0011\u0011CA\f!\u00119\u00131C1\n\u0007\u0005U\u0001F\u0001\u0004PaRLwN\u001c\u0005\u0007\u000331\u0002\u0019\u0001\u001e\u0002\u0013M,7o]5p]&#\u0017\u0001B:ju\u0016\fq\u0002^8uC2\u0004\u0016M\u001d;ji&|gn]\u0001\r]\u0016<8+Z:tS>t\u0017\n\u001a\u000b\u0002u\u0005\u0011R.Y=cK\u000e\u0013X-\u0019;f'\u0016\u001c8/[8o)-Q\u0014qEA\u0016\u0003k\t9$a\u000f\t\r\u0005%\"\u00041\u0001A\u0003\rqwn\u001e\u0005\b\u0003[Q\u0002\u0019AA\u0018\u0003)\u0001(/\u001b<jY\u0016<W\r\u001a\t\u0004O\u0005E\u0012bAA\u001aQ\t9!i\\8mK\u0006t\u0007BBA\u000e5\u0001\u0007!\bC\u0004\u0002:i\u0001\r!a\f\u0002\u0019U\u001cXm\u001d+pa&\u001c\u0017\nZ:\t\u000f\u0005u\"\u00041\u0001\u0002@\u0005\u00012M]3bi\u0016\u0004\u0016M\u001d;ji&|gn\u001d\t\u0006O\u0005\u0005\u0013QI\u0005\u0004\u0003\u0007B#!\u0003$v]\u000e$\u0018n\u001c81!\u0011\t9%!\u0014\u000f\u0007\u001d\u000bI%C\u0002\u0002L\u0001\nABR3uG\"\u001cVm]:j_:LA!a\u0014\u0002R\tI1)Q\"I\u000b~k\u0015\t\u0015\u0006\u0004\u0003\u0017\u0002\u0013\u0001\u0003;ss\u00163\u0018n\u0019;\u0015\u0011\u0005=\u0012qKA-\u0003;Bq!!\f\u001c\u0001\u0004\ty\u0003\u0003\u0004\u0002\\m\u0001\r\u0001]\u0001\u0004W\u0016L\bBBA\u00157\u0001\u0007\u0001)\u0001\u0004sK6|g/\u001a\u000b\u0005\u0003#\t\u0019\u0007\u0003\u0004\u0002\u001aq\u0001\rA\u000f\u000b\u0005\u0003#\t9\u0007\u0003\u0004\u0002ju\u0001\r!Y\u0001\bg\u0016\u001c8/[8o\u0003\u0015!x.^2i)\u0015i\u0015qNA9\u0011\u0019\tIG\ba\u0001C\"1\u0011\u0011\u0006\u0010A\u0002\u0001\u0003")
public class FetchSessionCache
implements KafkaMetricsGroup {
    private final int maxEntries;
    private final long evictionMs;
    private volatile long numPartitions;
    private final LinkedHashMap<Object, FetchSession> sessions;
    private volatile int sessionsSize;
    private final TreeMap<EvictableKey, FetchSession> evictableByAll;
    private final TreeMap<EvictableKey, FetchSession> evictableByPrivileged;
    private final Meter evictionsMeter;
    private final Meter activeSessionEvictionsMeter;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public <T> Gauge<T> newGauge(MetricName metricName, Gauge<T> metric) {
        return KafkaMetricsGroup.newGauge$(this, metricName, metric);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public void removeMetric(MetricName metricName) {
        KafkaMetricsGroup.removeMetric$(this, metricName);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private int maxEntries() {
        return this.maxEntries;
    }

    private long evictionMs() {
        return this.evictionMs;
    }

    private long numPartitions() {
        return this.numPartitions;
    }

    private void numPartitions_$eq(long x$1) {
        this.numPartitions = x$1;
    }

    private LinkedHashMap<Object, FetchSession> sessions() {
        return this.sessions;
    }

    public int sessionsSize() {
        return this.sessionsSize;
    }

    public void sessionsSize_$eq(int x$1) {
        this.sessionsSize = x$1;
    }

    private TreeMap<EvictableKey, FetchSession> evictableByAll() {
        return this.evictableByAll;
    }

    private TreeMap<EvictableKey, FetchSession> evictableByPrivileged() {
        return this.evictableByPrivileged;
    }

    public Meter evictionsMeter() {
        return this.evictionsMeter;
    }

    public Meter activeSessionEvictionsMeter() {
        return this.activeSessionEvictionsMeter;
    }

    public synchronized Option<FetchSession> get(int sessionId) {
        return Option$.MODULE$.apply((Object)this.sessions().get(BoxesRunTime.boxToInteger((int)sessionId)));
    }

    public int size() {
        return this.sessionsSize();
    }

    public long totalPartitions() {
        return this.numPartitions();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized int newSessionId() {
        void var1_1;
        int id;
        do {
            id = ThreadLocalRandom.current().nextInt(1, Integer.MAX_VALUE);
        } while (this.sessions().containsKey(BoxesRunTime.boxToInteger((int)id)) || id == 0);
        return (int)var1_1;
    }

    public synchronized int maybeCreateSession(long now, boolean privileged, int size, boolean usesTopicIds, Function0<ImplicitLinkedHashCollection<IncrementalPartitionFetchMetadata>> createPartitions) {
        if (this.sessionsSize() < this.maxEntries() || this.tryEvict(privileged, new EvictableKey(privileged, size, 0), now)) {
            ImplicitLinkedHashCollection partitionMap = (ImplicitLinkedHashCollection)createPartitions.apply();
            FetchSession session = new FetchSession(this.newSessionId(), privileged, (ImplicitLinkedHashCollection<IncrementalPartitionFetchMetadata>)partitionMap, usesTopicIds, now, now, FetchMetadata.nextEpoch((int)0));
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Created fetch session ").append(session.toString()).toString());
            this.touch(session, now);
            return session.id();
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("No fetch session created for privileged=").append(privileged).append(", size=").append(size).append(".").toString());
        return 0;
    }

    public synchronized boolean tryEvict(boolean privileged, EvictableKey key, long now) {
        Iterator<Map.Entry<Object, FetchSession>> sessionIterator = this.sessions().entrySet().iterator();
        if (!sessionIterator.hasNext()) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "There are no cache entries to evict.");
            return false;
        }
        FetchSession lastUsedSession = sessionIterator.next().getValue();
        if (now - lastUsedSession.lastUsedMs() > this.evictionMs()) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Evicting stale FetchSession ").append(lastUsedSession.id()).append(".").toString());
            this.remove(lastUsedSession);
            this.evictionsMeter().mark();
            return true;
        }
        if (privileged) {
            return this.evictEntry$1(key, this.evictableByPrivileged());
        }
        return this.evictEntry$1(key, this.evictableByAll());
    }

    public synchronized Option<FetchSession> remove(int sessionId) {
        Option<FetchSession> option;
        Option<FetchSession> option2 = this.get(sessionId);
        if (None$.MODULE$.equals(option2)) {
            option = None$.MODULE$;
        } else if (option2 instanceof Some) {
            FetchSession session = (FetchSession)((Some)option2).value();
            option = this.remove(session);
        } else {
            throw new MatchError(option2);
        }
        return option;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized Option<FetchSession> remove(FetchSession session) {
        void var2_3;
        synchronized (session) {
            EvictableKey evictableKey = session.evictableKey();
            if (!session.privileged()) {
                this.evictableByAll().remove(evictableKey);
            }
            this.evictableByPrivileged().remove(evictableKey);
            Option result = Option$.MODULE$.apply(this.sessions().remove(BoxesRunTime.boxToInteger((int)session.id())));
            if (result.isDefined()) {
                session.close();
                this.numPartitions_$eq(this.numPartitions() - (long)session.cachedSize());
            }
        }
        this.sessionsSize_$eq(this.sessions().size());
        return var2_3;
    }

    public synchronized void touch(FetchSession session, long now) {
        synchronized (session) {
            this.sessions().remove(BoxesRunTime.boxToInteger((int)session.id()));
            session.lastUsedMs_$eq(now);
            this.sessions().put(BoxesRunTime.boxToInteger((int)session.id()), session);
            int oldSize = session.cachedSize();
            if (oldSize != -1) {
                EvictableKey oldEvictableKey = session.evictableKey();
                this.evictableByPrivileged().remove(oldEvictableKey);
                this.evictableByAll().remove(oldEvictableKey);
                this.numPartitions_$eq(this.numPartitions() - (long)oldSize);
            }
            session.cachedSize_$eq(session.size());
            EvictableKey newEvictableKey = session.evictableKey();
            if (!session.privileged() || now - session.creationMs() > this.evictionMs()) {
                this.evictableByPrivileged().put(newEvictableKey, session);
            }
            if (!session.privileged() && now - session.creationMs() > this.evictionMs()) {
                this.evictableByAll().put(newEvictableKey, session);
            }
            this.numPartitions_$eq(this.numPartitions() + (long)session.cachedSize());
        }
        this.sessionsSize_$eq(this.sessions().size());
    }

    public final /* synthetic */ int kafka$server$FetchSessionCache$$$anonfun$new$1() {
        return this.size();
    }

    public final /* synthetic */ long kafka$server$FetchSessionCache$$$anonfun$new$2() {
        return this.totalPartitions();
    }

    private final boolean evictEntry$1(EvictableKey key, TreeMap map) {
        Map.Entry evictableEntry = map.firstEntry();
        if (evictableEntry == null) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No evictable entries found.");
            return false;
        }
        if (key.compareTo((EvictableKey)evictableEntry.getKey()) < 0) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Can't evict ").append(evictableEntry.getKey()).append(" with ").append(key.toString()).toString());
            return false;
        }
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Evicting ").append(evictableEntry.getKey()).append(" with ").append(key.toString()).append(".").toString());
        this.remove((FetchSession)evictableEntry.getValue());
        this.evictionsMeter().mark();
        this.activeSessionEvictionsMeter().mark();
        return true;
    }

    public FetchSessionCache(int maxEntries, long evictionMs) {
        this.maxEntries = maxEntries;
        this.evictionMs = evictionMs;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.numPartitions = 0L;
        this.sessions = new LinkedHashMap();
        this.sessionsSize = 0;
        this.evictableByAll = new TreeMap();
        this.evictableByPrivileged = new TreeMap();
        this.removeMetric(FetchSession$.MODULE$.NUM_INCREMENTAL_FETCH_SESSIONS(), this.removeMetric$default$2());
        this.newGauge(FetchSession$.MODULE$.NUM_INCREMENTAL_FETCH_SESSIONS(), new Gauge<Object>(this){
            private final /* synthetic */ FetchSessionCache $outer;

            public final int value() {
                return this.$outer.kafka$server$FetchSessionCache$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.removeMetric(FetchSession$.MODULE$.NUM_INCREMENTAL_FETCH_PARTITIONS_CACHED(), this.removeMetric$default$2());
        this.newGauge(FetchSession$.MODULE$.NUM_INCREMENTAL_FETCH_PARTITIONS_CACHED(), new Gauge<Object>(this){
            private final /* synthetic */ FetchSessionCache $outer;

            public final long value() {
                return this.$outer.kafka$server$FetchSessionCache$$$anonfun$new$2();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.removeMetric(FetchSession$.MODULE$.INCREMENTAL_FETCH_SESSIONS_EVICTIONS_PER_SEC(), this.removeMetric$default$2());
        this.evictionsMeter = this.newMeter(FetchSession$.MODULE$.INCREMENTAL_FETCH_SESSIONS_EVICTIONS_PER_SEC(), FetchSession$.MODULE$.EVICTIONS(), TimeUnit.SECONDS, (Map<String, String>)Predef$.MODULE$.Map().empty());
        this.removeMetric(FetchSession$.MODULE$.INCREMENTAL_FETCH_SESSIONS_ACTIVE_SESSION_EVICTIONS_PER_SEC(), this.removeMetric$default$2());
        this.activeSessionEvictionsMeter = this.newMeter(FetchSession$.MODULE$.INCREMENTAL_FETCH_SESSIONS_ACTIVE_SESSION_EVICTIONS_PER_SEC(), FetchSession$.MODULE$.EVICTIONS(), TimeUnit.SECONDS, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }
}

