/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.controller.KafkaController;
import kafka.server.BrokerReconfigurable;
import kafka.server.DynamicZkControllerConfig$;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.utils.Logging;
import org.apache.kafka.common.config.ConfigException;
import scala.Function0;
import scala.Function1;
import scala.collection.Iterable$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001i;Q\u0001D\u0007\t\u0002I1Q\u0001F\u0007\t\u0002UAQ\u0001H\u0001\u0005\u0002uAqAH\u0001C\u0002\u0013\u0005q\u0004\u0003\u00042\u0003\u0001\u0006I\u0001\t\u0004\u0005)5\u0001!\u0007\u0003\u0005=\u000b\t\u0005\t\u0015!\u0003>\u0011!\u0011UA!A!\u0002\u0013\u0019\u0005\"\u0002\u000f\u0006\t\u00031\u0005\"\u0002&\u0006\t\u0003y\u0002\"B&\u0006\t\u0003a\u0005\"B+\u0006\t\u00031\u0016!\u0007#z]\u0006l\u0017n\u0019.l\u0007>tGO]8mY\u0016\u00148i\u001c8gS\u001eT!AD\b\u0002\rM,'O^3s\u0015\u0005\u0001\u0012!B6bM.\f7\u0001\u0001\t\u0003'\u0005i\u0011!\u0004\u0002\u001a\tft\u0017-\\5d5.\u001cuN\u001c;s_2dWM]\"p]\u001aLwm\u0005\u0002\u0002-A\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\n\u0002+I+7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hgV\t\u0001\u0005E\u0002\"I\u0019j\u0011A\t\u0006\u0003Ga\t!bY8mY\u0016\u001cG/[8o\u0013\t)#EA\u0002TKR\u0004\"a\n\u0018\u000f\u0005!b\u0003CA\u0015\u0019\u001b\u0005Q#BA\u0016\u0012\u0003\u0019a$o\\8u}%\u0011Q\u0006G\u0001\u0007!J,G-\u001a4\n\u0005=\u0002$AB*ue&twM\u0003\u0002.1\u00051\"+Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001c\be\u0005\u0003\u0006-M2\u0004CA\n5\u0013\t)TB\u0001\u000bCe>\\WM\u001d*fG>tg-[4ve\u0006\u0014G.\u001a\t\u0003oij\u0011\u0001\u000f\u0006\u0003s=\tQ!\u001e;jYNL!a\u000f\u001d\u0003\u000f1{wmZ5oO\u0006Q1m\u001c8ue>dG.\u001a:\u0011\u0005y\u0002U\"A \u000b\u0005qz\u0011BA!@\u0005=Y\u0015MZ6b\u0007>tGO]8mY\u0016\u0014\u0018!D7fi\u0006$\u0017\r^1DC\u000eDW\r\u0005\u0002\u0014\t&\u0011Q)\u0004\u0002\u000e\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0015\u0007\u001dC\u0015\n\u0005\u0002\u0014\u000b!)A\b\u0003a\u0001{!)!\t\u0003a\u0001\u0007\u0006)\"/Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001c\u0018a\u0006<bY&$\u0017\r^3SK\u000e|gNZ5hkJ\fG/[8o)\ti\u0005\u000b\u0005\u0002\u0018\u001d&\u0011q\n\u0007\u0002\u0005+:LG\u000fC\u0003R\u0015\u0001\u0007!+A\u0005oK^\u001cuN\u001c4jOB\u00111cU\u0005\u0003)6\u00111bS1gW\u0006\u001cuN\u001c4jO\u0006Y!/Z2p]\u001aLw-\u001e:f)\riu+\u0017\u0005\u00061.\u0001\rAU\u0001\n_2$7i\u001c8gS\u001eDQ!U\u0006A\u0002I\u0003")
public class DynamicZkControllerConfig
implements BrokerReconfigurable,
Logging {
    private final KafkaController controller;
    private final MetadataCache metadataCache;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Set<String> ReconfigurableConfigs() {
        return DynamicZkControllerConfig$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return DynamicZkControllerConfig$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        scala.collection.immutable.Set aliveBrokerIds = ((TraversableOnce)this.metadataCache.getAliveBrokers().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.id()), Iterable$.MODULE$.canBuildFrom())).toSet();
        scala.collection.immutable.Set<Object> eligibleControllers = newConfig.confluentConfig().eligibleControllers();
        if (eligibleControllers.nonEmpty() && ((SetLike)aliveBrokerIds.intersect(eligibleControllers)).isEmpty()) {
            throw new ConfigException(new StringBuilder(121).append("Config value for `").append("confluent.eligible.controllers").append("` must ").append("contain at least one live broker, but all brokers in ").append(eligibleControllers).append(" are offline.").toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.controller.updateEligibleControllers((Set<Object>)newConfig.confluentConfig().eligibleControllers());
    }

    public DynamicZkControllerConfig(KafkaController controller, MetadataCache metadataCache) {
        this.controller = controller;
        this.metadataCache = metadataCache;
        Logging.$init$(this);
    }
}

