/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.coordinator.quota.QuotaCoordinator;
import kafka.server.AbstractQuotaChannelManager;
import kafka.server.DynamicQuotaChannelManager$;
import kafka.server.DynamicQuotaPublishingRequestThread;
import kafka.server.DynamicQuotaReportingRequestThread;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.utils.KafkaScheduler;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005r!B\n\u0015\u0011\u0003Ib!B\u000e\u0015\u0011\u0003a\u0002\"B\u0012\u0002\t\u0003!\u0003\"B\u0013\u0002\t\u00031c\u0001B\u000e\u0015\u0001YC\u0001b\u000b\u0003\u0003\u0002\u0003\u0006I\u0001\f\u0005\ta\u0011\u0011\t\u0011)A\u0005c!Aa\b\u0002B\u0001B\u0003%q\b\u0003\u0005D\t\t\u0005\t\u0015!\u0003E\u0011!YEA!A!\u0002\u0013a\u0005\u0002\u0003*\u0005\u0005\u0003\u0005\u000b\u0011B*\t\u000b\r\"A\u0011A,\t\u000f}#!\u0019!C!A\"1A\r\u0002Q\u0001\n\u0005Dq!\u001a\u0003C\u0002\u0013\u0005c\r\u0003\u0004k\t\u0001\u0006Ia\u001a\u0005\u0006W\u0012!\t\u0005\u001c\u0005\u0006s\u0012!\tE\u001f\u0005\u0006w\u0012!I\u0001`\u0001\u001b\tft\u0017-\\5d#V|G/Y\"iC:tW\r\\'b]\u0006<WM\u001d\u0006\u0003+Y\taa]3sm\u0016\u0014(\"A\f\u0002\u000b-\fgm[1\u0004\u0001A\u0011!$A\u0007\u0002)\tQB)\u001f8b[&\u001c\u0017+^8uC\u000eC\u0017M\u001c8fY6\u000bg.Y4feN\u0011\u0011!\b\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005I\u0012!B1qa2LHcB\u0014+_u\u0012%*\u0015\t\u00035!J!!\u000b\u000b\u00037\u0005\u00137\u000f\u001e:bGR\fVo\u001c;b\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u0011\u0015Y3\u00011\u0001-\u0003\u0019\u0019wN\u001c4jOB\u0011!$L\u0005\u0003]Q\u00111bS1gW\u0006\u001cuN\u001c4jO\")\u0001g\u0001a\u0001c\u00059Q.\u001a;sS\u000e\u001c\bC\u0001\u001a<\u001b\u0005\u0019$B\u0001\u00195\u0015\t)d'\u0001\u0004d_6lwN\u001c\u0006\u0003/]R!\u0001O\u001d\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0014aA8sO&\u0011Ah\r\u0002\b\u001b\u0016$(/[2t\u0011\u0015q4\u00011\u0001@\u00035iW\r^1eCR\f7)Y2iKB\u0011!\u0004Q\u0005\u0003\u0003R\u0011Q\"T3uC\u0012\fG/Y\"bG\",\u0007\"B\"\u0004\u0001\u0004!\u0015\u0001\u0002;j[\u0016\u0004\"!\u0012%\u000e\u0003\u0019S!a\u0012\u001b\u0002\u000bU$\u0018\u000e\\:\n\u0005%3%\u0001\u0002+j[\u0016DQaS\u0002A\u00021\u000bab[1gW\u0006\u001c6\r[3ek2,'\u000f\u0005\u0002N\u001f6\taJ\u0003\u0002H-%\u0011\u0001K\u0014\u0002\u000f\u0017\u000647.Y*dQ\u0016$W\u000f\\3s\u0011\u0015\u00116\u00011\u0001T\u0003)awnZ\"p]R,\u0007\u0010\u001e\t\u0003\u000bRK!!\u0016$\u0003\u00151{wmQ8oi\u0016DHoE\u0002\u0005;\u001d\"r\u0001W-[7rkf\f\u0005\u0002\u001b\t!)1f\u0003a\u0001Y!)\u0001g\u0003a\u0001c!)ah\u0003a\u0001\u007f!)1i\u0003a\u0001\t\")1j\u0003a\u0001\u0019\")!k\u0003a\u0001'\u00061r-\u001a;SKB|'\u000f\u001e*fcV,7\u000f\u001e+ie\u0016\fG-F\u0001b!\tQ\"-\u0003\u0002d)\t\u0011C)\u001f8b[&\u001c\u0017+^8uCJ+\u0007o\u001c:uS:<'+Z9vKN$H\u000b\u001b:fC\u0012\fqcZ3u%\u0016\u0004xN\u001d;SKF,Xm\u001d;UQJ,\u0017\r\u001a\u0011\u0002/\u001d,G\u000fU;cY&\u001c\bNU3rk\u0016\u001cH\u000f\u00165sK\u0006$W#A4\u0011\u0005iA\u0017BA5\u0015\u0005\r\"\u0015P\\1nS\u000e\fVo\u001c;b!V\u0014G.[:iS:<'+Z9vKN$H\u000b\u001b:fC\u0012\f\u0001dZ3u!V\u0014G.[:i%\u0016\fX/Z:u)\"\u0014X-\u00193!\u0003\u0015\u0019H/\u0019:u)\ti\u0007\u000f\u0005\u0002\u001f]&\u0011qn\b\u0002\u0005+:LG\u000fC\u0003r!\u0001\u0007!/A\u0006d_>\u0014H-\u001b8bi>\u0014\bCA:x\u001b\u0005!(BA;w\u0003\u0015\tXo\u001c;b\u0015\t\th#\u0003\u0002yi\n\u0001\u0012+^8uC\u000e{wN\u001d3j]\u0006$xN]\u0001\tg\",H\u000fZ8x]R\tQ.A\u000bhK:,'/\u0019;f\u001d\u0016$xo\u001c:l\u00072LWM\u001c;\u0015\u0007u\f9\u0001E\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u00031\u0014aB2mS\u0016tGo]\u0005\u0004\u0003\u000by(!\u0004(fi^|'o[\"mS\u0016tG\u000fC\u0004\u0002\nI\u0001\r!a\u0003\u0002\u00159\fW.\u001a)sK\u001aL\u0007\u0010\u0005\u0003\u0002\u000e\u0005ma\u0002BA\b\u0003/\u00012!!\u0005 \u001b\t\t\u0019BC\u0002\u0002\u0016a\ta\u0001\u0010:p_Rt\u0014bAA\r?\u00051\u0001K]3eK\u001aLA!!\b\u0002 \t11\u000b\u001e:j]\u001eT1!!\u0007 \u0001")
public class DynamicQuotaChannelManager
implements AbstractQuotaChannelManager {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final Time time;
    private final LogContext logContext;
    private final DynamicQuotaReportingRequestThread getReportRequestThread;
    private final DynamicQuotaPublishingRequestThread getPublishRequestThread;

    public static AbstractQuotaChannelManager apply(KafkaConfig kafkaConfig, Metrics metrics, MetadataCache metadataCache, Time time, KafkaScheduler kafkaScheduler, LogContext logContext) {
        return DynamicQuotaChannelManager$.MODULE$.apply(kafkaConfig, metrics, metadataCache, time, kafkaScheduler, logContext);
    }

    @Override
    public DynamicQuotaReportingRequestThread getReportRequestThread() {
        return this.getReportRequestThread;
    }

    @Override
    public DynamicQuotaPublishingRequestThread getPublishRequestThread() {
        return this.getPublishRequestThread;
    }

    @Override
    public void start(QuotaCoordinator coordinator) {
        this.getReportRequestThread().start(coordinator);
        this.getPublishRequestThread().start(coordinator);
    }

    @Override
    public void shutdown() {
        this.getPublishRequestThread().shutdown();
        this.getReportRequestThread().shutdown();
    }

    private NetworkClient generateNetworkClient(String namePrefix) {
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)this.config.interBrokerSecurityProtocol(), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)this.config, (ListenerName)this.config.interBrokerListenerName(), (String)this.config.saslMechanismInterBrokerProtocol(), (Time)this.time, (boolean)this.config.saslInterBrokerHandshakeRequestEnable(), (LogContext)this.logContext);
        if (channelBuilder instanceof Reconfigurable) {
            this.config.addReconfigurable((Reconfigurable)channelBuilder);
        }
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(this.config.connectionsMaxIdleMs()), this.metrics, this.time, new StringBuilder(22).append("dynamic-quota-").append(namePrefix).append("-channel").toString(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"BrokerId"), (Object)Integer.toString(this.config.brokerId()))}))).asJava(), false, channelBuilder, this.logContext);
        return new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), new StringBuilder(29).append("broker-").append(this.config.brokerId()).append("-dynamic-quota-").append(namePrefix).append("-sender").toString(), 1, 50L, 50L, -1, Predef$.MODULE$.Integer2int(this.config.socketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(this.config.requestTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, false, new ApiVersions(), this.logContext);
    }

    public DynamicQuotaChannelManager(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, Time time, KafkaScheduler kafkaScheduler, LogContext logContext) {
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        this.logContext = logContext;
        this.getReportRequestThread = new DynamicQuotaReportingRequestThread(config, metrics, metadataCache, this.generateNetworkClient("reporting"), kafkaScheduler, time);
        this.getPublishRequestThread = new DynamicQuotaPublishingRequestThread(config, metrics, metadataCache, this.generateNetworkClient("publishing"), kafkaScheduler, time);
    }
}

